# Licensed to Elasticsearch B.V under one or more agreements.
# Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
# See the LICENSE file in the project root for more information

require 'spec_helper'

describe 'client.cluster#reroute' do

  let(:expected_args) do
    [
        'POST',
        '_cluster/reroute',
        {},
        {},
        nil
    ]
  end

  it 'performs the request' do
    expect(client_double.cluster.reroute).to eq({})
  end

  context 'when a body is specified' do

    let(:expected_args) do
      [
          'POST',
          '_cluster/reroute',
          {},
          { commands: [ move: { index: 'myindex', shard: 0 }] },
          nil
      ]
    end

    it 'performs the request' do
      expect(client_double.cluster.reroute(body: { commands: [ move: { index: 'myindex', shard: 0 }] })).to eq({})
    end
  end
end
