// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

#![cfg(unix)]

use gdk4_sys::*;
use std::env;
use std::error::Error;
use std::ffi::OsString;
use std::mem::{align_of, size_of};
use std::path::Path;
use std::process::{Command, Stdio};
use std::str;
use tempfile::Builder;

static PACKAGES: &[&str] = &["gtk4"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Self, Box<dyn Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For _Generic
        args.push("-std=c11".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Self { args })
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<dyn Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {cmd:?} failed, {status}").into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<dyn Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{name} {err}").into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<dyn Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let pkg_config = env::var_os("PKG_CONFIG").unwrap_or_else(|| OsString::from("pkg-config"));
    let mut cmd = Command::new(pkg_config);
    cmd.arg("--cflags");
    cmd.args(packages);
    cmd.stderr(Stdio::inherit());
    let out = cmd.output()?;
    if !out.status.success() {
        let (status, stdout) = (out.status, String::from_utf8_lossy(&out.stdout));
        return Err(format!("command {cmd:?} failed, {status:?}\nstdout: {stdout}").into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}

#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn summary(&self) -> String {
        format!("{} passed; {} failed", self.passed, self.failed)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let mut c_constants: Vec<(String, String)> = Vec::new();

    for l in get_c_output("constant").unwrap().lines() {
        let (name, value) = l.split_once(';').expect("Missing ';' separator");
        c_constants.push((name.to_owned(), value.to_owned()));
    }

    let mut results = Results::default();

    for ((rust_name, rust_value), (c_name, c_value)) in
        RUST_CONSTANTS.iter().zip(c_constants.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {rust_name:?}\nC:    {c_name:?}");
            continue;
        }

        if rust_value != c_value {
            results.record_failed();
            eprintln!(
                "Constant value mismatch for {rust_name}\nRust: {rust_value:?}\nC:    {c_value:?}",
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let mut c_layouts = Vec::new();

    for l in get_c_output("layout").unwrap().lines() {
        let (name, value) = l.split_once(';').expect("Missing first ';' separator");
        let (size, alignment) = value.split_once(';').expect("Missing second ';' separator");
        let size = size.parse().expect("Failed to parse size");
        let alignment = alignment.parse().expect("Failed to parse alignment");
        c_layouts.push((name.to_owned(), Layout { size, alignment }));
    }

    let mut results = Results::default();

    for ((rust_name, rust_layout), (c_name, c_layout)) in RUST_LAYOUTS.iter().zip(c_layouts.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {rust_name:?}\nC:    {c_name:?}");
            continue;
        }

        if rust_layout != c_layout {
            results.record_failed();
            eprintln!("Layout mismatch for {rust_name}\nRust: {rust_layout:?}\nC:    {c_layout:?}",);
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

fn get_c_output(name: &str) -> Result<String, Box<dyn Error>> {
    let tmpdir = Builder::new().prefix("abi").tempdir()?;
    let exe = tmpdir.path().join(name);
    let c_file = Path::new("tests").join(name).with_extension("c");

    let cc = Compiler::new().expect("configured compiler");
    cc.compile(&c_file, &exe)?;

    let mut cmd = Command::new(exe);
    cmd.stderr(Stdio::inherit());
    let out = cmd.output()?;
    if !out.status.success() {
        let (status, stdout) = (out.status, String::from_utf8_lossy(&out.stdout));
        return Err(format!("command {cmd:?} failed, {status:?}\nstdout: {stdout}").into());
    }

    Ok(String::from_utf8(out.stdout)?)
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    (
        "GdkAnchorHints",
        Layout {
            size: size_of::<GdkAnchorHints>(),
            alignment: align_of::<GdkAnchorHints>(),
        },
    ),
    (
        "GdkAxisFlags",
        Layout {
            size: size_of::<GdkAxisFlags>(),
            alignment: align_of::<GdkAxisFlags>(),
        },
    ),
    (
        "GdkAxisUse",
        Layout {
            size: size_of::<GdkAxisUse>(),
            alignment: align_of::<GdkAxisUse>(),
        },
    ),
    (
        "GdkCicpRange",
        Layout {
            size: size_of::<GdkCicpRange>(),
            alignment: align_of::<GdkCicpRange>(),
        },
    ),
    (
        "GdkContentProvider",
        Layout {
            size: size_of::<GdkContentProvider>(),
            alignment: align_of::<GdkContentProvider>(),
        },
    ),
    (
        "GdkContentProviderClass",
        Layout {
            size: size_of::<GdkContentProviderClass>(),
            alignment: align_of::<GdkContentProviderClass>(),
        },
    ),
    (
        "GdkCrossingMode",
        Layout {
            size: size_of::<GdkCrossingMode>(),
            alignment: align_of::<GdkCrossingMode>(),
        },
    ),
    (
        "GdkDevicePadFeature",
        Layout {
            size: size_of::<GdkDevicePadFeature>(),
            alignment: align_of::<GdkDevicePadFeature>(),
        },
    ),
    (
        "GdkDeviceToolType",
        Layout {
            size: size_of::<GdkDeviceToolType>(),
            alignment: align_of::<GdkDeviceToolType>(),
        },
    ),
    (
        "GdkDmabufError",
        Layout {
            size: size_of::<GdkDmabufError>(),
            alignment: align_of::<GdkDmabufError>(),
        },
    ),
    (
        "GdkDragAction",
        Layout {
            size: size_of::<GdkDragAction>(),
            alignment: align_of::<GdkDragAction>(),
        },
    ),
    (
        "GdkDragCancelReason",
        Layout {
            size: size_of::<GdkDragCancelReason>(),
            alignment: align_of::<GdkDragCancelReason>(),
        },
    ),
    (
        "GdkEventType",
        Layout {
            size: size_of::<GdkEventType>(),
            alignment: align_of::<GdkEventType>(),
        },
    ),
    (
        "GdkFrameClockPhase",
        Layout {
            size: size_of::<GdkFrameClockPhase>(),
            alignment: align_of::<GdkFrameClockPhase>(),
        },
    ),
    (
        "GdkFullscreenMode",
        Layout {
            size: size_of::<GdkFullscreenMode>(),
            alignment: align_of::<GdkFullscreenMode>(),
        },
    ),
    (
        "GdkGLAPI",
        Layout {
            size: size_of::<GdkGLAPI>(),
            alignment: align_of::<GdkGLAPI>(),
        },
    ),
    (
        "GdkGLError",
        Layout {
            size: size_of::<GdkGLError>(),
            alignment: align_of::<GdkGLError>(),
        },
    ),
    (
        "GdkGravity",
        Layout {
            size: size_of::<GdkGravity>(),
            alignment: align_of::<GdkGravity>(),
        },
    ),
    (
        "GdkInputSource",
        Layout {
            size: size_of::<GdkInputSource>(),
            alignment: align_of::<GdkInputSource>(),
        },
    ),
    (
        "GdkKeyMatch",
        Layout {
            size: size_of::<GdkKeyMatch>(),
            alignment: align_of::<GdkKeyMatch>(),
        },
    ),
    (
        "GdkKeymapKey",
        Layout {
            size: size_of::<GdkKeymapKey>(),
            alignment: align_of::<GdkKeymapKey>(),
        },
    ),
    (
        "GdkMemoryFormat",
        Layout {
            size: size_of::<GdkMemoryFormat>(),
            alignment: align_of::<GdkMemoryFormat>(),
        },
    ),
    (
        "GdkModifierType",
        Layout {
            size: size_of::<GdkModifierType>(),
            alignment: align_of::<GdkModifierType>(),
        },
    ),
    (
        "GdkNotifyType",
        Layout {
            size: size_of::<GdkNotifyType>(),
            alignment: align_of::<GdkNotifyType>(),
        },
    ),
    (
        "GdkPaintableFlags",
        Layout {
            size: size_of::<GdkPaintableFlags>(),
            alignment: align_of::<GdkPaintableFlags>(),
        },
    ),
    (
        "GdkPaintableInterface",
        Layout {
            size: size_of::<GdkPaintableInterface>(),
            alignment: align_of::<GdkPaintableInterface>(),
        },
    ),
    (
        "GdkRGBA",
        Layout {
            size: size_of::<GdkRGBA>(),
            alignment: align_of::<GdkRGBA>(),
        },
    ),
    (
        "GdkRectangle",
        Layout {
            size: size_of::<GdkRectangle>(),
            alignment: align_of::<GdkRectangle>(),
        },
    ),
    (
        "GdkScrollDirection",
        Layout {
            size: size_of::<GdkScrollDirection>(),
            alignment: align_of::<GdkScrollDirection>(),
        },
    ),
    (
        "GdkScrollUnit",
        Layout {
            size: size_of::<GdkScrollUnit>(),
            alignment: align_of::<GdkScrollUnit>(),
        },
    ),
    (
        "GdkSeat",
        Layout {
            size: size_of::<GdkSeat>(),
            alignment: align_of::<GdkSeat>(),
        },
    ),
    (
        "GdkSeatCapabilities",
        Layout {
            size: size_of::<GdkSeatCapabilities>(),
            alignment: align_of::<GdkSeatCapabilities>(),
        },
    ),
    (
        "GdkSubpixelLayout",
        Layout {
            size: size_of::<GdkSubpixelLayout>(),
            alignment: align_of::<GdkSubpixelLayout>(),
        },
    ),
    (
        "GdkSurfaceEdge",
        Layout {
            size: size_of::<GdkSurfaceEdge>(),
            alignment: align_of::<GdkSurfaceEdge>(),
        },
    ),
    (
        "GdkTextureError",
        Layout {
            size: size_of::<GdkTextureError>(),
            alignment: align_of::<GdkTextureError>(),
        },
    ),
    (
        "GdkTimeCoord",
        Layout {
            size: size_of::<GdkTimeCoord>(),
            alignment: align_of::<GdkTimeCoord>(),
        },
    ),
    (
        "GdkTitlebarGesture",
        Layout {
            size: size_of::<GdkTitlebarGesture>(),
            alignment: align_of::<GdkTitlebarGesture>(),
        },
    ),
    (
        "GdkToplevelState",
        Layout {
            size: size_of::<GdkToplevelState>(),
            alignment: align_of::<GdkToplevelState>(),
        },
    ),
    (
        "GdkTouchpadGesturePhase",
        Layout {
            size: size_of::<GdkTouchpadGesturePhase>(),
            alignment: align_of::<GdkTouchpadGesturePhase>(),
        },
    ),
    (
        "GdkVulkanError",
        Layout {
            size: size_of::<GdkVulkanError>(),
            alignment: align_of::<GdkVulkanError>(),
        },
    ),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("GDK_ACTION_ALL", "7"),
    ("(guint) GDK_ACTION_ASK", "8"),
    ("(guint) GDK_ACTION_COPY", "1"),
    ("(guint) GDK_ACTION_LINK", "4"),
    ("(guint) GDK_ACTION_MOVE", "2"),
    ("(guint) GDK_ALT_MASK", "8"),
    ("(guint) GDK_ANCHOR_FLIP", "3"),
    ("(guint) GDK_ANCHOR_FLIP_X", "1"),
    ("(guint) GDK_ANCHOR_FLIP_Y", "2"),
    ("(guint) GDK_ANCHOR_RESIZE", "48"),
    ("(guint) GDK_ANCHOR_RESIZE_X", "16"),
    ("(guint) GDK_ANCHOR_RESIZE_Y", "32"),
    ("(guint) GDK_ANCHOR_SLIDE", "12"),
    ("(guint) GDK_ANCHOR_SLIDE_X", "4"),
    ("(guint) GDK_ANCHOR_SLIDE_Y", "8"),
    ("(gint) GDK_AXIS_DELTA_X", "3"),
    ("(gint) GDK_AXIS_DELTA_Y", "4"),
    ("(gint) GDK_AXIS_DISTANCE", "9"),
    ("(guint) GDK_AXIS_FLAG_DELTA_X", "8"),
    ("(guint) GDK_AXIS_FLAG_DELTA_Y", "16"),
    ("(guint) GDK_AXIS_FLAG_DISTANCE", "512"),
    ("(guint) GDK_AXIS_FLAG_PRESSURE", "32"),
    ("(guint) GDK_AXIS_FLAG_ROTATION", "1024"),
    ("(guint) GDK_AXIS_FLAG_SLIDER", "2048"),
    ("(guint) GDK_AXIS_FLAG_WHEEL", "256"),
    ("(guint) GDK_AXIS_FLAG_X", "2"),
    ("(guint) GDK_AXIS_FLAG_XTILT", "64"),
    ("(guint) GDK_AXIS_FLAG_Y", "4"),
    ("(guint) GDK_AXIS_FLAG_YTILT", "128"),
    ("(gint) GDK_AXIS_IGNORE", "0"),
    ("(gint) GDK_AXIS_LAST", "12"),
    ("(gint) GDK_AXIS_PRESSURE", "5"),
    ("(gint) GDK_AXIS_ROTATION", "10"),
    ("(gint) GDK_AXIS_SLIDER", "11"),
    ("(gint) GDK_AXIS_WHEEL", "8"),
    ("(gint) GDK_AXIS_X", "1"),
    ("(gint) GDK_AXIS_XTILT", "6"),
    ("(gint) GDK_AXIS_Y", "2"),
    ("(gint) GDK_AXIS_YTILT", "7"),
    ("(guint) GDK_BUTTON1_MASK", "256"),
    ("(guint) GDK_BUTTON2_MASK", "512"),
    ("(guint) GDK_BUTTON3_MASK", "1024"),
    ("(guint) GDK_BUTTON4_MASK", "2048"),
    ("(guint) GDK_BUTTON5_MASK", "4096"),
    ("GDK_BUTTON_MIDDLE", "2"),
    ("(gint) GDK_BUTTON_PRESS", "2"),
    ("GDK_BUTTON_PRIMARY", "1"),
    ("(gint) GDK_BUTTON_RELEASE", "3"),
    ("GDK_BUTTON_SECONDARY", "3"),
    ("(gint) GDK_CICP_RANGE_FULL", "1"),
    ("(gint) GDK_CICP_RANGE_NARROW", "0"),
    ("(guint) GDK_CONTROL_MASK", "4"),
    ("(gint) GDK_CROSSING_DEVICE_SWITCH", "8"),
    ("(gint) GDK_CROSSING_GRAB", "1"),
    ("(gint) GDK_CROSSING_GTK_GRAB", "3"),
    ("(gint) GDK_CROSSING_GTK_UNGRAB", "4"),
    ("(gint) GDK_CROSSING_NORMAL", "0"),
    ("(gint) GDK_CROSSING_STATE_CHANGED", "5"),
    ("(gint) GDK_CROSSING_TOUCH_BEGIN", "6"),
    ("(gint) GDK_CROSSING_TOUCH_END", "7"),
    ("(gint) GDK_CROSSING_UNGRAB", "2"),
    ("GDK_CURRENT_TIME", "0"),
    ("(gint) GDK_DELETE", "0"),
    ("(gint) GDK_DEVICE_PAD_FEATURE_BUTTON", "0"),
    ("(gint) GDK_DEVICE_PAD_FEATURE_RING", "1"),
    ("(gint) GDK_DEVICE_PAD_FEATURE_STRIP", "2"),
    ("(gint) GDK_DEVICE_TOOL_TYPE_AIRBRUSH", "5"),
    ("(gint) GDK_DEVICE_TOOL_TYPE_BRUSH", "3"),
    ("(gint) GDK_DEVICE_TOOL_TYPE_ERASER", "2"),
    ("(gint) GDK_DEVICE_TOOL_TYPE_LENS", "7"),
    ("(gint) GDK_DEVICE_TOOL_TYPE_MOUSE", "6"),
    ("(gint) GDK_DEVICE_TOOL_TYPE_PEN", "1"),
    ("(gint) GDK_DEVICE_TOOL_TYPE_PENCIL", "4"),
    ("(gint) GDK_DEVICE_TOOL_TYPE_UNKNOWN", "0"),
    ("(gint) GDK_DMABUF_ERROR_CREATION_FAILED", "2"),
    ("(gint) GDK_DMABUF_ERROR_NOT_AVAILABLE", "0"),
    ("(gint) GDK_DMABUF_ERROR_UNSUPPORTED_FORMAT", "1"),
    ("(gint) GDK_DRAG_CANCEL_ERROR", "2"),
    ("(gint) GDK_DRAG_CANCEL_NO_TARGET", "0"),
    ("(gint) GDK_DRAG_CANCEL_USER_CANCELLED", "1"),
    ("(gint) GDK_DRAG_ENTER", "11"),
    ("(gint) GDK_DRAG_LEAVE", "12"),
    ("(gint) GDK_DRAG_MOTION", "13"),
    ("(gint) GDK_DROP_START", "14"),
    ("(gint) GDK_ENTER_NOTIFY", "6"),
    ("(gint) GDK_EVENT_LAST", "29"),
    ("GDK_EVENT_PROPAGATE", "0"),
    ("GDK_EVENT_STOP", "1"),
    ("(gint) GDK_FOCUS_CHANGE", "8"),
    ("(guint) GDK_FRAME_CLOCK_PHASE_AFTER_PAINT", "64"),
    ("(guint) GDK_FRAME_CLOCK_PHASE_BEFORE_PAINT", "2"),
    ("(guint) GDK_FRAME_CLOCK_PHASE_FLUSH_EVENTS", "1"),
    ("(guint) GDK_FRAME_CLOCK_PHASE_LAYOUT", "8"),
    ("(guint) GDK_FRAME_CLOCK_PHASE_NONE", "0"),
    ("(guint) GDK_FRAME_CLOCK_PHASE_PAINT", "16"),
    ("(guint) GDK_FRAME_CLOCK_PHASE_RESUME_EVENTS", "32"),
    ("(guint) GDK_FRAME_CLOCK_PHASE_UPDATE", "4"),
    ("(gint) GDK_FULLSCREEN_ON_ALL_MONITORS", "1"),
    ("(gint) GDK_FULLSCREEN_ON_CURRENT_MONITOR", "0"),
    ("(guint) GDK_GL_API_GL", "1"),
    ("(guint) GDK_GL_API_GLES", "2"),
    ("(gint) GDK_GL_ERROR_COMPILATION_FAILED", "3"),
    ("(gint) GDK_GL_ERROR_LINK_FAILED", "4"),
    ("(gint) GDK_GL_ERROR_NOT_AVAILABLE", "0"),
    ("(gint) GDK_GL_ERROR_UNSUPPORTED_FORMAT", "1"),
    ("(gint) GDK_GL_ERROR_UNSUPPORTED_PROFILE", "2"),
    ("(gint) GDK_GRAB_BROKEN", "16"),
    ("(gint) GDK_GRAVITY_CENTER", "5"),
    ("(gint) GDK_GRAVITY_EAST", "6"),
    ("(gint) GDK_GRAVITY_NORTH", "2"),
    ("(gint) GDK_GRAVITY_NORTH_EAST", "3"),
    ("(gint) GDK_GRAVITY_NORTH_WEST", "1"),
    ("(gint) GDK_GRAVITY_SOUTH", "8"),
    ("(gint) GDK_GRAVITY_SOUTH_EAST", "9"),
    ("(gint) GDK_GRAVITY_SOUTH_WEST", "7"),
    ("(gint) GDK_GRAVITY_STATIC", "10"),
    ("(gint) GDK_GRAVITY_WEST", "4"),
    ("(guint) GDK_HYPER_MASK", "134217728"),
    ("GDK_KEY_0", "48"),
    ("GDK_KEY_1", "49"),
    ("GDK_KEY_2", "50"),
    ("GDK_KEY_3", "51"),
    ("GDK_KEY_3270_AltCursor", "64784"),
    ("GDK_KEY_3270_Attn", "64782"),
    ("GDK_KEY_3270_BackTab", "64773"),
    ("GDK_KEY_3270_ChangeScreen", "64793"),
    ("GDK_KEY_3270_Copy", "64789"),
    ("GDK_KEY_3270_CursorBlink", "64783"),
    ("GDK_KEY_3270_CursorSelect", "64796"),
    ("GDK_KEY_3270_DeleteWord", "64794"),
    ("GDK_KEY_3270_Duplicate", "64769"),
    ("GDK_KEY_3270_Enter", "64798"),
    ("GDK_KEY_3270_EraseEOF", "64774"),
    ("GDK_KEY_3270_EraseInput", "64775"),
    ("GDK_KEY_3270_ExSelect", "64795"),
    ("GDK_KEY_3270_FieldMark", "64770"),
    ("GDK_KEY_3270_Ident", "64787"),
    ("GDK_KEY_3270_Jump", "64786"),
    ("GDK_KEY_3270_KeyClick", "64785"),
    ("GDK_KEY_3270_Left2", "64772"),
    ("GDK_KEY_3270_PA1", "64778"),
    ("GDK_KEY_3270_PA2", "64779"),
    ("GDK_KEY_3270_PA3", "64780"),
    ("GDK_KEY_3270_Play", "64790"),
    ("GDK_KEY_3270_PrintScreen", "64797"),
    ("GDK_KEY_3270_Quit", "64777"),
    ("GDK_KEY_3270_Record", "64792"),
    ("GDK_KEY_3270_Reset", "64776"),
    ("GDK_KEY_3270_Right2", "64771"),
    ("GDK_KEY_3270_Rule", "64788"),
    ("GDK_KEY_3270_Setup", "64791"),
    ("GDK_KEY_3270_Test", "64781"),
    ("GDK_KEY_4", "52"),
    ("GDK_KEY_5", "53"),
    ("GDK_KEY_6", "54"),
    ("GDK_KEY_7", "55"),
    ("GDK_KEY_8", "56"),
    ("GDK_KEY_9", "57"),
    ("GDK_KEY_A", "65"),
    ("GDK_KEY_AE", "198"),
    ("GDK_KEY_Aacute", "193"),
    ("GDK_KEY_Abelowdot", "16785056"),
    ("GDK_KEY_Abreve", "451"),
    ("GDK_KEY_Abreveacute", "16785070"),
    ("GDK_KEY_Abrevebelowdot", "16785078"),
    ("GDK_KEY_Abrevegrave", "16785072"),
    ("GDK_KEY_Abrevehook", "16785074"),
    ("GDK_KEY_Abrevetilde", "16785076"),
    ("GDK_KEY_AccessX_Enable", "65136"),
    ("GDK_KEY_AccessX_Feedback_Enable", "65137"),
    ("GDK_KEY_Acircumflex", "194"),
    ("GDK_KEY_Acircumflexacute", "16785060"),
    ("GDK_KEY_Acircumflexbelowdot", "16785068"),
    ("GDK_KEY_Acircumflexgrave", "16785062"),
    ("GDK_KEY_Acircumflexhook", "16785064"),
    ("GDK_KEY_Acircumflextilde", "16785066"),
    ("GDK_KEY_AddFavorite", "269025081"),
    ("GDK_KEY_Adiaeresis", "196"),
    ("GDK_KEY_Agrave", "192"),
    ("GDK_KEY_Ahook", "16785058"),
    ("GDK_KEY_Alt_L", "65513"),
    ("GDK_KEY_Alt_R", "65514"),
    ("GDK_KEY_Amacron", "960"),
    ("GDK_KEY_Aogonek", "417"),
    ("GDK_KEY_ApplicationLeft", "269025104"),
    ("GDK_KEY_ApplicationRight", "269025105"),
    ("GDK_KEY_Arabic_0", "16778848"),
    ("GDK_KEY_Arabic_1", "16778849"),
    ("GDK_KEY_Arabic_2", "16778850"),
    ("GDK_KEY_Arabic_3", "16778851"),
    ("GDK_KEY_Arabic_4", "16778852"),
    ("GDK_KEY_Arabic_5", "16778853"),
    ("GDK_KEY_Arabic_6", "16778854"),
    ("GDK_KEY_Arabic_7", "16778855"),
    ("GDK_KEY_Arabic_8", "16778856"),
    ("GDK_KEY_Arabic_9", "16778857"),
    ("GDK_KEY_Arabic_ain", "1497"),
    ("GDK_KEY_Arabic_alef", "1479"),
    ("GDK_KEY_Arabic_alefmaksura", "1513"),
    ("GDK_KEY_Arabic_beh", "1480"),
    ("GDK_KEY_Arabic_comma", "1452"),
    ("GDK_KEY_Arabic_dad", "1494"),
    ("GDK_KEY_Arabic_dal", "1487"),
    ("GDK_KEY_Arabic_damma", "1519"),
    ("GDK_KEY_Arabic_dammatan", "1516"),
    ("GDK_KEY_Arabic_ddal", "16778888"),
    ("GDK_KEY_Arabic_farsi_yeh", "16778956"),
    ("GDK_KEY_Arabic_fatha", "1518"),
    ("GDK_KEY_Arabic_fathatan", "1515"),
    ("GDK_KEY_Arabic_feh", "1505"),
    ("GDK_KEY_Arabic_fullstop", "16778964"),
    ("GDK_KEY_Arabic_gaf", "16778927"),
    ("GDK_KEY_Arabic_ghain", "1498"),
    ("GDK_KEY_Arabic_ha", "1511"),
    ("GDK_KEY_Arabic_hah", "1485"),
    ("GDK_KEY_Arabic_hamza", "1473"),
    ("GDK_KEY_Arabic_hamza_above", "16778836"),
    ("GDK_KEY_Arabic_hamza_below", "16778837"),
    ("GDK_KEY_Arabic_hamzaonalef", "1475"),
    ("GDK_KEY_Arabic_hamzaonwaw", "1476"),
    ("GDK_KEY_Arabic_hamzaonyeh", "1478"),
    ("GDK_KEY_Arabic_hamzaunderalef", "1477"),
    ("GDK_KEY_Arabic_heh", "1511"),
    ("GDK_KEY_Arabic_heh_doachashmee", "16778942"),
    ("GDK_KEY_Arabic_heh_goal", "16778945"),
    ("GDK_KEY_Arabic_jeem", "1484"),
    ("GDK_KEY_Arabic_jeh", "16778904"),
    ("GDK_KEY_Arabic_kaf", "1507"),
    ("GDK_KEY_Arabic_kasra", "1520"),
    ("GDK_KEY_Arabic_kasratan", "1517"),
    ("GDK_KEY_Arabic_keheh", "16778921"),
    ("GDK_KEY_Arabic_khah", "1486"),
    ("GDK_KEY_Arabic_lam", "1508"),
    ("GDK_KEY_Arabic_madda_above", "16778835"),
    ("GDK_KEY_Arabic_maddaonalef", "1474"),
    ("GDK_KEY_Arabic_meem", "1509"),
    ("GDK_KEY_Arabic_noon", "1510"),
    ("GDK_KEY_Arabic_noon_ghunna", "16778938"),
    ("GDK_KEY_Arabic_peh", "16778878"),
    ("GDK_KEY_Arabic_percent", "16778858"),
    ("GDK_KEY_Arabic_qaf", "1506"),
    ("GDK_KEY_Arabic_question_mark", "1471"),
    ("GDK_KEY_Arabic_ra", "1489"),
    ("GDK_KEY_Arabic_rreh", "16778897"),
    ("GDK_KEY_Arabic_sad", "1493"),
    ("GDK_KEY_Arabic_seen", "1491"),
    ("GDK_KEY_Arabic_semicolon", "1467"),
    ("GDK_KEY_Arabic_shadda", "1521"),
    ("GDK_KEY_Arabic_sheen", "1492"),
    ("GDK_KEY_Arabic_sukun", "1522"),
    ("GDK_KEY_Arabic_superscript_alef", "16778864"),
    ("GDK_KEY_Arabic_switch", "65406"),
    ("GDK_KEY_Arabic_tah", "1495"),
    ("GDK_KEY_Arabic_tatweel", "1504"),
    ("GDK_KEY_Arabic_tcheh", "16778886"),
    ("GDK_KEY_Arabic_teh", "1482"),
    ("GDK_KEY_Arabic_tehmarbuta", "1481"),
    ("GDK_KEY_Arabic_thal", "1488"),
    ("GDK_KEY_Arabic_theh", "1483"),
    ("GDK_KEY_Arabic_tteh", "16778873"),
    ("GDK_KEY_Arabic_veh", "16778916"),
    ("GDK_KEY_Arabic_waw", "1512"),
    ("GDK_KEY_Arabic_yeh", "1514"),
    ("GDK_KEY_Arabic_yeh_baree", "16778962"),
    ("GDK_KEY_Arabic_zah", "1496"),
    ("GDK_KEY_Arabic_zain", "1490"),
    ("GDK_KEY_Aring", "197"),
    ("GDK_KEY_Armenian_AT", "16778552"),
    ("GDK_KEY_Armenian_AYB", "16778545"),
    ("GDK_KEY_Armenian_BEN", "16778546"),
    ("GDK_KEY_Armenian_CHA", "16778569"),
    ("GDK_KEY_Armenian_DA", "16778548"),
    ("GDK_KEY_Armenian_DZA", "16778561"),
    ("GDK_KEY_Armenian_E", "16778551"),
    ("GDK_KEY_Armenian_FE", "16778582"),
    ("GDK_KEY_Armenian_GHAT", "16778562"),
    ("GDK_KEY_Armenian_GIM", "16778547"),
    ("GDK_KEY_Armenian_HI", "16778565"),
    ("GDK_KEY_Armenian_HO", "16778560"),
    ("GDK_KEY_Armenian_INI", "16778555"),
    ("GDK_KEY_Armenian_JE", "16778571"),
    ("GDK_KEY_Armenian_KE", "16778580"),
    ("GDK_KEY_Armenian_KEN", "16778559"),
    ("GDK_KEY_Armenian_KHE", "16778557"),
    ("GDK_KEY_Armenian_LYUN", "16778556"),
    ("GDK_KEY_Armenian_MEN", "16778564"),
    ("GDK_KEY_Armenian_NU", "16778566"),
    ("GDK_KEY_Armenian_O", "16778581"),
    ("GDK_KEY_Armenian_PE", "16778570"),
    ("GDK_KEY_Armenian_PYUR", "16778579"),
    ("GDK_KEY_Armenian_RA", "16778572"),
    ("GDK_KEY_Armenian_RE", "16778576"),
    ("GDK_KEY_Armenian_SE", "16778573"),
    ("GDK_KEY_Armenian_SHA", "16778567"),
    ("GDK_KEY_Armenian_TCHE", "16778563"),
    ("GDK_KEY_Armenian_TO", "16778553"),
    ("GDK_KEY_Armenian_TSA", "16778558"),
    ("GDK_KEY_Armenian_TSO", "16778577"),
    ("GDK_KEY_Armenian_TYUN", "16778575"),
    ("GDK_KEY_Armenian_VEV", "16778574"),
    ("GDK_KEY_Armenian_VO", "16778568"),
    ("GDK_KEY_Armenian_VYUN", "16778578"),
    ("GDK_KEY_Armenian_YECH", "16778549"),
    ("GDK_KEY_Armenian_ZA", "16778550"),
    ("GDK_KEY_Armenian_ZHE", "16778554"),
    ("GDK_KEY_Armenian_accent", "16778587"),
    ("GDK_KEY_Armenian_amanak", "16778588"),
    ("GDK_KEY_Armenian_apostrophe", "16778586"),
    ("GDK_KEY_Armenian_at", "16778600"),
    ("GDK_KEY_Armenian_ayb", "16778593"),
    ("GDK_KEY_Armenian_ben", "16778594"),
    ("GDK_KEY_Armenian_but", "16778589"),
    ("GDK_KEY_Armenian_cha", "16778617"),
    ("GDK_KEY_Armenian_da", "16778596"),
    ("GDK_KEY_Armenian_dza", "16778609"),
    ("GDK_KEY_Armenian_e", "16778599"),
    ("GDK_KEY_Armenian_exclam", "16778588"),
    ("GDK_KEY_Armenian_fe", "16778630"),
    ("GDK_KEY_Armenian_full_stop", "16778633"),
    ("GDK_KEY_Armenian_ghat", "16778610"),
    ("GDK_KEY_Armenian_gim", "16778595"),
    ("GDK_KEY_Armenian_hi", "16778613"),
    ("GDK_KEY_Armenian_ho", "16778608"),
    ("GDK_KEY_Armenian_hyphen", "16778634"),
    ("GDK_KEY_Armenian_ini", "16778603"),
    ("GDK_KEY_Armenian_je", "16778619"),
    ("GDK_KEY_Armenian_ke", "16778628"),
    ("GDK_KEY_Armenian_ken", "16778607"),
    ("GDK_KEY_Armenian_khe", "16778605"),
    ("GDK_KEY_Armenian_ligature_ew", "16778631"),
    ("GDK_KEY_Armenian_lyun", "16778604"),
    ("GDK_KEY_Armenian_men", "16778612"),
    ("GDK_KEY_Armenian_nu", "16778614"),
    ("GDK_KEY_Armenian_o", "16778629"),
    ("GDK_KEY_Armenian_paruyk", "16778590"),
    ("GDK_KEY_Armenian_pe", "16778618"),
    ("GDK_KEY_Armenian_pyur", "16778627"),
    ("GDK_KEY_Armenian_question", "16778590"),
    ("GDK_KEY_Armenian_ra", "16778620"),
    ("GDK_KEY_Armenian_re", "16778624"),
    ("GDK_KEY_Armenian_se", "16778621"),
    ("GDK_KEY_Armenian_separation_mark", "16778589"),
    ("GDK_KEY_Armenian_sha", "16778615"),
    ("GDK_KEY_Armenian_shesht", "16778587"),
    ("GDK_KEY_Armenian_tche", "16778611"),
    ("GDK_KEY_Armenian_to", "16778601"),
    ("GDK_KEY_Armenian_tsa", "16778606"),
    ("GDK_KEY_Armenian_tso", "16778625"),
    ("GDK_KEY_Armenian_tyun", "16778623"),
    ("GDK_KEY_Armenian_verjaket", "16778633"),
    ("GDK_KEY_Armenian_vev", "16778622"),
    ("GDK_KEY_Armenian_vo", "16778616"),
    ("GDK_KEY_Armenian_vyun", "16778626"),
    ("GDK_KEY_Armenian_yech", "16778597"),
    ("GDK_KEY_Armenian_yentamna", "16778634"),
    ("GDK_KEY_Armenian_za", "16778598"),
    ("GDK_KEY_Armenian_zhe", "16778602"),
    ("GDK_KEY_Atilde", "195"),
    ("GDK_KEY_AudibleBell_Enable", "65146"),
    ("GDK_KEY_AudioCycleTrack", "269025179"),
    ("GDK_KEY_AudioForward", "269025175"),
    ("GDK_KEY_AudioLowerVolume", "269025041"),
    ("GDK_KEY_AudioMedia", "269025074"),
    ("GDK_KEY_AudioMicMute", "269025202"),
    ("GDK_KEY_AudioMute", "269025042"),
    ("GDK_KEY_AudioNext", "269025047"),
    ("GDK_KEY_AudioPause", "269025073"),
    ("GDK_KEY_AudioPlay", "269025044"),
    ("GDK_KEY_AudioPreset", "269025206"),
    ("GDK_KEY_AudioPrev", "269025046"),
    ("GDK_KEY_AudioRaiseVolume", "269025043"),
    ("GDK_KEY_AudioRandomPlay", "269025177"),
    ("GDK_KEY_AudioRecord", "269025052"),
    ("GDK_KEY_AudioRepeat", "269025176"),
    ("GDK_KEY_AudioRewind", "269025086"),
    ("GDK_KEY_AudioStop", "269025045"),
    ("GDK_KEY_Away", "269025165"),
    ("GDK_KEY_B", "66"),
    ("GDK_KEY_Babovedot", "16784898"),
    ("GDK_KEY_Back", "269025062"),
    ("GDK_KEY_BackForward", "269025087"),
    ("GDK_KEY_BackSpace", "65288"),
    ("GDK_KEY_Battery", "269025171"),
    ("GDK_KEY_Begin", "65368"),
    ("GDK_KEY_Blue", "269025190"),
    ("GDK_KEY_Bluetooth", "269025172"),
    ("GDK_KEY_Book", "269025106"),
    ("GDK_KEY_BounceKeys_Enable", "65140"),
    ("GDK_KEY_Break", "65387"),
    ("GDK_KEY_BrightnessAdjust", "269025083"),
    ("GDK_KEY_Byelorussian_SHORTU", "1726"),
    ("GDK_KEY_Byelorussian_shortu", "1710"),
    ("GDK_KEY_C", "67"),
    ("GDK_KEY_CD", "269025107"),
    ("GDK_KEY_CH", "65186"),
    ("GDK_KEY_C_H", "65189"),
    ("GDK_KEY_C_h", "65188"),
    ("GDK_KEY_Cabovedot", "709"),
    ("GDK_KEY_Cacute", "454"),
    ("GDK_KEY_Calculator", "269025053"),
    ("GDK_KEY_Calendar", "269025056"),
    ("GDK_KEY_Cancel", "65385"),
    ("GDK_KEY_Caps_Lock", "65509"),
    ("GDK_KEY_Ccaron", "456"),
    ("GDK_KEY_Ccedilla", "199"),
    ("GDK_KEY_Ccircumflex", "710"),
    ("GDK_KEY_Ch", "65185"),
    ("GDK_KEY_Clear", "65291"),
    ("GDK_KEY_ClearGrab", "269024801"),
    ("GDK_KEY_Close", "269025110"),
    ("GDK_KEY_Codeinput", "65335"),
    ("GDK_KEY_ColonSign", "16785569"),
    ("GDK_KEY_Community", "269025085"),
    ("GDK_KEY_ContrastAdjust", "269025058"),
    ("GDK_KEY_Control_L", "65507"),
    ("GDK_KEY_Control_R", "65508"),
    ("GDK_KEY_Copy", "269025111"),
    ("GDK_KEY_CruzeiroSign", "16785570"),
    ("GDK_KEY_Cut", "269025112"),
    ("GDK_KEY_CycleAngle", "269025180"),
    ("GDK_KEY_Cyrillic_A", "1761"),
    ("GDK_KEY_Cyrillic_BE", "1762"),
    ("GDK_KEY_Cyrillic_CHE", "1790"),
    ("GDK_KEY_Cyrillic_CHE_descender", "16778422"),
    ("GDK_KEY_Cyrillic_CHE_vertstroke", "16778424"),
    ("GDK_KEY_Cyrillic_DE", "1764"),
    ("GDK_KEY_Cyrillic_DZHE", "1727"),
    ("GDK_KEY_Cyrillic_E", "1788"),
    ("GDK_KEY_Cyrillic_EF", "1766"),
    ("GDK_KEY_Cyrillic_EL", "1772"),
    ("GDK_KEY_Cyrillic_EM", "1773"),
    ("GDK_KEY_Cyrillic_EN", "1774"),
    ("GDK_KEY_Cyrillic_EN_descender", "16778402"),
    ("GDK_KEY_Cyrillic_ER", "1778"),
    ("GDK_KEY_Cyrillic_ES", "1779"),
    ("GDK_KEY_Cyrillic_GHE", "1767"),
    ("GDK_KEY_Cyrillic_GHE_bar", "16778386"),
    ("GDK_KEY_Cyrillic_HA", "1768"),
    ("GDK_KEY_Cyrillic_HARDSIGN", "1791"),
    ("GDK_KEY_Cyrillic_HA_descender", "16778418"),
    ("GDK_KEY_Cyrillic_I", "1769"),
    ("GDK_KEY_Cyrillic_IE", "1765"),
    ("GDK_KEY_Cyrillic_IO", "1715"),
    ("GDK_KEY_Cyrillic_I_macron", "16778466"),
    ("GDK_KEY_Cyrillic_JE", "1720"),
    ("GDK_KEY_Cyrillic_KA", "1771"),
    ("GDK_KEY_Cyrillic_KA_descender", "16778394"),
    ("GDK_KEY_Cyrillic_KA_vertstroke", "16778396"),
    ("GDK_KEY_Cyrillic_LJE", "1721"),
    ("GDK_KEY_Cyrillic_NJE", "1722"),
    ("GDK_KEY_Cyrillic_O", "1775"),
    ("GDK_KEY_Cyrillic_O_bar", "16778472"),
    ("GDK_KEY_Cyrillic_PE", "1776"),
    ("GDK_KEY_Cyrillic_SCHWA", "16778456"),
    ("GDK_KEY_Cyrillic_SHA", "1787"),
    ("GDK_KEY_Cyrillic_SHCHA", "1789"),
    ("GDK_KEY_Cyrillic_SHHA", "16778426"),
    ("GDK_KEY_Cyrillic_SHORTI", "1770"),
    ("GDK_KEY_Cyrillic_SOFTSIGN", "1784"),
    ("GDK_KEY_Cyrillic_TE", "1780"),
    ("GDK_KEY_Cyrillic_TSE", "1763"),
    ("GDK_KEY_Cyrillic_U", "1781"),
    ("GDK_KEY_Cyrillic_U_macron", "16778478"),
    ("GDK_KEY_Cyrillic_U_straight", "16778414"),
    ("GDK_KEY_Cyrillic_U_straight_bar", "16778416"),
    ("GDK_KEY_Cyrillic_VE", "1783"),
    ("GDK_KEY_Cyrillic_YA", "1777"),
    ("GDK_KEY_Cyrillic_YERU", "1785"),
    ("GDK_KEY_Cyrillic_YU", "1760"),
    ("GDK_KEY_Cyrillic_ZE", "1786"),
    ("GDK_KEY_Cyrillic_ZHE", "1782"),
    ("GDK_KEY_Cyrillic_ZHE_descender", "16778390"),
    ("GDK_KEY_Cyrillic_a", "1729"),
    ("GDK_KEY_Cyrillic_be", "1730"),
    ("GDK_KEY_Cyrillic_che", "1758"),
    ("GDK_KEY_Cyrillic_che_descender", "16778423"),
    ("GDK_KEY_Cyrillic_che_vertstroke", "16778425"),
    ("GDK_KEY_Cyrillic_de", "1732"),
    ("GDK_KEY_Cyrillic_dzhe", "1711"),
    ("GDK_KEY_Cyrillic_e", "1756"),
    ("GDK_KEY_Cyrillic_ef", "1734"),
    ("GDK_KEY_Cyrillic_el", "1740"),
    ("GDK_KEY_Cyrillic_em", "1741"),
    ("GDK_KEY_Cyrillic_en", "1742"),
    ("GDK_KEY_Cyrillic_en_descender", "16778403"),
    ("GDK_KEY_Cyrillic_er", "1746"),
    ("GDK_KEY_Cyrillic_es", "1747"),
    ("GDK_KEY_Cyrillic_ghe", "1735"),
    ("GDK_KEY_Cyrillic_ghe_bar", "16778387"),
    ("GDK_KEY_Cyrillic_ha", "1736"),
    ("GDK_KEY_Cyrillic_ha_descender", "16778419"),
    ("GDK_KEY_Cyrillic_hardsign", "1759"),
    ("GDK_KEY_Cyrillic_i", "1737"),
    ("GDK_KEY_Cyrillic_i_macron", "16778467"),
    ("GDK_KEY_Cyrillic_ie", "1733"),
    ("GDK_KEY_Cyrillic_io", "1699"),
    ("GDK_KEY_Cyrillic_je", "1704"),
    ("GDK_KEY_Cyrillic_ka", "1739"),
    ("GDK_KEY_Cyrillic_ka_descender", "16778395"),
    ("GDK_KEY_Cyrillic_ka_vertstroke", "16778397"),
    ("GDK_KEY_Cyrillic_lje", "1705"),
    ("GDK_KEY_Cyrillic_nje", "1706"),
    ("GDK_KEY_Cyrillic_o", "1743"),
    ("GDK_KEY_Cyrillic_o_bar", "16778473"),
    ("GDK_KEY_Cyrillic_pe", "1744"),
    ("GDK_KEY_Cyrillic_schwa", "16778457"),
    ("GDK_KEY_Cyrillic_sha", "1755"),
    ("GDK_KEY_Cyrillic_shcha", "1757"),
    ("GDK_KEY_Cyrillic_shha", "16778427"),
    ("GDK_KEY_Cyrillic_shorti", "1738"),
    ("GDK_KEY_Cyrillic_softsign", "1752"),
    ("GDK_KEY_Cyrillic_te", "1748"),
    ("GDK_KEY_Cyrillic_tse", "1731"),
    ("GDK_KEY_Cyrillic_u", "1749"),
    ("GDK_KEY_Cyrillic_u_macron", "16778479"),
    ("GDK_KEY_Cyrillic_u_straight", "16778415"),
    ("GDK_KEY_Cyrillic_u_straight_bar", "16778417"),
    ("GDK_KEY_Cyrillic_ve", "1751"),
    ("GDK_KEY_Cyrillic_ya", "1745"),
    ("GDK_KEY_Cyrillic_yeru", "1753"),
    ("GDK_KEY_Cyrillic_yu", "1728"),
    ("GDK_KEY_Cyrillic_ze", "1754"),
    ("GDK_KEY_Cyrillic_zhe", "1750"),
    ("GDK_KEY_Cyrillic_zhe_descender", "16778391"),
    ("GDK_KEY_D", "68"),
    ("GDK_KEY_DOS", "269025114"),
    ("GDK_KEY_Dabovedot", "16784906"),
    ("GDK_KEY_Dcaron", "463"),
    ("GDK_KEY_Delete", "65535"),
    ("GDK_KEY_Display", "269025113"),
    ("GDK_KEY_Documents", "269025115"),
    ("GDK_KEY_DongSign", "16785579"),
    ("GDK_KEY_Down", "65364"),
    ("GDK_KEY_Dstroke", "464"),
    ("GDK_KEY_E", "69"),
    ("GDK_KEY_ENG", "957"),
    ("GDK_KEY_ETH", "208"),
    ("GDK_KEY_EZH", "16777655"),
    ("GDK_KEY_Eabovedot", "972"),
    ("GDK_KEY_Eacute", "201"),
    ("GDK_KEY_Ebelowdot", "16785080"),
    ("GDK_KEY_Ecaron", "460"),
    ("GDK_KEY_Ecircumflex", "202"),
    ("GDK_KEY_Ecircumflexacute", "16785086"),
    ("GDK_KEY_Ecircumflexbelowdot", "16785094"),
    ("GDK_KEY_Ecircumflexgrave", "16785088"),
    ("GDK_KEY_Ecircumflexhook", "16785090"),
    ("GDK_KEY_Ecircumflextilde", "16785092"),
    ("GDK_KEY_EcuSign", "16785568"),
    ("GDK_KEY_Ediaeresis", "203"),
    ("GDK_KEY_Egrave", "200"),
    ("GDK_KEY_Ehook", "16785082"),
    ("GDK_KEY_Eisu_Shift", "65327"),
    ("GDK_KEY_Eisu_toggle", "65328"),
    ("GDK_KEY_Eject", "269025068"),
    ("GDK_KEY_Emacron", "938"),
    ("GDK_KEY_End", "65367"),
    ("GDK_KEY_Eogonek", "458"),
    ("GDK_KEY_Escape", "65307"),
    ("GDK_KEY_Eth", "208"),
    ("GDK_KEY_Etilde", "16785084"),
    ("GDK_KEY_EuroSign", "8364"),
    ("GDK_KEY_Excel", "269025116"),
    ("GDK_KEY_Execute", "65378"),
    ("GDK_KEY_Explorer", "269025117"),
    ("GDK_KEY_F", "70"),
    ("GDK_KEY_F1", "65470"),
    ("GDK_KEY_F10", "65479"),
    ("GDK_KEY_F11", "65480"),
    ("GDK_KEY_F12", "65481"),
    ("GDK_KEY_F13", "65482"),
    ("GDK_KEY_F14", "65483"),
    ("GDK_KEY_F15", "65484"),
    ("GDK_KEY_F16", "65485"),
    ("GDK_KEY_F17", "65486"),
    ("GDK_KEY_F18", "65487"),
    ("GDK_KEY_F19", "65488"),
    ("GDK_KEY_F2", "65471"),
    ("GDK_KEY_F20", "65489"),
    ("GDK_KEY_F21", "65490"),
    ("GDK_KEY_F22", "65491"),
    ("GDK_KEY_F23", "65492"),
    ("GDK_KEY_F24", "65493"),
    ("GDK_KEY_F25", "65494"),
    ("GDK_KEY_F26", "65495"),
    ("GDK_KEY_F27", "65496"),
    ("GDK_KEY_F28", "65497"),
    ("GDK_KEY_F29", "65498"),
    ("GDK_KEY_F3", "65472"),
    ("GDK_KEY_F30", "65499"),
    ("GDK_KEY_F31", "65500"),
    ("GDK_KEY_F32", "65501"),
    ("GDK_KEY_F33", "65502"),
    ("GDK_KEY_F34", "65503"),
    ("GDK_KEY_F35", "65504"),
    ("GDK_KEY_F4", "65473"),
    ("GDK_KEY_F5", "65474"),
    ("GDK_KEY_F6", "65475"),
    ("GDK_KEY_F7", "65476"),
    ("GDK_KEY_F8", "65477"),
    ("GDK_KEY_F9", "65478"),
    ("GDK_KEY_FFrancSign", "16785571"),
    ("GDK_KEY_Fabovedot", "16784926"),
    ("GDK_KEY_Farsi_0", "16778992"),
    ("GDK_KEY_Farsi_1", "16778993"),
    ("GDK_KEY_Farsi_2", "16778994"),
    ("GDK_KEY_Farsi_3", "16778995"),
    ("GDK_KEY_Farsi_4", "16778996"),
    ("GDK_KEY_Farsi_5", "16778997"),
    ("GDK_KEY_Farsi_6", "16778998"),
    ("GDK_KEY_Farsi_7", "16778999"),
    ("GDK_KEY_Farsi_8", "16779000"),
    ("GDK_KEY_Farsi_9", "16779001"),
    ("GDK_KEY_Farsi_yeh", "16778956"),
    ("GDK_KEY_Favorites", "269025072"),
    ("GDK_KEY_Finance", "269025084"),
    ("GDK_KEY_Find", "65384"),
    ("GDK_KEY_First_Virtual_Screen", "65232"),
    ("GDK_KEY_Forward", "269025063"),
    ("GDK_KEY_FrameBack", "269025181"),
    ("GDK_KEY_FrameForward", "269025182"),
    ("GDK_KEY_G", "71"),
    ("GDK_KEY_Gabovedot", "725"),
    ("GDK_KEY_Game", "269025118"),
    ("GDK_KEY_Gbreve", "683"),
    ("GDK_KEY_Gcaron", "16777702"),
    ("GDK_KEY_Gcedilla", "939"),
    ("GDK_KEY_Gcircumflex", "728"),
    ("GDK_KEY_Georgian_an", "16781520"),
    ("GDK_KEY_Georgian_ban", "16781521"),
    ("GDK_KEY_Georgian_can", "16781546"),
    ("GDK_KEY_Georgian_char", "16781549"),
    ("GDK_KEY_Georgian_chin", "16781545"),
    ("GDK_KEY_Georgian_cil", "16781548"),
    ("GDK_KEY_Georgian_don", "16781523"),
    ("GDK_KEY_Georgian_en", "16781524"),
    ("GDK_KEY_Georgian_fi", "16781558"),
    ("GDK_KEY_Georgian_gan", "16781522"),
    ("GDK_KEY_Georgian_ghan", "16781542"),
    ("GDK_KEY_Georgian_hae", "16781552"),
    ("GDK_KEY_Georgian_har", "16781556"),
    ("GDK_KEY_Georgian_he", "16781553"),
    ("GDK_KEY_Georgian_hie", "16781554"),
    ("GDK_KEY_Georgian_hoe", "16781557"),
    ("GDK_KEY_Georgian_in", "16781528"),
    ("GDK_KEY_Georgian_jhan", "16781551"),
    ("GDK_KEY_Georgian_jil", "16781547"),
    ("GDK_KEY_Georgian_kan", "16781529"),
    ("GDK_KEY_Georgian_khar", "16781541"),
    ("GDK_KEY_Georgian_las", "16781530"),
    ("GDK_KEY_Georgian_man", "16781531"),
    ("GDK_KEY_Georgian_nar", "16781532"),
    ("GDK_KEY_Georgian_on", "16781533"),
    ("GDK_KEY_Georgian_par", "16781534"),
    ("GDK_KEY_Georgian_phar", "16781540"),
    ("GDK_KEY_Georgian_qar", "16781543"),
    ("GDK_KEY_Georgian_rae", "16781536"),
    ("GDK_KEY_Georgian_san", "16781537"),
    ("GDK_KEY_Georgian_shin", "16781544"),
    ("GDK_KEY_Georgian_tan", "16781527"),
    ("GDK_KEY_Georgian_tar", "16781538"),
    ("GDK_KEY_Georgian_un", "16781539"),
    ("GDK_KEY_Georgian_vin", "16781525"),
    ("GDK_KEY_Georgian_we", "16781555"),
    ("GDK_KEY_Georgian_xan", "16781550"),
    ("GDK_KEY_Georgian_zen", "16781526"),
    ("GDK_KEY_Georgian_zhar", "16781535"),
    ("GDK_KEY_Go", "269025119"),
    ("GDK_KEY_Greek_ALPHA", "1985"),
    ("GDK_KEY_Greek_ALPHAaccent", "1953"),
    ("GDK_KEY_Greek_BETA", "1986"),
    ("GDK_KEY_Greek_CHI", "2007"),
    ("GDK_KEY_Greek_DELTA", "1988"),
    ("GDK_KEY_Greek_EPSILON", "1989"),
    ("GDK_KEY_Greek_EPSILONaccent", "1954"),
    ("GDK_KEY_Greek_ETA", "1991"),
    ("GDK_KEY_Greek_ETAaccent", "1955"),
    ("GDK_KEY_Greek_GAMMA", "1987"),
    ("GDK_KEY_Greek_IOTA", "1993"),
    ("GDK_KEY_Greek_IOTAaccent", "1956"),
    ("GDK_KEY_Greek_IOTAdiaeresis", "1957"),
    ("GDK_KEY_Greek_IOTAdieresis", "1957"),
    ("GDK_KEY_Greek_KAPPA", "1994"),
    ("GDK_KEY_Greek_LAMBDA", "1995"),
    ("GDK_KEY_Greek_LAMDA", "1995"),
    ("GDK_KEY_Greek_MU", "1996"),
    ("GDK_KEY_Greek_NU", "1997"),
    ("GDK_KEY_Greek_OMEGA", "2009"),
    ("GDK_KEY_Greek_OMEGAaccent", "1963"),
    ("GDK_KEY_Greek_OMICRON", "1999"),
    ("GDK_KEY_Greek_OMICRONaccent", "1959"),
    ("GDK_KEY_Greek_PHI", "2006"),
    ("GDK_KEY_Greek_PI", "2000"),
    ("GDK_KEY_Greek_PSI", "2008"),
    ("GDK_KEY_Greek_RHO", "2001"),
    ("GDK_KEY_Greek_SIGMA", "2002"),
    ("GDK_KEY_Greek_TAU", "2004"),
    ("GDK_KEY_Greek_THETA", "1992"),
    ("GDK_KEY_Greek_UPSILON", "2005"),
    ("GDK_KEY_Greek_UPSILONaccent", "1960"),
    ("GDK_KEY_Greek_UPSILONdieresis", "1961"),
    ("GDK_KEY_Greek_XI", "1998"),
    ("GDK_KEY_Greek_ZETA", "1990"),
    ("GDK_KEY_Greek_accentdieresis", "1966"),
    ("GDK_KEY_Greek_alpha", "2017"),
    ("GDK_KEY_Greek_alphaaccent", "1969"),
    ("GDK_KEY_Greek_beta", "2018"),
    ("GDK_KEY_Greek_chi", "2039"),
    ("GDK_KEY_Greek_delta", "2020"),
    ("GDK_KEY_Greek_epsilon", "2021"),
    ("GDK_KEY_Greek_epsilonaccent", "1970"),
    ("GDK_KEY_Greek_eta", "2023"),
    ("GDK_KEY_Greek_etaaccent", "1971"),
    ("GDK_KEY_Greek_finalsmallsigma", "2035"),
    ("GDK_KEY_Greek_gamma", "2019"),
    ("GDK_KEY_Greek_horizbar", "1967"),
    ("GDK_KEY_Greek_iota", "2025"),
    ("GDK_KEY_Greek_iotaaccent", "1972"),
    ("GDK_KEY_Greek_iotaaccentdieresis", "1974"),
    ("GDK_KEY_Greek_iotadieresis", "1973"),
    ("GDK_KEY_Greek_kappa", "2026"),
    ("GDK_KEY_Greek_lambda", "2027"),
    ("GDK_KEY_Greek_lamda", "2027"),
    ("GDK_KEY_Greek_mu", "2028"),
    ("GDK_KEY_Greek_nu", "2029"),
    ("GDK_KEY_Greek_omega", "2041"),
    ("GDK_KEY_Greek_omegaaccent", "1979"),
    ("GDK_KEY_Greek_omicron", "2031"),
    ("GDK_KEY_Greek_omicronaccent", "1975"),
    ("GDK_KEY_Greek_phi", "2038"),
    ("GDK_KEY_Greek_pi", "2032"),
    ("GDK_KEY_Greek_psi", "2040"),
    ("GDK_KEY_Greek_rho", "2033"),
    ("GDK_KEY_Greek_sigma", "2034"),
    ("GDK_KEY_Greek_switch", "65406"),
    ("GDK_KEY_Greek_tau", "2036"),
    ("GDK_KEY_Greek_theta", "2024"),
    ("GDK_KEY_Greek_upsilon", "2037"),
    ("GDK_KEY_Greek_upsilonaccent", "1976"),
    ("GDK_KEY_Greek_upsilonaccentdieresis", "1978"),
    ("GDK_KEY_Greek_upsilondieresis", "1977"),
    ("GDK_KEY_Greek_xi", "2030"),
    ("GDK_KEY_Greek_zeta", "2022"),
    ("GDK_KEY_Green", "269025188"),
    ("GDK_KEY_H", "72"),
    ("GDK_KEY_Hangul", "65329"),
    ("GDK_KEY_Hangul_A", "3775"),
    ("GDK_KEY_Hangul_AE", "3776"),
    ("GDK_KEY_Hangul_AraeA", "3830"),
    ("GDK_KEY_Hangul_AraeAE", "3831"),
    ("GDK_KEY_Hangul_Banja", "65337"),
    ("GDK_KEY_Hangul_Cieuc", "3770"),
    ("GDK_KEY_Hangul_Codeinput", "65335"),
    ("GDK_KEY_Hangul_Dikeud", "3751"),
    ("GDK_KEY_Hangul_E", "3780"),
    ("GDK_KEY_Hangul_EO", "3779"),
    ("GDK_KEY_Hangul_EU", "3793"),
    ("GDK_KEY_Hangul_End", "65331"),
    ("GDK_KEY_Hangul_Hanja", "65332"),
    ("GDK_KEY_Hangul_Hieuh", "3774"),
    ("GDK_KEY_Hangul_I", "3795"),
    ("GDK_KEY_Hangul_Ieung", "3767"),
    ("GDK_KEY_Hangul_J_Cieuc", "3818"),
    ("GDK_KEY_Hangul_J_Dikeud", "3802"),
    ("GDK_KEY_Hangul_J_Hieuh", "3822"),
    ("GDK_KEY_Hangul_J_Ieung", "3816"),
    ("GDK_KEY_Hangul_J_Jieuj", "3817"),
    ("GDK_KEY_Hangul_J_Khieuq", "3819"),
    ("GDK_KEY_Hangul_J_Kiyeog", "3796"),
    ("GDK_KEY_Hangul_J_KiyeogSios", "3798"),
    ("GDK_KEY_Hangul_J_KkogjiDalrinIeung", "3833"),
    ("GDK_KEY_Hangul_J_Mieum", "3811"),
    ("GDK_KEY_Hangul_J_Nieun", "3799"),
    ("GDK_KEY_Hangul_J_NieunHieuh", "3801"),
    ("GDK_KEY_Hangul_J_NieunJieuj", "3800"),
    ("GDK_KEY_Hangul_J_PanSios", "3832"),
    ("GDK_KEY_Hangul_J_Phieuf", "3821"),
    ("GDK_KEY_Hangul_J_Pieub", "3812"),
    ("GDK_KEY_Hangul_J_PieubSios", "3813"),
    ("GDK_KEY_Hangul_J_Rieul", "3803"),
    ("GDK_KEY_Hangul_J_RieulHieuh", "3810"),
    ("GDK_KEY_Hangul_J_RieulKiyeog", "3804"),
    ("GDK_KEY_Hangul_J_RieulMieum", "3805"),
    ("GDK_KEY_Hangul_J_RieulPhieuf", "3809"),
    ("GDK_KEY_Hangul_J_RieulPieub", "3806"),
    ("GDK_KEY_Hangul_J_RieulSios", "3807"),
    ("GDK_KEY_Hangul_J_RieulTieut", "3808"),
    ("GDK_KEY_Hangul_J_Sios", "3814"),
    ("GDK_KEY_Hangul_J_SsangKiyeog", "3797"),
    ("GDK_KEY_Hangul_J_SsangSios", "3815"),
    ("GDK_KEY_Hangul_J_Tieut", "3820"),
    ("GDK_KEY_Hangul_J_YeorinHieuh", "3834"),
    ("GDK_KEY_Hangul_Jamo", "65333"),
    ("GDK_KEY_Hangul_Jeonja", "65336"),
    ("GDK_KEY_Hangul_Jieuj", "3768"),
    ("GDK_KEY_Hangul_Khieuq", "3771"),
    ("GDK_KEY_Hangul_Kiyeog", "3745"),
    ("GDK_KEY_Hangul_KiyeogSios", "3747"),
    ("GDK_KEY_Hangul_KkogjiDalrinIeung", "3827"),
    ("GDK_KEY_Hangul_Mieum", "3761"),
    ("GDK_KEY_Hangul_MultipleCandidate", "65341"),
    ("GDK_KEY_Hangul_Nieun", "3748"),
    ("GDK_KEY_Hangul_NieunHieuh", "3750"),
    ("GDK_KEY_Hangul_NieunJieuj", "3749"),
    ("GDK_KEY_Hangul_O", "3783"),
    ("GDK_KEY_Hangul_OE", "3786"),
    ("GDK_KEY_Hangul_PanSios", "3826"),
    ("GDK_KEY_Hangul_Phieuf", "3773"),
    ("GDK_KEY_Hangul_Pieub", "3762"),
    ("GDK_KEY_Hangul_PieubSios", "3764"),
    ("GDK_KEY_Hangul_PostHanja", "65339"),
    ("GDK_KEY_Hangul_PreHanja", "65338"),
    ("GDK_KEY_Hangul_PreviousCandidate", "65342"),
    ("GDK_KEY_Hangul_Rieul", "3753"),
    ("GDK_KEY_Hangul_RieulHieuh", "3760"),
    ("GDK_KEY_Hangul_RieulKiyeog", "3754"),
    ("GDK_KEY_Hangul_RieulMieum", "3755"),
    ("GDK_KEY_Hangul_RieulPhieuf", "3759"),
    ("GDK_KEY_Hangul_RieulPieub", "3756"),
    ("GDK_KEY_Hangul_RieulSios", "3757"),
    ("GDK_KEY_Hangul_RieulTieut", "3758"),
    ("GDK_KEY_Hangul_RieulYeorinHieuh", "3823"),
    ("GDK_KEY_Hangul_Romaja", "65334"),
    ("GDK_KEY_Hangul_SingleCandidate", "65340"),
    ("GDK_KEY_Hangul_Sios", "3765"),
    ("GDK_KEY_Hangul_Special", "65343"),
    ("GDK_KEY_Hangul_SsangDikeud", "3752"),
    ("GDK_KEY_Hangul_SsangJieuj", "3769"),
    ("GDK_KEY_Hangul_SsangKiyeog", "3746"),
    ("GDK_KEY_Hangul_SsangPieub", "3763"),
    ("GDK_KEY_Hangul_SsangSios", "3766"),
    ("GDK_KEY_Hangul_Start", "65330"),
    ("GDK_KEY_Hangul_SunkyeongeumMieum", "3824"),
    ("GDK_KEY_Hangul_SunkyeongeumPhieuf", "3828"),
    ("GDK_KEY_Hangul_SunkyeongeumPieub", "3825"),
    ("GDK_KEY_Hangul_Tieut", "3772"),
    ("GDK_KEY_Hangul_U", "3788"),
    ("GDK_KEY_Hangul_WA", "3784"),
    ("GDK_KEY_Hangul_WAE", "3785"),
    ("GDK_KEY_Hangul_WE", "3790"),
    ("GDK_KEY_Hangul_WEO", "3789"),
    ("GDK_KEY_Hangul_WI", "3791"),
    ("GDK_KEY_Hangul_YA", "3777"),
    ("GDK_KEY_Hangul_YAE", "3778"),
    ("GDK_KEY_Hangul_YE", "3782"),
    ("GDK_KEY_Hangul_YEO", "3781"),
    ("GDK_KEY_Hangul_YI", "3794"),
    ("GDK_KEY_Hangul_YO", "3787"),
    ("GDK_KEY_Hangul_YU", "3792"),
    ("GDK_KEY_Hangul_YeorinHieuh", "3829"),
    ("GDK_KEY_Hangul_switch", "65406"),
    ("GDK_KEY_Hankaku", "65321"),
    ("GDK_KEY_Hcircumflex", "678"),
    ("GDK_KEY_Hebrew_switch", "65406"),
    ("GDK_KEY_Help", "65386"),
    ("GDK_KEY_Henkan", "65315"),
    ("GDK_KEY_Henkan_Mode", "65315"),
    ("GDK_KEY_Hibernate", "269025192"),
    ("GDK_KEY_Hiragana", "65317"),
    ("GDK_KEY_Hiragana_Katakana", "65319"),
    ("GDK_KEY_History", "269025079"),
    ("GDK_KEY_Home", "65360"),
    ("GDK_KEY_HomePage", "269025048"),
    ("GDK_KEY_HotLinks", "269025082"),
    ("GDK_KEY_Hstroke", "673"),
    ("GDK_KEY_Hyper_L", "65517"),
    ("GDK_KEY_Hyper_R", "65518"),
    ("GDK_KEY_I", "73"),
    ("GDK_KEY_ISO_Center_Object", "65075"),
    ("GDK_KEY_ISO_Continuous_Underline", "65072"),
    ("GDK_KEY_ISO_Discontinuous_Underline", "65073"),
    ("GDK_KEY_ISO_Emphasize", "65074"),
    ("GDK_KEY_ISO_Enter", "65076"),
    ("GDK_KEY_ISO_Fast_Cursor_Down", "65071"),
    ("GDK_KEY_ISO_Fast_Cursor_Left", "65068"),
    ("GDK_KEY_ISO_Fast_Cursor_Right", "65069"),
    ("GDK_KEY_ISO_Fast_Cursor_Up", "65070"),
    ("GDK_KEY_ISO_First_Group", "65036"),
    ("GDK_KEY_ISO_First_Group_Lock", "65037"),
    ("GDK_KEY_ISO_Group_Latch", "65030"),
    ("GDK_KEY_ISO_Group_Lock", "65031"),
    ("GDK_KEY_ISO_Group_Shift", "65406"),
    ("GDK_KEY_ISO_Last_Group", "65038"),
    ("GDK_KEY_ISO_Last_Group_Lock", "65039"),
    ("GDK_KEY_ISO_Left_Tab", "65056"),
    ("GDK_KEY_ISO_Level2_Latch", "65026"),
    ("GDK_KEY_ISO_Level3_Latch", "65028"),
    ("GDK_KEY_ISO_Level3_Lock", "65029"),
    ("GDK_KEY_ISO_Level3_Shift", "65027"),
    ("GDK_KEY_ISO_Level5_Latch", "65042"),
    ("GDK_KEY_ISO_Level5_Lock", "65043"),
    ("GDK_KEY_ISO_Level5_Shift", "65041"),
    ("GDK_KEY_ISO_Lock", "65025"),
    ("GDK_KEY_ISO_Move_Line_Down", "65058"),
    ("GDK_KEY_ISO_Move_Line_Up", "65057"),
    ("GDK_KEY_ISO_Next_Group", "65032"),
    ("GDK_KEY_ISO_Next_Group_Lock", "65033"),
    ("GDK_KEY_ISO_Partial_Line_Down", "65060"),
    ("GDK_KEY_ISO_Partial_Line_Up", "65059"),
    ("GDK_KEY_ISO_Partial_Space_Left", "65061"),
    ("GDK_KEY_ISO_Partial_Space_Right", "65062"),
    ("GDK_KEY_ISO_Prev_Group", "65034"),
    ("GDK_KEY_ISO_Prev_Group_Lock", "65035"),
    ("GDK_KEY_ISO_Release_Both_Margins", "65067"),
    ("GDK_KEY_ISO_Release_Margin_Left", "65065"),
    ("GDK_KEY_ISO_Release_Margin_Right", "65066"),
    ("GDK_KEY_ISO_Set_Margin_Left", "65063"),
    ("GDK_KEY_ISO_Set_Margin_Right", "65064"),
    ("GDK_KEY_Iabovedot", "681"),
    ("GDK_KEY_Iacute", "205"),
    ("GDK_KEY_Ibelowdot", "16785098"),
    ("GDK_KEY_Ibreve", "16777516"),
    ("GDK_KEY_Icircumflex", "206"),
    ("GDK_KEY_Idiaeresis", "207"),
    ("GDK_KEY_Igrave", "204"),
    ("GDK_KEY_Ihook", "16785096"),
    ("GDK_KEY_Imacron", "975"),
    ("GDK_KEY_Insert", "65379"),
    ("GDK_KEY_Iogonek", "967"),
    ("GDK_KEY_Itilde", "933"),
    ("GDK_KEY_J", "74"),
    ("GDK_KEY_Jcircumflex", "684"),
    ("GDK_KEY_K", "75"),
    ("GDK_KEY_KP_0", "65456"),
    ("GDK_KEY_KP_1", "65457"),
    ("GDK_KEY_KP_2", "65458"),
    ("GDK_KEY_KP_3", "65459"),
    ("GDK_KEY_KP_4", "65460"),
    ("GDK_KEY_KP_5", "65461"),
    ("GDK_KEY_KP_6", "65462"),
    ("GDK_KEY_KP_7", "65463"),
    ("GDK_KEY_KP_8", "65464"),
    ("GDK_KEY_KP_9", "65465"),
    ("GDK_KEY_KP_Add", "65451"),
    ("GDK_KEY_KP_Begin", "65437"),
    ("GDK_KEY_KP_Decimal", "65454"),
    ("GDK_KEY_KP_Delete", "65439"),
    ("GDK_KEY_KP_Divide", "65455"),
    ("GDK_KEY_KP_Down", "65433"),
    ("GDK_KEY_KP_End", "65436"),
    ("GDK_KEY_KP_Enter", "65421"),
    ("GDK_KEY_KP_Equal", "65469"),
    ("GDK_KEY_KP_F1", "65425"),
    ("GDK_KEY_KP_F2", "65426"),
    ("GDK_KEY_KP_F3", "65427"),
    ("GDK_KEY_KP_F4", "65428"),
    ("GDK_KEY_KP_Home", "65429"),
    ("GDK_KEY_KP_Insert", "65438"),
    ("GDK_KEY_KP_Left", "65430"),
    ("GDK_KEY_KP_Multiply", "65450"),
    ("GDK_KEY_KP_Next", "65435"),
    ("GDK_KEY_KP_Page_Down", "65435"),
    ("GDK_KEY_KP_Page_Up", "65434"),
    ("GDK_KEY_KP_Prior", "65434"),
    ("GDK_KEY_KP_Right", "65432"),
    ("GDK_KEY_KP_Separator", "65452"),
    ("GDK_KEY_KP_Space", "65408"),
    ("GDK_KEY_KP_Subtract", "65453"),
    ("GDK_KEY_KP_Tab", "65417"),
    ("GDK_KEY_KP_Up", "65431"),
    ("GDK_KEY_Kana_Lock", "65325"),
    ("GDK_KEY_Kana_Shift", "65326"),
    ("GDK_KEY_Kanji", "65313"),
    ("GDK_KEY_Kanji_Bangou", "65335"),
    ("GDK_KEY_Katakana", "65318"),
    ("GDK_KEY_KbdBrightnessDown", "269025030"),
    ("GDK_KEY_KbdBrightnessUp", "269025029"),
    ("GDK_KEY_KbdLightOnOff", "269025028"),
    ("GDK_KEY_Kcedilla", "979"),
    ("GDK_KEY_Keyboard", "269025203"),
    ("GDK_KEY_Korean_Won", "3839"),
    ("GDK_KEY_L", "76"),
    ("GDK_KEY_L1", "65480"),
    ("GDK_KEY_L10", "65489"),
    ("GDK_KEY_L2", "65481"),
    ("GDK_KEY_L3", "65482"),
    ("GDK_KEY_L4", "65483"),
    ("GDK_KEY_L5", "65484"),
    ("GDK_KEY_L6", "65485"),
    ("GDK_KEY_L7", "65486"),
    ("GDK_KEY_L8", "65487"),
    ("GDK_KEY_L9", "65488"),
    ("GDK_KEY_Lacute", "453"),
    ("GDK_KEY_Last_Virtual_Screen", "65236"),
    ("GDK_KEY_Launch0", "269025088"),
    ("GDK_KEY_Launch1", "269025089"),
    ("GDK_KEY_Launch2", "269025090"),
    ("GDK_KEY_Launch3", "269025091"),
    ("GDK_KEY_Launch4", "269025092"),
    ("GDK_KEY_Launch5", "269025093"),
    ("GDK_KEY_Launch6", "269025094"),
    ("GDK_KEY_Launch7", "269025095"),
    ("GDK_KEY_Launch8", "269025096"),
    ("GDK_KEY_Launch9", "269025097"),
    ("GDK_KEY_LaunchA", "269025098"),
    ("GDK_KEY_LaunchB", "269025099"),
    ("GDK_KEY_LaunchC", "269025100"),
    ("GDK_KEY_LaunchD", "269025101"),
    ("GDK_KEY_LaunchE", "269025102"),
    ("GDK_KEY_LaunchF", "269025103"),
    ("GDK_KEY_Lbelowdot", "16784950"),
    ("GDK_KEY_Lcaron", "421"),
    ("GDK_KEY_Lcedilla", "934"),
    ("GDK_KEY_Left", "65361"),
    ("GDK_KEY_LightBulb", "269025077"),
    ("GDK_KEY_Linefeed", "65290"),
    ("GDK_KEY_LiraSign", "16785572"),
    ("GDK_KEY_LogGrabInfo", "269024805"),
    ("GDK_KEY_LogOff", "269025121"),
    ("GDK_KEY_LogWindowTree", "269024804"),
    ("GDK_KEY_Lstroke", "419"),
    ("GDK_KEY_M", "77"),
    ("(gint) GDK_KEY_MATCH_EXACT", "2"),
    ("(gint) GDK_KEY_MATCH_NONE", "0"),
    ("(gint) GDK_KEY_MATCH_PARTIAL", "1"),
    ("GDK_KEY_Mabovedot", "16784960"),
    ("GDK_KEY_Macedonia_DSE", "1717"),
    ("GDK_KEY_Macedonia_GJE", "1714"),
    ("GDK_KEY_Macedonia_KJE", "1724"),
    ("GDK_KEY_Macedonia_dse", "1701"),
    ("GDK_KEY_Macedonia_gje", "1698"),
    ("GDK_KEY_Macedonia_kje", "1708"),
    ("GDK_KEY_Mae_Koho", "65342"),
    ("GDK_KEY_Mail", "269025049"),
    ("GDK_KEY_MailForward", "269025168"),
    ("GDK_KEY_Market", "269025122"),
    ("GDK_KEY_Massyo", "65324"),
    ("GDK_KEY_Meeting", "269025123"),
    ("GDK_KEY_Memo", "269025054"),
    ("GDK_KEY_Menu", "65383"),
    ("GDK_KEY_MenuKB", "269025125"),
    ("GDK_KEY_MenuPB", "269025126"),
    ("GDK_KEY_Messenger", "269025166"),
    ("GDK_KEY_Meta_L", "65511"),
    ("GDK_KEY_Meta_R", "65512"),
    ("GDK_KEY_MillSign", "16785573"),
    ("GDK_KEY_ModeLock", "269025025"),
    ("GDK_KEY_Mode_switch", "65406"),
    ("GDK_KEY_MonBrightnessDown", "269025027"),
    ("GDK_KEY_MonBrightnessUp", "269025026"),
    ("GDK_KEY_MouseKeys_Accel_Enable", "65143"),
    ("GDK_KEY_MouseKeys_Enable", "65142"),
    ("GDK_KEY_Muhenkan", "65314"),
    ("GDK_KEY_Multi_key", "65312"),
    ("GDK_KEY_MultipleCandidate", "65341"),
    ("GDK_KEY_Music", "269025170"),
    ("GDK_KEY_MyComputer", "269025075"),
    ("GDK_KEY_MySites", "269025127"),
    ("GDK_KEY_N", "78"),
    ("GDK_KEY_Nacute", "465"),
    ("GDK_KEY_NairaSign", "16785574"),
    ("GDK_KEY_Ncaron", "466"),
    ("GDK_KEY_Ncedilla", "977"),
    ("GDK_KEY_New", "269025128"),
    ("GDK_KEY_NewSheqelSign", "16785578"),
    ("GDK_KEY_News", "269025129"),
    ("GDK_KEY_Next", "65366"),
    ("GDK_KEY_Next_VMode", "269024802"),
    ("GDK_KEY_Next_Virtual_Screen", "65234"),
    ("GDK_KEY_Ntilde", "209"),
    ("GDK_KEY_Num_Lock", "65407"),
    ("GDK_KEY_O", "79"),
    ("GDK_KEY_OE", "5052"),
    ("GDK_KEY_Oacute", "211"),
    ("GDK_KEY_Obarred", "16777631"),
    ("GDK_KEY_Obelowdot", "16785100"),
    ("GDK_KEY_Ocaron", "16777681"),
    ("GDK_KEY_Ocircumflex", "212"),
    ("GDK_KEY_Ocircumflexacute", "16785104"),
    ("GDK_KEY_Ocircumflexbelowdot", "16785112"),
    ("GDK_KEY_Ocircumflexgrave", "16785106"),
    ("GDK_KEY_Ocircumflexhook", "16785108"),
    ("GDK_KEY_Ocircumflextilde", "16785110"),
    ("GDK_KEY_Odiaeresis", "214"),
    ("GDK_KEY_Odoubleacute", "469"),
    ("GDK_KEY_OfficeHome", "269025130"),
    ("GDK_KEY_Ograve", "210"),
    ("GDK_KEY_Ohook", "16785102"),
    ("GDK_KEY_Ohorn", "16777632"),
    ("GDK_KEY_Ohornacute", "16785114"),
    ("GDK_KEY_Ohornbelowdot", "16785122"),
    ("GDK_KEY_Ohorngrave", "16785116"),
    ("GDK_KEY_Ohornhook", "16785118"),
    ("GDK_KEY_Ohorntilde", "16785120"),
    ("GDK_KEY_Omacron", "978"),
    ("GDK_KEY_Ooblique", "216"),
    ("GDK_KEY_Open", "269025131"),
    ("GDK_KEY_OpenURL", "269025080"),
    ("GDK_KEY_Option", "269025132"),
    ("GDK_KEY_Oslash", "216"),
    ("GDK_KEY_Otilde", "213"),
    ("GDK_KEY_Overlay1_Enable", "65144"),
    ("GDK_KEY_Overlay2_Enable", "65145"),
    ("GDK_KEY_P", "80"),
    ("(gint) GDK_KEY_PRESS", "4"),
    ("GDK_KEY_Pabovedot", "16784982"),
    ("GDK_KEY_Page_Down", "65366"),
    ("GDK_KEY_Page_Up", "65365"),
    ("GDK_KEY_Paste", "269025133"),
    ("GDK_KEY_Pause", "65299"),
    ("GDK_KEY_PesetaSign", "16785575"),
    ("GDK_KEY_Phone", "269025134"),
    ("GDK_KEY_Pictures", "269025169"),
    ("GDK_KEY_Pointer_Accelerate", "65274"),
    ("GDK_KEY_Pointer_Button1", "65257"),
    ("GDK_KEY_Pointer_Button2", "65258"),
    ("GDK_KEY_Pointer_Button3", "65259"),
    ("GDK_KEY_Pointer_Button4", "65260"),
    ("GDK_KEY_Pointer_Button5", "65261"),
    ("GDK_KEY_Pointer_Button_Dflt", "65256"),
    ("GDK_KEY_Pointer_DblClick1", "65263"),
    ("GDK_KEY_Pointer_DblClick2", "65264"),
    ("GDK_KEY_Pointer_DblClick3", "65265"),
    ("GDK_KEY_Pointer_DblClick4", "65266"),
    ("GDK_KEY_Pointer_DblClick5", "65267"),
    ("GDK_KEY_Pointer_DblClick_Dflt", "65262"),
    ("GDK_KEY_Pointer_DfltBtnNext", "65275"),
    ("GDK_KEY_Pointer_DfltBtnPrev", "65276"),
    ("GDK_KEY_Pointer_Down", "65251"),
    ("GDK_KEY_Pointer_DownLeft", "65254"),
    ("GDK_KEY_Pointer_DownRight", "65255"),
    ("GDK_KEY_Pointer_Drag1", "65269"),
    ("GDK_KEY_Pointer_Drag2", "65270"),
    ("GDK_KEY_Pointer_Drag3", "65271"),
    ("GDK_KEY_Pointer_Drag4", "65272"),
    ("GDK_KEY_Pointer_Drag5", "65277"),
    ("GDK_KEY_Pointer_Drag_Dflt", "65268"),
    ("GDK_KEY_Pointer_EnableKeys", "65273"),
    ("GDK_KEY_Pointer_Left", "65248"),
    ("GDK_KEY_Pointer_Right", "65249"),
    ("GDK_KEY_Pointer_Up", "65250"),
    ("GDK_KEY_Pointer_UpLeft", "65252"),
    ("GDK_KEY_Pointer_UpRight", "65253"),
    ("GDK_KEY_PowerDown", "269025057"),
    ("GDK_KEY_PowerOff", "269025066"),
    ("GDK_KEY_Prev_VMode", "269024803"),
    ("GDK_KEY_Prev_Virtual_Screen", "65233"),
    ("GDK_KEY_PreviousCandidate", "65342"),
    ("GDK_KEY_Print", "65377"),
    ("GDK_KEY_Prior", "65365"),
    ("GDK_KEY_Q", "81"),
    ("GDK_KEY_R", "82"),
    ("GDK_KEY_R1", "65490"),
    ("GDK_KEY_R10", "65499"),
    ("GDK_KEY_R11", "65500"),
    ("GDK_KEY_R12", "65501"),
    ("GDK_KEY_R13", "65502"),
    ("GDK_KEY_R14", "65503"),
    ("GDK_KEY_R15", "65504"),
    ("GDK_KEY_R2", "65491"),
    ("GDK_KEY_R3", "65492"),
    ("GDK_KEY_R4", "65493"),
    ("GDK_KEY_R5", "65494"),
    ("GDK_KEY_R6", "65495"),
    ("GDK_KEY_R7", "65496"),
    ("GDK_KEY_R8", "65497"),
    ("GDK_KEY_R9", "65498"),
    ("(gint) GDK_KEY_RELEASE", "5"),
    ("GDK_KEY_RFKill", "269025205"),
    ("GDK_KEY_Racute", "448"),
    ("GDK_KEY_Rcaron", "472"),
    ("GDK_KEY_Rcedilla", "931"),
    ("GDK_KEY_Red", "269025187"),
    ("GDK_KEY_Redo", "65382"),
    ("GDK_KEY_Refresh", "269025065"),
    ("GDK_KEY_Reload", "269025139"),
    ("GDK_KEY_RepeatKeys_Enable", "65138"),
    ("GDK_KEY_Reply", "269025138"),
    ("GDK_KEY_Return", "65293"),
    ("GDK_KEY_Right", "65363"),
    ("GDK_KEY_RockerDown", "269025060"),
    ("GDK_KEY_RockerEnter", "269025061"),
    ("GDK_KEY_RockerUp", "269025059"),
    ("GDK_KEY_Romaji", "65316"),
    ("GDK_KEY_RotateWindows", "269025140"),
    ("GDK_KEY_RotationKB", "269025142"),
    ("GDK_KEY_RotationPB", "269025141"),
    ("GDK_KEY_RupeeSign", "16785576"),
    ("GDK_KEY_S", "83"),
    ("GDK_KEY_SCHWA", "16777615"),
    ("GDK_KEY_Sabovedot", "16784992"),
    ("GDK_KEY_Sacute", "422"),
    ("GDK_KEY_Save", "269025143"),
    ("GDK_KEY_Scaron", "425"),
    ("GDK_KEY_Scedilla", "426"),
    ("GDK_KEY_Scircumflex", "734"),
    ("GDK_KEY_ScreenSaver", "269025069"),
    ("GDK_KEY_ScrollClick", "269025146"),
    ("GDK_KEY_ScrollDown", "269025145"),
    ("GDK_KEY_ScrollUp", "269025144"),
    ("GDK_KEY_Scroll_Lock", "65300"),
    ("GDK_KEY_Search", "269025051"),
    ("GDK_KEY_Select", "65376"),
    ("GDK_KEY_SelectButton", "269025184"),
    ("GDK_KEY_Send", "269025147"),
    ("GDK_KEY_Serbian_DJE", "1713"),
    ("GDK_KEY_Serbian_DZE", "1727"),
    ("GDK_KEY_Serbian_JE", "1720"),
    ("GDK_KEY_Serbian_LJE", "1721"),
    ("GDK_KEY_Serbian_NJE", "1722"),
    ("GDK_KEY_Serbian_TSHE", "1723"),
    ("GDK_KEY_Serbian_dje", "1697"),
    ("GDK_KEY_Serbian_dze", "1711"),
    ("GDK_KEY_Serbian_je", "1704"),
    ("GDK_KEY_Serbian_lje", "1705"),
    ("GDK_KEY_Serbian_nje", "1706"),
    ("GDK_KEY_Serbian_tshe", "1707"),
    ("GDK_KEY_Shift_L", "65505"),
    ("GDK_KEY_Shift_Lock", "65510"),
    ("GDK_KEY_Shift_R", "65506"),
    ("GDK_KEY_Shop", "269025078"),
    ("GDK_KEY_SingleCandidate", "65340"),
    ("GDK_KEY_Sinh_a", "16780677"),
    ("GDK_KEY_Sinh_aa", "16780678"),
    ("GDK_KEY_Sinh_aa2", "16780751"),
    ("GDK_KEY_Sinh_ae", "16780679"),
    ("GDK_KEY_Sinh_ae2", "16780752"),
    ("GDK_KEY_Sinh_aee", "16780680"),
    ("GDK_KEY_Sinh_aee2", "16780753"),
    ("GDK_KEY_Sinh_ai", "16780691"),
    ("GDK_KEY_Sinh_ai2", "16780763"),
    ("GDK_KEY_Sinh_al", "16780746"),
    ("GDK_KEY_Sinh_au", "16780694"),
    ("GDK_KEY_Sinh_au2", "16780766"),
    ("GDK_KEY_Sinh_ba", "16780726"),
    ("GDK_KEY_Sinh_bha", "16780727"),
    ("GDK_KEY_Sinh_ca", "16780704"),
    ("GDK_KEY_Sinh_cha", "16780705"),
    ("GDK_KEY_Sinh_dda", "16780713"),
    ("GDK_KEY_Sinh_ddha", "16780714"),
    ("GDK_KEY_Sinh_dha", "16780719"),
    ("GDK_KEY_Sinh_dhha", "16780720"),
    ("GDK_KEY_Sinh_e", "16780689"),
    ("GDK_KEY_Sinh_e2", "16780761"),
    ("GDK_KEY_Sinh_ee", "16780690"),
    ("GDK_KEY_Sinh_ee2", "16780762"),
    ("GDK_KEY_Sinh_fa", "16780742"),
    ("GDK_KEY_Sinh_ga", "16780700"),
    ("GDK_KEY_Sinh_gha", "16780701"),
    ("GDK_KEY_Sinh_h2", "16780675"),
    ("GDK_KEY_Sinh_ha", "16780740"),
    ("GDK_KEY_Sinh_i", "16780681"),
    ("GDK_KEY_Sinh_i2", "16780754"),
    ("GDK_KEY_Sinh_ii", "16780682"),
    ("GDK_KEY_Sinh_ii2", "16780755"),
    ("GDK_KEY_Sinh_ja", "16780706"),
    ("GDK_KEY_Sinh_jha", "16780707"),
    ("GDK_KEY_Sinh_jnya", "16780709"),
    ("GDK_KEY_Sinh_ka", "16780698"),
    ("GDK_KEY_Sinh_kha", "16780699"),
    ("GDK_KEY_Sinh_kunddaliya", "16780788"),
    ("GDK_KEY_Sinh_la", "16780733"),
    ("GDK_KEY_Sinh_lla", "16780741"),
    ("GDK_KEY_Sinh_lu", "16780687"),
    ("GDK_KEY_Sinh_lu2", "16780767"),
    ("GDK_KEY_Sinh_luu", "16780688"),
    ("GDK_KEY_Sinh_luu2", "16780787"),
    ("GDK_KEY_Sinh_ma", "16780728"),
    ("GDK_KEY_Sinh_mba", "16780729"),
    ("GDK_KEY_Sinh_na", "16780721"),
    ("GDK_KEY_Sinh_ndda", "16780716"),
    ("GDK_KEY_Sinh_ndha", "16780723"),
    ("GDK_KEY_Sinh_ng", "16780674"),
    ("GDK_KEY_Sinh_ng2", "16780702"),
    ("GDK_KEY_Sinh_nga", "16780703"),
    ("GDK_KEY_Sinh_nja", "16780710"),
    ("GDK_KEY_Sinh_nna", "16780715"),
    ("GDK_KEY_Sinh_nya", "16780708"),
    ("GDK_KEY_Sinh_o", "16780692"),
    ("GDK_KEY_Sinh_o2", "16780764"),
    ("GDK_KEY_Sinh_oo", "16780693"),
    ("GDK_KEY_Sinh_oo2", "16780765"),
    ("GDK_KEY_Sinh_pa", "16780724"),
    ("GDK_KEY_Sinh_pha", "16780725"),
    ("GDK_KEY_Sinh_ra", "16780731"),
    ("GDK_KEY_Sinh_ri", "16780685"),
    ("GDK_KEY_Sinh_rii", "16780686"),
    ("GDK_KEY_Sinh_ru2", "16780760"),
    ("GDK_KEY_Sinh_ruu2", "16780786"),
    ("GDK_KEY_Sinh_sa", "16780739"),
    ("GDK_KEY_Sinh_sha", "16780737"),
    ("GDK_KEY_Sinh_ssha", "16780738"),
    ("GDK_KEY_Sinh_tha", "16780717"),
    ("GDK_KEY_Sinh_thha", "16780718"),
    ("GDK_KEY_Sinh_tta", "16780711"),
    ("GDK_KEY_Sinh_ttha", "16780712"),
    ("GDK_KEY_Sinh_u", "16780683"),
    ("GDK_KEY_Sinh_u2", "16780756"),
    ("GDK_KEY_Sinh_uu", "16780684"),
    ("GDK_KEY_Sinh_uu2", "16780758"),
    ("GDK_KEY_Sinh_va", "16780736"),
    ("GDK_KEY_Sinh_ya", "16780730"),
    ("GDK_KEY_Sleep", "269025071"),
    ("GDK_KEY_SlowKeys_Enable", "65139"),
    ("GDK_KEY_Spell", "269025148"),
    ("GDK_KEY_SplitScreen", "269025149"),
    ("GDK_KEY_Standby", "269025040"),
    ("GDK_KEY_Start", "269025050"),
    ("GDK_KEY_StickyKeys_Enable", "65141"),
    ("GDK_KEY_Stop", "269025064"),
    ("GDK_KEY_Subtitle", "269025178"),
    ("GDK_KEY_Super_L", "65515"),
    ("GDK_KEY_Super_R", "65516"),
    ("GDK_KEY_Support", "269025150"),
    ("GDK_KEY_Suspend", "269025191"),
    ("GDK_KEY_Switch_VT_1", "269024769"),
    ("GDK_KEY_Switch_VT_10", "269024778"),
    ("GDK_KEY_Switch_VT_11", "269024779"),
    ("GDK_KEY_Switch_VT_12", "269024780"),
    ("GDK_KEY_Switch_VT_2", "269024770"),
    ("GDK_KEY_Switch_VT_3", "269024771"),
    ("GDK_KEY_Switch_VT_4", "269024772"),
    ("GDK_KEY_Switch_VT_5", "269024773"),
    ("GDK_KEY_Switch_VT_6", "269024774"),
    ("GDK_KEY_Switch_VT_7", "269024775"),
    ("GDK_KEY_Switch_VT_8", "269024776"),
    ("GDK_KEY_Switch_VT_9", "269024777"),
    ("GDK_KEY_Sys_Req", "65301"),
    ("GDK_KEY_T", "84"),
    ("GDK_KEY_THORN", "222"),
    ("GDK_KEY_Tab", "65289"),
    ("GDK_KEY_Tabovedot", "16785002"),
    ("GDK_KEY_TaskPane", "269025151"),
    ("GDK_KEY_Tcaron", "427"),
    ("GDK_KEY_Tcedilla", "478"),
    ("GDK_KEY_Terminal", "269025152"),
    ("GDK_KEY_Terminate_Server", "65237"),
    ("GDK_KEY_Thai_baht", "3551"),
    ("GDK_KEY_Thai_bobaimai", "3514"),
    ("GDK_KEY_Thai_chochan", "3496"),
    ("GDK_KEY_Thai_chochang", "3498"),
    ("GDK_KEY_Thai_choching", "3497"),
    ("GDK_KEY_Thai_chochoe", "3500"),
    ("GDK_KEY_Thai_dochada", "3502"),
    ("GDK_KEY_Thai_dodek", "3508"),
    ("GDK_KEY_Thai_fofa", "3517"),
    ("GDK_KEY_Thai_fofan", "3519"),
    ("GDK_KEY_Thai_hohip", "3531"),
    ("GDK_KEY_Thai_honokhuk", "3534"),
    ("GDK_KEY_Thai_khokhai", "3490"),
    ("GDK_KEY_Thai_khokhon", "3493"),
    ("GDK_KEY_Thai_khokhuat", "3491"),
    ("GDK_KEY_Thai_khokhwai", "3492"),
    ("GDK_KEY_Thai_khorakhang", "3494"),
    ("GDK_KEY_Thai_kokai", "3489"),
    ("GDK_KEY_Thai_lakkhangyao", "3557"),
    ("GDK_KEY_Thai_lekchet", "3575"),
    ("GDK_KEY_Thai_lekha", "3573"),
    ("GDK_KEY_Thai_lekhok", "3574"),
    ("GDK_KEY_Thai_lekkao", "3577"),
    ("GDK_KEY_Thai_leknung", "3569"),
    ("GDK_KEY_Thai_lekpaet", "3576"),
    ("GDK_KEY_Thai_leksam", "3571"),
    ("GDK_KEY_Thai_leksi", "3572"),
    ("GDK_KEY_Thai_leksong", "3570"),
    ("GDK_KEY_Thai_leksun", "3568"),
    ("GDK_KEY_Thai_lochula", "3532"),
    ("GDK_KEY_Thai_loling", "3525"),
    ("GDK_KEY_Thai_lu", "3526"),
    ("GDK_KEY_Thai_maichattawa", "3563"),
    ("GDK_KEY_Thai_maiek", "3560"),
    ("GDK_KEY_Thai_maihanakat", "3537"),
    ("GDK_KEY_Thai_maihanakat_maitho", "3550"),
    ("GDK_KEY_Thai_maitaikhu", "3559"),
    ("GDK_KEY_Thai_maitho", "3561"),
    ("GDK_KEY_Thai_maitri", "3562"),
    ("GDK_KEY_Thai_maiyamok", "3558"),
    ("GDK_KEY_Thai_moma", "3521"),
    ("GDK_KEY_Thai_ngongu", "3495"),
    ("GDK_KEY_Thai_nikhahit", "3565"),
    ("GDK_KEY_Thai_nonen", "3507"),
    ("GDK_KEY_Thai_nonu", "3513"),
    ("GDK_KEY_Thai_oang", "3533"),
    ("GDK_KEY_Thai_paiyannoi", "3535"),
    ("GDK_KEY_Thai_phinthu", "3546"),
    ("GDK_KEY_Thai_phophan", "3518"),
    ("GDK_KEY_Thai_phophung", "3516"),
    ("GDK_KEY_Thai_phosamphao", "3520"),
    ("GDK_KEY_Thai_popla", "3515"),
    ("GDK_KEY_Thai_rorua", "3523"),
    ("GDK_KEY_Thai_ru", "3524"),
    ("GDK_KEY_Thai_saraa", "3536"),
    ("GDK_KEY_Thai_saraaa", "3538"),
    ("GDK_KEY_Thai_saraae", "3553"),
    ("GDK_KEY_Thai_saraaimaimalai", "3556"),
    ("GDK_KEY_Thai_saraaimaimuan", "3555"),
    ("GDK_KEY_Thai_saraam", "3539"),
    ("GDK_KEY_Thai_sarae", "3552"),
    ("GDK_KEY_Thai_sarai", "3540"),
    ("GDK_KEY_Thai_saraii", "3541"),
    ("GDK_KEY_Thai_sarao", "3554"),
    ("GDK_KEY_Thai_sarau", "3544"),
    ("GDK_KEY_Thai_saraue", "3542"),
    ("GDK_KEY_Thai_sarauee", "3543"),
    ("GDK_KEY_Thai_sarauu", "3545"),
    ("GDK_KEY_Thai_sorusi", "3529"),
    ("GDK_KEY_Thai_sosala", "3528"),
    ("GDK_KEY_Thai_soso", "3499"),
    ("GDK_KEY_Thai_sosua", "3530"),
    ("GDK_KEY_Thai_thanthakhat", "3564"),
    ("GDK_KEY_Thai_thonangmontho", "3505"),
    ("GDK_KEY_Thai_thophuthao", "3506"),
    ("GDK_KEY_Thai_thothahan", "3511"),
    ("GDK_KEY_Thai_thothan", "3504"),
    ("GDK_KEY_Thai_thothong", "3512"),
    ("GDK_KEY_Thai_thothung", "3510"),
    ("GDK_KEY_Thai_topatak", "3503"),
    ("GDK_KEY_Thai_totao", "3509"),
    ("GDK_KEY_Thai_wowaen", "3527"),
    ("GDK_KEY_Thai_yoyak", "3522"),
    ("GDK_KEY_Thai_yoying", "3501"),
    ("GDK_KEY_Thorn", "222"),
    ("GDK_KEY_Time", "269025183"),
    ("GDK_KEY_ToDoList", "269025055"),
    ("GDK_KEY_Tools", "269025153"),
    ("GDK_KEY_TopMenu", "269025186"),
    ("GDK_KEY_TouchpadOff", "269025201"),
    ("GDK_KEY_TouchpadOn", "269025200"),
    ("GDK_KEY_TouchpadToggle", "269025193"),
    ("GDK_KEY_Touroku", "65323"),
    ("GDK_KEY_Travel", "269025154"),
    ("GDK_KEY_Tslash", "940"),
    ("GDK_KEY_U", "85"),
    ("GDK_KEY_UWB", "269025174"),
    ("GDK_KEY_Uacute", "218"),
    ("GDK_KEY_Ubelowdot", "16785124"),
    ("GDK_KEY_Ubreve", "733"),
    ("GDK_KEY_Ucircumflex", "219"),
    ("GDK_KEY_Udiaeresis", "220"),
    ("GDK_KEY_Udoubleacute", "475"),
    ("GDK_KEY_Ugrave", "217"),
    ("GDK_KEY_Uhook", "16785126"),
    ("GDK_KEY_Uhorn", "16777647"),
    ("GDK_KEY_Uhornacute", "16785128"),
    ("GDK_KEY_Uhornbelowdot", "16785136"),
    ("GDK_KEY_Uhorngrave", "16785130"),
    ("GDK_KEY_Uhornhook", "16785132"),
    ("GDK_KEY_Uhorntilde", "16785134"),
    ("GDK_KEY_Ukrainian_GHE_WITH_UPTURN", "1725"),
    ("GDK_KEY_Ukrainian_I", "1718"),
    ("GDK_KEY_Ukrainian_IE", "1716"),
    ("GDK_KEY_Ukrainian_YI", "1719"),
    ("GDK_KEY_Ukrainian_ghe_with_upturn", "1709"),
    ("GDK_KEY_Ukrainian_i", "1702"),
    ("GDK_KEY_Ukrainian_ie", "1700"),
    ("GDK_KEY_Ukrainian_yi", "1703"),
    ("GDK_KEY_Ukranian_I", "1718"),
    ("GDK_KEY_Ukranian_JE", "1716"),
    ("GDK_KEY_Ukranian_YI", "1719"),
    ("GDK_KEY_Ukranian_i", "1702"),
    ("GDK_KEY_Ukranian_je", "1700"),
    ("GDK_KEY_Ukranian_yi", "1703"),
    ("GDK_KEY_Umacron", "990"),
    ("GDK_KEY_Undo", "65381"),
    ("GDK_KEY_Ungrab", "269024800"),
    ("GDK_KEY_Uogonek", "985"),
    ("GDK_KEY_Up", "65362"),
    ("GDK_KEY_Uring", "473"),
    ("GDK_KEY_User1KB", "269025157"),
    ("GDK_KEY_User2KB", "269025158"),
    ("GDK_KEY_UserPB", "269025156"),
    ("GDK_KEY_Utilde", "989"),
    ("GDK_KEY_V", "86"),
    ("GDK_KEY_VendorHome", "269025076"),
    ("GDK_KEY_Video", "269025159"),
    ("GDK_KEY_View", "269025185"),
    ("GDK_KEY_VoidSymbol", "16777215"),
    ("GDK_KEY_W", "87"),
    ("GDK_KEY_WLAN", "269025173"),
    ("GDK_KEY_WWAN", "269025204"),
    ("GDK_KEY_WWW", "269025070"),
    ("GDK_KEY_Wacute", "16785026"),
    ("GDK_KEY_WakeUp", "269025067"),
    ("GDK_KEY_Wcircumflex", "16777588"),
    ("GDK_KEY_Wdiaeresis", "16785028"),
    ("GDK_KEY_WebCam", "269025167"),
    ("GDK_KEY_Wgrave", "16785024"),
    ("GDK_KEY_WheelButton", "269025160"),
    ("GDK_KEY_WindowClear", "269025109"),
    ("GDK_KEY_WonSign", "16785577"),
    ("GDK_KEY_Word", "269025161"),
    ("GDK_KEY_X", "88"),
    ("GDK_KEY_Xabovedot", "16785034"),
    ("GDK_KEY_Xfer", "269025162"),
    ("GDK_KEY_Y", "89"),
    ("GDK_KEY_Yacute", "221"),
    ("GDK_KEY_Ybelowdot", "16785140"),
    ("GDK_KEY_Ycircumflex", "16777590"),
    ("GDK_KEY_Ydiaeresis", "5054"),
    ("GDK_KEY_Yellow", "269025189"),
    ("GDK_KEY_Ygrave", "16785138"),
    ("GDK_KEY_Yhook", "16785142"),
    ("GDK_KEY_Ytilde", "16785144"),
    ("GDK_KEY_Z", "90"),
    ("GDK_KEY_Zabovedot", "431"),
    ("GDK_KEY_Zacute", "428"),
    ("GDK_KEY_Zcaron", "430"),
    ("GDK_KEY_Zen_Koho", "65341"),
    ("GDK_KEY_Zenkaku", "65320"),
    ("GDK_KEY_Zenkaku_Hankaku", "65322"),
    ("GDK_KEY_ZoomIn", "269025163"),
    ("GDK_KEY_ZoomOut", "269025164"),
    ("GDK_KEY_Zstroke", "16777653"),
    ("GDK_KEY_a", "97"),
    ("GDK_KEY_aacute", "225"),
    ("GDK_KEY_abelowdot", "16785057"),
    ("GDK_KEY_abovedot", "511"),
    ("GDK_KEY_abreve", "483"),
    ("GDK_KEY_abreveacute", "16785071"),
    ("GDK_KEY_abrevebelowdot", "16785079"),
    ("GDK_KEY_abrevegrave", "16785073"),
    ("GDK_KEY_abrevehook", "16785075"),
    ("GDK_KEY_abrevetilde", "16785077"),
    ("GDK_KEY_acircumflex", "226"),
    ("GDK_KEY_acircumflexacute", "16785061"),
    ("GDK_KEY_acircumflexbelowdot", "16785069"),
    ("GDK_KEY_acircumflexgrave", "16785063"),
    ("GDK_KEY_acircumflexhook", "16785065"),
    ("GDK_KEY_acircumflextilde", "16785067"),
    ("GDK_KEY_acute", "180"),
    ("GDK_KEY_adiaeresis", "228"),
    ("GDK_KEY_ae", "230"),
    ("GDK_KEY_agrave", "224"),
    ("GDK_KEY_ahook", "16785059"),
    ("GDK_KEY_amacron", "992"),
    ("GDK_KEY_ampersand", "38"),
    ("GDK_KEY_aogonek", "433"),
    ("GDK_KEY_apostrophe", "39"),
    ("GDK_KEY_approxeq", "16785992"),
    ("GDK_KEY_approximate", "2248"),
    ("GDK_KEY_aring", "229"),
    ("GDK_KEY_asciicircum", "94"),
    ("GDK_KEY_asciitilde", "126"),
    ("GDK_KEY_asterisk", "42"),
    ("GDK_KEY_at", "64"),
    ("GDK_KEY_atilde", "227"),
    ("GDK_KEY_b", "98"),
    ("GDK_KEY_babovedot", "16784899"),
    ("GDK_KEY_backslash", "92"),
    ("GDK_KEY_ballotcross", "2804"),
    ("GDK_KEY_bar", "124"),
    ("GDK_KEY_because", "16785973"),
    ("GDK_KEY_blank", "2527"),
    ("GDK_KEY_botintegral", "2213"),
    ("GDK_KEY_botleftparens", "2220"),
    ("GDK_KEY_botleftsqbracket", "2216"),
    ("GDK_KEY_botleftsummation", "2226"),
    ("GDK_KEY_botrightparens", "2222"),
    ("GDK_KEY_botrightsqbracket", "2218"),
    ("GDK_KEY_botrightsummation", "2230"),
    ("GDK_KEY_bott", "2550"),
    ("GDK_KEY_botvertsummationconnector", "2228"),
    ("GDK_KEY_braceleft", "123"),
    ("GDK_KEY_braceright", "125"),
    ("GDK_KEY_bracketleft", "91"),
    ("GDK_KEY_bracketright", "93"),
    ("GDK_KEY_braille_blank", "16787456"),
    ("GDK_KEY_braille_dot_1", "65521"),
    ("GDK_KEY_braille_dot_10", "65530"),
    ("GDK_KEY_braille_dot_2", "65522"),
    ("GDK_KEY_braille_dot_3", "65523"),
    ("GDK_KEY_braille_dot_4", "65524"),
    ("GDK_KEY_braille_dot_5", "65525"),
    ("GDK_KEY_braille_dot_6", "65526"),
    ("GDK_KEY_braille_dot_7", "65527"),
    ("GDK_KEY_braille_dot_8", "65528"),
    ("GDK_KEY_braille_dot_9", "65529"),
    ("GDK_KEY_braille_dots_1", "16787457"),
    ("GDK_KEY_braille_dots_12", "16787459"),
    ("GDK_KEY_braille_dots_123", "16787463"),
    ("GDK_KEY_braille_dots_1234", "16787471"),
    ("GDK_KEY_braille_dots_12345", "16787487"),
    ("GDK_KEY_braille_dots_123456", "16787519"),
    ("GDK_KEY_braille_dots_1234567", "16787583"),
    ("GDK_KEY_braille_dots_12345678", "16787711"),
    ("GDK_KEY_braille_dots_1234568", "16787647"),
    ("GDK_KEY_braille_dots_123457", "16787551"),
    ("GDK_KEY_braille_dots_1234578", "16787679"),
    ("GDK_KEY_braille_dots_123458", "16787615"),
    ("GDK_KEY_braille_dots_12346", "16787503"),
    ("GDK_KEY_braille_dots_123467", "16787567"),
    ("GDK_KEY_braille_dots_1234678", "16787695"),
    ("GDK_KEY_braille_dots_123468", "16787631"),
    ("GDK_KEY_braille_dots_12347", "16787535"),
    ("GDK_KEY_braille_dots_123478", "16787663"),
    ("GDK_KEY_braille_dots_12348", "16787599"),
    ("GDK_KEY_braille_dots_1235", "16787479"),
    ("GDK_KEY_braille_dots_12356", "16787511"),
    ("GDK_KEY_braille_dots_123567", "16787575"),
    ("GDK_KEY_braille_dots_1235678", "16787703"),
    ("GDK_KEY_braille_dots_123568", "16787639"),
    ("GDK_KEY_braille_dots_12357", "16787543"),
    ("GDK_KEY_braille_dots_123578", "16787671"),
    ("GDK_KEY_braille_dots_12358", "16787607"),
    ("GDK_KEY_braille_dots_1236", "16787495"),
    ("GDK_KEY_braille_dots_12367", "16787559"),
    ("GDK_KEY_braille_dots_123678", "16787687"),
    ("GDK_KEY_braille_dots_12368", "16787623"),
    ("GDK_KEY_braille_dots_1237", "16787527"),
    ("GDK_KEY_braille_dots_12378", "16787655"),
    ("GDK_KEY_braille_dots_1238", "16787591"),
    ("GDK_KEY_braille_dots_124", "16787467"),
    ("GDK_KEY_braille_dots_1245", "16787483"),
    ("GDK_KEY_braille_dots_12456", "16787515"),
    ("GDK_KEY_braille_dots_124567", "16787579"),
    ("GDK_KEY_braille_dots_1245678", "16787707"),
    ("GDK_KEY_braille_dots_124568", "16787643"),
    ("GDK_KEY_braille_dots_12457", "16787547"),
    ("GDK_KEY_braille_dots_124578", "16787675"),
    ("GDK_KEY_braille_dots_12458", "16787611"),
    ("GDK_KEY_braille_dots_1246", "16787499"),
    ("GDK_KEY_braille_dots_12467", "16787563"),
    ("GDK_KEY_braille_dots_124678", "16787691"),
    ("GDK_KEY_braille_dots_12468", "16787627"),
    ("GDK_KEY_braille_dots_1247", "16787531"),
    ("GDK_KEY_braille_dots_12478", "16787659"),
    ("GDK_KEY_braille_dots_1248", "16787595"),
    ("GDK_KEY_braille_dots_125", "16787475"),
    ("GDK_KEY_braille_dots_1256", "16787507"),
    ("GDK_KEY_braille_dots_12567", "16787571"),
    ("GDK_KEY_braille_dots_125678", "16787699"),
    ("GDK_KEY_braille_dots_12568", "16787635"),
    ("GDK_KEY_braille_dots_1257", "16787539"),
    ("GDK_KEY_braille_dots_12578", "16787667"),
    ("GDK_KEY_braille_dots_1258", "16787603"),
    ("GDK_KEY_braille_dots_126", "16787491"),
    ("GDK_KEY_braille_dots_1267", "16787555"),
    ("GDK_KEY_braille_dots_12678", "16787683"),
    ("GDK_KEY_braille_dots_1268", "16787619"),
    ("GDK_KEY_braille_dots_127", "16787523"),
    ("GDK_KEY_braille_dots_1278", "16787651"),
    ("GDK_KEY_braille_dots_128", "16787587"),
    ("GDK_KEY_braille_dots_13", "16787461"),
    ("GDK_KEY_braille_dots_134", "16787469"),
    ("GDK_KEY_braille_dots_1345", "16787485"),
    ("GDK_KEY_braille_dots_13456", "16787517"),
    ("GDK_KEY_braille_dots_134567", "16787581"),
    ("GDK_KEY_braille_dots_1345678", "16787709"),
    ("GDK_KEY_braille_dots_134568", "16787645"),
    ("GDK_KEY_braille_dots_13457", "16787549"),
    ("GDK_KEY_braille_dots_134578", "16787677"),
    ("GDK_KEY_braille_dots_13458", "16787613"),
    ("GDK_KEY_braille_dots_1346", "16787501"),
    ("GDK_KEY_braille_dots_13467", "16787565"),
    ("GDK_KEY_braille_dots_134678", "16787693"),
    ("GDK_KEY_braille_dots_13468", "16787629"),
    ("GDK_KEY_braille_dots_1347", "16787533"),
    ("GDK_KEY_braille_dots_13478", "16787661"),
    ("GDK_KEY_braille_dots_1348", "16787597"),
    ("GDK_KEY_braille_dots_135", "16787477"),
    ("GDK_KEY_braille_dots_1356", "16787509"),
    ("GDK_KEY_braille_dots_13567", "16787573"),
    ("GDK_KEY_braille_dots_135678", "16787701"),
    ("GDK_KEY_braille_dots_13568", "16787637"),
    ("GDK_KEY_braille_dots_1357", "16787541"),
    ("GDK_KEY_braille_dots_13578", "16787669"),
    ("GDK_KEY_braille_dots_1358", "16787605"),
    ("GDK_KEY_braille_dots_136", "16787493"),
    ("GDK_KEY_braille_dots_1367", "16787557"),
    ("GDK_KEY_braille_dots_13678", "16787685"),
    ("GDK_KEY_braille_dots_1368", "16787621"),
    ("GDK_KEY_braille_dots_137", "16787525"),
    ("GDK_KEY_braille_dots_1378", "16787653"),
    ("GDK_KEY_braille_dots_138", "16787589"),
    ("GDK_KEY_braille_dots_14", "16787465"),
    ("GDK_KEY_braille_dots_145", "16787481"),
    ("GDK_KEY_braille_dots_1456", "16787513"),
    ("GDK_KEY_braille_dots_14567", "16787577"),
    ("GDK_KEY_braille_dots_145678", "16787705"),
    ("GDK_KEY_braille_dots_14568", "16787641"),
    ("GDK_KEY_braille_dots_1457", "16787545"),
    ("GDK_KEY_braille_dots_14578", "16787673"),
    ("GDK_KEY_braille_dots_1458", "16787609"),
    ("GDK_KEY_braille_dots_146", "16787497"),
    ("GDK_KEY_braille_dots_1467", "16787561"),
    ("GDK_KEY_braille_dots_14678", "16787689"),
    ("GDK_KEY_braille_dots_1468", "16787625"),
    ("GDK_KEY_braille_dots_147", "16787529"),
    ("GDK_KEY_braille_dots_1478", "16787657"),
    ("GDK_KEY_braille_dots_148", "16787593"),
    ("GDK_KEY_braille_dots_15", "16787473"),
    ("GDK_KEY_braille_dots_156", "16787505"),
    ("GDK_KEY_braille_dots_1567", "16787569"),
    ("GDK_KEY_braille_dots_15678", "16787697"),
    ("GDK_KEY_braille_dots_1568", "16787633"),
    ("GDK_KEY_braille_dots_157", "16787537"),
    ("GDK_KEY_braille_dots_1578", "16787665"),
    ("GDK_KEY_braille_dots_158", "16787601"),
    ("GDK_KEY_braille_dots_16", "16787489"),
    ("GDK_KEY_braille_dots_167", "16787553"),
    ("GDK_KEY_braille_dots_1678", "16787681"),
    ("GDK_KEY_braille_dots_168", "16787617"),
    ("GDK_KEY_braille_dots_17", "16787521"),
    ("GDK_KEY_braille_dots_178", "16787649"),
    ("GDK_KEY_braille_dots_18", "16787585"),
    ("GDK_KEY_braille_dots_2", "16787458"),
    ("GDK_KEY_braille_dots_23", "16787462"),
    ("GDK_KEY_braille_dots_234", "16787470"),
    ("GDK_KEY_braille_dots_2345", "16787486"),
    ("GDK_KEY_braille_dots_23456", "16787518"),
    ("GDK_KEY_braille_dots_234567", "16787582"),
    ("GDK_KEY_braille_dots_2345678", "16787710"),
    ("GDK_KEY_braille_dots_234568", "16787646"),
    ("GDK_KEY_braille_dots_23457", "16787550"),
    ("GDK_KEY_braille_dots_234578", "16787678"),
    ("GDK_KEY_braille_dots_23458", "16787614"),
    ("GDK_KEY_braille_dots_2346", "16787502"),
    ("GDK_KEY_braille_dots_23467", "16787566"),
    ("GDK_KEY_braille_dots_234678", "16787694"),
    ("GDK_KEY_braille_dots_23468", "16787630"),
    ("GDK_KEY_braille_dots_2347", "16787534"),
    ("GDK_KEY_braille_dots_23478", "16787662"),
    ("GDK_KEY_braille_dots_2348", "16787598"),
    ("GDK_KEY_braille_dots_235", "16787478"),
    ("GDK_KEY_braille_dots_2356", "16787510"),
    ("GDK_KEY_braille_dots_23567", "16787574"),
    ("GDK_KEY_braille_dots_235678", "16787702"),
    ("GDK_KEY_braille_dots_23568", "16787638"),
    ("GDK_KEY_braille_dots_2357", "16787542"),
    ("GDK_KEY_braille_dots_23578", "16787670"),
    ("GDK_KEY_braille_dots_2358", "16787606"),
    ("GDK_KEY_braille_dots_236", "16787494"),
    ("GDK_KEY_braille_dots_2367", "16787558"),
    ("GDK_KEY_braille_dots_23678", "16787686"),
    ("GDK_KEY_braille_dots_2368", "16787622"),
    ("GDK_KEY_braille_dots_237", "16787526"),
    ("GDK_KEY_braille_dots_2378", "16787654"),
    ("GDK_KEY_braille_dots_238", "16787590"),
    ("GDK_KEY_braille_dots_24", "16787466"),
    ("GDK_KEY_braille_dots_245", "16787482"),
    ("GDK_KEY_braille_dots_2456", "16787514"),
    ("GDK_KEY_braille_dots_24567", "16787578"),
    ("GDK_KEY_braille_dots_245678", "16787706"),
    ("GDK_KEY_braille_dots_24568", "16787642"),
    ("GDK_KEY_braille_dots_2457", "16787546"),
    ("GDK_KEY_braille_dots_24578", "16787674"),
    ("GDK_KEY_braille_dots_2458", "16787610"),
    ("GDK_KEY_braille_dots_246", "16787498"),
    ("GDK_KEY_braille_dots_2467", "16787562"),
    ("GDK_KEY_braille_dots_24678", "16787690"),
    ("GDK_KEY_braille_dots_2468", "16787626"),
    ("GDK_KEY_braille_dots_247", "16787530"),
    ("GDK_KEY_braille_dots_2478", "16787658"),
    ("GDK_KEY_braille_dots_248", "16787594"),
    ("GDK_KEY_braille_dots_25", "16787474"),
    ("GDK_KEY_braille_dots_256", "16787506"),
    ("GDK_KEY_braille_dots_2567", "16787570"),
    ("GDK_KEY_braille_dots_25678", "16787698"),
    ("GDK_KEY_braille_dots_2568", "16787634"),
    ("GDK_KEY_braille_dots_257", "16787538"),
    ("GDK_KEY_braille_dots_2578", "16787666"),
    ("GDK_KEY_braille_dots_258", "16787602"),
    ("GDK_KEY_braille_dots_26", "16787490"),
    ("GDK_KEY_braille_dots_267", "16787554"),
    ("GDK_KEY_braille_dots_2678", "16787682"),
    ("GDK_KEY_braille_dots_268", "16787618"),
    ("GDK_KEY_braille_dots_27", "16787522"),
    ("GDK_KEY_braille_dots_278", "16787650"),
    ("GDK_KEY_braille_dots_28", "16787586"),
    ("GDK_KEY_braille_dots_3", "16787460"),
    ("GDK_KEY_braille_dots_34", "16787468"),
    ("GDK_KEY_braille_dots_345", "16787484"),
    ("GDK_KEY_braille_dots_3456", "16787516"),
    ("GDK_KEY_braille_dots_34567", "16787580"),
    ("GDK_KEY_braille_dots_345678", "16787708"),
    ("GDK_KEY_braille_dots_34568", "16787644"),
    ("GDK_KEY_braille_dots_3457", "16787548"),
    ("GDK_KEY_braille_dots_34578", "16787676"),
    ("GDK_KEY_braille_dots_3458", "16787612"),
    ("GDK_KEY_braille_dots_346", "16787500"),
    ("GDK_KEY_braille_dots_3467", "16787564"),
    ("GDK_KEY_braille_dots_34678", "16787692"),
    ("GDK_KEY_braille_dots_3468", "16787628"),
    ("GDK_KEY_braille_dots_347", "16787532"),
    ("GDK_KEY_braille_dots_3478", "16787660"),
    ("GDK_KEY_braille_dots_348", "16787596"),
    ("GDK_KEY_braille_dots_35", "16787476"),
    ("GDK_KEY_braille_dots_356", "16787508"),
    ("GDK_KEY_braille_dots_3567", "16787572"),
    ("GDK_KEY_braille_dots_35678", "16787700"),
    ("GDK_KEY_braille_dots_3568", "16787636"),
    ("GDK_KEY_braille_dots_357", "16787540"),
    ("GDK_KEY_braille_dots_3578", "16787668"),
    ("GDK_KEY_braille_dots_358", "16787604"),
    ("GDK_KEY_braille_dots_36", "16787492"),
    ("GDK_KEY_braille_dots_367", "16787556"),
    ("GDK_KEY_braille_dots_3678", "16787684"),
    ("GDK_KEY_braille_dots_368", "16787620"),
    ("GDK_KEY_braille_dots_37", "16787524"),
    ("GDK_KEY_braille_dots_378", "16787652"),
    ("GDK_KEY_braille_dots_38", "16787588"),
    ("GDK_KEY_braille_dots_4", "16787464"),
    ("GDK_KEY_braille_dots_45", "16787480"),
    ("GDK_KEY_braille_dots_456", "16787512"),
    ("GDK_KEY_braille_dots_4567", "16787576"),
    ("GDK_KEY_braille_dots_45678", "16787704"),
    ("GDK_KEY_braille_dots_4568", "16787640"),
    ("GDK_KEY_braille_dots_457", "16787544"),
    ("GDK_KEY_braille_dots_4578", "16787672"),
    ("GDK_KEY_braille_dots_458", "16787608"),
    ("GDK_KEY_braille_dots_46", "16787496"),
    ("GDK_KEY_braille_dots_467", "16787560"),
    ("GDK_KEY_braille_dots_4678", "16787688"),
    ("GDK_KEY_braille_dots_468", "16787624"),
    ("GDK_KEY_braille_dots_47", "16787528"),
    ("GDK_KEY_braille_dots_478", "16787656"),
    ("GDK_KEY_braille_dots_48", "16787592"),
    ("GDK_KEY_braille_dots_5", "16787472"),
    ("GDK_KEY_braille_dots_56", "16787504"),
    ("GDK_KEY_braille_dots_567", "16787568"),
    ("GDK_KEY_braille_dots_5678", "16787696"),
    ("GDK_KEY_braille_dots_568", "16787632"),
    ("GDK_KEY_braille_dots_57", "16787536"),
    ("GDK_KEY_braille_dots_578", "16787664"),
    ("GDK_KEY_braille_dots_58", "16787600"),
    ("GDK_KEY_braille_dots_6", "16787488"),
    ("GDK_KEY_braille_dots_67", "16787552"),
    ("GDK_KEY_braille_dots_678", "16787680"),
    ("GDK_KEY_braille_dots_68", "16787616"),
    ("GDK_KEY_braille_dots_7", "16787520"),
    ("GDK_KEY_braille_dots_78", "16787648"),
    ("GDK_KEY_braille_dots_8", "16787584"),
    ("GDK_KEY_breve", "418"),
    ("GDK_KEY_brokenbar", "166"),
    ("GDK_KEY_c", "99"),
    ("GDK_KEY_c_h", "65187"),
    ("GDK_KEY_cabovedot", "741"),
    ("GDK_KEY_cacute", "486"),
    ("GDK_KEY_careof", "2744"),
    ("GDK_KEY_caret", "2812"),
    ("GDK_KEY_caron", "439"),
    ("GDK_KEY_ccaron", "488"),
    ("GDK_KEY_ccedilla", "231"),
    ("GDK_KEY_ccircumflex", "742"),
    ("GDK_KEY_cedilla", "184"),
    ("GDK_KEY_cent", "162"),
    ("GDK_KEY_ch", "65184"),
    ("GDK_KEY_checkerboard", "2529"),
    ("GDK_KEY_checkmark", "2803"),
    ("GDK_KEY_circle", "3023"),
    ("GDK_KEY_club", "2796"),
    ("GDK_KEY_colon", "58"),
    ("GDK_KEY_combining_acute", "16777985"),
    ("GDK_KEY_combining_belowdot", "16778019"),
    ("GDK_KEY_combining_grave", "16777984"),
    ("GDK_KEY_combining_hook", "16777993"),
    ("GDK_KEY_combining_tilde", "16777987"),
    ("GDK_KEY_comma", "44"),
    ("GDK_KEY_containsas", "16785931"),
    ("GDK_KEY_copyright", "169"),
    ("GDK_KEY_cr", "2532"),
    ("GDK_KEY_crossinglines", "2542"),
    ("GDK_KEY_cuberoot", "16785947"),
    ("GDK_KEY_currency", "164"),
    ("GDK_KEY_cursor", "2815"),
    ("GDK_KEY_d", "100"),
    ("GDK_KEY_dabovedot", "16784907"),
    ("GDK_KEY_dagger", "2801"),
    ("GDK_KEY_dcaron", "495"),
    ("GDK_KEY_dead_A", "65153"),
    ("GDK_KEY_dead_E", "65155"),
    ("GDK_KEY_dead_I", "65157"),
    ("GDK_KEY_dead_O", "65159"),
    ("GDK_KEY_dead_SCHWA", "65163"),
    ("GDK_KEY_dead_U", "65161"),
    ("GDK_KEY_dead_a", "65152"),
    ("GDK_KEY_dead_abovecomma", "65124"),
    ("GDK_KEY_dead_abovedot", "65110"),
    ("GDK_KEY_dead_abovereversedcomma", "65125"),
    ("GDK_KEY_dead_abovering", "65112"),
    ("GDK_KEY_dead_aboveverticalline", "65169"),
    ("GDK_KEY_dead_acute", "65105"),
    ("GDK_KEY_dead_belowbreve", "65131"),
    ("GDK_KEY_dead_belowcircumflex", "65129"),
    ("GDK_KEY_dead_belowcomma", "65134"),
    ("GDK_KEY_dead_belowdiaeresis", "65132"),
    ("GDK_KEY_dead_belowdot", "65120"),
    ("GDK_KEY_dead_belowmacron", "65128"),
    ("GDK_KEY_dead_belowring", "65127"),
    ("GDK_KEY_dead_belowtilde", "65130"),
    ("GDK_KEY_dead_belowverticalline", "65170"),
    ("GDK_KEY_dead_breve", "65109"),
    ("GDK_KEY_dead_capital_schwa", "65163"),
    ("GDK_KEY_dead_caron", "65114"),
    ("GDK_KEY_dead_cedilla", "65115"),
    ("GDK_KEY_dead_circumflex", "65106"),
    ("GDK_KEY_dead_currency", "65135"),
    ("GDK_KEY_dead_dasia", "65125"),
    ("GDK_KEY_dead_diaeresis", "65111"),
    ("GDK_KEY_dead_doubleacute", "65113"),
    ("GDK_KEY_dead_doublegrave", "65126"),
    ("GDK_KEY_dead_e", "65154"),
    ("GDK_KEY_dead_grave", "65104"),
    ("GDK_KEY_dead_greek", "65164"),
    ("GDK_KEY_dead_hamza", "65165"),
    ("GDK_KEY_dead_hook", "65121"),
    ("GDK_KEY_dead_horn", "65122"),
    ("GDK_KEY_dead_i", "65156"),
    ("GDK_KEY_dead_invertedbreve", "65133"),
    ("GDK_KEY_dead_iota", "65117"),
    ("GDK_KEY_dead_longsolidusoverlay", "65171"),
    ("GDK_KEY_dead_lowline", "65168"),
    ("GDK_KEY_dead_macron", "65108"),
    ("GDK_KEY_dead_o", "65158"),
    ("GDK_KEY_dead_ogonek", "65116"),
    ("GDK_KEY_dead_perispomeni", "65107"),
    ("GDK_KEY_dead_psili", "65124"),
    ("GDK_KEY_dead_schwa", "65162"),
    ("GDK_KEY_dead_semivoiced_sound", "65119"),
    ("GDK_KEY_dead_small_schwa", "65162"),
    ("GDK_KEY_dead_stroke", "65123"),
    ("GDK_KEY_dead_tilde", "65107"),
    ("GDK_KEY_dead_u", "65160"),
    ("GDK_KEY_dead_voiced_sound", "65118"),
    ("GDK_KEY_decimalpoint", "2749"),
    ("GDK_KEY_degree", "176"),
    ("GDK_KEY_diaeresis", "168"),
    ("GDK_KEY_diamond", "2797"),
    ("GDK_KEY_digitspace", "2725"),
    ("GDK_KEY_dintegral", "16785964"),
    ("GDK_KEY_division", "247"),
    ("GDK_KEY_dollar", "36"),
    ("GDK_KEY_doubbaselinedot", "2735"),
    ("GDK_KEY_doubleacute", "445"),
    ("GDK_KEY_doubledagger", "2802"),
    ("GDK_KEY_doublelowquotemark", "2814"),
    ("GDK_KEY_downarrow", "2302"),
    ("GDK_KEY_downcaret", "2984"),
    ("GDK_KEY_downshoe", "3030"),
    ("GDK_KEY_downstile", "3012"),
    ("GDK_KEY_downtack", "3010"),
    ("GDK_KEY_dstroke", "496"),
    ("GDK_KEY_e", "101"),
    ("GDK_KEY_eabovedot", "1004"),
    ("GDK_KEY_eacute", "233"),
    ("GDK_KEY_ebelowdot", "16785081"),
    ("GDK_KEY_ecaron", "492"),
    ("GDK_KEY_ecircumflex", "234"),
    ("GDK_KEY_ecircumflexacute", "16785087"),
    ("GDK_KEY_ecircumflexbelowdot", "16785095"),
    ("GDK_KEY_ecircumflexgrave", "16785089"),
    ("GDK_KEY_ecircumflexhook", "16785091"),
    ("GDK_KEY_ecircumflextilde", "16785093"),
    ("GDK_KEY_ediaeresis", "235"),
    ("GDK_KEY_egrave", "232"),
    ("GDK_KEY_ehook", "16785083"),
    ("GDK_KEY_eightsubscript", "16785544"),
    ("GDK_KEY_eightsuperior", "16785528"),
    ("GDK_KEY_elementof", "16785928"),
    ("GDK_KEY_ellipsis", "2734"),
    ("GDK_KEY_em3space", "2723"),
    ("GDK_KEY_em4space", "2724"),
    ("GDK_KEY_emacron", "954"),
    ("GDK_KEY_emdash", "2729"),
    ("GDK_KEY_emfilledcircle", "2782"),
    ("GDK_KEY_emfilledrect", "2783"),
    ("GDK_KEY_emopencircle", "2766"),
    ("GDK_KEY_emopenrectangle", "2767"),
    ("GDK_KEY_emptyset", "16785925"),
    ("GDK_KEY_emspace", "2721"),
    ("GDK_KEY_endash", "2730"),
    ("GDK_KEY_enfilledcircbullet", "2790"),
    ("GDK_KEY_enfilledsqbullet", "2791"),
    ("GDK_KEY_eng", "959"),
    ("GDK_KEY_enopencircbullet", "2784"),
    ("GDK_KEY_enopensquarebullet", "2785"),
    ("GDK_KEY_enspace", "2722"),
    ("GDK_KEY_eogonek", "490"),
    ("GDK_KEY_equal", "61"),
    ("GDK_KEY_eth", "240"),
    ("GDK_KEY_etilde", "16785085"),
    ("GDK_KEY_exclam", "33"),
    ("GDK_KEY_exclamdown", "161"),
    ("GDK_KEY_ezh", "16777874"),
    ("GDK_KEY_f", "102"),
    ("GDK_KEY_fabovedot", "16784927"),
    ("GDK_KEY_femalesymbol", "2808"),
    ("GDK_KEY_ff", "2531"),
    ("GDK_KEY_figdash", "2747"),
    ("GDK_KEY_filledlefttribullet", "2780"),
    ("GDK_KEY_filledrectbullet", "2779"),
    ("GDK_KEY_filledrighttribullet", "2781"),
    ("GDK_KEY_filledtribulletdown", "2793"),
    ("GDK_KEY_filledtribulletup", "2792"),
    ("GDK_KEY_fiveeighths", "2757"),
    ("GDK_KEY_fivesixths", "2743"),
    ("GDK_KEY_fivesubscript", "16785541"),
    ("GDK_KEY_fivesuperior", "16785525"),
    ("GDK_KEY_fourfifths", "2741"),
    ("GDK_KEY_foursubscript", "16785540"),
    ("GDK_KEY_foursuperior", "16785524"),
    ("GDK_KEY_fourthroot", "16785948"),
    ("GDK_KEY_function", "2294"),
    ("GDK_KEY_g", "103"),
    ("GDK_KEY_gabovedot", "757"),
    ("GDK_KEY_gbreve", "699"),
    ("GDK_KEY_gcaron", "16777703"),
    ("GDK_KEY_gcedilla", "955"),
    ("GDK_KEY_gcircumflex", "760"),
    ("GDK_KEY_grave", "96"),
    ("GDK_KEY_greater", "62"),
    ("GDK_KEY_greaterthanequal", "2238"),
    ("GDK_KEY_guillemetleft", "171"),
    ("GDK_KEY_guillemetright", "187"),
    ("GDK_KEY_guillemotleft", "171"),
    ("GDK_KEY_guillemotright", "187"),
    ("GDK_KEY_h", "104"),
    ("GDK_KEY_hairspace", "2728"),
    ("GDK_KEY_hcircumflex", "694"),
    ("GDK_KEY_heart", "2798"),
    ("GDK_KEY_hebrew_aleph", "3296"),
    ("GDK_KEY_hebrew_ayin", "3314"),
    ("GDK_KEY_hebrew_bet", "3297"),
    ("GDK_KEY_hebrew_beth", "3297"),
    ("GDK_KEY_hebrew_chet", "3303"),
    ("GDK_KEY_hebrew_dalet", "3299"),
    ("GDK_KEY_hebrew_daleth", "3299"),
    ("GDK_KEY_hebrew_doublelowline", "3295"),
    ("GDK_KEY_hebrew_finalkaph", "3306"),
    ("GDK_KEY_hebrew_finalmem", "3309"),
    ("GDK_KEY_hebrew_finalnun", "3311"),
    ("GDK_KEY_hebrew_finalpe", "3315"),
    ("GDK_KEY_hebrew_finalzade", "3317"),
    ("GDK_KEY_hebrew_finalzadi", "3317"),
    ("GDK_KEY_hebrew_gimel", "3298"),
    ("GDK_KEY_hebrew_gimmel", "3298"),
    ("GDK_KEY_hebrew_he", "3300"),
    ("GDK_KEY_hebrew_het", "3303"),
    ("GDK_KEY_hebrew_kaph", "3307"),
    ("GDK_KEY_hebrew_kuf", "3319"),
    ("GDK_KEY_hebrew_lamed", "3308"),
    ("GDK_KEY_hebrew_mem", "3310"),
    ("GDK_KEY_hebrew_nun", "3312"),
    ("GDK_KEY_hebrew_pe", "3316"),
    ("GDK_KEY_hebrew_qoph", "3319"),
    ("GDK_KEY_hebrew_resh", "3320"),
    ("GDK_KEY_hebrew_samech", "3313"),
    ("GDK_KEY_hebrew_samekh", "3313"),
    ("GDK_KEY_hebrew_shin", "3321"),
    ("GDK_KEY_hebrew_taf", "3322"),
    ("GDK_KEY_hebrew_taw", "3322"),
    ("GDK_KEY_hebrew_tet", "3304"),
    ("GDK_KEY_hebrew_teth", "3304"),
    ("GDK_KEY_hebrew_waw", "3301"),
    ("GDK_KEY_hebrew_yod", "3305"),
    ("GDK_KEY_hebrew_zade", "3318"),
    ("GDK_KEY_hebrew_zadi", "3318"),
    ("GDK_KEY_hebrew_zain", "3302"),
    ("GDK_KEY_hebrew_zayin", "3302"),
    ("GDK_KEY_hexagram", "2778"),
    ("GDK_KEY_horizconnector", "2211"),
    ("GDK_KEY_horizlinescan1", "2543"),
    ("GDK_KEY_horizlinescan3", "2544"),
    ("GDK_KEY_horizlinescan5", "2545"),
    ("GDK_KEY_horizlinescan7", "2546"),
    ("GDK_KEY_horizlinescan9", "2547"),
    ("GDK_KEY_hstroke", "689"),
    ("GDK_KEY_ht", "2530"),
    ("GDK_KEY_hyphen", "173"),
    ("GDK_KEY_i", "105"),
    ("GDK_KEY_iTouch", "269025120"),
    ("GDK_KEY_iacute", "237"),
    ("GDK_KEY_ibelowdot", "16785099"),
    ("GDK_KEY_ibreve", "16777517"),
    ("GDK_KEY_icircumflex", "238"),
    ("GDK_KEY_identical", "2255"),
    ("GDK_KEY_idiaeresis", "239"),
    ("GDK_KEY_idotless", "697"),
    ("GDK_KEY_ifonlyif", "2253"),
    ("GDK_KEY_igrave", "236"),
    ("GDK_KEY_ihook", "16785097"),
    ("GDK_KEY_imacron", "1007"),
    ("GDK_KEY_implies", "2254"),
    ("GDK_KEY_includedin", "2266"),
    ("GDK_KEY_includes", "2267"),
    ("GDK_KEY_infinity", "2242"),
    ("GDK_KEY_integral", "2239"),
    ("GDK_KEY_intersection", "2268"),
    ("GDK_KEY_iogonek", "999"),
    ("GDK_KEY_itilde", "949"),
    ("GDK_KEY_j", "106"),
    ("GDK_KEY_jcircumflex", "700"),
    ("GDK_KEY_jot", "3018"),
    ("GDK_KEY_k", "107"),
    ("GDK_KEY_kana_A", "1201"),
    ("GDK_KEY_kana_CHI", "1217"),
    ("GDK_KEY_kana_E", "1204"),
    ("GDK_KEY_kana_FU", "1228"),
    ("GDK_KEY_kana_HA", "1226"),
    ("GDK_KEY_kana_HE", "1229"),
    ("GDK_KEY_kana_HI", "1227"),
    ("GDK_KEY_kana_HO", "1230"),
    ("GDK_KEY_kana_HU", "1228"),
    ("GDK_KEY_kana_I", "1202"),
    ("GDK_KEY_kana_KA", "1206"),
    ("GDK_KEY_kana_KE", "1209"),
    ("GDK_KEY_kana_KI", "1207"),
    ("GDK_KEY_kana_KO", "1210"),
    ("GDK_KEY_kana_KU", "1208"),
    ("GDK_KEY_kana_MA", "1231"),
    ("GDK_KEY_kana_ME", "1234"),
    ("GDK_KEY_kana_MI", "1232"),
    ("GDK_KEY_kana_MO", "1235"),
    ("GDK_KEY_kana_MU", "1233"),
    ("GDK_KEY_kana_N", "1245"),
    ("GDK_KEY_kana_NA", "1221"),
    ("GDK_KEY_kana_NE", "1224"),
    ("GDK_KEY_kana_NI", "1222"),
    ("GDK_KEY_kana_NO", "1225"),
    ("GDK_KEY_kana_NU", "1223"),
    ("GDK_KEY_kana_O", "1205"),
    ("GDK_KEY_kana_RA", "1239"),
    ("GDK_KEY_kana_RE", "1242"),
    ("GDK_KEY_kana_RI", "1240"),
    ("GDK_KEY_kana_RO", "1243"),
    ("GDK_KEY_kana_RU", "1241"),
    ("GDK_KEY_kana_SA", "1211"),
    ("GDK_KEY_kana_SE", "1214"),
    ("GDK_KEY_kana_SHI", "1212"),
    ("GDK_KEY_kana_SO", "1215"),
    ("GDK_KEY_kana_SU", "1213"),
    ("GDK_KEY_kana_TA", "1216"),
    ("GDK_KEY_kana_TE", "1219"),
    ("GDK_KEY_kana_TI", "1217"),
    ("GDK_KEY_kana_TO", "1220"),
    ("GDK_KEY_kana_TSU", "1218"),
    ("GDK_KEY_kana_TU", "1218"),
    ("GDK_KEY_kana_U", "1203"),
    ("GDK_KEY_kana_WA", "1244"),
    ("GDK_KEY_kana_WO", "1190"),
    ("GDK_KEY_kana_YA", "1236"),
    ("GDK_KEY_kana_YO", "1238"),
    ("GDK_KEY_kana_YU", "1237"),
    ("GDK_KEY_kana_a", "1191"),
    ("GDK_KEY_kana_closingbracket", "1187"),
    ("GDK_KEY_kana_comma", "1188"),
    ("GDK_KEY_kana_conjunctive", "1189"),
    ("GDK_KEY_kana_e", "1194"),
    ("GDK_KEY_kana_fullstop", "1185"),
    ("GDK_KEY_kana_i", "1192"),
    ("GDK_KEY_kana_middledot", "1189"),
    ("GDK_KEY_kana_o", "1195"),
    ("GDK_KEY_kana_openingbracket", "1186"),
    ("GDK_KEY_kana_switch", "65406"),
    ("GDK_KEY_kana_tsu", "1199"),
    ("GDK_KEY_kana_tu", "1199"),
    ("GDK_KEY_kana_u", "1193"),
    ("GDK_KEY_kana_ya", "1196"),
    ("GDK_KEY_kana_yo", "1198"),
    ("GDK_KEY_kana_yu", "1197"),
    ("GDK_KEY_kappa", "930"),
    ("GDK_KEY_kcedilla", "1011"),
    ("GDK_KEY_kra", "930"),
    ("GDK_KEY_l", "108"),
    ("GDK_KEY_lacute", "485"),
    ("GDK_KEY_latincross", "2777"),
    ("GDK_KEY_lbelowdot", "16784951"),
    ("GDK_KEY_lcaron", "437"),
    ("GDK_KEY_lcedilla", "950"),
    ("GDK_KEY_leftanglebracket", "2748"),
    ("GDK_KEY_leftarrow", "2299"),
    ("GDK_KEY_leftcaret", "2979"),
    ("GDK_KEY_leftdoublequotemark", "2770"),
    ("GDK_KEY_leftmiddlecurlybrace", "2223"),
    ("GDK_KEY_leftopentriangle", "2764"),
    ("GDK_KEY_leftpointer", "2794"),
    ("GDK_KEY_leftradical", "2209"),
    ("GDK_KEY_leftshoe", "3034"),
    ("GDK_KEY_leftsinglequotemark", "2768"),
    ("GDK_KEY_leftt", "2548"),
    ("GDK_KEY_lefttack", "3036"),
    ("GDK_KEY_less", "60"),
    ("GDK_KEY_lessthanequal", "2236"),
    ("GDK_KEY_lf", "2533"),
    ("GDK_KEY_logicaland", "2270"),
    ("GDK_KEY_logicalor", "2271"),
    ("GDK_KEY_lowleftcorner", "2541"),
    ("GDK_KEY_lowrightcorner", "2538"),
    ("GDK_KEY_lstroke", "435"),
    ("GDK_KEY_m", "109"),
    ("GDK_KEY_mabovedot", "16784961"),
    ("GDK_KEY_macron", "175"),
    ("GDK_KEY_malesymbol", "2807"),
    ("GDK_KEY_maltesecross", "2800"),
    ("GDK_KEY_marker", "2751"),
    ("GDK_KEY_masculine", "186"),
    ("GDK_KEY_minus", "45"),
    ("GDK_KEY_minutes", "2774"),
    ("GDK_KEY_mu", "181"),
    ("GDK_KEY_multiply", "215"),
    ("GDK_KEY_musicalflat", "2806"),
    ("GDK_KEY_musicalsharp", "2805"),
    ("GDK_KEY_n", "110"),
    ("GDK_KEY_nabla", "2245"),
    ("GDK_KEY_nacute", "497"),
    ("GDK_KEY_ncaron", "498"),
    ("GDK_KEY_ncedilla", "1009"),
    ("GDK_KEY_ninesubscript", "16785545"),
    ("GDK_KEY_ninesuperior", "16785529"),
    ("GDK_KEY_nl", "2536"),
    ("GDK_KEY_nobreakspace", "160"),
    ("GDK_KEY_notapproxeq", "16785991"),
    ("GDK_KEY_notelementof", "16785929"),
    ("GDK_KEY_notequal", "2237"),
    ("GDK_KEY_notidentical", "16786018"),
    ("GDK_KEY_notsign", "172"),
    ("GDK_KEY_ntilde", "241"),
    ("GDK_KEY_numbersign", "35"),
    ("GDK_KEY_numerosign", "1712"),
    ("GDK_KEY_o", "111"),
    ("GDK_KEY_oacute", "243"),
    ("GDK_KEY_obarred", "16777845"),
    ("GDK_KEY_obelowdot", "16785101"),
    ("GDK_KEY_ocaron", "16777682"),
    ("GDK_KEY_ocircumflex", "244"),
    ("GDK_KEY_ocircumflexacute", "16785105"),
    ("GDK_KEY_ocircumflexbelowdot", "16785113"),
    ("GDK_KEY_ocircumflexgrave", "16785107"),
    ("GDK_KEY_ocircumflexhook", "16785109"),
    ("GDK_KEY_ocircumflextilde", "16785111"),
    ("GDK_KEY_odiaeresis", "246"),
    ("GDK_KEY_odoubleacute", "501"),
    ("GDK_KEY_oe", "5053"),
    ("GDK_KEY_ogonek", "434"),
    ("GDK_KEY_ograve", "242"),
    ("GDK_KEY_ohook", "16785103"),
    ("GDK_KEY_ohorn", "16777633"),
    ("GDK_KEY_ohornacute", "16785115"),
    ("GDK_KEY_ohornbelowdot", "16785123"),
    ("GDK_KEY_ohorngrave", "16785117"),
    ("GDK_KEY_ohornhook", "16785119"),
    ("GDK_KEY_ohorntilde", "16785121"),
    ("GDK_KEY_omacron", "1010"),
    ("GDK_KEY_oneeighth", "2755"),
    ("GDK_KEY_onefifth", "2738"),
    ("GDK_KEY_onehalf", "189"),
    ("GDK_KEY_onequarter", "188"),
    ("GDK_KEY_onesixth", "2742"),
    ("GDK_KEY_onesubscript", "16785537"),
    ("GDK_KEY_onesuperior", "185"),
    ("GDK_KEY_onethird", "2736"),
    ("GDK_KEY_ooblique", "248"),
    ("GDK_KEY_openrectbullet", "2786"),
    ("GDK_KEY_openstar", "2789"),
    ("GDK_KEY_opentribulletdown", "2788"),
    ("GDK_KEY_opentribulletup", "2787"),
    ("GDK_KEY_ordfeminine", "170"),
    ("GDK_KEY_ordmasculine", "186"),
    ("GDK_KEY_oslash", "248"),
    ("GDK_KEY_otilde", "245"),
    ("GDK_KEY_overbar", "3008"),
    ("GDK_KEY_overline", "1150"),
    ("GDK_KEY_p", "112"),
    ("GDK_KEY_pabovedot", "16784983"),
    ("GDK_KEY_paragraph", "182"),
    ("GDK_KEY_parenleft", "40"),
    ("GDK_KEY_parenright", "41"),
    ("GDK_KEY_partdifferential", "16785922"),
    ("GDK_KEY_partialderivative", "2287"),
    ("GDK_KEY_percent", "37"),
    ("GDK_KEY_period", "46"),
    ("GDK_KEY_periodcentered", "183"),
    ("GDK_KEY_permille", "2773"),
    ("GDK_KEY_phonographcopyright", "2811"),
    ("GDK_KEY_plus", "43"),
    ("GDK_KEY_plusminus", "177"),
    ("GDK_KEY_prescription", "2772"),
    ("GDK_KEY_prolongedsound", "1200"),
    ("GDK_KEY_punctspace", "2726"),
    ("GDK_KEY_q", "113"),
    ("GDK_KEY_quad", "3020"),
    ("GDK_KEY_question", "63"),
    ("GDK_KEY_questiondown", "191"),
    ("GDK_KEY_quotedbl", "34"),
    ("GDK_KEY_quoteleft", "96"),
    ("GDK_KEY_quoteright", "39"),
    ("GDK_KEY_r", "114"),
    ("GDK_KEY_racute", "480"),
    ("GDK_KEY_radical", "2262"),
    ("GDK_KEY_rcaron", "504"),
    ("GDK_KEY_rcedilla", "947"),
    ("GDK_KEY_registered", "174"),
    ("GDK_KEY_rightanglebracket", "2750"),
    ("GDK_KEY_rightarrow", "2301"),
    ("GDK_KEY_rightcaret", "2982"),
    ("GDK_KEY_rightdoublequotemark", "2771"),
    ("GDK_KEY_rightmiddlecurlybrace", "2224"),
    ("GDK_KEY_rightmiddlesummation", "2231"),
    ("GDK_KEY_rightopentriangle", "2765"),
    ("GDK_KEY_rightpointer", "2795"),
    ("GDK_KEY_rightshoe", "3032"),
    ("GDK_KEY_rightsinglequotemark", "2769"),
    ("GDK_KEY_rightt", "2549"),
    ("GDK_KEY_righttack", "3068"),
    ("GDK_KEY_s", "115"),
    ("GDK_KEY_sabovedot", "16784993"),
    ("GDK_KEY_sacute", "438"),
    ("GDK_KEY_scaron", "441"),
    ("GDK_KEY_scedilla", "442"),
    ("GDK_KEY_schwa", "16777817"),
    ("GDK_KEY_scircumflex", "766"),
    ("GDK_KEY_script_switch", "65406"),
    ("GDK_KEY_seconds", "2775"),
    ("GDK_KEY_section", "167"),
    ("GDK_KEY_semicolon", "59"),
    ("GDK_KEY_semivoicedsound", "1247"),
    ("GDK_KEY_seveneighths", "2758"),
    ("GDK_KEY_sevensubscript", "16785543"),
    ("GDK_KEY_sevensuperior", "16785527"),
    ("GDK_KEY_signaturemark", "2762"),
    ("GDK_KEY_signifblank", "2732"),
    ("GDK_KEY_similarequal", "2249"),
    ("GDK_KEY_singlelowquotemark", "2813"),
    ("GDK_KEY_sixsubscript", "16785542"),
    ("GDK_KEY_sixsuperior", "16785526"),
    ("GDK_KEY_slash", "47"),
    ("GDK_KEY_soliddiamond", "2528"),
    ("GDK_KEY_space", "32"),
    ("GDK_KEY_squareroot", "16785946"),
    ("GDK_KEY_ssharp", "223"),
    ("GDK_KEY_sterling", "163"),
    ("GDK_KEY_stricteq", "16786019"),
    ("GDK_KEY_t", "116"),
    ("GDK_KEY_tabovedot", "16785003"),
    ("GDK_KEY_tcaron", "443"),
    ("GDK_KEY_tcedilla", "510"),
    ("GDK_KEY_telephone", "2809"),
    ("GDK_KEY_telephonerecorder", "2810"),
    ("GDK_KEY_therefore", "2240"),
    ("GDK_KEY_thinspace", "2727"),
    ("GDK_KEY_thorn", "254"),
    ("GDK_KEY_threeeighths", "2756"),
    ("GDK_KEY_threefifths", "2740"),
    ("GDK_KEY_threequarters", "190"),
    ("GDK_KEY_threesubscript", "16785539"),
    ("GDK_KEY_threesuperior", "179"),
    ("GDK_KEY_tintegral", "16785965"),
    ("GDK_KEY_topintegral", "2212"),
    ("GDK_KEY_topleftparens", "2219"),
    ("GDK_KEY_topleftradical", "2210"),
    ("GDK_KEY_topleftsqbracket", "2215"),
    ("GDK_KEY_topleftsummation", "2225"),
    ("GDK_KEY_toprightparens", "2221"),
    ("GDK_KEY_toprightsqbracket", "2217"),
    ("GDK_KEY_toprightsummation", "2229"),
    ("GDK_KEY_topt", "2551"),
    ("GDK_KEY_topvertsummationconnector", "2227"),
    ("GDK_KEY_trademark", "2761"),
    ("GDK_KEY_trademarkincircle", "2763"),
    ("GDK_KEY_tslash", "956"),
    ("GDK_KEY_twofifths", "2739"),
    ("GDK_KEY_twosubscript", "16785538"),
    ("GDK_KEY_twosuperior", "178"),
    ("GDK_KEY_twothirds", "2737"),
    ("GDK_KEY_u", "117"),
    ("GDK_KEY_uacute", "250"),
    ("GDK_KEY_ubelowdot", "16785125"),
    ("GDK_KEY_ubreve", "765"),
    ("GDK_KEY_ucircumflex", "251"),
    ("GDK_KEY_udiaeresis", "252"),
    ("GDK_KEY_udoubleacute", "507"),
    ("GDK_KEY_ugrave", "249"),
    ("GDK_KEY_uhook", "16785127"),
    ("GDK_KEY_uhorn", "16777648"),
    ("GDK_KEY_uhornacute", "16785129"),
    ("GDK_KEY_uhornbelowdot", "16785137"),
    ("GDK_KEY_uhorngrave", "16785131"),
    ("GDK_KEY_uhornhook", "16785133"),
    ("GDK_KEY_uhorntilde", "16785135"),
    ("GDK_KEY_umacron", "1022"),
    ("GDK_KEY_underbar", "3014"),
    ("GDK_KEY_underscore", "95"),
    ("GDK_KEY_union", "2269"),
    ("GDK_KEY_uogonek", "1017"),
    ("GDK_KEY_uparrow", "2300"),
    ("GDK_KEY_upcaret", "2985"),
    ("GDK_KEY_upleftcorner", "2540"),
    ("GDK_KEY_uprightcorner", "2539"),
    ("GDK_KEY_upshoe", "3011"),
    ("GDK_KEY_upstile", "3027"),
    ("GDK_KEY_uptack", "3022"),
    ("GDK_KEY_uring", "505"),
    ("GDK_KEY_utilde", "1021"),
    ("GDK_KEY_v", "118"),
    ("GDK_KEY_variation", "2241"),
    ("GDK_KEY_vertbar", "2552"),
    ("GDK_KEY_vertconnector", "2214"),
    ("GDK_KEY_voicedsound", "1246"),
    ("GDK_KEY_vt", "2537"),
    ("GDK_KEY_w", "119"),
    ("GDK_KEY_wacute", "16785027"),
    ("GDK_KEY_wcircumflex", "16777589"),
    ("GDK_KEY_wdiaeresis", "16785029"),
    ("GDK_KEY_wgrave", "16785025"),
    ("GDK_KEY_x", "120"),
    ("GDK_KEY_xabovedot", "16785035"),
    ("GDK_KEY_y", "121"),
    ("GDK_KEY_yacute", "253"),
    ("GDK_KEY_ybelowdot", "16785141"),
    ("GDK_KEY_ycircumflex", "16777591"),
    ("GDK_KEY_ydiaeresis", "255"),
    ("GDK_KEY_yen", "165"),
    ("GDK_KEY_ygrave", "16785139"),
    ("GDK_KEY_yhook", "16785143"),
    ("GDK_KEY_ytilde", "16785145"),
    ("GDK_KEY_z", "122"),
    ("GDK_KEY_zabovedot", "447"),
    ("GDK_KEY_zacute", "444"),
    ("GDK_KEY_zcaron", "446"),
    ("GDK_KEY_zerosubscript", "16785536"),
    ("GDK_KEY_zerosuperior", "16785520"),
    ("GDK_KEY_zstroke", "16777654"),
    ("(gint) GDK_LEAVE_NOTIFY", "7"),
    ("(guint) GDK_LOCK_MASK", "2"),
    ("(gint) GDK_MEMORY_A16", "25"),
    ("(gint) GDK_MEMORY_A16_FLOAT", "26"),
    ("(gint) GDK_MEMORY_A32_FLOAT", "27"),
    ("(gint) GDK_MEMORY_A8", "24"),
    ("(gint) GDK_MEMORY_A8B8G8R8", "6"),
    ("(gint) GDK_MEMORY_A8B8G8R8_PREMULTIPLIED", "28"),
    ("(gint) GDK_MEMORY_A8R8G8B8", "4"),
    ("(gint) GDK_MEMORY_A8R8G8B8_PREMULTIPLIED", "1"),
    ("(gint) GDK_MEMORY_B8G8R8", "8"),
    ("(gint) GDK_MEMORY_B8G8R8A8", "3"),
    ("(gint) GDK_MEMORY_B8G8R8A8_PREMULTIPLIED", "0"),
    ("(gint) GDK_MEMORY_B8G8R8X8", "29"),
    ("(gint) GDK_MEMORY_G16", "23"),
    ("(gint) GDK_MEMORY_G16A16", "22"),
    ("(gint) GDK_MEMORY_G16A16_PREMULTIPLIED", "21"),
    ("(gint) GDK_MEMORY_G8", "20"),
    ("(gint) GDK_MEMORY_G8A8", "19"),
    ("(gint) GDK_MEMORY_G8A8_PREMULTIPLIED", "18"),
    ("(gint) GDK_MEMORY_N_FORMATS", "33"),
    ("(gint) GDK_MEMORY_R16G16B16", "9"),
    ("(gint) GDK_MEMORY_R16G16B16A16", "11"),
    ("(gint) GDK_MEMORY_R16G16B16A16_FLOAT", "14"),
    ("(gint) GDK_MEMORY_R16G16B16A16_FLOAT_PREMULTIPLIED", "13"),
    ("(gint) GDK_MEMORY_R16G16B16A16_PREMULTIPLIED", "10"),
    ("(gint) GDK_MEMORY_R16G16B16_FLOAT", "12"),
    ("(gint) GDK_MEMORY_R32G32B32A32_FLOAT", "17"),
    ("(gint) GDK_MEMORY_R32G32B32A32_FLOAT_PREMULTIPLIED", "16"),
    ("(gint) GDK_MEMORY_R32G32B32_FLOAT", "15"),
    ("(gint) GDK_MEMORY_R8G8B8", "7"),
    ("(gint) GDK_MEMORY_R8G8B8A8", "5"),
    ("(gint) GDK_MEMORY_R8G8B8A8_PREMULTIPLIED", "2"),
    ("(gint) GDK_MEMORY_R8G8B8X8", "31"),
    ("(gint) GDK_MEMORY_X8B8G8R8", "32"),
    ("(gint) GDK_MEMORY_X8R8G8B8", "30"),
    ("(guint) GDK_META_MASK", "268435456"),
    ("GDK_MODIFIER_MASK", "469769999"),
    ("(gint) GDK_MOTION_NOTIFY", "1"),
    ("(gint) GDK_NOTIFY_ANCESTOR", "0"),
    ("(gint) GDK_NOTIFY_INFERIOR", "2"),
    ("(gint) GDK_NOTIFY_NONLINEAR", "3"),
    ("(gint) GDK_NOTIFY_NONLINEAR_VIRTUAL", "4"),
    ("(gint) GDK_NOTIFY_UNKNOWN", "5"),
    ("(gint) GDK_NOTIFY_VIRTUAL", "1"),
    ("(guint) GDK_NO_MODIFIER_MASK", "0"),
    ("(gint) GDK_PAD_BUTTON_PRESS", "23"),
    ("(gint) GDK_PAD_BUTTON_RELEASE", "24"),
    ("(gint) GDK_PAD_GROUP_MODE", "27"),
    ("(gint) GDK_PAD_RING", "25"),
    ("(gint) GDK_PAD_STRIP", "26"),
    ("(guint) GDK_PAINTABLE_STATIC_CONTENTS", "2"),
    ("(guint) GDK_PAINTABLE_STATIC_SIZE", "1"),
    ("GDK_PRIORITY_REDRAW", "120"),
    ("(gint) GDK_PROXIMITY_IN", "9"),
    ("(gint) GDK_PROXIMITY_OUT", "10"),
    ("(gint) GDK_SCROLL", "15"),
    ("(gint) GDK_SCROLL_DOWN", "1"),
    ("(gint) GDK_SCROLL_LEFT", "2"),
    ("(gint) GDK_SCROLL_RIGHT", "3"),
    ("(gint) GDK_SCROLL_SMOOTH", "4"),
    ("(gint) GDK_SCROLL_UNIT_SURFACE", "1"),
    ("(gint) GDK_SCROLL_UNIT_WHEEL", "0"),
    ("(gint) GDK_SCROLL_UP", "0"),
    ("(guint) GDK_SEAT_CAPABILITY_ALL", "31"),
    ("(guint) GDK_SEAT_CAPABILITY_ALL_POINTING", "7"),
    ("(guint) GDK_SEAT_CAPABILITY_KEYBOARD", "8"),
    ("(guint) GDK_SEAT_CAPABILITY_NONE", "0"),
    ("(guint) GDK_SEAT_CAPABILITY_POINTER", "1"),
    ("(guint) GDK_SEAT_CAPABILITY_TABLET_PAD", "16"),
    ("(guint) GDK_SEAT_CAPABILITY_TABLET_STYLUS", "4"),
    ("(guint) GDK_SEAT_CAPABILITY_TOUCH", "2"),
    ("(guint) GDK_SHIFT_MASK", "1"),
    ("(gint) GDK_SOURCE_KEYBOARD", "2"),
    ("(gint) GDK_SOURCE_MOUSE", "0"),
    ("(gint) GDK_SOURCE_PEN", "1"),
    ("(gint) GDK_SOURCE_TABLET_PAD", "6"),
    ("(gint) GDK_SOURCE_TOUCHPAD", "4"),
    ("(gint) GDK_SOURCE_TOUCHSCREEN", "3"),
    ("(gint) GDK_SOURCE_TRACKPOINT", "5"),
    ("(gint) GDK_SUBPIXEL_LAYOUT_HORIZONTAL_BGR", "3"),
    ("(gint) GDK_SUBPIXEL_LAYOUT_HORIZONTAL_RGB", "2"),
    ("(gint) GDK_SUBPIXEL_LAYOUT_NONE", "1"),
    ("(gint) GDK_SUBPIXEL_LAYOUT_UNKNOWN", "0"),
    ("(gint) GDK_SUBPIXEL_LAYOUT_VERTICAL_BGR", "5"),
    ("(gint) GDK_SUBPIXEL_LAYOUT_VERTICAL_RGB", "4"),
    ("(guint) GDK_SUPER_MASK", "67108864"),
    ("(gint) GDK_SURFACE_EDGE_EAST", "4"),
    ("(gint) GDK_SURFACE_EDGE_NORTH", "1"),
    ("(gint) GDK_SURFACE_EDGE_NORTH_EAST", "2"),
    ("(gint) GDK_SURFACE_EDGE_NORTH_WEST", "0"),
    ("(gint) GDK_SURFACE_EDGE_SOUTH", "6"),
    ("(gint) GDK_SURFACE_EDGE_SOUTH_EAST", "7"),
    ("(gint) GDK_SURFACE_EDGE_SOUTH_WEST", "5"),
    ("(gint) GDK_SURFACE_EDGE_WEST", "3"),
    ("(gint) GDK_TEXTURE_ERROR_CORRUPT_IMAGE", "1"),
    ("(gint) GDK_TEXTURE_ERROR_TOO_LARGE", "0"),
    ("(gint) GDK_TEXTURE_ERROR_UNSUPPORTED_CONTENT", "2"),
    ("(gint) GDK_TEXTURE_ERROR_UNSUPPORTED_FORMAT", "3"),
    ("(gint) GDK_TITLEBAR_GESTURE_DOUBLE_CLICK", "1"),
    ("(gint) GDK_TITLEBAR_GESTURE_MIDDLE_CLICK", "3"),
    ("(gint) GDK_TITLEBAR_GESTURE_RIGHT_CLICK", "2"),
    ("(guint) GDK_TOPLEVEL_STATE_ABOVE", "16"),
    ("(guint) GDK_TOPLEVEL_STATE_BELOW", "32"),
    ("(guint) GDK_TOPLEVEL_STATE_BOTTOM_RESIZABLE", "8192"),
    ("(guint) GDK_TOPLEVEL_STATE_BOTTOM_TILED", "4096"),
    ("(guint) GDK_TOPLEVEL_STATE_FOCUSED", "64"),
    ("(guint) GDK_TOPLEVEL_STATE_FULLSCREEN", "8"),
    ("(guint) GDK_TOPLEVEL_STATE_LEFT_RESIZABLE", "32768"),
    ("(guint) GDK_TOPLEVEL_STATE_LEFT_TILED", "16384"),
    ("(guint) GDK_TOPLEVEL_STATE_MAXIMIZED", "2"),
    ("(guint) GDK_TOPLEVEL_STATE_MINIMIZED", "1"),
    ("(guint) GDK_TOPLEVEL_STATE_RIGHT_RESIZABLE", "2048"),
    ("(guint) GDK_TOPLEVEL_STATE_RIGHT_TILED", "1024"),
    ("(guint) GDK_TOPLEVEL_STATE_STICKY", "4"),
    ("(guint) GDK_TOPLEVEL_STATE_SUSPENDED", "65536"),
    ("(guint) GDK_TOPLEVEL_STATE_TILED", "128"),
    ("(guint) GDK_TOPLEVEL_STATE_TOP_RESIZABLE", "512"),
    ("(guint) GDK_TOPLEVEL_STATE_TOP_TILED", "256"),
    ("(gint) GDK_TOUCHPAD_GESTURE_PHASE_BEGIN", "0"),
    ("(gint) GDK_TOUCHPAD_GESTURE_PHASE_CANCEL", "3"),
    ("(gint) GDK_TOUCHPAD_GESTURE_PHASE_END", "2"),
    ("(gint) GDK_TOUCHPAD_GESTURE_PHASE_UPDATE", "1"),
    ("(gint) GDK_TOUCHPAD_HOLD", "28"),
    ("(gint) GDK_TOUCHPAD_PINCH", "22"),
    ("(gint) GDK_TOUCHPAD_SWIPE", "21"),
    ("(gint) GDK_TOUCH_BEGIN", "17"),
    ("(gint) GDK_TOUCH_CANCEL", "20"),
    ("(gint) GDK_TOUCH_END", "19"),
    ("(gint) GDK_TOUCH_UPDATE", "18"),
    ("(gint) GDK_VULKAN_ERROR_NOT_AVAILABLE", "1"),
    ("(gint) GDK_VULKAN_ERROR_UNSUPPORTED", "0"),
];
