// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Texture;
use glib::object::Cast;
use glib::object::IsA;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::fmt;

glib::wrapper! {
    #[doc(alias = "GdkCursor")]
    pub struct Cursor(Object<ffi::GdkCursor>);

    match fn {
        type_ => || ffi::gdk_cursor_get_type(),
    }
}

impl Cursor {
    #[doc(alias = "gdk_cursor_new_from_name")]
    #[doc(alias = "new_from_name")]
    pub fn from_name(name: &str, fallback: Option<&Cursor>) -> Option<Cursor> {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::gdk_cursor_new_from_name(
                name.to_glib_none().0,
                fallback.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gdk_cursor_new_from_texture")]
    #[doc(alias = "new_from_texture")]
    pub fn from_texture(
        texture: &impl IsA<Texture>,
        hotspot_x: i32,
        hotspot_y: i32,
        fallback: Option<&Cursor>,
    ) -> Cursor {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::gdk_cursor_new_from_texture(
                texture.as_ref().to_glib_none().0,
                hotspot_x,
                hotspot_y,
                fallback.to_glib_none().0,
            ))
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Cursor`] objects.
    ///
    /// This method returns an instance of [`CursorBuilder`] which can be used to create [`Cursor`] objects.
    pub fn builder() -> CursorBuilder {
        CursorBuilder::default()
    }

    #[doc(alias = "gdk_cursor_get_fallback")]
    #[doc(alias = "get_fallback")]
    pub fn fallback(&self) -> Option<Cursor> {
        unsafe { from_glib_none(ffi::gdk_cursor_get_fallback(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_cursor_get_hotspot_x")]
    #[doc(alias = "get_hotspot_x")]
    pub fn hotspot_x(&self) -> i32 {
        unsafe { ffi::gdk_cursor_get_hotspot_x(self.to_glib_none().0) }
    }

    #[doc(alias = "gdk_cursor_get_hotspot_y")]
    #[doc(alias = "get_hotspot_y")]
    pub fn hotspot_y(&self) -> i32 {
        unsafe { ffi::gdk_cursor_get_hotspot_y(self.to_glib_none().0) }
    }

    #[doc(alias = "gdk_cursor_get_name")]
    #[doc(alias = "get_name")]
    pub fn name(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::gdk_cursor_get_name(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_cursor_get_texture")]
    #[doc(alias = "get_texture")]
    pub fn texture(&self) -> Option<Texture> {
        unsafe { from_glib_none(ffi::gdk_cursor_get_texture(self.to_glib_none().0)) }
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Cursor`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
pub struct CursorBuilder {
    fallback: Option<Cursor>,
    hotspot_x: Option<i32>,
    hotspot_y: Option<i32>,
    name: Option<String>,
    texture: Option<Texture>,
}

impl CursorBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`CursorBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Cursor`].
    pub fn build(self) -> Cursor {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref fallback) = self.fallback {
            properties.push(("fallback", fallback));
        }
        if let Some(ref hotspot_x) = self.hotspot_x {
            properties.push(("hotspot-x", hotspot_x));
        }
        if let Some(ref hotspot_y) = self.hotspot_y {
            properties.push(("hotspot-y", hotspot_y));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref texture) = self.texture {
            properties.push(("texture", texture));
        }
        glib::Object::new::<Cursor>(&properties).expect("Failed to create an instance of Cursor")
    }

    pub fn fallback(mut self, fallback: &Cursor) -> Self {
        self.fallback = Some(fallback.clone());
        self
    }

    pub fn hotspot_x(mut self, hotspot_x: i32) -> Self {
        self.hotspot_x = Some(hotspot_x);
        self
    }

    pub fn hotspot_y(mut self, hotspot_y: i32) -> Self {
        self.hotspot_y = Some(hotspot_y);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn texture(mut self, texture: &impl IsA<Texture>) -> Self {
        self.texture = Some(texture.clone().upcast());
        self
    }
}

impl fmt::Display for Cursor {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Cursor")
    }
}
