// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::CenteringPolicy;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "HdyHeaderBar")]
    pub struct HeaderBar(Object<ffi::HdyHeaderBar, ffi::HdyHeaderBarClass>) @extends gtk::Container, gtk::Widget, @implements gtk::Buildable;

    match fn {
        type_ => || ffi::hdy_header_bar_get_type(),
    }
}

impl HeaderBar {
    #[doc(alias = "hdy_header_bar_new")]
    pub fn new() -> HeaderBar {
        assert_initialized_main_thread!();
        unsafe { gtk::Widget::from_glib_none(ffi::hdy_header_bar_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`HeaderBar`] objects.
    ///
    /// This method returns an instance of [`HeaderBarBuilder`] which can be used to create [`HeaderBar`] objects.
    pub fn builder() -> HeaderBarBuilder {
        HeaderBarBuilder::default()
    }
}

impl Default for HeaderBar {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`HeaderBar`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
pub struct HeaderBarBuilder {
    centering_policy: Option<CenteringPolicy>,
    custom_title: Option<gtk::Widget>,
    decoration_layout: Option<String>,
    decoration_layout_set: Option<bool>,
    has_subtitle: Option<bool>,
    interpolate_size: Option<bool>,
    show_close_button: Option<bool>,
    spacing: Option<i32>,
    subtitle: Option<String>,
    title: Option<String>,
    transition_duration: Option<u32>,
    border_width: Option<u32>,
    child: Option<gtk::Widget>,
    resize_mode: Option<gtk::ResizeMode>,
    app_paintable: Option<bool>,
    can_default: Option<bool>,
    can_focus: Option<bool>,
    double_buffered: Option<bool>,
    events: Option<gdk::EventMask>,
    expand: Option<bool>,
    focus_on_click: Option<bool>,
    halign: Option<gtk::Align>,
    has_default: Option<bool>,
    has_focus: Option<bool>,
    has_tooltip: Option<bool>,
    height_request: Option<i32>,
    hexpand: Option<bool>,
    hexpand_set: Option<bool>,
    is_focus: Option<bool>,
    margin: Option<i32>,
    margin_bottom: Option<i32>,
    margin_end: Option<i32>,
    margin_left: Option<i32>,
    margin_right: Option<i32>,
    margin_start: Option<i32>,
    margin_top: Option<i32>,
    name: Option<String>,
    no_show_all: Option<bool>,
    opacity: Option<f64>,
    parent: Option<gtk::Container>,
    receives_default: Option<bool>,
    sensitive: Option<bool>,
    //style: /*Unknown type*/,
    tooltip_markup: Option<String>,
    tooltip_text: Option<String>,
    valign: Option<gtk::Align>,
    vexpand: Option<bool>,
    vexpand_set: Option<bool>,
    visible: Option<bool>,
    width_request: Option<i32>,
}

impl HeaderBarBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`HeaderBarBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`HeaderBar`].
    pub fn build(self) -> HeaderBar {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref centering_policy) = self.centering_policy {
            properties.push(("centering-policy", centering_policy));
        }
        if let Some(ref custom_title) = self.custom_title {
            properties.push(("custom-title", custom_title));
        }
        if let Some(ref decoration_layout) = self.decoration_layout {
            properties.push(("decoration-layout", decoration_layout));
        }
        if let Some(ref decoration_layout_set) = self.decoration_layout_set {
            properties.push(("decoration-layout-set", decoration_layout_set));
        }
        if let Some(ref has_subtitle) = self.has_subtitle {
            properties.push(("has-subtitle", has_subtitle));
        }
        if let Some(ref interpolate_size) = self.interpolate_size {
            properties.push(("interpolate-size", interpolate_size));
        }
        if let Some(ref show_close_button) = self.show_close_button {
            properties.push(("show-close-button", show_close_button));
        }
        if let Some(ref spacing) = self.spacing {
            properties.push(("spacing", spacing));
        }
        if let Some(ref subtitle) = self.subtitle {
            properties.push(("subtitle", subtitle));
        }
        if let Some(ref title) = self.title {
            properties.push(("title", title));
        }
        if let Some(ref transition_duration) = self.transition_duration {
            properties.push(("transition-duration", transition_duration));
        }
        if let Some(ref border_width) = self.border_width {
            properties.push(("border-width", border_width));
        }
        if let Some(ref child) = self.child {
            properties.push(("child", child));
        }
        if let Some(ref resize_mode) = self.resize_mode {
            properties.push(("resize-mode", resize_mode));
        }
        if let Some(ref app_paintable) = self.app_paintable {
            properties.push(("app-paintable", app_paintable));
        }
        if let Some(ref can_default) = self.can_default {
            properties.push(("can-default", can_default));
        }
        if let Some(ref can_focus) = self.can_focus {
            properties.push(("can-focus", can_focus));
        }
        if let Some(ref double_buffered) = self.double_buffered {
            properties.push(("double-buffered", double_buffered));
        }
        if let Some(ref events) = self.events {
            properties.push(("events", events));
        }
        if let Some(ref expand) = self.expand {
            properties.push(("expand", expand));
        }
        if let Some(ref focus_on_click) = self.focus_on_click {
            properties.push(("focus-on-click", focus_on_click));
        }
        if let Some(ref halign) = self.halign {
            properties.push(("halign", halign));
        }
        if let Some(ref has_default) = self.has_default {
            properties.push(("has-default", has_default));
        }
        if let Some(ref has_focus) = self.has_focus {
            properties.push(("has-focus", has_focus));
        }
        if let Some(ref has_tooltip) = self.has_tooltip {
            properties.push(("has-tooltip", has_tooltip));
        }
        if let Some(ref height_request) = self.height_request {
            properties.push(("height-request", height_request));
        }
        if let Some(ref hexpand) = self.hexpand {
            properties.push(("hexpand", hexpand));
        }
        if let Some(ref hexpand_set) = self.hexpand_set {
            properties.push(("hexpand-set", hexpand_set));
        }
        if let Some(ref is_focus) = self.is_focus {
            properties.push(("is-focus", is_focus));
        }
        if let Some(ref margin) = self.margin {
            properties.push(("margin", margin));
        }
        if let Some(ref margin_bottom) = self.margin_bottom {
            properties.push(("margin-bottom", margin_bottom));
        }
        if let Some(ref margin_end) = self.margin_end {
            properties.push(("margin-end", margin_end));
        }
        if let Some(ref margin_left) = self.margin_left {
            properties.push(("margin-left", margin_left));
        }
        if let Some(ref margin_right) = self.margin_right {
            properties.push(("margin-right", margin_right));
        }
        if let Some(ref margin_start) = self.margin_start {
            properties.push(("margin-start", margin_start));
        }
        if let Some(ref margin_top) = self.margin_top {
            properties.push(("margin-top", margin_top));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref no_show_all) = self.no_show_all {
            properties.push(("no-show-all", no_show_all));
        }
        if let Some(ref opacity) = self.opacity {
            properties.push(("opacity", opacity));
        }
        if let Some(ref parent) = self.parent {
            properties.push(("parent", parent));
        }
        if let Some(ref receives_default) = self.receives_default {
            properties.push(("receives-default", receives_default));
        }
        if let Some(ref sensitive) = self.sensitive {
            properties.push(("sensitive", sensitive));
        }
        if let Some(ref tooltip_markup) = self.tooltip_markup {
            properties.push(("tooltip-markup", tooltip_markup));
        }
        if let Some(ref tooltip_text) = self.tooltip_text {
            properties.push(("tooltip-text", tooltip_text));
        }
        if let Some(ref valign) = self.valign {
            properties.push(("valign", valign));
        }
        if let Some(ref vexpand) = self.vexpand {
            properties.push(("vexpand", vexpand));
        }
        if let Some(ref vexpand_set) = self.vexpand_set {
            properties.push(("vexpand-set", vexpand_set));
        }
        if let Some(ref visible) = self.visible {
            properties.push(("visible", visible));
        }
        if let Some(ref width_request) = self.width_request {
            properties.push(("width-request", width_request));
        }
        glib::Object::new::<HeaderBar>(&properties)
            .expect("Failed to create an instance of HeaderBar")
    }

    pub fn centering_policy(mut self, centering_policy: CenteringPolicy) -> Self {
        self.centering_policy = Some(centering_policy);
        self
    }

    pub fn custom_title<P: IsA<gtk::Widget>>(mut self, custom_title: &P) -> Self {
        self.custom_title = Some(custom_title.clone().upcast());
        self
    }

    pub fn decoration_layout(mut self, decoration_layout: &str) -> Self {
        self.decoration_layout = Some(decoration_layout.to_string());
        self
    }

    pub fn decoration_layout_set(mut self, decoration_layout_set: bool) -> Self {
        self.decoration_layout_set = Some(decoration_layout_set);
        self
    }

    pub fn has_subtitle(mut self, has_subtitle: bool) -> Self {
        self.has_subtitle = Some(has_subtitle);
        self
    }

    pub fn interpolate_size(mut self, interpolate_size: bool) -> Self {
        self.interpolate_size = Some(interpolate_size);
        self
    }

    pub fn show_close_button(mut self, show_close_button: bool) -> Self {
        self.show_close_button = Some(show_close_button);
        self
    }

    pub fn spacing(mut self, spacing: i32) -> Self {
        self.spacing = Some(spacing);
        self
    }

    pub fn subtitle(mut self, subtitle: &str) -> Self {
        self.subtitle = Some(subtitle.to_string());
        self
    }

    pub fn title(mut self, title: &str) -> Self {
        self.title = Some(title.to_string());
        self
    }

    pub fn transition_duration(mut self, transition_duration: u32) -> Self {
        self.transition_duration = Some(transition_duration);
        self
    }

    pub fn border_width(mut self, border_width: u32) -> Self {
        self.border_width = Some(border_width);
        self
    }

    pub fn child<P: IsA<gtk::Widget>>(mut self, child: &P) -> Self {
        self.child = Some(child.clone().upcast());
        self
    }

    pub fn resize_mode(mut self, resize_mode: gtk::ResizeMode) -> Self {
        self.resize_mode = Some(resize_mode);
        self
    }

    pub fn app_paintable(mut self, app_paintable: bool) -> Self {
        self.app_paintable = Some(app_paintable);
        self
    }

    pub fn can_default(mut self, can_default: bool) -> Self {
        self.can_default = Some(can_default);
        self
    }

    pub fn can_focus(mut self, can_focus: bool) -> Self {
        self.can_focus = Some(can_focus);
        self
    }

    pub fn double_buffered(mut self, double_buffered: bool) -> Self {
        self.double_buffered = Some(double_buffered);
        self
    }

    pub fn events(mut self, events: gdk::EventMask) -> Self {
        self.events = Some(events);
        self
    }

    pub fn expand(mut self, expand: bool) -> Self {
        self.expand = Some(expand);
        self
    }

    pub fn focus_on_click(mut self, focus_on_click: bool) -> Self {
        self.focus_on_click = Some(focus_on_click);
        self
    }

    pub fn halign(mut self, halign: gtk::Align) -> Self {
        self.halign = Some(halign);
        self
    }

    pub fn has_default(mut self, has_default: bool) -> Self {
        self.has_default = Some(has_default);
        self
    }

    pub fn has_focus(mut self, has_focus: bool) -> Self {
        self.has_focus = Some(has_focus);
        self
    }

    pub fn has_tooltip(mut self, has_tooltip: bool) -> Self {
        self.has_tooltip = Some(has_tooltip);
        self
    }

    pub fn height_request(mut self, height_request: i32) -> Self {
        self.height_request = Some(height_request);
        self
    }

    pub fn hexpand(mut self, hexpand: bool) -> Self {
        self.hexpand = Some(hexpand);
        self
    }

    pub fn hexpand_set(mut self, hexpand_set: bool) -> Self {
        self.hexpand_set = Some(hexpand_set);
        self
    }

    pub fn is_focus(mut self, is_focus: bool) -> Self {
        self.is_focus = Some(is_focus);
        self
    }

    pub fn margin(mut self, margin: i32) -> Self {
        self.margin = Some(margin);
        self
    }

    pub fn margin_bottom(mut self, margin_bottom: i32) -> Self {
        self.margin_bottom = Some(margin_bottom);
        self
    }

    pub fn margin_end(mut self, margin_end: i32) -> Self {
        self.margin_end = Some(margin_end);
        self
    }

    pub fn margin_left(mut self, margin_left: i32) -> Self {
        self.margin_left = Some(margin_left);
        self
    }

    pub fn margin_right(mut self, margin_right: i32) -> Self {
        self.margin_right = Some(margin_right);
        self
    }

    pub fn margin_start(mut self, margin_start: i32) -> Self {
        self.margin_start = Some(margin_start);
        self
    }

    pub fn margin_top(mut self, margin_top: i32) -> Self {
        self.margin_top = Some(margin_top);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn no_show_all(mut self, no_show_all: bool) -> Self {
        self.no_show_all = Some(no_show_all);
        self
    }

    pub fn opacity(mut self, opacity: f64) -> Self {
        self.opacity = Some(opacity);
        self
    }

    pub fn parent<P: IsA<gtk::Container>>(mut self, parent: &P) -> Self {
        self.parent = Some(parent.clone().upcast());
        self
    }

    pub fn receives_default(mut self, receives_default: bool) -> Self {
        self.receives_default = Some(receives_default);
        self
    }

    pub fn sensitive(mut self, sensitive: bool) -> Self {
        self.sensitive = Some(sensitive);
        self
    }

    pub fn tooltip_markup(mut self, tooltip_markup: &str) -> Self {
        self.tooltip_markup = Some(tooltip_markup.to_string());
        self
    }

    pub fn tooltip_text(mut self, tooltip_text: &str) -> Self {
        self.tooltip_text = Some(tooltip_text.to_string());
        self
    }

    pub fn valign(mut self, valign: gtk::Align) -> Self {
        self.valign = Some(valign);
        self
    }

    pub fn vexpand(mut self, vexpand: bool) -> Self {
        self.vexpand = Some(vexpand);
        self
    }

    pub fn vexpand_set(mut self, vexpand_set: bool) -> Self {
        self.vexpand_set = Some(vexpand_set);
        self
    }

    pub fn visible(mut self, visible: bool) -> Self {
        self.visible = Some(visible);
        self
    }

    pub fn width_request(mut self, width_request: i32) -> Self {
        self.width_request = Some(width_request);
        self
    }
}

pub const NONE_HEADER_BAR: Option<&HeaderBar> = None;

pub trait HeaderBarExt: 'static {
    #[doc(alias = "hdy_header_bar_get_centering_policy")]
    #[doc(alias = "get_centering_policy")]
    fn centering_policy(&self) -> CenteringPolicy;

    #[doc(alias = "hdy_header_bar_get_custom_title")]
    #[doc(alias = "get_custom_title")]
    fn custom_title(&self) -> Option<gtk::Widget>;

    #[doc(alias = "hdy_header_bar_get_decoration_layout")]
    #[doc(alias = "get_decoration_layout")]
    fn decoration_layout(&self) -> Option<glib::GString>;

    #[doc(alias = "hdy_header_bar_get_has_subtitle")]
    #[doc(alias = "get_has_subtitle")]
    fn has_subtitle(&self) -> bool;

    #[doc(alias = "hdy_header_bar_get_interpolate_size")]
    #[doc(alias = "get_interpolate_size")]
    fn is_interpolate_size(&self) -> bool;

    #[doc(alias = "hdy_header_bar_get_show_close_button")]
    #[doc(alias = "get_show_close_button")]
    fn shows_close_button(&self) -> bool;

    #[doc(alias = "hdy_header_bar_get_subtitle")]
    #[doc(alias = "get_subtitle")]
    fn subtitle(&self) -> Option<glib::GString>;

    #[doc(alias = "hdy_header_bar_get_title")]
    #[doc(alias = "get_title")]
    fn title(&self) -> Option<glib::GString>;

    #[doc(alias = "hdy_header_bar_get_transition_duration")]
    #[doc(alias = "get_transition_duration")]
    fn transition_duration(&self) -> u32;

    #[doc(alias = "hdy_header_bar_get_transition_running")]
    #[doc(alias = "get_transition_running")]
    fn is_transition_running(&self) -> bool;

    #[doc(alias = "hdy_header_bar_pack_end")]
    fn pack_end<P: IsA<gtk::Widget>>(&self, child: &P);

    #[doc(alias = "hdy_header_bar_pack_start")]
    fn pack_start<P: IsA<gtk::Widget>>(&self, child: &P);

    #[doc(alias = "hdy_header_bar_set_centering_policy")]
    fn set_centering_policy(&self, centering_policy: CenteringPolicy);

    #[doc(alias = "hdy_header_bar_set_custom_title")]
    fn set_custom_title<P: IsA<gtk::Widget>>(&self, title_widget: Option<&P>);

    #[doc(alias = "hdy_header_bar_set_decoration_layout")]
    fn set_decoration_layout(&self, layout: Option<&str>);

    #[doc(alias = "hdy_header_bar_set_has_subtitle")]
    fn set_has_subtitle(&self, setting: bool);

    #[doc(alias = "hdy_header_bar_set_interpolate_size")]
    fn set_interpolate_size(&self, interpolate_size: bool);

    #[doc(alias = "hdy_header_bar_set_show_close_button")]
    fn set_show_close_button(&self, setting: bool);

    #[doc(alias = "hdy_header_bar_set_subtitle")]
    fn set_subtitle(&self, subtitle: Option<&str>);

    #[doc(alias = "hdy_header_bar_set_title")]
    fn set_title(&self, title: Option<&str>);

    #[doc(alias = "hdy_header_bar_set_transition_duration")]
    fn set_transition_duration(&self, duration: u32);

    #[doc(alias = "decoration-layout-set")]
    fn is_decoration_layout_set(&self) -> bool;

    #[doc(alias = "decoration-layout-set")]
    fn set_decoration_layout_set(&self, decoration_layout_set: bool);

    fn spacing(&self) -> i32;

    fn set_spacing(&self, spacing: i32);

    #[doc(alias = "centering-policy")]
    fn connect_centering_policy_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "custom-title")]
    fn connect_custom_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "decoration-layout")]
    fn connect_decoration_layout_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "decoration-layout-set")]
    fn connect_decoration_layout_set_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    #[doc(alias = "has-subtitle")]
    fn connect_has_subtitle_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "interpolate-size")]
    fn connect_interpolate_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "show-close-button")]
    fn connect_show_close_button_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "spacing")]
    fn connect_spacing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "subtitle")]
    fn connect_subtitle_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "title")]
    fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "transition-duration")]
    fn connect_transition_duration_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "transition-running")]
    fn connect_transition_running_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<HeaderBar>> HeaderBarExt for O {
    fn centering_policy(&self) -> CenteringPolicy {
        unsafe {
            from_glib(ffi::hdy_header_bar_get_centering_policy(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn custom_title(&self) -> Option<gtk::Widget> {
        unsafe {
            from_glib_none(ffi::hdy_header_bar_get_custom_title(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn decoration_layout(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::hdy_header_bar_get_decoration_layout(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn has_subtitle(&self) -> bool {
        unsafe {
            from_glib(ffi::hdy_header_bar_get_has_subtitle(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_interpolate_size(&self) -> bool {
        unsafe {
            from_glib(ffi::hdy_header_bar_get_interpolate_size(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn shows_close_button(&self) -> bool {
        unsafe {
            from_glib(ffi::hdy_header_bar_get_show_close_button(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn subtitle(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::hdy_header_bar_get_subtitle(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn title(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::hdy_header_bar_get_title(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn transition_duration(&self) -> u32 {
        unsafe { ffi::hdy_header_bar_get_transition_duration(self.as_ref().to_glib_none().0) }
    }

    fn is_transition_running(&self) -> bool {
        unsafe {
            from_glib(ffi::hdy_header_bar_get_transition_running(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn pack_end<P: IsA<gtk::Widget>>(&self, child: &P) {
        unsafe {
            ffi::hdy_header_bar_pack_end(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
            );
        }
    }

    fn pack_start<P: IsA<gtk::Widget>>(&self, child: &P) {
        unsafe {
            ffi::hdy_header_bar_pack_start(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
            );
        }
    }

    fn set_centering_policy(&self, centering_policy: CenteringPolicy) {
        unsafe {
            ffi::hdy_header_bar_set_centering_policy(
                self.as_ref().to_glib_none().0,
                centering_policy.into_glib(),
            );
        }
    }

    fn set_custom_title<P: IsA<gtk::Widget>>(&self, title_widget: Option<&P>) {
        unsafe {
            ffi::hdy_header_bar_set_custom_title(
                self.as_ref().to_glib_none().0,
                title_widget.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_decoration_layout(&self, layout: Option<&str>) {
        unsafe {
            ffi::hdy_header_bar_set_decoration_layout(
                self.as_ref().to_glib_none().0,
                layout.to_glib_none().0,
            );
        }
    }

    fn set_has_subtitle(&self, setting: bool) {
        unsafe {
            ffi::hdy_header_bar_set_has_subtitle(
                self.as_ref().to_glib_none().0,
                setting.into_glib(),
            );
        }
    }

    fn set_interpolate_size(&self, interpolate_size: bool) {
        unsafe {
            ffi::hdy_header_bar_set_interpolate_size(
                self.as_ref().to_glib_none().0,
                interpolate_size.into_glib(),
            );
        }
    }

    fn set_show_close_button(&self, setting: bool) {
        unsafe {
            ffi::hdy_header_bar_set_show_close_button(
                self.as_ref().to_glib_none().0,
                setting.into_glib(),
            );
        }
    }

    fn set_subtitle(&self, subtitle: Option<&str>) {
        unsafe {
            ffi::hdy_header_bar_set_subtitle(
                self.as_ref().to_glib_none().0,
                subtitle.to_glib_none().0,
            );
        }
    }

    fn set_title(&self, title: Option<&str>) {
        unsafe {
            ffi::hdy_header_bar_set_title(self.as_ref().to_glib_none().0, title.to_glib_none().0);
        }
    }

    fn set_transition_duration(&self, duration: u32) {
        unsafe {
            ffi::hdy_header_bar_set_transition_duration(self.as_ref().to_glib_none().0, duration);
        }
    }

    fn is_decoration_layout_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"decoration-layout-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `decoration-layout-set` getter")
        }
    }

    fn set_decoration_layout_set(&self, decoration_layout_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"decoration-layout-set\0".as_ptr() as *const _,
                decoration_layout_set.to_value().to_glib_none().0,
            );
        }
    }

    fn spacing(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"spacing\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `spacing` getter")
        }
    }

    fn set_spacing(&self, spacing: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"spacing\0".as_ptr() as *const _,
                spacing.to_value().to_glib_none().0,
            );
        }
    }

    fn connect_centering_policy_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_centering_policy_trampoline<
            P: IsA<HeaderBar>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyHeaderBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(HeaderBar::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::centering-policy\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_centering_policy_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_custom_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_custom_title_trampoline<
            P: IsA<HeaderBar>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyHeaderBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(HeaderBar::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::custom-title\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_custom_title_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_decoration_layout_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_decoration_layout_trampoline<
            P: IsA<HeaderBar>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyHeaderBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(HeaderBar::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::decoration-layout\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_decoration_layout_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_decoration_layout_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_decoration_layout_set_trampoline<
            P: IsA<HeaderBar>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyHeaderBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(HeaderBar::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::decoration-layout-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_decoration_layout_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_has_subtitle_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_has_subtitle_trampoline<
            P: IsA<HeaderBar>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyHeaderBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(HeaderBar::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::has-subtitle\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_has_subtitle_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_interpolate_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_interpolate_size_trampoline<
            P: IsA<HeaderBar>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyHeaderBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(HeaderBar::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::interpolate-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_interpolate_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_show_close_button_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_close_button_trampoline<
            P: IsA<HeaderBar>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyHeaderBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(HeaderBar::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::show-close-button\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_show_close_button_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_spacing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_spacing_trampoline<P: IsA<HeaderBar>, F: Fn(&P) + 'static>(
            this: *mut ffi::HdyHeaderBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(HeaderBar::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::spacing\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_spacing_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_subtitle_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_subtitle_trampoline<P: IsA<HeaderBar>, F: Fn(&P) + 'static>(
            this: *mut ffi::HdyHeaderBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(HeaderBar::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::subtitle\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_subtitle_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_title_trampoline<P: IsA<HeaderBar>, F: Fn(&P) + 'static>(
            this: *mut ffi::HdyHeaderBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(HeaderBar::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::title\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_title_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_transition_duration_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_transition_duration_trampoline<
            P: IsA<HeaderBar>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyHeaderBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(HeaderBar::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::transition-duration\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_transition_duration_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_transition_running_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_transition_running_trampoline<
            P: IsA<HeaderBar>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyHeaderBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(HeaderBar::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::transition-running\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_transition_running_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for HeaderBar {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("HeaderBar")
    }
}
