use super::*;

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(rename_all = "snake_case")]
#[non_exhaustive]
pub struct App {
    pub id: AppId,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub slug: Option<String>,
    pub node_id: String,
    pub owner: Author,
    pub name: String,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    pub external_url: Url,
    pub html_url: Url,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_at: Option<DateTime<Utc>>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub updated_at: Option<DateTime<Utc>>,
    pub permissions: Permissions,
    pub events: Vec<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub installations_count: Option<u64>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub webhook_secret: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pem: Option<String>,
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[non_exhaustive]
pub struct Permissions {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub actions: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub administration: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub blocking: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub checks: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub contents: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub content_references: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub deployments: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub discussions: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub emails: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub environments: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub followers: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub gists: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub gpg_keys: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub interaction_limits: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub issues: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub keys: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub members: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub organization_administration: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub organization_events: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub organization_hooks: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub organization_plan: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub organization_projects: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub organization_secrets: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub organization_self_hosted_runners: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub organization_user_blocking: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub packages: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pages: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub plan: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub profile: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pull_requests: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub repository_hooks: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub repository_projects: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub secrets: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub secret_scanning_alerts: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_events: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub single_file: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub starring: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub statuses: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub team_discussions: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub vulnerability_alerts: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub watching: Option<String>,
    #[serde(skip_serializing_if = "Option::is_none")]
    pub workflows: Option<String>,
}
