// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{ffi, CompletionProvider};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkSourceCompletionWords")]
    pub struct CompletionWords(Object<ffi::GtkSourceCompletionWords, ffi::GtkSourceCompletionWordsClass>) @implements CompletionProvider;

    match fn {
        type_ => || ffi::gtk_source_completion_words_get_type(),
    }
}

impl CompletionWords {
    pub const NONE: Option<&'static CompletionWords> = None;

    #[doc(alias = "gtk_source_completion_words_new")]
    pub fn new(title: Option<&str>) -> CompletionWords {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gtk_source_completion_words_new(title.to_glib_none().0)) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`CompletionWords`] objects.
    ///
    /// This method returns an instance of [`CompletionWordsBuilder`](crate::builders::CompletionWordsBuilder) which can be used to create [`CompletionWords`] objects.
    pub fn builder() -> CompletionWordsBuilder {
        CompletionWordsBuilder::new()
    }
}

impl Default for CompletionWords {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`CompletionWords`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct CompletionWordsBuilder {
    builder: glib::object::ObjectBuilder<'static, CompletionWords>,
}

impl CompletionWordsBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn minimum_word_size(self, minimum_word_size: u32) -> Self {
        Self {
            builder: self
                .builder
                .property("minimum-word-size", minimum_word_size),
        }
    }

    pub fn priority(self, priority: i32) -> Self {
        Self {
            builder: self.builder.property("priority", priority),
        }
    }

    pub fn proposals_batch_size(self, proposals_batch_size: u32) -> Self {
        Self {
            builder: self
                .builder
                .property("proposals-batch-size", proposals_batch_size),
        }
    }

    pub fn scan_batch_size(self, scan_batch_size: u32) -> Self {
        Self {
            builder: self.builder.property("scan-batch-size", scan_batch_size),
        }
    }

    pub fn title(self, title: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("title", title.into()),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`CompletionWords`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> CompletionWords {
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::CompletionWords>> Sealed for T {}
}

pub trait CompletionWordsExt: IsA<CompletionWords> + sealed::Sealed + 'static {
    #[doc(alias = "gtk_source_completion_words_register")]
    fn register(&self, buffer: &impl IsA<gtk::TextBuffer>) {
        unsafe {
            ffi::gtk_source_completion_words_register(
                self.as_ref().to_glib_none().0,
                buffer.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_completion_words_unregister")]
    fn unregister(&self, buffer: &impl IsA<gtk::TextBuffer>) {
        unsafe {
            ffi::gtk_source_completion_words_unregister(
                self.as_ref().to_glib_none().0,
                buffer.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "minimum-word-size")]
    fn minimum_word_size(&self) -> u32 {
        ObjectExt::property(self.as_ref(), "minimum-word-size")
    }

    #[doc(alias = "minimum-word-size")]
    fn set_minimum_word_size(&self, minimum_word_size: u32) {
        ObjectExt::set_property(self.as_ref(), "minimum-word-size", minimum_word_size)
    }

    fn priority(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "priority")
    }

    fn set_priority(&self, priority: i32) {
        ObjectExt::set_property(self.as_ref(), "priority", priority)
    }

    #[doc(alias = "proposals-batch-size")]
    fn proposals_batch_size(&self) -> u32 {
        ObjectExt::property(self.as_ref(), "proposals-batch-size")
    }

    #[doc(alias = "proposals-batch-size")]
    fn set_proposals_batch_size(&self, proposals_batch_size: u32) {
        ObjectExt::set_property(self.as_ref(), "proposals-batch-size", proposals_batch_size)
    }

    #[doc(alias = "scan-batch-size")]
    fn scan_batch_size(&self) -> u32 {
        ObjectExt::property(self.as_ref(), "scan-batch-size")
    }

    #[doc(alias = "scan-batch-size")]
    fn set_scan_batch_size(&self, scan_batch_size: u32) {
        ObjectExt::set_property(self.as_ref(), "scan-batch-size", scan_batch_size)
    }

    fn set_title(&self, title: Option<&str>) {
        ObjectExt::set_property(self.as_ref(), "title", title)
    }

    #[doc(alias = "minimum-word-size")]
    fn connect_minimum_word_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_minimum_word_size_trampoline<
            P: IsA<CompletionWords>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceCompletionWords,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CompletionWords::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::minimum-word-size\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_minimum_word_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "priority")]
    fn connect_priority_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_priority_trampoline<
            P: IsA<CompletionWords>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceCompletionWords,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CompletionWords::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::priority\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_priority_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "proposals-batch-size")]
    fn connect_proposals_batch_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_proposals_batch_size_trampoline<
            P: IsA<CompletionWords>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceCompletionWords,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CompletionWords::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::proposals-batch-size\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_proposals_batch_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "scan-batch-size")]
    fn connect_scan_batch_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scan_batch_size_trampoline<
            P: IsA<CompletionWords>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceCompletionWords,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CompletionWords::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scan-batch-size\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_scan_batch_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "title")]
    fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_title_trampoline<
            P: IsA<CompletionWords>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceCompletionWords,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CompletionWords::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::title\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_title_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<CompletionWords>> CompletionWordsExt for O {}
