/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file IDriver.h
    \author Romain BONDUE
    \date 30/11/05 */
#ifndef __IDRIVER_H__
#define __IDRIVER_H__

#include <string>
#include <vector>
#include <stdexcept> // std::bad_alloc

#include "Exceptions.h"
#include "Parameters.h"



namespace nsWireless
{
    class IDriver
    {
      public :
        virtual ~IDriver () throw() {}

        virtual const std::string& GetProtoName () const throw() = 0;
        virtual std::string GetDeviceName () const throw() = 0;

        virtual std::string GetSSID () const throw (nsErrors::CSystemExc) = 0;
        virtual void SetSSID (const std::string&)
                                            throw (nsErrors::CSystemExc) = 0;
 
            // FIXME The exception profile.
        /** \return The unit is the GHz (2.462 for instance). */
        virtual double GetFrequency () const throw (nsErrors::CException) = 0;
        /** \param The unit is the GHz (2.462 for instance). */
        virtual void SetFrequency (double) throw (nsErrors::CSystemExc) = 0;

            // FIXME The exception profile.
        virtual unsigned GetChannel () const throw (nsErrors::CException) = 0;
        virtual void SetChannel (unsigned) throw (nsErrors::CSystemExc) = 0;

        // Unlike others GetXXX() members, this one requires root privileges.
        virtual CEncryptionD GetEncryption () throw (nsErrors::CSystemExc,
                                                     std::bad_alloc) = 0;
        virtual void SetEncryption (const CEncryptionD&)
                            throw (nsErrors::CSystemExc, std::bad_alloc) = 0;

        virtual Mode_e GetMode () const throw (nsErrors::CSystemExc) = 0;
        virtual void SetMode (Mode_e) throw (nsErrors::CSystemExc) = 0;

        virtual CQuality GetQuality () const throw (nsErrors::CSystemExc) = 0;

        /** \return The unit is the Kbps. */
        virtual int GetTxRate () const throw (nsErrors::CSystemExc) = 0;
        /** \param The unit is the Kbps. */
        virtual void SetTxRate (int) throw (nsErrors::CSystemExc) = 0;

        virtual CMacAddress GetAPMacAddr () const
                                            throw (nsErrors::CSystemExc) = 0;
        virtual void SetAPMacAddr (const CMacAddress&)
                            throw (std::bad_alloc, nsErrors::CSystemExc) = 0;

        virtual void Scan () throw (nsErrors::CSystemExc) = 0;
        virtual void GetScanResult (std::vector<CCell>&) const
                            throw (nsErrors::CException, std::bad_alloc) = 0;

        /** \return The maximum SSID size in byte. */
        virtual unsigned GetMaxSSIDSize () const throw() = 0;
        /** \return The maximum key size in byte. */
        virtual unsigned GetMaxKeySize () const throw() = 0;

        virtual const std::vector<CFreq>& GetSupportedFreq () const throw() = 0;
            // FIXME ? "auto" mode possible too.
            // May don't fill the vector if the driver doesn't support this.
        virtual void GetSupportedRates (std::vector<int>&) const
                                            throw (nsErrors::CSystemExc) = 0;
        virtual void Commit () throw (nsErrors::CSystemExc) = 0;

    }; // IDriver

} // namespace nsWireless

#endif // __IDRIVER_H__
