/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file WE17DriverRoot.hxx
    \author Romain BONDUE
    \date 17/02/2006
    \warning This file should only be included from WE17DriverRoot.h */
inline nsWireless::CWE17DriverRoot::~CWE17DriverRoot () throw() {}


inline void nsWireless::CWE17DriverRoot::SetSSID (const std::string& SSID)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetSSID (SSID);

} // SetSSID()


inline void nsWireless::CWE17DriverRoot::SetFrequency (double Frequency)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetFrequency (Frequency);

} // SetFrequency()


inline void nsWireless::CWE17DriverRoot::SetChannel (unsigned Channel)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetChannel (Channel);

} // SetChannel()


inline nsWireless::CEncryptionD nsWireless::CWE17DriverRoot::GetEncryption ()
                                    throw (nsErrors::CSystemExc, std::bad_alloc)
{
    return CSuWProtocol::GetEncryption();

} // GetEncryption()


inline void nsWireless::CWE17DriverRoot::SetEncryption (const CEncryptionD&
                                                                     Descriptor)
                                    throw (nsErrors::CSystemExc, std::bad_alloc)
{
    CSuWProtocol::SetEncryption (Descriptor);

} // SetEncryption()


inline void nsWireless::CWE17DriverRoot::SetMode (Mode_e Mode)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetMode (Mode);

} // SetMode()


inline void nsWireless::CWE17DriverRoot::SetTxRate (int TxRate)
                                                    throw (nsErrors::CSystemExc)
{
    CSuWProtocol::SetTxRate (TxRate);

} // SetTxRate()


inline void nsWireless::CWE17DriverRoot::SetAPMacAddr (const CMacAddress& Addr)
                                    throw (std::bad_alloc, nsErrors::CSystemExc)
{
    CSuWProtocol::SetAPMacAddr (Addr);

} // SetAPMacAddr()


inline void nsWireless::CWE17DriverRoot::Scan () throw (nsErrors::CSystemExc)
{
    CSuWProtocol::Scan();

} // Scan()
