### Helper functions:

* `adaptive.py`:
  `Adaptive` maintains samples used for memory footprint sparklines.
  
* `profile.py`:
  used to suspend/resume profiling of Scalene when run in the background (with `&`).

* `replacement_*.py`:
  Scalene needs to interpose on a variety of functions; this functionality is in these files.
  
* `runningstats.py`:
  `RunningStats` takes input samples and incrementally computes average and other statistics in a fixed amount of space.

* `sparkline.py`:
  Functions to generate sparklines, used to display memory consumption over time.

* `syntaxline.py`:
  A helper function for pretty-printing with the Rich library.


### Core Scalene functions:

* `scalene_arguments.py`:
  `ScaleneArguments` holds command-line arguments and their default values.

* `scalene_gpu.py`:
  `ScaleneGPU` wraps the NVIDIA library to conveniently provide access to GPU statistics required by Scalene.

* `scalene_magics.py`:
  Sets up the "magics" for using Scalene within Jupyter notebooks (`%scrun` and `%%scalene`).

* `scalene_output.py`:
  `ScaleneOutput` encapsulates functions used for generating Scalene's profiles either as text or HTML.

* `scalene_profiler.py`:
  The core of the Scalene profiler.
  
* `scalene_signals.py`:
  Defines the Unix signals that Scalene uses (some of which must be kept in sync with `include/sampleheap.hpp`).

* `scalene_statistics.py`:
  Operations for managing the statistics generated by Scalene.

* `scalene_version.py`:
  The version number of Scalene which ultimately is reflected on `pypi` (for `pip` installs, used by `setup.py` in the top level directory).
  
