/*							-- DO NOT EDIT --
 * Generated by smidump version 0.4.8:
 *   smidump -f scli \
 *     --scli-exclude='broadMauBasic' MAU-MIB
 *
 * Derived from MAU-MIB:
 *   Management information for 802.3 MAUs.
 *   
 *   The following reference is used throughout this MIB module:
 *   
 *   [IEEE802.3] refers to:
 *      IEEE Std 802.3, 2005 Edition: 'IEEE Standard for Information
 *      technology - Telecommunications and information exchange
 *      between systems - Local and metropolitan area networks -
 *      Specific requirements - Part 3: Carrier sense multiple
 *      access with collision detection (CSMA/CD) access method and
 *      physical layer specifications'.
 *   
 *      Of particular interest is Clause 30, 'Management'.
 *   
 *   Copyright (C) The IETF Trust (2007).
 *   This version of this MIB module is part of RFC 4836;
 *   see the RFC itself for full legal notices.
 *
 * Revision 2007-04-21 00:00:
 *   Updated to reference IANA maintaned textual
 *   conventions for MAU types, Media Availability state,
 *   Auto Negotiation capabilities, and jack types,
 *   instead of using internally defined values.
 *   
 *   This version is published as RFC 4836.
 *
 * Revision 2003-09-19 00:00:
 *   Updated to include support for 10 Gb/s MAUs.
 *   This resulted in the following revisions:
 *   - Added OBJECT-IDENTITY definitions for
 *     10 gigabit MAU types
 *   
 *   
 *   
 *   - Added fiberLC jack type to JackType TC
 *   - Extended ifMauTypeListBits with bits for
 *     the 10 gigabit MAU types
 *   - Added enumerations to ifMauMediaAvailable,
 *     and updated its DESCRIPTION to reflect
 *     behaviour at 10 Gb/s
 *   - Added 64-bit version of ifMauFalseCarriers
 *     and added mauIfGrpHCStats object group to
 *     contain the new object
 *   - Deprecated mauModIfCompl2 and replaced it
 *     with mauModIfCompl3, which includes the new
 *     object group
 *   
 *    This version published as RFC 3636.
 *
 * Revision 1999-08-24 04:00:
 *   This version published as RFC 2668.  Updated
 *   to include support for 1000 Mb/sec
 *   MAUs and flow control negotiation.
 *
 * Revision 1997-10-31 00:00:
 *   Version published as RFC 2239.
 *
 * Revision 1993-09-30 00:00:
 *   Initial version, published as RFC 1515.
 *
 * $Id: mau-mib.c 3180 2009-07-29 22:36:13Z schoenw $
 */

#include "mau-mib.h"

GNetSnmpEnum const mau_mib_enums_rpMauStatus[] = {
    { MAU_MIB_RPMAUSTATUS_OTHER,       "other" },
    { MAU_MIB_RPMAUSTATUS_UNKNOWN,     "unknown" },
    { MAU_MIB_RPMAUSTATUS_OPERATIONAL, "operational" },
    { MAU_MIB_RPMAUSTATUS_STANDBY,     "standby" },
    { MAU_MIB_RPMAUSTATUS_SHUTDOWN,    "shutdown" },
    { MAU_MIB_RPMAUSTATUS_RESET,       "reset" },
    { 0, NULL }
};

GNetSnmpEnum const mau_mib_enums_rpMauJabberState[] = {
    { MAU_MIB_RPMAUJABBERSTATE_OTHER,     "other" },
    { MAU_MIB_RPMAUJABBERSTATE_UNKNOWN,   "unknown" },
    { MAU_MIB_RPMAUJABBERSTATE_NOJABBER,  "noJabber" },
    { MAU_MIB_RPMAUJABBERSTATE_JABBERING, "jabbering" },
    { 0, NULL }
};

GNetSnmpEnum const mau_mib_enums_ifMauStatus[] = {
    { MAU_MIB_IFMAUSTATUS_OTHER,       "other" },
    { MAU_MIB_IFMAUSTATUS_UNKNOWN,     "unknown" },
    { MAU_MIB_IFMAUSTATUS_OPERATIONAL, "operational" },
    { MAU_MIB_IFMAUSTATUS_STANDBY,     "standby" },
    { MAU_MIB_IFMAUSTATUS_SHUTDOWN,    "shutdown" },
    { MAU_MIB_IFMAUSTATUS_RESET,       "reset" },
    { 0, NULL }
};

GNetSnmpEnum const mau_mib_enums_ifMauJabberState[] = {
    { MAU_MIB_IFMAUJABBERSTATE_OTHER,     "other" },
    { MAU_MIB_IFMAUJABBERSTATE_UNKNOWN,   "unknown" },
    { MAU_MIB_IFMAUJABBERSTATE_NOJABBER,  "noJabber" },
    { MAU_MIB_IFMAUJABBERSTATE_JABBERING, "jabbering" },
    { 0, NULL }
};

GNetSnmpEnum const mau_mib_enums_ifMauAutoNegAdminStatus[] = {
    { MAU_MIB_IFMAUAUTONEGADMINSTATUS_ENABLED,  "enabled" },
    { MAU_MIB_IFMAUAUTONEGADMINSTATUS_DISABLED, "disabled" },
    { 0, NULL }
};

GNetSnmpEnum const mau_mib_enums_ifMauAutoNegRemoteSignaling[] = {
    { MAU_MIB_IFMAUAUTONEGREMOTESIGNALING_DETECTED,    "detected" },
    { MAU_MIB_IFMAUAUTONEGREMOTESIGNALING_NOTDETECTED, "notdetected" },
    { 0, NULL }
};

GNetSnmpEnum const mau_mib_enums_ifMauAutoNegConfig[] = {
    { MAU_MIB_IFMAUAUTONEGCONFIG_OTHER,              "other" },
    { MAU_MIB_IFMAUAUTONEGCONFIG_CONFIGURING,        "configuring" },
    { MAU_MIB_IFMAUAUTONEGCONFIG_COMPLETE,           "complete" },
    { MAU_MIB_IFMAUAUTONEGCONFIG_DISABLED,           "disabled" },
    { MAU_MIB_IFMAUAUTONEGCONFIG_PARALLELDETECTFAIL, "parallelDetectFail" },
    { 0, NULL }
};

GNetSnmpEnum const mau_mib_enums_ifMauAutoNegRestart[] = {
    { MAU_MIB_IFMAUAUTONEGRESTART_RESTART,   "restart" },
    { MAU_MIB_IFMAUAUTONEGRESTART_NORESTART, "norestart" },
    { 0, NULL }
};

GNetSnmpEnum const mau_mib_enums_ifMauAutoNegRemoteFaultAdvertised[] = {
    { MAU_MIB_IFMAUAUTONEGREMOTEFAULTADVERTISED_NOERROR,      "noError" },
    { MAU_MIB_IFMAUAUTONEGREMOTEFAULTADVERTISED_OFFLINE,      "offline" },
    { MAU_MIB_IFMAUAUTONEGREMOTEFAULTADVERTISED_LINKFAILURE,  "linkFailure" },
    { MAU_MIB_IFMAUAUTONEGREMOTEFAULTADVERTISED_AUTONEGERROR, "autoNegError" },
    { 0, NULL }
};

GNetSnmpEnum const mau_mib_enums_ifMauAutoNegRemoteFaultReceived[] = {
    { MAU_MIB_IFMAUAUTONEGREMOTEFAULTRECEIVED_NOERROR,      "noError" },
    { MAU_MIB_IFMAUAUTONEGREMOTEFAULTRECEIVED_OFFLINE,      "offline" },
    { MAU_MIB_IFMAUAUTONEGREMOTEFAULTRECEIVED_LINKFAILURE,  "linkFailure" },
    { MAU_MIB_IFMAUAUTONEGREMOTEFAULTRECEIVED_AUTONEGERROR, "autoNegError" },
    { 0, NULL }
};

GNetSnmpEnum const mau_mib_enums_JackType[] = {
    { MAU_MIB_JACKTYPE_OTHER,    "other" },
    { MAU_MIB_JACKTYPE_RJ45,     "rj45" },
    { MAU_MIB_JACKTYPE_RJ45S,    "rj45S" },
    { MAU_MIB_JACKTYPE_DB9,      "db9" },
    { MAU_MIB_JACKTYPE_BNC,      "bnc" },
    { MAU_MIB_JACKTYPE_FAUI,     "fAUI" },
    { MAU_MIB_JACKTYPE_MAUI,     "mAUI" },
    { MAU_MIB_JACKTYPE_FIBERSC,  "fiberSC" },
    { MAU_MIB_JACKTYPE_FIBERMIC, "fiberMIC" },
    { MAU_MIB_JACKTYPE_FIBERST,  "fiberST" },
    { MAU_MIB_JACKTYPE_TELCO,    "telco" },
    { MAU_MIB_JACKTYPE_MTRJ,     "mtrj" },
    { MAU_MIB_JACKTYPE_HSSDC,    "hssdc" },
    { MAU_MIB_JACKTYPE_FIBERLC,  "fiberLC" },
    { 0, NULL }
};


static guint32 const rpMauJabberTrap[]
	= { MAU_MIB_RPMAUJABBERTRAP };
static guint32 const ifMauJabberTrap[]
	= { MAU_MIB_IFMAUJABBERTRAP };

GNetSnmpIdentity const mau_mib_notifications[] = {
    { rpMauJabberTrap,
      G_N_ELEMENTS(rpMauJabberTrap),
      "rpMauJabberTrap" },
    { ifMauJabberTrap,
      G_N_ELEMENTS(ifMauJabberTrap),
      "ifMauJabberTrap" },
    { 0, 0, NULL }
};


static guint32 const rpMauEntry_oid[] = {1, 3, 6, 1, 2, 1, 26, 1, 1, 1};

static GNetSnmpAttribute rpMauEntry_attr[] = {
    { 4, GNET_SNMP_VARBIND_TYPE_OBJECTID,
      MAU_MIB_RPMAUTYPE, "rpMauType",
       NULL,
      G_STRUCT_OFFSET(mau_mib_rpMauEntry_t, rpMauType),
      G_STRUCT_OFFSET(mau_mib_rpMauEntry_t, _rpMauTypeLength),
      0 },
    { 5, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_RPMAUSTATUS, "rpMauStatus",
       NULL,
      G_STRUCT_OFFSET(mau_mib_rpMauEntry_t, rpMauStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 6, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_RPMAUMEDIAAVAILABLE, "rpMauMediaAvailable",
       NULL,
      G_STRUCT_OFFSET(mau_mib_rpMauEntry_t, rpMauMediaAvailable),
      0,
      0 },
    { 7, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      MAU_MIB_RPMAUMEDIAAVAILABLESTATEEXITS, "rpMauMediaAvailableStateExits",
       NULL,
      G_STRUCT_OFFSET(mau_mib_rpMauEntry_t, rpMauMediaAvailableStateExits),
      0,
      0 },
    { 8, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_RPMAUJABBERSTATE, "rpMauJabberState",
       NULL,
      G_STRUCT_OFFSET(mau_mib_rpMauEntry_t, rpMauJabberState),
      0,
      0 },
    { 9, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      MAU_MIB_RPMAUJABBERINGSTATEENTERS, "rpMauJabberingStateEnters",
       NULL,
      G_STRUCT_OFFSET(mau_mib_rpMauEntry_t, rpMauJabberingStateEnters),
      0,
      0 },
    { 10, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      MAU_MIB_RPMAUFALSECARRIERS, "rpMauFalseCarriers",
       NULL,
      G_STRUCT_OFFSET(mau_mib_rpMauEntry_t, rpMauFalseCarriers),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const rpJackEntry_oid[] = {1, 3, 6, 1, 2, 1, 26, 1, 2, 1};

static GNetSnmpAttribute rpJackEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_RPJACKTYPE, "rpJackType",
       NULL,
      G_STRUCT_OFFSET(mau_mib_rpJackEntry_t, rpJackType),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const ifMauEntry_oid[] = {1, 3, 6, 1, 2, 1, 26, 2, 1, 1};

static GNetSnmpAttribute ifMauEntry_attr[] = {
    { 3, GNET_SNMP_VARBIND_TYPE_OBJECTID,
      MAU_MIB_IFMAUTYPE, "ifMauType",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauType),
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, _ifMauTypeLength),
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUSTATUS, "ifMauStatus",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 5, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUMEDIAAVAILABLE, "ifMauMediaAvailable",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauMediaAvailable),
      0,
      0 },
    { 6, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      MAU_MIB_IFMAUMEDIAAVAILABLESTATEEXITS, "ifMauMediaAvailableStateExits",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauMediaAvailableStateExits),
      0,
      0 },
    { 7, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUJABBERSTATE, "ifMauJabberState",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauJabberState),
      0,
      0 },
    { 8, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      MAU_MIB_IFMAUJABBERINGSTATEENTERS, "ifMauJabberingStateEnters",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauJabberingStateEnters),
      0,
      0 },
    { 9, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      MAU_MIB_IFMAUFALSECARRIERS, "ifMauFalseCarriers",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauFalseCarriers),
      0,
      0 },
    { 10, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUTYPELIST, "ifMauTypeList",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauTypeList),
      0,
      0 },
    { 11, GNET_SNMP_VARBIND_TYPE_OBJECTID,
      MAU_MIB_IFMAUDEFAULTTYPE, "ifMauDefaultType",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauDefaultType),
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, _ifMauDefaultTypeLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 12, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUAUTONEGSUPPORTED, "ifMauAutoNegSupported",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauAutoNegSupported),
      0,
      0 },
    { 13, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      MAU_MIB_IFMAUTYPELISTBITS, "ifMauTypeListBits",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauTypeListBits),
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, _ifMauTypeListBitsLength),
      0 },
    { 14, GNET_SNMP_VARBIND_TYPE_COUNTER64,
      MAU_MIB_IFMAUHCFALSECARRIERS, "ifMauHCFalseCarriers",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauHCFalseCarriers),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const ifJackEntry_oid[] = {1, 3, 6, 1, 2, 1, 26, 2, 2, 1};

static GNetSnmpAttribute ifJackEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFJACKTYPE, "ifJackType",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifJackEntry_t, ifJackType),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const ifMauAutoNegEntry_oid[] = {1, 3, 6, 1, 2, 1, 26, 5, 1, 1};

static GNetSnmpAttribute ifMauAutoNegEntry_attr[] = {
    { 1, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUAUTONEGADMINSTATUS, "ifMauAutoNegAdminStatus",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegAdminStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 2, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUAUTONEGREMOTESIGNALING, "ifMauAutoNegRemoteSignaling",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegRemoteSignaling),
      0,
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUAUTONEGCONFIG, "ifMauAutoNegConfig",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegConfig),
      0,
      0 },
    { 5, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUAUTONEGCAPABILITY, "ifMauAutoNegCapability",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegCapability),
      0,
      0 },
    { 6, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUAUTONEGCAPADVERTISED, "ifMauAutoNegCapAdvertised",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegCapAdvertised),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 7, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUAUTONEGCAPRECEIVED, "ifMauAutoNegCapReceived",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegCapReceived),
      0,
      0 },
    { 8, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUAUTONEGRESTART, "ifMauAutoNegRestart",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegRestart),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 9, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      MAU_MIB_IFMAUAUTONEGCAPABILITYBITS, "ifMauAutoNegCapabilityBits",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegCapabilityBits),
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, _ifMauAutoNegCapabilityBitsLength),
      0 },
    { 10, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      MAU_MIB_IFMAUAUTONEGCAPADVERTISEDBITS, "ifMauAutoNegCapAdvertisedBits",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegCapAdvertisedBits),
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, _ifMauAutoNegCapAdvertisedBitsLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 11, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      MAU_MIB_IFMAUAUTONEGCAPRECEIVEDBITS, "ifMauAutoNegCapReceivedBits",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegCapReceivedBits),
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, _ifMauAutoNegCapReceivedBitsLength),
      0 },
    { 12, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUAUTONEGREMOTEFAULTADVERTISED, "ifMauAutoNegRemoteFaultAdvertised",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegRemoteFaultAdvertised),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 13, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUAUTONEGREMOTEFAULTRECEIVED, "ifMauAutoNegRemoteFaultReceived",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegRemoteFaultReceived),
      0,
      0 },
    { 0, 0, 0, NULL }
};


mau_mib_rpMauEntry_t *
mau_mib_new_rpMauEntry()
{
    mau_mib_rpMauEntry_t *rpMauEntry;

    rpMauEntry = (mau_mib_rpMauEntry_t *) g_malloc0(sizeof(mau_mib_rpMauEntry_t) + sizeof(gpointer));
    return rpMauEntry;
}

static inline int
unpack_rpMauEntry(GNetSnmpVarBind *vb, mau_mib_rpMauEntry_t *rpMauEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    rpMauEntry->rpMauGroupIndex = vb->oid[idx++];
    if ((rpMauEntry->rpMauGroupIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    rpMauEntry->rpMauPortIndex = vb->oid[idx++];
    if ((rpMauEntry->rpMauPortIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    rpMauEntry->rpMauIndex = vb->oid[idx++];
    if ((rpMauEntry->rpMauIndex < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_rpMauEntry(guint32 *base, gint32 rpMauGroupIndex, gint32 rpMauPortIndex, gint32 rpMauIndex)
{
    guint8 idx = 11;

    base[idx++] = rpMauGroupIndex;
    base[idx++] = rpMauPortIndex;
    base[idx++] = rpMauIndex;
    return idx;
}

static inline mau_mib_rpMauEntry_t *
assign_rpMauEntry(GList *vbl)
{
    mau_mib_rpMauEntry_t *rpMauEntry;
    char *p;

    rpMauEntry = mau_mib_new_rpMauEntry();
    p = (char *) rpMauEntry + sizeof(mau_mib_rpMauEntry_t);
    * (GList **) p = vbl;

    if (unpack_rpMauEntry((GNetSnmpVarBind *) vbl->data, rpMauEntry) < 0) {
        g_warning("%s: invalid instance identifier", "rpMauEntry");
        g_free(rpMauEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, rpMauEntry_oid, G_N_ELEMENTS(rpMauEntry_oid),
                      rpMauEntry_attr, rpMauEntry);

    return rpMauEntry;
}

void
mau_mib_get_rpMauTable(GNetSnmp *s, mau_mib_rpMauEntry_t ***rpMauEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 26, 1, 1, 1, 0};
    guint32 base[128];

    *rpMauEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, rpMauEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *rpMauEntry = (mau_mib_rpMauEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(mau_mib_rpMauEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*rpMauEntry)[i] = assign_rpMauEntry(row->data);
        }
    }
}

void
mau_mib_get_rpMauEntry(GNetSnmp *s, mau_mib_rpMauEntry_t **rpMauEntry, gint32 rpMauGroupIndex, gint32 rpMauPortIndex, gint32 rpMauIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, rpMauEntry_oid, sizeof(rpMauEntry_oid));
    len = pack_rpMauEntry(base, rpMauGroupIndex, rpMauPortIndex, rpMauIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "rpMauEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *rpMauEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, rpMauEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *rpMauEntry = assign_rpMauEntry(out);
    }
}

void
mau_mib_set_rpMauEntry(GNetSnmp *s, mau_mib_rpMauEntry_t *rpMauEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, rpMauEntry_oid, sizeof(rpMauEntry_oid));
    len = pack_rpMauEntry(base, rpMauEntry->rpMauGroupIndex, rpMauEntry->rpMauPortIndex, rpMauEntry->rpMauIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "rpMauEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 10, rpMauEntry_attr, mask, rpMauEntry);

    out = gnet_snmp_sync_set(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
mau_mib_free_rpMauEntry(mau_mib_rpMauEntry_t *rpMauEntry)
{
    GList *vbl;
    char *p;

    if (rpMauEntry) {
        p = (char *) rpMauEntry + sizeof(mau_mib_rpMauEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(rpMauEntry);
    }
}

void
mau_mib_free_rpMauTable(mau_mib_rpMauEntry_t **rpMauEntry)
{
    int i;

    if (rpMauEntry) {
        for (i = 0; rpMauEntry[i]; i++) {
            mau_mib_free_rpMauEntry(rpMauEntry[i]);
        }
        g_free(rpMauEntry);
    }
}

mau_mib_rpJackEntry_t *
mau_mib_new_rpJackEntry()
{
    mau_mib_rpJackEntry_t *rpJackEntry;

    rpJackEntry = (mau_mib_rpJackEntry_t *) g_malloc0(sizeof(mau_mib_rpJackEntry_t) + sizeof(gpointer));
    return rpJackEntry;
}

static inline int
unpack_rpJackEntry(GNetSnmpVarBind *vb, mau_mib_rpJackEntry_t *rpJackEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    rpJackEntry->rpMauGroupIndex = vb->oid[idx++];
    if ((rpJackEntry->rpMauGroupIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    rpJackEntry->rpMauPortIndex = vb->oid[idx++];
    if ((rpJackEntry->rpMauPortIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    rpJackEntry->rpMauIndex = vb->oid[idx++];
    if ((rpJackEntry->rpMauIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    rpJackEntry->rpJackIndex = vb->oid[idx++];
    if ((rpJackEntry->rpJackIndex < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_rpJackEntry(guint32 *base, gint32 rpMauGroupIndex, gint32 rpMauPortIndex, gint32 rpMauIndex, gint32 rpJackIndex)
{
    guint8 idx = 11;

    base[idx++] = rpMauGroupIndex;
    base[idx++] = rpMauPortIndex;
    base[idx++] = rpMauIndex;
    base[idx++] = rpJackIndex;
    return idx;
}

static inline mau_mib_rpJackEntry_t *
assign_rpJackEntry(GList *vbl)
{
    mau_mib_rpJackEntry_t *rpJackEntry;
    char *p;

    rpJackEntry = mau_mib_new_rpJackEntry();
    p = (char *) rpJackEntry + sizeof(mau_mib_rpJackEntry_t);
    * (GList **) p = vbl;

    if (unpack_rpJackEntry((GNetSnmpVarBind *) vbl->data, rpJackEntry) < 0) {
        g_warning("%s: invalid instance identifier", "rpJackEntry");
        g_free(rpJackEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, rpJackEntry_oid, G_N_ELEMENTS(rpJackEntry_oid),
                      rpJackEntry_attr, rpJackEntry);

    return rpJackEntry;
}

void
mau_mib_get_rpJackTable(GNetSnmp *s, mau_mib_rpJackEntry_t ***rpJackEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 26, 1, 2, 1, 0};
    guint32 base[128];

    *rpJackEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, rpJackEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *rpJackEntry = (mau_mib_rpJackEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(mau_mib_rpJackEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*rpJackEntry)[i] = assign_rpJackEntry(row->data);
        }
    }
}

void
mau_mib_get_rpJackEntry(GNetSnmp *s, mau_mib_rpJackEntry_t **rpJackEntry, gint32 rpMauGroupIndex, gint32 rpMauPortIndex, gint32 rpMauIndex, gint32 rpJackIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, rpJackEntry_oid, sizeof(rpJackEntry_oid));
    len = pack_rpJackEntry(base, rpMauGroupIndex, rpMauPortIndex, rpMauIndex, rpJackIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "rpJackEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *rpJackEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, rpJackEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *rpJackEntry = assign_rpJackEntry(out);
    }
}

void
mau_mib_free_rpJackEntry(mau_mib_rpJackEntry_t *rpJackEntry)
{
    GList *vbl;
    char *p;

    if (rpJackEntry) {
        p = (char *) rpJackEntry + sizeof(mau_mib_rpJackEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(rpJackEntry);
    }
}

void
mau_mib_free_rpJackTable(mau_mib_rpJackEntry_t **rpJackEntry)
{
    int i;

    if (rpJackEntry) {
        for (i = 0; rpJackEntry[i]; i++) {
            mau_mib_free_rpJackEntry(rpJackEntry[i]);
        }
        g_free(rpJackEntry);
    }
}

mau_mib_ifMauEntry_t *
mau_mib_new_ifMauEntry()
{
    mau_mib_ifMauEntry_t *ifMauEntry;

    ifMauEntry = (mau_mib_ifMauEntry_t *) g_malloc0(sizeof(mau_mib_ifMauEntry_t) + sizeof(gpointer));
    return ifMauEntry;
}

static inline int
unpack_ifMauEntry(GNetSnmpVarBind *vb, mau_mib_ifMauEntry_t *ifMauEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    ifMauEntry->ifMauIfIndex = vb->oid[idx++];
    if ((ifMauEntry->ifMauIfIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    ifMauEntry->ifMauIndex = vb->oid[idx++];
    if ((ifMauEntry->ifMauIndex < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_ifMauEntry(guint32 *base, gint32 ifMauIfIndex, gint32 ifMauIndex)
{
    guint8 idx = 11;

    base[idx++] = ifMauIfIndex;
    base[idx++] = ifMauIndex;
    return idx;
}

static inline mau_mib_ifMauEntry_t *
assign_ifMauEntry(GList *vbl)
{
    mau_mib_ifMauEntry_t *ifMauEntry;
    char *p;

    ifMauEntry = mau_mib_new_ifMauEntry();
    p = (char *) ifMauEntry + sizeof(mau_mib_ifMauEntry_t);
    * (GList **) p = vbl;

    if (unpack_ifMauEntry((GNetSnmpVarBind *) vbl->data, ifMauEntry) < 0) {
        g_warning("%s: invalid instance identifier", "ifMauEntry");
        g_free(ifMauEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, ifMauEntry_oid, G_N_ELEMENTS(ifMauEntry_oid),
                      ifMauEntry_attr, ifMauEntry);

    return ifMauEntry;
}

void
mau_mib_get_ifMauTable(GNetSnmp *s, mau_mib_ifMauEntry_t ***ifMauEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 0};
    guint32 base[128];

    *ifMauEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, ifMauEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *ifMauEntry = (mau_mib_ifMauEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(mau_mib_ifMauEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*ifMauEntry)[i] = assign_ifMauEntry(row->data);
        }
    }
}

void
mau_mib_get_ifMauEntry(GNetSnmp *s, mau_mib_ifMauEntry_t **ifMauEntry, gint32 ifMauIfIndex, gint32 ifMauIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, ifMauEntry_oid, sizeof(ifMauEntry_oid));
    len = pack_ifMauEntry(base, ifMauIfIndex, ifMauIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "ifMauEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *ifMauEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, ifMauEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *ifMauEntry = assign_ifMauEntry(out);
    }
}

void
mau_mib_set_ifMauEntry(GNetSnmp *s, mau_mib_ifMauEntry_t *ifMauEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, ifMauEntry_oid, sizeof(ifMauEntry_oid));
    len = pack_ifMauEntry(base, ifMauEntry->ifMauIfIndex, ifMauEntry->ifMauIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "ifMauEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 10, ifMauEntry_attr, mask, ifMauEntry);

    out = gnet_snmp_sync_set(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
mau_mib_free_ifMauEntry(mau_mib_ifMauEntry_t *ifMauEntry)
{
    GList *vbl;
    char *p;

    if (ifMauEntry) {
        p = (char *) ifMauEntry + sizeof(mau_mib_ifMauEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(ifMauEntry);
    }
}

void
mau_mib_free_ifMauTable(mau_mib_ifMauEntry_t **ifMauEntry)
{
    int i;

    if (ifMauEntry) {
        for (i = 0; ifMauEntry[i]; i++) {
            mau_mib_free_ifMauEntry(ifMauEntry[i]);
        }
        g_free(ifMauEntry);
    }
}

mau_mib_ifJackEntry_t *
mau_mib_new_ifJackEntry()
{
    mau_mib_ifJackEntry_t *ifJackEntry;

    ifJackEntry = (mau_mib_ifJackEntry_t *) g_malloc0(sizeof(mau_mib_ifJackEntry_t) + sizeof(gpointer));
    return ifJackEntry;
}

static inline int
unpack_ifJackEntry(GNetSnmpVarBind *vb, mau_mib_ifJackEntry_t *ifJackEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    ifJackEntry->ifMauIfIndex = vb->oid[idx++];
    if ((ifJackEntry->ifMauIfIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    ifJackEntry->ifMauIndex = vb->oid[idx++];
    if ((ifJackEntry->ifMauIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    ifJackEntry->ifJackIndex = vb->oid[idx++];
    if ((ifJackEntry->ifJackIndex < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_ifJackEntry(guint32 *base, gint32 ifMauIfIndex, gint32 ifMauIndex, gint32 ifJackIndex)
{
    guint8 idx = 11;

    base[idx++] = ifMauIfIndex;
    base[idx++] = ifMauIndex;
    base[idx++] = ifJackIndex;
    return idx;
}

static inline mau_mib_ifJackEntry_t *
assign_ifJackEntry(GList *vbl)
{
    mau_mib_ifJackEntry_t *ifJackEntry;
    char *p;

    ifJackEntry = mau_mib_new_ifJackEntry();
    p = (char *) ifJackEntry + sizeof(mau_mib_ifJackEntry_t);
    * (GList **) p = vbl;

    if (unpack_ifJackEntry((GNetSnmpVarBind *) vbl->data, ifJackEntry) < 0) {
        g_warning("%s: invalid instance identifier", "ifJackEntry");
        g_free(ifJackEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, ifJackEntry_oid, G_N_ELEMENTS(ifJackEntry_oid),
                      ifJackEntry_attr, ifJackEntry);

    return ifJackEntry;
}

void
mau_mib_get_ifJackTable(GNetSnmp *s, mau_mib_ifJackEntry_t ***ifJackEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 26, 2, 2, 1, 0};
    guint32 base[128];

    *ifJackEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, ifJackEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *ifJackEntry = (mau_mib_ifJackEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(mau_mib_ifJackEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*ifJackEntry)[i] = assign_ifJackEntry(row->data);
        }
    }
}

void
mau_mib_get_ifJackEntry(GNetSnmp *s, mau_mib_ifJackEntry_t **ifJackEntry, gint32 ifMauIfIndex, gint32 ifMauIndex, gint32 ifJackIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, ifJackEntry_oid, sizeof(ifJackEntry_oid));
    len = pack_ifJackEntry(base, ifMauIfIndex, ifMauIndex, ifJackIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "ifJackEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *ifJackEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, ifJackEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *ifJackEntry = assign_ifJackEntry(out);
    }
}

void
mau_mib_free_ifJackEntry(mau_mib_ifJackEntry_t *ifJackEntry)
{
    GList *vbl;
    char *p;

    if (ifJackEntry) {
        p = (char *) ifJackEntry + sizeof(mau_mib_ifJackEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(ifJackEntry);
    }
}

void
mau_mib_free_ifJackTable(mau_mib_ifJackEntry_t **ifJackEntry)
{
    int i;

    if (ifJackEntry) {
        for (i = 0; ifJackEntry[i]; i++) {
            mau_mib_free_ifJackEntry(ifJackEntry[i]);
        }
        g_free(ifJackEntry);
    }
}

mau_mib_ifMauAutoNegEntry_t *
mau_mib_new_ifMauAutoNegEntry()
{
    mau_mib_ifMauAutoNegEntry_t *ifMauAutoNegEntry;

    ifMauAutoNegEntry = (mau_mib_ifMauAutoNegEntry_t *) g_malloc0(sizeof(mau_mib_ifMauAutoNegEntry_t) + sizeof(gpointer));
    return ifMauAutoNegEntry;
}

static inline int
unpack_ifMauAutoNegEntry(GNetSnmpVarBind *vb, mau_mib_ifMauAutoNegEntry_t *ifMauAutoNegEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    ifMauAutoNegEntry->ifMauIfIndex = vb->oid[idx++];
    if ((ifMauAutoNegEntry->ifMauIfIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    ifMauAutoNegEntry->ifMauIndex = vb->oid[idx++];
    if ((ifMauAutoNegEntry->ifMauIndex < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_ifMauAutoNegEntry(guint32 *base, gint32 ifMauIfIndex, gint32 ifMauIndex)
{
    guint8 idx = 11;

    base[idx++] = ifMauIfIndex;
    base[idx++] = ifMauIndex;
    return idx;
}

static inline mau_mib_ifMauAutoNegEntry_t *
assign_ifMauAutoNegEntry(GList *vbl)
{
    mau_mib_ifMauAutoNegEntry_t *ifMauAutoNegEntry;
    char *p;

    ifMauAutoNegEntry = mau_mib_new_ifMauAutoNegEntry();
    p = (char *) ifMauAutoNegEntry + sizeof(mau_mib_ifMauAutoNegEntry_t);
    * (GList **) p = vbl;

    if (unpack_ifMauAutoNegEntry((GNetSnmpVarBind *) vbl->data, ifMauAutoNegEntry) < 0) {
        g_warning("%s: invalid instance identifier", "ifMauAutoNegEntry");
        g_free(ifMauAutoNegEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, ifMauAutoNegEntry_oid, G_N_ELEMENTS(ifMauAutoNegEntry_oid),
                      ifMauAutoNegEntry_attr, ifMauAutoNegEntry);

    return ifMauAutoNegEntry;
}

void
mau_mib_get_ifMauAutoNegTable(GNetSnmp *s, mau_mib_ifMauAutoNegEntry_t ***ifMauAutoNegEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 0};
    guint32 base[128];

    *ifMauAutoNegEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, ifMauAutoNegEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *ifMauAutoNegEntry = (mau_mib_ifMauAutoNegEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(mau_mib_ifMauAutoNegEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*ifMauAutoNegEntry)[i] = assign_ifMauAutoNegEntry(row->data);
        }
    }
}

void
mau_mib_get_ifMauAutoNegEntry(GNetSnmp *s, mau_mib_ifMauAutoNegEntry_t **ifMauAutoNegEntry, gint32 ifMauIfIndex, gint32 ifMauIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, ifMauAutoNegEntry_oid, sizeof(ifMauAutoNegEntry_oid));
    len = pack_ifMauAutoNegEntry(base, ifMauIfIndex, ifMauIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "ifMauAutoNegEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *ifMauAutoNegEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, ifMauAutoNegEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *ifMauAutoNegEntry = assign_ifMauAutoNegEntry(out);
    }
}

void
mau_mib_set_ifMauAutoNegEntry(GNetSnmp *s, mau_mib_ifMauAutoNegEntry_t *ifMauAutoNegEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, ifMauAutoNegEntry_oid, sizeof(ifMauAutoNegEntry_oid));
    len = pack_ifMauAutoNegEntry(base, ifMauAutoNegEntry->ifMauIfIndex, ifMauAutoNegEntry->ifMauIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "ifMauAutoNegEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 10, ifMauAutoNegEntry_attr, mask, ifMauAutoNegEntry);

    out = gnet_snmp_sync_set(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
mau_mib_free_ifMauAutoNegEntry(mau_mib_ifMauAutoNegEntry_t *ifMauAutoNegEntry)
{
    GList *vbl;
    char *p;

    if (ifMauAutoNegEntry) {
        p = (char *) ifMauAutoNegEntry + sizeof(mau_mib_ifMauAutoNegEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(ifMauAutoNegEntry);
    }
}

void
mau_mib_free_ifMauAutoNegTable(mau_mib_ifMauAutoNegEntry_t **ifMauAutoNegEntry)
{
    int i;

    if (ifMauAutoNegEntry) {
        for (i = 0; ifMauAutoNegEntry[i]; i++) {
            mau_mib_free_ifMauAutoNegEntry(ifMauAutoNegEntry[i]);
        }
        g_free(ifMauAutoNegEntry);
    }
}


