/*							-- DO NOT EDIT --
 * Generated by smidump version 0.4.8:
 *   smidump -f scli --scli-set Printer-MIB
 *
 * Derived from Printer-MIB:
 *   The MIB module for management of printers.
 *   Copyright (C) The Internet Society (2004). This
 *   version of this MIB module was published
 *   in RFC 3805. For full legal notices see the RFC itself.
 *
 * Revision 2004-06-02 00:00:
 *   Printer MIB v2.
 *   Moved all enum groups to be maintained by IANA into new TCs
 *      within the ianaPrinterMIB, which is contained in this
 *      document.
 *   New TCs created from enums defined within RFC 1759 Objects:
 *      PrtPrintOrientationTC, PrtLocalizedDescriptionStringTC,
 *      PrtConsoleDescriptionStringTC, PrtChannelStateTC,
 *      PrtOutputStackingOrderTC, PrtOutputPageDeliveryOrientationTC,
 *      PrtMarkerCounterUnitTC, PrtMarkerSuppliesSupplyUnitTC,
 *      PrtMarkerSuppliesClassTC, PrtMarkerAddressabilityUnitTC,
 *      PrtMarkerColorantRoleTC, PrtMediaPathMaxSpeedPrintUnitTC,
 *      PrtInterpreterTwoWayTC, and PrtAlertSeverityLevelTC.
 *   The following four TCs have been deprecated:
 *      MediaUnit (replaced by PrtMediaUnitTC),
 *      CapacityUnit (replaced by PrtCapacityUnitTC),
 *      SubUnitStatus (replaced by PrtSubUnitStatusTC),
 *      CodedCharSet (replaced by IANACharset in IANA Charset MIB)
 *   Five new OBJECT-GROUPs: prtAuxilliarySheetGroup,
 *      prtInputSwitchingGroup, prtGeneralV2Group,
 *      prtAlertTableV2Group, prtChannelV2Group.
 *   Nine new objects added to those groups:
 *      prtAuxiliarySheetStartupPage, prtAuxiliarySheetBannerPage,
 *      prtGeneralPrinterName, prtGeneralSerialNumber,
 *      prtAlertCriticalEvents, prtAlertAllEvents,
 *   
 *   
 *      prtInputMediaLoadTimeout, prtInputNextIndex,
 *      prtChannelInformation.
 *   SYNTAX range changed from (0..65535) to (1..65535) for the
 *      index objects prtStorageRefSeqNumber, prtDeviceRefSeqNumber,
 *      and prtConsoleLightIndex.
 *   SYNTAX range changed from (0..65535) to (0..2147483647) for the
 *      objects prtStorageRefIndex and prtDeviceRefIndex to agree
 *      with the Host Resources MIB.
 *   Defined a range for the objects with a SYNTAX of Integer32:
 *      prtOutputDefaultIndex, prtInputMediaDimFeedDirDeclared,
 *      prtInputMediaDimXFeedDirDeclared, prtInputMaxCapacity,
 *      prtInputCurrentLevel, prtInputMediaDimFeedDirChosen,
 *      prtInputMediaDimXFeedDirChosen, prtInputMediaWeight,
 *      prtInputMediaFormParts, prtOutputIndex,
 *      prtOutputMaxCapacity, prtOutputRemainingCapacity,
 *      prtOutputMaxDimFeedDir, prtOutputMaxDimXFeedDir,
 *      prtOutputMinDimFeedDir, prtOutputMinDimXFeedDir,
 *      prtMarkerAddressibilityFeedDir,
 *      prtMarkerAddressibilityXFeedDir, prtMarkerNorthMargin,
 *      prtMarkerSouthMargin, prtMarkerWestMargin,
 *      prtMarkerEastMargin, prtMarkerSuppliesMaxCapacity,
 *      prtMarkerSuppliesLevel, prtMarkerColorantTonality,
 *      prtMediaPathMaxSpeed, prtMediaPathMaxMediaFeedDir,
 *      prtMediaPathMaxMediaXFeedDir, prtMediaPathMinMediaFeedDir,
 *      prtMediaPathMinMediaXFeedDir, prtChannelIndex,
 *      prtChannelCurrentJobCntlLangIndex, prtInterpreterIndex,
 *      prtChannelDefaultPageDescLangIndex, prtConsoleOnTime,
 *      prtInterpreterFeedAddressibility, prtConsoleOffTime,
 *      prtInterpreterXFeedAddressibility, prtAlertIndex,
 *      prtAlertGroupIndex, prtAlertLocation.
 *   Changed SYNTAX from Integer32 to InterfaceIndexOrZero for
 *      prtChannelIfIndex.
 *   Changed MAX-ACCESS of prtAlertIndex from not-accessible to
 *      Read-only and added a compliance statement to allow a
 *      MIN-ACCESS of accessible-for-notify.
 *   One new NOTIFICATION-GROUP: prtAlertTrapGroup which contains
 *      printerV2Alert.
 *   In MODULE-COMPLIANCE prtMIBCompliance, new OBJECT-GROUPs and
 *      the NOTIFICATION_GROUP, all in GROUP (not MANDATORY-GROUP)
 *      clauses.  The nine new objects are optional, i.e., this
 *      document is backward compatible with RFC 1759.
 *
 * Revision 1994-11-25 00:00:
 *   The original version of this MIB, published as RFC1759.
 *
 * $Id: printer-mib.c 3180 2009-07-29 22:36:13Z schoenw $
 */

#include "printer-mib.h"

GNetSnmpEnum const printer_mib_enums_PrtMediaUnitTC[] = {
    { PRINTER_MIB_PRTMEDIAUNITTC_TENTHOUSANDTHSOFINCHES, "tenThousandthsOfInches" },
    { PRINTER_MIB_PRTMEDIAUNITTC_MICROMETERS,            "micrometers" },
    { 0, NULL }
};

GNetSnmpEnum const printer_mib_enums_MediaUnit[] = {
    { PRINTER_MIB_MEDIAUNIT_TENTHOUSANDTHSOFINCHES, "tenThousandthsOfInches" },
    { PRINTER_MIB_MEDIAUNIT_MICROMETERS,            "micrometers" },
    { 0, NULL }
};

GNetSnmpEnum const printer_mib_enums_PrtCapacityUnitTC[] = {
    { PRINTER_MIB_PRTCAPACITYUNITTC_OTHER,                  "other" },
    { PRINTER_MIB_PRTCAPACITYUNITTC_UNKNOWN,                "unknown" },
    { PRINTER_MIB_PRTCAPACITYUNITTC_TENTHOUSANDTHSOFINCHES, "tenThousandthsOfInches" },
    { PRINTER_MIB_PRTCAPACITYUNITTC_MICROMETERS,            "micrometers" },
    { PRINTER_MIB_PRTCAPACITYUNITTC_SHEETS,                 "sheets" },
    { PRINTER_MIB_PRTCAPACITYUNITTC_FEET,                   "feet" },
    { PRINTER_MIB_PRTCAPACITYUNITTC_METERS,                 "meters" },
    { PRINTER_MIB_PRTCAPACITYUNITTC_ITEMS,                  "items" },
    { PRINTER_MIB_PRTCAPACITYUNITTC_PERCENT,                "percent" },
    { 0, NULL }
};

GNetSnmpEnum const printer_mib_enums_CapacityUnit[] = {
    { PRINTER_MIB_CAPACITYUNIT_TENTHOUSANDTHSOFINCHES, "tenThousandthsOfInches" },
    { PRINTER_MIB_CAPACITYUNIT_MICROMETERS,            "micrometers" },
    { PRINTER_MIB_CAPACITYUNIT_SHEETS,                 "sheets" },
    { PRINTER_MIB_CAPACITYUNIT_FEET,                   "feet" },
    { PRINTER_MIB_CAPACITYUNIT_METERS,                 "meters" },
    { 0, NULL }
};

GNetSnmpEnum const printer_mib_enums_PrtPrintOrientationTC[] = {
    { PRINTER_MIB_PRTPRINTORIENTATIONTC_OTHER,     "other" },
    { PRINTER_MIB_PRTPRINTORIENTATIONTC_PORTRAIT,  "portrait" },
    { PRINTER_MIB_PRTPRINTORIENTATIONTC_LANDSCAPE, "landscape" },
    { 0, NULL }
};

GNetSnmpEnum const printer_mib_enums_PresentOnOff[] = {
    { PRINTER_MIB_PRESENTONOFF_OTHER,      "other" },
    { PRINTER_MIB_PRESENTONOFF_ON,         "on" },
    { PRINTER_MIB_PRESENTONOFF_OFF,        "off" },
    { PRINTER_MIB_PRESENTONOFF_NOTPRESENT, "notPresent" },
    { 0, NULL }
};

GNetSnmpEnum const printer_mib_enums_CodedCharSet[] = {
    { PRINTER_MIB_CODEDCHARSET_OTHER, "other" },
    { 0, NULL }
};

GNetSnmpEnum const printer_mib_enums_PrtChannelStateTC[] = {
    { PRINTER_MIB_PRTCHANNELSTATETC_OTHER,             "other" },
    { PRINTER_MIB_PRTCHANNELSTATETC_PRINTDATAACCEPTED, "printDataAccepted" },
    { PRINTER_MIB_PRTCHANNELSTATETC_NODATAACCEPTED,    "noDataAccepted" },
    { 0, NULL }
};

GNetSnmpEnum const printer_mib_enums_PrtOutputStackingOrderTC[] = {
    { PRINTER_MIB_PRTOUTPUTSTACKINGORDERTC_UNKNOWN,     "unknown" },
    { PRINTER_MIB_PRTOUTPUTSTACKINGORDERTC_FIRSTTOLAST, "firstToLast" },
    { PRINTER_MIB_PRTOUTPUTSTACKINGORDERTC_LASTTOFIRST, "lastToFirst" },
    { 0, NULL }
};

GNetSnmpEnum const printer_mib_enums_PrtOutputPageDeliveryOrientationTC[] = {
    { PRINTER_MIB_PRTOUTPUTPAGEDELIVERYORIENTATIONTC_FACEUP,   "faceUp" },
    { PRINTER_MIB_PRTOUTPUTPAGEDELIVERYORIENTATIONTC_FACEDOWN, "faceDown" },
    { 0, NULL }
};

GNetSnmpEnum const printer_mib_enums_PrtMarkerCounterUnitTC[] = {
    { PRINTER_MIB_PRTMARKERCOUNTERUNITTC_TENTHOUSANDTHSOFINCHES, "tenThousandthsOfInches" },
    { PRINTER_MIB_PRTMARKERCOUNTERUNITTC_MICROMETERS,            "micrometers" },
    { PRINTER_MIB_PRTMARKERCOUNTERUNITTC_CHARACTERS,             "characters" },
    { PRINTER_MIB_PRTMARKERCOUNTERUNITTC_LINES,                  "lines" },
    { PRINTER_MIB_PRTMARKERCOUNTERUNITTC_IMPRESSIONS,            "impressions" },
    { PRINTER_MIB_PRTMARKERCOUNTERUNITTC_SHEETS,                 "sheets" },
    { PRINTER_MIB_PRTMARKERCOUNTERUNITTC_DOTROW,                 "dotRow" },
    { PRINTER_MIB_PRTMARKERCOUNTERUNITTC_HOURS,                  "hours" },
    { PRINTER_MIB_PRTMARKERCOUNTERUNITTC_FEET,                   "feet" },
    { PRINTER_MIB_PRTMARKERCOUNTERUNITTC_METERS,                 "meters" },
    { 0, NULL }
};

GNetSnmpEnum const printer_mib_enums_PrtMarkerSuppliesSupplyUnitTC[] = {
    { PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_OTHER,                  "other" },
    { PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_UNKNOWN,                "unknown" },
    { PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_TENTHOUSANDTHSOFINCHES, "tenThousandthsOfInches" },
    { PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_MICROMETERS,            "micrometers" },
    { PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_IMPRESSIONS,            "impressions" },
    { PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_SHEETS,                 "sheets" },
    { PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_HOURS,                  "hours" },
    { PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_THOUSANDTHSOFOUNCES,    "thousandthsOfOunces" },
    { PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_TENTHSOFGRAMS,          "tenthsOfGrams" },
    { PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_HUNDRETHSOFFLUIDOUNCES, "hundrethsOfFluidOunces" },
    { PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_TENTHSOFMILLILITERS,    "tenthsOfMilliliters" },
    { PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_FEET,                   "feet" },
    { PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_METERS,                 "meters" },
    { PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_ITEMS,                  "items" },
    { PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNITTC_PERCENT,                "percent" },
    { 0, NULL }
};

GNetSnmpEnum const printer_mib_enums_PrtMarkerSuppliesClassTC[] = {
    { PRINTER_MIB_PRTMARKERSUPPLIESCLASSTC_OTHER,                  "other" },
    { PRINTER_MIB_PRTMARKERSUPPLIESCLASSTC_SUPPLYTHATISCONSUMED,   "supplyThatIsConsumed" },
    { PRINTER_MIB_PRTMARKERSUPPLIESCLASSTC_RECEPTACLETHATISFILLED, "receptacleThatIsFilled" },
    { 0, NULL }
};

GNetSnmpEnum const printer_mib_enums_PrtMarkerColorantRoleTC[] = {
    { PRINTER_MIB_PRTMARKERCOLORANTROLETC_OTHER,   "other" },
    { PRINTER_MIB_PRTMARKERCOLORANTROLETC_PROCESS, "process" },
    { PRINTER_MIB_PRTMARKERCOLORANTROLETC_SPOT,    "spot" },
    { 0, NULL }
};

GNetSnmpEnum const printer_mib_enums_PrtMarkerAddressabilityUnitTC[] = {
    { PRINTER_MIB_PRTMARKERADDRESSABILITYUNITTC_TENTHOUSANDTHSOFINCHES, "tenThousandthsOfInches" },
    { PRINTER_MIB_PRTMARKERADDRESSABILITYUNITTC_MICROMETERS,            "micrometers" },
    { 0, NULL }
};

GNetSnmpEnum const printer_mib_enums_PrtMediaPathMaxSpeedPrintUnitTC[] = {
    { PRINTER_MIB_PRTMEDIAPATHMAXSPEEDPRINTUNITTC_TENTHOUSANDTHSOFINCHESPERHOUR, "tenThousandthsOfInchesPerHour" },
    { PRINTER_MIB_PRTMEDIAPATHMAXSPEEDPRINTUNITTC_MICROMETERSPERHOUR,            "micrometersPerHour" },
    { PRINTER_MIB_PRTMEDIAPATHMAXSPEEDPRINTUNITTC_CHARACTERSPERHOUR,             "charactersPerHour" },
    { PRINTER_MIB_PRTMEDIAPATHMAXSPEEDPRINTUNITTC_LINESPERHOUR,                  "linesPerHour" },
    { PRINTER_MIB_PRTMEDIAPATHMAXSPEEDPRINTUNITTC_IMPRESSIONSPERHOUR,            "impressionsPerHour" },
    { PRINTER_MIB_PRTMEDIAPATHMAXSPEEDPRINTUNITTC_SHEETSPERHOUR,                 "sheetsPerHour" },
    { PRINTER_MIB_PRTMEDIAPATHMAXSPEEDPRINTUNITTC_DOTROWPERHOUR,                 "dotRowPerHour" },
    { PRINTER_MIB_PRTMEDIAPATHMAXSPEEDPRINTUNITTC_FEETPERHOUR,                   "feetPerHour" },
    { PRINTER_MIB_PRTMEDIAPATHMAXSPEEDPRINTUNITTC_METERSPERHOUR,                 "metersPerHour" },
    { 0, NULL }
};

GNetSnmpEnum const printer_mib_enums_PrtInterpreterTwoWayTC[] = {
    { PRINTER_MIB_PRTINTERPRETERTWOWAYTC_YES, "yes" },
    { PRINTER_MIB_PRTINTERPRETERTWOWAYTC_NO,  "no" },
    { 0, NULL }
};

GNetSnmpEnum const printer_mib_enums_PrtAlertSeverityLevelTC[] = {
    { PRINTER_MIB_PRTALERTSEVERITYLEVELTC_OTHER,                    "other" },
    { PRINTER_MIB_PRTALERTSEVERITYLEVELTC_CRITICAL,                 "critical" },
    { PRINTER_MIB_PRTALERTSEVERITYLEVELTC_WARNING,                  "warning" },
    { PRINTER_MIB_PRTALERTSEVERITYLEVELTC_WARNINGBINARYCHANGEEVENT, "warningBinaryChangeEvent" },
    { 0, NULL }
};


static guint32 const printerV1Alert[]
	= { PRINTER_MIB_PRINTERV1ALERT };

GNetSnmpIdentity const printer_mib_identities[] = {
    { printerV1Alert,
      G_N_ELEMENTS(printerV1Alert),
      "printerV1Alert" },
    { 0, 0, NULL }
};


static guint32 const printerV2Alert[]
	= { PRINTER_MIB_PRINTERV2ALERT };

GNetSnmpIdentity const printer_mib_notifications[] = {
    { printerV2Alert,
      G_N_ELEMENTS(printerV2Alert),
      "printerV2Alert" },
    { 0, 0, NULL }
};


static gint32 prtGeneralCurrentLocalization_constraints[] = {1L, 65535L, 0, 0};
static guint16 prtGeneralCurrentOperator_constraints[] = {0U, 127U, 0, 0};
static guint16 prtGeneralServicePerson_constraints[] = {0U, 127U, 0, 0};
static gint32 prtInputDefaultIndex_constraints[] = {1L, 65535L, 0, 0};
static gint32 prtOutputDefaultIndex_constraints[] = {1L, 65535L, 0, 0};
static gint32 prtMarkerDefaultIndex_constraints[] = {1L, 65535L, 0, 0};
static gint32 prtMediaPathDefaultIndex_constraints[] = {1L, 65535L, 0, 0};
static gint32 prtConsoleLocalization_constraints[] = {1L, 65535L, 0, 0};
static gint32 prtConsoleNumberOfDisplayLines_constraints[] = {0L, 65535L, 0, 0};
static gint32 prtConsoleNumberOfDisplayChars_constraints[] = {0L, 65535L, 0, 0};
static guint16 prtGeneralPrinterName_constraints[] = {0U, 127U, 0, 0};
static guint16 prtGeneralSerialNumber_constraints[] = {0U, 255U, 0, 0};
static gint32 prtStorageRefIndex_constraints[] = {0L, 2147483647L, 0, 0};
static gint32 prtDeviceRefIndex_constraints[] = {0L, 2147483647L, 0, 0};
static guint16 prtCoverDescription_constraints[] = {0U, 255U, 0, 0};
static guint16 prtLocalizationLanguage_constraints[] = {2U, 2U, 0, 0};
static guint16 prtLocalizationCountry_constraints[] = {2U, 2U, 0, 0};
static gint32 prtInputMediaDimFeedDirDeclared_constraints[] = {-2L, 2147483647L, 0, 0};
static gint32 prtInputMediaDimXFeedDirDeclared_constraints[] = {-2L, 2147483647L, 0, 0};
static gint32 prtInputMediaDimFeedDirChosen_constraints[] = {-2L, 2147483647L, 0, 0};
static gint32 prtInputMediaDimXFeedDirChosen_constraints[] = {-2L, 2147483647L, 0, 0};
static gint32 prtInputMaxCapacity_constraints[] = {-2L, 2147483647L, 0, 0};
static gint32 prtInputCurrentLevel_constraints[] = {-3L, 2147483647L, 0, 0};
static gint32 prtInputStatus_constraints[] = {0L, 126L, 0, 0};
static guint16 prtInputMediaName_constraints[] = {0U, 63U, 0, 0};
static guint16 prtInputName_constraints[] = {0U, 63U, 0, 0};
static guint16 prtInputVendorName_constraints[] = {0U, 63U, 0, 0};
static guint16 prtInputModel_constraints[] = {0U, 63U, 0, 0};
static guint16 prtInputVersion_constraints[] = {0U, 63U, 0, 0};
static guint16 prtInputSerialNumber_constraints[] = {0U, 32U, 0, 0};
static guint16 prtInputDescription_constraints[] = {0U, 255U, 0, 0};
static gint32 prtInputMediaWeight_constraints[] = {-2L, 2147483647L, 0, 0};
static guint16 prtInputMediaType_constraints[] = {0U, 63U, 0, 0};
static guint16 prtInputMediaColor_constraints[] = {0U, 63U, 0, 0};
static gint32 prtInputMediaFormParts_constraints[] = {-2L, 2147483647L, 0, 0};
static gint32 prtInputMediaLoadTimeout_constraints[] = {-2L, 2147483647L, 0, 0};
static gint32 prtInputNextIndex_constraints[] = {-3L, 2147483647L, 0, 0};
static gint32 prtOutputMaxCapacity_constraints[] = {-2L, 2147483647L, 0, 0};
static gint32 prtOutputRemainingCapacity_constraints[] = {-3L, 2147483647L, 0, 0};
static gint32 prtOutputStatus_constraints[] = {0L, 126L, 0, 0};
static guint16 prtOutputName_constraints[] = {0U, 63U, 0, 0};
static guint16 prtOutputVendorName_constraints[] = {0U, 63U, 0, 0};
static guint16 prtOutputModel_constraints[] = {0U, 63U, 0, 0};
static guint16 prtOutputVersion_constraints[] = {0U, 63U, 0, 0};
static guint16 prtOutputSerialNumber_constraints[] = {0U, 63U, 0, 0};
static guint16 prtOutputDescription_constraints[] = {0U, 255U, 0, 0};
static gint32 prtOutputMaxDimFeedDir_constraints[] = {-2L, 2147483647L, 0, 0};
static gint32 prtOutputMaxDimXFeedDir_constraints[] = {-2L, 2147483647L, 0, 0};
static gint32 prtOutputMinDimFeedDir_constraints[] = {-2L, 2147483647L, 0, 0};
static gint32 prtOutputMinDimXFeedDir_constraints[] = {-2L, 2147483647L, 0, 0};
static gint32 prtMarkerProcessColorants_constraints[] = {0L, 65535L, 0, 0};
static gint32 prtMarkerSpotColorants_constraints[] = {0L, 65535L, 0, 0};
static gint32 prtMarkerAddressabilityFeedDir_constraints[] = {-2L, 2147483647L, 0, 0};
static gint32 prtMarkerAddressabilityXFeedDir_constraints[] = {-2L, 2147483647L, 0, 0};
static gint32 prtMarkerNorthMargin_constraints[] = {-2L, 2147483647L, 0, 0};
static gint32 prtMarkerSouthMargin_constraints[] = {-2L, 2147483647L, 0, 0};
static gint32 prtMarkerWestMargin_constraints[] = {-2L, 2147483647L, 0, 0};
static gint32 prtMarkerEastMargin_constraints[] = {-2L, 2147483647L, 0, 0};
static gint32 prtMarkerStatus_constraints[] = {0L, 126L, 0, 0};
static gint32 prtMarkerSuppliesMarkerIndex_constraints[] = {0L, 65535L, 0, 0};
static gint32 prtMarkerSuppliesColorantIndex_constraints[] = {0L, 65535L, 0, 0};
static guint16 prtMarkerSuppliesDescription_constraints[] = {0U, 255U, 0, 0};
static gint32 prtMarkerSuppliesMaxCapacity_constraints[] = {-2L, 2147483647L, 0, 0};
static gint32 prtMarkerSuppliesLevel_constraints[] = {-3L, 2147483647L, 0, 0};
static gint32 prtMarkerColorantMarkerIndex_constraints[] = {0L, 65535L, 0, 0};
static guint16 prtMarkerColorantValue_constraints[] = {0U, 255U, 0, 0};
static gint32 prtMarkerColorantTonality_constraints[] = {2L, 2147483647L, 0, 0};
static gint32 prtMediaPathMaxSpeed_constraints[] = {-2L, 2147483647L, 0, 0};
static gint32 prtMediaPathMaxMediaFeedDir_constraints[] = {-2L, 2147483647L, 0, 0};
static gint32 prtMediaPathMaxMediaXFeedDir_constraints[] = {-2L, 2147483647L, 0, 0};
static gint32 prtMediaPathMinMediaFeedDir_constraints[] = {-2L, 2147483647L, 0, 0};
static gint32 prtMediaPathMinMediaXFeedDir_constraints[] = {-2L, 2147483647L, 0, 0};
static guint16 prtMediaPathDescription_constraints[] = {0U, 255U, 0, 0};
static gint32 prtMediaPathStatus_constraints[] = {0L, 126L, 0, 0};
static guint16 prtChannelProtocolVersion_constraints[] = {0U, 63U, 0, 0};
static gint32 prtChannelCurrentJobCntlLangIndex_constraints[] = {0L, 65535L, 0, 0};
static gint32 prtChannelDefaultPageDescLangIndex_constraints[] = {0L, 65535L, 0, 0};
static gint32 prtChannelIfIndex_constraints[] = {0L, 2147483647L, 0, 0};
static gint32 prtChannelStatus_constraints[] = {0L, 126L, 0, 0};
static guint16 prtChannelInformation_constraints[] = {0U, 255U, 0, 0};
static guint16 prtInterpreterLangLevel_constraints[] = {0U, 31U, 0, 0};
static guint16 prtInterpreterLangVersion_constraints[] = {0U, 31U, 0, 0};
static guint16 prtInterpreterDescription_constraints[] = {0U, 255U, 0, 0};
static guint16 prtInterpreterVersion_constraints[] = {0U, 31U, 0, 0};
static gint32 prtInterpreterFeedAddressability_constraints[] = {-2L, 2147483647L, 0, 0};
static gint32 prtInterpreterXFeedAddressability_constraints[] = {-2L, 2147483647L, 0, 0};
static guint16 prtConsoleDisplayBufferText_constraints[] = {0U, 255U, 0, 0};
static gint32 prtConsoleOnTime_constraints[] = {0L, 2147483647L, 0, 0};
static gint32 prtConsoleOffTime_constraints[] = {0L, 2147483647L, 0, 0};
static guint16 prtConsoleDescription_constraints[] = {0U, 255U, 0, 0};
static gint32 prtAlertGroupIndex_constraints[] = {-1L, 2147483647L, 0, 0};
static gint32 prtAlertLocation_constraints[] = {-2L, 2147483647L, 0, 0};
static guint16 prtAlertDescription_constraints[] = {0U, 255U, 0, 0};


static guint32 const prtGeneralEntry_oid[] = {1, 3, 6, 1, 2, 1, 43, 5, 1, 1};

static GNetSnmpAttribute prtGeneralEntry_attr[] = {
    { 1, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      PRINTER_MIB_PRTGENERALCONFIGCHANGES, "prtGeneralConfigChanges",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtGeneralEntry_t, prtGeneralConfigChanges),
      0,
      0 },
    { 2, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTGENERALCURRENTLOCALIZATION, "prtGeneralCurrentLocalization",
       prtGeneralCurrentLocalization_constraints,
      G_STRUCT_OFFSET(printer_mib_prtGeneralEntry_t, prtGeneralCurrentLocalization),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 3, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTGENERALRESET, "prtGeneralReset",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtGeneralEntry_t, prtGeneralReset),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 4, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTGENERALCURRENTOPERATOR, "prtGeneralCurrentOperator",
       prtGeneralCurrentOperator_constraints,
      G_STRUCT_OFFSET(printer_mib_prtGeneralEntry_t, prtGeneralCurrentOperator),
      G_STRUCT_OFFSET(printer_mib_prtGeneralEntry_t, _prtGeneralCurrentOperatorLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 5, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTGENERALSERVICEPERSON, "prtGeneralServicePerson",
       prtGeneralServicePerson_constraints,
      G_STRUCT_OFFSET(printer_mib_prtGeneralEntry_t, prtGeneralServicePerson),
      G_STRUCT_OFFSET(printer_mib_prtGeneralEntry_t, _prtGeneralServicePersonLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 6, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTINPUTDEFAULTINDEX, "prtInputDefaultIndex",
       prtInputDefaultIndex_constraints,
      G_STRUCT_OFFSET(printer_mib_prtGeneralEntry_t, prtInputDefaultIndex),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 7, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTOUTPUTDEFAULTINDEX, "prtOutputDefaultIndex",
       prtOutputDefaultIndex_constraints,
      G_STRUCT_OFFSET(printer_mib_prtGeneralEntry_t, prtOutputDefaultIndex),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 8, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMARKERDEFAULTINDEX, "prtMarkerDefaultIndex",
       prtMarkerDefaultIndex_constraints,
      G_STRUCT_OFFSET(printer_mib_prtGeneralEntry_t, prtMarkerDefaultIndex),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 9, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMEDIAPATHDEFAULTINDEX, "prtMediaPathDefaultIndex",
       prtMediaPathDefaultIndex_constraints,
      G_STRUCT_OFFSET(printer_mib_prtGeneralEntry_t, prtMediaPathDefaultIndex),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 10, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTCONSOLELOCALIZATION, "prtConsoleLocalization",
       prtConsoleLocalization_constraints,
      G_STRUCT_OFFSET(printer_mib_prtGeneralEntry_t, prtConsoleLocalization),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 11, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTCONSOLENUMBEROFDISPLAYLINES, "prtConsoleNumberOfDisplayLines",
       prtConsoleNumberOfDisplayLines_constraints,
      G_STRUCT_OFFSET(printer_mib_prtGeneralEntry_t, prtConsoleNumberOfDisplayLines),
      0,
      0 },
    { 12, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTCONSOLENUMBEROFDISPLAYCHARS, "prtConsoleNumberOfDisplayChars",
       prtConsoleNumberOfDisplayChars_constraints,
      G_STRUCT_OFFSET(printer_mib_prtGeneralEntry_t, prtConsoleNumberOfDisplayChars),
      0,
      0 },
    { 13, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTCONSOLEDISABLE, "prtConsoleDisable",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtGeneralEntry_t, prtConsoleDisable),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 14, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTAUXILIARYSHEETSTARTUPPAGE, "prtAuxiliarySheetStartupPage",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtGeneralEntry_t, prtAuxiliarySheetStartupPage),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 15, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTAUXILIARYSHEETBANNERPAGE, "prtAuxiliarySheetBannerPage",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtGeneralEntry_t, prtAuxiliarySheetBannerPage),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 16, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTGENERALPRINTERNAME, "prtGeneralPrinterName",
       prtGeneralPrinterName_constraints,
      G_STRUCT_OFFSET(printer_mib_prtGeneralEntry_t, prtGeneralPrinterName),
      G_STRUCT_OFFSET(printer_mib_prtGeneralEntry_t, _prtGeneralPrinterNameLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 17, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTGENERALSERIALNUMBER, "prtGeneralSerialNumber",
       prtGeneralSerialNumber_constraints,
      G_STRUCT_OFFSET(printer_mib_prtGeneralEntry_t, prtGeneralSerialNumber),
      G_STRUCT_OFFSET(printer_mib_prtGeneralEntry_t, _prtGeneralSerialNumberLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 18, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      PRINTER_MIB_PRTALERTCRITICALEVENTS, "prtAlertCriticalEvents",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtGeneralEntry_t, prtAlertCriticalEvents),
      0,
      0 },
    { 19, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      PRINTER_MIB_PRTALERTALLEVENTS, "prtAlertAllEvents",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtGeneralEntry_t, prtAlertAllEvents),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const prtStorageRefEntry_oid[] = {1, 3, 6, 1, 2, 1, 43, 5, 2, 1};

static GNetSnmpAttribute prtStorageRefEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTSTORAGEREFINDEX, "prtStorageRefIndex",
       prtStorageRefIndex_constraints,
      G_STRUCT_OFFSET(printer_mib_prtStorageRefEntry_t, prtStorageRefIndex),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const prtDeviceRefEntry_oid[] = {1, 3, 6, 1, 2, 1, 43, 5, 3, 1};

static GNetSnmpAttribute prtDeviceRefEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTDEVICEREFINDEX, "prtDeviceRefIndex",
       prtDeviceRefIndex_constraints,
      G_STRUCT_OFFSET(printer_mib_prtDeviceRefEntry_t, prtDeviceRefIndex),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const prtCoverEntry_oid[] = {1, 3, 6, 1, 2, 1, 43, 6, 1, 1};

static GNetSnmpAttribute prtCoverEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTCOVERDESCRIPTION, "prtCoverDescription",
       prtCoverDescription_constraints,
      G_STRUCT_OFFSET(printer_mib_prtCoverEntry_t, prtCoverDescription),
      G_STRUCT_OFFSET(printer_mib_prtCoverEntry_t, _prtCoverDescriptionLength),
      0 },
    { 3, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTCOVERSTATUS, "prtCoverStatus",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtCoverEntry_t, prtCoverStatus),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const prtLocalizationEntry_oid[] = {1, 3, 6, 1, 2, 1, 43, 7, 1, 1};

static GNetSnmpAttribute prtLocalizationEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTLOCALIZATIONLANGUAGE, "prtLocalizationLanguage",
       prtLocalizationLanguage_constraints,
      G_STRUCT_OFFSET(printer_mib_prtLocalizationEntry_t, prtLocalizationLanguage),
      2,
      GSNMP_ATTR_FLAG_FIXED_LENGTH },
    { 3, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTLOCALIZATIONCOUNTRY, "prtLocalizationCountry",
       prtLocalizationCountry_constraints,
      G_STRUCT_OFFSET(printer_mib_prtLocalizationEntry_t, prtLocalizationCountry),
      2,
      GSNMP_ATTR_FLAG_FIXED_LENGTH },
    { 4, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTLOCALIZATIONCHARACTERSET, "prtLocalizationCharacterSet",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtLocalizationEntry_t, prtLocalizationCharacterSet),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const prtInputEntry_oid[] = {1, 3, 6, 1, 2, 1, 43, 8, 2, 1};

static GNetSnmpAttribute prtInputEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTINPUTTYPE, "prtInputType",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, prtInputType),
      0,
      0 },
    { 3, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTINPUTDIMUNIT, "prtInputDimUnit",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, prtInputDimUnit),
      0,
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTINPUTMEDIADIMFEEDDIRDECLARED, "prtInputMediaDimFeedDirDeclared",
       prtInputMediaDimFeedDirDeclared_constraints,
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, prtInputMediaDimFeedDirDeclared),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 5, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTINPUTMEDIADIMXFEEDDIRDECLARED, "prtInputMediaDimXFeedDirDeclared",
       prtInputMediaDimXFeedDirDeclared_constraints,
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, prtInputMediaDimXFeedDirDeclared),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 6, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTINPUTMEDIADIMFEEDDIRCHOSEN, "prtInputMediaDimFeedDirChosen",
       prtInputMediaDimFeedDirChosen_constraints,
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, prtInputMediaDimFeedDirChosen),
      0,
      0 },
    { 7, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTINPUTMEDIADIMXFEEDDIRCHOSEN, "prtInputMediaDimXFeedDirChosen",
       prtInputMediaDimXFeedDirChosen_constraints,
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, prtInputMediaDimXFeedDirChosen),
      0,
      0 },
    { 8, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTINPUTCAPACITYUNIT, "prtInputCapacityUnit",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, prtInputCapacityUnit),
      0,
      0 },
    { 9, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTINPUTMAXCAPACITY, "prtInputMaxCapacity",
       prtInputMaxCapacity_constraints,
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, prtInputMaxCapacity),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 10, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTINPUTCURRENTLEVEL, "prtInputCurrentLevel",
       prtInputCurrentLevel_constraints,
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, prtInputCurrentLevel),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 11, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTINPUTSTATUS, "prtInputStatus",
       prtInputStatus_constraints,
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, prtInputStatus),
      0,
      0 },
    { 12, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTINPUTMEDIANAME, "prtInputMediaName",
       prtInputMediaName_constraints,
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, prtInputMediaName),
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, _prtInputMediaNameLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 13, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTINPUTNAME, "prtInputName",
       prtInputName_constraints,
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, prtInputName),
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, _prtInputNameLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 14, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTINPUTVENDORNAME, "prtInputVendorName",
       prtInputVendorName_constraints,
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, prtInputVendorName),
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, _prtInputVendorNameLength),
      0 },
    { 15, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTINPUTMODEL, "prtInputModel",
       prtInputModel_constraints,
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, prtInputModel),
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, _prtInputModelLength),
      0 },
    { 16, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTINPUTVERSION, "prtInputVersion",
       prtInputVersion_constraints,
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, prtInputVersion),
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, _prtInputVersionLength),
      0 },
    { 17, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTINPUTSERIALNUMBER, "prtInputSerialNumber",
       prtInputSerialNumber_constraints,
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, prtInputSerialNumber),
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, _prtInputSerialNumberLength),
      0 },
    { 18, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTINPUTDESCRIPTION, "prtInputDescription",
       prtInputDescription_constraints,
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, prtInputDescription),
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, _prtInputDescriptionLength),
      0 },
    { 19, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTINPUTSECURITY, "prtInputSecurity",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, prtInputSecurity),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 20, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTINPUTMEDIAWEIGHT, "prtInputMediaWeight",
       prtInputMediaWeight_constraints,
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, prtInputMediaWeight),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 21, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTINPUTMEDIATYPE, "prtInputMediaType",
       prtInputMediaType_constraints,
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, prtInputMediaType),
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, _prtInputMediaTypeLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 22, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTINPUTMEDIACOLOR, "prtInputMediaColor",
       prtInputMediaColor_constraints,
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, prtInputMediaColor),
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, _prtInputMediaColorLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 23, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTINPUTMEDIAFORMPARTS, "prtInputMediaFormParts",
       prtInputMediaFormParts_constraints,
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, prtInputMediaFormParts),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 24, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTINPUTMEDIALOADTIMEOUT, "prtInputMediaLoadTimeout",
       prtInputMediaLoadTimeout_constraints,
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, prtInputMediaLoadTimeout),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 25, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTINPUTNEXTINDEX, "prtInputNextIndex",
       prtInputNextIndex_constraints,
      G_STRUCT_OFFSET(printer_mib_prtInputEntry_t, prtInputNextIndex),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 0, 0, 0, NULL }
};

static guint32 const prtOutputEntry_oid[] = {1, 3, 6, 1, 2, 1, 43, 9, 2, 1};

static GNetSnmpAttribute prtOutputEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTOUTPUTTYPE, "prtOutputType",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, prtOutputType),
      0,
      0 },
    { 3, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTOUTPUTCAPACITYUNIT, "prtOutputCapacityUnit",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, prtOutputCapacityUnit),
      0,
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTOUTPUTMAXCAPACITY, "prtOutputMaxCapacity",
       prtOutputMaxCapacity_constraints,
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, prtOutputMaxCapacity),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 5, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTOUTPUTREMAININGCAPACITY, "prtOutputRemainingCapacity",
       prtOutputRemainingCapacity_constraints,
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, prtOutputRemainingCapacity),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 6, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTOUTPUTSTATUS, "prtOutputStatus",
       prtOutputStatus_constraints,
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, prtOutputStatus),
      0,
      0 },
    { 7, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTOUTPUTNAME, "prtOutputName",
       prtOutputName_constraints,
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, prtOutputName),
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, _prtOutputNameLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 8, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTOUTPUTVENDORNAME, "prtOutputVendorName",
       prtOutputVendorName_constraints,
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, prtOutputVendorName),
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, _prtOutputVendorNameLength),
      0 },
    { 9, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTOUTPUTMODEL, "prtOutputModel",
       prtOutputModel_constraints,
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, prtOutputModel),
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, _prtOutputModelLength),
      0 },
    { 10, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTOUTPUTVERSION, "prtOutputVersion",
       prtOutputVersion_constraints,
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, prtOutputVersion),
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, _prtOutputVersionLength),
      0 },
    { 11, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTOUTPUTSERIALNUMBER, "prtOutputSerialNumber",
       prtOutputSerialNumber_constraints,
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, prtOutputSerialNumber),
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, _prtOutputSerialNumberLength),
      0 },
    { 12, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTOUTPUTDESCRIPTION, "prtOutputDescription",
       prtOutputDescription_constraints,
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, prtOutputDescription),
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, _prtOutputDescriptionLength),
      0 },
    { 13, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTOUTPUTSECURITY, "prtOutputSecurity",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, prtOutputSecurity),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 14, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTOUTPUTDIMUNIT, "prtOutputDimUnit",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, prtOutputDimUnit),
      0,
      0 },
    { 15, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTOUTPUTMAXDIMFEEDDIR, "prtOutputMaxDimFeedDir",
       prtOutputMaxDimFeedDir_constraints,
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, prtOutputMaxDimFeedDir),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 16, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTOUTPUTMAXDIMXFEEDDIR, "prtOutputMaxDimXFeedDir",
       prtOutputMaxDimXFeedDir_constraints,
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, prtOutputMaxDimXFeedDir),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 17, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTOUTPUTMINDIMFEEDDIR, "prtOutputMinDimFeedDir",
       prtOutputMinDimFeedDir_constraints,
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, prtOutputMinDimFeedDir),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 18, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTOUTPUTMINDIMXFEEDDIR, "prtOutputMinDimXFeedDir",
       prtOutputMinDimXFeedDir_constraints,
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, prtOutputMinDimXFeedDir),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 19, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTOUTPUTSTACKINGORDER, "prtOutputStackingOrder",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, prtOutputStackingOrder),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 20, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTOUTPUTPAGEDELIVERYORIENTATION, "prtOutputPageDeliveryOrientation",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, prtOutputPageDeliveryOrientation),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 21, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTOUTPUTBURSTING, "prtOutputBursting",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, prtOutputBursting),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 22, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTOUTPUTDECOLLATING, "prtOutputDecollating",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, prtOutputDecollating),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 23, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTOUTPUTPAGECOLLATED, "prtOutputPageCollated",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, prtOutputPageCollated),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 24, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTOUTPUTOFFSETSTACKING, "prtOutputOffsetStacking",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtOutputEntry_t, prtOutputOffsetStacking),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 0, 0, 0, NULL }
};

static guint32 const prtMarkerEntry_oid[] = {1, 3, 6, 1, 2, 1, 43, 10, 2, 1};

static GNetSnmpAttribute prtMarkerEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMARKERMARKTECH, "prtMarkerMarkTech",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtMarkerEntry_t, prtMarkerMarkTech),
      0,
      0 },
    { 3, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMARKERCOUNTERUNIT, "prtMarkerCounterUnit",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtMarkerEntry_t, prtMarkerCounterUnit),
      0,
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      PRINTER_MIB_PRTMARKERLIFECOUNT, "prtMarkerLifeCount",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtMarkerEntry_t, prtMarkerLifeCount),
      0,
      0 },
    { 5, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      PRINTER_MIB_PRTMARKERPOWERONCOUNT, "prtMarkerPowerOnCount",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtMarkerEntry_t, prtMarkerPowerOnCount),
      0,
      0 },
    { 6, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMARKERPROCESSCOLORANTS, "prtMarkerProcessColorants",
       prtMarkerProcessColorants_constraints,
      G_STRUCT_OFFSET(printer_mib_prtMarkerEntry_t, prtMarkerProcessColorants),
      0,
      0 },
    { 7, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMARKERSPOTCOLORANTS, "prtMarkerSpotColorants",
       prtMarkerSpotColorants_constraints,
      G_STRUCT_OFFSET(printer_mib_prtMarkerEntry_t, prtMarkerSpotColorants),
      0,
      0 },
    { 8, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMARKERADDRESSABILITYUNIT, "prtMarkerAddressabilityUnit",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtMarkerEntry_t, prtMarkerAddressabilityUnit),
      0,
      0 },
    { 9, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMARKERADDRESSABILITYFEEDDIR, "prtMarkerAddressabilityFeedDir",
       prtMarkerAddressabilityFeedDir_constraints,
      G_STRUCT_OFFSET(printer_mib_prtMarkerEntry_t, prtMarkerAddressabilityFeedDir),
      0,
      0 },
    { 10, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMARKERADDRESSABILITYXFEEDDIR, "prtMarkerAddressabilityXFeedDir",
       prtMarkerAddressabilityXFeedDir_constraints,
      G_STRUCT_OFFSET(printer_mib_prtMarkerEntry_t, prtMarkerAddressabilityXFeedDir),
      0,
      0 },
    { 11, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMARKERNORTHMARGIN, "prtMarkerNorthMargin",
       prtMarkerNorthMargin_constraints,
      G_STRUCT_OFFSET(printer_mib_prtMarkerEntry_t, prtMarkerNorthMargin),
      0,
      0 },
    { 12, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMARKERSOUTHMARGIN, "prtMarkerSouthMargin",
       prtMarkerSouthMargin_constraints,
      G_STRUCT_OFFSET(printer_mib_prtMarkerEntry_t, prtMarkerSouthMargin),
      0,
      0 },
    { 13, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMARKERWESTMARGIN, "prtMarkerWestMargin",
       prtMarkerWestMargin_constraints,
      G_STRUCT_OFFSET(printer_mib_prtMarkerEntry_t, prtMarkerWestMargin),
      0,
      0 },
    { 14, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMARKEREASTMARGIN, "prtMarkerEastMargin",
       prtMarkerEastMargin_constraints,
      G_STRUCT_OFFSET(printer_mib_prtMarkerEntry_t, prtMarkerEastMargin),
      0,
      0 },
    { 15, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMARKERSTATUS, "prtMarkerStatus",
       prtMarkerStatus_constraints,
      G_STRUCT_OFFSET(printer_mib_prtMarkerEntry_t, prtMarkerStatus),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const prtMarkerSuppliesEntry_oid[] = {1, 3, 6, 1, 2, 1, 43, 11, 1, 1};

static GNetSnmpAttribute prtMarkerSuppliesEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMARKERSUPPLIESMARKERINDEX, "prtMarkerSuppliesMarkerIndex",
       prtMarkerSuppliesMarkerIndex_constraints,
      G_STRUCT_OFFSET(printer_mib_prtMarkerSuppliesEntry_t, prtMarkerSuppliesMarkerIndex),
      0,
      0 },
    { 3, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMARKERSUPPLIESCOLORANTINDEX, "prtMarkerSuppliesColorantIndex",
       prtMarkerSuppliesColorantIndex_constraints,
      G_STRUCT_OFFSET(printer_mib_prtMarkerSuppliesEntry_t, prtMarkerSuppliesColorantIndex),
      0,
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMARKERSUPPLIESCLASS, "prtMarkerSuppliesClass",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtMarkerSuppliesEntry_t, prtMarkerSuppliesClass),
      0,
      0 },
    { 5, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMARKERSUPPLIESTYPE, "prtMarkerSuppliesType",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtMarkerSuppliesEntry_t, prtMarkerSuppliesType),
      0,
      0 },
    { 6, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTMARKERSUPPLIESDESCRIPTION, "prtMarkerSuppliesDescription",
       prtMarkerSuppliesDescription_constraints,
      G_STRUCT_OFFSET(printer_mib_prtMarkerSuppliesEntry_t, prtMarkerSuppliesDescription),
      G_STRUCT_OFFSET(printer_mib_prtMarkerSuppliesEntry_t, _prtMarkerSuppliesDescriptionLength),
      0 },
    { 7, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMARKERSUPPLIESSUPPLYUNIT, "prtMarkerSuppliesSupplyUnit",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtMarkerSuppliesEntry_t, prtMarkerSuppliesSupplyUnit),
      0,
      0 },
    { 8, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMARKERSUPPLIESMAXCAPACITY, "prtMarkerSuppliesMaxCapacity",
       prtMarkerSuppliesMaxCapacity_constraints,
      G_STRUCT_OFFSET(printer_mib_prtMarkerSuppliesEntry_t, prtMarkerSuppliesMaxCapacity),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 9, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMARKERSUPPLIESLEVEL, "prtMarkerSuppliesLevel",
       prtMarkerSuppliesLevel_constraints,
      G_STRUCT_OFFSET(printer_mib_prtMarkerSuppliesEntry_t, prtMarkerSuppliesLevel),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 0, 0, 0, NULL }
};

static guint32 const prtMarkerColorantEntry_oid[] = {1, 3, 6, 1, 2, 1, 43, 12, 1, 1};

static GNetSnmpAttribute prtMarkerColorantEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMARKERCOLORANTMARKERINDEX, "prtMarkerColorantMarkerIndex",
       prtMarkerColorantMarkerIndex_constraints,
      G_STRUCT_OFFSET(printer_mib_prtMarkerColorantEntry_t, prtMarkerColorantMarkerIndex),
      0,
      0 },
    { 3, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMARKERCOLORANTROLE, "prtMarkerColorantRole",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtMarkerColorantEntry_t, prtMarkerColorantRole),
      0,
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTMARKERCOLORANTVALUE, "prtMarkerColorantValue",
       prtMarkerColorantValue_constraints,
      G_STRUCT_OFFSET(printer_mib_prtMarkerColorantEntry_t, prtMarkerColorantValue),
      G_STRUCT_OFFSET(printer_mib_prtMarkerColorantEntry_t, _prtMarkerColorantValueLength),
      0 },
    { 5, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMARKERCOLORANTTONALITY, "prtMarkerColorantTonality",
       prtMarkerColorantTonality_constraints,
      G_STRUCT_OFFSET(printer_mib_prtMarkerColorantEntry_t, prtMarkerColorantTonality),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const prtMediaPathEntry_oid[] = {1, 3, 6, 1, 2, 1, 43, 13, 4, 1};

static GNetSnmpAttribute prtMediaPathEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMEDIAPATHMAXSPEEDPRINTUNIT, "prtMediaPathMaxSpeedPrintUnit",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtMediaPathEntry_t, prtMediaPathMaxSpeedPrintUnit),
      0,
      0 },
    { 3, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMEDIAPATHMEDIASIZEUNIT, "prtMediaPathMediaSizeUnit",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtMediaPathEntry_t, prtMediaPathMediaSizeUnit),
      0,
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMEDIAPATHMAXSPEED, "prtMediaPathMaxSpeed",
       prtMediaPathMaxSpeed_constraints,
      G_STRUCT_OFFSET(printer_mib_prtMediaPathEntry_t, prtMediaPathMaxSpeed),
      0,
      0 },
    { 5, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMEDIAPATHMAXMEDIAFEEDDIR, "prtMediaPathMaxMediaFeedDir",
       prtMediaPathMaxMediaFeedDir_constraints,
      G_STRUCT_OFFSET(printer_mib_prtMediaPathEntry_t, prtMediaPathMaxMediaFeedDir),
      0,
      0 },
    { 6, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMEDIAPATHMAXMEDIAXFEEDDIR, "prtMediaPathMaxMediaXFeedDir",
       prtMediaPathMaxMediaXFeedDir_constraints,
      G_STRUCT_OFFSET(printer_mib_prtMediaPathEntry_t, prtMediaPathMaxMediaXFeedDir),
      0,
      0 },
    { 7, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMEDIAPATHMINMEDIAFEEDDIR, "prtMediaPathMinMediaFeedDir",
       prtMediaPathMinMediaFeedDir_constraints,
      G_STRUCT_OFFSET(printer_mib_prtMediaPathEntry_t, prtMediaPathMinMediaFeedDir),
      0,
      0 },
    { 8, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMEDIAPATHMINMEDIAXFEEDDIR, "prtMediaPathMinMediaXFeedDir",
       prtMediaPathMinMediaXFeedDir_constraints,
      G_STRUCT_OFFSET(printer_mib_prtMediaPathEntry_t, prtMediaPathMinMediaXFeedDir),
      0,
      0 },
    { 9, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMEDIAPATHTYPE, "prtMediaPathType",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtMediaPathEntry_t, prtMediaPathType),
      0,
      0 },
    { 10, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTMEDIAPATHDESCRIPTION, "prtMediaPathDescription",
       prtMediaPathDescription_constraints,
      G_STRUCT_OFFSET(printer_mib_prtMediaPathEntry_t, prtMediaPathDescription),
      G_STRUCT_OFFSET(printer_mib_prtMediaPathEntry_t, _prtMediaPathDescriptionLength),
      0 },
    { 11, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTMEDIAPATHSTATUS, "prtMediaPathStatus",
       prtMediaPathStatus_constraints,
      G_STRUCT_OFFSET(printer_mib_prtMediaPathEntry_t, prtMediaPathStatus),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const prtChannelEntry_oid[] = {1, 3, 6, 1, 2, 1, 43, 14, 1, 1};

static GNetSnmpAttribute prtChannelEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTCHANNELTYPE, "prtChannelType",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtChannelEntry_t, prtChannelType),
      0,
      0 },
    { 3, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTCHANNELPROTOCOLVERSION, "prtChannelProtocolVersion",
       prtChannelProtocolVersion_constraints,
      G_STRUCT_OFFSET(printer_mib_prtChannelEntry_t, prtChannelProtocolVersion),
      G_STRUCT_OFFSET(printer_mib_prtChannelEntry_t, _prtChannelProtocolVersionLength),
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTCHANNELCURRENTJOBCNTLLANGINDEX, "prtChannelCurrentJobCntlLangIndex",
       prtChannelCurrentJobCntlLangIndex_constraints,
      G_STRUCT_OFFSET(printer_mib_prtChannelEntry_t, prtChannelCurrentJobCntlLangIndex),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 5, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTCHANNELDEFAULTPAGEDESCLANGINDEX, "prtChannelDefaultPageDescLangIndex",
       prtChannelDefaultPageDescLangIndex_constraints,
      G_STRUCT_OFFSET(printer_mib_prtChannelEntry_t, prtChannelDefaultPageDescLangIndex),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 6, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTCHANNELSTATE, "prtChannelState",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtChannelEntry_t, prtChannelState),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 7, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTCHANNELIFINDEX, "prtChannelIfIndex",
       prtChannelIfIndex_constraints,
      G_STRUCT_OFFSET(printer_mib_prtChannelEntry_t, prtChannelIfIndex),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 8, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTCHANNELSTATUS, "prtChannelStatus",
       prtChannelStatus_constraints,
      G_STRUCT_OFFSET(printer_mib_prtChannelEntry_t, prtChannelStatus),
      0,
      0 },
    { 9, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTCHANNELINFORMATION, "prtChannelInformation",
       prtChannelInformation_constraints,
      G_STRUCT_OFFSET(printer_mib_prtChannelEntry_t, prtChannelInformation),
      G_STRUCT_OFFSET(printer_mib_prtChannelEntry_t, _prtChannelInformationLength),
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const prtInterpreterEntry_oid[] = {1, 3, 6, 1, 2, 1, 43, 15, 1, 1};

static GNetSnmpAttribute prtInterpreterEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTINTERPRETERLANGFAMILY, "prtInterpreterLangFamily",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtInterpreterEntry_t, prtInterpreterLangFamily),
      0,
      0 },
    { 3, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTINTERPRETERLANGLEVEL, "prtInterpreterLangLevel",
       prtInterpreterLangLevel_constraints,
      G_STRUCT_OFFSET(printer_mib_prtInterpreterEntry_t, prtInterpreterLangLevel),
      G_STRUCT_OFFSET(printer_mib_prtInterpreterEntry_t, _prtInterpreterLangLevelLength),
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTINTERPRETERLANGVERSION, "prtInterpreterLangVersion",
       prtInterpreterLangVersion_constraints,
      G_STRUCT_OFFSET(printer_mib_prtInterpreterEntry_t, prtInterpreterLangVersion),
      G_STRUCT_OFFSET(printer_mib_prtInterpreterEntry_t, _prtInterpreterLangVersionLength),
      0 },
    { 5, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTINTERPRETERDESCRIPTION, "prtInterpreterDescription",
       prtInterpreterDescription_constraints,
      G_STRUCT_OFFSET(printer_mib_prtInterpreterEntry_t, prtInterpreterDescription),
      G_STRUCT_OFFSET(printer_mib_prtInterpreterEntry_t, _prtInterpreterDescriptionLength),
      0 },
    { 6, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTINTERPRETERVERSION, "prtInterpreterVersion",
       prtInterpreterVersion_constraints,
      G_STRUCT_OFFSET(printer_mib_prtInterpreterEntry_t, prtInterpreterVersion),
      G_STRUCT_OFFSET(printer_mib_prtInterpreterEntry_t, _prtInterpreterVersionLength),
      0 },
    { 7, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTINTERPRETERDEFAULTORIENTATION, "prtInterpreterDefaultOrientation",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtInterpreterEntry_t, prtInterpreterDefaultOrientation),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 8, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTINTERPRETERFEEDADDRESSABILITY, "prtInterpreterFeedAddressability",
       prtInterpreterFeedAddressability_constraints,
      G_STRUCT_OFFSET(printer_mib_prtInterpreterEntry_t, prtInterpreterFeedAddressability),
      0,
      0 },
    { 9, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTINTERPRETERXFEEDADDRESSABILITY, "prtInterpreterXFeedAddressability",
       prtInterpreterXFeedAddressability_constraints,
      G_STRUCT_OFFSET(printer_mib_prtInterpreterEntry_t, prtInterpreterXFeedAddressability),
      0,
      0 },
    { 10, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTINTERPRETERDEFAULTCHARSETIN, "prtInterpreterDefaultCharSetIn",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtInterpreterEntry_t, prtInterpreterDefaultCharSetIn),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 11, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTINTERPRETERDEFAULTCHARSETOUT, "prtInterpreterDefaultCharSetOut",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtInterpreterEntry_t, prtInterpreterDefaultCharSetOut),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 12, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTINTERPRETERTWOWAY, "prtInterpreterTwoWay",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtInterpreterEntry_t, prtInterpreterTwoWay),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const prtConsoleDisplayBufferEntry_oid[] = {1, 3, 6, 1, 2, 1, 43, 16, 5, 1};

static GNetSnmpAttribute prtConsoleDisplayBufferEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTCONSOLEDISPLAYBUFFERTEXT, "prtConsoleDisplayBufferText",
       prtConsoleDisplayBufferText_constraints,
      G_STRUCT_OFFSET(printer_mib_prtConsoleDisplayBufferEntry_t, prtConsoleDisplayBufferText),
      G_STRUCT_OFFSET(printer_mib_prtConsoleDisplayBufferEntry_t, _prtConsoleDisplayBufferTextLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 0, 0, 0, NULL }
};

static guint32 const prtConsoleLightEntry_oid[] = {1, 3, 6, 1, 2, 1, 43, 17, 6, 1};

static GNetSnmpAttribute prtConsoleLightEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTCONSOLEONTIME, "prtConsoleOnTime",
       prtConsoleOnTime_constraints,
      G_STRUCT_OFFSET(printer_mib_prtConsoleLightEntry_t, prtConsoleOnTime),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 3, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTCONSOLEOFFTIME, "prtConsoleOffTime",
       prtConsoleOffTime_constraints,
      G_STRUCT_OFFSET(printer_mib_prtConsoleLightEntry_t, prtConsoleOffTime),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 4, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTCONSOLECOLOR, "prtConsoleColor",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtConsoleLightEntry_t, prtConsoleColor),
      0,
      0 },
    { 5, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTCONSOLEDESCRIPTION, "prtConsoleDescription",
       prtConsoleDescription_constraints,
      G_STRUCT_OFFSET(printer_mib_prtConsoleLightEntry_t, prtConsoleDescription),
      G_STRUCT_OFFSET(printer_mib_prtConsoleLightEntry_t, _prtConsoleDescriptionLength),
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const prtAlertEntry_oid[] = {1, 3, 6, 1, 2, 1, 43, 18, 1, 1};

static GNetSnmpAttribute prtAlertEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTALERTSEVERITYLEVEL, "prtAlertSeverityLevel",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtAlertEntry_t, prtAlertSeverityLevel),
      0,
      0 },
    { 3, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTALERTTRAININGLEVEL, "prtAlertTrainingLevel",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtAlertEntry_t, prtAlertTrainingLevel),
      0,
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTALERTGROUP, "prtAlertGroup",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtAlertEntry_t, prtAlertGroup),
      0,
      0 },
    { 5, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTALERTGROUPINDEX, "prtAlertGroupIndex",
       prtAlertGroupIndex_constraints,
      G_STRUCT_OFFSET(printer_mib_prtAlertEntry_t, prtAlertGroupIndex),
      0,
      0 },
    { 6, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTALERTLOCATION, "prtAlertLocation",
       prtAlertLocation_constraints,
      G_STRUCT_OFFSET(printer_mib_prtAlertEntry_t, prtAlertLocation),
      0,
      0 },
    { 7, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      PRINTER_MIB_PRTALERTCODE, "prtAlertCode",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtAlertEntry_t, prtAlertCode),
      0,
      0 },
    { 8, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      PRINTER_MIB_PRTALERTDESCRIPTION, "prtAlertDescription",
       prtAlertDescription_constraints,
      G_STRUCT_OFFSET(printer_mib_prtAlertEntry_t, prtAlertDescription),
      G_STRUCT_OFFSET(printer_mib_prtAlertEntry_t, _prtAlertDescriptionLength),
      0 },
    { 9, GNET_SNMP_VARBIND_TYPE_TIMETICKS,
      PRINTER_MIB_PRTALERTTIME, "prtAlertTime",
       NULL,
      G_STRUCT_OFFSET(printer_mib_prtAlertEntry_t, prtAlertTime),
      0,
      0 },
    { 0, 0, 0, NULL }
};


printer_mib_prtGeneralEntry_t *
printer_mib_new_prtGeneralEntry()
{
    printer_mib_prtGeneralEntry_t *prtGeneralEntry;

    prtGeneralEntry = (printer_mib_prtGeneralEntry_t *) g_malloc0(sizeof(printer_mib_prtGeneralEntry_t) + sizeof(gpointer));
    return prtGeneralEntry;
}

static inline int
unpack_prtGeneralEntry(GNetSnmpVarBind *vb, printer_mib_prtGeneralEntry_t *prtGeneralEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    prtGeneralEntry->hrDeviceIndex = vb->oid[idx++];
    if ((prtGeneralEntry->hrDeviceIndex < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_prtGeneralEntry(guint32 *base, gint32 hrDeviceIndex)
{
    guint8 idx = 11;

    base[idx++] = hrDeviceIndex;
    return idx;
}

static inline printer_mib_prtGeneralEntry_t *
assign_prtGeneralEntry(GList *vbl)
{
    printer_mib_prtGeneralEntry_t *prtGeneralEntry;
    char *p;

    prtGeneralEntry = printer_mib_new_prtGeneralEntry();
    p = (char *) prtGeneralEntry + sizeof(printer_mib_prtGeneralEntry_t);
    * (GList **) p = vbl;

    if (unpack_prtGeneralEntry((GNetSnmpVarBind *) vbl->data, prtGeneralEntry) < 0) {
        g_warning("%s: invalid instance identifier", "prtGeneralEntry");
        g_free(prtGeneralEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, prtGeneralEntry_oid, G_N_ELEMENTS(prtGeneralEntry_oid),
                      prtGeneralEntry_attr, prtGeneralEntry);

    return prtGeneralEntry;
}

void
printer_mib_get_prtGeneralTable(GNetSnmp *s, printer_mib_prtGeneralEntry_t ***prtGeneralEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 0};
    guint32 base[128];

    *prtGeneralEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, prtGeneralEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *prtGeneralEntry = (printer_mib_prtGeneralEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(printer_mib_prtGeneralEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*prtGeneralEntry)[i] = assign_prtGeneralEntry(row->data);
        }
    }
}

void
printer_mib_get_prtGeneralEntry(GNetSnmp *s, printer_mib_prtGeneralEntry_t **prtGeneralEntry, gint32 hrDeviceIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, prtGeneralEntry_oid, sizeof(prtGeneralEntry_oid));
    len = pack_prtGeneralEntry(base, hrDeviceIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "prtGeneralEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *prtGeneralEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, prtGeneralEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *prtGeneralEntry = assign_prtGeneralEntry(out);
    }
}

void
printer_mib_set_prtGeneralEntry(GNetSnmp *s, printer_mib_prtGeneralEntry_t *prtGeneralEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, prtGeneralEntry_oid, sizeof(prtGeneralEntry_oid));
    len = pack_prtGeneralEntry(base, prtGeneralEntry->hrDeviceIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "prtGeneralEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 10, prtGeneralEntry_attr, mask, prtGeneralEntry);

    out = gnet_snmp_sync_set(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
printer_mib_free_prtGeneralEntry(printer_mib_prtGeneralEntry_t *prtGeneralEntry)
{
    GList *vbl;
    char *p;

    if (prtGeneralEntry) {
        p = (char *) prtGeneralEntry + sizeof(printer_mib_prtGeneralEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(prtGeneralEntry);
    }
}

void
printer_mib_free_prtGeneralTable(printer_mib_prtGeneralEntry_t **prtGeneralEntry)
{
    int i;

    if (prtGeneralEntry) {
        for (i = 0; prtGeneralEntry[i]; i++) {
            printer_mib_free_prtGeneralEntry(prtGeneralEntry[i]);
        }
        g_free(prtGeneralEntry);
    }
}

void
printer_mib_set_prtGeneralCurrentLocalization(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtGeneralCurrentLocalization, GError **error)
{
    printer_mib_prtGeneralEntry_t *prtGeneralEntry;

    printer_mib_get_prtGeneralEntry(s, &prtGeneralEntry, hrDeviceIndex, PRINTER_MIB_PRTGENERALCURRENTLOCALIZATION, error);
    if (error && *error) return;
    if (s->error_status || !prtGeneralEntry) return;
    prtGeneralEntry->prtGeneralCurrentLocalization = &prtGeneralCurrentLocalization;
    printer_mib_set_prtGeneralEntry(s, prtGeneralEntry, PRINTER_MIB_PRTGENERALCURRENTLOCALIZATION, error);
    printer_mib_free_prtGeneralEntry(prtGeneralEntry);
}

void
printer_mib_set_prtGeneralReset(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtGeneralReset, GError **error)
{
    printer_mib_prtGeneralEntry_t *prtGeneralEntry;

    printer_mib_get_prtGeneralEntry(s, &prtGeneralEntry, hrDeviceIndex, PRINTER_MIB_PRTGENERALRESET, error);
    if (error && *error) return;
    if (s->error_status || !prtGeneralEntry) return;
    prtGeneralEntry->prtGeneralReset = &prtGeneralReset;
    printer_mib_set_prtGeneralEntry(s, prtGeneralEntry, PRINTER_MIB_PRTGENERALRESET, error);
    printer_mib_free_prtGeneralEntry(prtGeneralEntry);
}

void
printer_mib_set_prtGeneralCurrentOperator(GNetSnmp *s, gint32 hrDeviceIndex, guchar *prtGeneralCurrentOperator, guint16 _prtGeneralCurrentOperatorLength, GError **error)
{
    printer_mib_prtGeneralEntry_t *prtGeneralEntry;

    printer_mib_get_prtGeneralEntry(s, &prtGeneralEntry, hrDeviceIndex, PRINTER_MIB_PRTGENERALCURRENTOPERATOR, error);
    if (error && *error) return;
    if (s->error_status || !prtGeneralEntry) return;
    prtGeneralEntry->prtGeneralCurrentOperator = prtGeneralCurrentOperator;
    prtGeneralEntry->_prtGeneralCurrentOperatorLength = _prtGeneralCurrentOperatorLength;
    printer_mib_set_prtGeneralEntry(s, prtGeneralEntry, PRINTER_MIB_PRTGENERALCURRENTOPERATOR, error);
    printer_mib_free_prtGeneralEntry(prtGeneralEntry);
}

void
printer_mib_set_prtGeneralServicePerson(GNetSnmp *s, gint32 hrDeviceIndex, guchar *prtGeneralServicePerson, guint16 _prtGeneralServicePersonLength, GError **error)
{
    printer_mib_prtGeneralEntry_t *prtGeneralEntry;

    printer_mib_get_prtGeneralEntry(s, &prtGeneralEntry, hrDeviceIndex, PRINTER_MIB_PRTGENERALSERVICEPERSON, error);
    if (error && *error) return;
    if (s->error_status || !prtGeneralEntry) return;
    prtGeneralEntry->prtGeneralServicePerson = prtGeneralServicePerson;
    prtGeneralEntry->_prtGeneralServicePersonLength = _prtGeneralServicePersonLength;
    printer_mib_set_prtGeneralEntry(s, prtGeneralEntry, PRINTER_MIB_PRTGENERALSERVICEPERSON, error);
    printer_mib_free_prtGeneralEntry(prtGeneralEntry);
}

void
printer_mib_set_prtInputDefaultIndex(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputDefaultIndex, GError **error)
{
    printer_mib_prtGeneralEntry_t *prtGeneralEntry;

    printer_mib_get_prtGeneralEntry(s, &prtGeneralEntry, hrDeviceIndex, PRINTER_MIB_PRTINPUTDEFAULTINDEX, error);
    if (error && *error) return;
    if (s->error_status || !prtGeneralEntry) return;
    prtGeneralEntry->prtInputDefaultIndex = &prtInputDefaultIndex;
    printer_mib_set_prtGeneralEntry(s, prtGeneralEntry, PRINTER_MIB_PRTINPUTDEFAULTINDEX, error);
    printer_mib_free_prtGeneralEntry(prtGeneralEntry);
}

void
printer_mib_set_prtOutputDefaultIndex(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputDefaultIndex, GError **error)
{
    printer_mib_prtGeneralEntry_t *prtGeneralEntry;

    printer_mib_get_prtGeneralEntry(s, &prtGeneralEntry, hrDeviceIndex, PRINTER_MIB_PRTOUTPUTDEFAULTINDEX, error);
    if (error && *error) return;
    if (s->error_status || !prtGeneralEntry) return;
    prtGeneralEntry->prtOutputDefaultIndex = &prtOutputDefaultIndex;
    printer_mib_set_prtGeneralEntry(s, prtGeneralEntry, PRINTER_MIB_PRTOUTPUTDEFAULTINDEX, error);
    printer_mib_free_prtGeneralEntry(prtGeneralEntry);
}

void
printer_mib_set_prtMarkerDefaultIndex(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtMarkerDefaultIndex, GError **error)
{
    printer_mib_prtGeneralEntry_t *prtGeneralEntry;

    printer_mib_get_prtGeneralEntry(s, &prtGeneralEntry, hrDeviceIndex, PRINTER_MIB_PRTMARKERDEFAULTINDEX, error);
    if (error && *error) return;
    if (s->error_status || !prtGeneralEntry) return;
    prtGeneralEntry->prtMarkerDefaultIndex = &prtMarkerDefaultIndex;
    printer_mib_set_prtGeneralEntry(s, prtGeneralEntry, PRINTER_MIB_PRTMARKERDEFAULTINDEX, error);
    printer_mib_free_prtGeneralEntry(prtGeneralEntry);
}

void
printer_mib_set_prtMediaPathDefaultIndex(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtMediaPathDefaultIndex, GError **error)
{
    printer_mib_prtGeneralEntry_t *prtGeneralEntry;

    printer_mib_get_prtGeneralEntry(s, &prtGeneralEntry, hrDeviceIndex, PRINTER_MIB_PRTMEDIAPATHDEFAULTINDEX, error);
    if (error && *error) return;
    if (s->error_status || !prtGeneralEntry) return;
    prtGeneralEntry->prtMediaPathDefaultIndex = &prtMediaPathDefaultIndex;
    printer_mib_set_prtGeneralEntry(s, prtGeneralEntry, PRINTER_MIB_PRTMEDIAPATHDEFAULTINDEX, error);
    printer_mib_free_prtGeneralEntry(prtGeneralEntry);
}

void
printer_mib_set_prtConsoleLocalization(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtConsoleLocalization, GError **error)
{
    printer_mib_prtGeneralEntry_t *prtGeneralEntry;

    printer_mib_get_prtGeneralEntry(s, &prtGeneralEntry, hrDeviceIndex, PRINTER_MIB_PRTCONSOLELOCALIZATION, error);
    if (error && *error) return;
    if (s->error_status || !prtGeneralEntry) return;
    prtGeneralEntry->prtConsoleLocalization = &prtConsoleLocalization;
    printer_mib_set_prtGeneralEntry(s, prtGeneralEntry, PRINTER_MIB_PRTCONSOLELOCALIZATION, error);
    printer_mib_free_prtGeneralEntry(prtGeneralEntry);
}

void
printer_mib_set_prtConsoleDisable(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtConsoleDisable, GError **error)
{
    printer_mib_prtGeneralEntry_t *prtGeneralEntry;

    printer_mib_get_prtGeneralEntry(s, &prtGeneralEntry, hrDeviceIndex, PRINTER_MIB_PRTCONSOLEDISABLE, error);
    if (error && *error) return;
    if (s->error_status || !prtGeneralEntry) return;
    prtGeneralEntry->prtConsoleDisable = &prtConsoleDisable;
    printer_mib_set_prtGeneralEntry(s, prtGeneralEntry, PRINTER_MIB_PRTCONSOLEDISABLE, error);
    printer_mib_free_prtGeneralEntry(prtGeneralEntry);
}

void
printer_mib_set_prtAuxiliarySheetStartupPage(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtAuxiliarySheetStartupPage, GError **error)
{
    printer_mib_prtGeneralEntry_t *prtGeneralEntry;

    printer_mib_get_prtGeneralEntry(s, &prtGeneralEntry, hrDeviceIndex, PRINTER_MIB_PRTAUXILIARYSHEETSTARTUPPAGE, error);
    if (error && *error) return;
    if (s->error_status || !prtGeneralEntry) return;
    prtGeneralEntry->prtAuxiliarySheetStartupPage = &prtAuxiliarySheetStartupPage;
    printer_mib_set_prtGeneralEntry(s, prtGeneralEntry, PRINTER_MIB_PRTAUXILIARYSHEETSTARTUPPAGE, error);
    printer_mib_free_prtGeneralEntry(prtGeneralEntry);
}

void
printer_mib_set_prtAuxiliarySheetBannerPage(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtAuxiliarySheetBannerPage, GError **error)
{
    printer_mib_prtGeneralEntry_t *prtGeneralEntry;

    printer_mib_get_prtGeneralEntry(s, &prtGeneralEntry, hrDeviceIndex, PRINTER_MIB_PRTAUXILIARYSHEETBANNERPAGE, error);
    if (error && *error) return;
    if (s->error_status || !prtGeneralEntry) return;
    prtGeneralEntry->prtAuxiliarySheetBannerPage = &prtAuxiliarySheetBannerPage;
    printer_mib_set_prtGeneralEntry(s, prtGeneralEntry, PRINTER_MIB_PRTAUXILIARYSHEETBANNERPAGE, error);
    printer_mib_free_prtGeneralEntry(prtGeneralEntry);
}

void
printer_mib_set_prtGeneralPrinterName(GNetSnmp *s, gint32 hrDeviceIndex, guchar *prtGeneralPrinterName, guint16 _prtGeneralPrinterNameLength, GError **error)
{
    printer_mib_prtGeneralEntry_t *prtGeneralEntry;

    printer_mib_get_prtGeneralEntry(s, &prtGeneralEntry, hrDeviceIndex, PRINTER_MIB_PRTGENERALPRINTERNAME, error);
    if (error && *error) return;
    if (s->error_status || !prtGeneralEntry) return;
    prtGeneralEntry->prtGeneralPrinterName = prtGeneralPrinterName;
    prtGeneralEntry->_prtGeneralPrinterNameLength = _prtGeneralPrinterNameLength;
    printer_mib_set_prtGeneralEntry(s, prtGeneralEntry, PRINTER_MIB_PRTGENERALPRINTERNAME, error);
    printer_mib_free_prtGeneralEntry(prtGeneralEntry);
}

void
printer_mib_set_prtGeneralSerialNumber(GNetSnmp *s, gint32 hrDeviceIndex, guchar *prtGeneralSerialNumber, guint16 _prtGeneralSerialNumberLength, GError **error)
{
    printer_mib_prtGeneralEntry_t *prtGeneralEntry;

    printer_mib_get_prtGeneralEntry(s, &prtGeneralEntry, hrDeviceIndex, PRINTER_MIB_PRTGENERALSERIALNUMBER, error);
    if (error && *error) return;
    if (s->error_status || !prtGeneralEntry) return;
    prtGeneralEntry->prtGeneralSerialNumber = prtGeneralSerialNumber;
    prtGeneralEntry->_prtGeneralSerialNumberLength = _prtGeneralSerialNumberLength;
    printer_mib_set_prtGeneralEntry(s, prtGeneralEntry, PRINTER_MIB_PRTGENERALSERIALNUMBER, error);
    printer_mib_free_prtGeneralEntry(prtGeneralEntry);
}

printer_mib_prtStorageRefEntry_t *
printer_mib_new_prtStorageRefEntry()
{
    printer_mib_prtStorageRefEntry_t *prtStorageRefEntry;

    prtStorageRefEntry = (printer_mib_prtStorageRefEntry_t *) g_malloc0(sizeof(printer_mib_prtStorageRefEntry_t) + sizeof(gpointer));
    return prtStorageRefEntry;
}

static inline int
unpack_prtStorageRefEntry(GNetSnmpVarBind *vb, printer_mib_prtStorageRefEntry_t *prtStorageRefEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    prtStorageRefEntry->hrStorageIndex = vb->oid[idx++];
    if ((prtStorageRefEntry->hrStorageIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    prtStorageRefEntry->prtStorageRefSeqNumber = vb->oid[idx++];
    if ((prtStorageRefEntry->prtStorageRefSeqNumber < 1 || prtStorageRefEntry->prtStorageRefSeqNumber > 65535)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_prtStorageRefEntry(guint32 *base, gint32 hrStorageIndex, gint32 prtStorageRefSeqNumber)
{
    guint8 idx = 11;

    base[idx++] = hrStorageIndex;
    base[idx++] = prtStorageRefSeqNumber;
    return idx;
}

static inline printer_mib_prtStorageRefEntry_t *
assign_prtStorageRefEntry(GList *vbl)
{
    printer_mib_prtStorageRefEntry_t *prtStorageRefEntry;
    char *p;

    prtStorageRefEntry = printer_mib_new_prtStorageRefEntry();
    p = (char *) prtStorageRefEntry + sizeof(printer_mib_prtStorageRefEntry_t);
    * (GList **) p = vbl;

    if (unpack_prtStorageRefEntry((GNetSnmpVarBind *) vbl->data, prtStorageRefEntry) < 0) {
        g_warning("%s: invalid instance identifier", "prtStorageRefEntry");
        g_free(prtStorageRefEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, prtStorageRefEntry_oid, G_N_ELEMENTS(prtStorageRefEntry_oid),
                      prtStorageRefEntry_attr, prtStorageRefEntry);

    return prtStorageRefEntry;
}

void
printer_mib_get_prtStorageRefTable(GNetSnmp *s, printer_mib_prtStorageRefEntry_t ***prtStorageRefEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 43, 5, 2, 1, 0};
    guint32 base[128];

    *prtStorageRefEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, prtStorageRefEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *prtStorageRefEntry = (printer_mib_prtStorageRefEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(printer_mib_prtStorageRefEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*prtStorageRefEntry)[i] = assign_prtStorageRefEntry(row->data);
        }
    }
}

void
printer_mib_get_prtStorageRefEntry(GNetSnmp *s, printer_mib_prtStorageRefEntry_t **prtStorageRefEntry, gint32 hrStorageIndex, gint32 prtStorageRefSeqNumber, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, prtStorageRefEntry_oid, sizeof(prtStorageRefEntry_oid));
    len = pack_prtStorageRefEntry(base, hrStorageIndex, prtStorageRefSeqNumber);
    if (len < 0) {
        g_warning("%s: invalid index values", "prtStorageRefEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *prtStorageRefEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, prtStorageRefEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *prtStorageRefEntry = assign_prtStorageRefEntry(out);
    }
}

void
printer_mib_free_prtStorageRefEntry(printer_mib_prtStorageRefEntry_t *prtStorageRefEntry)
{
    GList *vbl;
    char *p;

    if (prtStorageRefEntry) {
        p = (char *) prtStorageRefEntry + sizeof(printer_mib_prtStorageRefEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(prtStorageRefEntry);
    }
}

void
printer_mib_free_prtStorageRefTable(printer_mib_prtStorageRefEntry_t **prtStorageRefEntry)
{
    int i;

    if (prtStorageRefEntry) {
        for (i = 0; prtStorageRefEntry[i]; i++) {
            printer_mib_free_prtStorageRefEntry(prtStorageRefEntry[i]);
        }
        g_free(prtStorageRefEntry);
    }
}

printer_mib_prtDeviceRefEntry_t *
printer_mib_new_prtDeviceRefEntry()
{
    printer_mib_prtDeviceRefEntry_t *prtDeviceRefEntry;

    prtDeviceRefEntry = (printer_mib_prtDeviceRefEntry_t *) g_malloc0(sizeof(printer_mib_prtDeviceRefEntry_t) + sizeof(gpointer));
    return prtDeviceRefEntry;
}

static inline int
unpack_prtDeviceRefEntry(GNetSnmpVarBind *vb, printer_mib_prtDeviceRefEntry_t *prtDeviceRefEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    prtDeviceRefEntry->hrDeviceIndex = vb->oid[idx++];
    if ((prtDeviceRefEntry->hrDeviceIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    prtDeviceRefEntry->prtDeviceRefSeqNumber = vb->oid[idx++];
    if ((prtDeviceRefEntry->prtDeviceRefSeqNumber < 1 || prtDeviceRefEntry->prtDeviceRefSeqNumber > 65535)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_prtDeviceRefEntry(guint32 *base, gint32 hrDeviceIndex, gint32 prtDeviceRefSeqNumber)
{
    guint8 idx = 11;

    base[idx++] = hrDeviceIndex;
    base[idx++] = prtDeviceRefSeqNumber;
    return idx;
}

static inline printer_mib_prtDeviceRefEntry_t *
assign_prtDeviceRefEntry(GList *vbl)
{
    printer_mib_prtDeviceRefEntry_t *prtDeviceRefEntry;
    char *p;

    prtDeviceRefEntry = printer_mib_new_prtDeviceRefEntry();
    p = (char *) prtDeviceRefEntry + sizeof(printer_mib_prtDeviceRefEntry_t);
    * (GList **) p = vbl;

    if (unpack_prtDeviceRefEntry((GNetSnmpVarBind *) vbl->data, prtDeviceRefEntry) < 0) {
        g_warning("%s: invalid instance identifier", "prtDeviceRefEntry");
        g_free(prtDeviceRefEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, prtDeviceRefEntry_oid, G_N_ELEMENTS(prtDeviceRefEntry_oid),
                      prtDeviceRefEntry_attr, prtDeviceRefEntry);

    return prtDeviceRefEntry;
}

void
printer_mib_get_prtDeviceRefTable(GNetSnmp *s, printer_mib_prtDeviceRefEntry_t ***prtDeviceRefEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 43, 5, 3, 1, 0};
    guint32 base[128];

    *prtDeviceRefEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, prtDeviceRefEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *prtDeviceRefEntry = (printer_mib_prtDeviceRefEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(printer_mib_prtDeviceRefEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*prtDeviceRefEntry)[i] = assign_prtDeviceRefEntry(row->data);
        }
    }
}

void
printer_mib_get_prtDeviceRefEntry(GNetSnmp *s, printer_mib_prtDeviceRefEntry_t **prtDeviceRefEntry, gint32 hrDeviceIndex, gint32 prtDeviceRefSeqNumber, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, prtDeviceRefEntry_oid, sizeof(prtDeviceRefEntry_oid));
    len = pack_prtDeviceRefEntry(base, hrDeviceIndex, prtDeviceRefSeqNumber);
    if (len < 0) {
        g_warning("%s: invalid index values", "prtDeviceRefEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *prtDeviceRefEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, prtDeviceRefEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *prtDeviceRefEntry = assign_prtDeviceRefEntry(out);
    }
}

void
printer_mib_free_prtDeviceRefEntry(printer_mib_prtDeviceRefEntry_t *prtDeviceRefEntry)
{
    GList *vbl;
    char *p;

    if (prtDeviceRefEntry) {
        p = (char *) prtDeviceRefEntry + sizeof(printer_mib_prtDeviceRefEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(prtDeviceRefEntry);
    }
}

void
printer_mib_free_prtDeviceRefTable(printer_mib_prtDeviceRefEntry_t **prtDeviceRefEntry)
{
    int i;

    if (prtDeviceRefEntry) {
        for (i = 0; prtDeviceRefEntry[i]; i++) {
            printer_mib_free_prtDeviceRefEntry(prtDeviceRefEntry[i]);
        }
        g_free(prtDeviceRefEntry);
    }
}

printer_mib_prtCoverEntry_t *
printer_mib_new_prtCoverEntry()
{
    printer_mib_prtCoverEntry_t *prtCoverEntry;

    prtCoverEntry = (printer_mib_prtCoverEntry_t *) g_malloc0(sizeof(printer_mib_prtCoverEntry_t) + sizeof(gpointer));
    return prtCoverEntry;
}

static inline int
unpack_prtCoverEntry(GNetSnmpVarBind *vb, printer_mib_prtCoverEntry_t *prtCoverEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    prtCoverEntry->hrDeviceIndex = vb->oid[idx++];
    if ((prtCoverEntry->hrDeviceIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    prtCoverEntry->prtCoverIndex = vb->oid[idx++];
    if ((prtCoverEntry->prtCoverIndex < 1 || prtCoverEntry->prtCoverIndex > 65535)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_prtCoverEntry(guint32 *base, gint32 hrDeviceIndex, gint32 prtCoverIndex)
{
    guint8 idx = 11;

    base[idx++] = hrDeviceIndex;
    base[idx++] = prtCoverIndex;
    return idx;
}

static inline printer_mib_prtCoverEntry_t *
assign_prtCoverEntry(GList *vbl)
{
    printer_mib_prtCoverEntry_t *prtCoverEntry;
    char *p;

    prtCoverEntry = printer_mib_new_prtCoverEntry();
    p = (char *) prtCoverEntry + sizeof(printer_mib_prtCoverEntry_t);
    * (GList **) p = vbl;

    if (unpack_prtCoverEntry((GNetSnmpVarBind *) vbl->data, prtCoverEntry) < 0) {
        g_warning("%s: invalid instance identifier", "prtCoverEntry");
        g_free(prtCoverEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, prtCoverEntry_oid, G_N_ELEMENTS(prtCoverEntry_oid),
                      prtCoverEntry_attr, prtCoverEntry);

    return prtCoverEntry;
}

void
printer_mib_get_prtCoverTable(GNetSnmp *s, printer_mib_prtCoverEntry_t ***prtCoverEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 43, 6, 1, 1, 0};
    guint32 base[128];

    *prtCoverEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, prtCoverEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *prtCoverEntry = (printer_mib_prtCoverEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(printer_mib_prtCoverEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*prtCoverEntry)[i] = assign_prtCoverEntry(row->data);
        }
    }
}

void
printer_mib_get_prtCoverEntry(GNetSnmp *s, printer_mib_prtCoverEntry_t **prtCoverEntry, gint32 hrDeviceIndex, gint32 prtCoverIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, prtCoverEntry_oid, sizeof(prtCoverEntry_oid));
    len = pack_prtCoverEntry(base, hrDeviceIndex, prtCoverIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "prtCoverEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *prtCoverEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, prtCoverEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *prtCoverEntry = assign_prtCoverEntry(out);
    }
}

void
printer_mib_free_prtCoverEntry(printer_mib_prtCoverEntry_t *prtCoverEntry)
{
    GList *vbl;
    char *p;

    if (prtCoverEntry) {
        p = (char *) prtCoverEntry + sizeof(printer_mib_prtCoverEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(prtCoverEntry);
    }
}

void
printer_mib_free_prtCoverTable(printer_mib_prtCoverEntry_t **prtCoverEntry)
{
    int i;

    if (prtCoverEntry) {
        for (i = 0; prtCoverEntry[i]; i++) {
            printer_mib_free_prtCoverEntry(prtCoverEntry[i]);
        }
        g_free(prtCoverEntry);
    }
}

printer_mib_prtLocalizationEntry_t *
printer_mib_new_prtLocalizationEntry()
{
    printer_mib_prtLocalizationEntry_t *prtLocalizationEntry;

    prtLocalizationEntry = (printer_mib_prtLocalizationEntry_t *) g_malloc0(sizeof(printer_mib_prtLocalizationEntry_t) + sizeof(gpointer));
    return prtLocalizationEntry;
}

static inline int
unpack_prtLocalizationEntry(GNetSnmpVarBind *vb, printer_mib_prtLocalizationEntry_t *prtLocalizationEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    prtLocalizationEntry->hrDeviceIndex = vb->oid[idx++];
    if ((prtLocalizationEntry->hrDeviceIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    prtLocalizationEntry->prtLocalizationIndex = vb->oid[idx++];
    if ((prtLocalizationEntry->prtLocalizationIndex < 1 || prtLocalizationEntry->prtLocalizationIndex > 65535)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_prtLocalizationEntry(guint32 *base, gint32 hrDeviceIndex, gint32 prtLocalizationIndex)
{
    guint8 idx = 11;

    base[idx++] = hrDeviceIndex;
    base[idx++] = prtLocalizationIndex;
    return idx;
}

static inline printer_mib_prtLocalizationEntry_t *
assign_prtLocalizationEntry(GList *vbl)
{
    printer_mib_prtLocalizationEntry_t *prtLocalizationEntry;
    char *p;

    prtLocalizationEntry = printer_mib_new_prtLocalizationEntry();
    p = (char *) prtLocalizationEntry + sizeof(printer_mib_prtLocalizationEntry_t);
    * (GList **) p = vbl;

    if (unpack_prtLocalizationEntry((GNetSnmpVarBind *) vbl->data, prtLocalizationEntry) < 0) {
        g_warning("%s: invalid instance identifier", "prtLocalizationEntry");
        g_free(prtLocalizationEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, prtLocalizationEntry_oid, G_N_ELEMENTS(prtLocalizationEntry_oid),
                      prtLocalizationEntry_attr, prtLocalizationEntry);

    return prtLocalizationEntry;
}

void
printer_mib_get_prtLocalizationTable(GNetSnmp *s, printer_mib_prtLocalizationEntry_t ***prtLocalizationEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 43, 7, 1, 1, 0};
    guint32 base[128];

    *prtLocalizationEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, prtLocalizationEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *prtLocalizationEntry = (printer_mib_prtLocalizationEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(printer_mib_prtLocalizationEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*prtLocalizationEntry)[i] = assign_prtLocalizationEntry(row->data);
        }
    }
}

void
printer_mib_get_prtLocalizationEntry(GNetSnmp *s, printer_mib_prtLocalizationEntry_t **prtLocalizationEntry, gint32 hrDeviceIndex, gint32 prtLocalizationIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, prtLocalizationEntry_oid, sizeof(prtLocalizationEntry_oid));
    len = pack_prtLocalizationEntry(base, hrDeviceIndex, prtLocalizationIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "prtLocalizationEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *prtLocalizationEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, prtLocalizationEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *prtLocalizationEntry = assign_prtLocalizationEntry(out);
    }
}

void
printer_mib_free_prtLocalizationEntry(printer_mib_prtLocalizationEntry_t *prtLocalizationEntry)
{
    GList *vbl;
    char *p;

    if (prtLocalizationEntry) {
        p = (char *) prtLocalizationEntry + sizeof(printer_mib_prtLocalizationEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(prtLocalizationEntry);
    }
}

void
printer_mib_free_prtLocalizationTable(printer_mib_prtLocalizationEntry_t **prtLocalizationEntry)
{
    int i;

    if (prtLocalizationEntry) {
        for (i = 0; prtLocalizationEntry[i]; i++) {
            printer_mib_free_prtLocalizationEntry(prtLocalizationEntry[i]);
        }
        g_free(prtLocalizationEntry);
    }
}

printer_mib_prtInputEntry_t *
printer_mib_new_prtInputEntry()
{
    printer_mib_prtInputEntry_t *prtInputEntry;

    prtInputEntry = (printer_mib_prtInputEntry_t *) g_malloc0(sizeof(printer_mib_prtInputEntry_t) + sizeof(gpointer));
    return prtInputEntry;
}

static inline int
unpack_prtInputEntry(GNetSnmpVarBind *vb, printer_mib_prtInputEntry_t *prtInputEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    prtInputEntry->hrDeviceIndex = vb->oid[idx++];
    if ((prtInputEntry->hrDeviceIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    prtInputEntry->prtInputIndex = vb->oid[idx++];
    if ((prtInputEntry->prtInputIndex < 1 || prtInputEntry->prtInputIndex > 65535)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_prtInputEntry(guint32 *base, gint32 hrDeviceIndex, gint32 prtInputIndex)
{
    guint8 idx = 11;

    base[idx++] = hrDeviceIndex;
    base[idx++] = prtInputIndex;
    return idx;
}

static inline printer_mib_prtInputEntry_t *
assign_prtInputEntry(GList *vbl)
{
    printer_mib_prtInputEntry_t *prtInputEntry;
    char *p;

    prtInputEntry = printer_mib_new_prtInputEntry();
    p = (char *) prtInputEntry + sizeof(printer_mib_prtInputEntry_t);
    * (GList **) p = vbl;

    if (unpack_prtInputEntry((GNetSnmpVarBind *) vbl->data, prtInputEntry) < 0) {
        g_warning("%s: invalid instance identifier", "prtInputEntry");
        g_free(prtInputEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, prtInputEntry_oid, G_N_ELEMENTS(prtInputEntry_oid),
                      prtInputEntry_attr, prtInputEntry);

    return prtInputEntry;
}

void
printer_mib_get_prtInputTable(GNetSnmp *s, printer_mib_prtInputEntry_t ***prtInputEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 0};
    guint32 base[128];

    *prtInputEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, prtInputEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *prtInputEntry = (printer_mib_prtInputEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(printer_mib_prtInputEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*prtInputEntry)[i] = assign_prtInputEntry(row->data);
        }
    }
}

void
printer_mib_get_prtInputEntry(GNetSnmp *s, printer_mib_prtInputEntry_t **prtInputEntry, gint32 hrDeviceIndex, gint32 prtInputIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, prtInputEntry_oid, sizeof(prtInputEntry_oid));
    len = pack_prtInputEntry(base, hrDeviceIndex, prtInputIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "prtInputEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *prtInputEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, prtInputEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *prtInputEntry = assign_prtInputEntry(out);
    }
}

void
printer_mib_set_prtInputEntry(GNetSnmp *s, printer_mib_prtInputEntry_t *prtInputEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, prtInputEntry_oid, sizeof(prtInputEntry_oid));
    len = pack_prtInputEntry(base, prtInputEntry->hrDeviceIndex, prtInputEntry->prtInputIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "prtInputEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 10, prtInputEntry_attr, mask, prtInputEntry);

    out = gnet_snmp_sync_set(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
printer_mib_free_prtInputEntry(printer_mib_prtInputEntry_t *prtInputEntry)
{
    GList *vbl;
    char *p;

    if (prtInputEntry) {
        p = (char *) prtInputEntry + sizeof(printer_mib_prtInputEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(prtInputEntry);
    }
}

void
printer_mib_free_prtInputTable(printer_mib_prtInputEntry_t **prtInputEntry)
{
    int i;

    if (prtInputEntry) {
        for (i = 0; prtInputEntry[i]; i++) {
            printer_mib_free_prtInputEntry(prtInputEntry[i]);
        }
        g_free(prtInputEntry);
    }
}

void
printer_mib_set_prtInputMediaDimFeedDirDeclared(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputIndex, gint32 prtInputMediaDimFeedDirDeclared, GError **error)
{
    printer_mib_prtInputEntry_t *prtInputEntry;

    printer_mib_get_prtInputEntry(s, &prtInputEntry, hrDeviceIndex, prtInputIndex, PRINTER_MIB_PRTINPUTMEDIADIMFEEDDIRDECLARED, error);
    if (error && *error) return;
    if (s->error_status || !prtInputEntry) return;
    prtInputEntry->prtInputMediaDimFeedDirDeclared = &prtInputMediaDimFeedDirDeclared;
    printer_mib_set_prtInputEntry(s, prtInputEntry, PRINTER_MIB_PRTINPUTMEDIADIMFEEDDIRDECLARED, error);
    printer_mib_free_prtInputEntry(prtInputEntry);
}

void
printer_mib_set_prtInputMediaDimXFeedDirDeclared(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputIndex, gint32 prtInputMediaDimXFeedDirDeclared, GError **error)
{
    printer_mib_prtInputEntry_t *prtInputEntry;

    printer_mib_get_prtInputEntry(s, &prtInputEntry, hrDeviceIndex, prtInputIndex, PRINTER_MIB_PRTINPUTMEDIADIMXFEEDDIRDECLARED, error);
    if (error && *error) return;
    if (s->error_status || !prtInputEntry) return;
    prtInputEntry->prtInputMediaDimXFeedDirDeclared = &prtInputMediaDimXFeedDirDeclared;
    printer_mib_set_prtInputEntry(s, prtInputEntry, PRINTER_MIB_PRTINPUTMEDIADIMXFEEDDIRDECLARED, error);
    printer_mib_free_prtInputEntry(prtInputEntry);
}

void
printer_mib_set_prtInputMaxCapacity(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputIndex, gint32 prtInputMaxCapacity, GError **error)
{
    printer_mib_prtInputEntry_t *prtInputEntry;

    printer_mib_get_prtInputEntry(s, &prtInputEntry, hrDeviceIndex, prtInputIndex, PRINTER_MIB_PRTINPUTMAXCAPACITY, error);
    if (error && *error) return;
    if (s->error_status || !prtInputEntry) return;
    prtInputEntry->prtInputMaxCapacity = &prtInputMaxCapacity;
    printer_mib_set_prtInputEntry(s, prtInputEntry, PRINTER_MIB_PRTINPUTMAXCAPACITY, error);
    printer_mib_free_prtInputEntry(prtInputEntry);
}

void
printer_mib_set_prtInputCurrentLevel(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputIndex, gint32 prtInputCurrentLevel, GError **error)
{
    printer_mib_prtInputEntry_t *prtInputEntry;

    printer_mib_get_prtInputEntry(s, &prtInputEntry, hrDeviceIndex, prtInputIndex, PRINTER_MIB_PRTINPUTCURRENTLEVEL, error);
    if (error && *error) return;
    if (s->error_status || !prtInputEntry) return;
    prtInputEntry->prtInputCurrentLevel = &prtInputCurrentLevel;
    printer_mib_set_prtInputEntry(s, prtInputEntry, PRINTER_MIB_PRTINPUTCURRENTLEVEL, error);
    printer_mib_free_prtInputEntry(prtInputEntry);
}

void
printer_mib_set_prtInputMediaName(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputIndex, guchar *prtInputMediaName, guint16 _prtInputMediaNameLength, GError **error)
{
    printer_mib_prtInputEntry_t *prtInputEntry;

    printer_mib_get_prtInputEntry(s, &prtInputEntry, hrDeviceIndex, prtInputIndex, PRINTER_MIB_PRTINPUTMEDIANAME, error);
    if (error && *error) return;
    if (s->error_status || !prtInputEntry) return;
    prtInputEntry->prtInputMediaName = prtInputMediaName;
    prtInputEntry->_prtInputMediaNameLength = _prtInputMediaNameLength;
    printer_mib_set_prtInputEntry(s, prtInputEntry, PRINTER_MIB_PRTINPUTMEDIANAME, error);
    printer_mib_free_prtInputEntry(prtInputEntry);
}

void
printer_mib_set_prtInputName(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputIndex, guchar *prtInputName, guint16 _prtInputNameLength, GError **error)
{
    printer_mib_prtInputEntry_t *prtInputEntry;

    printer_mib_get_prtInputEntry(s, &prtInputEntry, hrDeviceIndex, prtInputIndex, PRINTER_MIB_PRTINPUTNAME, error);
    if (error && *error) return;
    if (s->error_status || !prtInputEntry) return;
    prtInputEntry->prtInputName = prtInputName;
    prtInputEntry->_prtInputNameLength = _prtInputNameLength;
    printer_mib_set_prtInputEntry(s, prtInputEntry, PRINTER_MIB_PRTINPUTNAME, error);
    printer_mib_free_prtInputEntry(prtInputEntry);
}

void
printer_mib_set_prtInputSecurity(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputIndex, gint32 prtInputSecurity, GError **error)
{
    printer_mib_prtInputEntry_t *prtInputEntry;

    printer_mib_get_prtInputEntry(s, &prtInputEntry, hrDeviceIndex, prtInputIndex, PRINTER_MIB_PRTINPUTSECURITY, error);
    if (error && *error) return;
    if (s->error_status || !prtInputEntry) return;
    prtInputEntry->prtInputSecurity = &prtInputSecurity;
    printer_mib_set_prtInputEntry(s, prtInputEntry, PRINTER_MIB_PRTINPUTSECURITY, error);
    printer_mib_free_prtInputEntry(prtInputEntry);
}

void
printer_mib_set_prtInputMediaWeight(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputIndex, gint32 prtInputMediaWeight, GError **error)
{
    printer_mib_prtInputEntry_t *prtInputEntry;

    printer_mib_get_prtInputEntry(s, &prtInputEntry, hrDeviceIndex, prtInputIndex, PRINTER_MIB_PRTINPUTMEDIAWEIGHT, error);
    if (error && *error) return;
    if (s->error_status || !prtInputEntry) return;
    prtInputEntry->prtInputMediaWeight = &prtInputMediaWeight;
    printer_mib_set_prtInputEntry(s, prtInputEntry, PRINTER_MIB_PRTINPUTMEDIAWEIGHT, error);
    printer_mib_free_prtInputEntry(prtInputEntry);
}

void
printer_mib_set_prtInputMediaType(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputIndex, guchar *prtInputMediaType, guint16 _prtInputMediaTypeLength, GError **error)
{
    printer_mib_prtInputEntry_t *prtInputEntry;

    printer_mib_get_prtInputEntry(s, &prtInputEntry, hrDeviceIndex, prtInputIndex, PRINTER_MIB_PRTINPUTMEDIATYPE, error);
    if (error && *error) return;
    if (s->error_status || !prtInputEntry) return;
    prtInputEntry->prtInputMediaType = prtInputMediaType;
    prtInputEntry->_prtInputMediaTypeLength = _prtInputMediaTypeLength;
    printer_mib_set_prtInputEntry(s, prtInputEntry, PRINTER_MIB_PRTINPUTMEDIATYPE, error);
    printer_mib_free_prtInputEntry(prtInputEntry);
}

void
printer_mib_set_prtInputMediaColor(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputIndex, guchar *prtInputMediaColor, guint16 _prtInputMediaColorLength, GError **error)
{
    printer_mib_prtInputEntry_t *prtInputEntry;

    printer_mib_get_prtInputEntry(s, &prtInputEntry, hrDeviceIndex, prtInputIndex, PRINTER_MIB_PRTINPUTMEDIACOLOR, error);
    if (error && *error) return;
    if (s->error_status || !prtInputEntry) return;
    prtInputEntry->prtInputMediaColor = prtInputMediaColor;
    prtInputEntry->_prtInputMediaColorLength = _prtInputMediaColorLength;
    printer_mib_set_prtInputEntry(s, prtInputEntry, PRINTER_MIB_PRTINPUTMEDIACOLOR, error);
    printer_mib_free_prtInputEntry(prtInputEntry);
}

void
printer_mib_set_prtInputMediaFormParts(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputIndex, gint32 prtInputMediaFormParts, GError **error)
{
    printer_mib_prtInputEntry_t *prtInputEntry;

    printer_mib_get_prtInputEntry(s, &prtInputEntry, hrDeviceIndex, prtInputIndex, PRINTER_MIB_PRTINPUTMEDIAFORMPARTS, error);
    if (error && *error) return;
    if (s->error_status || !prtInputEntry) return;
    prtInputEntry->prtInputMediaFormParts = &prtInputMediaFormParts;
    printer_mib_set_prtInputEntry(s, prtInputEntry, PRINTER_MIB_PRTINPUTMEDIAFORMPARTS, error);
    printer_mib_free_prtInputEntry(prtInputEntry);
}

void
printer_mib_set_prtInputMediaLoadTimeout(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputIndex, gint32 prtInputMediaLoadTimeout, GError **error)
{
    printer_mib_prtInputEntry_t *prtInputEntry;

    printer_mib_get_prtInputEntry(s, &prtInputEntry, hrDeviceIndex, prtInputIndex, PRINTER_MIB_PRTINPUTMEDIALOADTIMEOUT, error);
    if (error && *error) return;
    if (s->error_status || !prtInputEntry) return;
    prtInputEntry->prtInputMediaLoadTimeout = &prtInputMediaLoadTimeout;
    printer_mib_set_prtInputEntry(s, prtInputEntry, PRINTER_MIB_PRTINPUTMEDIALOADTIMEOUT, error);
    printer_mib_free_prtInputEntry(prtInputEntry);
}

void
printer_mib_set_prtInputNextIndex(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInputIndex, gint32 prtInputNextIndex, GError **error)
{
    printer_mib_prtInputEntry_t *prtInputEntry;

    printer_mib_get_prtInputEntry(s, &prtInputEntry, hrDeviceIndex, prtInputIndex, PRINTER_MIB_PRTINPUTNEXTINDEX, error);
    if (error && *error) return;
    if (s->error_status || !prtInputEntry) return;
    prtInputEntry->prtInputNextIndex = &prtInputNextIndex;
    printer_mib_set_prtInputEntry(s, prtInputEntry, PRINTER_MIB_PRTINPUTNEXTINDEX, error);
    printer_mib_free_prtInputEntry(prtInputEntry);
}

printer_mib_prtOutputEntry_t *
printer_mib_new_prtOutputEntry()
{
    printer_mib_prtOutputEntry_t *prtOutputEntry;

    prtOutputEntry = (printer_mib_prtOutputEntry_t *) g_malloc0(sizeof(printer_mib_prtOutputEntry_t) + sizeof(gpointer));
    return prtOutputEntry;
}

static inline int
unpack_prtOutputEntry(GNetSnmpVarBind *vb, printer_mib_prtOutputEntry_t *prtOutputEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    prtOutputEntry->hrDeviceIndex = vb->oid[idx++];
    if ((prtOutputEntry->hrDeviceIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    prtOutputEntry->prtOutputIndex = vb->oid[idx++];
    if ((prtOutputEntry->prtOutputIndex < 1 || prtOutputEntry->prtOutputIndex > 65535)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_prtOutputEntry(guint32 *base, gint32 hrDeviceIndex, gint32 prtOutputIndex)
{
    guint8 idx = 11;

    base[idx++] = hrDeviceIndex;
    base[idx++] = prtOutputIndex;
    return idx;
}

static inline printer_mib_prtOutputEntry_t *
assign_prtOutputEntry(GList *vbl)
{
    printer_mib_prtOutputEntry_t *prtOutputEntry;
    char *p;

    prtOutputEntry = printer_mib_new_prtOutputEntry();
    p = (char *) prtOutputEntry + sizeof(printer_mib_prtOutputEntry_t);
    * (GList **) p = vbl;

    if (unpack_prtOutputEntry((GNetSnmpVarBind *) vbl->data, prtOutputEntry) < 0) {
        g_warning("%s: invalid instance identifier", "prtOutputEntry");
        g_free(prtOutputEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, prtOutputEntry_oid, G_N_ELEMENTS(prtOutputEntry_oid),
                      prtOutputEntry_attr, prtOutputEntry);

    return prtOutputEntry;
}

void
printer_mib_get_prtOutputTable(GNetSnmp *s, printer_mib_prtOutputEntry_t ***prtOutputEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 0};
    guint32 base[128];

    *prtOutputEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, prtOutputEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *prtOutputEntry = (printer_mib_prtOutputEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(printer_mib_prtOutputEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*prtOutputEntry)[i] = assign_prtOutputEntry(row->data);
        }
    }
}

void
printer_mib_get_prtOutputEntry(GNetSnmp *s, printer_mib_prtOutputEntry_t **prtOutputEntry, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, prtOutputEntry_oid, sizeof(prtOutputEntry_oid));
    len = pack_prtOutputEntry(base, hrDeviceIndex, prtOutputIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "prtOutputEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *prtOutputEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, prtOutputEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *prtOutputEntry = assign_prtOutputEntry(out);
    }
}

void
printer_mib_set_prtOutputEntry(GNetSnmp *s, printer_mib_prtOutputEntry_t *prtOutputEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, prtOutputEntry_oid, sizeof(prtOutputEntry_oid));
    len = pack_prtOutputEntry(base, prtOutputEntry->hrDeviceIndex, prtOutputEntry->prtOutputIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "prtOutputEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 10, prtOutputEntry_attr, mask, prtOutputEntry);

    out = gnet_snmp_sync_set(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
printer_mib_free_prtOutputEntry(printer_mib_prtOutputEntry_t *prtOutputEntry)
{
    GList *vbl;
    char *p;

    if (prtOutputEntry) {
        p = (char *) prtOutputEntry + sizeof(printer_mib_prtOutputEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(prtOutputEntry);
    }
}

void
printer_mib_free_prtOutputTable(printer_mib_prtOutputEntry_t **prtOutputEntry)
{
    int i;

    if (prtOutputEntry) {
        for (i = 0; prtOutputEntry[i]; i++) {
            printer_mib_free_prtOutputEntry(prtOutputEntry[i]);
        }
        g_free(prtOutputEntry);
    }
}

void
printer_mib_set_prtOutputMaxCapacity(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint32 prtOutputMaxCapacity, GError **error)
{
    printer_mib_prtOutputEntry_t *prtOutputEntry;

    printer_mib_get_prtOutputEntry(s, &prtOutputEntry, hrDeviceIndex, prtOutputIndex, PRINTER_MIB_PRTOUTPUTMAXCAPACITY, error);
    if (error && *error) return;
    if (s->error_status || !prtOutputEntry) return;
    prtOutputEntry->prtOutputMaxCapacity = &prtOutputMaxCapacity;
    printer_mib_set_prtOutputEntry(s, prtOutputEntry, PRINTER_MIB_PRTOUTPUTMAXCAPACITY, error);
    printer_mib_free_prtOutputEntry(prtOutputEntry);
}

void
printer_mib_set_prtOutputRemainingCapacity(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint32 prtOutputRemainingCapacity, GError **error)
{
    printer_mib_prtOutputEntry_t *prtOutputEntry;

    printer_mib_get_prtOutputEntry(s, &prtOutputEntry, hrDeviceIndex, prtOutputIndex, PRINTER_MIB_PRTOUTPUTREMAININGCAPACITY, error);
    if (error && *error) return;
    if (s->error_status || !prtOutputEntry) return;
    prtOutputEntry->prtOutputRemainingCapacity = &prtOutputRemainingCapacity;
    printer_mib_set_prtOutputEntry(s, prtOutputEntry, PRINTER_MIB_PRTOUTPUTREMAININGCAPACITY, error);
    printer_mib_free_prtOutputEntry(prtOutputEntry);
}

void
printer_mib_set_prtOutputName(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, guchar *prtOutputName, guint16 _prtOutputNameLength, GError **error)
{
    printer_mib_prtOutputEntry_t *prtOutputEntry;

    printer_mib_get_prtOutputEntry(s, &prtOutputEntry, hrDeviceIndex, prtOutputIndex, PRINTER_MIB_PRTOUTPUTNAME, error);
    if (error && *error) return;
    if (s->error_status || !prtOutputEntry) return;
    prtOutputEntry->prtOutputName = prtOutputName;
    prtOutputEntry->_prtOutputNameLength = _prtOutputNameLength;
    printer_mib_set_prtOutputEntry(s, prtOutputEntry, PRINTER_MIB_PRTOUTPUTNAME, error);
    printer_mib_free_prtOutputEntry(prtOutputEntry);
}

void
printer_mib_set_prtOutputSecurity(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint32 prtOutputSecurity, GError **error)
{
    printer_mib_prtOutputEntry_t *prtOutputEntry;

    printer_mib_get_prtOutputEntry(s, &prtOutputEntry, hrDeviceIndex, prtOutputIndex, PRINTER_MIB_PRTOUTPUTSECURITY, error);
    if (error && *error) return;
    if (s->error_status || !prtOutputEntry) return;
    prtOutputEntry->prtOutputSecurity = &prtOutputSecurity;
    printer_mib_set_prtOutputEntry(s, prtOutputEntry, PRINTER_MIB_PRTOUTPUTSECURITY, error);
    printer_mib_free_prtOutputEntry(prtOutputEntry);
}

void
printer_mib_set_prtOutputMaxDimFeedDir(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint32 prtOutputMaxDimFeedDir, GError **error)
{
    printer_mib_prtOutputEntry_t *prtOutputEntry;

    printer_mib_get_prtOutputEntry(s, &prtOutputEntry, hrDeviceIndex, prtOutputIndex, PRINTER_MIB_PRTOUTPUTMAXDIMFEEDDIR, error);
    if (error && *error) return;
    if (s->error_status || !prtOutputEntry) return;
    prtOutputEntry->prtOutputMaxDimFeedDir = &prtOutputMaxDimFeedDir;
    printer_mib_set_prtOutputEntry(s, prtOutputEntry, PRINTER_MIB_PRTOUTPUTMAXDIMFEEDDIR, error);
    printer_mib_free_prtOutputEntry(prtOutputEntry);
}

void
printer_mib_set_prtOutputMaxDimXFeedDir(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint32 prtOutputMaxDimXFeedDir, GError **error)
{
    printer_mib_prtOutputEntry_t *prtOutputEntry;

    printer_mib_get_prtOutputEntry(s, &prtOutputEntry, hrDeviceIndex, prtOutputIndex, PRINTER_MIB_PRTOUTPUTMAXDIMXFEEDDIR, error);
    if (error && *error) return;
    if (s->error_status || !prtOutputEntry) return;
    prtOutputEntry->prtOutputMaxDimXFeedDir = &prtOutputMaxDimXFeedDir;
    printer_mib_set_prtOutputEntry(s, prtOutputEntry, PRINTER_MIB_PRTOUTPUTMAXDIMXFEEDDIR, error);
    printer_mib_free_prtOutputEntry(prtOutputEntry);
}

void
printer_mib_set_prtOutputMinDimFeedDir(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint32 prtOutputMinDimFeedDir, GError **error)
{
    printer_mib_prtOutputEntry_t *prtOutputEntry;

    printer_mib_get_prtOutputEntry(s, &prtOutputEntry, hrDeviceIndex, prtOutputIndex, PRINTER_MIB_PRTOUTPUTMINDIMFEEDDIR, error);
    if (error && *error) return;
    if (s->error_status || !prtOutputEntry) return;
    prtOutputEntry->prtOutputMinDimFeedDir = &prtOutputMinDimFeedDir;
    printer_mib_set_prtOutputEntry(s, prtOutputEntry, PRINTER_MIB_PRTOUTPUTMINDIMFEEDDIR, error);
    printer_mib_free_prtOutputEntry(prtOutputEntry);
}

void
printer_mib_set_prtOutputMinDimXFeedDir(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint32 prtOutputMinDimXFeedDir, GError **error)
{
    printer_mib_prtOutputEntry_t *prtOutputEntry;

    printer_mib_get_prtOutputEntry(s, &prtOutputEntry, hrDeviceIndex, prtOutputIndex, PRINTER_MIB_PRTOUTPUTMINDIMXFEEDDIR, error);
    if (error && *error) return;
    if (s->error_status || !prtOutputEntry) return;
    prtOutputEntry->prtOutputMinDimXFeedDir = &prtOutputMinDimXFeedDir;
    printer_mib_set_prtOutputEntry(s, prtOutputEntry, PRINTER_MIB_PRTOUTPUTMINDIMXFEEDDIR, error);
    printer_mib_free_prtOutputEntry(prtOutputEntry);
}

void
printer_mib_set_prtOutputStackingOrder(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint32 prtOutputStackingOrder, GError **error)
{
    printer_mib_prtOutputEntry_t *prtOutputEntry;

    printer_mib_get_prtOutputEntry(s, &prtOutputEntry, hrDeviceIndex, prtOutputIndex, PRINTER_MIB_PRTOUTPUTSTACKINGORDER, error);
    if (error && *error) return;
    if (s->error_status || !prtOutputEntry) return;
    prtOutputEntry->prtOutputStackingOrder = &prtOutputStackingOrder;
    printer_mib_set_prtOutputEntry(s, prtOutputEntry, PRINTER_MIB_PRTOUTPUTSTACKINGORDER, error);
    printer_mib_free_prtOutputEntry(prtOutputEntry);
}

void
printer_mib_set_prtOutputPageDeliveryOrientation(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint32 prtOutputPageDeliveryOrientation, GError **error)
{
    printer_mib_prtOutputEntry_t *prtOutputEntry;

    printer_mib_get_prtOutputEntry(s, &prtOutputEntry, hrDeviceIndex, prtOutputIndex, PRINTER_MIB_PRTOUTPUTPAGEDELIVERYORIENTATION, error);
    if (error && *error) return;
    if (s->error_status || !prtOutputEntry) return;
    prtOutputEntry->prtOutputPageDeliveryOrientation = &prtOutputPageDeliveryOrientation;
    printer_mib_set_prtOutputEntry(s, prtOutputEntry, PRINTER_MIB_PRTOUTPUTPAGEDELIVERYORIENTATION, error);
    printer_mib_free_prtOutputEntry(prtOutputEntry);
}

void
printer_mib_set_prtOutputBursting(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint32 prtOutputBursting, GError **error)
{
    printer_mib_prtOutputEntry_t *prtOutputEntry;

    printer_mib_get_prtOutputEntry(s, &prtOutputEntry, hrDeviceIndex, prtOutputIndex, PRINTER_MIB_PRTOUTPUTBURSTING, error);
    if (error && *error) return;
    if (s->error_status || !prtOutputEntry) return;
    prtOutputEntry->prtOutputBursting = &prtOutputBursting;
    printer_mib_set_prtOutputEntry(s, prtOutputEntry, PRINTER_MIB_PRTOUTPUTBURSTING, error);
    printer_mib_free_prtOutputEntry(prtOutputEntry);
}

void
printer_mib_set_prtOutputDecollating(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint32 prtOutputDecollating, GError **error)
{
    printer_mib_prtOutputEntry_t *prtOutputEntry;

    printer_mib_get_prtOutputEntry(s, &prtOutputEntry, hrDeviceIndex, prtOutputIndex, PRINTER_MIB_PRTOUTPUTDECOLLATING, error);
    if (error && *error) return;
    if (s->error_status || !prtOutputEntry) return;
    prtOutputEntry->prtOutputDecollating = &prtOutputDecollating;
    printer_mib_set_prtOutputEntry(s, prtOutputEntry, PRINTER_MIB_PRTOUTPUTDECOLLATING, error);
    printer_mib_free_prtOutputEntry(prtOutputEntry);
}

void
printer_mib_set_prtOutputPageCollated(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint32 prtOutputPageCollated, GError **error)
{
    printer_mib_prtOutputEntry_t *prtOutputEntry;

    printer_mib_get_prtOutputEntry(s, &prtOutputEntry, hrDeviceIndex, prtOutputIndex, PRINTER_MIB_PRTOUTPUTPAGECOLLATED, error);
    if (error && *error) return;
    if (s->error_status || !prtOutputEntry) return;
    prtOutputEntry->prtOutputPageCollated = &prtOutputPageCollated;
    printer_mib_set_prtOutputEntry(s, prtOutputEntry, PRINTER_MIB_PRTOUTPUTPAGECOLLATED, error);
    printer_mib_free_prtOutputEntry(prtOutputEntry);
}

void
printer_mib_set_prtOutputOffsetStacking(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtOutputIndex, gint32 prtOutputOffsetStacking, GError **error)
{
    printer_mib_prtOutputEntry_t *prtOutputEntry;

    printer_mib_get_prtOutputEntry(s, &prtOutputEntry, hrDeviceIndex, prtOutputIndex, PRINTER_MIB_PRTOUTPUTOFFSETSTACKING, error);
    if (error && *error) return;
    if (s->error_status || !prtOutputEntry) return;
    prtOutputEntry->prtOutputOffsetStacking = &prtOutputOffsetStacking;
    printer_mib_set_prtOutputEntry(s, prtOutputEntry, PRINTER_MIB_PRTOUTPUTOFFSETSTACKING, error);
    printer_mib_free_prtOutputEntry(prtOutputEntry);
}

printer_mib_prtMarkerEntry_t *
printer_mib_new_prtMarkerEntry()
{
    printer_mib_prtMarkerEntry_t *prtMarkerEntry;

    prtMarkerEntry = (printer_mib_prtMarkerEntry_t *) g_malloc0(sizeof(printer_mib_prtMarkerEntry_t) + sizeof(gpointer));
    return prtMarkerEntry;
}

static inline int
unpack_prtMarkerEntry(GNetSnmpVarBind *vb, printer_mib_prtMarkerEntry_t *prtMarkerEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    prtMarkerEntry->hrDeviceIndex = vb->oid[idx++];
    if ((prtMarkerEntry->hrDeviceIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    prtMarkerEntry->prtMarkerIndex = vb->oid[idx++];
    if ((prtMarkerEntry->prtMarkerIndex < 1 || prtMarkerEntry->prtMarkerIndex > 65535)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_prtMarkerEntry(guint32 *base, gint32 hrDeviceIndex, gint32 prtMarkerIndex)
{
    guint8 idx = 11;

    base[idx++] = hrDeviceIndex;
    base[idx++] = prtMarkerIndex;
    return idx;
}

static inline printer_mib_prtMarkerEntry_t *
assign_prtMarkerEntry(GList *vbl)
{
    printer_mib_prtMarkerEntry_t *prtMarkerEntry;
    char *p;

    prtMarkerEntry = printer_mib_new_prtMarkerEntry();
    p = (char *) prtMarkerEntry + sizeof(printer_mib_prtMarkerEntry_t);
    * (GList **) p = vbl;

    if (unpack_prtMarkerEntry((GNetSnmpVarBind *) vbl->data, prtMarkerEntry) < 0) {
        g_warning("%s: invalid instance identifier", "prtMarkerEntry");
        g_free(prtMarkerEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, prtMarkerEntry_oid, G_N_ELEMENTS(prtMarkerEntry_oid),
                      prtMarkerEntry_attr, prtMarkerEntry);

    return prtMarkerEntry;
}

void
printer_mib_get_prtMarkerTable(GNetSnmp *s, printer_mib_prtMarkerEntry_t ***prtMarkerEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 0};
    guint32 base[128];

    *prtMarkerEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, prtMarkerEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *prtMarkerEntry = (printer_mib_prtMarkerEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(printer_mib_prtMarkerEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*prtMarkerEntry)[i] = assign_prtMarkerEntry(row->data);
        }
    }
}

void
printer_mib_get_prtMarkerEntry(GNetSnmp *s, printer_mib_prtMarkerEntry_t **prtMarkerEntry, gint32 hrDeviceIndex, gint32 prtMarkerIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, prtMarkerEntry_oid, sizeof(prtMarkerEntry_oid));
    len = pack_prtMarkerEntry(base, hrDeviceIndex, prtMarkerIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "prtMarkerEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *prtMarkerEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, prtMarkerEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *prtMarkerEntry = assign_prtMarkerEntry(out);
    }
}

void
printer_mib_free_prtMarkerEntry(printer_mib_prtMarkerEntry_t *prtMarkerEntry)
{
    GList *vbl;
    char *p;

    if (prtMarkerEntry) {
        p = (char *) prtMarkerEntry + sizeof(printer_mib_prtMarkerEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(prtMarkerEntry);
    }
}

void
printer_mib_free_prtMarkerTable(printer_mib_prtMarkerEntry_t **prtMarkerEntry)
{
    int i;

    if (prtMarkerEntry) {
        for (i = 0; prtMarkerEntry[i]; i++) {
            printer_mib_free_prtMarkerEntry(prtMarkerEntry[i]);
        }
        g_free(prtMarkerEntry);
    }
}

printer_mib_prtMarkerSuppliesEntry_t *
printer_mib_new_prtMarkerSuppliesEntry()
{
    printer_mib_prtMarkerSuppliesEntry_t *prtMarkerSuppliesEntry;

    prtMarkerSuppliesEntry = (printer_mib_prtMarkerSuppliesEntry_t *) g_malloc0(sizeof(printer_mib_prtMarkerSuppliesEntry_t) + sizeof(gpointer));
    return prtMarkerSuppliesEntry;
}

static inline int
unpack_prtMarkerSuppliesEntry(GNetSnmpVarBind *vb, printer_mib_prtMarkerSuppliesEntry_t *prtMarkerSuppliesEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    prtMarkerSuppliesEntry->hrDeviceIndex = vb->oid[idx++];
    if ((prtMarkerSuppliesEntry->hrDeviceIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    prtMarkerSuppliesEntry->prtMarkerSuppliesIndex = vb->oid[idx++];
    if ((prtMarkerSuppliesEntry->prtMarkerSuppliesIndex < 1 || prtMarkerSuppliesEntry->prtMarkerSuppliesIndex > 65535)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_prtMarkerSuppliesEntry(guint32 *base, gint32 hrDeviceIndex, gint32 prtMarkerSuppliesIndex)
{
    guint8 idx = 11;

    base[idx++] = hrDeviceIndex;
    base[idx++] = prtMarkerSuppliesIndex;
    return idx;
}

static inline printer_mib_prtMarkerSuppliesEntry_t *
assign_prtMarkerSuppliesEntry(GList *vbl)
{
    printer_mib_prtMarkerSuppliesEntry_t *prtMarkerSuppliesEntry;
    char *p;

    prtMarkerSuppliesEntry = printer_mib_new_prtMarkerSuppliesEntry();
    p = (char *) prtMarkerSuppliesEntry + sizeof(printer_mib_prtMarkerSuppliesEntry_t);
    * (GList **) p = vbl;

    if (unpack_prtMarkerSuppliesEntry((GNetSnmpVarBind *) vbl->data, prtMarkerSuppliesEntry) < 0) {
        g_warning("%s: invalid instance identifier", "prtMarkerSuppliesEntry");
        g_free(prtMarkerSuppliesEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, prtMarkerSuppliesEntry_oid, G_N_ELEMENTS(prtMarkerSuppliesEntry_oid),
                      prtMarkerSuppliesEntry_attr, prtMarkerSuppliesEntry);

    return prtMarkerSuppliesEntry;
}

void
printer_mib_get_prtMarkerSuppliesTable(GNetSnmp *s, printer_mib_prtMarkerSuppliesEntry_t ***prtMarkerSuppliesEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 43, 11, 1, 1, 0};
    guint32 base[128];

    *prtMarkerSuppliesEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, prtMarkerSuppliesEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *prtMarkerSuppliesEntry = (printer_mib_prtMarkerSuppliesEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(printer_mib_prtMarkerSuppliesEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*prtMarkerSuppliesEntry)[i] = assign_prtMarkerSuppliesEntry(row->data);
        }
    }
}

void
printer_mib_get_prtMarkerSuppliesEntry(GNetSnmp *s, printer_mib_prtMarkerSuppliesEntry_t **prtMarkerSuppliesEntry, gint32 hrDeviceIndex, gint32 prtMarkerSuppliesIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, prtMarkerSuppliesEntry_oid, sizeof(prtMarkerSuppliesEntry_oid));
    len = pack_prtMarkerSuppliesEntry(base, hrDeviceIndex, prtMarkerSuppliesIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "prtMarkerSuppliesEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *prtMarkerSuppliesEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, prtMarkerSuppliesEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *prtMarkerSuppliesEntry = assign_prtMarkerSuppliesEntry(out);
    }
}

void
printer_mib_set_prtMarkerSuppliesEntry(GNetSnmp *s, printer_mib_prtMarkerSuppliesEntry_t *prtMarkerSuppliesEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, prtMarkerSuppliesEntry_oid, sizeof(prtMarkerSuppliesEntry_oid));
    len = pack_prtMarkerSuppliesEntry(base, prtMarkerSuppliesEntry->hrDeviceIndex, prtMarkerSuppliesEntry->prtMarkerSuppliesIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "prtMarkerSuppliesEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 10, prtMarkerSuppliesEntry_attr, mask, prtMarkerSuppliesEntry);

    out = gnet_snmp_sync_set(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
printer_mib_free_prtMarkerSuppliesEntry(printer_mib_prtMarkerSuppliesEntry_t *prtMarkerSuppliesEntry)
{
    GList *vbl;
    char *p;

    if (prtMarkerSuppliesEntry) {
        p = (char *) prtMarkerSuppliesEntry + sizeof(printer_mib_prtMarkerSuppliesEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(prtMarkerSuppliesEntry);
    }
}

void
printer_mib_free_prtMarkerSuppliesTable(printer_mib_prtMarkerSuppliesEntry_t **prtMarkerSuppliesEntry)
{
    int i;

    if (prtMarkerSuppliesEntry) {
        for (i = 0; prtMarkerSuppliesEntry[i]; i++) {
            printer_mib_free_prtMarkerSuppliesEntry(prtMarkerSuppliesEntry[i]);
        }
        g_free(prtMarkerSuppliesEntry);
    }
}

void
printer_mib_set_prtMarkerSuppliesMaxCapacity(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtMarkerSuppliesIndex, gint32 prtMarkerSuppliesMaxCapacity, GError **error)
{
    printer_mib_prtMarkerSuppliesEntry_t *prtMarkerSuppliesEntry;

    printer_mib_get_prtMarkerSuppliesEntry(s, &prtMarkerSuppliesEntry, hrDeviceIndex, prtMarkerSuppliesIndex, PRINTER_MIB_PRTMARKERSUPPLIESMAXCAPACITY, error);
    if (error && *error) return;
    if (s->error_status || !prtMarkerSuppliesEntry) return;
    prtMarkerSuppliesEntry->prtMarkerSuppliesMaxCapacity = &prtMarkerSuppliesMaxCapacity;
    printer_mib_set_prtMarkerSuppliesEntry(s, prtMarkerSuppliesEntry, PRINTER_MIB_PRTMARKERSUPPLIESMAXCAPACITY, error);
    printer_mib_free_prtMarkerSuppliesEntry(prtMarkerSuppliesEntry);
}

void
printer_mib_set_prtMarkerSuppliesLevel(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtMarkerSuppliesIndex, gint32 prtMarkerSuppliesLevel, GError **error)
{
    printer_mib_prtMarkerSuppliesEntry_t *prtMarkerSuppliesEntry;

    printer_mib_get_prtMarkerSuppliesEntry(s, &prtMarkerSuppliesEntry, hrDeviceIndex, prtMarkerSuppliesIndex, PRINTER_MIB_PRTMARKERSUPPLIESLEVEL, error);
    if (error && *error) return;
    if (s->error_status || !prtMarkerSuppliesEntry) return;
    prtMarkerSuppliesEntry->prtMarkerSuppliesLevel = &prtMarkerSuppliesLevel;
    printer_mib_set_prtMarkerSuppliesEntry(s, prtMarkerSuppliesEntry, PRINTER_MIB_PRTMARKERSUPPLIESLEVEL, error);
    printer_mib_free_prtMarkerSuppliesEntry(prtMarkerSuppliesEntry);
}

printer_mib_prtMarkerColorantEntry_t *
printer_mib_new_prtMarkerColorantEntry()
{
    printer_mib_prtMarkerColorantEntry_t *prtMarkerColorantEntry;

    prtMarkerColorantEntry = (printer_mib_prtMarkerColorantEntry_t *) g_malloc0(sizeof(printer_mib_prtMarkerColorantEntry_t) + sizeof(gpointer));
    return prtMarkerColorantEntry;
}

static inline int
unpack_prtMarkerColorantEntry(GNetSnmpVarBind *vb, printer_mib_prtMarkerColorantEntry_t *prtMarkerColorantEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    prtMarkerColorantEntry->hrDeviceIndex = vb->oid[idx++];
    if ((prtMarkerColorantEntry->hrDeviceIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    prtMarkerColorantEntry->prtMarkerColorantIndex = vb->oid[idx++];
    if ((prtMarkerColorantEntry->prtMarkerColorantIndex < 1 || prtMarkerColorantEntry->prtMarkerColorantIndex > 65535)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_prtMarkerColorantEntry(guint32 *base, gint32 hrDeviceIndex, gint32 prtMarkerColorantIndex)
{
    guint8 idx = 11;

    base[idx++] = hrDeviceIndex;
    base[idx++] = prtMarkerColorantIndex;
    return idx;
}

static inline printer_mib_prtMarkerColorantEntry_t *
assign_prtMarkerColorantEntry(GList *vbl)
{
    printer_mib_prtMarkerColorantEntry_t *prtMarkerColorantEntry;
    char *p;

    prtMarkerColorantEntry = printer_mib_new_prtMarkerColorantEntry();
    p = (char *) prtMarkerColorantEntry + sizeof(printer_mib_prtMarkerColorantEntry_t);
    * (GList **) p = vbl;

    if (unpack_prtMarkerColorantEntry((GNetSnmpVarBind *) vbl->data, prtMarkerColorantEntry) < 0) {
        g_warning("%s: invalid instance identifier", "prtMarkerColorantEntry");
        g_free(prtMarkerColorantEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, prtMarkerColorantEntry_oid, G_N_ELEMENTS(prtMarkerColorantEntry_oid),
                      prtMarkerColorantEntry_attr, prtMarkerColorantEntry);

    return prtMarkerColorantEntry;
}

void
printer_mib_get_prtMarkerColorantTable(GNetSnmp *s, printer_mib_prtMarkerColorantEntry_t ***prtMarkerColorantEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 43, 12, 1, 1, 0};
    guint32 base[128];

    *prtMarkerColorantEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, prtMarkerColorantEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *prtMarkerColorantEntry = (printer_mib_prtMarkerColorantEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(printer_mib_prtMarkerColorantEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*prtMarkerColorantEntry)[i] = assign_prtMarkerColorantEntry(row->data);
        }
    }
}

void
printer_mib_get_prtMarkerColorantEntry(GNetSnmp *s, printer_mib_prtMarkerColorantEntry_t **prtMarkerColorantEntry, gint32 hrDeviceIndex, gint32 prtMarkerColorantIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, prtMarkerColorantEntry_oid, sizeof(prtMarkerColorantEntry_oid));
    len = pack_prtMarkerColorantEntry(base, hrDeviceIndex, prtMarkerColorantIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "prtMarkerColorantEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *prtMarkerColorantEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, prtMarkerColorantEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *prtMarkerColorantEntry = assign_prtMarkerColorantEntry(out);
    }
}

void
printer_mib_free_prtMarkerColorantEntry(printer_mib_prtMarkerColorantEntry_t *prtMarkerColorantEntry)
{
    GList *vbl;
    char *p;

    if (prtMarkerColorantEntry) {
        p = (char *) prtMarkerColorantEntry + sizeof(printer_mib_prtMarkerColorantEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(prtMarkerColorantEntry);
    }
}

void
printer_mib_free_prtMarkerColorantTable(printer_mib_prtMarkerColorantEntry_t **prtMarkerColorantEntry)
{
    int i;

    if (prtMarkerColorantEntry) {
        for (i = 0; prtMarkerColorantEntry[i]; i++) {
            printer_mib_free_prtMarkerColorantEntry(prtMarkerColorantEntry[i]);
        }
        g_free(prtMarkerColorantEntry);
    }
}

printer_mib_prtMediaPathEntry_t *
printer_mib_new_prtMediaPathEntry()
{
    printer_mib_prtMediaPathEntry_t *prtMediaPathEntry;

    prtMediaPathEntry = (printer_mib_prtMediaPathEntry_t *) g_malloc0(sizeof(printer_mib_prtMediaPathEntry_t) + sizeof(gpointer));
    return prtMediaPathEntry;
}

static inline int
unpack_prtMediaPathEntry(GNetSnmpVarBind *vb, printer_mib_prtMediaPathEntry_t *prtMediaPathEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    prtMediaPathEntry->hrDeviceIndex = vb->oid[idx++];
    if ((prtMediaPathEntry->hrDeviceIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    prtMediaPathEntry->prtMediaPathIndex = vb->oid[idx++];
    if ((prtMediaPathEntry->prtMediaPathIndex < 1 || prtMediaPathEntry->prtMediaPathIndex > 65535)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_prtMediaPathEntry(guint32 *base, gint32 hrDeviceIndex, gint32 prtMediaPathIndex)
{
    guint8 idx = 11;

    base[idx++] = hrDeviceIndex;
    base[idx++] = prtMediaPathIndex;
    return idx;
}

static inline printer_mib_prtMediaPathEntry_t *
assign_prtMediaPathEntry(GList *vbl)
{
    printer_mib_prtMediaPathEntry_t *prtMediaPathEntry;
    char *p;

    prtMediaPathEntry = printer_mib_new_prtMediaPathEntry();
    p = (char *) prtMediaPathEntry + sizeof(printer_mib_prtMediaPathEntry_t);
    * (GList **) p = vbl;

    if (unpack_prtMediaPathEntry((GNetSnmpVarBind *) vbl->data, prtMediaPathEntry) < 0) {
        g_warning("%s: invalid instance identifier", "prtMediaPathEntry");
        g_free(prtMediaPathEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, prtMediaPathEntry_oid, G_N_ELEMENTS(prtMediaPathEntry_oid),
                      prtMediaPathEntry_attr, prtMediaPathEntry);

    return prtMediaPathEntry;
}

void
printer_mib_get_prtMediaPathTable(GNetSnmp *s, printer_mib_prtMediaPathEntry_t ***prtMediaPathEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 43, 13, 4, 1, 0};
    guint32 base[128];

    *prtMediaPathEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, prtMediaPathEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *prtMediaPathEntry = (printer_mib_prtMediaPathEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(printer_mib_prtMediaPathEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*prtMediaPathEntry)[i] = assign_prtMediaPathEntry(row->data);
        }
    }
}

void
printer_mib_get_prtMediaPathEntry(GNetSnmp *s, printer_mib_prtMediaPathEntry_t **prtMediaPathEntry, gint32 hrDeviceIndex, gint32 prtMediaPathIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, prtMediaPathEntry_oid, sizeof(prtMediaPathEntry_oid));
    len = pack_prtMediaPathEntry(base, hrDeviceIndex, prtMediaPathIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "prtMediaPathEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *prtMediaPathEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, prtMediaPathEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *prtMediaPathEntry = assign_prtMediaPathEntry(out);
    }
}

void
printer_mib_free_prtMediaPathEntry(printer_mib_prtMediaPathEntry_t *prtMediaPathEntry)
{
    GList *vbl;
    char *p;

    if (prtMediaPathEntry) {
        p = (char *) prtMediaPathEntry + sizeof(printer_mib_prtMediaPathEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(prtMediaPathEntry);
    }
}

void
printer_mib_free_prtMediaPathTable(printer_mib_prtMediaPathEntry_t **prtMediaPathEntry)
{
    int i;

    if (prtMediaPathEntry) {
        for (i = 0; prtMediaPathEntry[i]; i++) {
            printer_mib_free_prtMediaPathEntry(prtMediaPathEntry[i]);
        }
        g_free(prtMediaPathEntry);
    }
}

printer_mib_prtChannelEntry_t *
printer_mib_new_prtChannelEntry()
{
    printer_mib_prtChannelEntry_t *prtChannelEntry;

    prtChannelEntry = (printer_mib_prtChannelEntry_t *) g_malloc0(sizeof(printer_mib_prtChannelEntry_t) + sizeof(gpointer));
    return prtChannelEntry;
}

static inline int
unpack_prtChannelEntry(GNetSnmpVarBind *vb, printer_mib_prtChannelEntry_t *prtChannelEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    prtChannelEntry->hrDeviceIndex = vb->oid[idx++];
    if ((prtChannelEntry->hrDeviceIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    prtChannelEntry->prtChannelIndex = vb->oid[idx++];
    if ((prtChannelEntry->prtChannelIndex < 1 || prtChannelEntry->prtChannelIndex > 65535)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_prtChannelEntry(guint32 *base, gint32 hrDeviceIndex, gint32 prtChannelIndex)
{
    guint8 idx = 11;

    base[idx++] = hrDeviceIndex;
    base[idx++] = prtChannelIndex;
    return idx;
}

static inline printer_mib_prtChannelEntry_t *
assign_prtChannelEntry(GList *vbl)
{
    printer_mib_prtChannelEntry_t *prtChannelEntry;
    char *p;

    prtChannelEntry = printer_mib_new_prtChannelEntry();
    p = (char *) prtChannelEntry + sizeof(printer_mib_prtChannelEntry_t);
    * (GList **) p = vbl;

    if (unpack_prtChannelEntry((GNetSnmpVarBind *) vbl->data, prtChannelEntry) < 0) {
        g_warning("%s: invalid instance identifier", "prtChannelEntry");
        g_free(prtChannelEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, prtChannelEntry_oid, G_N_ELEMENTS(prtChannelEntry_oid),
                      prtChannelEntry_attr, prtChannelEntry);

    return prtChannelEntry;
}

void
printer_mib_get_prtChannelTable(GNetSnmp *s, printer_mib_prtChannelEntry_t ***prtChannelEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 43, 14, 1, 1, 0};
    guint32 base[128];

    *prtChannelEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, prtChannelEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *prtChannelEntry = (printer_mib_prtChannelEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(printer_mib_prtChannelEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*prtChannelEntry)[i] = assign_prtChannelEntry(row->data);
        }
    }
}

void
printer_mib_get_prtChannelEntry(GNetSnmp *s, printer_mib_prtChannelEntry_t **prtChannelEntry, gint32 hrDeviceIndex, gint32 prtChannelIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, prtChannelEntry_oid, sizeof(prtChannelEntry_oid));
    len = pack_prtChannelEntry(base, hrDeviceIndex, prtChannelIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "prtChannelEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *prtChannelEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, prtChannelEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *prtChannelEntry = assign_prtChannelEntry(out);
    }
}

void
printer_mib_set_prtChannelEntry(GNetSnmp *s, printer_mib_prtChannelEntry_t *prtChannelEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, prtChannelEntry_oid, sizeof(prtChannelEntry_oid));
    len = pack_prtChannelEntry(base, prtChannelEntry->hrDeviceIndex, prtChannelEntry->prtChannelIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "prtChannelEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 10, prtChannelEntry_attr, mask, prtChannelEntry);

    out = gnet_snmp_sync_set(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
printer_mib_free_prtChannelEntry(printer_mib_prtChannelEntry_t *prtChannelEntry)
{
    GList *vbl;
    char *p;

    if (prtChannelEntry) {
        p = (char *) prtChannelEntry + sizeof(printer_mib_prtChannelEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(prtChannelEntry);
    }
}

void
printer_mib_free_prtChannelTable(printer_mib_prtChannelEntry_t **prtChannelEntry)
{
    int i;

    if (prtChannelEntry) {
        for (i = 0; prtChannelEntry[i]; i++) {
            printer_mib_free_prtChannelEntry(prtChannelEntry[i]);
        }
        g_free(prtChannelEntry);
    }
}

void
printer_mib_set_prtChannelCurrentJobCntlLangIndex(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtChannelIndex, gint32 prtChannelCurrentJobCntlLangIndex, GError **error)
{
    printer_mib_prtChannelEntry_t *prtChannelEntry;

    printer_mib_get_prtChannelEntry(s, &prtChannelEntry, hrDeviceIndex, prtChannelIndex, PRINTER_MIB_PRTCHANNELCURRENTJOBCNTLLANGINDEX, error);
    if (error && *error) return;
    if (s->error_status || !prtChannelEntry) return;
    prtChannelEntry->prtChannelCurrentJobCntlLangIndex = &prtChannelCurrentJobCntlLangIndex;
    printer_mib_set_prtChannelEntry(s, prtChannelEntry, PRINTER_MIB_PRTCHANNELCURRENTJOBCNTLLANGINDEX, error);
    printer_mib_free_prtChannelEntry(prtChannelEntry);
}

void
printer_mib_set_prtChannelDefaultPageDescLangIndex(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtChannelIndex, gint32 prtChannelDefaultPageDescLangIndex, GError **error)
{
    printer_mib_prtChannelEntry_t *prtChannelEntry;

    printer_mib_get_prtChannelEntry(s, &prtChannelEntry, hrDeviceIndex, prtChannelIndex, PRINTER_MIB_PRTCHANNELDEFAULTPAGEDESCLANGINDEX, error);
    if (error && *error) return;
    if (s->error_status || !prtChannelEntry) return;
    prtChannelEntry->prtChannelDefaultPageDescLangIndex = &prtChannelDefaultPageDescLangIndex;
    printer_mib_set_prtChannelEntry(s, prtChannelEntry, PRINTER_MIB_PRTCHANNELDEFAULTPAGEDESCLANGINDEX, error);
    printer_mib_free_prtChannelEntry(prtChannelEntry);
}

void
printer_mib_set_prtChannelState(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtChannelIndex, gint32 prtChannelState, GError **error)
{
    printer_mib_prtChannelEntry_t *prtChannelEntry;

    printer_mib_get_prtChannelEntry(s, &prtChannelEntry, hrDeviceIndex, prtChannelIndex, PRINTER_MIB_PRTCHANNELSTATE, error);
    if (error && *error) return;
    if (s->error_status || !prtChannelEntry) return;
    prtChannelEntry->prtChannelState = &prtChannelState;
    printer_mib_set_prtChannelEntry(s, prtChannelEntry, PRINTER_MIB_PRTCHANNELSTATE, error);
    printer_mib_free_prtChannelEntry(prtChannelEntry);
}

void
printer_mib_set_prtChannelIfIndex(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtChannelIndex, gint32 prtChannelIfIndex, GError **error)
{
    printer_mib_prtChannelEntry_t *prtChannelEntry;

    printer_mib_get_prtChannelEntry(s, &prtChannelEntry, hrDeviceIndex, prtChannelIndex, PRINTER_MIB_PRTCHANNELIFINDEX, error);
    if (error && *error) return;
    if (s->error_status || !prtChannelEntry) return;
    prtChannelEntry->prtChannelIfIndex = &prtChannelIfIndex;
    printer_mib_set_prtChannelEntry(s, prtChannelEntry, PRINTER_MIB_PRTCHANNELIFINDEX, error);
    printer_mib_free_prtChannelEntry(prtChannelEntry);
}

printer_mib_prtInterpreterEntry_t *
printer_mib_new_prtInterpreterEntry()
{
    printer_mib_prtInterpreterEntry_t *prtInterpreterEntry;

    prtInterpreterEntry = (printer_mib_prtInterpreterEntry_t *) g_malloc0(sizeof(printer_mib_prtInterpreterEntry_t) + sizeof(gpointer));
    return prtInterpreterEntry;
}

static inline int
unpack_prtInterpreterEntry(GNetSnmpVarBind *vb, printer_mib_prtInterpreterEntry_t *prtInterpreterEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    prtInterpreterEntry->hrDeviceIndex = vb->oid[idx++];
    if ((prtInterpreterEntry->hrDeviceIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    prtInterpreterEntry->prtInterpreterIndex = vb->oid[idx++];
    if ((prtInterpreterEntry->prtInterpreterIndex < 1 || prtInterpreterEntry->prtInterpreterIndex > 65535)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_prtInterpreterEntry(guint32 *base, gint32 hrDeviceIndex, gint32 prtInterpreterIndex)
{
    guint8 idx = 11;

    base[idx++] = hrDeviceIndex;
    base[idx++] = prtInterpreterIndex;
    return idx;
}

static inline printer_mib_prtInterpreterEntry_t *
assign_prtInterpreterEntry(GList *vbl)
{
    printer_mib_prtInterpreterEntry_t *prtInterpreterEntry;
    char *p;

    prtInterpreterEntry = printer_mib_new_prtInterpreterEntry();
    p = (char *) prtInterpreterEntry + sizeof(printer_mib_prtInterpreterEntry_t);
    * (GList **) p = vbl;

    if (unpack_prtInterpreterEntry((GNetSnmpVarBind *) vbl->data, prtInterpreterEntry) < 0) {
        g_warning("%s: invalid instance identifier", "prtInterpreterEntry");
        g_free(prtInterpreterEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, prtInterpreterEntry_oid, G_N_ELEMENTS(prtInterpreterEntry_oid),
                      prtInterpreterEntry_attr, prtInterpreterEntry);

    return prtInterpreterEntry;
}

void
printer_mib_get_prtInterpreterTable(GNetSnmp *s, printer_mib_prtInterpreterEntry_t ***prtInterpreterEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 43, 15, 1, 1, 0};
    guint32 base[128];

    *prtInterpreterEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, prtInterpreterEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *prtInterpreterEntry = (printer_mib_prtInterpreterEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(printer_mib_prtInterpreterEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*prtInterpreterEntry)[i] = assign_prtInterpreterEntry(row->data);
        }
    }
}

void
printer_mib_get_prtInterpreterEntry(GNetSnmp *s, printer_mib_prtInterpreterEntry_t **prtInterpreterEntry, gint32 hrDeviceIndex, gint32 prtInterpreterIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, prtInterpreterEntry_oid, sizeof(prtInterpreterEntry_oid));
    len = pack_prtInterpreterEntry(base, hrDeviceIndex, prtInterpreterIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "prtInterpreterEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *prtInterpreterEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, prtInterpreterEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *prtInterpreterEntry = assign_prtInterpreterEntry(out);
    }
}

void
printer_mib_set_prtInterpreterEntry(GNetSnmp *s, printer_mib_prtInterpreterEntry_t *prtInterpreterEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, prtInterpreterEntry_oid, sizeof(prtInterpreterEntry_oid));
    len = pack_prtInterpreterEntry(base, prtInterpreterEntry->hrDeviceIndex, prtInterpreterEntry->prtInterpreterIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "prtInterpreterEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 10, prtInterpreterEntry_attr, mask, prtInterpreterEntry);

    out = gnet_snmp_sync_set(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
printer_mib_free_prtInterpreterEntry(printer_mib_prtInterpreterEntry_t *prtInterpreterEntry)
{
    GList *vbl;
    char *p;

    if (prtInterpreterEntry) {
        p = (char *) prtInterpreterEntry + sizeof(printer_mib_prtInterpreterEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(prtInterpreterEntry);
    }
}

void
printer_mib_free_prtInterpreterTable(printer_mib_prtInterpreterEntry_t **prtInterpreterEntry)
{
    int i;

    if (prtInterpreterEntry) {
        for (i = 0; prtInterpreterEntry[i]; i++) {
            printer_mib_free_prtInterpreterEntry(prtInterpreterEntry[i]);
        }
        g_free(prtInterpreterEntry);
    }
}

void
printer_mib_set_prtInterpreterDefaultOrientation(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInterpreterIndex, gint32 prtInterpreterDefaultOrientation, GError **error)
{
    printer_mib_prtInterpreterEntry_t *prtInterpreterEntry;

    printer_mib_get_prtInterpreterEntry(s, &prtInterpreterEntry, hrDeviceIndex, prtInterpreterIndex, PRINTER_MIB_PRTINTERPRETERDEFAULTORIENTATION, error);
    if (error && *error) return;
    if (s->error_status || !prtInterpreterEntry) return;
    prtInterpreterEntry->prtInterpreterDefaultOrientation = &prtInterpreterDefaultOrientation;
    printer_mib_set_prtInterpreterEntry(s, prtInterpreterEntry, PRINTER_MIB_PRTINTERPRETERDEFAULTORIENTATION, error);
    printer_mib_free_prtInterpreterEntry(prtInterpreterEntry);
}

void
printer_mib_set_prtInterpreterDefaultCharSetIn(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInterpreterIndex, gint32 prtInterpreterDefaultCharSetIn, GError **error)
{
    printer_mib_prtInterpreterEntry_t *prtInterpreterEntry;

    printer_mib_get_prtInterpreterEntry(s, &prtInterpreterEntry, hrDeviceIndex, prtInterpreterIndex, PRINTER_MIB_PRTINTERPRETERDEFAULTCHARSETIN, error);
    if (error && *error) return;
    if (s->error_status || !prtInterpreterEntry) return;
    prtInterpreterEntry->prtInterpreterDefaultCharSetIn = &prtInterpreterDefaultCharSetIn;
    printer_mib_set_prtInterpreterEntry(s, prtInterpreterEntry, PRINTER_MIB_PRTINTERPRETERDEFAULTCHARSETIN, error);
    printer_mib_free_prtInterpreterEntry(prtInterpreterEntry);
}

void
printer_mib_set_prtInterpreterDefaultCharSetOut(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtInterpreterIndex, gint32 prtInterpreterDefaultCharSetOut, GError **error)
{
    printer_mib_prtInterpreterEntry_t *prtInterpreterEntry;

    printer_mib_get_prtInterpreterEntry(s, &prtInterpreterEntry, hrDeviceIndex, prtInterpreterIndex, PRINTER_MIB_PRTINTERPRETERDEFAULTCHARSETOUT, error);
    if (error && *error) return;
    if (s->error_status || !prtInterpreterEntry) return;
    prtInterpreterEntry->prtInterpreterDefaultCharSetOut = &prtInterpreterDefaultCharSetOut;
    printer_mib_set_prtInterpreterEntry(s, prtInterpreterEntry, PRINTER_MIB_PRTINTERPRETERDEFAULTCHARSETOUT, error);
    printer_mib_free_prtInterpreterEntry(prtInterpreterEntry);
}

printer_mib_prtConsoleDisplayBufferEntry_t *
printer_mib_new_prtConsoleDisplayBufferEntry()
{
    printer_mib_prtConsoleDisplayBufferEntry_t *prtConsoleDisplayBufferEntry;

    prtConsoleDisplayBufferEntry = (printer_mib_prtConsoleDisplayBufferEntry_t *) g_malloc0(sizeof(printer_mib_prtConsoleDisplayBufferEntry_t) + sizeof(gpointer));
    return prtConsoleDisplayBufferEntry;
}

static inline int
unpack_prtConsoleDisplayBufferEntry(GNetSnmpVarBind *vb, printer_mib_prtConsoleDisplayBufferEntry_t *prtConsoleDisplayBufferEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    prtConsoleDisplayBufferEntry->hrDeviceIndex = vb->oid[idx++];
    if ((prtConsoleDisplayBufferEntry->hrDeviceIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    prtConsoleDisplayBufferEntry->prtConsoleDisplayBufferIndex = vb->oid[idx++];
    if ((prtConsoleDisplayBufferEntry->prtConsoleDisplayBufferIndex < 1 || prtConsoleDisplayBufferEntry->prtConsoleDisplayBufferIndex > 65535)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_prtConsoleDisplayBufferEntry(guint32 *base, gint32 hrDeviceIndex, gint32 prtConsoleDisplayBufferIndex)
{
    guint8 idx = 11;

    base[idx++] = hrDeviceIndex;
    base[idx++] = prtConsoleDisplayBufferIndex;
    return idx;
}

static inline printer_mib_prtConsoleDisplayBufferEntry_t *
assign_prtConsoleDisplayBufferEntry(GList *vbl)
{
    printer_mib_prtConsoleDisplayBufferEntry_t *prtConsoleDisplayBufferEntry;
    char *p;

    prtConsoleDisplayBufferEntry = printer_mib_new_prtConsoleDisplayBufferEntry();
    p = (char *) prtConsoleDisplayBufferEntry + sizeof(printer_mib_prtConsoleDisplayBufferEntry_t);
    * (GList **) p = vbl;

    if (unpack_prtConsoleDisplayBufferEntry((GNetSnmpVarBind *) vbl->data, prtConsoleDisplayBufferEntry) < 0) {
        g_warning("%s: invalid instance identifier", "prtConsoleDisplayBufferEntry");
        g_free(prtConsoleDisplayBufferEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, prtConsoleDisplayBufferEntry_oid, G_N_ELEMENTS(prtConsoleDisplayBufferEntry_oid),
                      prtConsoleDisplayBufferEntry_attr, prtConsoleDisplayBufferEntry);

    return prtConsoleDisplayBufferEntry;
}

void
printer_mib_get_prtConsoleDisplayBufferTable(GNetSnmp *s, printer_mib_prtConsoleDisplayBufferEntry_t ***prtConsoleDisplayBufferEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 43, 16, 5, 1, 0};
    guint32 base[128];

    *prtConsoleDisplayBufferEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, prtConsoleDisplayBufferEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *prtConsoleDisplayBufferEntry = (printer_mib_prtConsoleDisplayBufferEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(printer_mib_prtConsoleDisplayBufferEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*prtConsoleDisplayBufferEntry)[i] = assign_prtConsoleDisplayBufferEntry(row->data);
        }
    }
}

void
printer_mib_get_prtConsoleDisplayBufferEntry(GNetSnmp *s, printer_mib_prtConsoleDisplayBufferEntry_t **prtConsoleDisplayBufferEntry, gint32 hrDeviceIndex, gint32 prtConsoleDisplayBufferIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, prtConsoleDisplayBufferEntry_oid, sizeof(prtConsoleDisplayBufferEntry_oid));
    len = pack_prtConsoleDisplayBufferEntry(base, hrDeviceIndex, prtConsoleDisplayBufferIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "prtConsoleDisplayBufferEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *prtConsoleDisplayBufferEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, prtConsoleDisplayBufferEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *prtConsoleDisplayBufferEntry = assign_prtConsoleDisplayBufferEntry(out);
    }
}

void
printer_mib_set_prtConsoleDisplayBufferEntry(GNetSnmp *s, printer_mib_prtConsoleDisplayBufferEntry_t *prtConsoleDisplayBufferEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, prtConsoleDisplayBufferEntry_oid, sizeof(prtConsoleDisplayBufferEntry_oid));
    len = pack_prtConsoleDisplayBufferEntry(base, prtConsoleDisplayBufferEntry->hrDeviceIndex, prtConsoleDisplayBufferEntry->prtConsoleDisplayBufferIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "prtConsoleDisplayBufferEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 10, prtConsoleDisplayBufferEntry_attr, mask, prtConsoleDisplayBufferEntry);

    out = gnet_snmp_sync_set(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
printer_mib_free_prtConsoleDisplayBufferEntry(printer_mib_prtConsoleDisplayBufferEntry_t *prtConsoleDisplayBufferEntry)
{
    GList *vbl;
    char *p;

    if (prtConsoleDisplayBufferEntry) {
        p = (char *) prtConsoleDisplayBufferEntry + sizeof(printer_mib_prtConsoleDisplayBufferEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(prtConsoleDisplayBufferEntry);
    }
}

void
printer_mib_free_prtConsoleDisplayBufferTable(printer_mib_prtConsoleDisplayBufferEntry_t **prtConsoleDisplayBufferEntry)
{
    int i;

    if (prtConsoleDisplayBufferEntry) {
        for (i = 0; prtConsoleDisplayBufferEntry[i]; i++) {
            printer_mib_free_prtConsoleDisplayBufferEntry(prtConsoleDisplayBufferEntry[i]);
        }
        g_free(prtConsoleDisplayBufferEntry);
    }
}

void
printer_mib_set_prtConsoleDisplayBufferText(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtConsoleDisplayBufferIndex, guchar *prtConsoleDisplayBufferText, guint16 _prtConsoleDisplayBufferTextLength, GError **error)
{
    printer_mib_prtConsoleDisplayBufferEntry_t *prtConsoleDisplayBufferEntry;

    printer_mib_get_prtConsoleDisplayBufferEntry(s, &prtConsoleDisplayBufferEntry, hrDeviceIndex, prtConsoleDisplayBufferIndex, PRINTER_MIB_PRTCONSOLEDISPLAYBUFFERTEXT, error);
    if (error && *error) return;
    if (s->error_status || !prtConsoleDisplayBufferEntry) return;
    prtConsoleDisplayBufferEntry->prtConsoleDisplayBufferText = prtConsoleDisplayBufferText;
    prtConsoleDisplayBufferEntry->_prtConsoleDisplayBufferTextLength = _prtConsoleDisplayBufferTextLength;
    printer_mib_set_prtConsoleDisplayBufferEntry(s, prtConsoleDisplayBufferEntry, PRINTER_MIB_PRTCONSOLEDISPLAYBUFFERTEXT, error);
    printer_mib_free_prtConsoleDisplayBufferEntry(prtConsoleDisplayBufferEntry);
}

printer_mib_prtConsoleLightEntry_t *
printer_mib_new_prtConsoleLightEntry()
{
    printer_mib_prtConsoleLightEntry_t *prtConsoleLightEntry;

    prtConsoleLightEntry = (printer_mib_prtConsoleLightEntry_t *) g_malloc0(sizeof(printer_mib_prtConsoleLightEntry_t) + sizeof(gpointer));
    return prtConsoleLightEntry;
}

static inline int
unpack_prtConsoleLightEntry(GNetSnmpVarBind *vb, printer_mib_prtConsoleLightEntry_t *prtConsoleLightEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    prtConsoleLightEntry->hrDeviceIndex = vb->oid[idx++];
    if ((prtConsoleLightEntry->hrDeviceIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    prtConsoleLightEntry->prtConsoleLightIndex = vb->oid[idx++];
    if ((prtConsoleLightEntry->prtConsoleLightIndex < 1 || prtConsoleLightEntry->prtConsoleLightIndex > 65535)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_prtConsoleLightEntry(guint32 *base, gint32 hrDeviceIndex, gint32 prtConsoleLightIndex)
{
    guint8 idx = 11;

    base[idx++] = hrDeviceIndex;
    base[idx++] = prtConsoleLightIndex;
    return idx;
}

static inline printer_mib_prtConsoleLightEntry_t *
assign_prtConsoleLightEntry(GList *vbl)
{
    printer_mib_prtConsoleLightEntry_t *prtConsoleLightEntry;
    char *p;

    prtConsoleLightEntry = printer_mib_new_prtConsoleLightEntry();
    p = (char *) prtConsoleLightEntry + sizeof(printer_mib_prtConsoleLightEntry_t);
    * (GList **) p = vbl;

    if (unpack_prtConsoleLightEntry((GNetSnmpVarBind *) vbl->data, prtConsoleLightEntry) < 0) {
        g_warning("%s: invalid instance identifier", "prtConsoleLightEntry");
        g_free(prtConsoleLightEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, prtConsoleLightEntry_oid, G_N_ELEMENTS(prtConsoleLightEntry_oid),
                      prtConsoleLightEntry_attr, prtConsoleLightEntry);

    return prtConsoleLightEntry;
}

void
printer_mib_get_prtConsoleLightTable(GNetSnmp *s, printer_mib_prtConsoleLightEntry_t ***prtConsoleLightEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 43, 17, 6, 1, 0};
    guint32 base[128];

    *prtConsoleLightEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, prtConsoleLightEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *prtConsoleLightEntry = (printer_mib_prtConsoleLightEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(printer_mib_prtConsoleLightEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*prtConsoleLightEntry)[i] = assign_prtConsoleLightEntry(row->data);
        }
    }
}

void
printer_mib_get_prtConsoleLightEntry(GNetSnmp *s, printer_mib_prtConsoleLightEntry_t **prtConsoleLightEntry, gint32 hrDeviceIndex, gint32 prtConsoleLightIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, prtConsoleLightEntry_oid, sizeof(prtConsoleLightEntry_oid));
    len = pack_prtConsoleLightEntry(base, hrDeviceIndex, prtConsoleLightIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "prtConsoleLightEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *prtConsoleLightEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, prtConsoleLightEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *prtConsoleLightEntry = assign_prtConsoleLightEntry(out);
    }
}

void
printer_mib_set_prtConsoleLightEntry(GNetSnmp *s, printer_mib_prtConsoleLightEntry_t *prtConsoleLightEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, prtConsoleLightEntry_oid, sizeof(prtConsoleLightEntry_oid));
    len = pack_prtConsoleLightEntry(base, prtConsoleLightEntry->hrDeviceIndex, prtConsoleLightEntry->prtConsoleLightIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "prtConsoleLightEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 10, prtConsoleLightEntry_attr, mask, prtConsoleLightEntry);

    out = gnet_snmp_sync_set(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
printer_mib_free_prtConsoleLightEntry(printer_mib_prtConsoleLightEntry_t *prtConsoleLightEntry)
{
    GList *vbl;
    char *p;

    if (prtConsoleLightEntry) {
        p = (char *) prtConsoleLightEntry + sizeof(printer_mib_prtConsoleLightEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(prtConsoleLightEntry);
    }
}

void
printer_mib_free_prtConsoleLightTable(printer_mib_prtConsoleLightEntry_t **prtConsoleLightEntry)
{
    int i;

    if (prtConsoleLightEntry) {
        for (i = 0; prtConsoleLightEntry[i]; i++) {
            printer_mib_free_prtConsoleLightEntry(prtConsoleLightEntry[i]);
        }
        g_free(prtConsoleLightEntry);
    }
}

void
printer_mib_set_prtConsoleOnTime(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtConsoleLightIndex, gint32 prtConsoleOnTime, GError **error)
{
    printer_mib_prtConsoleLightEntry_t *prtConsoleLightEntry;

    printer_mib_get_prtConsoleLightEntry(s, &prtConsoleLightEntry, hrDeviceIndex, prtConsoleLightIndex, PRINTER_MIB_PRTCONSOLEONTIME, error);
    if (error && *error) return;
    if (s->error_status || !prtConsoleLightEntry) return;
    prtConsoleLightEntry->prtConsoleOnTime = &prtConsoleOnTime;
    printer_mib_set_prtConsoleLightEntry(s, prtConsoleLightEntry, PRINTER_MIB_PRTCONSOLEONTIME, error);
    printer_mib_free_prtConsoleLightEntry(prtConsoleLightEntry);
}

void
printer_mib_set_prtConsoleOffTime(GNetSnmp *s, gint32 hrDeviceIndex, gint32 prtConsoleLightIndex, gint32 prtConsoleOffTime, GError **error)
{
    printer_mib_prtConsoleLightEntry_t *prtConsoleLightEntry;

    printer_mib_get_prtConsoleLightEntry(s, &prtConsoleLightEntry, hrDeviceIndex, prtConsoleLightIndex, PRINTER_MIB_PRTCONSOLEOFFTIME, error);
    if (error && *error) return;
    if (s->error_status || !prtConsoleLightEntry) return;
    prtConsoleLightEntry->prtConsoleOffTime = &prtConsoleOffTime;
    printer_mib_set_prtConsoleLightEntry(s, prtConsoleLightEntry, PRINTER_MIB_PRTCONSOLEOFFTIME, error);
    printer_mib_free_prtConsoleLightEntry(prtConsoleLightEntry);
}

printer_mib_prtAlertEntry_t *
printer_mib_new_prtAlertEntry()
{
    printer_mib_prtAlertEntry_t *prtAlertEntry;

    prtAlertEntry = (printer_mib_prtAlertEntry_t *) g_malloc0(sizeof(printer_mib_prtAlertEntry_t) + sizeof(gpointer));
    return prtAlertEntry;
}

static inline int
unpack_prtAlertEntry(GNetSnmpVarBind *vb, printer_mib_prtAlertEntry_t *prtAlertEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    prtAlertEntry->hrDeviceIndex = vb->oid[idx++];
    if ((prtAlertEntry->hrDeviceIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    prtAlertEntry->prtAlertIndex = vb->oid[idx++];
    if ((prtAlertEntry->prtAlertIndex < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_prtAlertEntry(guint32 *base, gint32 hrDeviceIndex, gint32 prtAlertIndex)
{
    guint8 idx = 11;

    base[idx++] = hrDeviceIndex;
    base[idx++] = prtAlertIndex;
    return idx;
}

static inline printer_mib_prtAlertEntry_t *
assign_prtAlertEntry(GList *vbl)
{
    printer_mib_prtAlertEntry_t *prtAlertEntry;
    char *p;

    prtAlertEntry = printer_mib_new_prtAlertEntry();
    p = (char *) prtAlertEntry + sizeof(printer_mib_prtAlertEntry_t);
    * (GList **) p = vbl;

    if (unpack_prtAlertEntry((GNetSnmpVarBind *) vbl->data, prtAlertEntry) < 0) {
        g_warning("%s: invalid instance identifier", "prtAlertEntry");
        g_free(prtAlertEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, prtAlertEntry_oid, G_N_ELEMENTS(prtAlertEntry_oid),
                      prtAlertEntry_attr, prtAlertEntry);

    return prtAlertEntry;
}

void
printer_mib_get_prtAlertTable(GNetSnmp *s, printer_mib_prtAlertEntry_t ***prtAlertEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 43, 18, 1, 1, 0};
    guint32 base[128];

    *prtAlertEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, prtAlertEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *prtAlertEntry = (printer_mib_prtAlertEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(printer_mib_prtAlertEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*prtAlertEntry)[i] = assign_prtAlertEntry(row->data);
        }
    }
}

void
printer_mib_get_prtAlertEntry(GNetSnmp *s, printer_mib_prtAlertEntry_t **prtAlertEntry, gint32 hrDeviceIndex, gint32 prtAlertIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, prtAlertEntry_oid, sizeof(prtAlertEntry_oid));
    len = pack_prtAlertEntry(base, hrDeviceIndex, prtAlertIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "prtAlertEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *prtAlertEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, prtAlertEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *prtAlertEntry = assign_prtAlertEntry(out);
    }
}

void
printer_mib_free_prtAlertEntry(printer_mib_prtAlertEntry_t *prtAlertEntry)
{
    GList *vbl;
    char *p;

    if (prtAlertEntry) {
        p = (char *) prtAlertEntry + sizeof(printer_mib_prtAlertEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(prtAlertEntry);
    }
}

void
printer_mib_free_prtAlertTable(printer_mib_prtAlertEntry_t **prtAlertEntry)
{
    int i;

    if (prtAlertEntry) {
        for (i = 0; prtAlertEntry[i]; i++) {
            printer_mib_free_prtAlertEntry(prtAlertEntry[i]);
        }
        g_free(prtAlertEntry);
    }
}


