# Translations generated by Launchpad

## How to sync translations from Launchpad?
- Make sure `GOPATH` is set and `GOINVOKEFLAGS="-mod=readonly"`.
- Run `update-pot` to generate latest translation template (`po/snappy.pot`).
- Import generated translation template to [the snappy entry][templates].
- Wait until import is approved. You can monitor status in the [import queue][import-queue].
- Export [latest translations][export] (download link will be sent to your email).
- Extract archive: `tar -xvf launchpad-export.tar.gz`.
- Create new directory to store processed translations `mkdir processed`.
- Run the following to remove the `snappy-` prefix, remove obsolete `#-` messages (`--no-obsolete`) and exclude untranslated messages (`--translated`):
    - `for file in snappy-*; do msgattrib --no-obsolete --translated --output-file="processed/${file#snappy-}" "$file"; done;`
- Replace old translations under `/po` with new translations.

### Documentation:
- [Launchpad translations documentation][lp-docs].
- [How To: Manually import translation template][manual-imports].
- [How To: Request a one-off download][request-download].

[templates]: https://translations.launchpad.net/snapd/trunk/+templates
[import-queue]: https://translations.launchpad.net/snapd/trunk/+imports
[export]: https://translations.launchpad.net/snapd/trunk/+export
[lp-docs]: https://help.launchpad.net/Translations
[manual-imports]: https://help.launchpad.net/Translations/YourProject/ImportingTemplates#Manual_translation_template_imports
[request-download]: https://help.launchpad.net/Translations/YourProject/Exports#Requesting_a_one-off_download
