---
title: Students And Support
---

Please find below a list of possible work items. It includes both,
topics for long-term (3-6 months) academic theses and short-term
things/issues of which we think that they would improve SUMO.

# Master, Bachelor, or Diploma Theses

In the following, you may find ideas for student work - Bachelor,
Master, or Diploma theses. The topics you may find below are those we
are interested in and some of them are already covered by previous
scientific work. We assume them to be relevant for extending the current
state-of-the art in traffic science and information science.

In the case you are interested in one of the topics, we - the employees
of the German Aerospace Center - would accompany, review and judge your
work. Nonetheless, you will need an academic institution which will
accept your work. This means, you normally have to contact your
professor / advisor and ask him whether he will accept a topic. You
should do this before starting the work on one of the topics. One of us
will then act as the second reader/redactor and will guide you along
your work. Of course, an initial discussion between the professor /
advisor and us is wished for clarifying the work. Further regulations
and legal issues are a matter of your home university / organization.

The following list contains proposals only. If you have an own idea, you
can present it to us, too. There is also [a more verbose list of the
topics, in German](DiplomStudArb.md).

## Topics related to Traffic Science

### Pollutant Emission Modelling and Evaluation ("eco-mobility")

- Implementation and Evaluation of Pollutant Emission Models

### Traffic Lights

- Methods for Green Light District Computation
- A Methodology for Comparing Traffic Lights Algorithm

### Route Choice and Demand Modelling

- Evaluation of one-shot Traffic Assignment Approaches
- Evaluation of Gawron's Dynamic User Assignment Algorithm
- Alternate Methods for shortest-path Search in large Networks
- Ad-hoc Demand Generation
- Using Induction Loop Values for Highway Demand Generation
- Extrapolation of Routes based on Induction Loop Values

### Short-term Traffic Forecast

- Forecast of Demand Time-Lines

### Traffic Simulation Models

- Simulation Validation (should be concretized)
- Emergency Vehicle Simulation
- Using the opposite Lane for Overtaking - a Microsim Approach
- Left-Hand Traffic (includes both, work on the simulation and network
  preparation)
- Pedestrian Movement Simulation (... for the open source Traffic
  Simulation SUMO)

### V2X (vehicular communication)

- Approaches for Communication Simulation Speed-Up
- Replication of ETSI's Basic Set of Applications (BSA)
- Estimation of Travel Time using V2X Communication
- Traffic Management based on sparse Knowledge

## Topics related to Information Science

### Algorithms and theoretical Information Science

- Evaluation of the Usability of the Optimal Network Flow Algorithm
  for Demand Modelling (war: Analyse und Implementation eines
  Netzwerkflussalgorithmus zur Routenfindung)
- Evaluation of the Usability of the Quickest Flows Algorithm for
  Demand Modelling
- Matching Road Networks

### Software Engineering

- Checkstyle for c++
- Fixed point vs. Floating point
- Multi-Core Parallelisation (Simulation and Routing Modules)
- Parallelisation for Computer Clusters (Simulation and Routing
  Modules)
- SUMO-as-a-Service – SOA-based traffic simulation

### XML

- Efficient Import and Export of XML using schema-based Compression
- Modular XML

## Other

- OpenSource Marketing and Community Building

# Other Issues

In the following, you may find a list of tasks which are too
short-termed or too well-elaborated for being a part of an academic
work. They have to be done, but we could not find the time, yet, to work
on them honestly. If you have some spare time, it would be very nice if
you would invest it in one of them. Please contact us then for further
details.

Also, some of the items are assumed to be a good base for short-term
student topics, within seminars, or programming / software engineering
courses. Evaluating models could for instance be done by a set of
students, assigning one model per student, and the same would for
example also count for routing algorithms. Extending the test suites
would be a nice programming course topic, too.

## Documentation

- Converting our wiki-pages into PDFs
- Ideas/Designs for a documentation
- Improved search
- XML schemata for files
- a data catalogue for SUMO files

## Validation

- using real-world data (rather a topic for a seminar)
- using traffic engineering handbooks (rather a topic for a seminar)

## Models

- lane-change models evaluation (rather a topic for a seminar)
- car-following models evaluation (rather a topic for a seminar)

## Routing

- multi-criteria-routing (pareto-routing)
- high-performance-routing (Hub-Labeling etc.)
- state-of-the-art public transport routing (RAPTOR, Transfer Patterns, etc)

## Interoperability

- interoperability with other publicly available tools

## Tests

- Extend the unit-test - suite (would be a nice practical work for an
  according software engineering seminar)
- Extend the texttest - suite (would be a nice practical work for an
  according software engineering seminar)