[comment {-*- tcl -*- doctools manpage}]
[manpage_begin tcl::transform::core n 1.1]
[keywords {reflected channel}]
[keywords {tip 219}]
[keywords {virtual channel}]
[copyright {2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Reflected/virtual channel support}]
[category  Channels]
[titledesc {Basic reflected/virtual channel transform support}]
[require Tcl "8.5 9"]
[require TclOO]
[require tcl::transform::core [opt 1.1]]
[description]
[para]

The [package tcl::transform::core] package provides a [package TclOO]
class implementing common behaviour needed by virtually every
reflected or virtual channel transformation (initialization, finalization).

[para] This class expects to be used as either superclass of a concrete
channel class, or to be mixed into such a class.

[section {Class API}]

[list_begin definitions]

[call [cmd ::tcl::transform::core] [arg objectName]]

This command creates a new transform core object with an associated
global Tcl command whose name is [emph objectName]. This command may
be used to invoke various operations on the object, as described in
the section for the [sectref {Instance API}].

[list_end]

[section {Instance API}]

The API of transform core instances provides only two methods, both
corresponding to transform handler commands (For reference see
[uri http:/tip.tcl.tk/230 {TIP 230}]). They expect to be called
from whichever object instance the transform core was made a part of.

[list_begin definitions]

[call [arg objectName] [method initialize] [arg thechannel] [arg mode]]

This method implements standard behaviour for the [method initialize]
method of transform handlers. Using introspection it finds the handler
methods supported by the instance and returns a list containing their
names, as expected by the support for reflected transformation in the
Tcl core.

[para] It further remembers the channel handle in an instance variable
for access by sub-classes.

[call [arg objectName] [method finalize] [arg thechannel]]

This method implements standard behaviour for the [method finalize]
method of channel handlers. It simply destroys itself.

[call [arg objectName] [method destroy]]

Destroying the transform core instance closes the channel and transform
it was initialized for, see the method [method initialize]. When destroyed
from within a call of [method finalize] this does not happen, under
the assumption that the channel and transform are being destroyed by Tcl.

[list_end]

[vset CATEGORY virtchannel]
[include ../common-text/feedback.inc]
[manpage_end]
