# AutoGraph reference

This reference document describes the semantics of AutoGraph transformations.

In `@tf.function`, AutoGraph allows running Eager-style code as a TensorFlow
graph.

*   [Introduction](intro.md)
*   [Interacting with the generated code](generated_code.md)
*   [Debugging AutoGraph code](debugging.md)
*   [Control flow](control_flow.md)
*   [Functions and function calls](functions.md)
*   [Error handling](error_handling.md)
*   [Operator semantics](operators.md)
*   [Limitations](limitations.md)
*   [Common errors](common_errors.md)

Also see:

*   [AutoGraph blog post](https://medium.com/tensorflow/autograph-converts-python-into-tensorflow-graphs-b2a871f87ec7)
*   [AutoGraph deep dive](https://www.youtube.com/watch?v=NIEgzljyDyI)
*   [tf.function guide](https://www.tensorflow.org/guide/function)
*   [Intro to TF graphs](https://www.tensorflow.org/guide/intro_to_graphs)
