## TFSA-2020-034: Heap out of bounds access in MakeEdge

### CVE Number
CVE-2020-26271

### Impact
Under certain cases, loading a saved model can result in accessing uninitialized
memory while building the computation graph. The [`MakeEdge`
function](https://github.com/tensorflow/tensorflow/blob/3616708cb866365301d8e67b43b32b46d94b08a0/tensorflow/core/common_runtime/graph_constructor.cc#L1426-L1438)
creates an edge between one output tensor of the `src` node (given by
`output_index`) and the input slot of the `dst` node (given by `input_index`).
This is only possible if the types of the tensors on both sides coincide, so the
function begins by obtaining the corresponding `DataType` values and comparing
these for equality:

```cc
  DataType src_out = src->output_type(output_index);
  DataType dst_in = dst->input_type(input_index);
  //...
```

However, there is no check that the indices point to inside of the arrays they
index into. Thus, this can result in accessing data out of bounds of the
corresponding heap allocated arrays.

In most scenarios, this can manifest as unitialized data access, but if the
index points far away from the boundaries of the arrays this can be used to leak
addresses from the library.

### Patches

We have patched the issue in GitHub commit
[0cc38aaa4064fd9e79101994ce9872c6d91f816b](https://github.com/tensorflow/tensorflow/commit/0cc38aaa4064fd9e79101994ce9872c6d91f816b)
and will release TensorFlow 2.4.0 containing the patch. TensorFlow nightly
packages after this commit will also have the issue resolved.

Since this issue also impacts TF versions before 2.4, we will patch all releases
between 1.15 and 2.3 inclusive.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.
