## TFSA-2021-114: Integer division by 0 in sparse reshaping

### CVE Number
CVE-2021-37640

### Impact
The implementation of `tf.raw_ops.SparseReshape` can be made to trigger an
integral division by 0 exception:

```python
import tensorflow as tf

tf.raw_ops.SparseReshape(
  input_indices = np.ones((1,3)),
  input_shape = np.array([1,1,0]),
  new_shape = np.array([1,0]))
```

The
[implementation](https://github.com/tensorflow/tensorflow/blob/8d72537c6abf5a44103b57b9c2e22c14f5f49698/tensorflow/core/kernels/reshape_util.cc#L176-L181)
calls the reshaping functor whenever there is at least an index in the input but
does not check that shape of the input or the target shape have both a non-zero
number of elements.

The [reshape
functor](https://github.com/tensorflow/tensorflow/blob/8d72537c6abf5a44103b57b9c2e22c14f5f49698/tensorflow/core/kernels/reshape_util.cc#L40-L78)
blindly divides by the dimensions of the target shape. Hence, if this is not
checked, code will result in a division by 0.

### Patches
We have patched the issue in GitHub commit
[4923de56ec94fff7770df259ab7f2288a74feb41](https://github.com/tensorflow/tensorflow/commit/4923de56ec94fff7770df259ab7f2288a74feb41).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1 as this is the other affected version.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
