#!/bin/bash

function MueLuGenerateCmakeFile() {
  # $1 : the classList file                        e.g., SC-LO-GO-NO.classList
  # $2 : cmake variable for list of classes        e.g., MUELU_SC_LO_GO_NO_ETI_CLASSES
  # $3 : name cmake file to be generated           e.g., ETI_SC_LO_GO_NO_classes.cmake

  # internal field separator to figure out where to split words
  IFS=$'\n'

  classListDir="../ClassList/"
  classListFile=$classListDir/$1
  cmakeVariable=$2
  cmakeFile=$3

  rm -Rf $cmakeFile

  echo "# This file is automatically generated by muelu/src/Utils/ExplicitInstantiation/genClassLists.sh" > $cmakeFile
  for className in `cat $classListFile | egrep -v "^\#" | sed 's/ //'`
    do

    if ! grep -q -x $className $classListDir/EI-Exceptions.classList
        then

        printClassName=$(echo $className | sed 's/ /./g' | sed 's/#/?/g' | sed 's/(/[/g' | sed 's/)/]/g')
        echo "APPEND_SET($cmakeVariable MueLu::$printClassName )" >> $cmakeFile

    fi

  done

} # end of function MueLuGenerateCmakeFile()


MueLuGenerateCmakeFile "LO-GO-NO.classList"                "MUELU_LO_GO_NO_ETI_CLASSES"                "ETI_LO_GO_NO_classes.cmake"
MueLuGenerateCmakeFile "SC-LO-GO-NO.classList"             "MUELU_SC_LO_GO_NO_ETI_CLASSES"             "ETI_SC_LO_GO_NO_classes.cmake"
