/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#include "defaultappui.h"

DefaultAppUi::DefaultAppUi(QWidget *parent) : QWidget(parent)
{
    setAttribute(Qt::WA_DeleteOnClose);
    initUi();
}

void DefaultAppUi::initUi()
{
    QVBoxLayout *vLyt = new QVBoxLayout(this);
    vLyt->setSpacing(8);
    vLyt->setContentsMargins(0, 0, 0, 0);

    TitleLabel *mTitleLabel = new TitleLabel(this);
    mTitleLabel->setText(tr("DefaultAppWindow", "Select Default Application"));
    SettingGroup *mDefaultFrame = new SettingGroup(this);

    mBrowserFrame = new ComboxWidget(tr("Browser"));
    mMailFrame = new ComboxWidget(tr("Mail"));
    mImageFrame = new ComboxWidget(tr("Image Viewer"));
    mAudioFrame = new ComboxWidget(tr("Audio Player"));
    mVideoFrame = new ComboxWidget(tr("Video Player"));
    mTextFrame = new ComboxWidget(tr("Text Editor"));

    // 恢复默认
    mResetFrame = new PushButtonWidget(tr("Reset default apps to system recommended apps"));
    mResetFrame->setButtonText(tr("Reset"));

    mDefaultFrame->addWidget(mBrowserFrame);
    mDefaultFrame->addWidget(mMailFrame);
    mDefaultFrame->addWidget(mImageFrame);
    mDefaultFrame->addWidget(mAudioFrame);
    mDefaultFrame->addWidget(mVideoFrame);
    mDefaultFrame->addWidget(mTextFrame);
    mDefaultFrame->addWidget(mResetFrame);

    vLyt->addWidget(mTitleLabel);
    vLyt->addWidget(mDefaultFrame);
    vLyt->addStretch();
}
