/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.opensolaris.os.dtrace.Aggregation;
import org.opensolaris.os.dtrace.AggregationRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Aggregate
implements Serializable {
    static final long serialVersionUID = 3180340417154076628L;
    private final long snaptime;
    private transient Map<String, Aggregation> map;
    private transient int recordSequence;

    private Aggregate(long snaptimeNanos) {
        this.snaptime = snaptimeNanos;
        this.map = new HashMap<String, Aggregation>();
    }

    public Aggregate(long snaptimeNanos, Collection<Aggregation> aggregations) {
        this.snaptime = snaptimeNanos;
        this.mapAggregations(aggregations);
        this.validate();
    }

    private void mapAggregations(Collection<Aggregation> aggregations) {
        int capacity = (int)((float)aggregations.size() * 3.0f / 2.0f);
        this.map = new HashMap<String, Aggregation>(capacity, 1.0f);
        for (Aggregation a : aggregations) {
            this.map.put(a.getName(), a);
            this.recordSequence += a.asMap().size();
        }
    }

    private void validate() {
        int capacity = (int)((float)this.recordSequence * 3.0f / 2.0f);
        HashSet<Integer> ordinals = new HashSet<Integer>(capacity, 1.0f);
        int max = 0;
        for (Aggregation a : this.map.values()) {
            for (AggregationRecord r : a.asMap().values()) {
                int ordinal = r.getOrdinal();
                if (!ordinals.add(ordinal) && ordinal > 0) {
                    throw new IllegalArgumentException("duplicate record ordinal: " + ordinal);
                }
                if (ordinal <= max) continue;
                max = ordinal;
            }
        }
        if (max > 0 && max != this.recordSequence - 1) {
            throw new IllegalArgumentException("The maximum record ordinal (" + max + ") does not " + "equal the number of records (" + this.recordSequence + ") minus one.");
        }
    }

    public long getSnaptime() {
        return this.snaptime;
    }

    public List<Aggregation> getAggregations() {
        ArrayList<Aggregation> list = new ArrayList<Aggregation>(this.map.size());
        list.addAll(this.map.values());
        return list;
    }

    public Aggregation getAggregation(String name) {
        name = Aggregate.filterUnnamedAggregationName(name);
        return this.map.get(name);
    }

    public List<AggregationRecord> getRecords() {
        ArrayList<AggregationRecord> list = new ArrayList<AggregationRecord>(this.recordSequence);
        for (Aggregation a : this.map.values()) {
            list.addAll(a.asMap().values());
        }
        return list;
    }

    public List<AggregationRecord> getOrderedRecords() {
        List<AggregationRecord> list = this.getRecords();
        Collections.sort(list, new Comparator<AggregationRecord>(){

            @Override
            public int compare(AggregationRecord r1, AggregationRecord r2) {
                int n2;
                int n1 = r1.getOrdinal();
                return n1 < (n2 = r2.getOrdinal()) ? -1 : (n1 > n2 ? 1 : 0);
            }
        });
        return list;
    }

    static String filterUnnamedAggregationName(String name) {
        if (name != null && name.equals("_")) {
            return "";
        }
        return name;
    }

    public Map<String, Aggregation> asMap() {
        return Collections.unmodifiableMap(this.map);
    }

    private void addRecord(String aggregationName, long aggid, AggregationRecord rec) {
        rec.setOrdinal(this.recordSequence++);
        aggregationName = Aggregate.filterUnnamedAggregationName(aggregationName);
        Aggregation aggregation = this.getAggregation(aggregationName);
        if (aggregation == null) {
            aggregation = new Aggregation(aggregationName, aggid);
            this.map.put(aggregationName, aggregation);
        }
        aggregation.addRecord(rec);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.getAggregations());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        List aggregations = (List)s.readObject();
        this.mapAggregations(aggregations);
        try {
            this.validate();
        }
        catch (Exception e) {
            InvalidObjectException x = new InvalidObjectException(e.getMessage());
            x.initCause(e);
            throw x;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(Aggregate.class.getName());
        buf.append("[snaptime = ");
        buf.append(this.snaptime);
        buf.append(", aggregations = ");
        List<Aggregation> a = this.getAggregations();
        Collections.sort(a, new Comparator<Aggregation>(){

            @Override
            public int compare(Aggregation a1, Aggregation a2) {
                return a1.getName().compareTo(a2.getName());
            }
        });
        buf.append(Arrays.toString(a.toArray()));
        buf.append(']');
        return buf.toString();
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(Aggregate.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"snaptime", "aggregations"});
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            System.out.println(e);
        }
    }
}

