/*
 * Decompiled with CFR 0.152.
 */
package spec.jbb;

import java.lang.reflect.Constructor;
import java.util.logging.Level;
import spec.jbb.Company;
import spec.jbb.JBButil;

abstract class Transaction {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,(C) Copyright IBM Corp., 1996 - 2005All rights reserved,Licensed Materials - Property of SPEC";
    protected static final byte new_order = 0;
    protected static final byte payment = 1;
    protected static final byte order_status = 2;
    protected static final byte delivery = 3;
    protected static final byte stock_level = 4;
    protected static final byte cust_report = 5;
    public static int aveOrderlines = 10;
    public static int minOrderlines = aveOrderlines - 5;
    public static int maxOrderlines = aveOrderlines + 5;
    static boolean enableLogWrite = false;
    static boolean steadyStateMem = true;
    static boolean validationFlag = false;
    private static boolean validRun = true;
    static String[] transactionNames = new String[]{"NewOrder", "Payment", "OrderStatus", "Delivery", "StockLevel", "CustomerReport"};
    protected static final byte maxTxnTypes = (byte)transactionNames.length;
    static Class[] transactionClasses = new Class[maxTxnTypes];
    static Class[] transactionConstructorSignature;

    Transaction() {
    }

    public abstract String getMenuName();

    public abstract void init();

    public abstract boolean process();

    public abstract void initializeTransactionLog();

    public abstract void processTransactionLog();

    public static void invalidateRun() {
        validRun = false;
    }

    public static void validateRun() {
        validRun = true;
    }

    public static boolean isRunValid() {
        return validRun;
    }

    public static void setOrderLineCount(int n) {
        aveOrderlines = n;
        minOrderlines = aveOrderlines - 5;
        maxOrderlines = aveOrderlines + 5;
    }

    public static void setSteadyState(boolean bl) {
        steadyStateMem = bl;
    }

    public static void setLogWrite(boolean bl) {
        enableLogWrite = bl;
    }

    public static void setValidation(boolean bl) {
        validationFlag = bl;
    }

    static Transaction getInstance(Class clazz, Company company, short s) {
        Transaction transaction = null;
        try {
            Constructor constructor = clazz.getConstructor(transactionConstructorSignature);
            Object[] objectArray = new Object[]{company, new Short(s)};
            transaction = (Transaction)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            JBButil.getLog().log(Level.WARNING, "Exception: " + exception.getMessage(), exception);
        }
        return transaction;
    }

    static {
        for (int i = 0; i < maxTxnTypes; ++i) {
            try {
                Transaction.transactionClasses[i] = Class.forName("spec.jbb." + transactionNames[i] + "Transaction");
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("Transaction.transactionClasses - ClassNotFoundException");
            }
        }
        transactionConstructorSignature = new Class[]{Company.class, Short.TYPE};
    }
}

