/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.xmlschema;

import com.sun.tools.xjc.model.CAdapter;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CElement;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.model.CElementPropertyInfo;
import com.sun.tools.xjc.model.CReferencePropertyInfo;
import com.sun.tools.xjc.model.CTypeRef;
import com.sun.tools.xjc.model.Multiplicity;
import com.sun.tools.xjc.reader.RawTypeSet;
import com.sun.tools.xjc.reader.Ring;
import com.sun.tools.xjc.reader.xmlschema.BGMBuilder;
import com.sun.tools.xjc.reader.xmlschema.ClassSelector;
import com.sun.tools.xjc.reader.xmlschema.MultiplicityCounter;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIDom;
import com.sun.xml.bind.v2.model.core.ID;
import com.sun.xml.bind.v2.model.core.WildcardMode;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSWildcard;
import com.sun.xml.xsom.visitor.XSTermVisitor;
import java.util.HashSet;
import java.util.Set;
import javax.activation.MimeType;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawTypeSetBuilder
implements XSTermVisitor {
    private final Set<QName> elementNames = new HashSet<QName>();
    private final Set<RawTypeSet.Ref> refs = new HashSet<RawTypeSet.Ref>();
    protected final BGMBuilder builder = Ring.get(BGMBuilder.class);

    public static RawTypeSet build(XSParticle p, boolean optional) {
        RawTypeSetBuilder rtsb = new RawTypeSetBuilder();
        rtsb.particle(p);
        Multiplicity mul = MultiplicityCounter.theInstance.particle(p);
        if (optional) {
            mul = mul.makeOptional();
        }
        return new RawTypeSet(rtsb.refs, mul);
    }

    public Set<RawTypeSet.Ref> getRefs() {
        return this.refs;
    }

    private void particle(XSParticle p) {
        BIDom dom = this.builder.getLocalDomCustomization(p);
        if (dom != null) {
            dom.markAsAcknowledged();
            this.refs.add(new WildcardRef(WildcardMode.SKIP));
        } else {
            p.getTerm().visit(this);
        }
    }

    @Override
    public void wildcard(XSWildcard wc) {
        this.refs.add(new WildcardRef(wc));
    }

    @Override
    public void modelGroupDecl(XSModelGroupDecl decl) {
        this.modelGroup(decl.getModelGroup());
    }

    @Override
    public void modelGroup(XSModelGroup group2) {
        for (XSParticle p : group2.getChildren()) {
            this.particle(p);
        }
    }

    @Override
    public void elementDecl(XSElementDecl decl) {
        QName n = new QName(decl.getTargetNamespace(), decl.getName());
        if (this.elementNames.add(n)) {
            CElement elementBean = Ring.get(ClassSelector.class).bindToType(decl);
            if (elementBean == null) {
                this.refs.add(new RawTypeSet.XmlTypeRef(decl));
            } else if (elementBean instanceof CClassInfo) {
                this.refs.add(new CClassInfoRef(decl, (CClassInfo)elementBean));
            } else {
                this.refs.add(new CElementInfoRef(decl, (CElementInfo)elementBean));
            }
        }
    }

    public static final class CElementInfoRef
    extends RawTypeSet.Ref {
        public final CElementInfo target;
        public final XSElementDecl decl;

        CElementInfoRef(XSElementDecl decl, CElementInfo target) {
            this.decl = decl;
            this.target = target;
        }

        protected CTypeRef toTypeRef(CElementPropertyInfo ep) {
            assert (!this.target.isCollection());
            CAdapter a = this.target.getProperty().getAdapter();
            if (a != null && ep != null) {
                ep.setAdapter(a);
            }
            return new CTypeRef(this.target.getContentType(), this.target.getElementName(), this.decl.isNillable(), this.decl.getDefaultValue());
        }

        protected void toElementRef(CReferencePropertyInfo prop) {
            prop.getElements().add(this.target);
        }

        protected RawTypeSet.Mode canBeType(RawTypeSet parent) {
            if (this.decl.getSubstitutables().size() > 1) {
                return RawTypeSet.Mode.MUST_BE_REFERENCE;
            }
            CElementPropertyInfo p = this.target.getProperty();
            if (!(parent.refs.size() <= 1 && parent.mul.isAtMostOnce() || p.getAdapter() == null && p.id() == ID.NONE)) {
                return RawTypeSet.Mode.MUST_BE_REFERENCE;
            }
            return RawTypeSet.Mode.SHOULD_BE_TYPEREF;
        }

        protected boolean isListOfValues() {
            return this.target.getProperty().isValueList();
        }

        protected ID id() {
            return this.target.getProperty().id();
        }

        protected MimeType getExpectedMimeType() {
            return this.target.getProperty().getExpectedMimeType();
        }
    }

    public static final class CClassInfoRef
    extends RawTypeSet.Ref {
        public final CClassInfo target;
        public final XSElementDecl decl;

        CClassInfoRef(XSElementDecl decl, CClassInfo target) {
            this.decl = decl;
            this.target = target;
        }

        protected CTypeRef toTypeRef(CElementPropertyInfo ep) {
            return new CTypeRef(this.target, this.target.getElementName(), this.decl.isNillable(), this.decl.getDefaultValue());
        }

        protected void toElementRef(CReferencePropertyInfo prop) {
            prop.getElements().add(this.target);
        }

        protected RawTypeSet.Mode canBeType(RawTypeSet parent) {
            if (this.decl.getSubstitutables().size() > 1) {
                return RawTypeSet.Mode.MUST_BE_REFERENCE;
            }
            return RawTypeSet.Mode.SHOULD_BE_TYPEREF;
        }

        protected boolean isListOfValues() {
            return false;
        }

        protected ID id() {
            return ID.NONE;
        }
    }

    public static final class WildcardRef
    extends RawTypeSet.Ref {
        private final WildcardMode mode;

        WildcardRef(XSWildcard wildcard) {
            this.mode = WildcardRef.getMode(wildcard);
        }

        WildcardRef(WildcardMode mode) {
            this.mode = mode;
        }

        private static WildcardMode getMode(XSWildcard wildcard) {
            switch (wildcard.getMode()) {
                case 1: {
                    return WildcardMode.LAX;
                }
                case 2: {
                    return WildcardMode.STRICT;
                }
                case 3: {
                    return WildcardMode.SKIP;
                }
            }
            throw new IllegalStateException();
        }

        protected CTypeRef toTypeRef(CElementPropertyInfo ep) {
            throw new IllegalStateException();
        }

        protected void toElementRef(CReferencePropertyInfo prop) {
            prop.setWildcard(this.mode);
        }

        protected RawTypeSet.Mode canBeType(RawTypeSet parent) {
            return RawTypeSet.Mode.MUST_BE_REFERENCE;
        }

        protected boolean isListOfValues() {
            return false;
        }

        protected ID id() {
            return ID.NONE;
        }
    }
}

