/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.opensolaris.os.dtrace.ProbeData;
import org.opensolaris.os.dtrace.ScalarRecord;
import org.opensolaris.os.dtrace.ValueRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Tuple
implements Serializable,
Comparable<Tuple>,
Iterable<ValueRecord> {
    static final long serialVersionUID = 5192674716869462720L;
    public static final Tuple EMPTY = new Tuple();
    private List<ValueRecord> elements = new ArrayList<ValueRecord>(4);

    private Tuple() {
    }

    public Tuple(ValueRecord ... tupleElements) {
        this();
        if (tupleElements == null) {
            throw new NullPointerException("null array");
        }
        for (ValueRecord r : tupleElements) {
            if (r == null) {
                throw new NullPointerException("null element");
            }
            this.elements.add(r);
        }
    }

    public Tuple(List<ValueRecord> tupleElements) {
        this();
        if (tupleElements == null) {
            throw new NullPointerException("element list is null");
        }
        for (ValueRecord r : tupleElements) {
            if (r == null) {
                throw new NullPointerException("null element");
            }
            this.elements.add(r);
        }
    }

    private void addElement(ValueRecord element) {
        if (element == null) {
            throw new NullPointerException("tuple element is null at index " + this.elements.size());
        }
        this.elements.add(element);
    }

    public List<ValueRecord> getElements() {
        return new ArrayList<ValueRecord>(this.elements);
    }

    public List<ValueRecord> asList() {
        return Collections.unmodifiableList(this.elements);
    }

    public int size() {
        return this.elements.size();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public ValueRecord get(int index) {
        return this.elements.get(index);
    }

    @Override
    public Iterator<ValueRecord> iterator() {
        return this.elements.iterator();
    }

    public boolean equals(Object o) {
        if (o instanceof Tuple) {
            Tuple t = (Tuple)o;
            return ((Object)this.elements).equals(t.elements);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.elements).hashCode();
    }

    private static int compareObjects(Object o1, Object o2) {
        int cmp;
        if (o1 instanceof Comparable) {
            Class<?> c2;
            Class<?> c1 = o1.getClass();
            if (c1.equals(c2 = o2.getClass())) {
                cmp = ProbeData.compareUnsigned((Comparable)Comparable.class.cast(o1), (Comparable)Comparable.class.cast(o2));
            } else {
                String s1 = o1.toString();
                String s2 = o2.toString();
                cmp = s1.compareTo(s2);
            }
        } else if (o1 instanceof byte[] && o2 instanceof byte[]) {
            byte[] a1 = (byte[])byte[].class.cast(o1);
            byte[] a2 = (byte[])byte[].class.cast(o2);
            cmp = ProbeData.compareByteArrays(a1, a2);
        } else {
            String s1 = o1.toString();
            String s2 = o2.toString();
            cmp = s1.compareTo(s2);
        }
        return cmp;
    }

    @Override
    public int compareTo(Tuple t) {
        int cmp = 0;
        int len = this.size();
        int tlen = t.size();
        for (int i = 0; cmp == 0 && i < len && i < tlen; ++i) {
            cmp = Tuple.compare(this, t, i);
        }
        if (cmp == 0) {
            cmp = len < tlen ? -1 : (len > tlen ? 1 : 0);
        }
        return cmp;
    }

    public static int compare(Tuple t1, Tuple t2, int pos) {
        int cmp = 0;
        ValueRecord rec1 = t1.get(pos);
        ValueRecord rec2 = t2.get(pos);
        Object val1 = rec1 instanceof ScalarRecord ? rec1.getValue() : rec1;
        Object val2 = rec2 instanceof ScalarRecord ? rec2.getValue() : rec2;
        cmp = Tuple.compareObjects(val1, val2);
        return cmp;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.elements == null) {
            throw new InvalidObjectException("element list is null");
        }
        ArrayList<ValueRecord> copy = new ArrayList<ValueRecord>(this.elements.size());
        copy.addAll(this.elements);
        this.elements = copy;
        for (ValueRecord e : this.elements) {
            if (e != null) continue;
            throw new InvalidObjectException("null element");
        }
    }

    public String toString() {
        return this.elements.toString();
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(Tuple.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"elements"}){

                protected boolean mutatesTo(Object oldInstance, Object newInstance) {
                    return newInstance != null && oldInstance != null && oldInstance.getClass() == newInstance.getClass();
                }
            };
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            System.out.println(e);
        }
    }
}

