// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_ASSEMBLER_COND_RD_RN_RM_SMUADX_A32_H_
#define VIXL_ASSEMBLER_COND_RD_RN_RM_SMUADX_A32_H_

const byte kInstruction_smuadx_hi_r1_r9_r5[] = {
  0x39, 0xf5, 0x01, 0x87 // smuadx hi r1 r9 r5
};
const byte kInstruction_smuadx_pl_r8_r6_r2[] = {
  0x36, 0xf2, 0x08, 0x57 // smuadx pl r8 r6 r2
};
const byte kInstruction_smuadx_hi_r5_r8_r2[] = {
  0x38, 0xf2, 0x05, 0x87 // smuadx hi r5 r8 r2
};
const byte kInstruction_smuadx_vc_r9_r2_r7[] = {
  0x32, 0xf7, 0x09, 0x77 // smuadx vc r9 r2 r7
};
const byte kInstruction_smuadx_lt_r4_r6_r3[] = {
  0x36, 0xf3, 0x04, 0xb7 // smuadx lt r4 r6 r3
};
const byte kInstruction_smuadx_le_r11_r6_r2[] = {
  0x36, 0xf2, 0x0b, 0xd7 // smuadx le r11 r6 r2
};
const byte kInstruction_smuadx_cc_r8_r14_r4[] = {
  0x3e, 0xf4, 0x08, 0x37 // smuadx cc r8 r14 r4
};
const byte kInstruction_smuadx_le_r5_r14_r6[] = {
  0x3e, 0xf6, 0x05, 0xd7 // smuadx le r5 r14 r6
};
const byte kInstruction_smuadx_lt_r6_r1_r0[] = {
  0x31, 0xf0, 0x06, 0xb7 // smuadx lt r6 r1 r0
};
const byte kInstruction_smuadx_lt_r5_r0_r9[] = {
  0x30, 0xf9, 0x05, 0xb7 // smuadx lt r5 r0 r9
};
const byte kInstruction_smuadx_le_r8_r12_r7[] = {
  0x3c, 0xf7, 0x08, 0xd7 // smuadx le r8 r12 r7
};
const byte kInstruction_smuadx_eq_r7_r14_r6[] = {
  0x3e, 0xf6, 0x07, 0x07 // smuadx eq r7 r14 r6
};
const byte kInstruction_smuadx_cs_r7_r4_r6[] = {
  0x34, 0xf6, 0x07, 0x27 // smuadx cs r7 r4 r6
};
const byte kInstruction_smuadx_gt_r9_r6_r9[] = {
  0x36, 0xf9, 0x09, 0xc7 // smuadx gt r9 r6 r9
};
const byte kInstruction_smuadx_ne_r13_r9_r1[] = {
  0x39, 0xf1, 0x0d, 0x17 // smuadx ne r13 r9 r1
};
const byte kInstruction_smuadx_ge_r13_r1_r13[] = {
  0x31, 0xfd, 0x0d, 0xa7 // smuadx ge r13 r1 r13
};
const byte kInstruction_smuadx_ls_r8_r10_r2[] = {
  0x3a, 0xf2, 0x08, 0x97 // smuadx ls r8 r10 r2
};
const byte kInstruction_smuadx_hi_r0_r13_r5[] = {
  0x3d, 0xf5, 0x00, 0x87 // smuadx hi r0 r13 r5
};
const byte kInstruction_smuadx_pl_r13_r7_r8[] = {
  0x37, 0xf8, 0x0d, 0x57 // smuadx pl r13 r7 r8
};
const byte kInstruction_smuadx_ge_r4_r13_r11[] = {
  0x3d, 0xfb, 0x04, 0xa7 // smuadx ge r4 r13 r11
};
const byte kInstruction_smuadx_cs_r5_r10_r5[] = {
  0x3a, 0xf5, 0x05, 0x27 // smuadx cs r5 r10 r5
};
const byte kInstruction_smuadx_cs_r5_r4_r3[] = {
  0x34, 0xf3, 0x05, 0x27 // smuadx cs r5 r4 r3
};
const byte kInstruction_smuadx_ls_r6_r14_r8[] = {
  0x3e, 0xf8, 0x06, 0x97 // smuadx ls r6 r14 r8
};
const byte kInstruction_smuadx_vs_r3_r8_r6[] = {
  0x38, 0xf6, 0x03, 0x67 // smuadx vs r3 r8 r6
};
const byte kInstruction_smuadx_vc_r7_r12_r3[] = {
  0x3c, 0xf3, 0x07, 0x77 // smuadx vc r7 r12 r3
};
const byte kInstruction_smuadx_ge_r1_r4_r1[] = {
  0x34, 0xf1, 0x01, 0xa7 // smuadx ge r1 r4 r1
};
const byte kInstruction_smuadx_cc_r4_r7_r10[] = {
  0x37, 0xfa, 0x04, 0x37 // smuadx cc r4 r7 r10
};
const byte kInstruction_smuadx_cc_r2_r0_r13[] = {
  0x30, 0xfd, 0x02, 0x37 // smuadx cc r2 r0 r13
};
const byte kInstruction_smuadx_vs_r9_r6_r8[] = {
  0x36, 0xf8, 0x09, 0x67 // smuadx vs r9 r6 r8
};
const byte kInstruction_smuadx_cs_r14_r11_r13[] = {
  0x3b, 0xfd, 0x0e, 0x27 // smuadx cs r14 r11 r13
};
const byte kInstruction_smuadx_pl_r5_r8_r4[] = {
  0x38, 0xf4, 0x05, 0x57 // smuadx pl r5 r8 r4
};
const byte kInstruction_smuadx_pl_r2_r3_r7[] = {
  0x33, 0xf7, 0x02, 0x57 // smuadx pl r2 r3 r7
};
const byte kInstruction_smuadx_cs_r7_r12_r14[] = {
  0x3c, 0xfe, 0x07, 0x27 // smuadx cs r7 r12 r14
};
const byte kInstruction_smuadx_hi_r6_r6_r1[] = {
  0x36, 0xf1, 0x06, 0x87 // smuadx hi r6 r6 r1
};
const byte kInstruction_smuadx_cc_r6_r9_r6[] = {
  0x39, 0xf6, 0x06, 0x37 // smuadx cc r6 r9 r6
};
const byte kInstruction_smuadx_ne_r12_r12_r0[] = {
  0x3c, 0xf0, 0x0c, 0x17 // smuadx ne r12 r12 r0
};
const byte kInstruction_smuadx_cc_r9_r3_r8[] = {
  0x33, 0xf8, 0x09, 0x37 // smuadx cc r9 r3 r8
};
const byte kInstruction_smuadx_mi_r13_r6_r1[] = {
  0x36, 0xf1, 0x0d, 0x47 // smuadx mi r13 r6 r1
};
const byte kInstruction_smuadx_lt_r4_r8_r6[] = {
  0x38, 0xf6, 0x04, 0xb7 // smuadx lt r4 r8 r6
};
const byte kInstruction_smuadx_hi_r11_r5_r9[] = {
  0x35, 0xf9, 0x0b, 0x87 // smuadx hi r11 r5 r9
};
const byte kInstruction_smuadx_cc_r6_r10_r6[] = {
  0x3a, 0xf6, 0x06, 0x37 // smuadx cc r6 r10 r6
};
const byte kInstruction_smuadx_eq_r10_r10_r5[] = {
  0x3a, 0xf5, 0x0a, 0x07 // smuadx eq r10 r10 r5
};
const byte kInstruction_smuadx_al_r5_r4_r11[] = {
  0x34, 0xfb, 0x05, 0xe7 // smuadx al r5 r4 r11
};
const byte kInstruction_smuadx_pl_r11_r11_r2[] = {
  0x3b, 0xf2, 0x0b, 0x57 // smuadx pl r11 r11 r2
};
const byte kInstruction_smuadx_ls_r6_r14_r12[] = {
  0x3e, 0xfc, 0x06, 0x97 // smuadx ls r6 r14 r12
};
const byte kInstruction_smuadx_vc_r7_r7_r2[] = {
  0x37, 0xf2, 0x07, 0x77 // smuadx vc r7 r7 r2
};
const byte kInstruction_smuadx_eq_r10_r8_r4[] = {
  0x38, 0xf4, 0x0a, 0x07 // smuadx eq r10 r8 r4
};
const byte kInstruction_smuadx_al_r14_r7_r2[] = {
  0x37, 0xf2, 0x0e, 0xe7 // smuadx al r14 r7 r2
};
const byte kInstruction_smuadx_cs_r3_r11_r10[] = {
  0x3b, 0xfa, 0x03, 0x27 // smuadx cs r3 r11 r10
};
const byte kInstruction_smuadx_ls_r11_r4_r0[] = {
  0x34, 0xf0, 0x0b, 0x97 // smuadx ls r11 r4 r0
};
const byte kInstruction_smuadx_hi_r11_r8_r9[] = {
  0x38, 0xf9, 0x0b, 0x87 // smuadx hi r11 r8 r9
};
const byte kInstruction_smuadx_vs_r2_r14_r13[] = {
  0x3e, 0xfd, 0x02, 0x67 // smuadx vs r2 r14 r13
};
const byte kInstruction_smuadx_al_r1_r13_r9[] = {
  0x3d, 0xf9, 0x01, 0xe7 // smuadx al r1 r13 r9
};
const byte kInstruction_smuadx_eq_r3_r9_r13[] = {
  0x39, 0xfd, 0x03, 0x07 // smuadx eq r3 r9 r13
};
const byte kInstruction_smuadx_ge_r10_r3_r13[] = {
  0x33, 0xfd, 0x0a, 0xa7 // smuadx ge r10 r3 r13
};
const byte kInstruction_smuadx_pl_r8_r5_r10[] = {
  0x35, 0xfa, 0x08, 0x57 // smuadx pl r8 r5 r10
};
const byte kInstruction_smuadx_vc_r8_r11_r6[] = {
  0x3b, 0xf6, 0x08, 0x77 // smuadx vc r8 r11 r6
};
const byte kInstruction_smuadx_eq_r0_r0_r5[] = {
  0x30, 0xf5, 0x00, 0x07 // smuadx eq r0 r0 r5
};
const byte kInstruction_smuadx_ne_r6_r5_r8[] = {
  0x35, 0xf8, 0x06, 0x17 // smuadx ne r6 r5 r8
};
const byte kInstruction_smuadx_hi_r5_r13_r3[] = {
  0x3d, 0xf3, 0x05, 0x87 // smuadx hi r5 r13 r3
};
const byte kInstruction_smuadx_ne_r11_r14_r14[] = {
  0x3e, 0xfe, 0x0b, 0x17 // smuadx ne r11 r14 r14
};
const byte kInstruction_smuadx_mi_r1_r0_r6[] = {
  0x30, 0xf6, 0x01, 0x47 // smuadx mi r1 r0 r6
};
const byte kInstruction_smuadx_le_r14_r8_r2[] = {
  0x38, 0xf2, 0x0e, 0xd7 // smuadx le r14 r8 r2
};
const byte kInstruction_smuadx_eq_r9_r6_r5[] = {
  0x36, 0xf5, 0x09, 0x07 // smuadx eq r9 r6 r5
};
const byte kInstruction_smuadx_eq_r11_r0_r13[] = {
  0x30, 0xfd, 0x0b, 0x07 // smuadx eq r11 r0 r13
};
const byte kInstruction_smuadx_pl_r4_r5_r14[] = {
  0x35, 0xfe, 0x04, 0x57 // smuadx pl r4 r5 r14
};
const byte kInstruction_smuadx_cs_r13_r5_r13[] = {
  0x35, 0xfd, 0x0d, 0x27 // smuadx cs r13 r5 r13
};
const byte kInstruction_smuadx_mi_r0_r13_r8[] = {
  0x3d, 0xf8, 0x00, 0x47 // smuadx mi r0 r13 r8
};
const byte kInstruction_smuadx_lt_r2_r13_r3[] = {
  0x3d, 0xf3, 0x02, 0xb7 // smuadx lt r2 r13 r3
};
const byte kInstruction_smuadx_ls_r8_r1_r11[] = {
  0x31, 0xfb, 0x08, 0x97 // smuadx ls r8 r1 r11
};
const byte kInstruction_smuadx_vc_r14_r11_r8[] = {
  0x3b, 0xf8, 0x0e, 0x77 // smuadx vc r14 r11 r8
};
const byte kInstruction_smuadx_lt_r4_r13_r12[] = {
  0x3d, 0xfc, 0x04, 0xb7 // smuadx lt r4 r13 r12
};
const byte kInstruction_smuadx_eq_r2_r1_r14[] = {
  0x31, 0xfe, 0x02, 0x07 // smuadx eq r2 r1 r14
};
const byte kInstruction_smuadx_eq_r9_r4_r14[] = {
  0x34, 0xfe, 0x09, 0x07 // smuadx eq r9 r4 r14
};
const byte kInstruction_smuadx_hi_r10_r6_r13[] = {
  0x36, 0xfd, 0x0a, 0x87 // smuadx hi r10 r6 r13
};
const byte kInstruction_smuadx_ge_r12_r9_r4[] = {
  0x39, 0xf4, 0x0c, 0xa7 // smuadx ge r12 r9 r4
};
const byte kInstruction_smuadx_le_r9_r11_r14[] = {
  0x3b, 0xfe, 0x09, 0xd7 // smuadx le r9 r11 r14
};
const byte kInstruction_smuadx_ls_r0_r9_r5[] = {
  0x39, 0xf5, 0x00, 0x97 // smuadx ls r0 r9 r5
};
const byte kInstruction_smuadx_mi_r2_r3_r8[] = {
  0x33, 0xf8, 0x02, 0x47 // smuadx mi r2 r3 r8
};
const byte kInstruction_smuadx_ne_r14_r10_r14[] = {
  0x3a, 0xfe, 0x0e, 0x17 // smuadx ne r14 r10 r14
};
const byte kInstruction_smuadx_eq_r6_r2_r10[] = {
  0x32, 0xfa, 0x06, 0x07 // smuadx eq r6 r2 r10
};
const byte kInstruction_smuadx_lt_r11_r0_r12[] = {
  0x30, 0xfc, 0x0b, 0xb7 // smuadx lt r11 r0 r12
};
const byte kInstruction_smuadx_ne_r1_r12_r10[] = {
  0x3c, 0xfa, 0x01, 0x17 // smuadx ne r1 r12 r10
};
const byte kInstruction_smuadx_cc_r1_r0_r2[] = {
  0x30, 0xf2, 0x01, 0x37 // smuadx cc r1 r0 r2
};
const byte kInstruction_smuadx_al_r5_r5_r7[] = {
  0x35, 0xf7, 0x05, 0xe7 // smuadx al r5 r5 r7
};
const byte kInstruction_smuadx_hi_r7_r13_r1[] = {
  0x3d, 0xf1, 0x07, 0x87 // smuadx hi r7 r13 r1
};
const byte kInstruction_smuadx_cs_r4_r4_r9[] = {
  0x34, 0xf9, 0x04, 0x27 // smuadx cs r4 r4 r9
};
const byte kInstruction_smuadx_eq_r14_r4_r14[] = {
  0x34, 0xfe, 0x0e, 0x07 // smuadx eq r14 r4 r14
};
const byte kInstruction_smuadx_vs_r10_r5_r14[] = {
  0x35, 0xfe, 0x0a, 0x67 // smuadx vs r10 r5 r14
};
const byte kInstruction_smuadx_gt_r4_r3_r11[] = {
  0x33, 0xfb, 0x04, 0xc7 // smuadx gt r4 r3 r11
};
const byte kInstruction_smuadx_ne_r14_r10_r12[] = {
  0x3a, 0xfc, 0x0e, 0x17 // smuadx ne r14 r10 r12
};
const byte kInstruction_smuadx_vs_r2_r11_r0[] = {
  0x3b, 0xf0, 0x02, 0x67 // smuadx vs r2 r11 r0
};
const byte kInstruction_smuadx_ge_r5_r12_r7[] = {
  0x3c, 0xf7, 0x05, 0xa7 // smuadx ge r5 r12 r7
};
const byte kInstruction_smuadx_mi_r7_r14_r6[] = {
  0x3e, 0xf6, 0x07, 0x47 // smuadx mi r7 r14 r6
};
const byte kInstruction_smuadx_gt_r8_r3_r8[] = {
  0x33, 0xf8, 0x08, 0xc7 // smuadx gt r8 r3 r8
};
const byte kInstruction_smuadx_hi_r9_r14_r3[] = {
  0x3e, 0xf3, 0x09, 0x87 // smuadx hi r9 r14 r3
};
const byte kInstruction_smuadx_vc_r2_r11_r2[] = {
  0x3b, 0xf2, 0x02, 0x77 // smuadx vc r2 r11 r2
};
const byte kInstruction_smuadx_hi_r11_r7_r12[] = {
  0x37, 0xfc, 0x0b, 0x87 // smuadx hi r11 r7 r12
};
const byte kInstruction_smuadx_cs_r6_r4_r11[] = {
  0x34, 0xfb, 0x06, 0x27 // smuadx cs r6 r4 r11
};
const byte kInstruction_smuadx_cs_r12_r5_r9[] = {
  0x35, 0xf9, 0x0c, 0x27 // smuadx cs r12 r5 r9
};
const byte kInstruction_smuadx_ls_r5_r10_r5[] = {
  0x3a, 0xf5, 0x05, 0x97 // smuadx ls r5 r10 r5
};
const byte kInstruction_smuadx_ls_r0_r9_r13[] = {
  0x39, 0xfd, 0x00, 0x97 // smuadx ls r0 r9 r13
};
const byte kInstruction_smuadx_lt_r3_r3_r5[] = {
  0x33, 0xf5, 0x03, 0xb7 // smuadx lt r3 r3 r5
};
const byte kInstruction_smuadx_mi_r0_r12_r8[] = {
  0x3c, 0xf8, 0x00, 0x47 // smuadx mi r0 r12 r8
};
const byte kInstruction_smuadx_pl_r3_r12_r12[] = {
  0x3c, 0xfc, 0x03, 0x57 // smuadx pl r3 r12 r12
};
const byte kInstruction_smuadx_eq_r8_r12_r5[] = {
  0x3c, 0xf5, 0x08, 0x07 // smuadx eq r8 r12 r5
};
const byte kInstruction_smuadx_cc_r7_r8_r1[] = {
  0x38, 0xf1, 0x07, 0x37 // smuadx cc r7 r8 r1
};
const byte kInstruction_smuadx_hi_r2_r13_r10[] = {
  0x3d, 0xfa, 0x02, 0x87 // smuadx hi r2 r13 r10
};
const byte kInstruction_smuadx_al_r7_r10_r10[] = {
  0x3a, 0xfa, 0x07, 0xe7 // smuadx al r7 r10 r10
};
const byte kInstruction_smuadx_vc_r1_r12_r2[] = {
  0x3c, 0xf2, 0x01, 0x77 // smuadx vc r1 r12 r2
};
const byte kInstruction_smuadx_cc_r8_r5_r8[] = {
  0x35, 0xf8, 0x08, 0x37 // smuadx cc r8 r5 r8
};
const byte kInstruction_smuadx_ls_r3_r7_r9[] = {
  0x37, 0xf9, 0x03, 0x97 // smuadx ls r3 r7 r9
};
const byte kInstruction_smuadx_al_r8_r10_r8[] = {
  0x3a, 0xf8, 0x08, 0xe7 // smuadx al r8 r10 r8
};
const byte kInstruction_smuadx_lt_r4_r12_r10[] = {
  0x3c, 0xfa, 0x04, 0xb7 // smuadx lt r4 r12 r10
};
const byte kInstruction_smuadx_ge_r10_r5_r11[] = {
  0x35, 0xfb, 0x0a, 0xa7 // smuadx ge r10 r5 r11
};
const byte kInstruction_smuadx_ls_r3_r14_r4[] = {
  0x3e, 0xf4, 0x03, 0x97 // smuadx ls r3 r14 r4
};
const byte kInstruction_smuadx_hi_r3_r6_r12[] = {
  0x36, 0xfc, 0x03, 0x87 // smuadx hi r3 r6 r12
};
const byte kInstruction_smuadx_hi_r6_r0_r4[] = {
  0x30, 0xf4, 0x06, 0x87 // smuadx hi r6 r0 r4
};
const byte kInstruction_smuadx_al_r11_r6_r0[] = {
  0x36, 0xf0, 0x0b, 0xe7 // smuadx al r11 r6 r0
};
const byte kInstruction_smuadx_mi_r3_r1_r9[] = {
  0x31, 0xf9, 0x03, 0x47 // smuadx mi r3 r1 r9
};
const byte kInstruction_smuadx_mi_r12_r13_r0[] = {
  0x3d, 0xf0, 0x0c, 0x47 // smuadx mi r12 r13 r0
};
const byte kInstruction_smuadx_le_r1_r2_r5[] = {
  0x32, 0xf5, 0x01, 0xd7 // smuadx le r1 r2 r5
};
const byte kInstruction_smuadx_hi_r4_r3_r14[] = {
  0x33, 0xfe, 0x04, 0x87 // smuadx hi r4 r3 r14
};
const byte kInstruction_smuadx_eq_r6_r11_r11[] = {
  0x3b, 0xfb, 0x06, 0x07 // smuadx eq r6 r11 r11
};
const byte kInstruction_smuadx_cc_r14_r11_r14[] = {
  0x3b, 0xfe, 0x0e, 0x37 // smuadx cc r14 r11 r14
};
const byte kInstruction_smuadx_hi_r4_r10_r0[] = {
  0x3a, 0xf0, 0x04, 0x87 // smuadx hi r4 r10 r0
};
const byte kInstruction_smuadx_cc_r7_r11_r1[] = {
  0x3b, 0xf1, 0x07, 0x37 // smuadx cc r7 r11 r1
};
const byte kInstruction_smuadx_mi_r14_r6_r10[] = {
  0x36, 0xfa, 0x0e, 0x47 // smuadx mi r14 r6 r10
};
const byte kInstruction_smuadx_eq_r2_r0_r11[] = {
  0x30, 0xfb, 0x02, 0x07 // smuadx eq r2 r0 r11
};
const byte kInstruction_smuadx_mi_r13_r5_r12[] = {
  0x35, 0xfc, 0x0d, 0x47 // smuadx mi r13 r5 r12
};
const byte kInstruction_smuadx_eq_r2_r12_r5[] = {
  0x3c, 0xf5, 0x02, 0x07 // smuadx eq r2 r12 r5
};
const byte kInstruction_smuadx_le_r12_r0_r2[] = {
  0x30, 0xf2, 0x0c, 0xd7 // smuadx le r12 r0 r2
};
const byte kInstruction_smuadx_vc_r10_r10_r9[] = {
  0x3a, 0xf9, 0x0a, 0x77 // smuadx vc r10 r10 r9
};
const byte kInstruction_smuadx_ls_r11_r11_r8[] = {
  0x3b, 0xf8, 0x0b, 0x97 // smuadx ls r11 r11 r8
};
const byte kInstruction_smuadx_hi_r10_r11_r9[] = {
  0x3b, 0xf9, 0x0a, 0x87 // smuadx hi r10 r11 r9
};
const byte kInstruction_smuadx_vs_r7_r12_r14[] = {
  0x3c, 0xfe, 0x07, 0x67 // smuadx vs r7 r12 r14
};
const byte kInstruction_smuadx_gt_r11_r14_r12[] = {
  0x3e, 0xfc, 0x0b, 0xc7 // smuadx gt r11 r14 r12
};
const byte kInstruction_smuadx_vs_r0_r12_r8[] = {
  0x3c, 0xf8, 0x00, 0x67 // smuadx vs r0 r12 r8
};
const byte kInstruction_smuadx_al_r0_r5_r7[] = {
  0x35, 0xf7, 0x00, 0xe7 // smuadx al r0 r5 r7
};
const byte kInstruction_smuadx_hi_r5_r13_r8[] = {
  0x3d, 0xf8, 0x05, 0x87 // smuadx hi r5 r13 r8
};
const byte kInstruction_smuadx_le_r9_r9_r7[] = {
  0x39, 0xf7, 0x09, 0xd7 // smuadx le r9 r9 r7
};
const byte kInstruction_smuadx_cc_r4_r9_r5[] = {
  0x39, 0xf5, 0x04, 0x37 // smuadx cc r4 r9 r5
};
const byte kInstruction_smuadx_vs_r8_r1_r3[] = {
  0x31, 0xf3, 0x08, 0x67 // smuadx vs r8 r1 r3
};
const byte kInstruction_smuadx_cc_r0_r10_r12[] = {
  0x3a, 0xfc, 0x00, 0x37 // smuadx cc r0 r10 r12
};
const byte kInstruction_smuadx_eq_r7_r14_r0[] = {
  0x3e, 0xf0, 0x07, 0x07 // smuadx eq r7 r14 r0
};
const byte kInstruction_smuadx_vs_r12_r9_r11[] = {
  0x39, 0xfb, 0x0c, 0x67 // smuadx vs r12 r9 r11
};
const byte kInstruction_smuadx_gt_r5_r9_r11[] = {
  0x39, 0xfb, 0x05, 0xc7 // smuadx gt r5 r9 r11
};
const byte kInstruction_smuadx_cs_r14_r13_r7[] = {
  0x3d, 0xf7, 0x0e, 0x27 // smuadx cs r14 r13 r7
};
const byte kInstruction_smuadx_mi_r11_r3_r10[] = {
  0x33, 0xfa, 0x0b, 0x47 // smuadx mi r11 r3 r10
};
const byte kInstruction_smuadx_hi_r11_r8_r12[] = {
  0x38, 0xfc, 0x0b, 0x87 // smuadx hi r11 r8 r12
};
const byte kInstruction_smuadx_cs_r3_r8_r13[] = {
  0x38, 0xfd, 0x03, 0x27 // smuadx cs r3 r8 r13
};
const byte kInstruction_smuadx_pl_r10_r12_r6[] = {
  0x3c, 0xf6, 0x0a, 0x57 // smuadx pl r10 r12 r6
};
const byte kInstruction_smuadx_vc_r7_r3_r2[] = {
  0x33, 0xf2, 0x07, 0x77 // smuadx vc r7 r3 r2
};
const byte kInstruction_smuadx_mi_r9_r0_r8[] = {
  0x30, 0xf8, 0x09, 0x47 // smuadx mi r9 r0 r8
};
const byte kInstruction_smuadx_eq_r2_r13_r7[] = {
  0x3d, 0xf7, 0x02, 0x07 // smuadx eq r2 r13 r7
};
const byte kInstruction_smuadx_ne_r2_r14_r0[] = {
  0x3e, 0xf0, 0x02, 0x17 // smuadx ne r2 r14 r0
};
const byte kInstruction_smuadx_vs_r4_r10_r0[] = {
  0x3a, 0xf0, 0x04, 0x67 // smuadx vs r4 r10 r0
};
const byte kInstruction_smuadx_ls_r0_r2_r2[] = {
  0x32, 0xf2, 0x00, 0x97 // smuadx ls r0 r2 r2
};
const byte kInstruction_smuadx_cc_r1_r6_r0[] = {
  0x36, 0xf0, 0x01, 0x37 // smuadx cc r1 r6 r0
};
const byte kInstruction_smuadx_lt_r12_r0_r8[] = {
  0x30, 0xf8, 0x0c, 0xb7 // smuadx lt r12 r0 r8
};
const byte kInstruction_smuadx_cc_r9_r3_r14[] = {
  0x33, 0xfe, 0x09, 0x37 // smuadx cc r9 r3 r14
};
const byte kInstruction_smuadx_vs_r7_r9_r1[] = {
  0x39, 0xf1, 0x07, 0x67 // smuadx vs r7 r9 r1
};
const byte kInstruction_smuadx_eq_r11_r9_r14[] = {
  0x39, 0xfe, 0x0b, 0x07 // smuadx eq r11 r9 r14
};
const byte kInstruction_smuadx_pl_r6_r10_r4[] = {
  0x3a, 0xf4, 0x06, 0x57 // smuadx pl r6 r10 r4
};
const byte kInstruction_smuadx_ne_r8_r5_r6[] = {
  0x35, 0xf6, 0x08, 0x17 // smuadx ne r8 r5 r6
};
const byte kInstruction_smuadx_cs_r0_r6_r2[] = {
  0x36, 0xf2, 0x00, 0x27 // smuadx cs r0 r6 r2
};
const byte kInstruction_smuadx_eq_r11_r12_r4[] = {
  0x3c, 0xf4, 0x0b, 0x07 // smuadx eq r11 r12 r4
};
const byte kInstruction_smuadx_lt_r14_r3_r14[] = {
  0x33, 0xfe, 0x0e, 0xb7 // smuadx lt r14 r3 r14
};
const byte kInstruction_smuadx_le_r7_r12_r14[] = {
  0x3c, 0xfe, 0x07, 0xd7 // smuadx le r7 r12 r14
};
const byte kInstruction_smuadx_hi_r2_r9_r9[] = {
  0x39, 0xf9, 0x02, 0x87 // smuadx hi r2 r9 r9
};
const byte kInstruction_smuadx_ne_r8_r1_r0[] = {
  0x31, 0xf0, 0x08, 0x17 // smuadx ne r8 r1 r0
};
const byte kInstruction_smuadx_cc_r5_r11_r2[] = {
  0x3b, 0xf2, 0x05, 0x37 // smuadx cc r5 r11 r2
};
const byte kInstruction_smuadx_hi_r0_r1_r2[] = {
  0x31, 0xf2, 0x00, 0x87 // smuadx hi r0 r1 r2
};
const byte kInstruction_smuadx_al_r4_r9_r4[] = {
  0x39, 0xf4, 0x04, 0xe7 // smuadx al r4 r9 r4
};
const byte kInstruction_smuadx_cs_r12_r7_r14[] = {
  0x37, 0xfe, 0x0c, 0x27 // smuadx cs r12 r7 r14
};
const byte kInstruction_smuadx_cc_r4_r12_r10[] = {
  0x3c, 0xfa, 0x04, 0x37 // smuadx cc r4 r12 r10
};
const byte kInstruction_smuadx_al_r3_r5_r10[] = {
  0x35, 0xfa, 0x03, 0xe7 // smuadx al r3 r5 r10
};
const byte kInstruction_smuadx_mi_r5_r3_r7[] = {
  0x33, 0xf7, 0x05, 0x47 // smuadx mi r5 r3 r7
};
const byte kInstruction_smuadx_ls_r10_r6_r2[] = {
  0x36, 0xf2, 0x0a, 0x97 // smuadx ls r10 r6 r2
};
const byte kInstruction_smuadx_mi_r0_r12_r11[] = {
  0x3c, 0xfb, 0x00, 0x47 // smuadx mi r0 r12 r11
};
const byte kInstruction_smuadx_vc_r12_r5_r6[] = {
  0x35, 0xf6, 0x0c, 0x77 // smuadx vc r12 r5 r6
};
const byte kInstruction_smuadx_cs_r3_r9_r4[] = {
  0x39, 0xf4, 0x03, 0x27 // smuadx cs r3 r9 r4
};
const byte kInstruction_smuadx_ls_r4_r9_r11[] = {
  0x39, 0xfb, 0x04, 0x97 // smuadx ls r4 r9 r11
};
const byte kInstruction_smuadx_le_r14_r8_r13[] = {
  0x38, 0xfd, 0x0e, 0xd7 // smuadx le r14 r8 r13
};
const byte kInstruction_smuadx_gt_r4_r10_r8[] = {
  0x3a, 0xf8, 0x04, 0xc7 // smuadx gt r4 r10 r8
};
const byte kInstruction_smuadx_al_r6_r9_r9[] = {
  0x39, 0xf9, 0x06, 0xe7 // smuadx al r6 r9 r9
};
const byte kInstruction_smuadx_ne_r8_r5_r12[] = {
  0x35, 0xfc, 0x08, 0x17 // smuadx ne r8 r5 r12
};
const byte kInstruction_smuadx_ne_r0_r4_r8[] = {
  0x34, 0xf8, 0x00, 0x17 // smuadx ne r0 r4 r8
};
const byte kInstruction_smuadx_mi_r7_r13_r3[] = {
  0x3d, 0xf3, 0x07, 0x47 // smuadx mi r7 r13 r3
};
const byte kInstruction_smuadx_cc_r11_r7_r0[] = {
  0x37, 0xf0, 0x0b, 0x37 // smuadx cc r11 r7 r0
};
const byte kInstruction_smuadx_hi_r1_r0_r12[] = {
  0x30, 0xfc, 0x01, 0x87 // smuadx hi r1 r0 r12
};
const byte kInstruction_smuadx_lt_r8_r9_r3[] = {
  0x39, 0xf3, 0x08, 0xb7 // smuadx lt r8 r9 r3
};
const byte kInstruction_smuadx_al_r0_r2_r1[] = {
  0x32, 0xf1, 0x00, 0xe7 // smuadx al r0 r2 r1
};
const byte kInstruction_smuadx_vs_r4_r3_r14[] = {
  0x33, 0xfe, 0x04, 0x67 // smuadx vs r4 r3 r14
};
const byte kInstruction_smuadx_ge_r2_r11_r1[] = {
  0x3b, 0xf1, 0x02, 0xa7 // smuadx ge r2 r11 r1
};
const byte kInstruction_smuadx_lt_r12_r9_r6[] = {
  0x39, 0xf6, 0x0c, 0xb7 // smuadx lt r12 r9 r6
};
const byte kInstruction_smuadx_ls_r8_r2_r7[] = {
  0x32, 0xf7, 0x08, 0x97 // smuadx ls r8 r2 r7
};
const byte kInstruction_smuadx_le_r8_r13_r3[] = {
  0x3d, 0xf3, 0x08, 0xd7 // smuadx le r8 r13 r3
};
const byte kInstruction_smuadx_eq_r11_r13_r14[] = {
  0x3d, 0xfe, 0x0b, 0x07 // smuadx eq r11 r13 r14
};
const byte kInstruction_smuadx_lt_r1_r6_r13[] = {
  0x36, 0xfd, 0x01, 0xb7 // smuadx lt r1 r6 r13
};
const byte kInstruction_smuadx_cs_r3_r8_r11[] = {
  0x38, 0xfb, 0x03, 0x27 // smuadx cs r3 r8 r11
};
const byte kInstruction_smuadx_pl_r12_r5_r4[] = {
  0x35, 0xf4, 0x0c, 0x57 // smuadx pl r12 r5 r4
};
const byte kInstruction_smuadx_eq_r8_r7_r2[] = {
  0x37, 0xf2, 0x08, 0x07 // smuadx eq r8 r7 r2
};
const byte kInstruction_smuadx_ls_r2_r12_r2[] = {
  0x3c, 0xf2, 0x02, 0x97 // smuadx ls r2 r12 r2
};
const byte kInstruction_smuadx_le_r14_r2_r3[] = {
  0x32, 0xf3, 0x0e, 0xd7 // smuadx le r14 r2 r3
};
const byte kInstruction_smuadx_ge_r10_r11_r6[] = {
  0x3b, 0xf6, 0x0a, 0xa7 // smuadx ge r10 r11 r6
};
const byte kInstruction_smuadx_hi_r0_r2_r2[] = {
  0x32, 0xf2, 0x00, 0x87 // smuadx hi r0 r2 r2
};
const byte kInstruction_smuadx_ge_r2_r0_r2[] = {
  0x30, 0xf2, 0x02, 0xa7 // smuadx ge r2 r0 r2
};
const byte kInstruction_smuadx_vs_r11_r14_r0[] = {
  0x3e, 0xf0, 0x0b, 0x67 // smuadx vs r11 r14 r0
};
const byte kInstruction_smuadx_lt_r2_r0_r1[] = {
  0x30, 0xf1, 0x02, 0xb7 // smuadx lt r2 r0 r1
};
const byte kInstruction_smuadx_cs_r2_r5_r11[] = {
  0x35, 0xfb, 0x02, 0x27 // smuadx cs r2 r5 r11
};
const byte kInstruction_smuadx_ls_r7_r14_r5[] = {
  0x3e, 0xf5, 0x07, 0x97 // smuadx ls r7 r14 r5
};
const byte kInstruction_smuadx_pl_r0_r0_r3[] = {
  0x30, 0xf3, 0x00, 0x57 // smuadx pl r0 r0 r3
};
const byte kInstruction_smuadx_ge_r6_r8_r8[] = {
  0x38, 0xf8, 0x06, 0xa7 // smuadx ge r6 r8 r8
};
const byte kInstruction_smuadx_le_r11_r1_r10[] = {
  0x31, 0xfa, 0x0b, 0xd7 // smuadx le r11 r1 r10
};
const byte kInstruction_smuadx_vs_r5_r2_r7[] = {
  0x32, 0xf7, 0x05, 0x67 // smuadx vs r5 r2 r7
};
const byte kInstruction_smuadx_ne_r4_r4_r8[] = {
  0x34, 0xf8, 0x04, 0x17 // smuadx ne r4 r4 r8
};
const byte kInstruction_smuadx_cc_r9_r14_r13[] = {
  0x3e, 0xfd, 0x09, 0x37 // smuadx cc r9 r14 r13
};
const byte kInstruction_smuadx_hi_r14_r6_r3[] = {
  0x36, 0xf3, 0x0e, 0x87 // smuadx hi r14 r6 r3
};
const byte kInstruction_smuadx_al_r0_r8_r0[] = {
  0x38, 0xf0, 0x00, 0xe7 // smuadx al r0 r8 r0
};
const byte kInstruction_smuadx_lt_r6_r11_r1[] = {
  0x3b, 0xf1, 0x06, 0xb7 // smuadx lt r6 r11 r1
};
const byte kInstruction_smuadx_ge_r7_r6_r12[] = {
  0x36, 0xfc, 0x07, 0xa7 // smuadx ge r7 r6 r12
};
const byte kInstruction_smuadx_cs_r4_r6_r14[] = {
  0x36, 0xfe, 0x04, 0x27 // smuadx cs r4 r6 r14
};
const byte kInstruction_smuadx_cs_r7_r6_r7[] = {
  0x36, 0xf7, 0x07, 0x27 // smuadx cs r7 r6 r7
};
const byte kInstruction_smuadx_cs_r3_r7_r10[] = {
  0x37, 0xfa, 0x03, 0x27 // smuadx cs r3 r7 r10
};
const byte kInstruction_smuadx_ne_r0_r2_r1[] = {
  0x32, 0xf1, 0x00, 0x17 // smuadx ne r0 r2 r1
};
const byte kInstruction_smuadx_vs_r9_r10_r13[] = {
  0x3a, 0xfd, 0x09, 0x67 // smuadx vs r9 r10 r13
};
const byte kInstruction_smuadx_vc_r11_r14_r12[] = {
  0x3e, 0xfc, 0x0b, 0x77 // smuadx vc r11 r14 r12
};
const byte kInstruction_smuadx_ge_r14_r8_r7[] = {
  0x38, 0xf7, 0x0e, 0xa7 // smuadx ge r14 r8 r7
};
const byte kInstruction_smuadx_lt_r13_r0_r11[] = {
  0x30, 0xfb, 0x0d, 0xb7 // smuadx lt r13 r0 r11
};
const byte kInstruction_smuadx_lt_r14_r13_r4[] = {
  0x3d, 0xf4, 0x0e, 0xb7 // smuadx lt r14 r13 r4
};
const byte kInstruction_smuadx_al_r1_r10_r9[] = {
  0x3a, 0xf9, 0x01, 0xe7 // smuadx al r1 r10 r9
};
const byte kInstruction_smuadx_ge_r11_r14_r11[] = {
  0x3e, 0xfb, 0x0b, 0xa7 // smuadx ge r11 r14 r11
};
const byte kInstruction_smuadx_cs_r11_r4_r11[] = {
  0x34, 0xfb, 0x0b, 0x27 // smuadx cs r11 r4 r11
};
const byte kInstruction_smuadx_ge_r0_r14_r7[] = {
  0x3e, 0xf7, 0x00, 0xa7 // smuadx ge r0 r14 r7
};
const byte kInstruction_smuadx_mi_r1_r2_r9[] = {
  0x32, 0xf9, 0x01, 0x47 // smuadx mi r1 r2 r9
};
const byte kInstruction_smuadx_eq_r5_r12_r3[] = {
  0x3c, 0xf3, 0x05, 0x07 // smuadx eq r5 r12 r3
};
const byte kInstruction_smuadx_ge_r1_r5_r12[] = {
  0x35, 0xfc, 0x01, 0xa7 // smuadx ge r1 r5 r12
};
const byte kInstruction_smuadx_lt_r10_r11_r4[] = {
  0x3b, 0xf4, 0x0a, 0xb7 // smuadx lt r10 r11 r4
};
const byte kInstruction_smuadx_le_r1_r1_r5[] = {
  0x31, 0xf5, 0x01, 0xd7 // smuadx le r1 r1 r5
};
const byte kInstruction_smuadx_al_r9_r1_r8[] = {
  0x31, 0xf8, 0x09, 0xe7 // smuadx al r9 r1 r8
};
const byte kInstruction_smuadx_ne_r6_r8_r4[] = {
  0x38, 0xf4, 0x06, 0x17 // smuadx ne r6 r8 r4
};
const byte kInstruction_smuadx_ge_r12_r2_r9[] = {
  0x32, 0xf9, 0x0c, 0xa7 // smuadx ge r12 r2 r9
};
const byte kInstruction_smuadx_pl_r4_r3_r10[] = {
  0x33, 0xfa, 0x04, 0x57 // smuadx pl r4 r3 r10
};
const byte kInstruction_smuadx_eq_r14_r4_r11[] = {
  0x34, 0xfb, 0x0e, 0x07 // smuadx eq r14 r4 r11
};
const byte kInstruction_smuadx_cc_r9_r7_r6[] = {
  0x37, 0xf6, 0x09, 0x37 // smuadx cc r9 r7 r6
};
const byte kInstruction_smuadx_ge_r12_r4_r5[] = {
  0x34, 0xf5, 0x0c, 0xa7 // smuadx ge r12 r4 r5
};
const byte kInstruction_smuadx_hi_r2_r3_r4[] = {
  0x33, 0xf4, 0x02, 0x87 // smuadx hi r2 r3 r4
};
const byte kInstruction_smuadx_cs_r0_r3_r1[] = {
  0x33, 0xf1, 0x00, 0x27 // smuadx cs r0 r3 r1
};
const byte kInstruction_smuadx_hi_r6_r2_r8[] = {
  0x32, 0xf8, 0x06, 0x87 // smuadx hi r6 r2 r8
};
const byte kInstruction_smuadx_cc_r3_r14_r13[] = {
  0x3e, 0xfd, 0x03, 0x37 // smuadx cc r3 r14 r13
};
const byte kInstruction_smuadx_gt_r11_r4_r7[] = {
  0x34, 0xf7, 0x0b, 0xc7 // smuadx gt r11 r4 r7
};
const byte kInstruction_smuadx_hi_r5_r0_r12[] = {
  0x30, 0xfc, 0x05, 0x87 // smuadx hi r5 r0 r12
};
const byte kInstruction_smuadx_gt_r0_r14_r14[] = {
  0x3e, 0xfe, 0x00, 0xc7 // smuadx gt r0 r14 r14
};
const byte kInstruction_smuadx_hi_r9_r0_r10[] = {
  0x30, 0xfa, 0x09, 0x87 // smuadx hi r9 r0 r10
};
const byte kInstruction_smuadx_vc_r7_r11_r8[] = {
  0x3b, 0xf8, 0x07, 0x77 // smuadx vc r7 r11 r8
};
const byte kInstruction_smuadx_pl_r11_r9_r6[] = {
  0x39, 0xf6, 0x0b, 0x57 // smuadx pl r11 r9 r6
};
const byte kInstruction_smuadx_al_r3_r3_r7[] = {
  0x33, 0xf7, 0x03, 0xe7 // smuadx al r3 r3 r7
};
const byte kInstruction_smuadx_mi_r5_r7_r9[] = {
  0x37, 0xf9, 0x05, 0x47 // smuadx mi r5 r7 r9
};
const byte kInstruction_smuadx_cc_r11_r2_r4[] = {
  0x32, 0xf4, 0x0b, 0x37 // smuadx cc r11 r2 r4
};
const byte kInstruction_smuadx_cc_r9_r13_r10[] = {
  0x3d, 0xfa, 0x09, 0x37 // smuadx cc r9 r13 r10
};
const byte kInstruction_smuadx_al_r5_r2_r6[] = {
  0x32, 0xf6, 0x05, 0xe7 // smuadx al r5 r2 r6
};
const byte kInstruction_smuadx_ge_r9_r4_r6[] = {
  0x34, 0xf6, 0x09, 0xa7 // smuadx ge r9 r4 r6
};
const byte kInstruction_smuadx_ls_r3_r3_r4[] = {
  0x33, 0xf4, 0x03, 0x97 // smuadx ls r3 r3 r4
};
const byte kInstruction_smuadx_ge_r14_r1_r8[] = {
  0x31, 0xf8, 0x0e, 0xa7 // smuadx ge r14 r1 r8
};
const byte kInstruction_smuadx_ls_r7_r12_r7[] = {
  0x3c, 0xf7, 0x07, 0x97 // smuadx ls r7 r12 r7
};
const byte kInstruction_smuadx_al_r11_r10_r5[] = {
  0x3a, 0xf5, 0x0b, 0xe7 // smuadx al r11 r10 r5
};
const byte kInstruction_smuadx_al_r7_r4_r6[] = {
  0x34, 0xf6, 0x07, 0xe7 // smuadx al r7 r4 r6
};
const byte kInstruction_smuadx_vs_r12_r4_r10[] = {
  0x34, 0xfa, 0x0c, 0x67 // smuadx vs r12 r4 r10
};
const byte kInstruction_smuadx_eq_r4_r4_r4[] = {
  0x34, 0xf4, 0x04, 0x07 // smuadx eq r4 r4 r4
};
const byte kInstruction_smuadx_vs_r6_r6_r12[] = {
  0x36, 0xfc, 0x06, 0x67 // smuadx vs r6 r6 r12
};
const byte kInstruction_smuadx_pl_r9_r3_r5[] = {
  0x33, 0xf5, 0x09, 0x57 // smuadx pl r9 r3 r5
};
const byte kInstruction_smuadx_eq_r6_r5_r13[] = {
  0x35, 0xfd, 0x06, 0x07 // smuadx eq r6 r5 r13
};
const byte kInstruction_smuadx_cc_r8_r2_r12[] = {
  0x32, 0xfc, 0x08, 0x37 // smuadx cc r8 r2 r12
};
const byte kInstruction_smuadx_le_r4_r2_r0[] = {
  0x32, 0xf0, 0x04, 0xd7 // smuadx le r4 r2 r0
};
const byte kInstruction_smuadx_lt_r7_r9_r8[] = {
  0x39, 0xf8, 0x07, 0xb7 // smuadx lt r7 r9 r8
};
const byte kInstruction_smuadx_le_r4_r7_r11[] = {
  0x37, 0xfb, 0x04, 0xd7 // smuadx le r4 r7 r11
};
const byte kInstruction_smuadx_eq_r5_r7_r5[] = {
  0x37, 0xf5, 0x05, 0x07 // smuadx eq r5 r7 r5
};
const byte kInstruction_smuadx_vc_r10_r7_r12[] = {
  0x37, 0xfc, 0x0a, 0x77 // smuadx vc r10 r7 r12
};
const byte kInstruction_smuadx_eq_r7_r10_r6[] = {
  0x3a, 0xf6, 0x07, 0x07 // smuadx eq r7 r10 r6
};
const byte kInstruction_smuadx_pl_r1_r12_r2[] = {
  0x3c, 0xf2, 0x01, 0x57 // smuadx pl r1 r12 r2
};
const byte kInstruction_smuadx_le_r14_r6_r6[] = {
  0x36, 0xf6, 0x0e, 0xd7 // smuadx le r14 r6 r6
};
const byte kInstruction_smuadx_ne_r3_r8_r8[] = {
  0x38, 0xf8, 0x03, 0x17 // smuadx ne r3 r8 r8
};
const byte kInstruction_smuadx_eq_r4_r12_r8[] = {
  0x3c, 0xf8, 0x04, 0x07 // smuadx eq r4 r12 r8
};
const byte kInstruction_smuadx_ge_r11_r2_r3[] = {
  0x32, 0xf3, 0x0b, 0xa7 // smuadx ge r11 r2 r3
};
const byte kInstruction_smuadx_hi_r12_r6_r11[] = {
  0x36, 0xfb, 0x0c, 0x87 // smuadx hi r12 r6 r11
};
const byte kInstruction_smuadx_cs_r4_r5_r10[] = {
  0x35, 0xfa, 0x04, 0x27 // smuadx cs r4 r5 r10
};
const byte kInstruction_smuadx_ge_r10_r2_r10[] = {
  0x32, 0xfa, 0x0a, 0xa7 // smuadx ge r10 r2 r10
};
const byte kInstruction_smuadx_ge_r5_r14_r6[] = {
  0x3e, 0xf6, 0x05, 0xa7 // smuadx ge r5 r14 r6
};
const byte kInstruction_smuadx_gt_r13_r7_r5[] = {
  0x37, 0xf5, 0x0d, 0xc7 // smuadx gt r13 r7 r5
};
const byte kInstruction_smuadx_ge_r13_r4_r12[] = {
  0x34, 0xfc, 0x0d, 0xa7 // smuadx ge r13 r4 r12
};
const byte kInstruction_smuadx_lt_r8_r10_r14[] = {
  0x3a, 0xfe, 0x08, 0xb7 // smuadx lt r8 r10 r14
};
const byte kInstruction_smuadx_le_r4_r3_r13[] = {
  0x33, 0xfd, 0x04, 0xd7 // smuadx le r4 r3 r13
};
const byte kInstruction_smuadx_pl_r0_r9_r0[] = {
  0x39, 0xf0, 0x00, 0x57 // smuadx pl r0 r9 r0
};
const byte kInstruction_smuadx_eq_r2_r3_r1[] = {
  0x33, 0xf1, 0x02, 0x07 // smuadx eq r2 r3 r1
};
const byte kInstruction_smuadx_vc_r0_r0_r3[] = {
  0x30, 0xf3, 0x00, 0x77 // smuadx vc r0 r0 r3
};
const byte kInstruction_smuadx_mi_r10_r8_r11[] = {
  0x38, 0xfb, 0x0a, 0x47 // smuadx mi r10 r8 r11
};
const byte kInstruction_smuadx_mi_r5_r14_r14[] = {
  0x3e, 0xfe, 0x05, 0x47 // smuadx mi r5 r14 r14
};
const byte kInstruction_smuadx_gt_r5_r11_r2[] = {
  0x3b, 0xf2, 0x05, 0xc7 // smuadx gt r5 r11 r2
};
const byte kInstruction_smuadx_al_r4_r7_r11[] = {
  0x37, 0xfb, 0x04, 0xe7 // smuadx al r4 r7 r11
};
const TestResult kReferencesmuadx[] = {
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r1_r9_r5),
    kInstruction_smuadx_hi_r1_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_pl_r8_r6_r2),
    kInstruction_smuadx_pl_r8_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r5_r8_r2),
    kInstruction_smuadx_hi_r5_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vc_r9_r2_r7),
    kInstruction_smuadx_vc_r9_r2_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_lt_r4_r6_r3),
    kInstruction_smuadx_lt_r4_r6_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_le_r11_r6_r2),
    kInstruction_smuadx_le_r11_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cc_r8_r14_r4),
    kInstruction_smuadx_cc_r8_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_le_r5_r14_r6),
    kInstruction_smuadx_le_r5_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_lt_r6_r1_r0),
    kInstruction_smuadx_lt_r6_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_lt_r5_r0_r9),
    kInstruction_smuadx_lt_r5_r0_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_le_r8_r12_r7),
    kInstruction_smuadx_le_r8_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r7_r14_r6),
    kInstruction_smuadx_eq_r7_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cs_r7_r4_r6),
    kInstruction_smuadx_cs_r7_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_gt_r9_r6_r9),
    kInstruction_smuadx_gt_r9_r6_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ne_r13_r9_r1),
    kInstruction_smuadx_ne_r13_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ge_r13_r1_r13),
    kInstruction_smuadx_ge_r13_r1_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ls_r8_r10_r2),
    kInstruction_smuadx_ls_r8_r10_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r0_r13_r5),
    kInstruction_smuadx_hi_r0_r13_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_pl_r13_r7_r8),
    kInstruction_smuadx_pl_r13_r7_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ge_r4_r13_r11),
    kInstruction_smuadx_ge_r4_r13_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cs_r5_r10_r5),
    kInstruction_smuadx_cs_r5_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cs_r5_r4_r3),
    kInstruction_smuadx_cs_r5_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ls_r6_r14_r8),
    kInstruction_smuadx_ls_r6_r14_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vs_r3_r8_r6),
    kInstruction_smuadx_vs_r3_r8_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vc_r7_r12_r3),
    kInstruction_smuadx_vc_r7_r12_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ge_r1_r4_r1),
    kInstruction_smuadx_ge_r1_r4_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cc_r4_r7_r10),
    kInstruction_smuadx_cc_r4_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cc_r2_r0_r13),
    kInstruction_smuadx_cc_r2_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vs_r9_r6_r8),
    kInstruction_smuadx_vs_r9_r6_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cs_r14_r11_r13),
    kInstruction_smuadx_cs_r14_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_pl_r5_r8_r4),
    kInstruction_smuadx_pl_r5_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_pl_r2_r3_r7),
    kInstruction_smuadx_pl_r2_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cs_r7_r12_r14),
    kInstruction_smuadx_cs_r7_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r6_r6_r1),
    kInstruction_smuadx_hi_r6_r6_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cc_r6_r9_r6),
    kInstruction_smuadx_cc_r6_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ne_r12_r12_r0),
    kInstruction_smuadx_ne_r12_r12_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cc_r9_r3_r8),
    kInstruction_smuadx_cc_r9_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_mi_r13_r6_r1),
    kInstruction_smuadx_mi_r13_r6_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_lt_r4_r8_r6),
    kInstruction_smuadx_lt_r4_r8_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r11_r5_r9),
    kInstruction_smuadx_hi_r11_r5_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cc_r6_r10_r6),
    kInstruction_smuadx_cc_r6_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r10_r10_r5),
    kInstruction_smuadx_eq_r10_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_al_r5_r4_r11),
    kInstruction_smuadx_al_r5_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_pl_r11_r11_r2),
    kInstruction_smuadx_pl_r11_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ls_r6_r14_r12),
    kInstruction_smuadx_ls_r6_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vc_r7_r7_r2),
    kInstruction_smuadx_vc_r7_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r10_r8_r4),
    kInstruction_smuadx_eq_r10_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_al_r14_r7_r2),
    kInstruction_smuadx_al_r14_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cs_r3_r11_r10),
    kInstruction_smuadx_cs_r3_r11_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ls_r11_r4_r0),
    kInstruction_smuadx_ls_r11_r4_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r11_r8_r9),
    kInstruction_smuadx_hi_r11_r8_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vs_r2_r14_r13),
    kInstruction_smuadx_vs_r2_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_al_r1_r13_r9),
    kInstruction_smuadx_al_r1_r13_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r3_r9_r13),
    kInstruction_smuadx_eq_r3_r9_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ge_r10_r3_r13),
    kInstruction_smuadx_ge_r10_r3_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_pl_r8_r5_r10),
    kInstruction_smuadx_pl_r8_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vc_r8_r11_r6),
    kInstruction_smuadx_vc_r8_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r0_r0_r5),
    kInstruction_smuadx_eq_r0_r0_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ne_r6_r5_r8),
    kInstruction_smuadx_ne_r6_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r5_r13_r3),
    kInstruction_smuadx_hi_r5_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ne_r11_r14_r14),
    kInstruction_smuadx_ne_r11_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_mi_r1_r0_r6),
    kInstruction_smuadx_mi_r1_r0_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_le_r14_r8_r2),
    kInstruction_smuadx_le_r14_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r9_r6_r5),
    kInstruction_smuadx_eq_r9_r6_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r11_r0_r13),
    kInstruction_smuadx_eq_r11_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_pl_r4_r5_r14),
    kInstruction_smuadx_pl_r4_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cs_r13_r5_r13),
    kInstruction_smuadx_cs_r13_r5_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_mi_r0_r13_r8),
    kInstruction_smuadx_mi_r0_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_lt_r2_r13_r3),
    kInstruction_smuadx_lt_r2_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ls_r8_r1_r11),
    kInstruction_smuadx_ls_r8_r1_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vc_r14_r11_r8),
    kInstruction_smuadx_vc_r14_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_lt_r4_r13_r12),
    kInstruction_smuadx_lt_r4_r13_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r2_r1_r14),
    kInstruction_smuadx_eq_r2_r1_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r9_r4_r14),
    kInstruction_smuadx_eq_r9_r4_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r10_r6_r13),
    kInstruction_smuadx_hi_r10_r6_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ge_r12_r9_r4),
    kInstruction_smuadx_ge_r12_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_le_r9_r11_r14),
    kInstruction_smuadx_le_r9_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ls_r0_r9_r5),
    kInstruction_smuadx_ls_r0_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_mi_r2_r3_r8),
    kInstruction_smuadx_mi_r2_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ne_r14_r10_r14),
    kInstruction_smuadx_ne_r14_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r6_r2_r10),
    kInstruction_smuadx_eq_r6_r2_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_lt_r11_r0_r12),
    kInstruction_smuadx_lt_r11_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ne_r1_r12_r10),
    kInstruction_smuadx_ne_r1_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cc_r1_r0_r2),
    kInstruction_smuadx_cc_r1_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_al_r5_r5_r7),
    kInstruction_smuadx_al_r5_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r7_r13_r1),
    kInstruction_smuadx_hi_r7_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cs_r4_r4_r9),
    kInstruction_smuadx_cs_r4_r4_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r14_r4_r14),
    kInstruction_smuadx_eq_r14_r4_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vs_r10_r5_r14),
    kInstruction_smuadx_vs_r10_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_gt_r4_r3_r11),
    kInstruction_smuadx_gt_r4_r3_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ne_r14_r10_r12),
    kInstruction_smuadx_ne_r14_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vs_r2_r11_r0),
    kInstruction_smuadx_vs_r2_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ge_r5_r12_r7),
    kInstruction_smuadx_ge_r5_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_mi_r7_r14_r6),
    kInstruction_smuadx_mi_r7_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_gt_r8_r3_r8),
    kInstruction_smuadx_gt_r8_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r9_r14_r3),
    kInstruction_smuadx_hi_r9_r14_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vc_r2_r11_r2),
    kInstruction_smuadx_vc_r2_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r11_r7_r12),
    kInstruction_smuadx_hi_r11_r7_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cs_r6_r4_r11),
    kInstruction_smuadx_cs_r6_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cs_r12_r5_r9),
    kInstruction_smuadx_cs_r12_r5_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ls_r5_r10_r5),
    kInstruction_smuadx_ls_r5_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ls_r0_r9_r13),
    kInstruction_smuadx_ls_r0_r9_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_lt_r3_r3_r5),
    kInstruction_smuadx_lt_r3_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_mi_r0_r12_r8),
    kInstruction_smuadx_mi_r0_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_pl_r3_r12_r12),
    kInstruction_smuadx_pl_r3_r12_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r8_r12_r5),
    kInstruction_smuadx_eq_r8_r12_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cc_r7_r8_r1),
    kInstruction_smuadx_cc_r7_r8_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r2_r13_r10),
    kInstruction_smuadx_hi_r2_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_al_r7_r10_r10),
    kInstruction_smuadx_al_r7_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vc_r1_r12_r2),
    kInstruction_smuadx_vc_r1_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cc_r8_r5_r8),
    kInstruction_smuadx_cc_r8_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ls_r3_r7_r9),
    kInstruction_smuadx_ls_r3_r7_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_al_r8_r10_r8),
    kInstruction_smuadx_al_r8_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_lt_r4_r12_r10),
    kInstruction_smuadx_lt_r4_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ge_r10_r5_r11),
    kInstruction_smuadx_ge_r10_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ls_r3_r14_r4),
    kInstruction_smuadx_ls_r3_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r3_r6_r12),
    kInstruction_smuadx_hi_r3_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r6_r0_r4),
    kInstruction_smuadx_hi_r6_r0_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_al_r11_r6_r0),
    kInstruction_smuadx_al_r11_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_mi_r3_r1_r9),
    kInstruction_smuadx_mi_r3_r1_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_mi_r12_r13_r0),
    kInstruction_smuadx_mi_r12_r13_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_le_r1_r2_r5),
    kInstruction_smuadx_le_r1_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r4_r3_r14),
    kInstruction_smuadx_hi_r4_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r6_r11_r11),
    kInstruction_smuadx_eq_r6_r11_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cc_r14_r11_r14),
    kInstruction_smuadx_cc_r14_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r4_r10_r0),
    kInstruction_smuadx_hi_r4_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cc_r7_r11_r1),
    kInstruction_smuadx_cc_r7_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_mi_r14_r6_r10),
    kInstruction_smuadx_mi_r14_r6_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r2_r0_r11),
    kInstruction_smuadx_eq_r2_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_mi_r13_r5_r12),
    kInstruction_smuadx_mi_r13_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r2_r12_r5),
    kInstruction_smuadx_eq_r2_r12_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_le_r12_r0_r2),
    kInstruction_smuadx_le_r12_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vc_r10_r10_r9),
    kInstruction_smuadx_vc_r10_r10_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ls_r11_r11_r8),
    kInstruction_smuadx_ls_r11_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r10_r11_r9),
    kInstruction_smuadx_hi_r10_r11_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vs_r7_r12_r14),
    kInstruction_smuadx_vs_r7_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_gt_r11_r14_r12),
    kInstruction_smuadx_gt_r11_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vs_r0_r12_r8),
    kInstruction_smuadx_vs_r0_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_al_r0_r5_r7),
    kInstruction_smuadx_al_r0_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r5_r13_r8),
    kInstruction_smuadx_hi_r5_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_le_r9_r9_r7),
    kInstruction_smuadx_le_r9_r9_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cc_r4_r9_r5),
    kInstruction_smuadx_cc_r4_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vs_r8_r1_r3),
    kInstruction_smuadx_vs_r8_r1_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cc_r0_r10_r12),
    kInstruction_smuadx_cc_r0_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r7_r14_r0),
    kInstruction_smuadx_eq_r7_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vs_r12_r9_r11),
    kInstruction_smuadx_vs_r12_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_gt_r5_r9_r11),
    kInstruction_smuadx_gt_r5_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cs_r14_r13_r7),
    kInstruction_smuadx_cs_r14_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_mi_r11_r3_r10),
    kInstruction_smuadx_mi_r11_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r11_r8_r12),
    kInstruction_smuadx_hi_r11_r8_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cs_r3_r8_r13),
    kInstruction_smuadx_cs_r3_r8_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_pl_r10_r12_r6),
    kInstruction_smuadx_pl_r10_r12_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vc_r7_r3_r2),
    kInstruction_smuadx_vc_r7_r3_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_mi_r9_r0_r8),
    kInstruction_smuadx_mi_r9_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r2_r13_r7),
    kInstruction_smuadx_eq_r2_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ne_r2_r14_r0),
    kInstruction_smuadx_ne_r2_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vs_r4_r10_r0),
    kInstruction_smuadx_vs_r4_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ls_r0_r2_r2),
    kInstruction_smuadx_ls_r0_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cc_r1_r6_r0),
    kInstruction_smuadx_cc_r1_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_lt_r12_r0_r8),
    kInstruction_smuadx_lt_r12_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cc_r9_r3_r14),
    kInstruction_smuadx_cc_r9_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vs_r7_r9_r1),
    kInstruction_smuadx_vs_r7_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r11_r9_r14),
    kInstruction_smuadx_eq_r11_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_pl_r6_r10_r4),
    kInstruction_smuadx_pl_r6_r10_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ne_r8_r5_r6),
    kInstruction_smuadx_ne_r8_r5_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cs_r0_r6_r2),
    kInstruction_smuadx_cs_r0_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r11_r12_r4),
    kInstruction_smuadx_eq_r11_r12_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_lt_r14_r3_r14),
    kInstruction_smuadx_lt_r14_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_le_r7_r12_r14),
    kInstruction_smuadx_le_r7_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r2_r9_r9),
    kInstruction_smuadx_hi_r2_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ne_r8_r1_r0),
    kInstruction_smuadx_ne_r8_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cc_r5_r11_r2),
    kInstruction_smuadx_cc_r5_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r0_r1_r2),
    kInstruction_smuadx_hi_r0_r1_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_al_r4_r9_r4),
    kInstruction_smuadx_al_r4_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cs_r12_r7_r14),
    kInstruction_smuadx_cs_r12_r7_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cc_r4_r12_r10),
    kInstruction_smuadx_cc_r4_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_al_r3_r5_r10),
    kInstruction_smuadx_al_r3_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_mi_r5_r3_r7),
    kInstruction_smuadx_mi_r5_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ls_r10_r6_r2),
    kInstruction_smuadx_ls_r10_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_mi_r0_r12_r11),
    kInstruction_smuadx_mi_r0_r12_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vc_r12_r5_r6),
    kInstruction_smuadx_vc_r12_r5_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cs_r3_r9_r4),
    kInstruction_smuadx_cs_r3_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ls_r4_r9_r11),
    kInstruction_smuadx_ls_r4_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_le_r14_r8_r13),
    kInstruction_smuadx_le_r14_r8_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_gt_r4_r10_r8),
    kInstruction_smuadx_gt_r4_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_al_r6_r9_r9),
    kInstruction_smuadx_al_r6_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ne_r8_r5_r12),
    kInstruction_smuadx_ne_r8_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ne_r0_r4_r8),
    kInstruction_smuadx_ne_r0_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_mi_r7_r13_r3),
    kInstruction_smuadx_mi_r7_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cc_r11_r7_r0),
    kInstruction_smuadx_cc_r11_r7_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r1_r0_r12),
    kInstruction_smuadx_hi_r1_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_lt_r8_r9_r3),
    kInstruction_smuadx_lt_r8_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_al_r0_r2_r1),
    kInstruction_smuadx_al_r0_r2_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vs_r4_r3_r14),
    kInstruction_smuadx_vs_r4_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ge_r2_r11_r1),
    kInstruction_smuadx_ge_r2_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_lt_r12_r9_r6),
    kInstruction_smuadx_lt_r12_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ls_r8_r2_r7),
    kInstruction_smuadx_ls_r8_r2_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_le_r8_r13_r3),
    kInstruction_smuadx_le_r8_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r11_r13_r14),
    kInstruction_smuadx_eq_r11_r13_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_lt_r1_r6_r13),
    kInstruction_smuadx_lt_r1_r6_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cs_r3_r8_r11),
    kInstruction_smuadx_cs_r3_r8_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_pl_r12_r5_r4),
    kInstruction_smuadx_pl_r12_r5_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r8_r7_r2),
    kInstruction_smuadx_eq_r8_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ls_r2_r12_r2),
    kInstruction_smuadx_ls_r2_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_le_r14_r2_r3),
    kInstruction_smuadx_le_r14_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ge_r10_r11_r6),
    kInstruction_smuadx_ge_r10_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r0_r2_r2),
    kInstruction_smuadx_hi_r0_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ge_r2_r0_r2),
    kInstruction_smuadx_ge_r2_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vs_r11_r14_r0),
    kInstruction_smuadx_vs_r11_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_lt_r2_r0_r1),
    kInstruction_smuadx_lt_r2_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cs_r2_r5_r11),
    kInstruction_smuadx_cs_r2_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ls_r7_r14_r5),
    kInstruction_smuadx_ls_r7_r14_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_pl_r0_r0_r3),
    kInstruction_smuadx_pl_r0_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ge_r6_r8_r8),
    kInstruction_smuadx_ge_r6_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_le_r11_r1_r10),
    kInstruction_smuadx_le_r11_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vs_r5_r2_r7),
    kInstruction_smuadx_vs_r5_r2_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ne_r4_r4_r8),
    kInstruction_smuadx_ne_r4_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cc_r9_r14_r13),
    kInstruction_smuadx_cc_r9_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r14_r6_r3),
    kInstruction_smuadx_hi_r14_r6_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_al_r0_r8_r0),
    kInstruction_smuadx_al_r0_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_lt_r6_r11_r1),
    kInstruction_smuadx_lt_r6_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ge_r7_r6_r12),
    kInstruction_smuadx_ge_r7_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cs_r4_r6_r14),
    kInstruction_smuadx_cs_r4_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cs_r7_r6_r7),
    kInstruction_smuadx_cs_r7_r6_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cs_r3_r7_r10),
    kInstruction_smuadx_cs_r3_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ne_r0_r2_r1),
    kInstruction_smuadx_ne_r0_r2_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vs_r9_r10_r13),
    kInstruction_smuadx_vs_r9_r10_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vc_r11_r14_r12),
    kInstruction_smuadx_vc_r11_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ge_r14_r8_r7),
    kInstruction_smuadx_ge_r14_r8_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_lt_r13_r0_r11),
    kInstruction_smuadx_lt_r13_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_lt_r14_r13_r4),
    kInstruction_smuadx_lt_r14_r13_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_al_r1_r10_r9),
    kInstruction_smuadx_al_r1_r10_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ge_r11_r14_r11),
    kInstruction_smuadx_ge_r11_r14_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cs_r11_r4_r11),
    kInstruction_smuadx_cs_r11_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ge_r0_r14_r7),
    kInstruction_smuadx_ge_r0_r14_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_mi_r1_r2_r9),
    kInstruction_smuadx_mi_r1_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r5_r12_r3),
    kInstruction_smuadx_eq_r5_r12_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ge_r1_r5_r12),
    kInstruction_smuadx_ge_r1_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_lt_r10_r11_r4),
    kInstruction_smuadx_lt_r10_r11_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_le_r1_r1_r5),
    kInstruction_smuadx_le_r1_r1_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_al_r9_r1_r8),
    kInstruction_smuadx_al_r9_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ne_r6_r8_r4),
    kInstruction_smuadx_ne_r6_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ge_r12_r2_r9),
    kInstruction_smuadx_ge_r12_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_pl_r4_r3_r10),
    kInstruction_smuadx_pl_r4_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r14_r4_r11),
    kInstruction_smuadx_eq_r14_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cc_r9_r7_r6),
    kInstruction_smuadx_cc_r9_r7_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ge_r12_r4_r5),
    kInstruction_smuadx_ge_r12_r4_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r2_r3_r4),
    kInstruction_smuadx_hi_r2_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cs_r0_r3_r1),
    kInstruction_smuadx_cs_r0_r3_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r6_r2_r8),
    kInstruction_smuadx_hi_r6_r2_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cc_r3_r14_r13),
    kInstruction_smuadx_cc_r3_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_gt_r11_r4_r7),
    kInstruction_smuadx_gt_r11_r4_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r5_r0_r12),
    kInstruction_smuadx_hi_r5_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_gt_r0_r14_r14),
    kInstruction_smuadx_gt_r0_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r9_r0_r10),
    kInstruction_smuadx_hi_r9_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vc_r7_r11_r8),
    kInstruction_smuadx_vc_r7_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_pl_r11_r9_r6),
    kInstruction_smuadx_pl_r11_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_al_r3_r3_r7),
    kInstruction_smuadx_al_r3_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_mi_r5_r7_r9),
    kInstruction_smuadx_mi_r5_r7_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cc_r11_r2_r4),
    kInstruction_smuadx_cc_r11_r2_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cc_r9_r13_r10),
    kInstruction_smuadx_cc_r9_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_al_r5_r2_r6),
    kInstruction_smuadx_al_r5_r2_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ge_r9_r4_r6),
    kInstruction_smuadx_ge_r9_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ls_r3_r3_r4),
    kInstruction_smuadx_ls_r3_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ge_r14_r1_r8),
    kInstruction_smuadx_ge_r14_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ls_r7_r12_r7),
    kInstruction_smuadx_ls_r7_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_al_r11_r10_r5),
    kInstruction_smuadx_al_r11_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_al_r7_r4_r6),
    kInstruction_smuadx_al_r7_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vs_r12_r4_r10),
    kInstruction_smuadx_vs_r12_r4_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r4_r4_r4),
    kInstruction_smuadx_eq_r4_r4_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vs_r6_r6_r12),
    kInstruction_smuadx_vs_r6_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_pl_r9_r3_r5),
    kInstruction_smuadx_pl_r9_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r6_r5_r13),
    kInstruction_smuadx_eq_r6_r5_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cc_r8_r2_r12),
    kInstruction_smuadx_cc_r8_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_le_r4_r2_r0),
    kInstruction_smuadx_le_r4_r2_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_lt_r7_r9_r8),
    kInstruction_smuadx_lt_r7_r9_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_le_r4_r7_r11),
    kInstruction_smuadx_le_r4_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r5_r7_r5),
    kInstruction_smuadx_eq_r5_r7_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vc_r10_r7_r12),
    kInstruction_smuadx_vc_r10_r7_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r7_r10_r6),
    kInstruction_smuadx_eq_r7_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_pl_r1_r12_r2),
    kInstruction_smuadx_pl_r1_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_le_r14_r6_r6),
    kInstruction_smuadx_le_r14_r6_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ne_r3_r8_r8),
    kInstruction_smuadx_ne_r3_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r4_r12_r8),
    kInstruction_smuadx_eq_r4_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ge_r11_r2_r3),
    kInstruction_smuadx_ge_r11_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_hi_r12_r6_r11),
    kInstruction_smuadx_hi_r12_r6_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_cs_r4_r5_r10),
    kInstruction_smuadx_cs_r4_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ge_r10_r2_r10),
    kInstruction_smuadx_ge_r10_r2_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ge_r5_r14_r6),
    kInstruction_smuadx_ge_r5_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_gt_r13_r7_r5),
    kInstruction_smuadx_gt_r13_r7_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_ge_r13_r4_r12),
    kInstruction_smuadx_ge_r13_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_lt_r8_r10_r14),
    kInstruction_smuadx_lt_r8_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_le_r4_r3_r13),
    kInstruction_smuadx_le_r4_r3_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_pl_r0_r9_r0),
    kInstruction_smuadx_pl_r0_r9_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_eq_r2_r3_r1),
    kInstruction_smuadx_eq_r2_r3_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_vc_r0_r0_r3),
    kInstruction_smuadx_vc_r0_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_mi_r10_r8_r11),
    kInstruction_smuadx_mi_r10_r8_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_mi_r5_r14_r14),
    kInstruction_smuadx_mi_r5_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_gt_r5_r11_r2),
    kInstruction_smuadx_gt_r5_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smuadx_al_r4_r7_r11),
    kInstruction_smuadx_al_r4_r7_r11,
  },
};

#endif  // VIXL_ASSEMBLER_COND_RD_RN_RM_SMUADX_A32_H_
