// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UABAL_4S_TRACE_AARCH64_H_
#define VIXL_SIM_UABAL_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_uabal_4S[] = {
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x000032b5, 0x00002224, 0x00002ac8,
  0x000032b5, 0x000054d7, 0x00004ccc, 0x00002ac9,
  0x000054d7, 0x00007f7f, 0x00004ccd, 0x00002aca,
  0x00007f7f, 0x00007f80, 0x00004cce, 0x00005575,
  0x00007f80, 0x00007f81, 0x00003335, 0x00005574,
  0x00007f81, 0x00000080, 0x00003334, 0x00005573,
  0x0000007e, 0x0000007f, 0x00003333, 0x00005565,
  0x0000007d, 0x0000007e, 0x00003325, 0x000054f8,
  0x0000007c, 0x00000070, 0x000032b8, 0x000054f7,
  0x0000006e, 0x00000003, 0x000032b7, 0x000054f6,
  0x00000001, 0x00000002, 0x000032b6, 0x00002242,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x000032b5, 0x00002224, 0x00002ac8,
  0x000032b5, 0x000054d7, 0x00004ccc, 0x00002ac9,
  0x000054d7, 0x00007f7f, 0x00004ccd, 0x00002aca,
  0x00007f7f, 0x00007f80, 0x00004cce, 0x00002acb,
  0x00007f80, 0x00007f81, 0x00004ccf, 0x00002acc,
  0x00007f81, 0x00007f82, 0x00004cd0, 0x00005575,
  0x00007f82, 0x00007f83, 0x00007779, 0x00007797,
  0x00007f83, 0x0000aa2c, 0x0000999b, 0x0000aa4b,
  0x0000aa2c, 0x0000cc4e, 0x0000cc4f, 0x0000aa4c,
  0x0000cc4e, 0x0000ff02, 0x0000cc50, 0x0000aa4d,
  0x0000ff02, 0x0000ff03, 0x0000cc51, 0x0000aa4e,
  0x0000ff02, 0x0000cc50, 0x0000aa30, 0x00008013,
  0x0000ff03, 0x0000cc51, 0x0000aa9d, 0x00008020,
  0x0000ff04, 0x0000ccbe, 0x0000aaaa, 0x00008021,
  0x0000ff71, 0x0000cccb, 0x0000aaab, 0x00008022,
  0x0000ff7e, 0x0000cccc, 0x0000aaac, 0x0000801d,
  0x0000ff7f, 0x0000cccd, 0x00005557, 0x0000801c,
  0x0000ff80, 0x00003334, 0x00005556, 0x0000801b,
  0x0000007f, 0x00003333, 0x00005555, 0x0000800d,
  0x0000007e, 0x00003332, 0x00005547, 0x00007fa0,
  0x0000007d, 0x00003324, 0x000054da, 0x00007f9f,
  0x0000006f, 0x000032b7, 0x000054d9, 0x00007f9e,
  0x00000002, 0x000032b6, 0x000054d8, 0x00004cea,
  0x00000001, 0x000032b5, 0x00002224, 0x00002ac8,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x000032b4, 0x00002223, 0x00002aaa, 0x00000021,
  0x000054d6, 0x00004ccb, 0x00002aab, 0x00000022,
  0x00007f7e, 0x00004ccc, 0x00002aac, 0x00000023,
  0x00007f7f, 0x00004ccd, 0x00002aad, 0x00000024,
  0x00007f80, 0x00004cce, 0x00002aae, 0x00002acd,
  0x00007f81, 0x00004ccf, 0x00005557, 0x00004cef,
  0x00007f82, 0x00007778, 0x00007779, 0x00007fa3,
  0x0000aa2b, 0x0000999a, 0x0000aa2d, 0x00007fa4,
  0x0000cc4d, 0x0000cc4e, 0x0000aa2e, 0x00007fa5,
  0x0000ff01, 0x0000cc4f, 0x0000aa2f, 0x00007fa6,
  0x0000cc4e, 0x0000aa2e, 0x00007f88, 0x00008012,
  0x0000cc4f, 0x0000aa2f, 0x00007ff5, 0x0000801f,
  0x0000cc50, 0x0000aa9c, 0x00008002, 0x00008020,
  0x0000ccbd, 0x0000aaa9, 0x00008003, 0x00008021,
  0x0000ccca, 0x0000aaaa, 0x00008004, 0x0000801e,
  0x0000cccb, 0x0000aaab, 0x00007fff, 0x0000801d,
  0x0000cccc, 0x00005556, 0x00007ffe, 0x0000801c,
  0x00003333, 0x00005555, 0x00007ffd, 0x0000800e,
  0x00003332, 0x00005554, 0x00007fef, 0x00007fa1,
  0x00003331, 0x00005546, 0x00007f82, 0x00007fa0,
  0x00003323, 0x000054d9, 0x00007f81, 0x00007f9f,
  0x000032b6, 0x000054d8, 0x00007f80, 0x00004ceb,
  0x000032b5, 0x000054d7, 0x00004ccc, 0x00002ac9,
  0x000032b4, 0x00002223, 0x00002aaa, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00002222, 0x00002aa9, 0x00000003, 0x00000021,
  0x00004cca, 0x00002aaa, 0x00000004, 0x00000022,
  0x00004ccb, 0x00002aab, 0x00000005, 0x00000023,
  0x00004ccc, 0x00002aac, 0x00000006, 0x00002acc,
  0x00004ccd, 0x00002aad, 0x00002aaf, 0x00004cee,
  0x00004cce, 0x00005556, 0x00004cd1, 0x00007fa2,
  0x00007777, 0x00007778, 0x00007f85, 0x00007fa3,
  0x00009999, 0x0000aa2c, 0x00007f86, 0x00007fa4,
  0x0000cc4d, 0x0000aa2d, 0x00007f87, 0x00007fa5,
  0x0000aa2c, 0x00007f86, 0x00007f87, 0x00008011,
  0x0000aa2d, 0x00007f87, 0x00007ff4, 0x0000801e,
  0x0000aa2e, 0x00007ff4, 0x00008001, 0x0000801f,
  0x0000aa9b, 0x00008001, 0x00008002, 0x00008020,
  0x0000aaa8, 0x00008002, 0x00008003, 0x0000801f,
  0x0000aaa9, 0x00008003, 0x00008000, 0x0000801e,
  0x0000aaaa, 0x00007ffe, 0x00007fff, 0x0000801d,
  0x00005555, 0x00007ffd, 0x00007ffe, 0x0000800f,
  0x00005554, 0x00007ffc, 0x00007ff0, 0x00007fa2,
  0x00005553, 0x00007fee, 0x00007f83, 0x00007fa1,
  0x00005545, 0x00007f81, 0x00007f82, 0x00007fa0,
  0x000054d8, 0x00007f80, 0x00007f81, 0x00004cec,
  0x000054d7, 0x00007f7f, 0x00004ccd, 0x00002aca,
  0x000054d6, 0x00004ccb, 0x00002aab, 0x00000022,
  0x00002222, 0x00002aa9, 0x00000003, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00002aa8, 0x00000002, 0x00000003, 0x00000021,
  0x00002aa9, 0x00000003, 0x00000004, 0x00000022,
  0x00002aaa, 0x00000004, 0x00000005, 0x00002acb,
  0x00002aab, 0x00000005, 0x00002aae, 0x00004ced,
  0x00002aac, 0x00002aae, 0x00004cd0, 0x00007fa1,
  0x00005555, 0x00004cd0, 0x00007f84, 0x00007fa2,
  0x00007777, 0x00007f84, 0x00007f85, 0x00007fa3,
  0x0000aa2b, 0x00007f85, 0x00007f86, 0x00007fa4,
  0x00007f84, 0x00007f85, 0x00007f86, 0x00010010,
  0x00007f85, 0x00007f86, 0x00007ff3, 0x0001001d,
  0x00007f86, 0x00007ff3, 0x00008000, 0x0001001e,
  0x00007ff3, 0x00008000, 0x00008001, 0x0001001f,
  0x00008000, 0x00008001, 0x00008002, 0x00000020,
  0x00008001, 0x00008002, 0x00008001, 0x00000021,
  0x00008002, 0x00007fff, 0x00008000, 0x00000022,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x00000030,
  0x00007ffc, 0x00007ffd, 0x00007ff1, 0x0000009d,
  0x00007ffb, 0x00007fef, 0x00007f84, 0x0000009e,
  0x00007fed, 0x00007f82, 0x00007f83, 0x0000009f,
  0x00007f80, 0x00007f81, 0x00007f82, 0x00003353,
  0x00007f7f, 0x00007f80, 0x00004cce, 0x00005575,
  0x00007f7e, 0x00004ccc, 0x00002aac, 0x0000801d,
  0x00004cca, 0x00002aaa, 0x00000004, 0x0000801e,
  0x00002aa8, 0x00000002, 0x00000003, 0x0000801f,
  0x00000000, 0x00000001, 0x00000002, 0x00008020,
  0x00000001, 0x00000002, 0x00000003, 0x00008021,
  0x00000002, 0x00000003, 0x00000004, 0x0000aaca,
  0x00000003, 0x00000004, 0x00002aad, 0x0000ccec,
  0x00000004, 0x00002aad, 0x00004ccf, 0x0000ffa0,
  0x00002aad, 0x00004ccf, 0x00007f83, 0x0000ffa1,
  0x00004ccf, 0x00007f83, 0x00007f84, 0x0000ffa2,
  0x00007f83, 0x00007f84, 0x00007f85, 0x0000ffa3,
  0x00007f83, 0x00007f84, 0x0000ff85, 0x0001000f,
  0x00007f84, 0x00007f85, 0x0000fff2, 0x0001001c,
  0x00007f85, 0x00007ff2, 0x0000ffff, 0x0001001d,
  0x00007ff2, 0x00007fff, 0x00010000, 0x0001001e,
  0x00007fff, 0x00008000, 0x00010001, 0x00000021,
  0x00008000, 0x00008001, 0x00000002, 0x00000020,
  0x00008001, 0x00008000, 0x00000003, 0x00000021,
  0x00007ffe, 0x00007fff, 0x00000004, 0x0000002f,
  0x00007ffd, 0x00007ffe, 0x00000012, 0x0000009c,
  0x00007ffc, 0x00007ff0, 0x0000007f, 0x0000009d,
  0x00007fee, 0x00007f83, 0x00000080, 0x0000009e,
  0x00007f81, 0x00007f82, 0x00000081, 0x00003352,
  0x00007f80, 0x00007f81, 0x00003335, 0x00005574,
  0x00007f7f, 0x00004ccd, 0x00005557, 0x0000801c,
  0x00004ccb, 0x00002aab, 0x00007fff, 0x0000801d,
  0x00002aa9, 0x00000003, 0x00008000, 0x0000801e,
  0x00000001, 0x00000002, 0x00008001, 0x0000801f,
  0x00000000, 0x00000001, 0x00008002, 0x00008020,
  0x00000001, 0x00000002, 0x00008003, 0x0000aac9,
  0x00000002, 0x00000003, 0x0000aaac, 0x0000cceb,
  0x00000003, 0x00002aac, 0x0000ccce, 0x0000ff9f,
  0x00002aac, 0x00004cce, 0x0000ff82, 0x0000ffa0,
  0x00004cce, 0x00007f82, 0x0000ff83, 0x0000ffa1,
  0x00007f82, 0x00007f83, 0x0000ff84, 0x0000ffa2,
  0x00007f82, 0x0000ff83, 0x0000ff84, 0x0001000e,
  0x00007f83, 0x0000ff84, 0x0000fff1, 0x0001001b,
  0x00007f84, 0x0000fff1, 0x0000fffe, 0x0001001c,
  0x00007ff1, 0x0000fffe, 0x0000ffff, 0x0001001d,
  0x00007ffe, 0x0000ffff, 0x00010000, 0x00000022,
  0x00007fff, 0x00010000, 0x00000003, 0x00000021,
  0x00008000, 0x00000001, 0x00000002, 0x00000020,
  0x00007fff, 0x00000002, 0x00000003, 0x0000002e,
  0x00007ffe, 0x00000003, 0x00000011, 0x0000009b,
  0x00007ffd, 0x00000011, 0x0000007e, 0x0000009c,
  0x00007fef, 0x0000007e, 0x0000007f, 0x0000009d,
  0x00007f82, 0x0000007f, 0x00000080, 0x00003351,
  0x00007f81, 0x00000080, 0x00003334, 0x00005573,
  0x00007f80, 0x00003334, 0x00005556, 0x0000801b,
  0x00004ccc, 0x00005556, 0x00007ffe, 0x0000801c,
  0x00002aaa, 0x00007ffe, 0x00007fff, 0x0000801d,
  0x00000002, 0x00007fff, 0x00008000, 0x0000801e,
  0x00000001, 0x00008000, 0x00008001, 0x0000801f,
  0x00000000, 0x00008001, 0x00008002, 0x0000aac8,
  0x00000001, 0x00008002, 0x0000aaab, 0x0000ccea,
  0x00000002, 0x0000aaab, 0x0000cccd, 0x0000ff9e,
  0x00002aab, 0x0000cccd, 0x0000ff81, 0x0000ff9f,
  0x00004ccd, 0x0000ff81, 0x0000ff82, 0x0000ffa0,
  0x00007f81, 0x0000ff82, 0x0000ff83, 0x0000ffa1,
  0x0000ff81, 0x0000ff82, 0x0000ff83, 0x00010000,
  0x0000ff82, 0x0000ff83, 0x0000fff0, 0x0001000d,
  0x0000ff83, 0x0000fff0, 0x0000fffd, 0x0001000e,
  0x0000fff0, 0x0000fffd, 0x0000fffe, 0x0001000f,
  0x0000fffd, 0x0000fffe, 0x0000ffff, 0x00000030,
  0x0000fffe, 0x0000ffff, 0x00000004, 0x0000002f,
  0x0000ffff, 0x00000002, 0x00000003, 0x0000002e,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00000010, 0x0000008d,
  0x00000002, 0x00000010, 0x0000007d, 0x0000008e,
  0x00000010, 0x0000007d, 0x0000007e, 0x0000008f,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00003343,
  0x0000007e, 0x0000007f, 0x00003333, 0x00005565,
  0x0000007f, 0x00003333, 0x00005555, 0x0000800d,
  0x00003333, 0x00005555, 0x00007ffd, 0x0000800e,
  0x00005555, 0x00007ffd, 0x00007ffe, 0x0000800f,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x00008010,
  0x00007ffe, 0x00007fff, 0x00008000, 0x00008011,
  0x00007fff, 0x00008000, 0x00008001, 0x0000aaba,
  0x00008000, 0x00008001, 0x0000aaaa, 0x0000ccdc,
  0x00008001, 0x0000aaaa, 0x0000cccc, 0x0000ff90,
  0x0000aaaa, 0x0000cccc, 0x0000ff80, 0x0000ff91,
  0x0000cccc, 0x0000ff80, 0x0000ff81, 0x0000ff92,
  0x0000ff80, 0x0000ff81, 0x0000ff82, 0x0000ff93,
  0x0000ff80, 0x0000ff81, 0x0000ff75, 0x0000ff93,
  0x0000ff81, 0x0000ff82, 0x0000ffe2, 0x0000ffa0,
  0x0000ff82, 0x0000ffef, 0x0000ffef, 0x0000ffa1,
  0x0000ffef, 0x0000fffc, 0x0000fff0, 0x0000ffa2,
  0x0000fffc, 0x0000fffd, 0x0000fff1, 0x0000009d,
  0x0000fffd, 0x0000fffe, 0x00000012, 0x0000009c,
  0x0000fffe, 0x00000003, 0x00000011, 0x0000009b,
  0x00000001, 0x00000002, 0x00000010, 0x0000008d,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x0000000f, 0x0000006f, 0x00000021,
  0x0000000f, 0x0000007c, 0x00000070, 0x00000022,
  0x0000007c, 0x0000007d, 0x00000071, 0x000032d6,
  0x0000007d, 0x0000007e, 0x00003325, 0x000054f8,
  0x0000007e, 0x00003332, 0x00005547, 0x00007fa0,
  0x00003332, 0x00005554, 0x00007fef, 0x00007fa1,
  0x00005554, 0x00007ffc, 0x00007ff0, 0x00007fa2,
  0x00007ffc, 0x00007ffd, 0x00007ff1, 0x00007fa3,
  0x00007ffd, 0x00007ffe, 0x00007ff2, 0x00007fa4,
  0x00007ffe, 0x00007fff, 0x00007ff3, 0x0000aa4d,
  0x00007fff, 0x00008000, 0x0000aa9c, 0x0000cc6f,
  0x00008000, 0x0000aaa9, 0x0000ccbe, 0x0000ff23,
  0x0000aaa9, 0x0000cccb, 0x0000ff72, 0x0000ff24,
  0x0000cccb, 0x0000ff7f, 0x0000ff73, 0x0000ff25,
  0x0000ff7f, 0x0000ff80, 0x0000ff74, 0x0000ff26,
  0x0000ff7f, 0x0000ff73, 0x0000ff08, 0x0000ff92,
  0x0000ff80, 0x0000ff74, 0x0000ff75, 0x0000ff9f,
  0x0000ff81, 0x0000ffe1, 0x0000ff82, 0x0000ffa0,
  0x0000ffee, 0x0000ffee, 0x0000ff83, 0x0000ffa1,
  0x0000fffb, 0x0000ffef, 0x0000ff84, 0x0000009e,
  0x0000fffc, 0x0000fff0, 0x0000007f, 0x0000009d,
  0x0000fffd, 0x00000011, 0x0000007e, 0x0000009c,
  0x00000002, 0x00000010, 0x0000007d, 0x0000008e,
  0x00000001, 0x0000000f, 0x0000006f, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000000e, 0x0000006e, 0x00000003, 0x00000021,
  0x0000007b, 0x0000006f, 0x00000004, 0x000032d5,
  0x0000007c, 0x00000070, 0x000032b8, 0x000054f7,
  0x0000007d, 0x00003324, 0x000054da, 0x00007f9f,
  0x00003331, 0x00005546, 0x00007f82, 0x00007fa0,
  0x00005553, 0x00007fee, 0x00007f83, 0x00007fa1,
  0x00007ffb, 0x00007fef, 0x00007f84, 0x00007fa2,
  0x00007ffc, 0x00007ff0, 0x00007f85, 0x00007fa3,
  0x00007ffd, 0x00007ff1, 0x00007f86, 0x0000aa4c,
  0x00007ffe, 0x00007ff2, 0x0000aa2f, 0x0000cc6e,
  0x00007fff, 0x0000aa9b, 0x0000cc51, 0x0000ff22,
  0x0000aaa8, 0x0000ccbd, 0x0000ff05, 0x0000ff23,
  0x0000ccca, 0x0000ff71, 0x0000ff06, 0x0000ff24,
  0x0000ff7e, 0x0000ff72, 0x0000ff07, 0x0000ff25,
  0x0000ff71, 0x0000ff06, 0x0000ff07, 0x0000ff91,
  0x0000ff72, 0x0000ff07, 0x0000ff74, 0x0000ff9e,
  0x0000ff73, 0x0000ff74, 0x0000ff81, 0x0000ff9f,
  0x0000ffe0, 0x0000ff81, 0x0000ff82, 0x0000ffa0,
  0x0000ffed, 0x0000ff82, 0x0000ff83, 0x0000009f,
  0x0000ffee, 0x0000ff83, 0x00000080, 0x0000009e,
  0x0000ffef, 0x0000007e, 0x0000007f, 0x0000009d,
  0x00000010, 0x0000007d, 0x0000007e, 0x0000008f,
  0x0000000f, 0x0000007c, 0x00000070, 0x00000022,
  0x0000000e, 0x0000006e, 0x00000003, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000006d, 0x00000002, 0x00000003, 0x000032d4,
  0x0000006e, 0x00000003, 0x000032b7, 0x000054f6,
  0x0000006f, 0x000032b7, 0x000054d9, 0x00007f9e,
  0x00003323, 0x000054d9, 0x00007f81, 0x00007f9f,
  0x00005545, 0x00007f81, 0x00007f82, 0x00007fa0,
  0x00007fed, 0x00007f82, 0x00007f83, 0x00007fa1,
  0x00007fee, 0x00007f83, 0x00007f84, 0x00007fa2,
  0x00007fef, 0x00007f84, 0x00007f85, 0x0000aa4b,
  0x00007ff0, 0x00007f85, 0x0000aa2e, 0x0000cc6d,
  0x00007ff1, 0x0000aa2e, 0x0000cc50, 0x0000ff21,
  0x0000aa9a, 0x0000cc50, 0x0000ff04, 0x0000ff22,
  0x0000ccbc, 0x0000ff04, 0x0000ff05, 0x0000ff23,
  0x0000ff70, 0x0000ff05, 0x0000ff06, 0x0000ff24,
  0x0000ff04, 0x0000ff05, 0x0000ff06, 0x0000ccdd,
  0x0000ff05, 0x0000ff06, 0x0000ff73, 0x0000ccea,
  0x0000ff06, 0x0000ff73, 0x0000ff80, 0x0000cceb,
  0x0000ff73, 0x0000ff80, 0x0000ff81, 0x0000ccec,
  0x0000ff80, 0x0000ff81, 0x0000ff82, 0x00003353,
  0x0000ff81, 0x0000ff82, 0x00000081, 0x00003352,
  0x0000ff82, 0x0000007f, 0x00000080, 0x00003351,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00003343,
  0x0000007c, 0x0000007d, 0x00000071, 0x000032d6,
  0x0000007b, 0x0000006f, 0x00000004, 0x000032d5,
  0x0000006d, 0x00000002, 0x00000003, 0x000032d4,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x000032b6, 0x00002242,
  0x00000002, 0x000032b6, 0x000054d8, 0x00004cea,
  0x000032b6, 0x000054d8, 0x00007f80, 0x00004ceb,
  0x000054d8, 0x00007f80, 0x00007f81, 0x00004cec,
  0x00007f80, 0x00007f81, 0x00007f82, 0x00004ced,
  0x00007f81, 0x00007f82, 0x00007f83, 0x00004cee,
  0x00007f82, 0x00007f83, 0x00007f84, 0x00007797,
  0x00007f83, 0x00007f84, 0x0000aa2d, 0x000099b9,
  0x00007f84, 0x0000aa2d, 0x0000cc4f, 0x0000cc6d,
  0x0000aa2d, 0x0000cc4f, 0x0000ff03, 0x0000cc6e,
  0x0000cc4f, 0x0000ff03, 0x0000ff04, 0x0000cc6f,
  0x0000ff03, 0x0000ff04, 0x0000ff05, 0x0000cc70,
  0x0000ff03, 0x0000ff04, 0x0000cc52, 0x0000aabb,
  0x0000ff04, 0x0000ff05, 0x0000ccbf, 0x0000aac8,
  0x0000ff05, 0x0000ff72, 0x0000cccc, 0x0000aac9,
  0x0000ff72, 0x0000ff7f, 0x0000cccd, 0x0000aaca,
  0x0000ff7f, 0x0000ff80, 0x0000ccce, 0x00005575,
  0x0000ff80, 0x0000ff81, 0x00003335, 0x00005574,
  0x0000ff81, 0x00000080, 0x00003334, 0x00005573,
  0x0000007e, 0x0000007f, 0x00003333, 0x00005565,
  0x0000007d, 0x0000007e, 0x00003325, 0x000054f8,
  0x0000007c, 0x00000070, 0x000032b8, 0x000054f7,
  0x0000006e, 0x00000003, 0x000032b7, 0x000054f6,
  0x00000001, 0x00000002, 0x000032b6, 0x00002242,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x000032b5, 0x00002224, 0x00002ac8,
  0x000032b5, 0x000054d7, 0x00004ccc, 0x00002ac9,
  0x000054d7, 0x00007f7f, 0x00004ccd, 0x00002aca,
  0x00007f7f, 0x00007f80, 0x00004cce, 0x00002acb,
  0x00007f80, 0x00007f81, 0x00004ccf, 0x00002acc,
  0x00007f81, 0x00007f82, 0x00004cd0, 0x00005575,
  0x00007f82, 0x00007f83, 0x00007779, 0x00007797,
  0x00007f83, 0x0000aa2c, 0x0000999b, 0x0000aa4b,
  0x0000aa2c, 0x0000cc4e, 0x0000cc4f, 0x0000aa4c,
  0x0000cc4e, 0x0000ff02, 0x0000cc50, 0x0000aa4d,
  0x0000ff02, 0x0000ff03, 0x0000cc51, 0x0000aa4e,
  0x0000ff02, 0x0000cc50, 0x0000aa30, 0x00008013,
  0x0000ff03, 0x0000cc51, 0x0000aa9d, 0x00008020,
  0x0000ff04, 0x0000ccbe, 0x0000aaaa, 0x00008021,
  0x0000ff71, 0x0000cccb, 0x0000aaab, 0x00008022,
  0x0000ff7e, 0x0000cccc, 0x0000aaac, 0x0000801d,
  0x0000ff7f, 0x0000cccd, 0x00005557, 0x0000801c,
  0x0000ff80, 0x00003334, 0x00005556, 0x0000801b,
  0x0000007f, 0x00003333, 0x00005555, 0x0000800d,
  0x0000007e, 0x00003332, 0x00005547, 0x00007fa0,
  0x0000007d, 0x00003324, 0x000054da, 0x00007f9f,
  0x0000006f, 0x000032b7, 0x000054d9, 0x00007f9e,
  0x00000002, 0x000032b6, 0x000054d8, 0x00004cea,
  0x00000001, 0x000032b5, 0x00002224, 0x00002ac8,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x000032b4, 0x00002223, 0x00002aaa, 0x00000021,
  0x000054d6, 0x00004ccb, 0x00002aab, 0x00000022,
  0x00007f7e, 0x00004ccc, 0x00002aac, 0x00000023,
  0x00007f7f, 0x00004ccd, 0x00002aad, 0x00000024,
  0x00007f80, 0x00004cce, 0x00002aae, 0x00002acd,
  0x00007f81, 0x00004ccf, 0x00005557, 0x00004cef,
  0x00007f82, 0x00007778, 0x00007779, 0x00007fa3,
  0x0000aa2b, 0x0000999a, 0x0000aa2d, 0x00007fa4,
  0x0000cc4d, 0x0000cc4e, 0x0000aa2e, 0x00007fa5,
  0x0000ff01, 0x0000cc4f, 0x0000aa2f, 0x00007fa6,
  0x0000cc4e, 0x0000aa2e, 0x00007f88, 0x00008012,
  0x0000cc4f, 0x0000aa2f, 0x00007ff5, 0x0000801f,
  0x0000cc50, 0x0000aa9c, 0x00008002, 0x00008020,
  0x0000ccbd, 0x0000aaa9, 0x00008003, 0x00008021,
  0x0000ccca, 0x0000aaaa, 0x00008004, 0x0000801e,
  0x0000cccb, 0x0000aaab, 0x00007fff, 0x0000801d,
  0x0000cccc, 0x00005556, 0x00007ffe, 0x0000801c,
  0x00003333, 0x00005555, 0x00007ffd, 0x0000800e,
  0x00003332, 0x00005554, 0x00007fef, 0x00007fa1,
  0x00003331, 0x00005546, 0x00007f82, 0x00007fa0,
  0x00003323, 0x000054d9, 0x00007f81, 0x00007f9f,
  0x000032b6, 0x000054d8, 0x00007f80, 0x00004ceb,
  0x000032b5, 0x000054d7, 0x00004ccc, 0x00002ac9,
  0x000032b4, 0x00002223, 0x00002aaa, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00002222, 0x00002aa9, 0x00000003, 0x00000021,
  0x00004cca, 0x00002aaa, 0x00000004, 0x00000022,
  0x00004ccb, 0x00002aab, 0x00000005, 0x00000023,
  0x00004ccc, 0x00002aac, 0x00000006, 0x00002acc,
  0x00004ccd, 0x00002aad, 0x00002aaf, 0x00004cee,
  0x00004cce, 0x00005556, 0x00004cd1, 0x00007fa2,
  0x00007777, 0x00007778, 0x00007f85, 0x00007fa3,
  0x00009999, 0x0000aa2c, 0x00007f86, 0x00007fa4,
  0x0000cc4d, 0x0000aa2d, 0x00007f87, 0x00007fa5,
  0x0000aa2c, 0x00007f86, 0x00007f87, 0x00008011,
  0x0000aa2d, 0x00007f87, 0x00007ff4, 0x0000801e,
  0x0000aa2e, 0x00007ff4, 0x00008001, 0x0000801f,
  0x0000aa9b, 0x00008001, 0x00008002, 0x00008020,
  0x0000aaa8, 0x00008002, 0x00008003, 0x0000801f,
  0x0000aaa9, 0x00008003, 0x00008000, 0x0000801e,
  0x0000aaaa, 0x00007ffe, 0x00007fff, 0x0000801d,
  0x00005555, 0x00007ffd, 0x00007ffe, 0x0000800f,
  0x00005554, 0x00007ffc, 0x00007ff0, 0x00007fa2,
  0x00005553, 0x00007fee, 0x00007f83, 0x00007fa1,
  0x00005545, 0x00007f81, 0x00007f82, 0x00007fa0,
  0x000054d8, 0x00007f80, 0x00007f81, 0x00004cec,
  0x000054d7, 0x00007f7f, 0x00004ccd, 0x00002aca,
  0x000054d6, 0x00004ccb, 0x00002aab, 0x00000022,
  0x00002222, 0x00002aa9, 0x00000003, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00002aa8, 0x00000002, 0x00000003, 0x00000021,
  0x00002aa9, 0x00000003, 0x00000004, 0x00000022,
  0x00002aaa, 0x00000004, 0x00000005, 0x00002acb,
  0x00002aab, 0x00000005, 0x00002aae, 0x00004ced,
  0x00002aac, 0x00002aae, 0x00004cd0, 0x00007fa1,
  0x00005555, 0x00004cd0, 0x00007f84, 0x00007fa2,
  0x00007777, 0x00007f84, 0x00007f85, 0x00007fa3,
  0x0000aa2b, 0x00007f85, 0x00007f86, 0x00007fa4,
  0x00007f84, 0x00007f85, 0x00007f86, 0x00008010,
  0x00007f85, 0x00007f86, 0x00007ff3, 0x0000801d,
  0x00007f86, 0x00007ff3, 0x00008000, 0x0000801e,
  0x00007ff3, 0x00008000, 0x00008001, 0x0000801f,
  0x00008000, 0x00008001, 0x00008002, 0x00008020,
  0x00008001, 0x00008002, 0x00008001, 0x0000801f,
  0x00008002, 0x00007fff, 0x00008000, 0x0000801e,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x00008010,
  0x00007ffc, 0x00007ffd, 0x00007ff1, 0x00007fa3,
  0x00007ffb, 0x00007fef, 0x00007f84, 0x00007fa2,
  0x00007fed, 0x00007f82, 0x00007f83, 0x00007fa1,
  0x00007f80, 0x00007f81, 0x00007f82, 0x00004ced,
  0x00007f7f, 0x00007f80, 0x00004cce, 0x00002acb,
  0x00007f7e, 0x00004ccc, 0x00002aac, 0x00000023,
  0x00004cca, 0x00002aaa, 0x00000004, 0x00000022,
  0x00002aa8, 0x00000002, 0x00000003, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00000003, 0x00000021,
  0x00000002, 0x00000003, 0x00000004, 0x00002aca,
  0x00000003, 0x00000004, 0x00002aad, 0x00004cec,
  0x00000004, 0x00002aad, 0x00004ccf, 0x00007fa0,
  0x00002aad, 0x00004ccf, 0x00007f83, 0x00007fa1,
  0x00004ccf, 0x00007f83, 0x00007f84, 0x00007fa2,
  0x00007f83, 0x00007f84, 0x00007f85, 0x00007fa3,
  0x00007f83, 0x00007f84, 0x00007f85, 0x0000800f,
  0x00007f84, 0x00007f85, 0x00007ff2, 0x0000801c,
  0x00007f85, 0x00007ff2, 0x00007fff, 0x0000801d,
  0x00007ff2, 0x00007fff, 0x00008000, 0x0000801e,
  0x00007fff, 0x00008000, 0x00008001, 0x00008021,
  0x00008000, 0x00008001, 0x00008002, 0x00008020,
  0x00008001, 0x00008000, 0x00008001, 0x0000801f,
  0x00007ffe, 0x00007fff, 0x00008000, 0x00008011,
  0x00007ffd, 0x00007ffe, 0x00007ff2, 0x00007fa4,
  0x00007ffc, 0x00007ff0, 0x00007f85, 0x00007fa3,
  0x00007fee, 0x00007f83, 0x00007f84, 0x00007fa2,
  0x00007f81, 0x00007f82, 0x00007f83, 0x00004cee,
  0x00007f80, 0x00007f81, 0x00004ccf, 0x00002acc,
  0x00007f7f, 0x00004ccd, 0x00002aad, 0x00000024,
  0x00004ccb, 0x00002aab, 0x00000005, 0x00000023,
  0x00002aa9, 0x00000003, 0x00000004, 0x00000022,
  0x00000001, 0x00000002, 0x00000003, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00000003, 0x00002ac9,
  0x00000002, 0x00000003, 0x00002aac, 0x00004ceb,
  0x00000003, 0x00002aac, 0x00004cce, 0x00007f9f,
  0x00002aac, 0x00004cce, 0x00007f82, 0x00007fa0,
  0x00004cce, 0x00007f82, 0x00007f83, 0x00007fa1,
  0x00007f82, 0x00007f83, 0x00007f84, 0x00007fa2,
  0x00007f82, 0x00007f83, 0x00007f84, 0x00005566,
  0x00007f83, 0x00007f84, 0x00007ff1, 0x00005573,
  0x00007f84, 0x00007ff1, 0x00007ffe, 0x00005574,
  0x00007ff1, 0x00007ffe, 0x00007fff, 0x00005575,
  0x00007ffe, 0x00007fff, 0x00008000, 0x0000aaca,
  0x00007fff, 0x00008000, 0x00008003, 0x0000aac9,
  0x00008000, 0x00008001, 0x00008002, 0x0000aac8,
  0x00007fff, 0x00008000, 0x00008001, 0x0000aaba,
  0x00007ffe, 0x00007fff, 0x00007ff3, 0x0000aa4d,
  0x00007ffd, 0x00007ff1, 0x00007f86, 0x0000aa4c,
  0x00007fef, 0x00007f84, 0x00007f85, 0x0000aa4b,
  0x00007f82, 0x00007f83, 0x00007f84, 0x00007797,
  0x00007f81, 0x00007f82, 0x00004cd0, 0x00005575,
  0x00007f80, 0x00004cce, 0x00002aae, 0x00002acd,
  0x00004ccc, 0x00002aac, 0x00000006, 0x00002acc,
  0x00002aaa, 0x00000004, 0x00000005, 0x00002acb,
  0x00000002, 0x00000003, 0x00000004, 0x00002aca,
  0x00000001, 0x00000002, 0x00000003, 0x00002ac9,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00002aab, 0x00002242,
  0x00000002, 0x00002aab, 0x00004ccd, 0x000054f6,
  0x00002aab, 0x00004ccd, 0x00007f81, 0x000054f7,
  0x00004ccd, 0x00007f81, 0x00007f82, 0x000054f8,
  0x00007f81, 0x00007f82, 0x00007f83, 0x000054f9,
  0x00007f81, 0x00007f82, 0x000054db, 0x00003344,
  0x00007f82, 0x00007f83, 0x00005548, 0x00003351,
  0x00007f83, 0x00007ff0, 0x00005555, 0x00003352,
  0x00007ff0, 0x00007ffd, 0x00005556, 0x00003353,
  0x00007ffd, 0x00007ffe, 0x00005557, 0x0000ccec,
  0x00007ffe, 0x00007fff, 0x0000aaac, 0x0000cceb,
  0x00007fff, 0x00008002, 0x0000aaab, 0x0000ccea,
  0x00008000, 0x00008001, 0x0000aaaa, 0x0000ccdc,
  0x00007fff, 0x00008000, 0x0000aa9c, 0x0000cc6f,
  0x00007ffe, 0x00007ff2, 0x0000aa2f, 0x0000cc6e,
  0x00007ff0, 0x00007f85, 0x0000aa2e, 0x0000cc6d,
  0x00007f83, 0x00007f84, 0x0000aa2d, 0x000099b9,
  0x00007f82, 0x00007f83, 0x00007779, 0x00007797,
  0x00007f81, 0x00004ccf, 0x00005557, 0x00004cef,
  0x00004ccd, 0x00002aad, 0x00002aaf, 0x00004cee,
  0x00002aab, 0x00000005, 0x00002aae, 0x00004ced,
  0x00000003, 0x00000004, 0x00002aad, 0x00004cec,
  0x00000002, 0x00000003, 0x00002aac, 0x00004ceb,
  0x00000001, 0x00000002, 0x00002aab, 0x00002242,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00002aaa, 0x00002224, 0x000032d4,
  0x00002aaa, 0x00004ccc, 0x000054d8, 0x000032d5,
  0x00004ccc, 0x00007f80, 0x000054d9, 0x000032d6,
  0x00007f80, 0x00007f81, 0x000054da, 0x000032d7,
  0x00007f80, 0x000054d9, 0x000032b9, 0x00000090,
  0x00007f81, 0x000054da, 0x00003326, 0x0000009d,
  0x00007f82, 0x00005547, 0x00003333, 0x0000009e,
  0x00007fef, 0x00005554, 0x00003334, 0x0000009f,
  0x00007ffc, 0x00005555, 0x00003335, 0x0000ffa0,
  0x00007ffd, 0x00005556, 0x0000ccce, 0x0000ff9f,
  0x00007ffe, 0x0000aaab, 0x0000cccd, 0x0000ff9e,
  0x00008001, 0x0000aaaa, 0x0000cccc, 0x0000ff90,
  0x00008000, 0x0000aaa9, 0x0000ccbe, 0x0000ff23,
  0x00007fff, 0x0000aa9b, 0x0000cc51, 0x0000ff22,
  0x00007ff1, 0x0000aa2e, 0x0000cc50, 0x0000ff21,
  0x00007f84, 0x0000aa2d, 0x0000cc4f, 0x0000cc6d,
  0x00007f83, 0x0000aa2c, 0x0000999b, 0x0000aa4b,
  0x00007f82, 0x00007778, 0x00007779, 0x00007fa3,
  0x00004cce, 0x00005556, 0x00004cd1, 0x00007fa2,
  0x00002aac, 0x00002aae, 0x00004cd0, 0x00007fa1,
  0x00000004, 0x00002aad, 0x00004ccf, 0x00007fa0,
  0x00000003, 0x00002aac, 0x00004cce, 0x00007f9f,
  0x00000002, 0x00002aab, 0x00004ccd, 0x000054f6,
  0x00000001, 0x00002aaa, 0x00002224, 0x000032d4,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00002aa9, 0x00002223, 0x000032b6, 0x00000021,
  0x00004ccb, 0x000054d7, 0x000032b7, 0x00000022,
  0x00007f7f, 0x000054d8, 0x000032b8, 0x00000023,
  0x000054d7, 0x000032b7, 0x00000005, 0x0000008f,
  0x000054d8, 0x000032b8, 0x00000072, 0x0000009c,
  0x000054d9, 0x00003325, 0x0000007f, 0x0000009d,
  0x00005546, 0x00003332, 0x00000080, 0x0000009e,
  0x00005553, 0x00003333, 0x00000081, 0x0000ffa1,
  0x00005554, 0x00003334, 0x0000ff82, 0x0000ffa0,
  0x00005555, 0x0000cccd, 0x0000ff81, 0x0000ff9f,
  0x0000aaaa, 0x0000cccc, 0x0000ff80, 0x0000ff91,
  0x0000aaa9, 0x0000cccb, 0x0000ff72, 0x0000ff24,
  0x0000aaa8, 0x0000ccbd, 0x0000ff05, 0x0000ff23,
  0x0000aa9a, 0x0000cc50, 0x0000ff04, 0x0000ff22,
  0x0000aa2d, 0x0000cc4f, 0x0000ff03, 0x0000cc6e,
  0x0000aa2c, 0x0000cc4e, 0x0000cc4f, 0x0000aa4c,
  0x0000aa2b, 0x0000999a, 0x0000aa2d, 0x00007fa4,
  0x00007777, 0x00007778, 0x00007f85, 0x00007fa3,
  0x00005555, 0x00004cd0, 0x00007f84, 0x00007fa2,
  0x00002aad, 0x00004ccf, 0x00007f83, 0x00007fa1,
  0x00002aac, 0x00004cce, 0x00007f82, 0x00007fa0,
  0x00002aab, 0x00004ccd, 0x00007f81, 0x000054f7,
  0x00002aaa, 0x00004ccc, 0x000054d8, 0x000032d5,
  0x00002aa9, 0x00002223, 0x000032b6, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00002222, 0x000032b5, 0x00000003, 0x00000021,
  0x000054d6, 0x000032b6, 0x00000004, 0x00000022,
  0x000032b5, 0x00000003, 0x00000004, 0x0000008e,
  0x000032b6, 0x00000004, 0x00000071, 0x0000009b,
  0x000032b7, 0x00000071, 0x0000007e, 0x0000009c,
  0x00003324, 0x0000007e, 0x0000007f, 0x0000009d,
  0x00003331, 0x0000007f, 0x00000080, 0x0000ffa2,
  0x00003332, 0x00000080, 0x0000ff83, 0x0000ffa1,
  0x00003333, 0x0000ff81, 0x0000ff82, 0x0000ffa0,
  0x0000cccc, 0x0000ff80, 0x0000ff81, 0x0000ff92,
  0x0000cccb, 0x0000ff7f, 0x0000ff73, 0x0000ff25,
  0x0000ccca, 0x0000ff71, 0x0000ff06, 0x0000ff24,
  0x0000ccbc, 0x0000ff04, 0x0000ff05, 0x0000ff23,
  0x0000cc4f, 0x0000ff03, 0x0000ff04, 0x0000cc6f,
  0x0000cc4e, 0x0000ff02, 0x0000cc50, 0x0000aa4d,
  0x0000cc4d, 0x0000cc4e, 0x0000aa2e, 0x00007fa5,
  0x00009999, 0x0000aa2c, 0x00007f86, 0x00007fa4,
  0x00007777, 0x00007f84, 0x00007f85, 0x00007fa3,
  0x00004ccf, 0x00007f83, 0x00007f84, 0x00007fa2,
  0x00004cce, 0x00007f82, 0x00007f83, 0x00007fa1,
  0x00004ccd, 0x00007f81, 0x00007f82, 0x000054f8,
  0x00004ccc, 0x00007f80, 0x000054d9, 0x000032d6,
  0x00004ccb, 0x000054d7, 0x000032b7, 0x00000022,
  0x00002222, 0x000032b5, 0x00000003, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x000032b4, 0x00000002, 0x00000003, 0x00000021,
  0x00000001, 0x00000002, 0x00000003, 0x0000008d,
  0x00000002, 0x00000003, 0x00000070, 0x0000009a,
  0x00000003, 0x00000070, 0x0000007d, 0x0000009b,
  0x00000070, 0x0000007d, 0x0000007e, 0x0000009c,
  0x0000007d, 0x0000007e, 0x0000007f, 0x0000ffa3,
  0x0000007e, 0x0000007f, 0x0000ff84, 0x0000ffa2,
  0x0000007f, 0x0000ff82, 0x0000ff83, 0x0000ffa1,
  0x0000ff80, 0x0000ff81, 0x0000ff82, 0x0000ff93,
  0x0000ff7f, 0x0000ff80, 0x0000ff74, 0x0000ff26,
  0x0000ff7e, 0x0000ff72, 0x0000ff07, 0x0000ff25,
  0x0000ff70, 0x0000ff05, 0x0000ff06, 0x0000ff24,
  0x0000ff03, 0x0000ff04, 0x0000ff05, 0x0000cc70,
  0x0000ff02, 0x0000ff03, 0x0000cc51, 0x0000aa4e,
  0x0000ff01, 0x0000cc4f, 0x0000aa2f, 0x00007fa6,
  0x0000cc4d, 0x0000aa2d, 0x00007f87, 0x00007fa5,
  0x0000aa2b, 0x00007f85, 0x00007f86, 0x00007fa4,
  0x00007f83, 0x00007f84, 0x00007f85, 0x00007fa3,
  0x00007f82, 0x00007f83, 0x00007f84, 0x00007fa2,
  0x00007f81, 0x00007f82, 0x00007f83, 0x000054f9,
  0x00007f80, 0x00007f81, 0x000054da, 0x000032d7,
  0x00007f7f, 0x000054d8, 0x000032b8, 0x00000023,
  0x000054d6, 0x000032b6, 0x00000004, 0x00000022,
  0x000032b4, 0x00000002, 0x00000003, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
};
const unsigned kExpectedCount_NEON_uabal_4S = 576;

#endif  // VIXL_SIM_UABAL_4S_TRACE_AARCH64_H_
