// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UMLSL_4S_4H_H_TRACE_AARCH64_H_
#define VIXL_SIM_UMLSL_4S_4H_H_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_umlsl_4S_4H_H[] = {
  0xffffc1fc, 0xffffc17f, 0xffe6cce8, 0xffd6004a,
  0xffff837a, 0xffff827e, 0xffcd669b, 0xffabab1f,
  0xffe65060, 0xffe61c31, 0xf5900a72, 0xee9abc30,
  0xffbc508a, 0xffbbc706, 0xe47f1b83, 0xd2292df7,
  0xff7d5204, 0xff7c4883, 0xcae6351c, 0xa77fadf6,
  0xff3e5300, 0xff3cc981, 0xb14d1b82, 0x7cd5d8a0,
  0xfeff537e, 0xfefd4a00, 0x97b3ceb5, 0x522badf5,
  0xfeff537e, 0xfefd4a00, 0x97b3ceb5, 0x522badf5,
  0xffffc17e, 0xffffc100, 0xffe699b5, 0xffd5aaf5,
  0xffe68e64, 0xffe65ab3, 0xf5a93d8c, 0xeec4bc06,
  0xffbc8e8e, 0xffbc0588, 0xe4984e9d, 0xd2532dcd,
  0xff7d9008, 0xff7c8705, 0xcaff6836, 0xa7a9adcc,
  0xff3e9104, 0xff3d0803, 0xb1664e9c, 0x7cffd876,
  0xfeff9182, 0xfefd8882, 0x97cd01cf, 0x5255adcb,
  0xfeff9182, 0xfefd8882, 0x97cd01cf, 0x5255adcb,
  0xfeff9104, 0xfefd8803, 0x97ccce9c, 0x52555876,
  0xffe6cce6, 0xffe699b4, 0xf5c2a3d9, 0xeeef1131,
  0xffbccd10, 0xffbc4489, 0xe4b1b4ea, 0xd27d82f8,
  0xff7dce8a, 0xff7cc606, 0xcb18ce83, 0xa7d402f7,
  0xff3ecf86, 0xff3d4704, 0xb17fb4e9, 0x7d2a2da1,
  0xfeffd004, 0xfefdc783, 0x97e6681c, 0x528002f6,
  0xfeffd004, 0xfefdc783, 0x97e6681c, 0x528002f6,
  0xfeffcf86, 0xfefdc704, 0x97e634e9, 0x527fada1,
  0xfeffce8a, 0xfefdc606, 0x97e5ce83, 0x527f02f7,
  0xffd6002a, 0xffd5aad6, 0xeeef1113, 0xe38e71e7,
  0xff9701a4, 0xff962c53, 0xd5562aac, 0xb8e4f1e6,
  0xff5802a0, 0xff56ad51, 0xbbbd1112, 0x8e3b1c90,
  0xff19031e, 0xff172dd0, 0xa223c445, 0x6390f1e5,
  0xff19031e, 0xff172dd0, 0xa223c445, 0x6390f1e5,
  0xff1902a0, 0xff172d51, 0xa2239112, 0x63909c90,
  0xff1901a4, 0xff172c53, 0xa2232aac, 0x638ff1e6,
  0xff18f9c4, 0xff172463, 0xa21ff77c, 0x638a9c96,
  0xffc1017a, 0xffc0817e, 0xe667199b, 0xd556801f,
  0xff820276, 0xff81027c, 0xccce0001, 0xaaacaac9,
  0xff4302f4, 0xff4182fb, 0xb334b334, 0x8002801e,
  0xff4302f4, 0xff4182fb, 0xb334b334, 0x8002801e,
  0xff430276, 0xff41827c, 0xb3348001, 0x80022ac9,
  0xff43017a, 0xff41817e, 0xb334199b, 0x8001801f,
  0xff42f99a, 0xff41798e, 0xb330e66b, 0x7ffc2acf,
  0xff42bc14, 0xff413b8b, 0xb317e684, 0x7fd2804e,
  0xffc100fc, 0xffc080ff, 0xe666e668, 0xd5562aca,
  0xff82017a, 0xff81017e, 0xcccd999b, 0xaaac001f,
  0xff82017a, 0xff81017e, 0xcccd999b, 0xaaac001f,
  0xff8200fc, 0xff8100ff, 0xcccd6668, 0xaaabaaca,
  0xff820000, 0xff810001, 0xcccd0002, 0xaaab0020,
  0xff81f820, 0xff80f811, 0xccc9ccd2, 0xaaa5aad0,
  0xff81ba9a, 0xff80ba0e, 0xccb0cceb, 0xaa7c004f,
  0xff817c96, 0xff807b8c, 0xcc9799d1, 0xaa520079,
  0xffc1007e, 0xffc08080, 0xe666b335, 0xd555d575,
  0xffc1007e, 0xffc08080, 0xe666b335, 0xd555d575,
  0xffc10000, 0xffc08001, 0xe6668002, 0xd5558020,
  0xffc0ff04, 0xffc07f03, 0xe666199c, 0xd554d576,
  0xffc0f724, 0xffc07713, 0xe662e66c, 0xd54f8026,
  0xffc0b99e, 0xffc03910, 0xe649e685, 0xd525d5a5,
  0xffc07b9a, 0xffbffa8e, 0xe630b36b, 0xd4fbd5cf,
  0xffc03d18, 0xffbfbb8d, 0xe6174d1e, 0xd4d180a4,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffff82, 0xffffff82, 0xffffcccf, 0xffffaacb,
  0xfffffe86, 0xfffffe84, 0xffff6669, 0xffff0021,
  0xfffff6a6, 0xfffff694, 0xfffc3339, 0xfff9aad1,
  0xffffb920, 0xffffb891, 0xffe33352, 0xffd00050,
  0xffff7b1c, 0xffff7a0f, 0xffca0038, 0xffa6007a,
  0xffff3c9a, 0xffff3b0e, 0xffb099eb, 0xff7bab4f,
  0xffe60980, 0xffe5d4c1, 0xf5733dc2, 0xee6abc60,
  0xffffff82, 0xffffff82, 0xffffcccf, 0xffffaacb,
  0xfffffe86, 0xfffffe84, 0xffff6669, 0xffff0021,
  0xfffff6a6, 0xfffff694, 0xfffc3339, 0xfff9aad1,
  0xffffb920, 0xffffb891, 0xffe33352, 0xffd00050,
  0xffff7b1c, 0xffff7a0f, 0xffca0038, 0xffa6007a,
  0xffff3c9a, 0xffff3b0e, 0xffb099eb, 0xff7bab4f,
  0xffe60980, 0xffe5d4c1, 0xf5733dc2, 0xee6abc60,
  0xffbc09aa, 0xffbb7f96, 0xe4624ed3, 0xd1f92e27,
  0xffffff04, 0xffffff03, 0xffff999c, 0xffff5576,
  0xfffff724, 0xfffff713, 0xfffc666c, 0xfffa0026,
  0xffffb99e, 0xffffb910, 0xffe36685, 0xffd055a5,
  0xffff7b9a, 0xffff7a8e, 0xffca336b, 0xffa655cf,
  0xffff3d18, 0xffff3b8d, 0xffb0cd1e, 0xff7c00a4,
  0xffe609fe, 0xffe5d540, 0xf57370f5, 0xee6b11b5,
  0xffbc0a28, 0xffbb8015, 0xe4628206, 0xd1f9837c,
  0xff7d0ba2, 0xff7c0192, 0xcac99b9f, 0xa750037b,
  0xfffff820, 0xfffff811, 0xfffcccd2, 0xfffaaad0,
  0xffffba9a, 0xffffba0e, 0xffe3cceb, 0xffd1004f,
  0xffff7c96, 0xffff7b8c, 0xffca99d1, 0xffa70079,
  0xffff3e14, 0xffff3c8b, 0xffb13384, 0xff7cab4e,
  0xffe60afa, 0xffe5d63e, 0xf573d75b, 0xee6bbc5f,
  0xffbc0b24, 0xffbb8113, 0xe462e86c, 0xd1fa2e26,
  0xff7d0c9e, 0xff7c0290, 0xcaca0205, 0xa750ae25,
  0xff3e0d9a, 0xff3c838e, 0xb130e86b, 0x7ca6d8cf,
  0xffffc27a, 0xffffc1fe, 0xffe7001b, 0xffd6559f,
  0xffff8476, 0xffff837c, 0xffcdcd01, 0xffac55c9,
  0xffff45f4, 0xffff447b, 0xffb466b4, 0xff82009e,
  0xffe612da, 0xffe5de2e, 0xf5770a8b, 0xee7111af,
  0xffbc1304, 0xffbb8903, 0xe4661b9c, 0xd1ff8376,
  0xff7d147e, 0xff7c0a80, 0xcacd3535, 0xa7560375,
  0xff3e157a, 0xff3c8b7e, 0xb1341b9b, 0x7cac2e1f,
  0xfeff15f8, 0xfefd0bfd, 0x979acece, 0x52020374,
  0xffffc1fc, 0xffffc17f, 0xffe6cce8, 0xffd6004a,
  0xffff837a, 0xffff827e, 0xffcd669b, 0xffabab1f,
  0xffe65060, 0xffe61c31, 0xf5900a72, 0xee9abc30,
  0xffbc508a, 0xffbbc706, 0xe47f1b83, 0xd2292df7,
  0xff7d5204, 0xff7c4883, 0xcae6351c, 0xa77fadf6,
  0xff3e5300, 0xff3cc981, 0xb14d1b82, 0x7cd5d8a0,
  0xfeff537e, 0xfefd4a00, 0x97b3ceb5, 0x522badf5,
  0xfec0537e, 0xfebdca00, 0x7e1a4eb5, 0x27812df5,
  0xffffc17e, 0xffffc100, 0xffe699b5, 0xffd5aaf5,
  0xffe68e64, 0xffe65ab3, 0xf5a93d8c, 0xeec4bc06,
  0xffbc8e8e, 0xffbc0588, 0xe4984e9d, 0xd2532dcd,
  0xff7d9008, 0xff7c8705, 0xcaff6836, 0xa7a9adcc,
  0xff3e9104, 0xff3d0803, 0xb1664e9c, 0x7cffd876,
  0xfeff9182, 0xfefd8882, 0x97cd01cf, 0x5255adcb,
  0xfec09182, 0xfebe0882, 0x7e3381cf, 0x27ab2dcb,
  0xfe819104, 0xfe7e8803, 0x6499ce9c, 0xfd005876,
  0xffe6cce6, 0xffe699b4, 0xf5c2a3d9, 0xeeef1131,
  0xffbccd10, 0xffbc4489, 0xe4b1b4ea, 0xd27d82f8,
  0xff7dce8a, 0xff7cc606, 0xcb18ce83, 0xa7d402f7,
  0xff3ecf86, 0xff3d4704, 0xb17fb4e9, 0x7d2a2da1,
  0xfeffd004, 0xfefdc783, 0x97e6681c, 0x528002f6,
  0xfec0d004, 0xfebe4783, 0x7e4ce81c, 0x27d582f6,
  0xfe81cf86, 0xfe7ec704, 0x64b334e9, 0xfd2aada1,
  0xfe2dcfda, 0xfe2a1cae, 0x4291570b, 0xc447912f,
  0xffd6002a, 0xffd5aad6, 0xeeef1113, 0xe38e71e7,
  0xff9701a4, 0xff962c53, 0xd5562aac, 0xb8e4f1e6,
  0xff5802a0, 0xff56ad51, 0xbbbd1112, 0x8e3b1c90,
  0xff19031e, 0xff172dd0, 0xa223c445, 0x6390f1e5,
  0xfeda031e, 0xfed7add0, 0x888a4445, 0x38e671e5,
  0xfe9b02a0, 0xfe982d51, 0x6ef09112, 0x0e3b9c90,
  0xfe4702f4, 0xfe4382fb, 0x4cceb334, 0xd558801e,
  0xfde2368c, 0xfddde9c7, 0x23d94290, 0x9114c462,
  0xffc1017a, 0xffc0817e, 0xe667199b, 0xd556801f,
  0xff820276, 0xff81027c, 0xccce0001, 0xaaacaac9,
  0xff4302f4, 0xff4182fb, 0xb334b334, 0x8002801e,
  0xff0402f4, 0xff0202fb, 0x999b3334, 0x5558001e,
  0xfec50276, 0xfec2827c, 0x80018001, 0x2aad2ac9,
  0xfe7102ca, 0xfe6dd826, 0x5ddfa223, 0xf1ca0e57,
  0xfe0c3662, 0xfe083ef2, 0x34ea317f, 0xad86529b,
  0xfd8e7562, 0xfd897e72, 0x01d0caff, 0x585bfd1b,
  0xffc100fc, 0xffc080ff, 0xe666e668, 0xd5562aca,
  0xff82017a, 0xff81017e, 0xcccd999b, 0xaaac001f,
  0xff43017a, 0xff41817e, 0xb334199b, 0x8001801f,
  0xff0400fc, 0xff0200ff, 0x999a6668, 0x5556aaca,
  0xfeb00150, 0xfead56a9, 0x7778888a, 0x1c738e58,
  0xfe4b34e8, 0xfe47bd75, 0x4e8317e6, 0xd82fd29c,
  0xfdcd73e8, 0xfdc8fcf5, 0x1b69b166, 0x83057d1c,
  0xfd4fb26a, 0xfd4a3bf6, 0xe85017b3, 0x2ddad247,
  0xffc1007e, 0xffc08080, 0xe666b335, 0xd555d575,
  0xff82007e, 0xff810080, 0xcccd3335, 0xaaab5575,
  0xff430000, 0xff418001, 0xb3338002, 0x80008020,
  0xfeef0054, 0xfeecd5ab, 0x9111a224, 0x471d63ae,
  0xfe8a33ec, 0xfe873c77, 0x681c3180, 0x02d9a7f2,
  0xfe0c72ec, 0xfe087bf7, 0x3502cb00, 0xadaf5272,
  0xfd8eb16e, 0xfd89baf8, 0x01e9314d, 0x5884a79d,
  0xfd10ef72, 0xfd0af97a, 0xcecf6467, 0x0359a773,
  0xffc10000, 0xffc08001, 0xe6668002, 0xd5558020,
  0xff81ff82, 0xff80ff82, 0xcccccccf, 0xaaaaaacb,
  0xff2dffd6, 0xff2c552c, 0xaaaaeef1, 0x71c78e59,
  0xfec9336e, 0xfec6bbf8, 0x81b57e4d, 0x2d83d29d,
  0xfe4b726e, 0xfe47fb78, 0x4e9c17cd, 0xd8597d1d,
  0xfdcdb0f0, 0xfdc93a79, 0x1b827e1a, 0x832ed248,
  0xfd4feef4, 0xfd4a78fb, 0xe868b134, 0x2e03d21e,
  0xfcd22c7a, 0xfccbb6fe, 0xb54eb11b, 0xd8d87c9f,
  0xffc0ff82, 0xffc07f82, 0xe6664ccf, 0xd5552acb,
  0xff6cffd6, 0xff6bd52c, 0xc4446ef1, 0x9c720e59,
  0xff08336e, 0xff063bf8, 0x9b4efe4d, 0x582e529d,
  0xfe8a726e, 0xfe877b78, 0x683597cd, 0x0303fd1d,
  0xfe0cb0f0, 0xfe08ba79, 0x351bfe1a, 0xadd95248,
  0xfd8eeef4, 0xfd89f8fb, 0x02023134, 0x58ae521e,
  0xfd112c7a, 0xfd0b36fe, 0xcee8311b, 0x0382fc9f,
  0xfc93345a, 0xfc8c3eee, 0x9bb8644b, 0xae3351ef,
  0xffac0054, 0xffab55ab, 0xddde2224, 0xc71ce3ae,
  0xff4733ec, 0xff45bc77, 0xb4e8b180, 0x82d927f2,
  0xfec972ec, 0xfec6fbf7, 0x81cf4b00, 0x2daed272,
  0xfe4bb16e, 0xfe483af8, 0x4eb5b14d, 0xd884279d,
  0xfdcdef72, 0xfdc9797a, 0x1b9be467, 0x83592773,
  0xfd502cf8, 0xfd4ab77d, 0xe881e44e, 0x2e2dd1f4,
  0xfcd234d8, 0xfccbbf6d, 0xb552177e, 0xd8de2744,
  0xfc543652, 0xfc4cc0ea, 0x821fb117, 0x838a2743,
  0xff9b3398, 0xff9a66cd, 0xd70a8f5e, 0xbbbc4464,
  0xff1d7298, 0xff1ba64d, 0xa3f128de, 0x6691eee4,
  0xfe9fb11a, 0xfe9ce54e, 0x70d78f2b, 0x1167440f,
  0xfe21ef1e, 0xfe1e23d0, 0x3dbdc245, 0xbc3c43e5,
  0xfda42ca4, 0xfd9f61d3, 0x0aa3c22c, 0x6710ee66,
  0xfd263484, 0xfd2069c3, 0xd773f55c, 0x11c143b6,
  0xfca835fe, 0xfca16b40, 0xa4418ef5, 0xbc6d43b5,
  0xfc2a36fa, 0xfc226c3e, 0x710ef55b, 0x6718ee5f,
  0xff823f00, 0xff813f81, 0xcce69982, 0xaad5aaa0,
  0xff047d82, 0xff027e82, 0x99ccffcf, 0x55aaffcb,
  0xfe86bb86, 0xfe83bd04, 0x66b332e9, 0x007fffa1,
  0xfe08f90c, 0xfe04fb07, 0x339932d0, 0xab54aa22,
  0xfd8b00ec, 0xfd8602f7, 0x00696600, 0x5604ff72,
  0xfd0d0266, 0xfd070474, 0xcd36ff99, 0x00b0ff71,
  0xfc8f0362, 0xfc880572, 0x9a0465ff, 0xab5caa1b,
  0xfc1103e0, 0xfc0905f1, 0x66d19932, 0x5607ff70,
  0xff813f01, 0xcce6664e, 0xaad5552d, 0x80427ea3,
  0xff027d83, 0x99cc9968, 0x55aa5503, 0x00847d29,
  0xfe83bb86, 0x66b2994f, 0x007eff84, 0x80c5fbb2,
  0xfe04c376, 0x3382cc7f, 0xab2f54d4, 0x00d0fb82,
  0xfd85c4f3, 0x00506618, 0x55db54d3, 0x80d57b79,
  0xfd06c5f1, 0xcd1dcc7e, 0x0086ff7d, 0x00d97b73,
  0xfc87c670, 0x99eaffb1, 0xab3254d2, 0x80dcfb70,
  0xfc87c670, 0x99eaffb1, 0xab3254d2, 0x80dcfb70,
  0xff813e82, 0xcce6331b, 0xaad4ffd8, 0x8041fea6,
  0xff027c85, 0x99cc3302, 0x55a9aa59, 0x00837d2f,
  0xfe838475, 0x669c6632, 0x0059ffa9, 0x808e7cff,
  0xfe0485f2, 0x3369ffcb, 0xab05ffa8, 0x0092fcf6,
  0xfd8586f0, 0x00376631, 0x55b1aa52, 0x8096fcf0,
  0xfd06876f, 0xcd049964, 0x005cffa7, 0x009a7ced,
  0xfd06876f, 0xcd049964, 0x005cffa7, 0x009a7ced,
  0xfd0686f0, 0xcd046631, 0x005caa52, 0x0099fcf0,
  0xff813e03, 0xcce5ffe8, 0xaad4aa83, 0x80417ea9,
  0xff0245f3, 0x99b63318, 0x5584ffd3, 0x004c7e79,
  0xfe834770, 0x6683ccb1, 0x0030ffd2, 0x8050fe70,
  0xfe04486e, 0x33513317, 0xaadcaa7c, 0x0054fe6a,
  0xfd8548ed, 0x001e664a, 0x5587ffd1, 0x80587e67,
  0xfd8548ed, 0x001e664a, 0x5587ffd1, 0x80587e67,
  0xfd85486e, 0x001e3317, 0x5587aa7c, 0x8057fe6a,
  0xfd854770, 0x001dccb1, 0x5586ffd2, 0x8056fe70,
  0xff8107f0, 0xccd03331, 0xaab05552, 0x800afff0,
  0xff02096d, 0x999dccca, 0x555c5551, 0x000f7fe7,
  0xfe830a6b, 0x666b3330, 0x0007fffb, 0x80137fe1,
  0xfe040aea, 0x33386663, 0xaab35550, 0x0016ffde,
  0xfe040aea, 0x33386663, 0xaab35550, 0x0016ffde,
  0xfe040a6b, 0x33383330, 0xaab2fffb, 0x00167fe1,
  0xfe04096d, 0x3337ccca, 0xaab25551, 0x00157fe7,
  0xfe04017d, 0x3334999a, 0xaaad0001, 0x000d8017,
  0xff81017d, 0xcccd999a, 0xaaac0001, 0x80048017,
  0xff02027b, 0x999b0000, 0x5557aaab, 0x00088011,
  0xfe8302fa, 0x66683333, 0x00030000, 0x800c000e,
  0xfe8302fa, 0x66683333, 0x00030000, 0x800c000e,
  0xfe83027b, 0x66680000, 0x0002aaab, 0x800b8011,
  0xfe83017d, 0x6667999a, 0x00020001, 0x800a8017,
  0xfe82f98d, 0x6664666a, 0xfffcaab1, 0x80028047,
  0xfe82bb8a, 0x664b6683, 0xffd30030, 0x7fc401be,
  0xff8100fe, 0xcccd6667, 0xaaabaaac, 0x8004001a,
  0xff02017d, 0x999a999a, 0x55570001, 0x00078017,
  0xff02017d, 0x999a999a, 0x55570001, 0x00078017,
  0xff0200fe, 0x999a6667, 0x5556aaac, 0x0007001a,
  0xff020000, 0x999a0001, 0x55560002, 0x00060020,
  0xff01f810, 0x9996ccd1, 0x5550aab2, 0xfffe0050,
  0xff01ba0d, 0x997dccea, 0x55270031, 0xffbf81c7,
  0xff017b8b, 0x996499d0, 0x54fd005b, 0xff808341,
  0xff81007f, 0xcccd3334, 0xaaab5557, 0x8003801d,
  0xff81007f, 0xcccd3334, 0xaaab5557, 0x8003801d,
  0xff810000, 0xcccd0001, 0xaaab0002, 0x80030020,
  0xff80ff02, 0xcccc999b, 0xaaaa5558, 0x80020026,
  0xff80f712, 0xccc9666b, 0xaaa50008, 0x7ffa0056,
  0xff80b90f, 0xccb06684, 0xaa7b5587, 0x7fbb81cd,
  0xff807a8d, 0xcc97336a, 0xaa5155b1, 0x7f7c8347,
  0xff803b8c, 0xcc7dcd1d, 0xaa270086, 0x7f3d04c4,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffff81, 0xffffccce, 0xffffaaad, 0xffff8023,
  0xfffffe83, 0xffff6668, 0xffff0003, 0xfffe8029,
  0xfffff693, 0xfffc3338, 0xfff9aab3, 0xfff68059,
  0xffffb890, 0xffe33351, 0xffd00032, 0xffb801d0,
  0xffff7a0e, 0xffca0037, 0xffa6005c, 0xff79034a,
  0xffff3b0d, 0xffb099ea, 0xff7bab31, 0xff3984c7,
  0xffe5d4c0, 0xf5733dc1, 0xee6abc42, 0xe5a09e60,
  0xffffff81, 0xffffccce, 0xffffaaad, 0xffff8023,
  0xfffffe83, 0xffff6668, 0xffff0003, 0xfffe8029,
  0xfffff693, 0xfffc3338, 0xfff9aab3, 0xfff68059,
  0xffffb890, 0xffe33351, 0xffd00032, 0xffb801d0,
  0xffff7a0e, 0xffca0037, 0xffa6005c, 0xff79034a,
  0xffff3b0d, 0xffb099ea, 0xff7bab31, 0xff3984c7,
  0xffe5d4c0, 0xf5733dc1, 0xee6abc42, 0xe5a09e60,
  0xffbb7f95, 0xe4624ed2, 0xd1f92e09, 0xbaf71e5f,
  0xffffff02, 0xffff999b, 0xffff5558, 0xffff0026,
  0xfffff712, 0xfffc666b, 0xfffa0008, 0xfff70056,
  0xffffb90f, 0xffe36684, 0xffd05587, 0xffb881cd,
  0xffff7a8d, 0xffca336a, 0xffa655b1, 0xff798347,
  0xffff3b8c, 0xffb0cd1d, 0xff7c0086, 0xff3a04c4,
  0xffe5d53f, 0xf57370f4, 0xee6b1197, 0xe5a11e5d,
  0xffbb8014, 0xe4628205, 0xd1f9835e, 0xbaf79e5c,
  0xff7c0191, 0xcac99b9e, 0xa750035d, 0x7afa9e53,
  0xfffff810, 0xfffcccd1, 0xfffaaab2, 0xfff80050,
  0xffffba0d, 0xffe3ccea, 0xffd10031, 0xffb981c7,
  0xffff7b8b, 0xffca99d0, 0xffa7005b, 0xff7a8341,
  0xffff3c8a, 0xffb13383, 0xff7cab30, 0xff3b04be,
  0xffe5d63d, 0xf573d75a, 0xee6bbc41, 0xe5a21e57,
  0xffbb8112, 0xe462e86b, 0xd1fa2e08, 0xbaf89e56,
  0xff7c028f, 0xcaca0204, 0xa750ae07, 0x7afb9e4d,
  0xff3c838d, 0xb130e86a, 0x7ca6d8b1, 0x3afe1e47,
  0xffffc1fd, 0xffe7001a, 0xffd65581, 0xffc18197,
  0xffff837b, 0xffcdcd00, 0xffac55ab, 0xff828311,
  0xffff447a, 0xffb466b3, 0xff820080, 0xff43048e,
  0xffe5de2d, 0xf5770a8a, 0xee711191, 0xe5aa1e27,
  0xffbb8902, 0xe4661b9b, 0xd1ff8358, 0xbb009e26,
  0xff7c0a7f, 0xcacd3534, 0xa7560357, 0x7b039e1d,
  0xff3c8b7d, 0xb1341b9a, 0x7cac2e01, 0x3b061e17,
  0xfefd0bfc, 0x979acecd, 0x52020356, 0xfb081e14,
  0xffffc17e, 0xffe6cce7, 0xffd6002c, 0xffc1019a,
  0xffff827d, 0xffcd669a, 0xffabab01, 0xff818317,
  0xffe61c30, 0xf5900a71, 0xee9abc12, 0xe5e89cb0,
  0xffbbc705, 0xe47f1b82, 0xd2292dd9, 0xbb3f1caf,
  0xff7c4882, 0xcae6351b, 0xa77fadd8, 0x7b421ca6,
  0xff3cc980, 0xb14d1b81, 0x7cd5d882, 0x3b449ca0,
  0xfefd49ff, 0x97b3ceb4, 0x522badd7, 0xfb469c9d,
  0xfebdc9ff, 0x7e1a4eb4, 0x27812dd7, 0xbb481c9d,
  0xffffc0ff, 0xffe699b4, 0xffd5aad7, 0xffc0819d,
  0xffe65ab2, 0xf5a93d8b, 0xeec4bbe8, 0xe6279b36,
  0xffbc0587, 0xe4984e9c, 0xd2532daf, 0xbb7e1b35,
  0xff7c8704, 0xcaff6835, 0xa7a9adae, 0x7b811b2c,
  0xff3d0802, 0xb1664e9b, 0x7cffd858, 0x3b839b26,
  0xfefd8881, 0x97cd01ce, 0x5255adad, 0xfb859b23,
  0xfebe0881, 0x7e3381ce, 0x27ab2dad, 0xbb871b23,
  0xfe7e8802, 0x6499ce9b, 0xfd005858, 0x7b881b26,
  0xffe699b3, 0xf5c2a3d8, 0xeeef1113, 0xe66719b9,
  0xffbc4488, 0xe4b1b4e9, 0xd27d82da, 0xbbbd99b8,
  0xff7cc605, 0xcb18ce82, 0xa7d402d9, 0x7bc099af,
  0xff3d4703, 0xb17fb4e8, 0x7d2a2d83, 0x3bc319a9,
  0xfefdc782, 0x97e6681b, 0x528002d8, 0xfbc519a6,
  0xfebe4782, 0x7e4ce81b, 0x27d582d8, 0xbbc699a6,
  0xfe7ec703, 0x64b334e8, 0xfd2aad83, 0x7bc799a9,
  0xfe2a1cad, 0x4291570a, 0xc4479111, 0x267499a7,
  0xffd5aad5, 0xeeef1112, 0xe38e71c9, 0xd556801f,
  0xff962c52, 0xd5562aab, 0xb8e4f1c8, 0x95598016,
  0xff56ad50, 0xbbbd1111, 0x8e3b1c72, 0x555c0010,
  0xff172dcf, 0xa223c444, 0x6390f1c7, 0x155e000d,
  0xfed7adcf, 0x888a4444, 0x38e671c7, 0xd55f800d,
  0xfe982d50, 0x6ef09111, 0x0e3b9c72, 0x95608010,
  0xfe4382fa, 0x4cceb333, 0xd5588000, 0x400d800e,
  0xfddde9c6, 0x23d9428f, 0x9114c444, 0xd9a9e672,
  0xffc0817d, 0xe667199a, 0xd5568001, 0xc0030017,
  0xff81027b, 0xccce0000, 0xaaacaaab, 0x80058011,
  0xff4182fa, 0xb334b333, 0x80028000, 0x4007800e,
  0xff0202fa, 0x999b3333, 0x55580000, 0x0009000e,
  0xfec2827b, 0x80018000, 0x2aad2aab, 0xc00a0011,
  0xfe6dd825, 0x5ddfa222, 0xf1ca0e39, 0x6ab7000f,
  0xfe083ef1, 0x34ea317e, 0xad86527d, 0x04536673,
  0xfd897e71, 0x01d0cafe, 0x585bfcfd, 0x849664f3,
  0xffc080fe, 0xe666e667, 0xd5562aac, 0xc002801a,
  0xff81017d, 0xcccd999a, 0xaaac0001, 0x80048017,
  0xff41817d, 0xb334199a, 0x80018001, 0x40060017,
  0xff0200fe, 0x999a6667, 0x5556aaac, 0x0007001a,
  0xfead56a8, 0x77788889, 0x1c738e3a, 0xaab40018,
  0xfe47bd74, 0x4e8317e5, 0xd82fd27e, 0x4450667c,
  0xfdc8fcf4, 0x1b69b165, 0x83057cfe, 0xc49364fc,
  0xfd4a3bf5, 0xe85017b2, 0x2ddad229, 0x44d5e37f,
  0xffc0807f, 0xe666b334, 0xd555d557, 0xc002001d,
  0xff81007f, 0xcccd3334, 0xaaab5557, 0x8003801d,
  0xff418000, 0xb3338001, 0x80008002, 0x40048020,
  0xfeecd5aa, 0x9111a223, 0x471d6390, 0xeab1801e,
  0xfe873c76, 0x681c317f, 0x02d9a7d4, 0x844de682,
  0xfe087bf6, 0x3502caff, 0xadaf5254, 0x0490e502,
  0xfd89baf7, 0x01e9314c, 0x5884a77f, 0x84d36385,
  0xfd0af979, 0xcecf6466, 0x0359a755, 0x0515620b,
  0xffc08000, 0xe6668001, 0xd5558002, 0xc0018020,
  0xff80ff81, 0xccccccce, 0xaaaaaaad, 0x80028023,
  0xff2c552b, 0xaaaaeef0, 0x71c78e3b, 0x2aaf8021,
  0xfec6bbf7, 0x81b57e4c, 0x2d83d27f, 0xc44be685,
  0xfe47fb77, 0x4e9c17cc, 0xd8597cff, 0x448ee505,
  0xfdc93a78, 0x1b827e19, 0x832ed22a, 0xc4d16388,
  0xfd4a78fa, 0xe868b133, 0x2e03d200, 0x4513620e,
  0xfccbb6fd, 0xb54eb11a, 0xd8d87c81, 0xc554e097,
  0xffc07f81, 0xe6664cce, 0xd5552aad, 0xc0010023,
  0xff6bd52b, 0xc4446ef0, 0x9c720e3b, 0x6aae0021,
  0xff063bf7, 0x9b4efe4c, 0x582e527f, 0x044a6685,
  0xfe877b77, 0x683597cc, 0x0303fcff, 0x848d6505,
  0xfe08ba78, 0x351bfe19, 0xadd9522a, 0x04cfe388,
  0xfd89f8fa, 0x02023133, 0x58ae5200, 0x8511e20e,
  0xfd0b36fd, 0xcee8311a, 0x0382fc81, 0x05536097,
  0xfc8c3eed, 0x9bb8644a, 0xae3351d1, 0x855e6067,
  0xffab55aa, 0xddde2223, 0xc71ce390, 0xaaad001e,
  0xff45bc76, 0xb4e8b17f, 0x82d927d4, 0x44496682,
  0xfec6fbf6, 0x81cf4aff, 0x2daed254, 0xc48c6502,
  0xfe483af7, 0x4eb5b14c, 0xd884277f, 0x44cee385,
  0xfdc97979, 0x1b9be466, 0x83592755, 0xc510e20b,
  0xfd4ab77c, 0xe881e44d, 0x2e2dd1d6, 0x45526094,
  0xfccbbf6c, 0xb552177d, 0xd8de2726, 0xc55d6064,
  0xfc4cc0e9, 0x821fb116, 0x838a2725, 0x4561e05b,
  0xff9a66cc, 0xd70a8f5d, 0xbbbc4446, 0x999c6684,
  0xff1ba64c, 0xa3f128dd, 0x6691eec6, 0x19df6504,
  0xfe9ce54d, 0x70d78f2a, 0x116743f1, 0x9a21e387,
  0xfe1e23cf, 0x3dbdc244, 0xbc3c43c7, 0x1a63e20d,
  0xfd9f61d2, 0x0aa3c22b, 0x6710ee48, 0x9aa56096,
  0xfd2069c2, 0xd773f55b, 0x11c14398, 0x1ab06066,
  0xfca16b3f, 0xa4418ef4, 0xbc6d4397, 0x9ab4e05d,
  0xfc226c3d, 0x710ef55a, 0x6718ee41, 0x1ab8e057,
  0xff813f80, 0xcce69981, 0xaad5aa82, 0x8042fea0,
  0xff027e81, 0x99ccffce, 0x55aaffad, 0x00857d23,
  0xfe83bd03, 0x66b332e8, 0x007fff83, 0x80c77ba9,
  0xfe04fb06, 0x339932cf, 0xab54aa04, 0x0108fa32,
  0xfd8602f6, 0x006965ff, 0x5604ff54, 0x8113fa02,
  0xfd070473, 0xcd36ff98, 0x00b0ff53, 0x011879f9,
  0xfc880571, 0x9a0465fe, 0xab5ca9fd, 0x811c79f3,
  0xfc0905f0, 0x66d19931, 0x5607ff52, 0x011ff9f0,
  0xcce6664d, 0xaad5552c, 0x80427e85, 0x80417f22,
  0x99cc9967, 0x55aa5502, 0x00847d0b, 0x00827e26,
  0x66b2994e, 0x007eff83, 0x80c5fb94, 0x80c2fd2c,
  0x3382cc7e, 0xab2f54d3, 0x00d0fb64, 0x00ccfd0c,
  0x00506617, 0x55db54d2, 0x80d57b5b, 0x80d07d06,
  0xcd1dcc7d, 0x0086ff7c, 0x00d97b55, 0x00d37d02,
  0x99eaffb0, 0xab3254d1, 0x80dcfb52, 0x80d5fd00,
  0x99eaffb0, 0xab3254d1, 0x80dcfb52, 0x80d5fd00,
  0xcce6331a, 0xaad4ffd7, 0x8041fe88, 0x8040ff24,
  0x99cc3301, 0x55a9aa58, 0x00837d11, 0x00817e2a,
  0x669c6631, 0x0059ffa8, 0x808e7ce1, 0x808b7e0a,
  0x3369ffca, 0xab05ffa7, 0x0092fcd8, 0x008efe04,
  0x00376630, 0x55b1aa51, 0x8096fcd2, 0x8091fe00,
  0xcd049963, 0x005cffa6, 0x009a7ccf, 0x00947dfe,
  0xcd049963, 0x005cffa6, 0x009a7ccf, 0x00947dfe,
  0xcd046630, 0x005caa51, 0x0099fcd2, 0x0093fe00,
  0xcce5ffe7, 0xaad4aa82, 0x80417e8b, 0x80407f26,
  0x99b63317, 0x5584ffd2, 0x004c7e5b, 0x004a7f06,
  0x6683ccb0, 0x0030ffd1, 0x8050fe52, 0x804dff00,
  0x33513316, 0xaadcaa7b, 0x0054fe4c, 0x0050fefc,
  0x001e6649, 0x5587ffd0, 0x80587e49, 0x80537efa,
  0x001e6649, 0x5587ffd0, 0x80587e49, 0x80537efa,
  0x001e3316, 0x5587aa7b, 0x8057fe4c, 0x8052fefc,
  0x001dccb0, 0x5586ffd1, 0x8056fe52, 0x8051ff00,
  0xccd03330, 0xaab05551, 0x800affd2, 0x800a0000,
  0x999dccc9, 0x555c5550, 0x000f7fc9, 0x000d7ffa,
  0x666b332f, 0x0007fffa, 0x80137fc3, 0x80107ff6,
  0x33386662, 0xaab3554f, 0x0016ffc0, 0x0012fff4,
  0x33386662, 0xaab3554f, 0x0016ffc0, 0x0012fff4,
  0x3338332f, 0xaab2fffa, 0x00167fc3, 0x00127ff6,
  0x3337ccc9, 0xaab25550, 0x00157fc9, 0x00117ffa,
  0x33349999, 0xaaad0000, 0x000d7ff9, 0x0009801a,
  0xcccd9999, 0xaaac0000, 0x80047ff9, 0x8003801a,
  0x999affff, 0x5557aaaa, 0x00087ff3, 0x00068016,
  0x66683332, 0x0002ffff, 0x800bfff0, 0x80090014,
  0x66683332, 0x0002ffff, 0x800bfff0, 0x80090014,
  0x6667ffff, 0x0002aaaa, 0x800b7ff3, 0x80088016,
  0x66679999, 0x00020000, 0x800a7ff9, 0x8007801a,
  0x66646669, 0xfffcaab0, 0x80028029, 0x7fff803a,
  0x664b6682, 0xffd3002f, 0x7fc401a0, 0x7fc10134,
  0xcccd6666, 0xaaabaaab, 0x8003fffc, 0x8003001c,
  0x999a9999, 0x55570000, 0x00077ff9, 0x0005801a,
  0x999a9999, 0x55570000, 0x00077ff9, 0x0005801a,
  0x999a6666, 0x5556aaab, 0x0006fffc, 0x0005001c,
  0x999a0000, 0x55560001, 0x00060002, 0x00040020,
  0x9996ccd0, 0x5550aab1, 0xfffe0032, 0xfffc0040,
  0x997dcce9, 0x55270030, 0xffbf81a9, 0xffbd813a,
  0x996499cf, 0x54fd005a, 0xff808323, 0xff7e8236,
  0xcccd3333, 0xaaab5556, 0x80037fff, 0x8002801e,
  0xcccd3333, 0xaaab5556, 0x80037fff, 0x8002801e,
  0xcccd0000, 0xaaab0001, 0x80030002, 0x80020020,
  0xcccc999a, 0xaaaa5557, 0x80020008, 0x80010024,
  0xccc9666a, 0xaaa50007, 0x7ffa0038, 0x7ff90044,
  0xccb06683, 0xaa7b5586, 0x7fbb81af, 0x7fba813e,
  0xcc973369, 0xaa5155b0, 0x7f7c8329, 0x7f7b823a,
  0xcc7dcd1c, 0xaa270085, 0x7f3d04a6, 0x7f3c0338,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffcccd, 0xffffaaac, 0xffff8005, 0xffff8022,
  0xffff6667, 0xffff0002, 0xfffe800b, 0xfffe8026,
  0xfffc3337, 0xfff9aab2, 0xfff6803b, 0xfff68046,
  0xffe33350, 0xffd00031, 0xffb801b2, 0xffb80140,
  0xffca0036, 0xffa6005b, 0xff79032c, 0xff79023c,
  0xffb099e9, 0xff7bab30, 0xff3984a9, 0xff39833a,
  0xf5733dc0, 0xee6abc41, 0xe5a09e42, 0xe5a069a0,
  0xffffcccd, 0xffffaaac, 0xffff8005, 0xffff8022,
  0xffff6667, 0xffff0002, 0xfffe800b, 0xfffe8026,
  0xfffc3337, 0xfff9aab2, 0xfff6803b, 0xfff68046,
  0xffe33350, 0xffd00031, 0xffb801b2, 0xffb80140,
  0xffca0036, 0xffa6005b, 0xff79032c, 0xff79023c,
  0xffb099e9, 0xff7bab30, 0xff3984a9, 0xff39833a,
  0xf5733dc0, 0xee6abc41, 0xe5a09e42, 0xe5a069a0,
  0xe4624ed1, 0xd1f92e08, 0xbaf71e41, 0xbaf6944a,
  0xffff999a, 0xffff5557, 0xffff0008, 0xffff0024,
  0xfffc666a, 0xfffa0007, 0xfff70038, 0xfff70044,
  0xffe36683, 0xffd05586, 0xffb881af, 0xffb8813e,
  0xffca3369, 0xffa655b0, 0xff798329, 0xff79823a,
  0xffb0cd1c, 0xff7c0085, 0xff3a04a6, 0xff3a0338,
  0xf57370f3, 0xee6b1196, 0xe5a11e3f, 0xe5a0e99e,
  0xe4628204, 0xd1f9835d, 0xbaf79e3e, 0xbaf71448,
  0xcac99b9d, 0xa750035c, 0x7afa9e35, 0x7af99442,
  0xfffcccd0, 0xfffaaab1, 0xfff80032, 0xfff80040,
  0xffe3cce9, 0xffd10030, 0xffb981a9, 0xffb9813a,
  0xffca99cf, 0xffa7005a, 0xff7a8323, 0xff7a8236,
  0xffb13382, 0xff7cab2f, 0xff3b04a0, 0xff3b0334,
  0xf573d759, 0xee6bbc40, 0xe5a21e39, 0xe5a1e99a,
  0xe462e86a, 0xd1fa2e07, 0xbaf89e38, 0xbaf81444,
  0xcaca0203, 0xa750ae06, 0x7afb9e2f, 0x7afa943e,
  0xb130e869, 0x7ca6d8b0, 0x3afe1e29, 0x3afc943a,
  0xffe70019, 0xffd65580, 0xffc18179, 0xffc1811a,
  0xffcdccff, 0xffac55aa, 0xff8282f3, 0xff828216,
  0xffb466b2, 0xff82007f, 0xff430470, 0xff430314,
  0xf5770a89, 0xee711190, 0xe5aa1e09, 0xe5a9e97a,
  0xe4661b9a, 0xd1ff8357, 0xbb009e08, 0xbb001424,
  0xcacd3533, 0xa7560356, 0x7b039dff, 0x7b02941e,
  0xb1341b99, 0x7cac2e00, 0x3b061df9, 0x3b04941a,
  0x979acecc, 0x52020355, 0xfb081df6, 0xfb061418,
  0xffe6cce6, 0xffd6002b, 0xffc1017c, 0xffc1011c,
  0xffcd6699, 0xffabab00, 0xff8182f9, 0xff81821a,
  0xf5900a70, 0xee9abc11, 0xe5e89c92, 0xe5e86880,
  0xe47f1b81, 0xd2292dd8, 0xbb3f1c91, 0xbb3e932a,
  0xcae6351a, 0xa77fadd7, 0x7b421c88, 0x7b411324,
  0xb14d1b80, 0x7cd5d881, 0x3b449c82, 0x3b431320,
  0x97b3ceb3, 0x522badd6, 0xfb469c7f, 0xfb44931e,
  0x7e1a4eb3, 0x27812dd6, 0xbb481c7f, 0xbb45931e,
  0xffe699b3, 0xffd5aad6, 0xffc0817f, 0xffc0811e,
  0xf5a93d8a, 0xeec4bbe7, 0xe6279b18, 0xe6276784,
  0xe4984e9b, 0xd2532dae, 0xbb7e1b17, 0xbb7d922e,
  0xcaff6834, 0xa7a9adad, 0x7b811b0e, 0x7b801228,
  0xb1664e9a, 0x7cffd857, 0x3b839b08, 0x3b821224,
  0x97cd01cd, 0x5255adac, 0xfb859b05, 0xfb839222,
  0x7e3381cd, 0x27ab2dac, 0xbb871b05, 0xbb849222,
  0x6499ce9a, 0xfd005857, 0x7b881b08, 0x7b851224,
  0xf5c2a3d7, 0xeeef1112, 0xe667199b, 0xe666e686,
  0xe4b1b4e8, 0xd27d82d9, 0xbbbd999a, 0xbbbd1130,
  0xcb18ce81, 0xa7d402d8, 0x7bc09991, 0x7bbf912a,
  0xb17fb4e7, 0x7d2a2d82, 0x3bc3198b, 0x3bc19126,
  0x97e6681a, 0x528002d7, 0xfbc51988, 0xfbc31124,
  0x7e4ce81a, 0x27d582d7, 0xbbc69988, 0xbbc41124,
  0x64b334e7, 0xfd2aad82, 0x7bc7998b, 0x7bc49126,
  0x42915709, 0xc4479110, 0x26749989, 0x2670e67a,
  0xeeef1111, 0xe38e71c8, 0xd5568001, 0xd5562aca,
  0xd5562aaa, 0xb8e4f1c7, 0x95597ff8, 0x9558aac4,
  0xbbbd1110, 0x8e3b1c71, 0x555bfff2, 0x555aaac0,
  0xa223c443, 0x6390f1c6, 0x155dffef, 0x155c2abe,
  0x888a4443, 0x38e671c6, 0xd55f7fef, 0xd55d2abe,
  0x6ef09110, 0x0e3b9c71, 0x95607ff2, 0x955daac0,
  0x4cceb332, 0xd5587fff, 0x400d7ff0, 0x400a0014,
  0x23d9428e, 0x9114c443, 0xd9a9e654, 0xd9a599ac,
  0xe6671999, 0xd5568000, 0xc002fff9, 0xc002801a,
  0xcccdffff, 0xaaacaaaa, 0x80057ff3, 0x80048016,
  0xb334b332, 0x80027fff, 0x40077ff0, 0x40060014,
  0x999b3332, 0x5557ffff, 0x0008fff0, 0x00070014,
  0x80017fff, 0x2aad2aaa, 0xc009fff3, 0xc0078016,
  0x5ddfa221, 0xf1ca0e38, 0x6ab6fff1, 0x6ab3d56a,
  0x34ea317d, 0xad86527c, 0x04536655, 0x044f6f02,
  0x01d0cafd, 0x585bfcfc, 0x849664d5, 0x84916e02,
  0xe666e666, 0xd5562aab, 0xc0027ffc, 0xc002001c,
  0xcccd9999, 0xaaac0000, 0x80047ff9, 0x8003801a,
  0xb3341999, 0x80018000, 0x4005fff9, 0x4004801a,
  0x999a6666, 0x5556aaab, 0x0006fffc, 0x0005001c,
  0x77788888, 0x1c738e39, 0xaab3fffa, 0xaab15570,
  0x4e8317e4, 0xd82fd27d, 0x4450665e, 0x444cef08,
  0x1b69b164, 0x83057cfd, 0xc49364de, 0xc48eee08,
  0xe85017b1, 0x2ddad228, 0x44d5e361, 0x44d06d0a,
  0xe666b333, 0xd555d556, 0xc001ffff, 0xc001801e,
  0xcccd3333, 0xaaab5556, 0x80037fff, 0x8002801e,
  0xb3338000, 0x80008001, 0x40048002, 0x40030020,
  0x9111a222, 0x471d638f, 0xeab18000, 0xeaaf5574,
  0x681c317e, 0x02d9a7d3, 0x844de664, 0x844aef0c,
  0x3502cafe, 0xadaf5253, 0x0490e4e4, 0x048cee0c,
  0x01e9314b, 0x5884a77e, 0x84d36367, 0x84ce6d0e,
  0xcecf6465, 0x0359a754, 0x051561ed, 0x050f6c12,
  0xe6668000, 0xd5558001, 0xc0018002, 0xc0010020,
  0xcccccccd, 0xaaaaaaac, 0x80028005, 0x80018022,
  0xaaaaeeef, 0x71c78e3a, 0x2aaf8003, 0x2aadd576,
  0x81b57e4b, 0x2d83d27e, 0xc44be667, 0xc4496f0e,
  0x4e9c17cb, 0xd8597cfe, 0x448ee4e7, 0x448b6e0e,
  0x1b827e18, 0x832ed229, 0xc4d1636a, 0xc4cced10,
  0xe868b132, 0x2e03d1ff, 0x451361f0, 0x450dec14,
  0xb54eb119, 0xd8d87c80, 0xc554e079, 0xc54e6b1a,
  0xe6664ccd, 0xd5552aac, 0xc0010005, 0xc0008022,
  0xc4446eef, 0x9c720e3a, 0x6aae0003, 0x6aacd576,
  0x9b4efe4b, 0x582e527e, 0x044a6667, 0x04486f0e,
  0x683597cb, 0x0303fcfe, 0x848d64e7, 0x848a6e0e,
  0x351bfe18, 0xadd95229, 0x04cfe36a, 0x04cbed10,
  0x02023132, 0x58ae51ff, 0x8511e1f0, 0x850cec14,
  0xcee83119, 0x0382fc80, 0x05536079, 0x054d6b1a,
  0x9bb86449, 0xae3351d0, 0x855e6049, 0x85576afa,
  0xddde2222, 0xc71ce38f, 0xaaad0000, 0xaaac5574,
  0xb4e8b17e, 0x82d927d3, 0x44496664, 0x4447ef0c,
  0x81cf4afe, 0x2daed253, 0xc48c64e4, 0xc489ee0c,
  0x4eb5b14b, 0xd884277e, 0x44cee367, 0x44cb6d0e,
  0x1b9be465, 0x83592754, 0xc510e1ed, 0xc50c6c12,
  0xe881e44c, 0x2e2dd1d5, 0x45526076, 0x454ceb18,
  0xb552177c, 0xd8de2725, 0xc55d6046, 0xc556eaf8,
  0x821fb115, 0x838a2724, 0x4561e03d, 0x455a6af2,
  0xd70a8f5c, 0xbbbc4445, 0x999c6666, 0x999b99b8,
  0xa3f128dc, 0x6691eec5, 0x19df64e6, 0x19dd98b8,
  0x70d78f29, 0x116743f0, 0x9a21e369, 0x9a1f17ba,
  0x3dbdc243, 0xbc3c43c6, 0x1a63e1ef, 0x1a6016be,
  0x0aa3c22a, 0x6710ee47, 0x9aa56078, 0x9aa095c4,
  0xd773f55a, 0x11c14397, 0x1ab06048, 0x1aaa95a4,
  0xa4418ef3, 0xbc6d4396, 0x9ab4e03f, 0x9aae159e,
  0x710ef559, 0x6718ee40, 0x1ab8e039, 0x1ab1159a,
  0xcce69980, 0xaad5aa81, 0x8042fe82, 0x8041ff20,
  0x99ccffcd, 0x55aaffac, 0x00857d05, 0x00837e22,
  0x66b332e7, 0x007fff82, 0x80c77b8b, 0x80c47d26,
  0x339932ce, 0xab54aa03, 0x0108fa14, 0x0104fc2c,
  0x006965fe, 0x5604ff53, 0x8113f9e4, 0x810efc0c,
  0xcd36ff97, 0x00b0ff52, 0x011879db, 0x01127c06,
  0x9a0465fd, 0xab5ca9fc, 0x811c79d5, 0x81157c02,
  0x66d19930, 0x5607ff51, 0x011ff9d2, 0x0117fc00,
  0xaad5552b, 0x80427e84, 0x80417f04, 0x80407fa1,
  0x55aa5501, 0x00847d0a, 0x00827e08, 0x00807f23,
  0x007eff82, 0x80c5fb93, 0x80c2fd0e, 0x80bffea6,
  0xab2f54d2, 0x00d0fb63, 0x00ccfcee, 0x00c8fe96,
  0x55db54d1, 0x80d57b5a, 0x80d07ce8, 0x80cb7e93,
  0x0086ff7b, 0x00d97b54, 0x00d37ce4, 0x00cd7e91,
  0xab3254d0, 0x80dcfb51, 0x80d5fce2, 0x80cefe90,
  0xab3254d0, 0x80dcfb51, 0x80d5fce2, 0x80cefe90,
  0xaad4ffd6, 0x8041fe87, 0x8040ff06, 0x803fffa2,
  0x55a9aa57, 0x00837d10, 0x00817e0c, 0x007f7f25,
  0x0059ffa7, 0x808e7ce0, 0x808b7dec, 0x80887f15,
  0xab05ffa6, 0x0092fcd7, 0x008efde6, 0x008aff12,
  0x55b1aa50, 0x8096fcd1, 0x8091fde2, 0x808cff10,
  0x005cffa5, 0x009a7cce, 0x00947de0, 0x008e7f0f,
  0x005cffa5, 0x009a7cce, 0x00947de0, 0x008e7f0f,
  0x005caa50, 0x0099fcd1, 0x0093fde2, 0x008dff10,
  0xaad4aa81, 0x80417e8a, 0x80407f08, 0x803f7fa3,
  0x5584ffd1, 0x004c7e5a, 0x004a7ee8, 0x00487f93,
  0x0030ffd0, 0x8050fe51, 0x804dfee2, 0x804aff90,
  0xaadcaa7a, 0x0054fe4b, 0x0050fede, 0x004cff8e,
  0x5587ffcf, 0x80587e48, 0x80537edc, 0x804e7f8d,
  0x5587ffcf, 0x80587e48, 0x80537edc, 0x804e7f8d,
  0x5587aa7a, 0x8057fe4b, 0x8052fede, 0x804dff8e,
  0x5586ffd0, 0x8056fe51, 0x8051fee2, 0x804cff90,
  0xaab05550, 0x800affd1, 0x8009ffe2, 0x80090010,
  0x555c554f, 0x000f7fc8, 0x000d7fdc, 0x000b800d,
  0x0007fff9, 0x80137fc2, 0x80107fd8, 0x800d800b,
  0xaab3554e, 0x0016ffbf, 0x0012ffd6, 0x000f000a,
  0xaab3554e, 0x0016ffbf, 0x0012ffd6, 0x000f000a,
  0xaab2fff9, 0x00167fc2, 0x00127fd8, 0x000e800b,
  0xaab2554f, 0x00157fc8, 0x00117fdc, 0x000d800d,
  0xaaacffff, 0x000d7ff8, 0x00097ffc, 0x0005801d,
  0xaaabffff, 0x80047ff8, 0x80037ffc, 0x8002801d,
  0x5557aaa9, 0x00087ff2, 0x00067ff8, 0x0004801b,
  0x0002fffe, 0x800bffef, 0x8008fff6, 0x8006001a,
  0x0002fffe, 0x800bffef, 0x8008fff6, 0x8006001a,
  0x0002aaa9, 0x800b7ff2, 0x80087ff8, 0x8005801b,
  0x0001ffff, 0x800a7ff8, 0x80077ffc, 0x8004801d,
  0xfffcaaaf, 0x80028028, 0x7fff801c, 0x7ffc802d,
  0xffd3002e, 0x7fc4019f, 0x7fc10116, 0x7fbe00aa,
  0xaaabaaaa, 0x8003fffb, 0x8002fffe, 0x8002001e,
  0x5556ffff, 0x00077ff8, 0x00057ffc, 0x0003801d,
  0x5556ffff, 0x00077ff8, 0x00057ffc, 0x0003801d,
  0x5556aaaa, 0x0006fffb, 0x0004fffe, 0x0003001e,
  0x55560000, 0x00060001, 0x00040002, 0x00020020,
  0x5550aab0, 0xfffe0031, 0xfffc0022, 0xfffa0030,
  0x5527002f, 0xffbf81a8, 0xffbd811c, 0xffbb80ad,
  0x54fd0059, 0xff808322, 0xff7e8218, 0xff7c812b,
  0xaaab5555, 0x80037ffe, 0x80028000, 0x8001801f,
  0xaaab5555, 0x80037ffe, 0x80028000, 0x8001801f,
  0xaaab0000, 0x80030001, 0x80020002, 0x80010020,
  0xaaaa5556, 0x80020007, 0x80010006, 0x80000022,
  0xaaa50006, 0x7ffa0037, 0x7ff90026, 0x7ff80032,
  0xaa7b5585, 0x7fbb81ae, 0x7fba8120, 0x7fb980af,
  0xaa5155af, 0x7f7c8328, 0x7f7b821c, 0x7f7a812d,
  0xaa270084, 0x7f3d04a5, 0x7f3c031a, 0x7f3b01ac,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffaaab, 0xffff8004, 0xffff8004, 0xffff8021,
  0xffff0001, 0xfffe800a, 0xfffe8008, 0xfffe8023,
  0xfff9aab1, 0xfff6803a, 0xfff68028, 0xfff68033,
  0xffd00030, 0xffb801b1, 0xffb80122, 0xffb800b0,
  0xffa6005a, 0xff79032b, 0xff79021e, 0xff79012e,
  0xff7bab2f, 0xff3984a8, 0xff39831c, 0xff3981ad,
  0xee6abc40, 0xe5a09e41, 0xe5a06982, 0xe5a034e0,
  0xffffaaab, 0xffff8004, 0xffff8004, 0xffff8021,
  0xffff0001, 0xfffe800a, 0xfffe8008, 0xfffe8023,
  0xfff9aab1, 0xfff6803a, 0xfff68028, 0xfff68033,
  0xffd00030, 0xffb801b1, 0xffb80122, 0xffb800b0,
  0xffa6005a, 0xff79032b, 0xff79021e, 0xff79012e,
  0xff7bab2f, 0xff3984a8, 0xff39831c, 0xff3981ad,
  0xee6abc40, 0xe5a09e41, 0xe5a06982, 0xe5a034e0,
  0xd1f92e07, 0xbaf71e40, 0xbaf6942c, 0xbaf60a35,
  0xffff5556, 0xffff0007, 0xffff0006, 0xffff0022,
  0xfffa0006, 0xfff70037, 0xfff70026, 0xfff70032,
  0xffd05585, 0xffb881ae, 0xffb88120, 0xffb880af,
  0xffa655af, 0xff798328, 0xff79821c, 0xff79812d,
  0xff7c0084, 0xff3a04a5, 0xff3a031a, 0xff3a01ac,
  0xee6b1195, 0xe5a11e3e, 0xe5a0e980, 0xe5a0b4df,
  0xd1f9835c, 0xbaf79e3d, 0xbaf7142a, 0xbaf68a34,
  0xa750035b, 0x7afa9e34, 0x7af99424, 0x7af88a31,
  0xfffaaab0, 0xfff80031, 0xfff80022, 0xfff80030,
  0xffd1002f, 0xffb981a8, 0xffb9811c, 0xffb980ad,
  0xffa70059, 0xff7a8322, 0xff7a8218, 0xff7a812b,
  0xff7cab2e, 0xff3b049f, 0xff3b0316, 0xff3b01aa,
  0xee6bbc3f, 0xe5a21e38, 0xe5a1e97c, 0xe5a1b4dd,
  0xd1fa2e06, 0xbaf89e37, 0xbaf81426, 0xbaf78a32,
  0xa750ae05, 0x7afb9e2e, 0x7afa9420, 0x7af98a2f,
  0x7ca6d8af, 0x3afe1e28, 0x3afc941c, 0x3afb0a2d,
  0xffd6557f, 0xffc18178, 0xffc180fc, 0xffc1809d,
  0xffac55a9, 0xff8282f2, 0xff8281f8, 0xff82811b,
  0xff82007e, 0xff43046f, 0xff4302f6, 0xff43019a,
  0xee71118f, 0xe5aa1e08, 0xe5a9e95c, 0xe5a9b4cd,
  0xd1ff8356, 0xbb009e07, 0xbb001406, 0xbaff8a22,
  0xa7560355, 0x7b039dfe, 0x7b029400, 0x7b018a1f,
  0x7cac2dff, 0x3b061df8, 0x3b0493fc, 0x3b030a1d,
  0x52020354, 0xfb081df5, 0xfb0613fa, 0xfb040a1c,
  0xffd6002a, 0xffc1017b, 0xffc100fe, 0xffc1009e,
  0xffabaaff, 0xff8182f8, 0xff8181fc, 0xff81811d,
  0xee9abc10, 0xe5e89c91, 0xe5e86862, 0xe5e83450,
  0xd2292dd7, 0xbb3f1c90, 0xbb3e930c, 0xbb3e09a5,
  0xa77fadd6, 0x7b421c87, 0x7b411306, 0x7b4009a2,
  0x7cd5d880, 0x3b449c81, 0x3b431302, 0x3b4189a0,
  0x522badd5, 0xfb469c7e, 0xfb449300, 0xfb42899f,
  0x27812dd5, 0xbb481c7e, 0xbb459300, 0xbb43099f,
  0xffd5aad5, 0xffc0817e, 0xffc08100, 0xffc0809f,
  0xeec4bbe6, 0xe6279b17, 0xe6276766, 0xe62733d2,
  0xd2532dad, 0xbb7e1b16, 0xbb7d9210, 0xbb7d0927,
  0xa7a9adac, 0x7b811b0d, 0x7b80120a, 0x7b7f0924,
  0x7cffd856, 0x3b839b07, 0x3b821206, 0x3b808922,
  0x5255adab, 0xfb859b04, 0xfb839204, 0xfb818921,
  0x27ab2dab, 0xbb871b04, 0xbb849204, 0xbb820921,
  0xfd005856, 0x7b881b07, 0x7b851206, 0x7b820922,
  0xeeef1111, 0xe667199a, 0xe666e668, 0xe666b353,
  0xd27d82d8, 0xbbbd9999, 0xbbbd1112, 0xbbbc88a8,
  0xa7d402d7, 0x7bc09990, 0x7bbf910c, 0x7bbe88a5,
  0x7d2a2d81, 0x3bc3198a, 0x3bc19108, 0x3bc008a3,
  0x528002d6, 0xfbc51987, 0xfbc31106, 0xfbc108a2,
  0x27d582d6, 0xbbc69987, 0xbbc41106, 0xbbc188a2,
  0xfd2aad81, 0x7bc7998a, 0x7bc49108, 0x7bc188a3,
  0xc447910f, 0x26749988, 0x2670e65c, 0x266d334d,
  0xe38e71c7, 0xd5568000, 0xd5562aac, 0xd555d575,
  0xb8e4f1c6, 0x95597ff7, 0x9558aaa6, 0x9557d572,
  0x8e3b1c70, 0x555bfff1, 0x555aaaa2, 0x55595570,
  0x6390f1c5, 0x155dffee, 0x155c2aa0, 0x155a556f,
  0x38e671c5, 0xd55f7fee, 0xd55d2aa0, 0xd55ad56f,
  0x0e3b9c70, 0x95607ff1, 0x955daaa2, 0x955ad570,
  0xd5587ffe, 0x400d7fef, 0x4009fff6, 0x4006801a,
  0x9114c442, 0xd9a9e653, 0xd9a5998e, 0xd9a14ce6,
  0xd5567fff, 0xc002fff8, 0xc0027ffc, 0xc002001d,
  0xaaacaaa9, 0x80057ff2, 0x80047ff8, 0x8003801b,
  0x80027ffe, 0x40077fef, 0x4005fff6, 0x4004801a,
  0x5557fffe, 0x0008ffef, 0x0006fff6, 0x0005001a,
  0x2aad2aa9, 0xc009fff2, 0xc0077ff8, 0xc005001b,
  0xf1ca0e37, 0x6ab6fff0, 0x6ab3d54c, 0x6ab0aac5,
  0xad86527b, 0x04536654, 0x044f6ee4, 0x044b7791,
  0x585bfcfb, 0x849664d4, 0x84916de4, 0x848c7711,
  0xd5562aaa, 0xc0027ffb, 0xc001fffe, 0xc001801e,
  0xaaabffff, 0x80047ff8, 0x80037ffc, 0x8002801d,
  0x80017fff, 0x4005fff8, 0x40047ffc, 0x4003001d,
  0x5556aaaa, 0x0006fffb, 0x0004fffe, 0x0003001e,
  0x1c738e38, 0xaab3fff9, 0xaab15552, 0xaaaeaac8,
  0xd82fd27c, 0x4450665d, 0x444ceeea, 0x44497794,
  0x83057cfc, 0xc49364dd, 0xc48eedea, 0xc48a7714,
  0x2ddad227, 0x44d5e360, 0x44d06cec, 0x44caf695,
  0xd555d555, 0xc001fffe, 0xc0018000, 0xc001001f,
  0xaaab5555, 0x80037ffe, 0x80028000, 0x8001801f,
  0x80008000, 0x40048001, 0x40030002, 0x40018020,
  0x471d638e, 0xeab17fff, 0xeaaf5556, 0xeaad2aca,
  0x02d9a7d2, 0x844de663, 0x844aeeee, 0x8447f796,
  0xadaf5252, 0x0490e4e3, 0x048cedee, 0x0488f716,
  0x5884a77d, 0x84d36366, 0x84ce6cf0, 0x84c97697,
  0x0359a753, 0x051561ec, 0x050f6bf4, 0x05097619,
  0xd5558000, 0xc0018001, 0xc0010002, 0xc0008020,
  0xaaaaaaab, 0x80028004, 0x80018004, 0x80008021,
  0x71c78e39, 0x2aaf8002, 0x2aadd558, 0x2aac2acb,
  0x2d83d27d, 0xc44be666, 0xc4496ef0, 0xc446f797,
  0xd8597cfd, 0x448ee4e6, 0x448b6df0, 0x4487f717,
  0x832ed228, 0xc4d16369, 0xc4ccecf2, 0xc4c87698,
  0x2e03d1fe, 0x451361ef, 0x450debf6, 0x4508761a,
  0xd8d87c7f, 0xc554e078, 0xc54e6afc, 0xc547f59d,
  0xd5552aab, 0xc0010004, 0xc0008004, 0xc0000021,
  0x9c720e39, 0x6aae0002, 0x6aacd558, 0x6aabaacb,
  0x582e527d, 0x044a6666, 0x04486ef0, 0x04467797,
  0x0303fcfd, 0x848d64e6, 0x848a6df0, 0x84877717,
  0xadd95228, 0x04cfe369, 0x04cbecf2, 0x04c7f698,
  0x58ae51fe, 0x8511e1ef, 0x850cebf6, 0x8507f61a,
  0x0382fc7f, 0x05536078, 0x054d6afc, 0x0547759d,
  0xae3351cf, 0x855e6048, 0x85576adc, 0x8550758d,
  0xc71ce38e, 0xaaacffff, 0xaaac5556, 0xaaabaaca,
  0x82d927d2, 0x44496663, 0x4447eeee, 0x44467796,
  0x2daed252, 0xc48c64e3, 0xc489edee, 0xc4877716,
  0xd884277d, 0x44cee366, 0x44cb6cf0, 0x44c7f697,
  0x83592753, 0xc510e1ec, 0xc50c6bf4, 0xc507f619,
  0x2e2dd1d4, 0x45526075, 0x454ceafa, 0x4547759c,
  0xd8de2724, 0xc55d6045, 0xc556eada, 0xc550758c,
  0x838a2723, 0x4561e03c, 0x455a6ad4, 0x4552f589,
  0xbbbc4444, 0x999c6665, 0x999b999a, 0x999accec,
  0x6691eec4, 0x19df64e5, 0x19dd989a, 0x19dbcc6c,
  0x116743ef, 0x9a21e368, 0x9a1f179c, 0x9a1c4bed,
  0xbc3c43c5, 0x1a63e1ee, 0x1a6016a0, 0x1a5c4b6f,
  0x6710ee46, 0x9aa56077, 0x9aa095a6, 0x9a9bcaf2,
  0x11c14396, 0x1ab06047, 0x1aaa9586, 0x1aa4cae2,
  0xbc6d4395, 0x9ab4e03e, 0x9aae1580, 0x9aa74adf,
  0x6718ee3f, 0x1ab8e038, 0x1ab1157c, 0x1aa94add,
  0xaad5aa80, 0x8042fe81, 0x8041ff02, 0x8040ffa0,
  0x55aaffab, 0x00857d04, 0x00837e04, 0x00817f21,
  0x007fff81, 0x80c77b8a, 0x80c47d08, 0x80c17ea3,
  0xab54aa02, 0x0108fa13, 0x0104fc0e, 0x0100fe26,
  0x5604ff52, 0x8113f9e3, 0x810efbee, 0x8109fe16,
  0x00b0ff51, 0x011879da, 0x01127be8, 0x010c7e13,
  0xab5ca9fb, 0x811c79d4, 0x81157be4, 0x810e7e11,
  0x5607ff50, 0x011ff9d1, 0x0117fbe2, 0x010ffe10,
  0x80427e83, 0x80417f03, 0x80407f83, 0x00000020,
  0x00847d09, 0x00827e07, 0x00807f05, 0x00000020,
  0x80c5fb92, 0x80c2fd0d, 0x80bffe88, 0x00000020,
  0x00d0fb62, 0x00ccfced, 0x00c8fe78, 0x00000020,
  0x80d57b59, 0x80d07ce7, 0x80cb7e75, 0x00000020,
  0x00d97b53, 0x00d37ce3, 0x00cd7e73, 0x00000020,
  0x80dcfb50, 0x80d5fce1, 0x80cefe72, 0x00000020,
  0x80dcfb50, 0x80d5fce1, 0x80cefe72, 0x00000020,
  0x8041fe86, 0x8040ff05, 0x803fff84, 0x00000020,
  0x00837d0f, 0x00817e0b, 0x007f7f07, 0x00000020,
  0x808e7cdf, 0x808b7deb, 0x80887ef7, 0x00000020,
  0x0092fcd6, 0x008efde5, 0x008afef4, 0x00000020,
  0x8096fcd0, 0x8091fde1, 0x808cfef2, 0x00000020,
  0x009a7ccd, 0x00947ddf, 0x008e7ef1, 0x00000020,
  0x009a7ccd, 0x00947ddf, 0x008e7ef1, 0x00000020,
  0x0099fcd0, 0x0093fde1, 0x008dfef2, 0x00000020,
  0x80417e89, 0x80407f07, 0x803f7f85, 0x00000020,
  0x004c7e59, 0x004a7ee7, 0x00487f75, 0x00000020,
  0x8050fe50, 0x804dfee1, 0x804aff72, 0x00000020,
  0x0054fe4a, 0x0050fedd, 0x004cff70, 0x00000020,
  0x80587e47, 0x80537edb, 0x804e7f6f, 0x00000020,
  0x80587e47, 0x80537edb, 0x804e7f6f, 0x00000020,
  0x8057fe4a, 0x8052fedd, 0x804dff70, 0x00000020,
  0x8056fe50, 0x8051fee1, 0x804cff72, 0x00000020,
  0x800affd0, 0x8009ffe1, 0x8008fff2, 0x00000020,
  0x000f7fc7, 0x000d7fdb, 0x000b7fef, 0x00000020,
  0x80137fc1, 0x80107fd7, 0x800d7fed, 0x00000020,
  0x0016ffbe, 0x0012ffd5, 0x000effec, 0x00000020,
  0x0016ffbe, 0x0012ffd5, 0x000effec, 0x00000020,
  0x00167fc1, 0x00127fd7, 0x000e7fed, 0x00000020,
  0x00157fc7, 0x00117fdb, 0x000d7fef, 0x00000020,
  0x000d7ff7, 0x00097ffb, 0x00057fff, 0x00000020,
  0x80047ff7, 0x80037ffb, 0x80027fff, 0x00000020,
  0x00087ff1, 0x00067ff7, 0x00047ffd, 0x00000020,
  0x800bffee, 0x8008fff5, 0x8005fffc, 0x00000020,
  0x800bffee, 0x8008fff5, 0x8005fffc, 0x00000020,
  0x800b7ff1, 0x80087ff7, 0x80057ffd, 0x00000020,
  0x800a7ff7, 0x80077ffb, 0x80047fff, 0x00000020,
  0x80028027, 0x7fff801b, 0x7ffc800f, 0x00000020,
  0x7fc4019e, 0x7fc10115, 0x7fbe008c, 0x00000020,
  0x8003fffa, 0x8002fffd, 0x80020000, 0x00000020,
  0x00077ff7, 0x00057ffb, 0x00037fff, 0x00000020,
  0x00077ff7, 0x00057ffb, 0x00037fff, 0x00000020,
  0x0006fffa, 0x0004fffd, 0x00030000, 0x00000020,
  0x00060000, 0x00040001, 0x00020002, 0x00000020,
  0xfffe0030, 0xfffc0021, 0xfffa0012, 0x00000020,
  0xffbf81a7, 0xffbd811b, 0xffbb808f, 0x00000020,
  0xff808321, 0xff7e8217, 0xff7c810d, 0x00000020,
  0x80037ffd, 0x80027fff, 0x80018001, 0x00000020,
  0x80037ffd, 0x80027fff, 0x80018001, 0x00000020,
  0x80030000, 0x80020001, 0x80010002, 0x00000020,
  0x80020006, 0x80010005, 0x80000004, 0x00000020,
  0x7ffa0036, 0x7ff90025, 0x7ff80014, 0x00000020,
  0x7fbb81ad, 0x7fba811f, 0x7fb98091, 0x00000020,
  0x7f7c8327, 0x7f7b821b, 0x7f7a810f, 0x00000020,
  0x7f3d04a4, 0x7f3c0319, 0x7f3b018e, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff8003, 0xffff8003, 0xffff8003, 0x00000020,
  0xfffe8009, 0xfffe8007, 0xfffe8005, 0x00000020,
  0xfff68039, 0xfff68027, 0xfff68015, 0x00000020,
  0xffb801b0, 0xffb80121, 0xffb80092, 0x00000020,
  0xff79032a, 0xff79021d, 0xff790110, 0x00000020,
  0xff3984a7, 0xff39831b, 0xff39818f, 0x00000020,
  0xe5a09e40, 0xe5a06981, 0xe5a034c2, 0x00000020,
  0xffff8003, 0xffff8003, 0xffff8003, 0x00000020,
  0xfffe8009, 0xfffe8007, 0xfffe8005, 0x00000020,
  0xfff68039, 0xfff68027, 0xfff68015, 0x00000020,
  0xffb801b0, 0xffb80121, 0xffb80092, 0x00000020,
  0xff79032a, 0xff79021d, 0xff790110, 0x00000020,
  0xff3984a7, 0xff39831b, 0xff39818f, 0x00000020,
  0xe5a09e40, 0xe5a06981, 0xe5a034c2, 0x00000020,
  0xbaf71e3f, 0xbaf6942b, 0xbaf60a17, 0x00000020,
  0xffff0006, 0xffff0005, 0xffff0004, 0x00000020,
  0xfff70036, 0xfff70025, 0xfff70014, 0x00000020,
  0xffb881ad, 0xffb8811f, 0xffb88091, 0x00000020,
  0xff798327, 0xff79821b, 0xff79810f, 0x00000020,
  0xff3a04a4, 0xff3a0319, 0xff3a018e, 0x00000020,
  0xe5a11e3d, 0xe5a0e97f, 0xe5a0b4c1, 0x00000020,
  0xbaf79e3c, 0xbaf71429, 0xbaf68a16, 0x00000020,
  0x7afa9e33, 0x7af99423, 0x7af88a13, 0x00000020,
  0xfff80030, 0xfff80021, 0xfff80012, 0x00000020,
  0xffb981a7, 0xffb9811b, 0xffb9808f, 0x00000020,
  0xff7a8321, 0xff7a8217, 0xff7a810d, 0x00000020,
  0xff3b049e, 0xff3b0315, 0xff3b018c, 0x00000020,
  0xe5a21e37, 0xe5a1e97b, 0xe5a1b4bf, 0x00000020,
  0xbaf89e36, 0xbaf81425, 0xbaf78a14, 0x00000020,
  0x7afb9e2d, 0x7afa941f, 0x7af98a11, 0x00000020,
  0x3afe1e27, 0x3afc941b, 0x3afb0a0f, 0x00000020,
  0xffc18177, 0xffc180fb, 0xffc1807f, 0x00000020,
  0xff8282f1, 0xff8281f7, 0xff8280fd, 0x00000020,
  0xff43046e, 0xff4302f5, 0xff43017c, 0x00000020,
  0xe5aa1e07, 0xe5a9e95b, 0xe5a9b4af, 0x00000020,
  0xbb009e06, 0xbb001405, 0xbaff8a04, 0x00000020,
  0x7b039dfd, 0x7b0293ff, 0x7b018a01, 0x00000020,
  0x3b061df7, 0x3b0493fb, 0x3b0309ff, 0x00000020,
  0xfb081df4, 0xfb0613f9, 0xfb0409fe, 0x00000020,
  0xffc1017a, 0xffc100fd, 0xffc10080, 0x00000020,
  0xff8182f7, 0xff8181fb, 0xff8180ff, 0x00000020,
  0xe5e89c90, 0xe5e86861, 0xe5e83432, 0x00000020,
  0xbb3f1c8f, 0xbb3e930b, 0xbb3e0987, 0x00000020,
  0x7b421c86, 0x7b411305, 0x7b400984, 0x00000020,
  0x3b449c80, 0x3b431301, 0x3b418982, 0x00000020,
  0xfb469c7d, 0xfb4492ff, 0xfb428981, 0x00000020,
  0xbb481c7d, 0xbb4592ff, 0xbb430981, 0x00000020,
  0xffc0817d, 0xffc080ff, 0xffc08081, 0x00000020,
  0xe6279b16, 0xe6276765, 0xe62733b4, 0x00000020,
  0xbb7e1b15, 0xbb7d920f, 0xbb7d0909, 0x00000020,
  0x7b811b0c, 0x7b801209, 0x7b7f0906, 0x00000020,
  0x3b839b06, 0x3b821205, 0x3b808904, 0x00000020,
  0xfb859b03, 0xfb839203, 0xfb818903, 0x00000020,
  0xbb871b03, 0xbb849203, 0xbb820903, 0x00000020,
  0x7b881b06, 0x7b851205, 0x7b820904, 0x00000020,
  0xe6671999, 0xe666e667, 0xe666b335, 0x00000020,
  0xbbbd9998, 0xbbbd1111, 0xbbbc888a, 0x00000020,
  0x7bc0998f, 0x7bbf910b, 0x7bbe8887, 0x00000020,
  0x3bc31989, 0x3bc19107, 0x3bc00885, 0x00000020,
  0xfbc51986, 0xfbc31105, 0xfbc10884, 0x00000020,
  0xbbc69986, 0xbbc41105, 0xbbc18884, 0x00000020,
  0x7bc79989, 0x7bc49107, 0x7bc18885, 0x00000020,
  0x26749987, 0x2670e65b, 0x266d332f, 0x00000020,
  0xd5567fff, 0xd5562aab, 0xd555d557, 0x00000020,
  0x95597ff6, 0x9558aaa5, 0x9557d554, 0x00000020,
  0x555bfff0, 0x555aaaa1, 0x55595552, 0x00000020,
  0x155dffed, 0x155c2a9f, 0x155a5551, 0x00000020,
  0xd55f7fed, 0xd55d2a9f, 0xd55ad551, 0x00000020,
  0x95607ff0, 0x955daaa1, 0x955ad552, 0x00000020,
  0x400d7fee, 0x4009fff5, 0x40067ffc, 0x00000020,
  0xd9a9e652, 0xd9a5998d, 0xd9a14cc8, 0x00000020,
  0xc002fff7, 0xc0027ffb, 0xc001ffff, 0x00000020,
  0x80057ff1, 0x80047ff7, 0x80037ffd, 0x00000020,
  0x40077fee, 0x4005fff5, 0x40047ffc, 0x00000020,
  0x0008ffee, 0x0006fff5, 0x0004fffc, 0x00000020,
  0xc009fff1, 0xc0077ff7, 0xc004fffd, 0x00000020,
  0x6ab6ffef, 0x6ab3d54b, 0x6ab0aaa7, 0x00000020,
  0x04536653, 0x044f6ee3, 0x044b7773, 0x00000020,
  0x849664d3, 0x84916de3, 0x848c76f3, 0x00000020,
  0xc0027ffa, 0xc001fffd, 0xc0018000, 0x00000020,
  0x80047ff7, 0x80037ffb, 0x80027fff, 0x00000020,
  0x4005fff7, 0x40047ffb, 0x4002ffff, 0x00000020,
  0x0006fffa, 0x0004fffd, 0x00030000, 0x00000020,
  0xaab3fff8, 0xaab15551, 0xaaaeaaaa, 0x00000020,
  0x4450665c, 0x444ceee9, 0x44497776, 0x00000020,
  0xc49364dc, 0xc48eede9, 0xc48a76f6, 0x00000020,
  0x44d5e35f, 0x44d06ceb, 0x44caf677, 0x00000020,
  0xc001fffd, 0xc0017fff, 0xc0010001, 0x00000020,
  0x80037ffd, 0x80027fff, 0x80018001, 0x00000020,
  0x40048000, 0x40030001, 0x40018002, 0x00000020,
  0xeab17ffe, 0xeaaf5555, 0xeaad2aac, 0x00000020,
  0x844de662, 0x844aeeed, 0x8447f778, 0x00000020,
  0x0490e4e2, 0x048ceded, 0x0488f6f8, 0x00000020,
  0x84d36365, 0x84ce6cef, 0x84c97679, 0x00000020,
  0x051561eb, 0x050f6bf3, 0x050975fb, 0x00000020,
  0xc0018000, 0xc0010001, 0xc0008002, 0x00000020,
  0x80028003, 0x80018003, 0x80008003, 0x00000020,
  0x2aaf8001, 0x2aadd557, 0x2aac2aad, 0x00000020,
  0xc44be665, 0xc4496eef, 0xc446f779, 0x00000020,
  0x448ee4e5, 0x448b6def, 0x4487f6f9, 0x00000020,
  0xc4d16368, 0xc4ccecf1, 0xc4c8767a, 0x00000020,
  0x451361ee, 0x450debf5, 0x450875fc, 0x00000020,
  0xc554e077, 0xc54e6afb, 0xc547f57f, 0x00000020,
  0xc0010003, 0xc0008003, 0xc0000003, 0x00000020,
  0x6aae0001, 0x6aacd557, 0x6aabaaad, 0x00000020,
  0x044a6665, 0x04486eef, 0x04467779, 0x00000020,
  0x848d64e5, 0x848a6def, 0x848776f9, 0x00000020,
  0x04cfe368, 0x04cbecf1, 0x04c7f67a, 0x00000020,
  0x8511e1ee, 0x850cebf5, 0x8507f5fc, 0x00000020,
  0x05536077, 0x054d6afb, 0x0547757f, 0x00000020,
  0x855e6047, 0x85576adb, 0x8550756f, 0x00000020,
  0xaaacfffe, 0xaaac5555, 0xaaabaaac, 0x00000020,
  0x44496662, 0x4447eeed, 0x44467778, 0x00000020,
  0xc48c64e2, 0xc489eded, 0xc48776f8, 0x00000020,
  0x44cee365, 0x44cb6cef, 0x44c7f679, 0x00000020,
  0xc510e1eb, 0xc50c6bf3, 0xc507f5fb, 0x00000020,
  0x45526074, 0x454ceaf9, 0x4547757e, 0x00000020,
  0xc55d6044, 0xc556ead9, 0xc550756e, 0x00000020,
  0x4561e03b, 0x455a6ad3, 0x4552f56b, 0x00000020,
  0x999c6664, 0x999b9999, 0x999accce, 0x00000020,
  0x19df64e4, 0x19dd9899, 0x19dbcc4e, 0x00000020,
  0x9a21e367, 0x9a1f179b, 0x9a1c4bcf, 0x00000020,
  0x1a63e1ed, 0x1a60169f, 0x1a5c4b51, 0x00000020,
  0x9aa56076, 0x9aa095a5, 0x9a9bcad4, 0x00000020,
  0x1ab06046, 0x1aaa9585, 0x1aa4cac4, 0x00000020,
  0x9ab4e03d, 0x9aae157f, 0x9aa74ac1, 0x00000020,
  0x1ab8e037, 0x1ab1157b, 0x1aa94abf, 0x00000020,
  0x8042fe80, 0x8041ff01, 0x8040ff82, 0x00000020,
  0x00857d03, 0x00837e03, 0x00817f03, 0x00000020,
  0x80c77b89, 0x80c47d07, 0x80c17e85, 0x00000020,
  0x0108fa12, 0x0104fc0d, 0x0100fe08, 0x00000020,
  0x8113f9e2, 0x810efbed, 0x8109fdf8, 0x00000020,
  0x011879d9, 0x01127be7, 0x010c7df5, 0x00000020,
  0x811c79d3, 0x81157be3, 0x810e7df3, 0x00000020,
  0x011ff9d0, 0x0117fbe1, 0x010ffdf2, 0x00000020,
  0x80417f02, 0x80407f82, 0x00000002, 0xffff009f,
  0x00827e06, 0x00807f04, 0x00000002, 0xfffe011d,
  0x80c2fd0c, 0x80bffe87, 0x00000002, 0xfffd019a,
  0x00ccfcec, 0x00c8fe77, 0x00000002, 0xfffc01aa,
  0x80d07ce6, 0x80cb7e74, 0x00000002, 0xfffb01ad,
  0x00d37ce2, 0x00cd7e72, 0x00000002, 0xfffa01af,
  0x80d5fce0, 0x80cefe71, 0x00000002, 0xfff901b0,
  0x80d5fce0, 0x80cefe71, 0x00000002, 0xfff901b0,
  0x8040ff04, 0x803fff83, 0x00000002, 0xffff009e,
  0x00817e0a, 0x007f7f06, 0x00000002, 0xfffe011b,
  0x808b7dea, 0x80887ef6, 0x00000002, 0xfffd012b,
  0x008efde4, 0x008afef3, 0x00000002, 0xfffc012e,
  0x8091fde0, 0x808cfef1, 0x00000002, 0xfffb0130,
  0x00947dde, 0x008e7ef0, 0x00000002, 0xfffa0131,
  0x00947dde, 0x008e7ef0, 0x00000002, 0xfffa0131,
  0x0093fde0, 0x008dfef1, 0x00000002, 0xfffa0130,
  0x80407f06, 0x803f7f84, 0x00000002, 0xffff009d,
  0x004a7ee6, 0x00487f74, 0x00000002, 0xfffe00ad,
  0x804dfee0, 0x804aff71, 0x00000002, 0xfffd00b0,
  0x0050fedc, 0x004cff6f, 0x00000002, 0xfffc00b2,
  0x80537eda, 0x804e7f6e, 0x00000002, 0xfffb00b3,
  0x80537eda, 0x804e7f6e, 0x00000002, 0xfffb00b3,
  0x8052fedc, 0x804dff6f, 0x00000002, 0xfffb00b2,
  0x8051fee0, 0x804cff71, 0x00000002, 0xfffb00b0,
  0x8009ffe0, 0x8008fff1, 0x00000002, 0xffff0030,
  0x000d7fda, 0x000b7fee, 0x00000002, 0xfffe0033,
  0x80107fd6, 0x800d7fec, 0x00000002, 0xfffd0035,
  0x0012ffd4, 0x000effeb, 0x00000002, 0xfffc0036,
  0x0012ffd4, 0x000effeb, 0x00000002, 0xfffc0036,
  0x00127fd6, 0x000e7fec, 0x00000002, 0xfffc0035,
  0x00117fda, 0x000d7fee, 0x00000002, 0xfffc0033,
  0x00097ffa, 0x00057ffe, 0x00000002, 0xfffc0023,
  0x80037ffa, 0x80027ffe, 0x00000002, 0xffff0023,
  0x00067ff6, 0x00047ffc, 0x00000002, 0xfffe0025,
  0x8008fff4, 0x8005fffb, 0x00000002, 0xfffd0026,
  0x8008fff4, 0x8005fffb, 0x00000002, 0xfffd0026,
  0x80087ff6, 0x80057ffc, 0x00000002, 0xfffd0025,
  0x80077ffa, 0x80047ffe, 0x00000002, 0xfffd0023,
  0x7fff801a, 0x7ffc800e, 0x00000002, 0xfffd0013,
  0x7fc10114, 0x7fbe008b, 0x00000002, 0xfffcff96,
  0x8002fffc, 0x8001ffff, 0x00000002, 0xffff0022,
  0x00057ffa, 0x00037ffe, 0x00000002, 0xfffe0023,
  0x00057ffa, 0x00037ffe, 0x00000002, 0xfffe0023,
  0x0004fffc, 0x0002ffff, 0x00000002, 0xfffe0022,
  0x00040000, 0x00020001, 0x00000002, 0xfffe0020,
  0xfffc0020, 0xfffa0011, 0x00000002, 0xfffe0010,
  0xffbd811a, 0xffbb808e, 0x00000002, 0xfffdff93,
  0xff7e8216, 0xff7c810c, 0x00000002, 0xfffdff15,
  0x80027ffe, 0x80018000, 0x00000002, 0xffff0021,
  0x80027ffe, 0x80018000, 0x00000002, 0xffff0021,
  0x80020000, 0x80010001, 0x00000002, 0xffff0020,
  0x80010004, 0x80000003, 0x00000002, 0xffff001e,
  0x7ff90024, 0x7ff80013, 0x00000002, 0xffff000e,
  0x7fba811e, 0x7fb98090, 0x00000002, 0xfffeff91,
  0x7f7b821a, 0x7f7a810e, 0x00000002, 0xfffeff13,
  0x7f3c0318, 0x7f3b018d, 0x00000002, 0xfffefe94,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff8002, 0xffff8002, 0x00000002, 0x0000001f,
  0xfffe8006, 0xfffe8004, 0x00000002, 0x0000001d,
  0xfff68026, 0xfff68014, 0x00000002, 0x0000000d,
  0xffb80120, 0xffb80091, 0x00000002, 0xffffff90,
  0xff79021c, 0xff79010f, 0x00000002, 0xffffff12,
  0xff39831a, 0xff39818e, 0x00000002, 0xfffffe93,
  0xe5a06980, 0xe5a034c1, 0x00000002, 0xffffcb60,
  0xffff8002, 0xffff8002, 0x00000002, 0x0000001f,
  0xfffe8006, 0xfffe8004, 0x00000002, 0x0000001d,
  0xfff68026, 0xfff68014, 0x00000002, 0x0000000d,
  0xffb80120, 0xffb80091, 0x00000002, 0xffffff90,
  0xff79021c, 0xff79010f, 0x00000002, 0xffffff12,
  0xff39831a, 0xff39818e, 0x00000002, 0xfffffe93,
  0xe5a06980, 0xe5a034c1, 0x00000002, 0xffffcb60,
  0xbaf6942a, 0xbaf60a16, 0x00000002, 0xffff760b,
  0xffff0004, 0xffff0003, 0x00000002, 0x0000001e,
  0xfff70024, 0xfff70013, 0x00000002, 0x0000000e,
  0xffb8811e, 0xffb88090, 0x00000002, 0xffffff91,
  0xff79821a, 0xff79810e, 0x00000002, 0xffffff13,
  0xff3a0318, 0xff3a018d, 0x00000002, 0xfffffe94,
  0xe5a0e97e, 0xe5a0b4c0, 0x00000002, 0xffffcb61,
  0xbaf71428, 0xbaf68a15, 0x00000002, 0xffff760c,
  0x7af99422, 0x7af88a12, 0x00000002, 0xfffef60f,
  0xfff80020, 0xfff80011, 0x00000002, 0x00000010,
  0xffb9811a, 0xffb9808e, 0x00000002, 0xffffff93,
  0xff7a8216, 0xff7a810c, 0x00000002, 0xffffff15,
  0xff3b0314, 0xff3b018b, 0x00000002, 0xfffffe96,
  0xe5a1e97a, 0xe5a1b4be, 0x00000002, 0xffffcb63,
  0xbaf81424, 0xbaf78a13, 0x00000002, 0xffff760e,
  0x7afa941e, 0x7af98a10, 0x00000002, 0xfffef611,
  0x3afc941a, 0x3afb0a0e, 0x00000002, 0xfffe7613,
  0xffc180fa, 0xffc1807e, 0x00000002, 0xffffffa3,
  0xff8281f6, 0xff8280fc, 0x00000002, 0xffffff25,
  0xff4302f4, 0xff43017b, 0x00000002, 0xfffffea6,
  0xe5a9e95a, 0xe5a9b4ae, 0x00000002, 0xffffcb73,
  0xbb001404, 0xbaff8a03, 0x00000002, 0xffff761e,
  0x7b0293fe, 0x7b018a00, 0x00000002, 0xfffef621,
  0x3b0493fa, 0x3b0309fe, 0x00000002, 0xfffe7623,
  0xfb0613f8, 0xfb0409fd, 0x00000002, 0xfffdf624,
  0xffc100fc, 0xffc1007f, 0x00000002, 0xffffffa2,
  0xff8181fa, 0xff8180fe, 0x00000002, 0xffffff23,
  0xe5e86860, 0xe5e83431, 0x00000002, 0xffffcbf0,
  0xbb3e930a, 0xbb3e0986, 0x00000002, 0xffff769b,
  0x7b411304, 0x7b400983, 0x00000002, 0xfffef69e,
  0x3b431300, 0x3b418981, 0x00000002, 0xfffe76a0,
  0xfb4492fe, 0xfb428980, 0x00000002, 0xfffdf6a1,
  0xbb4592fe, 0xbb430980, 0x00000002, 0xfffd76a1,
  0xffc080fe, 0xffc08080, 0x00000002, 0xffffffa1,
  0xe6276764, 0xe62733b3, 0x00000002, 0xffffcc6e,
  0xbb7d920e, 0xbb7d0908, 0x00000002, 0xffff7719,
  0x7b801208, 0x7b7f0905, 0x00000002, 0xfffef71c,
  0x3b821204, 0x3b808903, 0x00000002, 0xfffe771e,
  0xfb839202, 0xfb818902, 0x00000002, 0xfffdf71f,
  0xbb849202, 0xbb820902, 0x00000002, 0xfffd771f,
  0x7b851204, 0x7b820903, 0x00000002, 0xfffcf71e,
  0xe666e666, 0xe666b334, 0x00000002, 0xffffcced,
  0xbbbd1110, 0xbbbc8889, 0x00000002, 0xffff7798,
  0x7bbf910a, 0x7bbe8886, 0x00000002, 0xfffef79b,
  0x3bc19106, 0x3bc00884, 0x00000002, 0xfffe779d,
  0xfbc31104, 0xfbc10883, 0x00000002, 0xfffdf79e,
  0xbbc41104, 0xbbc18883, 0x00000002, 0xfffd779e,
  0x7bc49106, 0x7bc18884, 0x00000002, 0xfffcf79d,
  0x2670e65a, 0x266d332e, 0x00000002, 0xfffc4cf3,
  0xd5562aaa, 0xd555d556, 0x00000002, 0xffffaacb,
  0x9558aaa4, 0x9557d553, 0x00000002, 0xffff2ace,
  0x555aaaa0, 0x55595551, 0x00000002, 0xfffeaad0,
  0x155c2a9e, 0x155a5550, 0x00000002, 0xfffe2ad1,
  0xd55d2a9e, 0xd55ad550, 0x00000002, 0xfffdaad1,
  0x955daaa0, 0x955ad551, 0x00000002, 0xfffd2ad0,
  0x4009fff4, 0x40067ffb, 0x00000002, 0xfffc8026,
  0xd9a5998c, 0xd9a14cc7, 0x00000002, 0xfffbb35a,
  0xc0027ffa, 0xc001fffe, 0x00000002, 0xffff8023,
  0x80047ff6, 0x80037ffc, 0x00000002, 0xffff0025,
  0x4005fff4, 0x40047ffb, 0x00000002, 0xfffe8026,
  0x0006fff4, 0x0004fffb, 0x00000002, 0xfffe0026,
  0xc0077ff6, 0xc004fffc, 0x00000002, 0xfffd8025,
  0x6ab3d54a, 0x6ab0aaa6, 0x00000002, 0xfffcd57b,
  0x044f6ee2, 0x044b7772, 0x00000002, 0xfffc08af,
  0x84916de2, 0x848c76f2, 0x00000002, 0xfffb092f,
  0xc001fffc, 0xc0017fff, 0x00000002, 0xffff8022,
  0x80037ffa, 0x80027ffe, 0x00000002, 0xffff0023,
  0x40047ffa, 0x4002fffe, 0x00000002, 0xfffe8023,
  0x0004fffc, 0x0002ffff, 0x00000002, 0xfffe0022,
  0xaab15550, 0xaaaeaaa9, 0x00000002, 0xfffd5578,
  0x444ceee8, 0x44497775, 0x00000002, 0xfffc88ac,
  0xc48eede8, 0xc48a76f5, 0x00000002, 0xfffb892c,
  0x44d06cea, 0x44caf676, 0x00000002, 0xfffa89ab,
  0xc0017ffe, 0xc0010000, 0x00000002, 0xffff8021,
  0x80027ffe, 0x80018000, 0x00000002, 0xffff0021,
  0x40030000, 0x40018001, 0x00000002, 0xfffe8020,
  0xeaaf5554, 0xeaad2aab, 0x00000002, 0xfffdd576,
  0x844aeeec, 0x8447f777, 0x00000002, 0xfffd08aa,
  0x048cedec, 0x0488f6f7, 0x00000002, 0xfffc092a,
  0x84ce6cee, 0x84c97678, 0x00000002, 0xfffb09a9,
  0x050f6bf2, 0x050975fa, 0x00000002, 0xfffa0a27,
  0xc0010000, 0xc0008001, 0x00000002, 0xffff8020,
  0x80018002, 0x80008002, 0x00000002, 0xffff001f,
  0x2aadd556, 0x2aac2aac, 0x00000002, 0xfffe5575,
  0xc4496eee, 0xc446f778, 0x00000002, 0xfffd88a9,
  0x448b6dee, 0x4487f6f8, 0x00000002, 0xfffc8929,
  0xc4ccecf0, 0xc4c87679, 0x00000002, 0xfffb89a8,
  0x450debf4, 0x450875fb, 0x00000002, 0xfffa8a26,
  0xc54e6afa, 0xc547f57e, 0x00000002, 0xfff98aa3,
  0xc0008002, 0xc0000002, 0x00000002, 0xffff801f,
  0x6aacd556, 0x6aabaaac, 0x00000002, 0xfffed575,
  0x04486eee, 0x04467778, 0x00000002, 0xfffe08a9,
  0x848a6dee, 0x848776f8, 0x00000002, 0xfffd0929,
  0x04cbecf0, 0x04c7f679, 0x00000002, 0xfffc09a8,
  0x850cebf4, 0x8507f5fb, 0x00000002, 0xfffb0a26,
  0x054d6afa, 0x0547757e, 0x00000002, 0xfffa0aa3,
  0x85576ada, 0x8550756e, 0x00000002, 0xfff90ab3,
  0xaaac5554, 0xaaabaaab, 0x00000002, 0xffff5576,
  0x4447eeec, 0x44467777, 0x00000002, 0xfffe88aa,
  0xc489edec, 0xc48776f7, 0x00000002, 0xfffd892a,
  0x44cb6cee, 0x44c7f678, 0x00000002, 0xfffc89a9,
  0xc50c6bf2, 0xc507f5fa, 0x00000002, 0xfffb8a27,
  0x454ceaf8, 0x4547757d, 0x00000002, 0xfffa8aa4,
  0xc556ead8, 0xc550756d, 0x00000002, 0xfff98ab4,
  0x455a6ad2, 0x4552f56a, 0x00000002, 0xfff88ab7,
  0x999b9998, 0x999acccd, 0x00000002, 0xffff3354,
  0x19dd9898, 0x19dbcc4d, 0x00000002, 0xfffe33d4,
  0x9a1f179a, 0x9a1c4bce, 0x00000002, 0xfffd3453,
  0x1a60169e, 0x1a5c4b50, 0x00000002, 0xfffc34d1,
  0x9aa095a4, 0x9a9bcad3, 0x00000002, 0xfffb354e,
  0x1aaa9584, 0x1aa4cac3, 0x00000002, 0xfffa355e,
  0x9aae157e, 0x9aa74ac0, 0x00000002, 0xfff93561,
  0x1ab1157a, 0x1aa94abe, 0x00000002, 0xfff83563,
  0x8041ff00, 0x8040ff81, 0x00000002, 0xffff00a0,
  0x00837e02, 0x00817f02, 0x00000002, 0xfffe011f,
  0x80c47d06, 0x80c17e84, 0x00000002, 0xfffd019d,
  0x0104fc0c, 0x0100fe07, 0x00000002, 0xfffc021a,
  0x810efbec, 0x8109fdf7, 0x00000002, 0xfffb022a,
  0x01127be6, 0x010c7df4, 0x00000002, 0xfffa022d,
  0x81157be2, 0x810e7df2, 0x00000002, 0xfff9022f,
  0x0117fbe0, 0x010ffdf1, 0x00000002, 0xfff80230,
  0x80407f81, 0x00000001, 0xffff0081, 0xfffe011e,
  0x00807f03, 0x00000001, 0xfffe00ff, 0xfffc021a,
  0x80bffe86, 0x00000001, 0xfffd017c, 0xfffa0314,
  0x00c8fe76, 0x00000001, 0xfffc018c, 0xfff80334,
  0x80cb7e73, 0x00000001, 0xfffb018f, 0xfff6033a,
  0x00cd7e71, 0x00000001, 0xfffa0191, 0xfff4033e,
  0x80cefe70, 0x00000001, 0xfff90192, 0xfff20340,
  0x80cefe70, 0x00000001, 0xfff90192, 0xfff20340,
  0x803fff82, 0x00000001, 0xffff0080, 0xfffe011c,
  0x007f7f05, 0x00000001, 0xfffe00fd, 0xfffc0216,
  0x80887ef5, 0x00000001, 0xfffd010d, 0xfffa0236,
  0x008afef2, 0x00000001, 0xfffc0110, 0xfff8023c,
  0x808cfef0, 0x00000001, 0xfffb0112, 0xfff60240,
  0x008e7eef, 0x00000001, 0xfffa0113, 0xfff40242,
  0x008e7eef, 0x00000001, 0xfffa0113, 0xfff40242,
  0x008dfef0, 0x00000001, 0xfffa0112, 0xfff40240,
  0x803f7f83, 0x00000001, 0xffff007f, 0xfffe011a,
  0x00487f73, 0x00000001, 0xfffe008f, 0xfffc013a,
  0x804aff70, 0x00000001, 0xfffd0092, 0xfffa0140,
  0x004cff6e, 0x00000001, 0xfffc0094, 0xfff80144,
  0x804e7f6d, 0x00000001, 0xfffb0095, 0xfff60146,
  0x804e7f6d, 0x00000001, 0xfffb0095, 0xfff60146,
  0x804dff6e, 0x00000001, 0xfffb0094, 0xfff60144,
  0x804cff70, 0x00000001, 0xfffb0092, 0xfff60140,
  0x8008fff0, 0x00000001, 0xffff0012, 0xfffe0040,
  0x000b7fed, 0x00000001, 0xfffe0015, 0xfffc0046,
  0x800d7feb, 0x00000001, 0xfffd0017, 0xfffa004a,
  0x000effea, 0x00000001, 0xfffc0018, 0xfff8004c,
  0x000effea, 0x00000001, 0xfffc0018, 0xfff8004c,
  0x000e7feb, 0x00000001, 0xfffc0017, 0xfff8004a,
  0x000d7fed, 0x00000001, 0xfffc0015, 0xfff80046,
  0x00057ffd, 0x00000001, 0xfffc0005, 0xfff80026,
  0x80027ffd, 0x00000001, 0xffff0005, 0xfffe0026,
  0x00047ffb, 0x00000001, 0xfffe0007, 0xfffc002a,
  0x8005fffa, 0x00000001, 0xfffd0008, 0xfffa002c,
  0x8005fffa, 0x00000001, 0xfffd0008, 0xfffa002c,
  0x80057ffb, 0x00000001, 0xfffd0007, 0xfffa002a,
  0x80047ffd, 0x00000001, 0xfffd0005, 0xfffa0026,
  0x7ffc800d, 0x00000001, 0xfffcfff5, 0xfffa0006,
  0x7fbe008a, 0x00000001, 0xfffcff78, 0xfff9ff0c,
  0x8001fffe, 0x00000001, 0xffff0004, 0xfffe0024,
  0x00037ffd, 0x00000001, 0xfffe0005, 0xfffc0026,
  0x00037ffd, 0x00000001, 0xfffe0005, 0xfffc0026,
  0x0002fffe, 0x00000001, 0xfffe0004, 0xfffc0024,
  0x00020000, 0x00000001, 0xfffe0002, 0xfffc0020,
  0xfffa0010, 0x00000001, 0xfffdfff2, 0xfffc0000,
  0xffbb808d, 0x00000001, 0xfffdff75, 0xfffbff06,
  0xff7c810b, 0x00000001, 0xfffdfef7, 0xfffbfe0a,
  0x80017fff, 0x00000001, 0xffff0003, 0xfffe0022,
  0x80017fff, 0x00000001, 0xffff0003, 0xfffe0022,
  0x80010000, 0x00000001, 0xffff0002, 0xfffe0020,
  0x80000002, 0x00000001, 0xffff0000, 0xfffe001c,
  0x7ff80012, 0x00000001, 0xfffefff0, 0xfffdfffc,
  0x7fb9808f, 0x00000001, 0xfffeff73, 0xfffdff02,
  0x7f7a810d, 0x00000001, 0xfffefef5, 0xfffdfe06,
  0x7f3b018c, 0x00000001, 0xfffefe76, 0xfffdfd08,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff8001, 0x00000001, 0x00000001, 0x0000001e,
  0xfffe8003, 0x00000001, 0xffffffff, 0x0000001a,
  0xfff68013, 0x00000001, 0xffffffef, 0xfffffffa,
  0xffb80090, 0x00000001, 0xffffff72, 0xffffff00,
  0xff79010e, 0x00000001, 0xfffffef4, 0xfffffe04,
  0xff39818d, 0x00000001, 0xfffffe75, 0xfffffd06,
  0xe5a034c0, 0x00000001, 0xffffcb42, 0xffff96a0,
  0xffff8001, 0x00000001, 0x00000001, 0x0000001e,
  0xfffe8003, 0x00000001, 0xffffffff, 0x0000001a,
  0xfff68013, 0x00000001, 0xffffffef, 0xfffffffa,
  0xffb80090, 0x00000001, 0xffffff72, 0xffffff00,
  0xff79010e, 0x00000001, 0xfffffef4, 0xfffffe04,
  0xff39818d, 0x00000001, 0xfffffe75, 0xfffffd06,
  0xe5a034c0, 0x00000001, 0xffffcb42, 0xffff96a0,
  0xbaf60a15, 0x00000001, 0xffff75ed, 0xfffeebf6,
  0xffff0002, 0x00000001, 0x00000000, 0x0000001c,
  0xfff70012, 0x00000001, 0xfffffff0, 0xfffffffc,
  0xffb8808f, 0x00000001, 0xffffff73, 0xffffff02,
  0xff79810d, 0x00000001, 0xfffffef5, 0xfffffe06,
  0xff3a018c, 0x00000001, 0xfffffe76, 0xfffffd08,
  0xe5a0b4bf, 0x00000001, 0xffffcb43, 0xffff96a2,
  0xbaf68a14, 0x00000001, 0xffff75ee, 0xfffeebf8,
  0x7af88a11, 0x00000001, 0xfffef5f1, 0xfffdebfe,
  0xfff80010, 0x00000001, 0xfffffff2, 0x00000000,
  0xffb9808d, 0x00000001, 0xffffff75, 0xffffff06,
  0xff7a810b, 0x00000001, 0xfffffef7, 0xfffffe0a,
  0xff3b018a, 0x00000001, 0xfffffe78, 0xfffffd0c,
  0xe5a1b4bd, 0x00000001, 0xffffcb45, 0xffff96a6,
  0xbaf78a12, 0x00000001, 0xffff75f0, 0xfffeebfc,
  0x7af98a0f, 0x00000001, 0xfffef5f3, 0xfffdec02,
  0x3afb0a0d, 0x00000001, 0xfffe75f5, 0xfffcec06,
  0xffc1807d, 0x00000001, 0xffffff85, 0xffffff26,
  0xff8280fb, 0x00000001, 0xffffff07, 0xfffffe2a,
  0xff43017a, 0x00000001, 0xfffffe88, 0xfffffd2c,
  0xe5a9b4ad, 0x00000001, 0xffffcb55, 0xffff96c6,
  0xbaff8a02, 0x00000001, 0xffff7600, 0xfffeec1c,
  0x7b0189ff, 0x00000001, 0xfffef603, 0xfffdec22,
  0x3b0309fd, 0x00000001, 0xfffe7605, 0xfffcec26,
  0xfb0409fc, 0x00000001, 0xfffdf606, 0xfffbec28,
  0xffc1007e, 0x00000001, 0xffffff84, 0xffffff24,
  0xff8180fd, 0x00000001, 0xffffff05, 0xfffffe26,
  0xe5e83430, 0x00000001, 0xffffcbd2, 0xffff97c0,
  0xbb3e0985, 0x00000001, 0xffff767d, 0xfffeed16,
  0x7b400982, 0x00000001, 0xfffef680, 0xfffded1c,
  0x3b418980, 0x00000001, 0xfffe7682, 0xfffced20,
  0xfb42897f, 0x00000001, 0xfffdf683, 0xfffbed22,
  0xbb43097f, 0x00000001, 0xfffd7683, 0xfffaed22,
  0xffc0807f, 0x00000001, 0xffffff83, 0xffffff22,
  0xe62733b2, 0x00000001, 0xffffcc50, 0xffff98bc,
  0xbb7d0907, 0x00000001, 0xffff76fb, 0xfffeee12,
  0x7b7f0904, 0x00000001, 0xfffef6fe, 0xfffdee18,
  0x3b808902, 0x00000001, 0xfffe7700, 0xfffcee1c,
  0xfb818901, 0x00000001, 0xfffdf701, 0xfffbee1e,
  0xbb820901, 0x00000001, 0xfffd7701, 0xfffaee1e,
  0x7b820902, 0x00000001, 0xfffcf700, 0xfff9ee1c,
  0xe666b333, 0x00000001, 0xffffcccf, 0xffff99ba,
  0xbbbc8888, 0x00000001, 0xffff777a, 0xfffeef10,
  0x7bbe8885, 0x00000001, 0xfffef77d, 0xfffdef16,
  0x3bc00883, 0x00000001, 0xfffe777f, 0xfffcef1a,
  0xfbc10882, 0x00000001, 0xfffdf780, 0xfffbef1c,
  0xbbc18882, 0x00000001, 0xfffd7780, 0xfffaef1c,
  0x7bc18883, 0x00000001, 0xfffcf77f, 0xfff9ef1a,
  0x266d332d, 0x00000001, 0xfffc4cd5, 0xfff899c6,
  0xd555d555, 0x00000001, 0xffffaaad, 0xffff5576,
  0x9557d552, 0x00000001, 0xffff2ab0, 0xfffe557c,
  0x55595550, 0x00000001, 0xfffeaab2, 0xfffd5580,
  0x155a554f, 0x00000001, 0xfffe2ab3, 0xfffc5582,
  0xd55ad54f, 0x00000001, 0xfffdaab3, 0xfffb5582,
  0x955ad550, 0x00000001, 0xfffd2ab2, 0xfffa5580,
  0x40067ffa, 0x00000001, 0xfffc8008, 0xfff9002c,
  0xd9a14cc6, 0x00000001, 0xfffbb33c, 0xfff76694,
  0xc001fffd, 0x00000001, 0xffff8005, 0xffff0026,
  0x80037ffb, 0x00000001, 0xffff0007, 0xfffe002a,
  0x40047ffa, 0x00000001, 0xfffe8008, 0xfffd002c,
  0x0004fffa, 0x00000001, 0xfffe0008, 0xfffc002c,
  0xc004fffb, 0x00000001, 0xfffd8007, 0xfffb002a,
  0x6ab0aaa5, 0x00000001, 0xfffcd55d, 0xfff9aad6,
  0x044b7771, 0x00000001, 0xfffc0891, 0xfff8113e,
  0x848c76f1, 0x00000001, 0xfffb0911, 0xfff6123e,
  0xc0017ffe, 0x00000001, 0xffff8004, 0xffff0024,
  0x80027ffd, 0x00000001, 0xffff0005, 0xfffe0026,
  0x4002fffd, 0x00000001, 0xfffe8005, 0xfffd0026,
  0x0002fffe, 0x00000001, 0xfffe0004, 0xfffc0024,
  0xaaaeaaa8, 0x00000001, 0xfffd555a, 0xfffaaad0,
  0x44497774, 0x00000001, 0xfffc888e, 0xfff91138,
  0xc48a76f4, 0x00000001, 0xfffb890e, 0xfff71238,
  0x44caf675, 0x00000001, 0xfffa898d, 0xfff51336,
  0xc000ffff, 0x00000001, 0xffff8003, 0xffff0022,
  0x80017fff, 0x00000001, 0xffff0003, 0xfffe0022,
  0x40018000, 0x00000001, 0xfffe8002, 0xfffd0020,
  0xeaad2aaa, 0x00000001, 0xfffdd558, 0xfffbaacc,
  0x8447f776, 0x00000001, 0xfffd088c, 0xfffa1134,
  0x0488f6f6, 0x00000001, 0xfffc090c, 0xfff81234,
  0x84c97677, 0x00000001, 0xfffb098b, 0xfff61332,
  0x050975f9, 0x00000001, 0xfffa0a09, 0xfff4142e,
  0xc0008000, 0x00000001, 0xffff8002, 0xffff0020,
  0x80008001, 0x00000001, 0xffff0001, 0xfffe001e,
  0x2aac2aab, 0x00000001, 0xfffe5557, 0xfffcaaca,
  0xc446f777, 0x00000001, 0xfffd888b, 0xfffb1132,
  0x4487f6f7, 0x00000001, 0xfffc890b, 0xfff91232,
  0xc4c87678, 0x00000001, 0xfffb898a, 0xfff71330,
  0x450875fa, 0x00000001, 0xfffa8a08, 0xfff5142c,
  0xc547f57d, 0x00000001, 0xfff98a85, 0xfff31526,
  0xc0000001, 0x00000001, 0xffff8001, 0xffff001e,
  0x6aabaaab, 0x00000001, 0xfffed557, 0xfffdaaca,
  0x04467777, 0x00000001, 0xfffe088b, 0xfffc1132,
  0x848776f7, 0x00000001, 0xfffd090b, 0xfffa1232,
  0x04c7f678, 0x00000001, 0xfffc098a, 0xfff81330,
  0x8507f5fa, 0x00000001, 0xfffb0a08, 0xfff6142c,
  0x0547757d, 0x00000001, 0xfffa0a85, 0xfff41526,
  0x8550756d, 0x00000001, 0xfff90a95, 0xfff21546,
  0xaaabaaaa, 0x00000001, 0xffff5558, 0xfffeaacc,
  0x44467776, 0x00000001, 0xfffe888c, 0xfffd1134,
  0xc48776f6, 0x00000001, 0xfffd890c, 0xfffb1234,
  0x44c7f677, 0x00000001, 0xfffc898b, 0xfff91332,
  0xc507f5f9, 0x00000001, 0xfffb8a09, 0xfff7142e,
  0x4547757c, 0x00000001, 0xfffa8a86, 0xfff51528,
  0xc550756c, 0x00000001, 0xfff98a96, 0xfff31548,
  0x4552f569, 0x00000001, 0xfff88a99, 0xfff1154e,
  0x999acccc, 0x00000001, 0xffff3336, 0xfffe6688,
  0x19dbcc4c, 0x00000001, 0xfffe33b6, 0xfffc6788,
  0x9a1c4bcd, 0x00000001, 0xfffd3435, 0xfffa6886,
  0x1a5c4b4f, 0x00000001, 0xfffc34b3, 0xfff86982,
  0x9a9bcad2, 0x00000001, 0xfffb3530, 0xfff66a7c,
  0x1aa4cac2, 0x00000001, 0xfffa3540, 0xfff46a9c,
  0x9aa74abf, 0x00000001, 0xfff93543, 0xfff26aa2,
  0x1aa94abd, 0x00000001, 0xfff83545, 0xfff06aa6,
  0x8040ff80, 0x00000001, 0xffff0082, 0xfffe0120,
  0x00817f01, 0x00000001, 0xfffe0101, 0xfffc021e,
  0x80c17e83, 0x00000001, 0xfffd017f, 0xfffa031a,
  0x0100fe06, 0x00000001, 0xfffc01fc, 0xfff80414,
  0x8109fdf6, 0x00000001, 0xfffb020c, 0xfff60434,
  0x010c7df3, 0x00000001, 0xfffa020f, 0xfff4043a,
  0x810e7df1, 0x00000001, 0xfff90211, 0xfff2043e,
  0x010ffdf0, 0x00000001, 0xfff80212, 0xfff00440,
  0x00000000, 0xffff0080, 0xfffe0100, 0xfff00810,
  0x00000000, 0xfffe00fe, 0xfffc01fc, 0xffe00ff0,
  0x00000000, 0xfffd017b, 0xfffa02f6, 0xffd017c0,
  0x00000000, 0xfffc018b, 0xfff80316, 0xffc018c0,
  0x00000000, 0xfffb018e, 0xfff6031c, 0xffb018f0,
  0x00000000, 0xfffa0190, 0xfff40320, 0xffa01910,
  0x00000000, 0xfff90191, 0xfff20322, 0xff901920,
  0x00000000, 0xfff90191, 0xfff20322, 0xff901920,
  0x00000000, 0xffff007f, 0xfffe00fe, 0xfff00800,
  0x00000000, 0xfffe00fc, 0xfffc01f8, 0xffe00fd0,
  0x00000000, 0xfffd010c, 0xfffa0218, 0xffd010d0,
  0x00000000, 0xfffc010f, 0xfff8021e, 0xffc01100,
  0x00000000, 0xfffb0111, 0xfff60222, 0xffb01120,
  0x00000000, 0xfffa0112, 0xfff40224, 0xffa01130,
  0x00000000, 0xfffa0112, 0xfff40224, 0xffa01130,
  0x00000000, 0xfffa0111, 0xfff40222, 0xffa01120,
  0x00000000, 0xffff007e, 0xfffe00fc, 0xfff007f0,
  0x00000000, 0xfffe008e, 0xfffc011c, 0xffe008f0,
  0x00000000, 0xfffd0091, 0xfffa0122, 0xffd00920,
  0x00000000, 0xfffc0093, 0xfff80126, 0xffc00940,
  0x00000000, 0xfffb0094, 0xfff60128, 0xffb00950,
  0x00000000, 0xfffb0094, 0xfff60128, 0xffb00950,
  0x00000000, 0xfffb0093, 0xfff60126, 0xffb00940,
  0x00000000, 0xfffb0091, 0xfff60122, 0xffb00920,
  0x00000000, 0xffff0011, 0xfffe0022, 0xfff00120,
  0x00000000, 0xfffe0014, 0xfffc0028, 0xffe00150,
  0x00000000, 0xfffd0016, 0xfffa002c, 0xffd00170,
  0x00000000, 0xfffc0017, 0xfff8002e, 0xffc00180,
  0x00000000, 0xfffc0017, 0xfff8002e, 0xffc00180,
  0x00000000, 0xfffc0016, 0xfff8002c, 0xffc00170,
  0x00000000, 0xfffc0014, 0xfff80028, 0xffc00150,
  0x00000000, 0xfffc0004, 0xfff80008, 0xffc00050,
  0x00000000, 0xffff0004, 0xfffe0008, 0xfff00050,
  0x00000000, 0xfffe0006, 0xfffc000c, 0xffe00070,
  0x00000000, 0xfffd0007, 0xfffa000e, 0xffd00080,
  0x00000000, 0xfffd0007, 0xfffa000e, 0xffd00080,
  0x00000000, 0xfffd0006, 0xfffa000c, 0xffd00070,
  0x00000000, 0xfffd0004, 0xfffa0008, 0xffd00050,
  0x00000000, 0xfffcfff4, 0xfff9ffe8, 0xffcfff50,
  0x00000000, 0xfffcff77, 0xfff9feee, 0xffcff780,
  0x00000000, 0xffff0003, 0xfffe0006, 0xfff00040,
  0x00000000, 0xfffe0004, 0xfffc0008, 0xffe00050,
  0x00000000, 0xfffe0004, 0xfffc0008, 0xffe00050,
  0x00000000, 0xfffe0003, 0xfffc0006, 0xffe00040,
  0x00000000, 0xfffe0001, 0xfffc0002, 0xffe00020,
  0x00000000, 0xfffdfff1, 0xfffbffe2, 0xffdfff20,
  0x00000000, 0xfffdff74, 0xfffbfee8, 0xffdff750,
  0x00000000, 0xfffdfef6, 0xfffbfdec, 0xffdfef70,
  0x00000000, 0xffff0002, 0xfffe0004, 0xfff00030,
  0x00000000, 0xffff0002, 0xfffe0004, 0xfff00030,
  0x00000000, 0xffff0001, 0xfffe0002, 0xfff00020,
  0x00000000, 0xfffeffff, 0xfffdfffe, 0xfff00000,
  0x00000000, 0xfffeffef, 0xfffdffde, 0xffefff00,
  0x00000000, 0xfffeff72, 0xfffdfee4, 0xffeff730,
  0x00000000, 0xfffefef4, 0xfffdfde8, 0xffefef50,
  0x00000000, 0xfffefe75, 0xfffdfcea, 0xffefe760,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000000, 0x00000000, 0x00000010,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xfffffff0,
  0x00000000, 0xffffffee, 0xffffffdc, 0xfffffef0,
  0x00000000, 0xffffff71, 0xfffffee2, 0xfffff720,
  0x00000000, 0xfffffef3, 0xfffffde6, 0xffffef40,
  0x00000000, 0xfffffe74, 0xfffffce8, 0xffffe750,
  0x00000000, 0xffffcb41, 0xffff9682, 0xfffcb420,
  0x00000000, 0x00000000, 0x00000000, 0x00000010,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xfffffff0,
  0x00000000, 0xffffffee, 0xffffffdc, 0xfffffef0,
  0x00000000, 0xffffff71, 0xfffffee2, 0xfffff720,
  0x00000000, 0xfffffef3, 0xfffffde6, 0xffffef40,
  0x00000000, 0xfffffe74, 0xfffffce8, 0xffffe750,
  0x00000000, 0xffffcb41, 0xffff9682, 0xfffcb420,
  0x00000000, 0xffff75ec, 0xfffeebd8, 0xfff75ed0,
  0x00000000, 0xffffffff, 0xfffffffe, 0x00000000,
  0x00000000, 0xffffffef, 0xffffffde, 0xffffff00,
  0x00000000, 0xffffff72, 0xfffffee4, 0xfffff730,
  0x00000000, 0xfffffef4, 0xfffffde8, 0xffffef50,
  0x00000000, 0xfffffe75, 0xfffffcea, 0xffffe760,
  0x00000000, 0xffffcb42, 0xffff9684, 0xfffcb430,
  0x00000000, 0xffff75ed, 0xfffeebda, 0xfff75ee0,
  0x00000000, 0xfffef5f0, 0xfffdebe0, 0xffef5f10,
  0x00000000, 0xfffffff1, 0xffffffe2, 0xffffff20,
  0x00000000, 0xffffff74, 0xfffffee8, 0xfffff750,
  0x00000000, 0xfffffef6, 0xfffffdec, 0xffffef70,
  0x00000000, 0xfffffe77, 0xfffffcee, 0xffffe780,
  0x00000000, 0xffffcb44, 0xffff9688, 0xfffcb450,
  0x00000000, 0xffff75ef, 0xfffeebde, 0xfff75f00,
  0x00000000, 0xfffef5f2, 0xfffdebe4, 0xffef5f30,
  0x00000000, 0xfffe75f4, 0xfffcebe8, 0xffe75f50,
  0x00000000, 0xffffff84, 0xffffff08, 0xfffff850,
  0x00000000, 0xffffff06, 0xfffffe0c, 0xfffff070,
  0x00000000, 0xfffffe87, 0xfffffd0e, 0xffffe880,
  0x00000000, 0xffffcb54, 0xffff96a8, 0xfffcb550,
  0x00000000, 0xffff75ff, 0xfffeebfe, 0xfff76000,
  0x00000000, 0xfffef602, 0xfffdec04, 0xffef6030,
  0x00000000, 0xfffe7604, 0xfffcec08, 0xffe76050,
  0x00000000, 0xfffdf605, 0xfffbec0a, 0xffdf6060,
  0x00000000, 0xffffff83, 0xffffff06, 0xfffff840,
  0x00000000, 0xffffff04, 0xfffffe08, 0xfffff050,
  0x00000000, 0xffffcbd1, 0xffff97a2, 0xfffcbd20,
  0x00000000, 0xffff767c, 0xfffeecf8, 0xfff767d0,
  0x00000000, 0xfffef67f, 0xfffdecfe, 0xffef6800,
  0x00000000, 0xfffe7681, 0xfffced02, 0xffe76820,
  0x00000000, 0xfffdf682, 0xfffbed04, 0xffdf6830,
  0x00000000, 0xfffd7682, 0xfffaed04, 0xffd76830,
  0x00000000, 0xffffff82, 0xffffff04, 0xfffff830,
  0x00000000, 0xffffcc4f, 0xffff989e, 0xfffcc500,
  0x00000000, 0xffff76fa, 0xfffeedf4, 0xfff76fb0,
  0x00000000, 0xfffef6fd, 0xfffdedfa, 0xffef6fe0,
  0x00000000, 0xfffe76ff, 0xfffcedfe, 0xffe77000,
  0x00000000, 0xfffdf700, 0xfffbee00, 0xffdf7010,
  0x00000000, 0xfffd7700, 0xfffaee00, 0xffd77010,
  0x00000000, 0xfffcf6ff, 0xfff9edfe, 0xffcf7000,
  0x00000000, 0xffffccce, 0xffff999c, 0xfffcccf0,
  0x00000000, 0xffff7779, 0xfffeeef2, 0xfff777a0,
  0x00000000, 0xfffef77c, 0xfffdeef8, 0xffef77d0,
  0x00000000, 0xfffe777e, 0xfffceefc, 0xffe777f0,
  0x00000000, 0xfffdf77f, 0xfffbeefe, 0xffdf7800,
  0x00000000, 0xfffd777f, 0xfffaeefe, 0xffd77800,
  0x00000000, 0xfffcf77e, 0xfff9eefc, 0xffcf77f0,
  0x00000000, 0xfffc4cd4, 0xfff899a8, 0xffc4cd50,
  0x00000000, 0xffffaaac, 0xffff5558, 0xfffaaad0,
  0x00000000, 0xffff2aaf, 0xfffe555e, 0xfff2ab00,
  0x00000000, 0xfffeaab1, 0xfffd5562, 0xffeaab20,
  0x00000000, 0xfffe2ab2, 0xfffc5564, 0xffe2ab30,
  0x00000000, 0xfffdaab2, 0xfffb5564, 0xffdaab30,
  0x00000000, 0xfffd2ab1, 0xfffa5562, 0xffd2ab20,
  0x00000000, 0xfffc8007, 0xfff9000e, 0xffc80080,
  0x00000000, 0xfffbb33b, 0xfff76676, 0xffbb33c0,
  0x00000000, 0xffff8004, 0xffff0008, 0xfff80050,
  0x00000000, 0xffff0006, 0xfffe000c, 0xfff00070,
  0x00000000, 0xfffe8007, 0xfffd000e, 0xffe80080,
  0x00000000, 0xfffe0007, 0xfffc000e, 0xffe00080,
  0x00000000, 0xfffd8006, 0xfffb000c, 0xffd80070,
  0x00000000, 0xfffcd55c, 0xfff9aab8, 0xffcd55d0,
  0x00000000, 0xfffc0890, 0xfff81120, 0xffc08910,
  0x00000000, 0xfffb0910, 0xfff61220, 0xffb09110,
  0x00000000, 0xffff8003, 0xffff0006, 0xfff80040,
  0x00000000, 0xffff0004, 0xfffe0008, 0xfff00050,
  0x00000000, 0xfffe8004, 0xfffd0008, 0xffe80050,
  0x00000000, 0xfffe0003, 0xfffc0006, 0xffe00040,
  0x00000000, 0xfffd5559, 0xfffaaab2, 0xffd555a0,
  0x00000000, 0xfffc888d, 0xfff9111a, 0xffc888e0,
  0x00000000, 0xfffb890d, 0xfff7121a, 0xffb890e0,
  0x00000000, 0xfffa898c, 0xfff51318, 0xffa898d0,
  0x00000000, 0xffff8002, 0xffff0004, 0xfff80030,
  0x00000000, 0xffff0002, 0xfffe0004, 0xfff00030,
  0x00000000, 0xfffe8001, 0xfffd0002, 0xffe80020,
  0x00000000, 0xfffdd557, 0xfffbaaae, 0xffdd5580,
  0x00000000, 0xfffd088b, 0xfffa1116, 0xffd088c0,
  0x00000000, 0xfffc090b, 0xfff81216, 0xffc090c0,
  0x00000000, 0xfffb098a, 0xfff61314, 0xffb098b0,
  0x00000000, 0xfffa0a08, 0xfff41410, 0xffa0a090,
  0x00000000, 0xffff8001, 0xffff0002, 0xfff80020,
  0x00000000, 0xffff0000, 0xfffe0000, 0xfff00010,
  0x00000000, 0xfffe5556, 0xfffcaaac, 0xffe55570,
  0x00000000, 0xfffd888a, 0xfffb1114, 0xffd888b0,
  0x00000000, 0xfffc890a, 0xfff91214, 0xffc890b0,
  0x00000000, 0xfffb8989, 0xfff71312, 0xffb898a0,
  0x00000000, 0xfffa8a07, 0xfff5140e, 0xffa8a080,
  0x00000000, 0xfff98a84, 0xfff31508, 0xff98a850,
  0x00000000, 0xffff8000, 0xffff0000, 0xfff80010,
  0x00000000, 0xfffed556, 0xfffdaaac, 0xffed5570,
  0x00000000, 0xfffe088a, 0xfffc1114, 0xffe088b0,
  0x00000000, 0xfffd090a, 0xfffa1214, 0xffd090b0,
  0x00000000, 0xfffc0989, 0xfff81312, 0xffc098a0,
  0x00000000, 0xfffb0a07, 0xfff6140e, 0xffb0a080,
  0x00000000, 0xfffa0a84, 0xfff41508, 0xffa0a850,
  0x00000000, 0xfff90a94, 0xfff21528, 0xff90a950,
  0x00000000, 0xffff5557, 0xfffeaaae, 0xfff55580,
  0x00000000, 0xfffe888b, 0xfffd1116, 0xffe888c0,
  0x00000000, 0xfffd890b, 0xfffb1216, 0xffd890c0,
  0x00000000, 0xfffc898a, 0xfff91314, 0xffc898b0,
  0x00000000, 0xfffb8a08, 0xfff71410, 0xffb8a090,
  0x00000000, 0xfffa8a85, 0xfff5150a, 0xffa8a860,
  0x00000000, 0xfff98a95, 0xfff3152a, 0xff98a960,
  0x00000000, 0xfff88a98, 0xfff11530, 0xff88a990,
  0x00000000, 0xffff3335, 0xfffe666a, 0xfff33360,
  0x00000000, 0xfffe33b5, 0xfffc676a, 0xffe33b60,
  0x00000000, 0xfffd3434, 0xfffa6868, 0xffd34350,
  0x00000000, 0xfffc34b2, 0xfff86964, 0xffc34b30,
  0x00000000, 0xfffb352f, 0xfff66a5e, 0xffb35300,
  0x00000000, 0xfffa353f, 0xfff46a7e, 0xffa35400,
  0x00000000, 0xfff93542, 0xfff26a84, 0xff935430,
  0x00000000, 0xfff83544, 0xfff06a88, 0xff835450,
  0x00000000, 0xffff0081, 0xfffe0102, 0xfff00820,
  0x00000000, 0xfffe0100, 0xfffc0200, 0xffe01010,
  0x00000000, 0xfffd017e, 0xfffa02fc, 0xffd017f0,
  0x00000000, 0xfffc01fb, 0xfff803f6, 0xffc01fc0,
  0x00000000, 0xfffb020b, 0xfff60416, 0xffb020c0,
  0x00000000, 0xfffa020e, 0xfff4041c, 0xffa020f0,
  0x00000000, 0xfff90210, 0xfff20420, 0xff902110,
  0x00000000, 0xfff80211, 0xfff00422, 0xff802120,
  0xffff007f, 0xfffe00ff, 0xfff007f2, 0xff833e23,
  0xfffe00fd, 0xfffc01fb, 0xffe00fd2, 0xff067ba9,
  0xfffd017a, 0xfffa02f5, 0xffd017a2, 0xfe89b8b2,
  0xfffc018a, 0xfff80315, 0xffc018a2, 0xfe0cc082,
  0xfffb018d, 0xfff6031b, 0xffb018d2, 0xfd8fc1f9,
  0xfffa018f, 0xfff4031f, 0xffa018f2, 0xfd12c2f3,
  0xfff90190, 0xfff20321, 0xff901902, 0xfc95c370,
  0xfff90190, 0xfff20321, 0xff901902, 0xfc95c370,
  0xffff007e, 0xfffe00fd, 0xfff007e2, 0xff833da6,
  0xfffe00fb, 0xfffc01f7, 0xffe00fb2, 0xff067aaf,
  0xfffd010b, 0xfffa0217, 0xffd010b2, 0xfe89827f,
  0xfffc010e, 0xfff8021d, 0xffc010e2, 0xfe0c83f6,
  0xfffb0110, 0xfff60221, 0xffb01102, 0xfd8f84f0,
  0xfffa0111, 0xfff40223, 0xffa01112, 0xfd12856d,
  0xfffa0111, 0xfff40223, 0xffa01112, 0xfd12856d,
  0xfffa0110, 0xfff40221, 0xffa01102, 0xfd1284f0,
  0xffff007d, 0xfffe00fb, 0xfff007d2, 0xff833d29,
  0xfffe008d, 0xfffc011b, 0xffe008d2, 0xff0644f9,
  0xfffd0090, 0xfffa0121, 0xffd00902, 0xfe894670,
  0xfffc0092, 0xfff80125, 0xffc00922, 0xfe0c476a,
  0xfffb0093, 0xfff60127, 0xffb00932, 0xfd8f47e7,
  0xfffb0093, 0xfff60127, 0xffb00932, 0xfd8f47e7,
  0xfffb0092, 0xfff60125, 0xffb00922, 0xfd8f476a,
  0xfffb0090, 0xfff60121, 0xffb00902, 0xfd8f4670,
  0xffff0010, 0xfffe0021, 0xfff00102, 0xff8307f0,
  0xfffe0013, 0xfffc0027, 0xffe00132, 0xff060967,
  0xfffd0015, 0xfffa002b, 0xffd00152, 0xfe890a61,
  0xfffc0016, 0xfff8002d, 0xffc00162, 0xfe0c0ade,
  0xfffc0016, 0xfff8002d, 0xffc00162, 0xfe0c0ade,
  0xfffc0015, 0xfff8002b, 0xffc00152, 0xfe0c0a61,
  0xfffc0013, 0xfff80027, 0xffc00132, 0xfe0c0967,
  0xfffc0003, 0xfff80007, 0xffc00032, 0xfe0c0197,
  0xffff0003, 0xfffe0007, 0xfff00032, 0xff830197,
  0xfffe0005, 0xfffc000b, 0xffe00052, 0xff060291,
  0xfffd0006, 0xfffa000d, 0xffd00062, 0xfe89030e,
  0xfffd0006, 0xfffa000d, 0xffd00062, 0xfe89030e,
  0xfffd0005, 0xfffa000b, 0xffd00052, 0xfe890291,
  0xfffd0003, 0xfffa0007, 0xffd00032, 0xfe890197,
  0xfffcfff3, 0xfff9ffe7, 0xffcfff32, 0xfe88f9c7,
  0xfffcff76, 0xfff9feed, 0xffcff762, 0xfe88bcbe,
  0xffff0002, 0xfffe0005, 0xfff00022, 0xff83011a,
  0xfffe0003, 0xfffc0007, 0xffe00032, 0xff060197,
  0xfffe0003, 0xfffc0007, 0xffe00032, 0xff060197,
  0xfffe0002, 0xfffc0005, 0xffe00022, 0xff06011a,
  0xfffe0000, 0xfffc0001, 0xffe00002, 0xff060020,
  0xfffdfff0, 0xfffbffe1, 0xffdfff02, 0xff05f850,
  0xfffdff73, 0xfffbfee7, 0xffdff732, 0xff05bb47,
  0xfffdfef5, 0xfffbfdeb, 0xffdfef52, 0xff057dc1,
  0xffff0001, 0xfffe0003, 0xfff00012, 0xff83009d,
  0xffff0001, 0xfffe0003, 0xfff00012, 0xff83009d,
  0xffff0000, 0xfffe0001, 0xfff00002, 0xff830020,
  0xfffefffe, 0xfffdfffd, 0xffefffe2, 0xff82ff26,
  0xfffeffee, 0xfffdffdd, 0xffeffee2, 0xff82f756,
  0xfffeff71, 0xfffdfee3, 0xffeff712, 0xff82ba4d,
  0xfffefef3, 0xfffdfde7, 0xffefef32, 0xff827cc7,
  0xfffefe74, 0xfffdfce9, 0xffefe742, 0xff823ec4,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffffff, 0xffffffff, 0xfffffff2, 0xffffffa3,
  0xfffffffd, 0xfffffffb, 0xffffffd2, 0xfffffea9,
  0xffffffed, 0xffffffdb, 0xfffffed2, 0xfffff6d9,
  0xffffff70, 0xfffffee1, 0xfffff702, 0xffffb9d0,
  0xfffffef2, 0xfffffde5, 0xffffef22, 0xffff7c4a,
  0xfffffe73, 0xfffffce7, 0xffffe732, 0xffff3e47,
  0xffffcb40, 0xffff9681, 0xfffcb402, 0xffe63e60,
  0xffffffff, 0xffffffff, 0xfffffff2, 0xffffffa3,
  0xfffffffd, 0xfffffffb, 0xffffffd2, 0xfffffea9,
  0xffffffed, 0xffffffdb, 0xfffffed2, 0xfffff6d9,
  0xffffff70, 0xfffffee1, 0xfffff702, 0xffffb9d0,
  0xfffffef2, 0xfffffde5, 0xffffef22, 0xffff7c4a,
  0xfffffe73, 0xfffffce7, 0xffffe732, 0xffff3e47,
  0xffffcb40, 0xffff9681, 0xfffcb402, 0xffe63e60,
  0xffff75eb, 0xfffeebd7, 0xfff75eb2, 0xffbc93df,
  0xfffffffe, 0xfffffffd, 0xffffffe2, 0xffffff26,
  0xffffffee, 0xffffffdd, 0xfffffee2, 0xfffff756,
  0xffffff71, 0xfffffee3, 0xfffff712, 0xffffba4d,
  0xfffffef3, 0xfffffde7, 0xffffef32, 0xffff7cc7,
  0xfffffe74, 0xfffffce9, 0xffffe742, 0xffff3ec4,
  0xffffcb41, 0xffff9683, 0xfffcb412, 0xffe63edd,
  0xffff75ec, 0xfffeebd9, 0xfff75ec2, 0xffbc945c,
  0xfffef5ef, 0xfffdebdf, 0xffef5ef2, 0xff7e15d3,
  0xfffffff0, 0xffffffe1, 0xffffff02, 0xfffff850,
  0xffffff73, 0xfffffee7, 0xfffff732, 0xffffbb47,
  0xfffffef5, 0xfffffdeb, 0xffffef52, 0xffff7dc1,
  0xfffffe76, 0xfffffced, 0xffffe762, 0xffff3fbe,
  0xffffcb43, 0xffff9687, 0xfffcb432, 0xffe63fd7,
  0xffff75ee, 0xfffeebdd, 0xfff75ee2, 0xffbc9556,
  0xfffef5f1, 0xfffdebe3, 0xffef5f12, 0xff7e16cd,
  0xfffe75f3, 0xfffcebe7, 0xffe75f32, 0xff3f97c7,
  0xffffff83, 0xffffff07, 0xfffff832, 0xffffc317,
  0xffffff05, 0xfffffe0b, 0xfffff052, 0xffff8591,
  0xfffffe86, 0xfffffd0d, 0xffffe862, 0xffff478e,
  0xffffcb53, 0xffff96a7, 0xfffcb532, 0xffe647a7,
  0xffff75fe, 0xfffeebfd, 0xfff75fe2, 0xffbc9d26,
  0xfffef601, 0xfffdec03, 0xffef6012, 0xff7e1e9d,
  0xfffe7603, 0xfffcec07, 0xffe76032, 0xff3f9f97,
  0xfffdf604, 0xfffbec09, 0xffdf6042, 0xff012014,
  0xffffff82, 0xffffff05, 0xfffff822, 0xffffc29a,
  0xffffff03, 0xfffffe07, 0xfffff032, 0xffff8497,
  0xffffcbd0, 0xffff97a1, 0xfffcbd02, 0xffe684b0,
  0xffff767b, 0xfffeecf7, 0xfff767b2, 0xffbcda2f,
  0xfffef67e, 0xfffdecfd, 0xffef67e2, 0xff7e5ba6,
  0xfffe7680, 0xfffced01, 0xffe76802, 0xff3fdca0,
  0xfffdf681, 0xfffbed03, 0xffdf6812, 0xff015d1d,
  0xfffd7681, 0xfffaed03, 0xffd76812, 0xfec2dd1d,
  0xffffff81, 0xffffff03, 0xfffff812, 0xffffc21d,
  0xffffcc4e, 0xffff989d, 0xfffcc4e2, 0xffe6c236,
  0xffff76f9, 0xfffeedf3, 0xfff76f92, 0xffbd17b5,
  0xfffef6fc, 0xfffdedf9, 0xffef6fc2, 0xff7e992c,
  0xfffe76fe, 0xfffcedfd, 0xffe76fe2, 0xff401a26,
  0xfffdf6ff, 0xfffbedff, 0xffdf6ff2, 0xff019aa3,
  0xfffd76ff, 0xfffaedff, 0xffd76ff2, 0xfec31aa3,
  0xfffcf6fe, 0xfff9edfd, 0xffcf6fe2, 0xfe849a26,
  0xffffcccd, 0xffff999b, 0xfffcccd2, 0xffe70039,
  0xffff7778, 0xfffeeef1, 0xfff77782, 0xffbd55b8,
  0xfffef77b, 0xfffdeef7, 0xffef77b2, 0xff7ed72f,
  0xfffe777d, 0xfffceefb, 0xffe777d2, 0xff405829,
  0xfffdf77e, 0xfffbeefd, 0xffdf77e2, 0xff01d8a6,
  0xfffd777e, 0xfffaeefd, 0xffd777e2, 0xfec358a6,
  0xfffcf77d, 0xfff9eefb, 0xffcf77d2, 0xfe84d829,
  0xfffc4cd3, 0xfff899a7, 0xffc4cd32, 0xfe318327,
  0xffffaaab, 0xffff5557, 0xfffaaab2, 0xffd6559f,
  0xffff2aae, 0xfffe555d, 0xfff2aae2, 0xff97d716,
  0xfffeaab0, 0xfffd5561, 0xffeaab02, 0xff595810,
  0xfffe2ab1, 0xfffc5563, 0xffe2ab12, 0xff1ad88d,
  0xfffdaab1, 0xfffb5563, 0xffdaab12, 0xfedc588d,
  0xfffd2ab0, 0xfffa5561, 0xffd2ab02, 0xfe9dd810,
  0xfffc8006, 0xfff9000d, 0xffc80062, 0xfe4a830e,
  0xfffbb33a, 0xfff76675, 0xffbb33a2, 0xfde68372,
  0xffff8003, 0xffff0007, 0xfff80032, 0xffc18197,
  0xffff0005, 0xfffe000b, 0xfff00052, 0xff830291,
  0xfffe8006, 0xfffd000d, 0xffe80062, 0xff44830e,
  0xfffe0006, 0xfffc000d, 0xffe00062, 0xff06030e,
  0xfffd8005, 0xfffb000b, 0xffd80052, 0xfec78291,
  0xfffcd55b, 0xfff9aab7, 0xffcd55b2, 0xfe742d8f,
  0xfffc088f, 0xfff8111f, 0xffc088f2, 0xfe102df3,
  0xfffb090f, 0xfff6121f, 0xffb090f2, 0xfd936c73,
  0xffff8002, 0xffff0005, 0xfff80022, 0xffc1811a,
  0xffff0003, 0xfffe0007, 0xfff00032, 0xff830197,
  0xfffe8003, 0xfffd0007, 0xffe80032, 0xff448197,
  0xfffe0002, 0xfffc0005, 0xffe00022, 0xff06011a,
  0xfffd5558, 0xfffaaab1, 0xffd55582, 0xfeb2ac18,
  0xfffc888c, 0xfff91119, 0xffc888c2, 0xfe4eac7c,
  0xfffb890c, 0xfff71219, 0xffb890c2, 0xfdd1eafc,
  0xfffa898b, 0xfff51317, 0xffa898b2, 0xfd5528ff,
  0xffff8001, 0xffff0003, 0xfff80012, 0xffc1809d,
  0xffff0001, 0xfffe0003, 0xfff00012, 0xff83009d,
  0xfffe8000, 0xfffd0001, 0xffe80002, 0xff448020,
  0xfffdd556, 0xfffbaaad, 0xffdd5562, 0xfef12b1e,
  0xfffd088a, 0xfffa1115, 0xffd088a2, 0xfe8d2b82,
  0xfffc090a, 0xfff81215, 0xffc090a2, 0xfe106a02,
  0xfffb0989, 0xfff61313, 0xffb09892, 0xfd93a805,
  0xfffa0a07, 0xfff4140f, 0xffa0a072, 0xfd16e58b,
  0xffff8000, 0xffff0001, 0xfff80002, 0xffc18020,
  0xfffeffff, 0xfffdffff, 0xffeffff2, 0xff82ffa3,
  0xfffe5555, 0xfffcaaab, 0xffe55552, 0xff2faaa1,
  0xfffd8889, 0xfffb1113, 0xffd88892, 0xfecbab05,
  0xfffc8909, 0xfff91213, 0xffc89092, 0xfe4ee985,
  0xfffb8988, 0xfff71311, 0xffb89882, 0xfdd22788,
  0xfffa8a06, 0xfff5140d, 0xffa8a062, 0xfd55650e,
  0xfff98a83, 0xfff31507, 0xff98a832, 0xfcd8a217,
  0xffff7fff, 0xfffeffff, 0xfff7fff2, 0xffc17fa3,
  0xfffed555, 0xfffdaaab, 0xffed5552, 0xff6e2aa1,
  0xfffe0889, 0xfffc1113, 0xffe08892, 0xff0a2b05,
  0xfffd0909, 0xfffa1213, 0xffd09092, 0xfe8d6985,
  0xfffc0988, 0xfff81311, 0xffc09882, 0xfe10a788,
  0xfffb0a06, 0xfff6140d, 0xffb0a062, 0xfd93e50e,
  0xfffa0a83, 0xfff41507, 0xffa0a832, 0xfd172217,
  0xfff90a93, 0xfff21527, 0xff90a932, 0xfc9a29e7,
  0xffff5556, 0xfffeaaad, 0xfff55562, 0xffacab1e,
  0xfffe888a, 0xfffd1115, 0xffe888a2, 0xff48ab82,
  0xfffd890a, 0xfffb1215, 0xffd890a2, 0xfecbea02,
  0xfffc8989, 0xfff91313, 0xffc89892, 0xfe4f2805,
  0xfffb8a07, 0xfff7140f, 0xffb8a072, 0xfdd2658b,
  0xfffa8a84, 0xfff51509, 0xffa8a842, 0xfd55a294,
  0xfff98a94, 0xfff31529, 0xff98a942, 0xfcd8aa64,
  0xfff88a97, 0xfff1152f, 0xff88a972, 0xfc5babdb,
  0xffff3334, 0xfffe6669, 0xfff33342, 0xff9c0084,
  0xfffe33b4, 0xfffc6769, 0xffe33b42, 0xff1f3f04,
  0xfffd3433, 0xfffa6867, 0xffd34332, 0xfea27d07,
  0xfffc34b1, 0xfff86963, 0xffc34b12, 0xfe25ba8d,
  0xfffb352e, 0xfff66a5d, 0xffb352e2, 0xfda8f796,
  0xfffa353e, 0xfff46a7d, 0xffa353e2, 0xfd2bff66,
  0xfff93541, 0xfff26a83, 0xff935412, 0xfcaf00dd,
  0xfff83543, 0xfff06a87, 0xff835432, 0xfc3201d7,
  0xffff0080, 0xfffe0101, 0xfff00802, 0xff833ea0,
  0xfffe00ff, 0xfffc01ff, 0xffe00ff2, 0xff067ca3,
  0xfffd017d, 0xfffa02fb, 0xffd017d2, 0xfe89ba29,
  0xfffc01fa, 0xfff803f5, 0xffc01fa2, 0xfe0cf732,
  0xfffb020a, 0xfff60415, 0xffb020a2, 0xfd8fff02,
  0xfffa020d, 0xfff4041b, 0xffa020d2, 0xfd130079,
  0xfff9020f, 0xfff2041f, 0xff9020f2, 0xfc960173,
  0xfff80210, 0xfff00421, 0xff802102, 0xfc1901f0,
  0xfffe00fe, 0xfff007f1, 0xff833e05, 0xff823ea2,
  0xfffc01fa, 0xffe00fd1, 0xff067b8b, 0xff047ca6,
  0xfffa02f4, 0xffd017a1, 0xfe89b894, 0xfe86ba2c,
  0xfff80314, 0xffc018a1, 0xfe0cc064, 0xfe08c20c,
  0xfff6031a, 0xffb018d1, 0xfd8fc1db, 0xfd8ac386,
  0xfff4031e, 0xffa018f1, 0xfd12c2d5, 0xfd0cc482,
  0xfff20320, 0xff901901, 0xfc95c352, 0xfc8ec500,
  0xfff20320, 0xff901901, 0xfc95c352, 0xfc8ec500,
  0xfffe00fc, 0xfff007e1, 0xff833d88, 0xff823e24,
  0xfffc01f6, 0xffe00fb1, 0xff067a91, 0xff047baa,
  0xfffa0216, 0xffd010b1, 0xfe898261, 0xfe86838a,
  0xfff8021c, 0xffc010e1, 0xfe0c83d8, 0xfe088504,
  0xfff60220, 0xffb01101, 0xfd8f84d2, 0xfd8a8600,
  0xfff40222, 0xffa01111, 0xfd12854f, 0xfd0c867e,
  0xfff40222, 0xffa01111, 0xfd12854f, 0xfd0c867e,
  0xfff40220, 0xffa01101, 0xfd1284d2, 0xfd0c8600,
  0xfffe00fa, 0xfff007d1, 0xff833d0b, 0xff823da6,
  0xfffc011a, 0xffe008d1, 0xff0644db, 0xff044586,
  0xfffa0120, 0xffd00901, 0xfe894652, 0xfe864700,
  0xfff80124, 0xffc00921, 0xfe0c474c, 0xfe0847fc,
  0xfff60126, 0xffb00931, 0xfd8f47c9, 0xfd8a487a,
  0xfff60126, 0xffb00931, 0xfd8f47c9, 0xfd8a487a,
  0xfff60124, 0xffb00921, 0xfd8f474c, 0xfd8a47fc,
  0xfff60120, 0xffb00901, 0xfd8f4652, 0xfd8a4700,
  0xfffe0020, 0xfff00101, 0xff8307d2, 0xff820800,
  0xfffc0026, 0xffe00131, 0xff060949, 0xff04097a,
  0xfffa002a, 0xffd00151, 0xfe890a43, 0xfe860a76,
  0xfff8002c, 0xffc00161, 0xfe0c0ac0, 0xfe080af4,
  0xfff8002c, 0xffc00161, 0xfe0c0ac0, 0xfe080af4,
  0xfff8002a, 0xffc00151, 0xfe0c0a43, 0xfe080a76,
  0xfff80026, 0xffc00131, 0xfe0c0949, 0xfe08097a,
  0xfff80006, 0xffc00031, 0xfe0c0179, 0xfe08019a,
  0xfffe0006, 0xfff00031, 0xff830179, 0xff82019a,
  0xfffc000a, 0xffe00051, 0xff060273, 0xff040296,
  0xfffa000c, 0xffd00061, 0xfe8902f0, 0xfe860314,
  0xfffa000c, 0xffd00061, 0xfe8902f0, 0xfe860314,
  0xfffa000a, 0xffd00051, 0xfe890273, 0xfe860296,
  0xfffa0006, 0xffd00031, 0xfe890179, 0xfe86019a,
  0xfff9ffe6, 0xffcfff31, 0xfe88f9a9, 0xfe85f9ba,
  0xfff9feec, 0xffcff761, 0xfe88bca0, 0xfe85bc34,
  0xfffe0004, 0xfff00021, 0xff8300fc, 0xff82011c,
  0xfffc0006, 0xffe00031, 0xff060179, 0xff04019a,
  0xfffc0006, 0xffe00031, 0xff060179, 0xff04019a,
  0xfffc0004, 0xffe00021, 0xff0600fc, 0xff04011c,
  0xfffc0000, 0xffe00001, 0xff060002, 0xff040020,
  0xfffbffe0, 0xffdfff01, 0xff05f832, 0xff03f840,
  0xfffbfee6, 0xffdff731, 0xff05bb29, 0xff03baba,
  0xfffbfdea, 0xffdfef51, 0xff057da3, 0xff037cb6,
  0xfffe0002, 0xfff00011, 0xff83007f, 0xff82009e,
  0xfffe0002, 0xfff00011, 0xff83007f, 0xff82009e,
  0xfffe0000, 0xfff00001, 0xff830002, 0xff820020,
  0xfffdfffc, 0xffefffe1, 0xff82ff08, 0xff81ff24,
  0xfffdffdc, 0xffeffee1, 0xff82f738, 0xff81f744,
  0xfffdfee2, 0xffeff711, 0xff82ba2f, 0xff81b9be,
  0xfffdfde6, 0xffefef31, 0xff827ca9, 0xff817bba,
  0xfffdfce8, 0xffefe741, 0xff823ea6, 0xff813d38,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffffffe, 0xfffffff1, 0xffffff85, 0xffffffa2,
  0xfffffffa, 0xffffffd1, 0xfffffe8b, 0xfffffea6,
  0xffffffda, 0xfffffed1, 0xfffff6bb, 0xfffff6c6,
  0xfffffee0, 0xfffff701, 0xffffb9b2, 0xffffb940,
  0xfffffde4, 0xffffef21, 0xffff7c2c, 0xffff7b3c,
  0xfffffce6, 0xffffe731, 0xffff3e29, 0xffff3cba,
  0xffff9680, 0xfffcb401, 0xffe63e42, 0xffe609a0,
  0xfffffffe, 0xfffffff1, 0xffffff85, 0xffffffa2,
  0xfffffffa, 0xffffffd1, 0xfffffe8b, 0xfffffea6,
  0xffffffda, 0xfffffed1, 0xfffff6bb, 0xfffff6c6,
  0xfffffee0, 0xfffff701, 0xffffb9b2, 0xffffb940,
  0xfffffde4, 0xffffef21, 0xffff7c2c, 0xffff7b3c,
  0xfffffce6, 0xffffe731, 0xffff3e29, 0xffff3cba,
  0xffff9680, 0xfffcb401, 0xffe63e42, 0xffe609a0,
  0xfffeebd6, 0xfff75eb1, 0xffbc93c1, 0xffbc09ca,
  0xfffffffc, 0xffffffe1, 0xffffff08, 0xffffff24,
  0xffffffdc, 0xfffffee1, 0xfffff738, 0xfffff744,
  0xfffffee2, 0xfffff711, 0xffffba2f, 0xffffb9be,
  0xfffffde6, 0xffffef31, 0xffff7ca9, 0xffff7bba,
  0xfffffce8, 0xffffe741, 0xffff3ea6, 0xffff3d38,
  0xffff9682, 0xfffcb411, 0xffe63ebf, 0xffe60a1e,
  0xfffeebd8, 0xfff75ec1, 0xffbc943e, 0xffbc0a48,
  0xfffdebde, 0xffef5ef1, 0xff7e15b5, 0xff7d0bc2,
  0xffffffe0, 0xffffff01, 0xfffff832, 0xfffff840,
  0xfffffee6, 0xfffff731, 0xffffbb29, 0xffffbaba,
  0xfffffdea, 0xffffef51, 0xffff7da3, 0xffff7cb6,
  0xfffffcec, 0xffffe761, 0xffff3fa0, 0xffff3e34,
  0xffff9686, 0xfffcb431, 0xffe63fb9, 0xffe60b1a,
  0xfffeebdc, 0xfff75ee1, 0xffbc9538, 0xffbc0b44,
  0xfffdebe2, 0xffef5f11, 0xff7e16af, 0xff7d0cbe,
  0xfffcebe6, 0xffe75f31, 0xff3f97a9, 0xff3e0dba,
  0xffffff06, 0xfffff831, 0xffffc2f9, 0xffffc29a,
  0xfffffe0a, 0xfffff051, 0xffff8573, 0xffff8496,
  0xfffffd0c, 0xffffe861, 0xffff4770, 0xffff4614,
  0xffff96a6, 0xfffcb531, 0xffe64789, 0xffe612fa,
  0xfffeebfc, 0xfff75fe1, 0xffbc9d08, 0xffbc1324,
  0xfffdec02, 0xffef6011, 0xff7e1e7f, 0xff7d149e,
  0xfffcec06, 0xffe76031, 0xff3f9f79, 0xff3e159a,
  0xfffbec08, 0xffdf6041, 0xff011ff6, 0xfeff1618,
  0xffffff04, 0xfffff821, 0xffffc27c, 0xffffc21c,
  0xfffffe06, 0xfffff031, 0xffff8479, 0xffff839a,
  0xffff97a0, 0xfffcbd01, 0xffe68492, 0xffe65080,
  0xfffeecf6, 0xfff767b1, 0xffbcda11, 0xffbc50aa,
  0xfffdecfc, 0xffef67e1, 0xff7e5b88, 0xff7d5224,
  0xfffced00, 0xffe76801, 0xff3fdc82, 0xff3e5320,
  0xfffbed02, 0xffdf6811, 0xff015cff, 0xfeff539e,
  0xfffaed02, 0xffd76811, 0xfec2dcff, 0xfec0539e,
  0xffffff02, 0xfffff811, 0xffffc1ff, 0xffffc19e,
  0xffff989c, 0xfffcc4e1, 0xffe6c218, 0xffe68e84,
  0xfffeedf2, 0xfff76f91, 0xffbd1797, 0xffbc8eae,
  0xfffdedf8, 0xffef6fc1, 0xff7e990e, 0xff7d9028,
  0xfffcedfc, 0xffe76fe1, 0xff401a08, 0xff3e9124,
  0xfffbedfe, 0xffdf6ff1, 0xff019a85, 0xfeff91a2,
  0xfffaedfe, 0xffd76ff1, 0xfec31a85, 0xfec091a2,
  0xfff9edfc, 0xffcf6fe1, 0xfe849a08, 0xfe819124,
  0xffff999a, 0xfffcccd1, 0xffe7001b, 0xffe6cd06,
  0xfffeeef0, 0xfff77781, 0xffbd559a, 0xffbccd30,
  0xfffdeef6, 0xffef77b1, 0xff7ed711, 0xff7dceaa,
  0xfffceefa, 0xffe777d1, 0xff40580b, 0xff3ecfa6,
  0xfffbeefc, 0xffdf77e1, 0xff01d888, 0xfeffd024,
  0xfffaeefc, 0xffd777e1, 0xfec35888, 0xfec0d024,
  0xfff9eefa, 0xffcf77d1, 0xfe84d80b, 0xfe81cfa6,
  0xfff899a6, 0xffc4cd31, 0xfe318309, 0xfe2dcffa,
  0xffff5556, 0xfffaaab1, 0xffd65581, 0xffd6004a,
  0xfffe555c, 0xfff2aae1, 0xff97d6f8, 0xff9701c4,
  0xfffd5560, 0xffeaab01, 0xff5957f2, 0xff5802c0,
  0xfffc5562, 0xffe2ab11, 0xff1ad86f, 0xff19033e,
  0xfffb5562, 0xffdaab11, 0xfedc586f, 0xfeda033e,
  0xfffa5560, 0xffd2ab01, 0xfe9dd7f2, 0xfe9b02c0,
  0xfff9000c, 0xffc80061, 0xfe4a82f0, 0xfe470314,
  0xfff76674, 0xffbb33a1, 0xfde68354, 0xfde236ac,
  0xffff0006, 0xfff80031, 0xffc18179, 0xffc1019a,
  0xfffe000a, 0xfff00051, 0xff830273, 0xff820296,
  0xfffd000c, 0xffe80061, 0xff4482f0, 0xff430314,
  0xfffc000c, 0xffe00061, 0xff0602f0, 0xff040314,
  0xfffb000a, 0xffd80051, 0xfec78273, 0xfec50296,
  0xfff9aab6, 0xffcd55b1, 0xfe742d71, 0xfe7102ea,
  0xfff8111e, 0xffc088f1, 0xfe102dd5, 0xfe0c3682,
  0xfff6121e, 0xffb090f1, 0xfd936c55, 0xfd8e7582,
  0xffff0004, 0xfff80021, 0xffc180fc, 0xffc1011c,
  0xfffe0006, 0xfff00031, 0xff830179, 0xff82019a,
  0xfffd0006, 0xffe80031, 0xff448179, 0xff43019a,
  0xfffc0004, 0xffe00021, 0xff0600fc, 0xff04011c,
  0xfffaaab0, 0xffd55581, 0xfeb2abfa, 0xfeb00170,
  0xfff91118, 0xffc888c1, 0xfe4eac5e, 0xfe4b3508,
  0xfff71218, 0xffb890c1, 0xfdd1eade, 0xfdcd7408,
  0xfff51316, 0xffa898b1, 0xfd5528e1, 0xfd4fb28a,
  0xffff0002, 0xfff80011, 0xffc1807f, 0xffc1009e,
  0xfffe0002, 0xfff00011, 0xff83007f, 0xff82009e,
  0xfffd0000, 0xffe80001, 0xff448002, 0xff430020,
  0xfffbaaac, 0xffdd5561, 0xfef12b00, 0xfeef0074,
  0xfffa1114, 0xffd088a1, 0xfe8d2b64, 0xfe8a340c,
  0xfff81214, 0xffc090a1, 0xfe1069e4, 0xfe0c730c,
  0xfff61312, 0xffb09891, 0xfd93a7e7, 0xfd8eb18e,
  0xfff4140e, 0xffa0a071, 0xfd16e56d, 0xfd10ef92,
  0xffff0000, 0xfff80001, 0xffc18002, 0xffc10020,
  0xfffdfffe, 0xffeffff1, 0xff82ff85, 0xff81ffa2,
  0xfffcaaaa, 0xffe55551, 0xff2faa83, 0xff2dfff6,
  0xfffb1112, 0xffd88891, 0xfecbaae7, 0xfec9338e,
  0xfff91212, 0xffc89091, 0xfe4ee967, 0xfe4b728e,
  0xfff71310, 0xffb89881, 0xfdd2276a, 0xfdcdb110,
  0xfff5140c, 0xffa8a061, 0xfd5564f0, 0xfd4fef14,
  0xfff31506, 0xff98a831, 0xfcd8a1f9, 0xfcd22c9a,
  0xfffefffe, 0xfff7fff1, 0xffc17f85, 0xffc0ffa2,
  0xfffdaaaa, 0xffed5551, 0xff6e2a83, 0xff6cfff6,
  0xfffc1112, 0xffe08891, 0xff0a2ae7, 0xff08338e,
  0xfffa1212, 0xffd09091, 0xfe8d6967, 0xfe8a728e,
  0xfff81310, 0xffc09881, 0xfe10a76a, 0xfe0cb110,
  0xfff6140c, 0xffb0a061, 0xfd93e4f0, 0xfd8eef14,
  0xfff41506, 0xffa0a831, 0xfd1721f9, 0xfd112c9a,
  0xfff21526, 0xff90a931, 0xfc9a29c9, 0xfc93347a,
  0xfffeaaac, 0xfff55561, 0xffacab00, 0xffac0074,
  0xfffd1114, 0xffe888a1, 0xff48ab64, 0xff47340c,
  0xfffb1214, 0xffd890a1, 0xfecbe9e4, 0xfec9730c,
  0xfff91312, 0xffc89891, 0xfe4f27e7, 0xfe4bb18e,
  0xfff7140e, 0xffb8a071, 0xfdd2656d, 0xfdcdef92,
  0xfff51508, 0xffa8a841, 0xfd55a276, 0xfd502d18,
  0xfff31528, 0xff98a941, 0xfcd8aa46, 0xfcd234f8,
  0xfff1152e, 0xff88a971, 0xfc5babbd, 0xfc543672,
  0xfffe6668, 0xfff33341, 0xff9c0066, 0xff9b33b8,
  0xfffc6768, 0xffe33b41, 0xff1f3ee6, 0xff1d72b8,
  0xfffa6866, 0xffd34331, 0xfea27ce9, 0xfe9fb13a,
  0xfff86962, 0xffc34b11, 0xfe25ba6f, 0xfe21ef3e,
  0xfff66a5c, 0xffb352e1, 0xfda8f778, 0xfda42cc4,
  0xfff46a7c, 0xffa353e1, 0xfd2bff48, 0xfd2634a4,
  0xfff26a82, 0xff935411, 0xfcaf00bf, 0xfca8361e,
  0xfff06a86, 0xff835431, 0xfc3201b9, 0xfc2a371a,
  0xfffe0100, 0xfff00801, 0xff833e82, 0xff823f20,
  0xfffc01fe, 0xffe00ff1, 0xff067c85, 0xff047da2,
  0xfffa02fa, 0xffd017d1, 0xfe89ba0b, 0xfe86bba6,
  0xfff803f4, 0xffc01fa1, 0xfe0cf714, 0xfe08f92c,
  0xfff60414, 0xffb020a1, 0xfd8ffee4, 0xfd8b010c,
  0xfff4041a, 0xffa020d1, 0xfd13005b, 0xfd0d0286,
  0xfff2041e, 0xff9020f1, 0xfc960155, 0xfc8f0382,
  0xfff00420, 0xff802101, 0xfc1901d2, 0xfc110400,
  0xfff007f0, 0xff833e04, 0xff823e84, 0xff813f21,
  0xffe00fd0, 0xff067b8a, 0xff047c88, 0xff027da3,
  0xffd017a0, 0xfe89b893, 0xfe86ba0e, 0xfe83bba6,
  0xffc018a0, 0xfe0cc063, 0xfe08c1ee, 0xfe04c396,
  0xffb018d0, 0xfd8fc1da, 0xfd8ac368, 0xfd85c513,
  0xffa018f0, 0xfd12c2d4, 0xfd0cc464, 0xfd06c611,
  0xff901900, 0xfc95c351, 0xfc8ec4e2, 0xfc87c690,
  0xff901900, 0xfc95c351, 0xfc8ec4e2, 0xfc87c690,
  0xfff007e0, 0xff833d87, 0xff823e06, 0xff813ea2,
  0xffe00fb0, 0xff067a90, 0xff047b8c, 0xff027ca5,
  0xffd010b0, 0xfe898260, 0xfe86836c, 0xfe838495,
  0xffc010e0, 0xfe0c83d7, 0xfe0884e6, 0xfe048612,
  0xffb01100, 0xfd8f84d1, 0xfd8a85e2, 0xfd858710,
  0xffa01110, 0xfd12854e, 0xfd0c8660, 0xfd06878f,
  0xffa01110, 0xfd12854e, 0xfd0c8660, 0xfd06878f,
  0xffa01100, 0xfd1284d1, 0xfd0c85e2, 0xfd068710,
  0xfff007d0, 0xff833d0a, 0xff823d88, 0xff813e23,
  0xffe008d0, 0xff0644da, 0xff044568, 0xff024613,
  0xffd00900, 0xfe894651, 0xfe8646e2, 0xfe834790,
  0xffc00920, 0xfe0c474b, 0xfe0847de, 0xfe04488e,
  0xffb00930, 0xfd8f47c8, 0xfd8a485c, 0xfd85490d,
  0xffb00930, 0xfd8f47c8, 0xfd8a485c, 0xfd85490d,
  0xffb00920, 0xfd8f474b, 0xfd8a47de, 0xfd85488e,
  0xffb00900, 0xfd8f4651, 0xfd8a46e2, 0xfd854790,
  0xfff00100, 0xff8307d1, 0xff8207e2, 0xff810810,
  0xffe00130, 0xff060948, 0xff04095c, 0xff02098d,
  0xffd00150, 0xfe890a42, 0xfe860a58, 0xfe830a8b,
  0xffc00160, 0xfe0c0abf, 0xfe080ad6, 0xfe040b0a,
  0xffc00160, 0xfe0c0abf, 0xfe080ad6, 0xfe040b0a,
  0xffc00150, 0xfe0c0a42, 0xfe080a58, 0xfe040a8b,
  0xffc00130, 0xfe0c0948, 0xfe08095c, 0xfe04098d,
  0xffc00030, 0xfe0c0178, 0xfe08017c, 0xfe04019d,
  0xfff00030, 0xff830178, 0xff82017c, 0xff81019d,
  0xffe00050, 0xff060272, 0xff040278, 0xff02029b,
  0xffd00060, 0xfe8902ef, 0xfe8602f6, 0xfe83031a,
  0xffd00060, 0xfe8902ef, 0xfe8602f6, 0xfe83031a,
  0xffd00050, 0xfe890272, 0xfe860278, 0xfe83029b,
  0xffd00030, 0xfe890178, 0xfe86017c, 0xfe83019d,
  0xffcfff30, 0xfe88f9a8, 0xfe85f99c, 0xfe82f9ad,
  0xffcff760, 0xfe88bc9f, 0xfe85bc16, 0xfe82bbaa,
  0xfff00020, 0xff8300fb, 0xff8200fe, 0xff81011e,
  0xffe00030, 0xff060178, 0xff04017c, 0xff02019d,
  0xffe00030, 0xff060178, 0xff04017c, 0xff02019d,
  0xffe00020, 0xff0600fb, 0xff0400fe, 0xff02011e,
  0xffe00000, 0xff060001, 0xff040002, 0xff020020,
  0xffdfff00, 0xff05f831, 0xff03f822, 0xff01f830,
  0xffdff730, 0xff05bb28, 0xff03ba9c, 0xff01ba2d,
  0xffdfef50, 0xff057da2, 0xff037c98, 0xff017bab,
  0xfff00010, 0xff83007e, 0xff820080, 0xff81009f,
  0xfff00010, 0xff83007e, 0xff820080, 0xff81009f,
  0xfff00000, 0xff830001, 0xff820002, 0xff810020,
  0xffefffe0, 0xff82ff07, 0xff81ff06, 0xff80ff22,
  0xffeffee0, 0xff82f737, 0xff81f726, 0xff80f732,
  0xffeff710, 0xff82ba2e, 0xff81b9a0, 0xff80b92f,
  0xffefef30, 0xff827ca8, 0xff817b9c, 0xff807aad,
  0xffefe740, 0xff823ea5, 0xff813d1a, 0xff803bac,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffffff0, 0xffffff84, 0xffffff84, 0xffffffa1,
  0xffffffd0, 0xfffffe8a, 0xfffffe88, 0xfffffea3,
  0xfffffed0, 0xfffff6ba, 0xfffff6a8, 0xfffff6b3,
  0xfffff700, 0xffffb9b1, 0xffffb922, 0xffffb8b0,
  0xffffef20, 0xffff7c2b, 0xffff7b1e, 0xffff7a2e,
  0xffffe730, 0xffff3e28, 0xffff3c9c, 0xffff3b2d,
  0xfffcb400, 0xffe63e41, 0xffe60982, 0xffe5d4e0,
  0xfffffff0, 0xffffff84, 0xffffff84, 0xffffffa1,
  0xffffffd0, 0xfffffe8a, 0xfffffe88, 0xfffffea3,
  0xfffffed0, 0xfffff6ba, 0xfffff6a8, 0xfffff6b3,
  0xfffff700, 0xffffb9b1, 0xffffb922, 0xffffb8b0,
  0xffffef20, 0xffff7c2b, 0xffff7b1e, 0xffff7a2e,
  0xffffe730, 0xffff3e28, 0xffff3c9c, 0xffff3b2d,
  0xfffcb400, 0xffe63e41, 0xffe60982, 0xffe5d4e0,
  0xfff75eb0, 0xffbc93c0, 0xffbc09ac, 0xffbb7fb5,
  0xffffffe0, 0xffffff07, 0xffffff06, 0xffffff22,
  0xfffffee0, 0xfffff737, 0xfffff726, 0xfffff732,
  0xfffff710, 0xffffba2e, 0xffffb9a0, 0xffffb92f,
  0xffffef30, 0xffff7ca8, 0xffff7b9c, 0xffff7aad,
  0xffffe740, 0xffff3ea5, 0xffff3d1a, 0xffff3bac,
  0xfffcb410, 0xffe63ebe, 0xffe60a00, 0xffe5d55f,
  0xfff75ec0, 0xffbc943d, 0xffbc0a2a, 0xffbb8034,
  0xffef5ef0, 0xff7e15b4, 0xff7d0ba4, 0xff7c01b1,
  0xffffff00, 0xfffff831, 0xfffff822, 0xfffff830,
  0xfffff730, 0xffffbb28, 0xffffba9c, 0xffffba2d,
  0xffffef50, 0xffff7da2, 0xffff7c98, 0xffff7bab,
  0xffffe760, 0xffff3f9f, 0xffff3e16, 0xffff3caa,
  0xfffcb430, 0xffe63fb8, 0xffe60afc, 0xffe5d65d,
  0xfff75ee0, 0xffbc9537, 0xffbc0b26, 0xffbb8132,
  0xffef5f10, 0xff7e16ae, 0xff7d0ca0, 0xff7c02af,
  0xffe75f30, 0xff3f97a8, 0xff3e0d9c, 0xff3c83ad,
  0xfffff830, 0xffffc2f8, 0xffffc27c, 0xffffc21d,
  0xfffff050, 0xffff8572, 0xffff8478, 0xffff839b,
  0xffffe860, 0xffff476f, 0xffff45f6, 0xffff449a,
  0xfffcb530, 0xffe64788, 0xffe612dc, 0xffe5de4d,
  0xfff75fe0, 0xffbc9d07, 0xffbc1306, 0xffbb8922,
  0xffef6010, 0xff7e1e7e, 0xff7d1480, 0xff7c0a9f,
  0xffe76030, 0xff3f9f78, 0xff3e157c, 0xff3c8b9d,
  0xffdf6040, 0xff011ff5, 0xfeff15fa, 0xfefd0c1c,
  0xfffff820, 0xffffc27b, 0xffffc1fe, 0xffffc19e,
  0xfffff030, 0xffff8478, 0xffff837c, 0xffff829d,
  0xfffcbd00, 0xffe68491, 0xffe65062, 0xffe61c50,
  0xfff767b0, 0xffbcda10, 0xffbc508c, 0xffbbc725,
  0xffef67e0, 0xff7e5b87, 0xff7d5206, 0xff7c48a2,
  0xffe76800, 0xff3fdc81, 0xff3e5302, 0xff3cc9a0,
  0xffdf6810, 0xff015cfe, 0xfeff5380, 0xfefd4a1f,
  0xffd76810, 0xfec2dcfe, 0xfec05380, 0xfebdca1f,
  0xfffff810, 0xffffc1fe, 0xffffc180, 0xffffc11f,
  0xfffcc4e0, 0xffe6c217, 0xffe68e66, 0xffe65ad2,
  0xfff76f90, 0xffbd1796, 0xffbc8e90, 0xffbc05a7,
  0xffef6fc0, 0xff7e990d, 0xff7d900a, 0xff7c8724,
  0xffe76fe0, 0xff401a07, 0xff3e9106, 0xff3d0822,
  0xffdf6ff0, 0xff019a84, 0xfeff9184, 0xfefd88a1,
  0xffd76ff0, 0xfec31a84, 0xfec09184, 0xfebe08a1,
  0xffcf6fe0, 0xfe849a07, 0xfe819106, 0xfe7e8822,
  0xfffcccd0, 0xffe7001a, 0xffe6cce8, 0xffe699d3,
  0xfff77780, 0xffbd5599, 0xffbccd12, 0xffbc44a8,
  0xffef77b0, 0xff7ed710, 0xff7dce8c, 0xff7cc625,
  0xffe777d0, 0xff40580a, 0xff3ecf88, 0xff3d4723,
  0xffdf77e0, 0xff01d887, 0xfeffd006, 0xfefdc7a2,
  0xffd777e0, 0xfec35887, 0xfec0d006, 0xfebe47a2,
  0xffcf77d0, 0xfe84d80a, 0xfe81cf88, 0xfe7ec723,
  0xffc4cd30, 0xfe318308, 0xfe2dcfdc, 0xfe2a1ccd,
  0xfffaaab0, 0xffd65580, 0xffd6002c, 0xffd5aaf5,
  0xfff2aae0, 0xff97d6f7, 0xff9701a6, 0xff962c72,
  0xffeaab00, 0xff5957f1, 0xff5802a2, 0xff56ad70,
  0xffe2ab10, 0xff1ad86e, 0xff190320, 0xff172def,
  0xffdaab10, 0xfedc586e, 0xfeda0320, 0xfed7adef,
  0xffd2ab00, 0xfe9dd7f1, 0xfe9b02a2, 0xfe982d70,
  0xffc80060, 0xfe4a82ef, 0xfe4702f6, 0xfe43831a,
  0xffbb33a0, 0xfde68353, 0xfde2368e, 0xfddde9e6,
  0xfff80030, 0xffc18178, 0xffc1017c, 0xffc0819d,
  0xfff00050, 0xff830272, 0xff820278, 0xff81029b,
  0xffe80060, 0xff4482ef, 0xff4302f6, 0xff41831a,
  0xffe00060, 0xff0602ef, 0xff0402f6, 0xff02031a,
  0xffd80050, 0xfec78272, 0xfec50278, 0xfec2829b,
  0xffcd55b0, 0xfe742d70, 0xfe7102cc, 0xfe6dd845,
  0xffc088f0, 0xfe102dd4, 0xfe0c3664, 0xfe083f11,
  0xffb090f0, 0xfd936c54, 0xfd8e7564, 0xfd897e91,
  0xfff80020, 0xffc180fb, 0xffc100fe, 0xffc0811e,
  0xfff00030, 0xff830178, 0xff82017c, 0xff81019d,
  0xffe80030, 0xff448178, 0xff43017c, 0xff41819d,
  0xffe00020, 0xff0600fb, 0xff0400fe, 0xff02011e,
  0xffd55580, 0xfeb2abf9, 0xfeb00152, 0xfead56c8,
  0xffc888c0, 0xfe4eac5d, 0xfe4b34ea, 0xfe47bd94,
  0xffb890c0, 0xfdd1eadd, 0xfdcd73ea, 0xfdc8fd14,
  0xffa898b0, 0xfd5528e0, 0xfd4fb26c, 0xfd4a3c15,
  0xfff80010, 0xffc1807e, 0xffc10080, 0xffc0809f,
  0xfff00010, 0xff83007e, 0xff820080, 0xff81009f,
  0xffe80000, 0xff448001, 0xff430002, 0xff418020,
  0xffdd5560, 0xfef12aff, 0xfeef0056, 0xfeecd5ca,
  0xffd088a0, 0xfe8d2b63, 0xfe8a33ee, 0xfe873c96,
  0xffc090a0, 0xfe1069e3, 0xfe0c72ee, 0xfe087c16,
  0xffb09890, 0xfd93a7e6, 0xfd8eb170, 0xfd89bb17,
  0xffa0a070, 0xfd16e56c, 0xfd10ef74, 0xfd0af999,
  0xfff80000, 0xffc18001, 0xffc10002, 0xffc08020,
  0xffeffff0, 0xff82ff84, 0xff81ff84, 0xff80ffa1,
  0xffe55550, 0xff2faa82, 0xff2dffd8, 0xff2c554b,
  0xffd88890, 0xfecbaae6, 0xfec93370, 0xfec6bc17,
  0xffc89090, 0xfe4ee966, 0xfe4b7270, 0xfe47fb97,
  0xffb89880, 0xfdd22769, 0xfdcdb0f2, 0xfdc93a98,
  0xffa8a060, 0xfd5564ef, 0xfd4feef6, 0xfd4a791a,
  0xff98a830, 0xfcd8a1f8, 0xfcd22c7c, 0xfccbb71d,
  0xfff7fff0, 0xffc17f84, 0xffc0ff84, 0xffc07fa1,
  0xffed5550, 0xff6e2a82, 0xff6cffd8, 0xff6bd54b,
  0xffe08890, 0xff0a2ae6, 0xff083370, 0xff063c17,
  0xffd09090, 0xfe8d6966, 0xfe8a7270, 0xfe877b97,
  0xffc09880, 0xfe10a769, 0xfe0cb0f2, 0xfe08ba98,
  0xffb0a060, 0xfd93e4ef, 0xfd8eeef6, 0xfd89f91a,
  0xffa0a830, 0xfd1721f8, 0xfd112c7c, 0xfd0b371d,
  0xff90a930, 0xfc9a29c8, 0xfc93345c, 0xfc8c3f0d,
  0xfff55560, 0xffacaaff, 0xffac0056, 0xffab55ca,
  0xffe888a0, 0xff48ab63, 0xff4733ee, 0xff45bc96,
  0xffd890a0, 0xfecbe9e3, 0xfec972ee, 0xfec6fc16,
  0xffc89890, 0xfe4f27e6, 0xfe4bb170, 0xfe483b17,
  0xffb8a070, 0xfdd2656c, 0xfdcdef74, 0xfdc97999,
  0xffa8a840, 0xfd55a275, 0xfd502cfa, 0xfd4ab79c,
  0xff98a940, 0xfcd8aa45, 0xfcd234da, 0xfccbbf8c,
  0xff88a970, 0xfc5babbc, 0xfc543654, 0xfc4cc109,
  0xfff33340, 0xff9c0065, 0xff9b339a, 0xff9a66ec,
  0xffe33b40, 0xff1f3ee5, 0xff1d729a, 0xff1ba66c,
  0xffd34330, 0xfea27ce8, 0xfe9fb11c, 0xfe9ce56d,
  0xffc34b10, 0xfe25ba6e, 0xfe21ef20, 0xfe1e23ef,
  0xffb352e0, 0xfda8f777, 0xfda42ca6, 0xfd9f61f2,
  0xffa353e0, 0xfd2bff47, 0xfd263486, 0xfd2069e2,
  0xff935410, 0xfcaf00be, 0xfca83600, 0xfca16b5f,
  0xff835430, 0xfc3201b8, 0xfc2a36fc, 0xfc226c5d,
  0xfff00800, 0xff833e81, 0xff823f02, 0xff813fa0,
  0xffe00ff0, 0xff067c84, 0xff047d84, 0xff027ea1,
  0xffd017d0, 0xfe89ba0a, 0xfe86bb88, 0xfe83bd23,
  0xffc01fa0, 0xfe0cf713, 0xfe08f90e, 0xfe04fb26,
  0xffb020a0, 0xfd8ffee3, 0xfd8b00ee, 0xfd860316,
  0xffa020d0, 0xfd13005a, 0xfd0d0268, 0xfd070493,
  0xff9020f0, 0xfc960154, 0xfc8f0364, 0xfc880591,
  0xff802100, 0xfc1901d1, 0xfc1103e2, 0xfc090610,
  0xff833e03, 0xff823e83, 0xff813f03, 0xcce6666d,
  0xff067b89, 0xff047c87, 0xff027d85, 0x99cc9987,
  0xfe89b892, 0xfe86ba0d, 0xfe83bb88, 0x66b2996e,
  0xfe0cc062, 0xfe08c1ed, 0xfe04c378, 0x3382cc9e,
  0xfd8fc1d9, 0xfd8ac367, 0xfd85c4f5, 0x00506637,
  0xfd12c2d3, 0xfd0cc463, 0xfd06c5f3, 0xcd1dcc9d,
  0xfc95c350, 0xfc8ec4e1, 0xfc87c672, 0x99eaffd0,
  0xfc95c350, 0xfc8ec4e1, 0xfc87c672, 0x99eaffd0,
  0xff833d86, 0xff823e05, 0xff813e84, 0xcce6333a,
  0xff067a8f, 0xff047b8b, 0xff027c87, 0x99cc3321,
  0xfe89825f, 0xfe86836b, 0xfe838477, 0x669c6651,
  0xfe0c83d6, 0xfe0884e5, 0xfe0485f4, 0x3369ffea,
  0xfd8f84d0, 0xfd8a85e1, 0xfd8586f2, 0x00376650,
  0xfd12854d, 0xfd0c865f, 0xfd068771, 0xcd049983,
  0xfd12854d, 0xfd0c865f, 0xfd068771, 0xcd049983,
  0xfd1284d0, 0xfd0c85e1, 0xfd0686f2, 0xcd046650,
  0xff833d09, 0xff823d87, 0xff813e05, 0xcce60007,
  0xff0644d9, 0xff044567, 0xff0245f5, 0x99b63337,
  0xfe894650, 0xfe8646e1, 0xfe834772, 0x6683ccd0,
  0xfe0c474a, 0xfe0847dd, 0xfe044870, 0x33513336,
  0xfd8f47c7, 0xfd8a485b, 0xfd8548ef, 0x001e6669,
  0xfd8f47c7, 0xfd8a485b, 0xfd8548ef, 0x001e6669,
  0xfd8f474a, 0xfd8a47dd, 0xfd854870, 0x001e3336,
  0xfd8f4650, 0xfd8a46e1, 0xfd854772, 0x001dccd0,
  0xff8307d0, 0xff8207e1, 0xff8107f2, 0xccd03350,
  0xff060947, 0xff04095b, 0xff02096f, 0x999dcce9,
  0xfe890a41, 0xfe860a57, 0xfe830a6d, 0x666b334f,
  0xfe0c0abe, 0xfe080ad5, 0xfe040aec, 0x33386682,
  0xfe0c0abe, 0xfe080ad5, 0xfe040aec, 0x33386682,
  0xfe0c0a41, 0xfe080a57, 0xfe040a6d, 0x3338334f,
  0xfe0c0947, 0xfe08095b, 0xfe04096f, 0x3337cce9,
  0xfe0c0177, 0xfe08017b, 0xfe04017f, 0x333499b9,
  0xff830177, 0xff82017b, 0xff81017f, 0xcccd99b9,
  0xff060271, 0xff040277, 0xff02027d, 0x999b001f,
  0xfe8902ee, 0xfe8602f5, 0xfe8302fc, 0x66683352,
  0xfe8902ee, 0xfe8602f5, 0xfe8302fc, 0x66683352,
  0xfe890271, 0xfe860277, 0xfe83027d, 0x6668001f,
  0xfe890177, 0xfe86017b, 0xfe83017f, 0x666799b9,
  0xfe88f9a7, 0xfe85f99b, 0xfe82f98f, 0x66646689,
  0xfe88bc9e, 0xfe85bc15, 0xfe82bb8c, 0x664b66a2,
  0xff8300fa, 0xff8200fd, 0xff810100, 0xcccd6686,
  0xff060177, 0xff04017b, 0xff02017f, 0x999a99b9,
  0xff060177, 0xff04017b, 0xff02017f, 0x999a99b9,
  0xff0600fa, 0xff0400fd, 0xff020100, 0x999a6686,
  0xff060000, 0xff040001, 0xff020002, 0x999a0020,
  0xff05f830, 0xff03f821, 0xff01f812, 0x9996ccf0,
  0xff05bb27, 0xff03ba9b, 0xff01ba0f, 0x997dcd09,
  0xff057da1, 0xff037c97, 0xff017b8d, 0x996499ef,
  0xff83007d, 0xff82007f, 0xff810081, 0xcccd3353,
  0xff83007d, 0xff82007f, 0xff810081, 0xcccd3353,
  0xff830000, 0xff820001, 0xff810002, 0xcccd0020,
  0xff82ff06, 0xff81ff05, 0xff80ff04, 0xcccc99ba,
  0xff82f736, 0xff81f725, 0xff80f714, 0xccc9668a,
  0xff82ba2d, 0xff81b99f, 0xff80b911, 0xccb066a3,
  0xff827ca7, 0xff817b9b, 0xff807a8f, 0xcc973389,
  0xff823ea4, 0xff813d19, 0xff803b8e, 0xcc7dcd3c,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffff83, 0xffffff83, 0xffffff83, 0xffffcced,
  0xfffffe89, 0xfffffe87, 0xfffffe85, 0xffff6687,
  0xfffff6b9, 0xfffff6a7, 0xfffff695, 0xfffc3357,
  0xffffb9b0, 0xffffb921, 0xffffb892, 0xffe33370,
  0xffff7c2a, 0xffff7b1d, 0xffff7a10, 0xffca0056,
  0xffff3e27, 0xffff3c9b, 0xffff3b0f, 0xffb09a09,
  0xffe63e40, 0xffe60981, 0xffe5d4c2, 0xf5733de0,
  0xffffff83, 0xffffff83, 0xffffff83, 0xffffcced,
  0xfffffe89, 0xfffffe87, 0xfffffe85, 0xffff6687,
  0xfffff6b9, 0xfffff6a7, 0xfffff695, 0xfffc3357,
  0xffffb9b0, 0xffffb921, 0xffffb892, 0xffe33370,
  0xffff7c2a, 0xffff7b1d, 0xffff7a10, 0xffca0056,
  0xffff3e27, 0xffff3c9b, 0xffff3b0f, 0xffb09a09,
  0xffe63e40, 0xffe60981, 0xffe5d4c2, 0xf5733de0,
  0xffbc93bf, 0xffbc09ab, 0xffbb7f97, 0xe4624ef1,
  0xffffff06, 0xffffff05, 0xffffff04, 0xffff99ba,
  0xfffff736, 0xfffff725, 0xfffff714, 0xfffc668a,
  0xffffba2d, 0xffffb99f, 0xffffb911, 0xffe366a3,
  0xffff7ca7, 0xffff7b9b, 0xffff7a8f, 0xffca3389,
  0xffff3ea4, 0xffff3d19, 0xffff3b8e, 0xffb0cd3c,
  0xffe63ebd, 0xffe609ff, 0xffe5d541, 0xf5737113,
  0xffbc943c, 0xffbc0a29, 0xffbb8016, 0xe4628224,
  0xff7e15b3, 0xff7d0ba3, 0xff7c0193, 0xcac99bbd,
  0xfffff830, 0xfffff821, 0xfffff812, 0xfffcccf0,
  0xffffbb27, 0xffffba9b, 0xffffba0f, 0xffe3cd09,
  0xffff7da1, 0xffff7c97, 0xffff7b8d, 0xffca99ef,
  0xffff3f9e, 0xffff3e15, 0xffff3c8c, 0xffb133a2,
  0xffe63fb7, 0xffe60afb, 0xffe5d63f, 0xf573d779,
  0xffbc9536, 0xffbc0b25, 0xffbb8114, 0xe462e88a,
  0xff7e16ad, 0xff7d0c9f, 0xff7c0291, 0xcaca0223,
  0xff3f97a7, 0xff3e0d9b, 0xff3c838f, 0xb130e889,
  0xffffc2f7, 0xffffc27b, 0xffffc1ff, 0xffe70039,
  0xffff8571, 0xffff8477, 0xffff837d, 0xffcdcd1f,
  0xffff476e, 0xffff45f5, 0xffff447c, 0xffb466d2,
  0xffe64787, 0xffe612db, 0xffe5de2f, 0xf5770aa9,
  0xffbc9d06, 0xffbc1305, 0xffbb8904, 0xe4661bba,
  0xff7e1e7d, 0xff7d147f, 0xff7c0a81, 0xcacd3553,
  0xff3f9f77, 0xff3e157b, 0xff3c8b7f, 0xb1341bb9,
  0xff011ff4, 0xfeff15f9, 0xfefd0bfe, 0x979aceec,
  0xffffc27a, 0xffffc1fd, 0xffffc180, 0xffe6cd06,
  0xffff8477, 0xffff837b, 0xffff827f, 0xffcd66b9,
  0xffe68490, 0xffe65061, 0xffe61c32, 0xf5900a90,
  0xffbcda0f, 0xffbc508b, 0xffbbc707, 0xe47f1ba1,
  0xff7e5b86, 0xff7d5205, 0xff7c4884, 0xcae6353a,
  0xff3fdc80, 0xff3e5301, 0xff3cc982, 0xb14d1ba0,
  0xff015cfd, 0xfeff537f, 0xfefd4a01, 0x97b3ced3,
  0xfec2dcfd, 0xfec0537f, 0xfebdca01, 0x7e1a4ed3,
  0xffffc1fd, 0xffffc17f, 0xffffc101, 0xffe699d3,
  0xffe6c216, 0xffe68e65, 0xffe65ab4, 0xf5a93daa,
  0xffbd1795, 0xffbc8e8f, 0xffbc0589, 0xe4984ebb,
  0xff7e990c, 0xff7d9009, 0xff7c8706, 0xcaff6854,
  0xff401a06, 0xff3e9105, 0xff3d0804, 0xb1664eba,
  0xff019a83, 0xfeff9183, 0xfefd8883, 0x97cd01ed,
  0xfec31a83, 0xfec09183, 0xfebe0883, 0x7e3381ed,
  0xfe849a06, 0xfe819105, 0xfe7e8804, 0x6499ceba,
  0xffe70019, 0xffe6cce7, 0xffe699b5, 0xf5c2a3f7,
  0xffbd5598, 0xffbccd11, 0xffbc448a, 0xe4b1b508,
  0xff7ed70f, 0xff7dce8b, 0xff7cc607, 0xcb18cea1,
  0xff405809, 0xff3ecf87, 0xff3d4705, 0xb17fb507,
  0xff01d886, 0xfeffd005, 0xfefdc784, 0x97e6683a,
  0xfec35886, 0xfec0d005, 0xfebe4784, 0x7e4ce83a,
  0xfe84d809, 0xfe81cf87, 0xfe7ec705, 0x64b33507,
  0xfe318307, 0xfe2dcfdb, 0xfe2a1caf, 0x42915729,
  0xffd6557f, 0xffd6002b, 0xffd5aad7, 0xeeef1131,
  0xff97d6f6, 0xff9701a5, 0xff962c54, 0xd5562aca,
  0xff5957f0, 0xff5802a1, 0xff56ad52, 0xbbbd1130,
  0xff1ad86d, 0xff19031f, 0xff172dd1, 0xa223c463,
  0xfedc586d, 0xfeda031f, 0xfed7add1, 0x888a4463,
  0xfe9dd7f0, 0xfe9b02a1, 0xfe982d52, 0x6ef09130,
  0xfe4a82ee, 0xfe4702f5, 0xfe4382fc, 0x4cceb352,
  0xfde68352, 0xfde2368d, 0xfddde9c8, 0x23d942ae,
  0xffc18177, 0xffc1017b, 0xffc0817f, 0xe66719b9,
  0xff830271, 0xff820277, 0xff81027d, 0xccce001f,
  0xff4482ee, 0xff4302f5, 0xff4182fc, 0xb334b352,
  0xff0602ee, 0xff0402f5, 0xff0202fc, 0x999b3352,
  0xfec78271, 0xfec50277, 0xfec2827d, 0x8001801f,
  0xfe742d6f, 0xfe7102cb, 0xfe6dd827, 0x5ddfa241,
  0xfe102dd3, 0xfe0c3663, 0xfe083ef3, 0x34ea319d,
  0xfd936c53, 0xfd8e7563, 0xfd897e73, 0x01d0cb1d,
  0xffc180fa, 0xffc100fd, 0xffc08100, 0xe666e686,
  0xff830177, 0xff82017b, 0xff81017f, 0xcccd99b9,
  0xff448177, 0xff43017b, 0xff41817f, 0xb33419b9,
  0xff0600fa, 0xff0400fd, 0xff020100, 0x999a6686,
  0xfeb2abf8, 0xfeb00151, 0xfead56aa, 0x777888a8,
  0xfe4eac5c, 0xfe4b34e9, 0xfe47bd76, 0x4e831804,
  0xfdd1eadc, 0xfdcd73e9, 0xfdc8fcf6, 0x1b69b184,
  0xfd5528df, 0xfd4fb26b, 0xfd4a3bf7, 0xe85017d1,
  0xffc1807d, 0xffc1007f, 0xffc08081, 0xe666b353,
  0xff83007d, 0xff82007f, 0xff810081, 0xcccd3353,
  0xff448000, 0xff430001, 0xff418002, 0xb3338020,
  0xfef12afe, 0xfeef0055, 0xfeecd5ac, 0x9111a242,
  0xfe8d2b62, 0xfe8a33ed, 0xfe873c78, 0x681c319e,
  0xfe1069e2, 0xfe0c72ed, 0xfe087bf8, 0x3502cb1e,
  0xfd93a7e5, 0xfd8eb16f, 0xfd89baf9, 0x01e9316b,
  0xfd16e56b, 0xfd10ef73, 0xfd0af97b, 0xcecf6485,
  0xffc18000, 0xffc10001, 0xffc08002, 0xe6668020,
  0xff82ff83, 0xff81ff83, 0xff80ff83, 0xcccccced,
  0xff2faa81, 0xff2dffd7, 0xff2c552d, 0xaaaaef0f,
  0xfecbaae5, 0xfec9336f, 0xfec6bbf9, 0x81b57e6b,
  0xfe4ee965, 0xfe4b726f, 0xfe47fb79, 0x4e9c17eb,
  0xfdd22768, 0xfdcdb0f1, 0xfdc93a7a, 0x1b827e38,
  0xfd5564ee, 0xfd4feef5, 0xfd4a78fc, 0xe868b152,
  0xfcd8a1f7, 0xfcd22c7b, 0xfccbb6ff, 0xb54eb139,
  0xffc17f83, 0xffc0ff83, 0xffc07f83, 0xe6664ced,
  0xff6e2a81, 0xff6cffd7, 0xff6bd52d, 0xc4446f0f,
  0xff0a2ae5, 0xff08336f, 0xff063bf9, 0x9b4efe6b,
  0xfe8d6965, 0xfe8a726f, 0xfe877b79, 0x683597eb,
  0xfe10a768, 0xfe0cb0f1, 0xfe08ba7a, 0x351bfe38,
  0xfd93e4ee, 0xfd8eeef5, 0xfd89f8fc, 0x02023152,
  0xfd1721f7, 0xfd112c7b, 0xfd0b36ff, 0xcee83139,
  0xfc9a29c7, 0xfc93345b, 0xfc8c3eef, 0x9bb86469,
  0xffacaafe, 0xffac0055, 0xffab55ac, 0xddde2242,
  0xff48ab62, 0xff4733ed, 0xff45bc78, 0xb4e8b19e,
  0xfecbe9e2, 0xfec972ed, 0xfec6fbf8, 0x81cf4b1e,
  0xfe4f27e5, 0xfe4bb16f, 0xfe483af9, 0x4eb5b16b,
  0xfdd2656b, 0xfdcdef73, 0xfdc9797b, 0x1b9be485,
  0xfd55a274, 0xfd502cf9, 0xfd4ab77e, 0xe881e46c,
  0xfcd8aa44, 0xfcd234d9, 0xfccbbf6e, 0xb552179c,
  0xfc5babbb, 0xfc543653, 0xfc4cc0eb, 0x821fb135,
  0xff9c0064, 0xff9b3399, 0xff9a66ce, 0xd70a8f7c,
  0xff1f3ee4, 0xff1d7299, 0xff1ba64e, 0xa3f128fc,
  0xfea27ce7, 0xfe9fb11b, 0xfe9ce54f, 0x70d78f49,
  0xfe25ba6d, 0xfe21ef1f, 0xfe1e23d1, 0x3dbdc263,
  0xfda8f776, 0xfda42ca5, 0xfd9f61d4, 0x0aa3c24a,
  0xfd2bff46, 0xfd263485, 0xfd2069c4, 0xd773f57a,
  0xfcaf00bd, 0xfca835ff, 0xfca16b41, 0xa4418f13,
  0xfc3201b7, 0xfc2a36fb, 0xfc226c3f, 0x710ef579,
  0xff833e80, 0xff823f01, 0xff813f82, 0xcce699a0,
  0xff067c83, 0xff047d83, 0xff027e83, 0x99ccffed,
  0xfe89ba09, 0xfe86bb87, 0xfe83bd05, 0x66b33307,
  0xfe0cf712, 0xfe08f90d, 0xfe04fb08, 0x339932ee,
  0xfd8ffee2, 0xfd8b00ed, 0xfd8602f8, 0x0069661e,
  0xfd130059, 0xfd0d0267, 0xfd070475, 0xcd36ffb7,
  0xfc960153, 0xfc8f0363, 0xfc880573, 0x9a04661d,
  0xfc1901d0, 0xfc1103e1, 0xfc0905f2, 0x66d19950,
  0xff823e82, 0xff813f02, 0xcce6664f, 0xaad5554b,
  0xff047c86, 0xff027d84, 0x99cc9969, 0x55aa5521,
  0xfe86ba0c, 0xfe83bb87, 0x66b29950, 0x007effa2,
  0xfe08c1ec, 0xfe04c377, 0x3382cc80, 0xab2f54f2,
  0xfd8ac366, 0xfd85c4f4, 0x00506619, 0x55db54f1,
  0xfd0cc462, 0xfd06c5f2, 0xcd1dcc7f, 0x0086ff9b,
  0xfc8ec4e0, 0xfc87c671, 0x99eaffb2, 0xab3254f0,
  0xfc8ec4e0, 0xfc87c671, 0x99eaffb2, 0xab3254f0,
  0xff823e04, 0xff813e83, 0xcce6331c, 0xaad4fff6,
  0xff047b8a, 0xff027c86, 0x99cc3303, 0x55a9aa77,
  0xfe86836a, 0xfe838476, 0x669c6633, 0x0059ffc7,
  0xfe0884e4, 0xfe0485f3, 0x3369ffcc, 0xab05ffc6,
  0xfd8a85e0, 0xfd8586f1, 0x00376632, 0x55b1aa70,
  0xfd0c865e, 0xfd068770, 0xcd049965, 0x005cffc5,
  0xfd0c865e, 0xfd068770, 0xcd049965, 0x005cffc5,
  0xfd0c85e0, 0xfd0686f1, 0xcd046632, 0x005caa70,
  0xff823d86, 0xff813e04, 0xcce5ffe9, 0xaad4aaa1,
  0xff044566, 0xff0245f4, 0x99b63319, 0x5584fff1,
  0xfe8646e0, 0xfe834771, 0x6683ccb2, 0x0030fff0,
  0xfe0847dc, 0xfe04486f, 0x33513318, 0xaadcaa9a,
  0xfd8a485a, 0xfd8548ee, 0x001e664b, 0x5587ffef,
  0xfd8a485a, 0xfd8548ee, 0x001e664b, 0x5587ffef,
  0xfd8a47dc, 0xfd85486f, 0x001e3318, 0x5587aa9a,
  0xfd8a46e0, 0xfd854771, 0x001dccb2, 0x5586fff0,
  0xff8207e0, 0xff8107f1, 0xccd03332, 0xaab05570,
  0xff04095a, 0xff02096e, 0x999dcccb, 0x555c556f,
  0xfe860a56, 0xfe830a6c, 0x666b3331, 0x00080019,
  0xfe080ad4, 0xfe040aeb, 0x33386664, 0xaab3556e,
  0xfe080ad4, 0xfe040aeb, 0x33386664, 0xaab3556e,
  0xfe080a56, 0xfe040a6c, 0x33383331, 0xaab30019,
  0xfe08095a, 0xfe04096e, 0x3337cccb, 0xaab2556f,
  0xfe08017a, 0xfe04017e, 0x3334999b, 0xaaad001f,
  0xff82017a, 0xff81017e, 0xcccd999b, 0xaaac001f,
  0xff040276, 0xff02027c, 0x999b0001, 0x5557aac9,
  0xfe8602f4, 0xfe8302fb, 0x66683334, 0x0003001e,
  0xfe8602f4, 0xfe8302fb, 0x66683334, 0x0003001e,
  0xfe860276, 0xfe83027c, 0x66680001, 0x0002aac9,
  0xfe86017a, 0xfe83017e, 0x6667999b, 0x0002001f,
  0xfe85f99a, 0xfe82f98e, 0x6664666b, 0xfffcaacf,
  0xfe85bc14, 0xfe82bb8b, 0x664b6684, 0xffd3004e,
  0xff8200fc, 0xff8100ff, 0xcccd6668, 0xaaabaaca,
  0xff04017a, 0xff02017e, 0x999a999b, 0x5557001f,
  0xff04017a, 0xff02017e, 0x999a999b, 0x5557001f,
  0xff0400fc, 0xff0200ff, 0x999a6668, 0x5556aaca,
  0xff040000, 0xff020001, 0x999a0002, 0x55560020,
  0xff03f820, 0xff01f811, 0x9996ccd2, 0x5550aad0,
  0xff03ba9a, 0xff01ba0e, 0x997dcceb, 0x5527004f,
  0xff037c96, 0xff017b8c, 0x996499d1, 0x54fd0079,
  0xff82007e, 0xff810080, 0xcccd3335, 0xaaab5575,
  0xff82007e, 0xff810080, 0xcccd3335, 0xaaab5575,
  0xff820000, 0xff810001, 0xcccd0002, 0xaaab0020,
  0xff81ff04, 0xff80ff03, 0xcccc999c, 0xaaaa5576,
  0xff81f724, 0xff80f713, 0xccc9666c, 0xaaa50026,
  0xff81b99e, 0xff80b910, 0xccb06685, 0xaa7b55a5,
  0xff817b9a, 0xff807a8e, 0xcc97336b, 0xaa5155cf,
  0xff813d18, 0xff803b8d, 0xcc7dcd1e, 0xaa2700a4,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffff82, 0xffffff82, 0xffffcccf, 0xffffaacb,
  0xfffffe86, 0xfffffe84, 0xffff6669, 0xffff0021,
  0xfffff6a6, 0xfffff694, 0xfffc3339, 0xfff9aad1,
  0xffffb920, 0xffffb891, 0xffe33352, 0xffd00050,
  0xffff7b1c, 0xffff7a0f, 0xffca0038, 0xffa6007a,
  0xffff3c9a, 0xffff3b0e, 0xffb099eb, 0xff7bab4f,
  0xffe60980, 0xffe5d4c1, 0xf5733dc2, 0xee6abc60,
  0xffffff82, 0xffffff82, 0xffffcccf, 0xffffaacb,
  0xfffffe86, 0xfffffe84, 0xffff6669, 0xffff0021,
  0xfffff6a6, 0xfffff694, 0xfffc3339, 0xfff9aad1,
  0xffffb920, 0xffffb891, 0xffe33352, 0xffd00050,
  0xffff7b1c, 0xffff7a0f, 0xffca0038, 0xffa6007a,
  0xffff3c9a, 0xffff3b0e, 0xffb099eb, 0xff7bab4f,
  0xffe60980, 0xffe5d4c1, 0xf5733dc2, 0xee6abc60,
  0xffbc09aa, 0xffbb7f96, 0xe4624ed3, 0xd1f92e27,
  0xffffff04, 0xffffff03, 0xffff999c, 0xffff5576,
  0xfffff724, 0xfffff713, 0xfffc666c, 0xfffa0026,
  0xffffb99e, 0xffffb910, 0xffe36685, 0xffd055a5,
  0xffff7b9a, 0xffff7a8e, 0xffca336b, 0xffa655cf,
  0xffff3d18, 0xffff3b8d, 0xffb0cd1e, 0xff7c00a4,
  0xffe609fe, 0xffe5d540, 0xf57370f5, 0xee6b11b5,
  0xffbc0a28, 0xffbb8015, 0xe4628206, 0xd1f9837c,
  0xff7d0ba2, 0xff7c0192, 0xcac99b9f, 0xa750037b,
  0xfffff820, 0xfffff811, 0xfffcccd2, 0xfffaaad0,
  0xffffba9a, 0xffffba0e, 0xffe3cceb, 0xffd1004f,
  0xffff7c96, 0xffff7b8c, 0xffca99d1, 0xffa70079,
  0xffff3e14, 0xffff3c8b, 0xffb13384, 0xff7cab4e,
  0xffe60afa, 0xffe5d63e, 0xf573d75b, 0xee6bbc5f,
  0xffbc0b24, 0xffbb8113, 0xe462e86c, 0xd1fa2e26,
  0xff7d0c9e, 0xff7c0290, 0xcaca0205, 0xa750ae25,
  0xff3e0d9a, 0xff3c838e, 0xb130e86b, 0x7ca6d8cf,
  0xffffc27a, 0xffffc1fe, 0xffe7001b, 0xffd6559f,
  0xffff8476, 0xffff837c, 0xffcdcd01, 0xffac55c9,
  0xffff45f4, 0xffff447b, 0xffb466b4, 0xff82009e,
  0xffe612da, 0xffe5de2e, 0xf5770a8b, 0xee7111af,
  0xffbc1304, 0xffbb8903, 0xe4661b9c, 0xd1ff8376,
  0xff7d147e, 0xff7c0a80, 0xcacd3535, 0xa7560375,
  0xff3e157a, 0xff3c8b7e, 0xb1341b9b, 0x7cac2e1f,
  0xfeff15f8, 0xfefd0bfd, 0x979acece, 0x52020374,
  0xffffc1fc, 0xffffc17f, 0xffe6cce8, 0xffd6004a,
  0xffff837a, 0xffff827e, 0xffcd669b, 0xffabab1f,
  0xffe65060, 0xffe61c31, 0xf5900a72, 0xee9abc30,
  0xffbc508a, 0xffbbc706, 0xe47f1b83, 0xd2292df7,
  0xff7d5204, 0xff7c4883, 0xcae6351c, 0xa77fadf6,
  0xff3e5300, 0xff3cc981, 0xb14d1b82, 0x7cd5d8a0,
  0xfeff537e, 0xfefd4a00, 0x97b3ceb5, 0x522badf5,
  0xfec0537e, 0xfebdca00, 0x7e1a4eb5, 0x27812df5,
  0xffffc17e, 0xffffc100, 0xffe699b5, 0xffd5aaf5,
  0xffe68e64, 0xffe65ab3, 0xf5a93d8c, 0xeec4bc06,
  0xffbc8e8e, 0xffbc0588, 0xe4984e9d, 0xd2532dcd,
  0xff7d9008, 0xff7c8705, 0xcaff6836, 0xa7a9adcc,
  0xff3e9104, 0xff3d0803, 0xb1664e9c, 0x7cffd876,
  0xfeff9182, 0xfefd8882, 0x97cd01cf, 0x5255adcb,
  0xfec09182, 0xfebe0882, 0x7e3381cf, 0x27ab2dcb,
  0xfe819104, 0xfe7e8803, 0x6499ce9c, 0xfd005876,
  0xffe6cce6, 0xffe699b4, 0xf5c2a3d9, 0xeeef1131,
  0xffbccd10, 0xffbc4489, 0xe4b1b4ea, 0xd27d82f8,
  0xff7dce8a, 0xff7cc606, 0xcb18ce83, 0xa7d402f7,
  0xff3ecf86, 0xff3d4704, 0xb17fb4e9, 0x7d2a2da1,
  0xfeffd004, 0xfefdc783, 0x97e6681c, 0x528002f6,
  0xfec0d004, 0xfebe4783, 0x7e4ce81c, 0x27d582f6,
  0xfe81cf86, 0xfe7ec704, 0x64b334e9, 0xfd2aada1,
  0xfe2dcfda, 0xfe2a1cae, 0x4291570b, 0xc447912f,
  0xffd6002a, 0xffd5aad6, 0xeeef1113, 0xe38e71e7,
  0xff9701a4, 0xff962c53, 0xd5562aac, 0xb8e4f1e6,
  0xff5802a0, 0xff56ad51, 0xbbbd1112, 0x8e3b1c90,
  0xff19031e, 0xff172dd0, 0xa223c445, 0x6390f1e5,
  0xfeda031e, 0xfed7add0, 0x888a4445, 0x38e671e5,
  0xfe9b02a0, 0xfe982d51, 0x6ef09112, 0x0e3b9c90,
  0xfe4702f4, 0xfe4382fb, 0x4cceb334, 0xd558801e,
  0xfde2368c, 0xfddde9c7, 0x23d94290, 0x9114c462,
  0xffc1017a, 0xffc0817e, 0xe667199b, 0xd556801f,
  0xff820276, 0xff81027c, 0xccce0001, 0xaaacaac9,
  0xff4302f4, 0xff4182fb, 0xb334b334, 0x8002801e,
  0xff0402f4, 0xff0202fb, 0x999b3334, 0x5558001e,
  0xfec50276, 0xfec2827c, 0x80018001, 0x2aad2ac9,
  0xfe7102ca, 0xfe6dd826, 0x5ddfa223, 0xf1ca0e57,
  0xfe0c3662, 0xfe083ef2, 0x34ea317f, 0xad86529b,
  0xfd8e7562, 0xfd897e72, 0x01d0caff, 0x585bfd1b,
  0xffc100fc, 0xffc080ff, 0xe666e668, 0xd5562aca,
  0xff82017a, 0xff81017e, 0xcccd999b, 0xaaac001f,
  0xff43017a, 0xff41817e, 0xb334199b, 0x8001801f,
  0xff0400fc, 0xff0200ff, 0x999a6668, 0x5556aaca,
  0xfeb00150, 0xfead56a9, 0x7778888a, 0x1c738e58,
  0xfe4b34e8, 0xfe47bd75, 0x4e8317e6, 0xd82fd29c,
  0xfdcd73e8, 0xfdc8fcf5, 0x1b69b166, 0x83057d1c,
  0xfd4fb26a, 0xfd4a3bf6, 0xe85017b3, 0x2ddad247,
  0xffc1007e, 0xffc08080, 0xe666b335, 0xd555d575,
  0xff82007e, 0xff810080, 0xcccd3335, 0xaaab5575,
  0xff430000, 0xff418001, 0xb3338002, 0x80008020,
  0xfeef0054, 0xfeecd5ab, 0x9111a224, 0x471d63ae,
  0xfe8a33ec, 0xfe873c77, 0x681c3180, 0x02d9a7f2,
  0xfe0c72ec, 0xfe087bf7, 0x3502cb00, 0xadaf5272,
  0xfd8eb16e, 0xfd89baf8, 0x01e9314d, 0x5884a79d,
  0xfd10ef72, 0xfd0af97a, 0xcecf6467, 0x0359a773,
  0xffc10000, 0xffc08001, 0xe6668002, 0xd5558020,
  0xff81ff82, 0xff80ff82, 0xcccccccf, 0xaaaaaacb,
  0xff2dffd6, 0xff2c552c, 0xaaaaeef1, 0x71c78e59,
  0xfec9336e, 0xfec6bbf8, 0x81b57e4d, 0x2d83d29d,
  0xfe4b726e, 0xfe47fb78, 0x4e9c17cd, 0xd8597d1d,
  0xfdcdb0f0, 0xfdc93a79, 0x1b827e1a, 0x832ed248,
  0xfd4feef4, 0xfd4a78fb, 0xe868b134, 0x2e03d21e,
  0xfcd22c7a, 0xfccbb6fe, 0xb54eb11b, 0xd8d87c9f,
  0xffc0ff82, 0xffc07f82, 0xe6664ccf, 0xd5552acb,
  0xff6cffd6, 0xff6bd52c, 0xc4446ef1, 0x9c720e59,
  0xff08336e, 0xff063bf8, 0x9b4efe4d, 0x582e529d,
  0xfe8a726e, 0xfe877b78, 0x683597cd, 0x0303fd1d,
  0xfe0cb0f0, 0xfe08ba79, 0x351bfe1a, 0xadd95248,
  0xfd8eeef4, 0xfd89f8fb, 0x02023134, 0x58ae521e,
  0xfd112c7a, 0xfd0b36fe, 0xcee8311b, 0x0382fc9f,
  0xfc93345a, 0xfc8c3eee, 0x9bb8644b, 0xae3351ef,
  0xffac0054, 0xffab55ab, 0xddde2224, 0xc71ce3ae,
  0xff4733ec, 0xff45bc77, 0xb4e8b180, 0x82d927f2,
  0xfec972ec, 0xfec6fbf7, 0x81cf4b00, 0x2daed272,
  0xfe4bb16e, 0xfe483af8, 0x4eb5b14d, 0xd884279d,
  0xfdcdef72, 0xfdc9797a, 0x1b9be467, 0x83592773,
  0xfd502cf8, 0xfd4ab77d, 0xe881e44e, 0x2e2dd1f4,
  0xfcd234d8, 0xfccbbf6d, 0xb552177e, 0xd8de2744,
  0xfc543652, 0xfc4cc0ea, 0x821fb117, 0x838a2743,
  0xff9b3398, 0xff9a66cd, 0xd70a8f5e, 0xbbbc4464,
  0xff1d7298, 0xff1ba64d, 0xa3f128de, 0x6691eee4,
  0xfe9fb11a, 0xfe9ce54e, 0x70d78f2b, 0x1167440f,
  0xfe21ef1e, 0xfe1e23d0, 0x3dbdc245, 0xbc3c43e5,
  0xfda42ca4, 0xfd9f61d3, 0x0aa3c22c, 0x6710ee66,
  0xfd263484, 0xfd2069c3, 0xd773f55c, 0x11c143b6,
  0xfca835fe, 0xfca16b40, 0xa4418ef5, 0xbc6d43b5,
  0xfc2a36fa, 0xfc226c3e, 0x710ef55b, 0x6718ee5f,
  0xff823f00, 0xff813f81, 0xcce69982, 0xaad5aaa0,
  0xff047d82, 0xff027e82, 0x99ccffcf, 0x55aaffcb,
  0xfe86bb86, 0xfe83bd04, 0x66b332e9, 0x007fffa1,
  0xfe08f90c, 0xfe04fb07, 0x339932d0, 0xab54aa22,
  0xfd8b00ec, 0xfd8602f7, 0x00696600, 0x5604ff72,
  0xfd0d0266, 0xfd070474, 0xcd36ff99, 0x00b0ff71,
  0xfc8f0362, 0xfc880572, 0x9a0465ff, 0xab5caa1b,
  0xfc1103e0, 0xfc0905f1, 0x66d19932, 0x5607ff70,
  0xff813f01, 0xcce6664e, 0xaad5552d, 0x80427ea3,
  0xff027d83, 0x99cc9968, 0x55aa5503, 0x00847d29,
  0xfe83bb86, 0x66b2994f, 0x007eff84, 0x80c5fbb2,
  0xfe04c376, 0x3382cc7f, 0xab2f54d4, 0x00d0fb82,
  0xfd85c4f3, 0x00506618, 0x55db54d3, 0x80d57b79,
  0xfd06c5f1, 0xcd1dcc7e, 0x0086ff7d, 0x00d97b73,
  0xfc87c670, 0x99eaffb1, 0xab3254d2, 0x80dcfb70,
  0xfc87c670, 0x99eaffb1, 0xab3254d2, 0x80dcfb70,
  0xff813e82, 0xcce6331b, 0xaad4ffd8, 0x8041fea6,
  0xff027c85, 0x99cc3302, 0x55a9aa59, 0x00837d2f,
  0xfe838475, 0x669c6632, 0x0059ffa9, 0x808e7cff,
  0xfe0485f2, 0x3369ffcb, 0xab05ffa8, 0x0092fcf6,
  0xfd8586f0, 0x00376631, 0x55b1aa52, 0x8096fcf0,
  0xfd06876f, 0xcd049964, 0x005cffa7, 0x009a7ced,
  0xfd06876f, 0xcd049964, 0x005cffa7, 0x009a7ced,
  0xfd0686f0, 0xcd046631, 0x005caa52, 0x0099fcf0,
  0xff813e03, 0xcce5ffe8, 0xaad4aa83, 0x80417ea9,
  0xff0245f3, 0x99b63318, 0x5584ffd3, 0x004c7e79,
  0xfe834770, 0x6683ccb1, 0x0030ffd2, 0x8050fe70,
  0xfe04486e, 0x33513317, 0xaadcaa7c, 0x0054fe6a,
  0xfd8548ed, 0x001e664a, 0x5587ffd1, 0x80587e67,
  0xfd8548ed, 0x001e664a, 0x5587ffd1, 0x80587e67,
  0xfd85486e, 0x001e3317, 0x5587aa7c, 0x8057fe6a,
  0xfd854770, 0x001dccb1, 0x5586ffd2, 0x8056fe70,
  0xff8107f0, 0xccd03331, 0xaab05552, 0x800afff0,
  0xff02096d, 0x999dccca, 0x555c5551, 0x000f7fe7,
  0xfe830a6b, 0x666b3330, 0x0007fffb, 0x80137fe1,
  0xfe040aea, 0x33386663, 0xaab35550, 0x0016ffde,
  0xfe040aea, 0x33386663, 0xaab35550, 0x0016ffde,
  0xfe040a6b, 0x33383330, 0xaab2fffb, 0x00167fe1,
  0xfe04096d, 0x3337ccca, 0xaab25551, 0x00157fe7,
  0xfe04017d, 0x3334999a, 0xaaad0001, 0x000d8017,
  0xff81017d, 0xcccd999a, 0xaaac0001, 0x80048017,
  0xff02027b, 0x999b0000, 0x5557aaab, 0x00088011,
  0xfe8302fa, 0x66683333, 0x00030000, 0x800c000e,
  0xfe8302fa, 0x66683333, 0x00030000, 0x800c000e,
  0xfe83027b, 0x66680000, 0x0002aaab, 0x800b8011,
  0xfe83017d, 0x6667999a, 0x00020001, 0x800a8017,
  0xfe82f98d, 0x6664666a, 0xfffcaab1, 0x80028047,
  0xfe82bb8a, 0x664b6683, 0xffd30030, 0x7fc401be,
  0xff8100fe, 0xcccd6667, 0xaaabaaac, 0x8004001a,
  0xff02017d, 0x999a999a, 0x55570001, 0x00078017,
  0xff02017d, 0x999a999a, 0x55570001, 0x00078017,
  0xff0200fe, 0x999a6667, 0x5556aaac, 0x0007001a,
  0xff020000, 0x999a0001, 0x55560002, 0x00060020,
  0xff01f810, 0x9996ccd1, 0x5550aab2, 0xfffe0050,
  0xff01ba0d, 0x997dccea, 0x55270031, 0xffbf81c7,
  0xff017b8b, 0x996499d0, 0x54fd005b, 0xff808341,
  0xff81007f, 0xcccd3334, 0xaaab5557, 0x8003801d,
  0xff81007f, 0xcccd3334, 0xaaab5557, 0x8003801d,
  0xff810000, 0xcccd0001, 0xaaab0002, 0x80030020,
  0xff80ff02, 0xcccc999b, 0xaaaa5558, 0x80020026,
  0xff80f712, 0xccc9666b, 0xaaa50008, 0x7ffa0056,
  0xff80b90f, 0xccb06684, 0xaa7b5587, 0x7fbb81cd,
  0xff807a8d, 0xcc97336a, 0xaa5155b1, 0x7f7c8347,
  0xff803b8c, 0xcc7dcd1d, 0xaa270086, 0x7f3d04c4,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffff81, 0xffffccce, 0xffffaaad, 0xffff8023,
  0xfffffe83, 0xffff6668, 0xffff0003, 0xfffe8029,
  0xfffff693, 0xfffc3338, 0xfff9aab3, 0xfff68059,
  0xffffb890, 0xffe33351, 0xffd00032, 0xffb801d0,
  0xffff7a0e, 0xffca0037, 0xffa6005c, 0xff79034a,
  0xffff3b0d, 0xffb099ea, 0xff7bab31, 0xff3984c7,
  0xffe5d4c0, 0xf5733dc1, 0xee6abc42, 0xe5a09e60,
  0xffffff81, 0xffffccce, 0xffffaaad, 0xffff8023,
  0xfffffe83, 0xffff6668, 0xffff0003, 0xfffe8029,
  0xfffff693, 0xfffc3338, 0xfff9aab3, 0xfff68059,
  0xffffb890, 0xffe33351, 0xffd00032, 0xffb801d0,
  0xffff7a0e, 0xffca0037, 0xffa6005c, 0xff79034a,
  0xffff3b0d, 0xffb099ea, 0xff7bab31, 0xff3984c7,
  0xffe5d4c0, 0xf5733dc1, 0xee6abc42, 0xe5a09e60,
  0xffbb7f95, 0xe4624ed2, 0xd1f92e09, 0xbaf71e5f,
  0xffffff02, 0xffff999b, 0xffff5558, 0xffff0026,
  0xfffff712, 0xfffc666b, 0xfffa0008, 0xfff70056,
  0xffffb90f, 0xffe36684, 0xffd05587, 0xffb881cd,
  0xffff7a8d, 0xffca336a, 0xffa655b1, 0xff798347,
  0xffff3b8c, 0xffb0cd1d, 0xff7c0086, 0xff3a04c4,
  0xffe5d53f, 0xf57370f4, 0xee6b1197, 0xe5a11e5d,
  0xffbb8014, 0xe4628205, 0xd1f9835e, 0xbaf79e5c,
  0xff7c0191, 0xcac99b9e, 0xa750035d, 0x7afa9e53,
  0xfffff810, 0xfffcccd1, 0xfffaaab2, 0xfff80050,
  0xffffba0d, 0xffe3ccea, 0xffd10031, 0xffb981c7,
  0xffff7b8b, 0xffca99d0, 0xffa7005b, 0xff7a8341,
  0xffff3c8a, 0xffb13383, 0xff7cab30, 0xff3b04be,
  0xffe5d63d, 0xf573d75a, 0xee6bbc41, 0xe5a21e57,
  0xffbb8112, 0xe462e86b, 0xd1fa2e08, 0xbaf89e56,
  0xff7c028f, 0xcaca0204, 0xa750ae07, 0x7afb9e4d,
  0xff3c838d, 0xb130e86a, 0x7ca6d8b1, 0x3afe1e47,
  0xffffc1fd, 0xffe7001a, 0xffd65581, 0xffc18197,
  0xffff837b, 0xffcdcd00, 0xffac55ab, 0xff828311,
  0xffff447a, 0xffb466b3, 0xff820080, 0xff43048e,
  0xffe5de2d, 0xf5770a8a, 0xee711191, 0xe5aa1e27,
  0xffbb8902, 0xe4661b9b, 0xd1ff8358, 0xbb009e26,
  0xff7c0a7f, 0xcacd3534, 0xa7560357, 0x7b039e1d,
  0xff3c8b7d, 0xb1341b9a, 0x7cac2e01, 0x3b061e17,
  0xfefd0bfc, 0x979acecd, 0x52020356, 0xfb081e14,
  0xffffc17e, 0xffe6cce7, 0xffd6002c, 0xffc1019a,
  0xffff827d, 0xffcd669a, 0xffabab01, 0xff818317,
  0xffe61c30, 0xf5900a71, 0xee9abc12, 0xe5e89cb0,
  0xffbbc705, 0xe47f1b82, 0xd2292dd9, 0xbb3f1caf,
  0xff7c4882, 0xcae6351b, 0xa77fadd8, 0x7b421ca6,
  0xff3cc980, 0xb14d1b81, 0x7cd5d882, 0x3b449ca0,
  0xfefd49ff, 0x97b3ceb4, 0x522badd7, 0xfb469c9d,
  0xfebdc9ff, 0x7e1a4eb4, 0x27812dd7, 0xbb481c9d,
  0xffffc0ff, 0xffe699b4, 0xffd5aad7, 0xffc0819d,
  0xffe65ab2, 0xf5a93d8b, 0xeec4bbe8, 0xe6279b36,
  0xffbc0587, 0xe4984e9c, 0xd2532daf, 0xbb7e1b35,
  0xff7c8704, 0xcaff6835, 0xa7a9adae, 0x7b811b2c,
  0xff3d0802, 0xb1664e9b, 0x7cffd858, 0x3b839b26,
  0xfefd8881, 0x97cd01ce, 0x5255adad, 0xfb859b23,
  0xfebe0881, 0x7e3381ce, 0x27ab2dad, 0xbb871b23,
  0xfe7e8802, 0x6499ce9b, 0xfd005858, 0x7b881b26,
  0xffe699b3, 0xf5c2a3d8, 0xeeef1113, 0xe66719b9,
  0xffbc4488, 0xe4b1b4e9, 0xd27d82da, 0xbbbd99b8,
  0xff7cc605, 0xcb18ce82, 0xa7d402d9, 0x7bc099af,
  0xff3d4703, 0xb17fb4e8, 0x7d2a2d83, 0x3bc319a9,
  0xfefdc782, 0x97e6681b, 0x528002d8, 0xfbc519a6,
  0xfebe4782, 0x7e4ce81b, 0x27d582d8, 0xbbc699a6,
  0xfe7ec703, 0x64b334e8, 0xfd2aad83, 0x7bc799a9,
  0xfe2a1cad, 0x4291570a, 0xc4479111, 0x267499a7,
  0xffd5aad5, 0xeeef1112, 0xe38e71c9, 0xd556801f,
  0xff962c52, 0xd5562aab, 0xb8e4f1c8, 0x95598016,
  0xff56ad50, 0xbbbd1111, 0x8e3b1c72, 0x555c0010,
  0xff172dcf, 0xa223c444, 0x6390f1c7, 0x155e000d,
  0xfed7adcf, 0x888a4444, 0x38e671c7, 0xd55f800d,
  0xfe982d50, 0x6ef09111, 0x0e3b9c72, 0x95608010,
  0xfe4382fa, 0x4cceb333, 0xd5588000, 0x400d800e,
  0xfddde9c6, 0x23d9428f, 0x9114c444, 0xd9a9e672,
  0xffc0817d, 0xe667199a, 0xd5568001, 0xc0030017,
  0xff81027b, 0xccce0000, 0xaaacaaab, 0x80058011,
  0xff4182fa, 0xb334b333, 0x80028000, 0x4007800e,
  0xff0202fa, 0x999b3333, 0x55580000, 0x0009000e,
  0xfec2827b, 0x80018000, 0x2aad2aab, 0xc00a0011,
  0xfe6dd825, 0x5ddfa222, 0xf1ca0e39, 0x6ab7000f,
  0xfe083ef1, 0x34ea317e, 0xad86527d, 0x04536673,
  0xfd897e71, 0x01d0cafe, 0x585bfcfd, 0x849664f3,
  0xffc080fe, 0xe666e667, 0xd5562aac, 0xc002801a,
  0xff81017d, 0xcccd999a, 0xaaac0001, 0x80048017,
  0xff41817d, 0xb334199a, 0x80018001, 0x40060017,
  0xff0200fe, 0x999a6667, 0x5556aaac, 0x0007001a,
  0xfead56a8, 0x77788889, 0x1c738e3a, 0xaab40018,
  0xfe47bd74, 0x4e8317e5, 0xd82fd27e, 0x4450667c,
  0xfdc8fcf4, 0x1b69b165, 0x83057cfe, 0xc49364fc,
  0xfd4a3bf5, 0xe85017b2, 0x2ddad229, 0x44d5e37f,
  0xffc0807f, 0xe666b334, 0xd555d557, 0xc002001d,
  0xff81007f, 0xcccd3334, 0xaaab5557, 0x8003801d,
  0xff418000, 0xb3338001, 0x80008002, 0x40048020,
  0xfeecd5aa, 0x9111a223, 0x471d6390, 0xeab1801e,
  0xfe873c76, 0x681c317f, 0x02d9a7d4, 0x844de682,
  0xfe087bf6, 0x3502caff, 0xadaf5254, 0x0490e502,
  0xfd89baf7, 0x01e9314c, 0x5884a77f, 0x84d36385,
  0xfd0af979, 0xcecf6466, 0x0359a755, 0x0515620b,
  0xffc08000, 0xe6668001, 0xd5558002, 0xc0018020,
  0xff80ff81, 0xccccccce, 0xaaaaaaad, 0x80028023,
  0xff2c552b, 0xaaaaeef0, 0x71c78e3b, 0x2aaf8021,
  0xfec6bbf7, 0x81b57e4c, 0x2d83d27f, 0xc44be685,
  0xfe47fb77, 0x4e9c17cc, 0xd8597cff, 0x448ee505,
  0xfdc93a78, 0x1b827e19, 0x832ed22a, 0xc4d16388,
  0xfd4a78fa, 0xe868b133, 0x2e03d200, 0x4513620e,
  0xfccbb6fd, 0xb54eb11a, 0xd8d87c81, 0xc554e097,
  0xffc07f81, 0xe6664cce, 0xd5552aad, 0xc0010023,
  0xff6bd52b, 0xc4446ef0, 0x9c720e3b, 0x6aae0021,
  0xff063bf7, 0x9b4efe4c, 0x582e527f, 0x044a6685,
  0xfe877b77, 0x683597cc, 0x0303fcff, 0x848d6505,
  0xfe08ba78, 0x351bfe19, 0xadd9522a, 0x04cfe388,
  0xfd89f8fa, 0x02023133, 0x58ae5200, 0x8511e20e,
  0xfd0b36fd, 0xcee8311a, 0x0382fc81, 0x05536097,
  0xfc8c3eed, 0x9bb8644a, 0xae3351d1, 0x855e6067,
  0xffab55aa, 0xddde2223, 0xc71ce390, 0xaaad001e,
  0xff45bc76, 0xb4e8b17f, 0x82d927d4, 0x44496682,
  0xfec6fbf6, 0x81cf4aff, 0x2daed254, 0xc48c6502,
  0xfe483af7, 0x4eb5b14c, 0xd884277f, 0x44cee385,
  0xfdc97979, 0x1b9be466, 0x83592755, 0xc510e20b,
  0xfd4ab77c, 0xe881e44d, 0x2e2dd1d6, 0x45526094,
  0xfccbbf6c, 0xb552177d, 0xd8de2726, 0xc55d6064,
  0xfc4cc0e9, 0x821fb116, 0x838a2725, 0x4561e05b,
  0xff9a66cc, 0xd70a8f5d, 0xbbbc4446, 0x999c6684,
  0xff1ba64c, 0xa3f128dd, 0x6691eec6, 0x19df6504,
  0xfe9ce54d, 0x70d78f2a, 0x116743f1, 0x9a21e387,
  0xfe1e23cf, 0x3dbdc244, 0xbc3c43c7, 0x1a63e20d,
  0xfd9f61d2, 0x0aa3c22b, 0x6710ee48, 0x9aa56096,
  0xfd2069c2, 0xd773f55b, 0x11c14398, 0x1ab06066,
  0xfca16b3f, 0xa4418ef4, 0xbc6d4397, 0x9ab4e05d,
  0xfc226c3d, 0x710ef55a, 0x6718ee41, 0x1ab8e057,
  0xff813f80, 0xcce69981, 0xaad5aa82, 0x8042fea0,
  0xff027e81, 0x99ccffce, 0x55aaffad, 0x00857d23,
  0xfe83bd03, 0x66b332e8, 0x007fff83, 0x80c77ba9,
  0xfe04fb06, 0x339932cf, 0xab54aa04, 0x0108fa32,
  0xfd8602f6, 0x006965ff, 0x5604ff54, 0x8113fa02,
  0xfd070473, 0xcd36ff98, 0x00b0ff53, 0x011879f9,
  0xfc880571, 0x9a0465fe, 0xab5ca9fd, 0x811c79f3,
  0xfc0905f0, 0x66d19931, 0x5607ff52, 0x011ff9f0,
  0xcce6664d, 0xaad5552c, 0x80427e85, 0x80417f22,
  0x99cc9967, 0x55aa5502, 0x00847d0b, 0x00827e26,
  0x66b2994e, 0x007eff83, 0x80c5fb94, 0x80c2fd2c,
  0x3382cc7e, 0xab2f54d3, 0x00d0fb64, 0x00ccfd0c,
  0x00506617, 0x55db54d2, 0x80d57b5b, 0x80d07d06,
  0xcd1dcc7d, 0x0086ff7c, 0x00d97b55, 0x00d37d02,
  0x99eaffb0, 0xab3254d1, 0x80dcfb52, 0x80d5fd00,
  0x99eaffb0, 0xab3254d1, 0x80dcfb52, 0x80d5fd00,
  0xcce6331a, 0xaad4ffd7, 0x8041fe88, 0x8040ff24,
  0x99cc3301, 0x55a9aa58, 0x00837d11, 0x00817e2a,
  0x669c6631, 0x0059ffa8, 0x808e7ce1, 0x808b7e0a,
  0x3369ffca, 0xab05ffa7, 0x0092fcd8, 0x008efe04,
  0x00376630, 0x55b1aa51, 0x8096fcd2, 0x8091fe00,
  0xcd049963, 0x005cffa6, 0x009a7ccf, 0x00947dfe,
  0xcd049963, 0x005cffa6, 0x009a7ccf, 0x00947dfe,
  0xcd046630, 0x005caa51, 0x0099fcd2, 0x0093fe00,
  0xcce5ffe7, 0xaad4aa82, 0x80417e8b, 0x80407f26,
  0x99b63317, 0x5584ffd2, 0x004c7e5b, 0x004a7f06,
  0x6683ccb0, 0x0030ffd1, 0x8050fe52, 0x804dff00,
  0x33513316, 0xaadcaa7b, 0x0054fe4c, 0x0050fefc,
  0x001e6649, 0x5587ffd0, 0x80587e49, 0x80537efa,
  0x001e6649, 0x5587ffd0, 0x80587e49, 0x80537efa,
  0x001e3316, 0x5587aa7b, 0x8057fe4c, 0x8052fefc,
  0x001dccb0, 0x5586ffd1, 0x8056fe52, 0x8051ff00,
  0xccd03330, 0xaab05551, 0x800affd2, 0x800a0000,
  0x999dccc9, 0x555c5550, 0x000f7fc9, 0x000d7ffa,
  0x666b332f, 0x0007fffa, 0x80137fc3, 0x80107ff6,
  0x33386662, 0xaab3554f, 0x0016ffc0, 0x0012fff4,
  0x33386662, 0xaab3554f, 0x0016ffc0, 0x0012fff4,
  0x3338332f, 0xaab2fffa, 0x00167fc3, 0x00127ff6,
  0x3337ccc9, 0xaab25550, 0x00157fc9, 0x00117ffa,
  0x33349999, 0xaaad0000, 0x000d7ff9, 0x0009801a,
  0xcccd9999, 0xaaac0000, 0x80047ff9, 0x8003801a,
  0x999affff, 0x5557aaaa, 0x00087ff3, 0x00068016,
  0x66683332, 0x0002ffff, 0x800bfff0, 0x80090014,
  0x66683332, 0x0002ffff, 0x800bfff0, 0x80090014,
  0x6667ffff, 0x0002aaaa, 0x800b7ff3, 0x80088016,
  0x66679999, 0x00020000, 0x800a7ff9, 0x8007801a,
  0x66646669, 0xfffcaab0, 0x80028029, 0x7fff803a,
  0x664b6682, 0xffd3002f, 0x7fc401a0, 0x7fc10134,
  0xcccd6666, 0xaaabaaab, 0x8003fffc, 0x8003001c,
  0x999a9999, 0x55570000, 0x00077ff9, 0x0005801a,
  0x999a9999, 0x55570000, 0x00077ff9, 0x0005801a,
  0x999a6666, 0x5556aaab, 0x0006fffc, 0x0005001c,
  0x999a0000, 0x55560001, 0x00060002, 0x00040020,
  0x9996ccd0, 0x5550aab1, 0xfffe0032, 0xfffc0040,
  0x997dcce9, 0x55270030, 0xffbf81a9, 0xffbd813a,
  0x996499cf, 0x54fd005a, 0xff808323, 0xff7e8236,
  0xcccd3333, 0xaaab5556, 0x80037fff, 0x8002801e,
  0xcccd3333, 0xaaab5556, 0x80037fff, 0x8002801e,
  0xcccd0000, 0xaaab0001, 0x80030002, 0x80020020,
  0xcccc999a, 0xaaaa5557, 0x80020008, 0x80010024,
  0xccc9666a, 0xaaa50007, 0x7ffa0038, 0x7ff90044,
  0xccb06683, 0xaa7b5586, 0x7fbb81af, 0x7fba813e,
  0xcc973369, 0xaa5155b0, 0x7f7c8329, 0x7f7b823a,
  0xcc7dcd1c, 0xaa270085, 0x7f3d04a6, 0x7f3c0338,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffcccd, 0xffffaaac, 0xffff8005, 0xffff8022,
  0xffff6667, 0xffff0002, 0xfffe800b, 0xfffe8026,
  0xfffc3337, 0xfff9aab2, 0xfff6803b, 0xfff68046,
  0xffe33350, 0xffd00031, 0xffb801b2, 0xffb80140,
  0xffca0036, 0xffa6005b, 0xff79032c, 0xff79023c,
  0xffb099e9, 0xff7bab30, 0xff3984a9, 0xff39833a,
  0xf5733dc0, 0xee6abc41, 0xe5a09e42, 0xe5a069a0,
  0xffffcccd, 0xffffaaac, 0xffff8005, 0xffff8022,
  0xffff6667, 0xffff0002, 0xfffe800b, 0xfffe8026,
  0xfffc3337, 0xfff9aab2, 0xfff6803b, 0xfff68046,
  0xffe33350, 0xffd00031, 0xffb801b2, 0xffb80140,
  0xffca0036, 0xffa6005b, 0xff79032c, 0xff79023c,
  0xffb099e9, 0xff7bab30, 0xff3984a9, 0xff39833a,
  0xf5733dc0, 0xee6abc41, 0xe5a09e42, 0xe5a069a0,
  0xe4624ed1, 0xd1f92e08, 0xbaf71e41, 0xbaf6944a,
  0xffff999a, 0xffff5557, 0xffff0008, 0xffff0024,
  0xfffc666a, 0xfffa0007, 0xfff70038, 0xfff70044,
  0xffe36683, 0xffd05586, 0xffb881af, 0xffb8813e,
  0xffca3369, 0xffa655b0, 0xff798329, 0xff79823a,
  0xffb0cd1c, 0xff7c0085, 0xff3a04a6, 0xff3a0338,
  0xf57370f3, 0xee6b1196, 0xe5a11e3f, 0xe5a0e99e,
  0xe4628204, 0xd1f9835d, 0xbaf79e3e, 0xbaf71448,
  0xcac99b9d, 0xa750035c, 0x7afa9e35, 0x7af99442,
  0xfffcccd0, 0xfffaaab1, 0xfff80032, 0xfff80040,
  0xffe3cce9, 0xffd10030, 0xffb981a9, 0xffb9813a,
  0xffca99cf, 0xffa7005a, 0xff7a8323, 0xff7a8236,
  0xffb13382, 0xff7cab2f, 0xff3b04a0, 0xff3b0334,
  0xf573d759, 0xee6bbc40, 0xe5a21e39, 0xe5a1e99a,
  0xe462e86a, 0xd1fa2e07, 0xbaf89e38, 0xbaf81444,
  0xcaca0203, 0xa750ae06, 0x7afb9e2f, 0x7afa943e,
  0xb130e869, 0x7ca6d8b0, 0x3afe1e29, 0x3afc943a,
  0xffe70019, 0xffd65580, 0xffc18179, 0xffc1811a,
  0xffcdccff, 0xffac55aa, 0xff8282f3, 0xff828216,
  0xffb466b2, 0xff82007f, 0xff430470, 0xff430314,
  0xf5770a89, 0xee711190, 0xe5aa1e09, 0xe5a9e97a,
  0xe4661b9a, 0xd1ff8357, 0xbb009e08, 0xbb001424,
  0xcacd3533, 0xa7560356, 0x7b039dff, 0x7b02941e,
  0xb1341b99, 0x7cac2e00, 0x3b061df9, 0x3b04941a,
  0x979acecc, 0x52020355, 0xfb081df6, 0xfb061418,
  0xffe6cce6, 0xffd6002b, 0xffc1017c, 0xffc1011c,
  0xffcd6699, 0xffabab00, 0xff8182f9, 0xff81821a,
  0xf5900a70, 0xee9abc11, 0xe5e89c92, 0xe5e86880,
  0xe47f1b81, 0xd2292dd8, 0xbb3f1c91, 0xbb3e932a,
  0xcae6351a, 0xa77fadd7, 0x7b421c88, 0x7b411324,
  0xb14d1b80, 0x7cd5d881, 0x3b449c82, 0x3b431320,
  0x97b3ceb3, 0x522badd6, 0xfb469c7f, 0xfb44931e,
  0x7e1a4eb3, 0x27812dd6, 0xbb481c7f, 0xbb45931e,
  0xffe699b3, 0xffd5aad6, 0xffc0817f, 0xffc0811e,
  0xf5a93d8a, 0xeec4bbe7, 0xe6279b18, 0xe6276784,
  0xe4984e9b, 0xd2532dae, 0xbb7e1b17, 0xbb7d922e,
  0xcaff6834, 0xa7a9adad, 0x7b811b0e, 0x7b801228,
  0xb1664e9a, 0x7cffd857, 0x3b839b08, 0x3b821224,
  0x97cd01cd, 0x5255adac, 0xfb859b05, 0xfb839222,
  0x7e3381cd, 0x27ab2dac, 0xbb871b05, 0xbb849222,
  0x6499ce9a, 0xfd005857, 0x7b881b08, 0x7b851224,
  0xf5c2a3d7, 0xeeef1112, 0xe667199b, 0xe666e686,
  0xe4b1b4e8, 0xd27d82d9, 0xbbbd999a, 0xbbbd1130,
  0xcb18ce81, 0xa7d402d8, 0x7bc09991, 0x7bbf912a,
  0xb17fb4e7, 0x7d2a2d82, 0x3bc3198b, 0x3bc19126,
  0x97e6681a, 0x528002d7, 0xfbc51988, 0xfbc31124,
  0x7e4ce81a, 0x27d582d7, 0xbbc69988, 0xbbc41124,
  0x64b334e7, 0xfd2aad82, 0x7bc7998b, 0x7bc49126,
  0x42915709, 0xc4479110, 0x26749989, 0x2670e67a,
  0xeeef1111, 0xe38e71c8, 0xd5568001, 0xd5562aca,
  0xd5562aaa, 0xb8e4f1c7, 0x95597ff8, 0x9558aac4,
  0xbbbd1110, 0x8e3b1c71, 0x555bfff2, 0x555aaac0,
  0xa223c443, 0x6390f1c6, 0x155dffef, 0x155c2abe,
  0x888a4443, 0x38e671c6, 0xd55f7fef, 0xd55d2abe,
  0x6ef09110, 0x0e3b9c71, 0x95607ff2, 0x955daac0,
  0x4cceb332, 0xd5587fff, 0x400d7ff0, 0x400a0014,
  0x23d9428e, 0x9114c443, 0xd9a9e654, 0xd9a599ac,
  0xe6671999, 0xd5568000, 0xc002fff9, 0xc002801a,
  0xcccdffff, 0xaaacaaaa, 0x80057ff3, 0x80048016,
  0xb334b332, 0x80027fff, 0x40077ff0, 0x40060014,
  0x999b3332, 0x5557ffff, 0x0008fff0, 0x00070014,
  0x80017fff, 0x2aad2aaa, 0xc009fff3, 0xc0078016,
  0x5ddfa221, 0xf1ca0e38, 0x6ab6fff1, 0x6ab3d56a,
  0x34ea317d, 0xad86527c, 0x04536655, 0x044f6f02,
  0x01d0cafd, 0x585bfcfc, 0x849664d5, 0x84916e02,
  0xe666e666, 0xd5562aab, 0xc0027ffc, 0xc002001c,
  0xcccd9999, 0xaaac0000, 0x80047ff9, 0x8003801a,
  0xb3341999, 0x80018000, 0x4005fff9, 0x4004801a,
  0x999a6666, 0x5556aaab, 0x0006fffc, 0x0005001c,
  0x77788888, 0x1c738e39, 0xaab3fffa, 0xaab15570,
  0x4e8317e4, 0xd82fd27d, 0x4450665e, 0x444cef08,
  0x1b69b164, 0x83057cfd, 0xc49364de, 0xc48eee08,
  0xe85017b1, 0x2ddad228, 0x44d5e361, 0x44d06d0a,
  0xe666b333, 0xd555d556, 0xc001ffff, 0xc001801e,
  0xcccd3333, 0xaaab5556, 0x80037fff, 0x8002801e,
  0xb3338000, 0x80008001, 0x40048002, 0x40030020,
  0x9111a222, 0x471d638f, 0xeab18000, 0xeaaf5574,
  0x681c317e, 0x02d9a7d3, 0x844de664, 0x844aef0c,
  0x3502cafe, 0xadaf5253, 0x0490e4e4, 0x048cee0c,
  0x01e9314b, 0x5884a77e, 0x84d36367, 0x84ce6d0e,
  0xcecf6465, 0x0359a754, 0x051561ed, 0x050f6c12,
  0xe6668000, 0xd5558001, 0xc0018002, 0xc0010020,
  0xcccccccd, 0xaaaaaaac, 0x80028005, 0x80018022,
  0xaaaaeeef, 0x71c78e3a, 0x2aaf8003, 0x2aadd576,
  0x81b57e4b, 0x2d83d27e, 0xc44be667, 0xc4496f0e,
  0x4e9c17cb, 0xd8597cfe, 0x448ee4e7, 0x448b6e0e,
  0x1b827e18, 0x832ed229, 0xc4d1636a, 0xc4cced10,
  0xe868b132, 0x2e03d1ff, 0x451361f0, 0x450dec14,
  0xb54eb119, 0xd8d87c80, 0xc554e079, 0xc54e6b1a,
  0xe6664ccd, 0xd5552aac, 0xc0010005, 0xc0008022,
  0xc4446eef, 0x9c720e3a, 0x6aae0003, 0x6aacd576,
  0x9b4efe4b, 0x582e527e, 0x044a6667, 0x04486f0e,
  0x683597cb, 0x0303fcfe, 0x848d64e7, 0x848a6e0e,
  0x351bfe18, 0xadd95229, 0x04cfe36a, 0x04cbed10,
  0x02023132, 0x58ae51ff, 0x8511e1f0, 0x850cec14,
  0xcee83119, 0x0382fc80, 0x05536079, 0x054d6b1a,
  0x9bb86449, 0xae3351d0, 0x855e6049, 0x85576afa,
  0xddde2222, 0xc71ce38f, 0xaaad0000, 0xaaac5574,
  0xb4e8b17e, 0x82d927d3, 0x44496664, 0x4447ef0c,
  0x81cf4afe, 0x2daed253, 0xc48c64e4, 0xc489ee0c,
  0x4eb5b14b, 0xd884277e, 0x44cee367, 0x44cb6d0e,
  0x1b9be465, 0x83592754, 0xc510e1ed, 0xc50c6c12,
  0xe881e44c, 0x2e2dd1d5, 0x45526076, 0x454ceb18,
  0xb552177c, 0xd8de2725, 0xc55d6046, 0xc556eaf8,
  0x821fb115, 0x838a2724, 0x4561e03d, 0x455a6af2,
  0xd70a8f5c, 0xbbbc4445, 0x999c6666, 0x999b99b8,
  0xa3f128dc, 0x6691eec5, 0x19df64e6, 0x19dd98b8,
  0x70d78f29, 0x116743f0, 0x9a21e369, 0x9a1f17ba,
  0x3dbdc243, 0xbc3c43c6, 0x1a63e1ef, 0x1a6016be,
  0x0aa3c22a, 0x6710ee47, 0x9aa56078, 0x9aa095c4,
  0xd773f55a, 0x11c14397, 0x1ab06048, 0x1aaa95a4,
  0xa4418ef3, 0xbc6d4396, 0x9ab4e03f, 0x9aae159e,
  0x710ef559, 0x6718ee40, 0x1ab8e039, 0x1ab1159a,
  0xcce69980, 0xaad5aa81, 0x8042fe82, 0x8041ff20,
  0x99ccffcd, 0x55aaffac, 0x00857d05, 0x00837e22,
  0x66b332e7, 0x007fff82, 0x80c77b8b, 0x80c47d26,
  0x339932ce, 0xab54aa03, 0x0108fa14, 0x0104fc2c,
  0x006965fe, 0x5604ff53, 0x8113f9e4, 0x810efc0c,
  0xcd36ff97, 0x00b0ff52, 0x011879db, 0x01127c06,
  0x9a0465fd, 0xab5ca9fc, 0x811c79d5, 0x81157c02,
  0x66d19930, 0x5607ff51, 0x011ff9d2, 0x0117fc00,
  0xaad5552b, 0x80427e84, 0x80417f04, 0x80407fa1,
  0x55aa5501, 0x00847d0a, 0x00827e08, 0x00807f23,
  0x007eff82, 0x80c5fb93, 0x80c2fd0e, 0x80bffea6,
  0xab2f54d2, 0x00d0fb63, 0x00ccfcee, 0x00c8fe96,
  0x55db54d1, 0x80d57b5a, 0x80d07ce8, 0x80cb7e93,
  0x0086ff7b, 0x00d97b54, 0x00d37ce4, 0x00cd7e91,
  0xab3254d0, 0x80dcfb51, 0x80d5fce2, 0x80cefe90,
  0xab3254d0, 0x80dcfb51, 0x80d5fce2, 0x80cefe90,
  0xaad4ffd6, 0x8041fe87, 0x8040ff06, 0x803fffa2,
  0x55a9aa57, 0x00837d10, 0x00817e0c, 0x007f7f25,
  0x0059ffa7, 0x808e7ce0, 0x808b7dec, 0x80887f15,
  0xab05ffa6, 0x0092fcd7, 0x008efde6, 0x008aff12,
  0x55b1aa50, 0x8096fcd1, 0x8091fde2, 0x808cff10,
  0x005cffa5, 0x009a7cce, 0x00947de0, 0x008e7f0f,
  0x005cffa5, 0x009a7cce, 0x00947de0, 0x008e7f0f,
  0x005caa50, 0x0099fcd1, 0x0093fde2, 0x008dff10,
  0xaad4aa81, 0x80417e8a, 0x80407f08, 0x803f7fa3,
  0x5584ffd1, 0x004c7e5a, 0x004a7ee8, 0x00487f93,
  0x0030ffd0, 0x8050fe51, 0x804dfee2, 0x804aff90,
  0xaadcaa7a, 0x0054fe4b, 0x0050fede, 0x004cff8e,
  0x5587ffcf, 0x80587e48, 0x80537edc, 0x804e7f8d,
  0x5587ffcf, 0x80587e48, 0x80537edc, 0x804e7f8d,
  0x5587aa7a, 0x8057fe4b, 0x8052fede, 0x804dff8e,
  0x5586ffd0, 0x8056fe51, 0x8051fee2, 0x804cff90,
  0xaab05550, 0x800affd1, 0x8009ffe2, 0x80090010,
  0x555c554f, 0x000f7fc8, 0x000d7fdc, 0x000b800d,
  0x0007fff9, 0x80137fc2, 0x80107fd8, 0x800d800b,
  0xaab3554e, 0x0016ffbf, 0x0012ffd6, 0x000f000a,
  0xaab3554e, 0x0016ffbf, 0x0012ffd6, 0x000f000a,
  0xaab2fff9, 0x00167fc2, 0x00127fd8, 0x000e800b,
  0xaab2554f, 0x00157fc8, 0x00117fdc, 0x000d800d,
  0xaaacffff, 0x000d7ff8, 0x00097ffc, 0x0005801d,
  0xaaabffff, 0x80047ff8, 0x80037ffc, 0x8002801d,
  0x5557aaa9, 0x00087ff2, 0x00067ff8, 0x0004801b,
  0x0002fffe, 0x800bffef, 0x8008fff6, 0x8006001a,
  0x0002fffe, 0x800bffef, 0x8008fff6, 0x8006001a,
  0x0002aaa9, 0x800b7ff2, 0x80087ff8, 0x8005801b,
  0x0001ffff, 0x800a7ff8, 0x80077ffc, 0x8004801d,
  0xfffcaaaf, 0x80028028, 0x7fff801c, 0x7ffc802d,
  0xffd3002e, 0x7fc4019f, 0x7fc10116, 0x7fbe00aa,
  0xaaabaaaa, 0x8003fffb, 0x8002fffe, 0x8002001e,
  0x5556ffff, 0x00077ff8, 0x00057ffc, 0x0003801d,
  0x5556ffff, 0x00077ff8, 0x00057ffc, 0x0003801d,
  0x5556aaaa, 0x0006fffb, 0x0004fffe, 0x0003001e,
  0x55560000, 0x00060001, 0x00040002, 0x00020020,
  0x5550aab0, 0xfffe0031, 0xfffc0022, 0xfffa0030,
  0x5527002f, 0xffbf81a8, 0xffbd811c, 0xffbb80ad,
  0x54fd0059, 0xff808322, 0xff7e8218, 0xff7c812b,
  0xaaab5555, 0x80037ffe, 0x80028000, 0x8001801f,
  0xaaab5555, 0x80037ffe, 0x80028000, 0x8001801f,
  0xaaab0000, 0x80030001, 0x80020002, 0x80010020,
  0xaaaa5556, 0x80020007, 0x80010006, 0x80000022,
  0xaaa50006, 0x7ffa0037, 0x7ff90026, 0x7ff80032,
  0xaa7b5585, 0x7fbb81ae, 0x7fba8120, 0x7fb980af,
  0xaa5155af, 0x7f7c8328, 0x7f7b821c, 0x7f7a812d,
  0xaa270084, 0x7f3d04a5, 0x7f3c031a, 0x7f3b01ac,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffaaab, 0xffff8004, 0xffff8004, 0xffff8021,
  0xffff0001, 0xfffe800a, 0xfffe8008, 0xfffe8023,
  0xfff9aab1, 0xfff6803a, 0xfff68028, 0xfff68033,
  0xffd00030, 0xffb801b1, 0xffb80122, 0xffb800b0,
  0xffa6005a, 0xff79032b, 0xff79021e, 0xff79012e,
  0xff7bab2f, 0xff3984a8, 0xff39831c, 0xff3981ad,
  0xee6abc40, 0xe5a09e41, 0xe5a06982, 0xe5a034e0,
  0xffffaaab, 0xffff8004, 0xffff8004, 0xffff8021,
  0xffff0001, 0xfffe800a, 0xfffe8008, 0xfffe8023,
  0xfff9aab1, 0xfff6803a, 0xfff68028, 0xfff68033,
  0xffd00030, 0xffb801b1, 0xffb80122, 0xffb800b0,
  0xffa6005a, 0xff79032b, 0xff79021e, 0xff79012e,
  0xff7bab2f, 0xff3984a8, 0xff39831c, 0xff3981ad,
  0xee6abc40, 0xe5a09e41, 0xe5a06982, 0xe5a034e0,
  0xd1f92e07, 0xbaf71e40, 0xbaf6942c, 0xbaf60a35,
  0xffff5556, 0xffff0007, 0xffff0006, 0xffff0022,
  0xfffa0006, 0xfff70037, 0xfff70026, 0xfff70032,
  0xffd05585, 0xffb881ae, 0xffb88120, 0xffb880af,
  0xffa655af, 0xff798328, 0xff79821c, 0xff79812d,
  0xff7c0084, 0xff3a04a5, 0xff3a031a, 0xff3a01ac,
  0xee6b1195, 0xe5a11e3e, 0xe5a0e980, 0xe5a0b4df,
  0xd1f9835c, 0xbaf79e3d, 0xbaf7142a, 0xbaf68a34,
  0xa750035b, 0x7afa9e34, 0x7af99424, 0x7af88a31,
  0xfffaaab0, 0xfff80031, 0xfff80022, 0xfff80030,
  0xffd1002f, 0xffb981a8, 0xffb9811c, 0xffb980ad,
  0xffa70059, 0xff7a8322, 0xff7a8218, 0xff7a812b,
  0xff7cab2e, 0xff3b049f, 0xff3b0316, 0xff3b01aa,
  0xee6bbc3f, 0xe5a21e38, 0xe5a1e97c, 0xe5a1b4dd,
  0xd1fa2e06, 0xbaf89e37, 0xbaf81426, 0xbaf78a32,
  0xa750ae05, 0x7afb9e2e, 0x7afa9420, 0x7af98a2f,
  0x7ca6d8af, 0x3afe1e28, 0x3afc941c, 0x3afb0a2d,
  0xffd6557f, 0xffc18178, 0xffc180fc, 0xffc1809d,
  0xffac55a9, 0xff8282f2, 0xff8281f8, 0xff82811b,
  0xff82007e, 0xff43046f, 0xff4302f6, 0xff43019a,
  0xee71118f, 0xe5aa1e08, 0xe5a9e95c, 0xe5a9b4cd,
  0xd1ff8356, 0xbb009e07, 0xbb001406, 0xbaff8a22,
  0xa7560355, 0x7b039dfe, 0x7b029400, 0x7b018a1f,
  0x7cac2dff, 0x3b061df8, 0x3b0493fc, 0x3b030a1d,
  0x52020354, 0xfb081df5, 0xfb0613fa, 0xfb040a1c,
  0xffd6002a, 0xffc1017b, 0xffc100fe, 0xffc1009e,
  0xffabaaff, 0xff8182f8, 0xff8181fc, 0xff81811d,
  0xee9abc10, 0xe5e89c91, 0xe5e86862, 0xe5e83450,
  0xd2292dd7, 0xbb3f1c90, 0xbb3e930c, 0xbb3e09a5,
  0xa77fadd6, 0x7b421c87, 0x7b411306, 0x7b4009a2,
  0x7cd5d880, 0x3b449c81, 0x3b431302, 0x3b4189a0,
  0x522badd5, 0xfb469c7e, 0xfb449300, 0xfb42899f,
  0x27812dd5, 0xbb481c7e, 0xbb459300, 0xbb43099f,
  0xffd5aad5, 0xffc0817e, 0xffc08100, 0xffc0809f,
  0xeec4bbe6, 0xe6279b17, 0xe6276766, 0xe62733d2,
  0xd2532dad, 0xbb7e1b16, 0xbb7d9210, 0xbb7d0927,
  0xa7a9adac, 0x7b811b0d, 0x7b80120a, 0x7b7f0924,
  0x7cffd856, 0x3b839b07, 0x3b821206, 0x3b808922,
  0x5255adab, 0xfb859b04, 0xfb839204, 0xfb818921,
  0x27ab2dab, 0xbb871b04, 0xbb849204, 0xbb820921,
  0xfd005856, 0x7b881b07, 0x7b851206, 0x7b820922,
  0xeeef1111, 0xe667199a, 0xe666e668, 0xe666b353,
  0xd27d82d8, 0xbbbd9999, 0xbbbd1112, 0xbbbc88a8,
  0xa7d402d7, 0x7bc09990, 0x7bbf910c, 0x7bbe88a5,
  0x7d2a2d81, 0x3bc3198a, 0x3bc19108, 0x3bc008a3,
  0x528002d6, 0xfbc51987, 0xfbc31106, 0xfbc108a2,
  0x27d582d6, 0xbbc69987, 0xbbc41106, 0xbbc188a2,
  0xfd2aad81, 0x7bc7998a, 0x7bc49108, 0x7bc188a3,
  0xc447910f, 0x26749988, 0x2670e65c, 0x266d334d,
  0xe38e71c7, 0xd5568000, 0xd5562aac, 0xd555d575,
  0xb8e4f1c6, 0x95597ff7, 0x9558aaa6, 0x9557d572,
  0x8e3b1c70, 0x555bfff1, 0x555aaaa2, 0x55595570,
  0x6390f1c5, 0x155dffee, 0x155c2aa0, 0x155a556f,
  0x38e671c5, 0xd55f7fee, 0xd55d2aa0, 0xd55ad56f,
  0x0e3b9c70, 0x95607ff1, 0x955daaa2, 0x955ad570,
  0xd5587ffe, 0x400d7fef, 0x4009fff6, 0x4006801a,
  0x9114c442, 0xd9a9e653, 0xd9a5998e, 0xd9a14ce6,
  0xd5567fff, 0xc002fff8, 0xc0027ffc, 0xc002001d,
  0xaaacaaa9, 0x80057ff2, 0x80047ff8, 0x8003801b,
  0x80027ffe, 0x40077fef, 0x4005fff6, 0x4004801a,
  0x5557fffe, 0x0008ffef, 0x0006fff6, 0x0005001a,
  0x2aad2aa9, 0xc009fff2, 0xc0077ff8, 0xc005001b,
  0xf1ca0e37, 0x6ab6fff0, 0x6ab3d54c, 0x6ab0aac5,
  0xad86527b, 0x04536654, 0x044f6ee4, 0x044b7791,
  0x585bfcfb, 0x849664d4, 0x84916de4, 0x848c7711,
  0xd5562aaa, 0xc0027ffb, 0xc001fffe, 0xc001801e,
  0xaaabffff, 0x80047ff8, 0x80037ffc, 0x8002801d,
  0x80017fff, 0x4005fff8, 0x40047ffc, 0x4003001d,
  0x5556aaaa, 0x0006fffb, 0x0004fffe, 0x0003001e,
  0x1c738e38, 0xaab3fff9, 0xaab15552, 0xaaaeaac8,
  0xd82fd27c, 0x4450665d, 0x444ceeea, 0x44497794,
  0x83057cfc, 0xc49364dd, 0xc48eedea, 0xc48a7714,
  0x2ddad227, 0x44d5e360, 0x44d06cec, 0x44caf695,
  0xd555d555, 0xc001fffe, 0xc0018000, 0xc001001f,
  0xaaab5555, 0x80037ffe, 0x80028000, 0x8001801f,
  0x80008000, 0x40048001, 0x40030002, 0x40018020,
  0x471d638e, 0xeab17fff, 0xeaaf5556, 0xeaad2aca,
  0x02d9a7d2, 0x844de663, 0x844aeeee, 0x8447f796,
  0xadaf5252, 0x0490e4e3, 0x048cedee, 0x0488f716,
  0x5884a77d, 0x84d36366, 0x84ce6cf0, 0x84c97697,
  0x0359a753, 0x051561ec, 0x050f6bf4, 0x05097619,
  0xd5558000, 0xc0018001, 0xc0010002, 0xc0008020,
  0xaaaaaaab, 0x80028004, 0x80018004, 0x80008021,
  0x71c78e39, 0x2aaf8002, 0x2aadd558, 0x2aac2acb,
  0x2d83d27d, 0xc44be666, 0xc4496ef0, 0xc446f797,
  0xd8597cfd, 0x448ee4e6, 0x448b6df0, 0x4487f717,
  0x832ed228, 0xc4d16369, 0xc4ccecf2, 0xc4c87698,
  0x2e03d1fe, 0x451361ef, 0x450debf6, 0x4508761a,
  0xd8d87c7f, 0xc554e078, 0xc54e6afc, 0xc547f59d,
  0xd5552aab, 0xc0010004, 0xc0008004, 0xc0000021,
  0x9c720e39, 0x6aae0002, 0x6aacd558, 0x6aabaacb,
  0x582e527d, 0x044a6666, 0x04486ef0, 0x04467797,
  0x0303fcfd, 0x848d64e6, 0x848a6df0, 0x84877717,
  0xadd95228, 0x04cfe369, 0x04cbecf2, 0x04c7f698,
  0x58ae51fe, 0x8511e1ef, 0x850cebf6, 0x8507f61a,
  0x0382fc7f, 0x05536078, 0x054d6afc, 0x0547759d,
  0xae3351cf, 0x855e6048, 0x85576adc, 0x8550758d,
  0xc71ce38e, 0xaaacffff, 0xaaac5556, 0xaaabaaca,
  0x82d927d2, 0x44496663, 0x4447eeee, 0x44467796,
  0x2daed252, 0xc48c64e3, 0xc489edee, 0xc4877716,
  0xd884277d, 0x44cee366, 0x44cb6cf0, 0x44c7f697,
  0x83592753, 0xc510e1ec, 0xc50c6bf4, 0xc507f619,
  0x2e2dd1d4, 0x45526075, 0x454ceafa, 0x4547759c,
  0xd8de2724, 0xc55d6045, 0xc556eada, 0xc550758c,
  0x838a2723, 0x4561e03c, 0x455a6ad4, 0x4552f589,
  0xbbbc4444, 0x999c6665, 0x999b999a, 0x999accec,
  0x6691eec4, 0x19df64e5, 0x19dd989a, 0x19dbcc6c,
  0x116743ef, 0x9a21e368, 0x9a1f179c, 0x9a1c4bed,
  0xbc3c43c5, 0x1a63e1ee, 0x1a6016a0, 0x1a5c4b6f,
  0x6710ee46, 0x9aa56077, 0x9aa095a6, 0x9a9bcaf2,
  0x11c14396, 0x1ab06047, 0x1aaa9586, 0x1aa4cae2,
  0xbc6d4395, 0x9ab4e03e, 0x9aae1580, 0x9aa74adf,
  0x6718ee3f, 0x1ab8e038, 0x1ab1157c, 0x1aa94add,
  0xaad5aa80, 0x8042fe81, 0x8041ff02, 0x8040ffa0,
  0x55aaffab, 0x00857d04, 0x00837e04, 0x00817f21,
  0x007fff81, 0x80c77b8a, 0x80c47d08, 0x80c17ea3,
  0xab54aa02, 0x0108fa13, 0x0104fc0e, 0x0100fe26,
  0x5604ff52, 0x8113f9e3, 0x810efbee, 0x8109fe16,
  0x00b0ff51, 0x011879da, 0x01127be8, 0x010c7e13,
  0xab5ca9fb, 0x811c79d4, 0x81157be4, 0x810e7e11,
  0x5607ff50, 0x011ff9d1, 0x0117fbe2, 0x010ffe10,
  0x80427e83, 0x80417f03, 0x80407f83, 0x803f8020,
  0x00847d09, 0x00827e07, 0x00807f05, 0x007e8020,
  0x80c5fb92, 0x80c2fd0d, 0x80bffe88, 0x80bd0020,
  0x00d0fb62, 0x00ccfced, 0x00c8fe78, 0x00c50020,
  0x80d57b59, 0x80d07ce7, 0x80cb7e75, 0x80c68020,
  0x00d97b53, 0x00d37ce3, 0x00cd7e73, 0x00c78020,
  0x80dcfb50, 0x80d5fce1, 0x80cefe72, 0x80c80020,
  0x80dcfb50, 0x80d5fce1, 0x80cefe72, 0x80c80020,
  0x8041fe86, 0x8040ff05, 0x803fff84, 0x803f0020,
  0x00837d0f, 0x00817e0b, 0x007f7f07, 0x007d8020,
  0x808e7cdf, 0x808b7deb, 0x80887ef7, 0x80858020,
  0x0092fcd6, 0x008efde5, 0x008afef4, 0x00870020,
  0x8096fcd0, 0x8091fde1, 0x808cfef2, 0x80880020,
  0x009a7ccd, 0x00947ddf, 0x008e7ef1, 0x00888020,
  0x009a7ccd, 0x00947ddf, 0x008e7ef1, 0x00888020,
  0x0099fcd0, 0x0093fde1, 0x008dfef2, 0x00880020,
  0x80417e89, 0x80407f07, 0x803f7f85, 0x803e8020,
  0x004c7e59, 0x004a7ee7, 0x00487f75, 0x00468020,
  0x8050fe50, 0x804dfee1, 0x804aff72, 0x80480020,
  0x0054fe4a, 0x0050fedd, 0x004cff70, 0x00490020,
  0x80587e47, 0x80537edb, 0x804e7f6f, 0x80498020,
  0x80587e47, 0x80537edb, 0x804e7f6f, 0x80498020,
  0x8057fe4a, 0x8052fedd, 0x804dff70, 0x80490020,
  0x8056fe50, 0x8051fee1, 0x804cff72, 0x80480020,
  0x800affd0, 0x8009ffe1, 0x8008fff2, 0x80080020,
  0x000f7fc7, 0x000d7fdb, 0x000b7fef, 0x00098020,
  0x80137fc1, 0x80107fd7, 0x800d7fed, 0x800a8020,
  0x0016ffbe, 0x0012ffd5, 0x000effec, 0x000b0020,
  0x0016ffbe, 0x0012ffd5, 0x000effec, 0x000b0020,
  0x00167fc1, 0x00127fd7, 0x000e7fed, 0x000a8020,
  0x00157fc7, 0x00117fdb, 0x000d7fef, 0x00098020,
  0x000d7ff7, 0x00097ffb, 0x00057fff, 0x00018020,
  0x80047ff7, 0x80037ffb, 0x80027fff, 0x80018020,
  0x00087ff1, 0x00067ff7, 0x00047ffd, 0x00028020,
  0x800bffee, 0x8008fff5, 0x8005fffc, 0x80030020,
  0x800bffee, 0x8008fff5, 0x8005fffc, 0x80030020,
  0x800b7ff1, 0x80087ff7, 0x80057ffd, 0x80028020,
  0x800a7ff7, 0x80077ffb, 0x80047fff, 0x80018020,
  0x80028027, 0x7fff801b, 0x7ffc800f, 0x7ff98020,
  0x7fc4019e, 0x7fc10115, 0x7fbe008c, 0x7fbb0020,
  0x8003fffa, 0x8002fffd, 0x80020000, 0x80010020,
  0x00077ff7, 0x00057ffb, 0x00037fff, 0x00018020,
  0x00077ff7, 0x00057ffb, 0x00037fff, 0x00018020,
  0x0006fffa, 0x0004fffd, 0x00030000, 0x00010020,
  0x00060000, 0x00040001, 0x00020002, 0x00000020,
  0xfffe0030, 0xfffc0021, 0xfffa0012, 0xfff80020,
  0xffbf81a7, 0xffbd811b, 0xffbb808f, 0xffb98020,
  0xff808321, 0xff7e8217, 0xff7c810d, 0xff7a8020,
  0x80037ffd, 0x80027fff, 0x80018001, 0x80008020,
  0x80037ffd, 0x80027fff, 0x80018001, 0x80008020,
  0x80030000, 0x80020001, 0x80010002, 0x80000020,
  0x80020006, 0x80010005, 0x80000004, 0x7fff0020,
  0x7ffa0036, 0x7ff90025, 0x7ff80014, 0x7ff70020,
  0x7fbb81ad, 0x7fba811f, 0x7fb98091, 0x7fb88020,
  0x7f7c8327, 0x7f7b821b, 0x7f7a810f, 0x7f798020,
  0x7f3d04a4, 0x7f3c0319, 0x7f3b018e, 0x7f3a0020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff8003, 0xffff8003, 0xffff8003, 0xffff8020,
  0xfffe8009, 0xfffe8007, 0xfffe8005, 0xfffe8020,
  0xfff68039, 0xfff68027, 0xfff68015, 0xfff68020,
  0xffb801b0, 0xffb80121, 0xffb80092, 0xffb80020,
  0xff79032a, 0xff79021d, 0xff790110, 0xff790020,
  0xff3984a7, 0xff39831b, 0xff39818f, 0xff398020,
  0xe5a09e40, 0xe5a06981, 0xe5a034c2, 0xe5a00020,
  0xffff8003, 0xffff8003, 0xffff8003, 0xffff8020,
  0xfffe8009, 0xfffe8007, 0xfffe8005, 0xfffe8020,
  0xfff68039, 0xfff68027, 0xfff68015, 0xfff68020,
  0xffb801b0, 0xffb80121, 0xffb80092, 0xffb80020,
  0xff79032a, 0xff79021d, 0xff790110, 0xff790020,
  0xff3984a7, 0xff39831b, 0xff39818f, 0xff398020,
  0xe5a09e40, 0xe5a06981, 0xe5a034c2, 0xe5a00020,
  0xbaf71e3f, 0xbaf6942b, 0xbaf60a17, 0xbaf58020,
  0xffff0006, 0xffff0005, 0xffff0004, 0xffff0020,
  0xfff70036, 0xfff70025, 0xfff70014, 0xfff70020,
  0xffb881ad, 0xffb8811f, 0xffb88091, 0xffb88020,
  0xff798327, 0xff79821b, 0xff79810f, 0xff798020,
  0xff3a04a4, 0xff3a0319, 0xff3a018e, 0xff3a0020,
  0xe5a11e3d, 0xe5a0e97f, 0xe5a0b4c1, 0xe5a08020,
  0xbaf79e3c, 0xbaf71429, 0xbaf68a16, 0xbaf60020,
  0x7afa9e33, 0x7af99423, 0x7af88a13, 0x7af78020,
  0xfff80030, 0xfff80021, 0xfff80012, 0xfff80020,
  0xffb981a7, 0xffb9811b, 0xffb9808f, 0xffb98020,
  0xff7a8321, 0xff7a8217, 0xff7a810d, 0xff7a8020,
  0xff3b049e, 0xff3b0315, 0xff3b018c, 0xff3b0020,
  0xe5a21e37, 0xe5a1e97b, 0xe5a1b4bf, 0xe5a18020,
  0xbaf89e36, 0xbaf81425, 0xbaf78a14, 0xbaf70020,
  0x7afb9e2d, 0x7afa941f, 0x7af98a11, 0x7af88020,
  0x3afe1e27, 0x3afc941b, 0x3afb0a0f, 0x3af98020,
  0xffc18177, 0xffc180fb, 0xffc1807f, 0xffc18020,
  0xff8282f1, 0xff8281f7, 0xff8280fd, 0xff828020,
  0xff43046e, 0xff4302f5, 0xff43017c, 0xff430020,
  0xe5aa1e07, 0xe5a9e95b, 0xe5a9b4af, 0xe5a98020,
  0xbb009e06, 0xbb001405, 0xbaff8a04, 0xbaff0020,
  0x7b039dfd, 0x7b0293ff, 0x7b018a01, 0x7b008020,
  0x3b061df7, 0x3b0493fb, 0x3b0309ff, 0x3b018020,
  0xfb081df4, 0xfb0613f9, 0xfb0409fe, 0xfb020020,
  0xffc1017a, 0xffc100fd, 0xffc10080, 0xffc10020,
  0xff8182f7, 0xff8181fb, 0xff8180ff, 0xff818020,
  0xe5e89c90, 0xe5e86861, 0xe5e83432, 0xe5e80020,
  0xbb3f1c8f, 0xbb3e930b, 0xbb3e0987, 0xbb3d8020,
  0x7b421c86, 0x7b411305, 0x7b400984, 0x7b3f0020,
  0x3b449c80, 0x3b431301, 0x3b418982, 0x3b400020,
  0xfb469c7d, 0xfb4492ff, 0xfb428981, 0xfb408020,
  0xbb481c7d, 0xbb4592ff, 0xbb430981, 0xbb408020,
  0xffc0817d, 0xffc080ff, 0xffc08081, 0xffc08020,
  0xe6279b16, 0xe6276765, 0xe62733b4, 0xe6270020,
  0xbb7e1b15, 0xbb7d920f, 0xbb7d0909, 0xbb7c8020,
  0x7b811b0c, 0x7b801209, 0x7b7f0906, 0x7b7e0020,
  0x3b839b06, 0x3b821205, 0x3b808904, 0x3b7f0020,
  0xfb859b03, 0xfb839203, 0xfb818903, 0xfb7f8020,
  0xbb871b03, 0xbb849203, 0xbb820903, 0xbb7f8020,
  0x7b881b06, 0x7b851205, 0x7b820904, 0x7b7f0020,
  0xe6671999, 0xe666e667, 0xe666b335, 0xe6668020,
  0xbbbd9998, 0xbbbd1111, 0xbbbc888a, 0xbbbc0020,
  0x7bc0998f, 0x7bbf910b, 0x7bbe8887, 0x7bbd8020,
  0x3bc31989, 0x3bc19107, 0x3bc00885, 0x3bbe8020,
  0xfbc51986, 0xfbc31105, 0xfbc10884, 0xfbbf0020,
  0xbbc69986, 0xbbc41105, 0xbbc18884, 0xbbbf0020,
  0x7bc79989, 0x7bc49107, 0x7bc18885, 0x7bbe8020,
  0x26749987, 0x2670e65b, 0x266d332f, 0x26698020,
  0xd5567fff, 0xd5562aab, 0xd555d557, 0xd5558020,
  0x95597ff6, 0x9558aaa5, 0x9557d554, 0x95570020,
  0x555bfff0, 0x555aaaa1, 0x55595552, 0x55580020,
  0x155dffed, 0x155c2a9f, 0x155a5551, 0x15588020,
  0xd55f7fed, 0xd55d2a9f, 0xd55ad551, 0xd5588020,
  0x95607ff0, 0x955daaa1, 0x955ad552, 0x95580020,
  0x400d7fee, 0x4009fff5, 0x40067ffc, 0x40030020,
  0xd9a9e652, 0xd9a5998d, 0xd9a14cc8, 0xd99d0020,
  0xc002fff7, 0xc0027ffb, 0xc001ffff, 0xc0018020,
  0x80057ff1, 0x80047ff7, 0x80037ffd, 0x80028020,
  0x40077fee, 0x4005fff5, 0x40047ffc, 0x40030020,
  0x0008ffee, 0x0006fff5, 0x0004fffc, 0x00030020,
  0xc009fff1, 0xc0077ff7, 0xc004fffd, 0xc0028020,
  0x6ab6ffef, 0x6ab3d54b, 0x6ab0aaa7, 0x6aad8020,
  0x04536653, 0x044f6ee3, 0x044b7773, 0x04478020,
  0x849664d3, 0x84916de3, 0x848c76f3, 0x84878020,
  0xc0027ffa, 0xc001fffd, 0xc0018000, 0xc0010020,
  0x80047ff7, 0x80037ffb, 0x80027fff, 0x80018020,
  0x4005fff7, 0x40047ffb, 0x4002ffff, 0x40018020,
  0x0006fffa, 0x0004fffd, 0x00030000, 0x00010020,
  0xaab3fff8, 0xaab15551, 0xaaaeaaaa, 0xaaac0020,
  0x4450665c, 0x444ceee9, 0x44497776, 0x44460020,
  0xc49364dc, 0xc48eede9, 0xc48a76f6, 0xc4860020,
  0x44d5e35f, 0x44d06ceb, 0x44caf677, 0x44c58020,
  0xc001fffd, 0xc0017fff, 0xc0010001, 0xc0008020,
  0x80037ffd, 0x80027fff, 0x80018001, 0x80008020,
  0x40048000, 0x40030001, 0x40018002, 0x40000020,
  0xeab17ffe, 0xeaaf5555, 0xeaad2aac, 0xeaab0020,
  0x844de662, 0x844aeeed, 0x8447f778, 0x84450020,
  0x0490e4e2, 0x048ceded, 0x0488f6f8, 0x04850020,
  0x84d36365, 0x84ce6cef, 0x84c97679, 0x84c48020,
  0x051561eb, 0x050f6bf3, 0x050975fb, 0x05038020,
  0xc0018000, 0xc0010001, 0xc0008002, 0xc0000020,
  0x80028003, 0x80018003, 0x80008003, 0x7fff8020,
  0x2aaf8001, 0x2aadd557, 0x2aac2aad, 0x2aaa8020,
  0xc44be665, 0xc4496eef, 0xc446f779, 0xc4448020,
  0x448ee4e5, 0x448b6def, 0x4487f6f9, 0x44848020,
  0xc4d16368, 0xc4ccecf1, 0xc4c8767a, 0xc4c40020,
  0x451361ee, 0x450debf5, 0x450875fc, 0x45030020,
  0xc554e077, 0xc54e6afb, 0xc547f57f, 0xc5418020,
  0xc0010003, 0xc0008003, 0xc0000003, 0xbfff8020,
  0x6aae0001, 0x6aacd557, 0x6aabaaad, 0x6aaa8020,
  0x044a6665, 0x04486eef, 0x04467779, 0x04448020,
  0x848d64e5, 0x848a6def, 0x848776f9, 0x84848020,
  0x04cfe368, 0x04cbecf1, 0x04c7f67a, 0x04c40020,
  0x8511e1ee, 0x850cebf5, 0x8507f5fc, 0x85030020,
  0x05536077, 0x054d6afb, 0x0547757f, 0x05418020,
  0x855e6047, 0x85576adb, 0x8550756f, 0x85498020,
  0xaaacfffe, 0xaaac5555, 0xaaabaaac, 0xaaab0020,
  0x44496662, 0x4447eeed, 0x44467778, 0x44450020,
  0xc48c64e2, 0xc489eded, 0xc48776f8, 0xc4850020,
  0x44cee365, 0x44cb6cef, 0x44c7f679, 0x44c48020,
  0xc510e1eb, 0xc50c6bf3, 0xc507f5fb, 0xc5038020,
  0x45526074, 0x454ceaf9, 0x4547757e, 0x45420020,
  0xc55d6044, 0xc556ead9, 0xc550756e, 0xc54a0020,
  0x4561e03b, 0x455a6ad3, 0x4552f56b, 0x454b8020,
  0x999c6664, 0x999b9999, 0x999accce, 0x999a0020,
  0x19df64e4, 0x19dd9899, 0x19dbcc4e, 0x19da0020,
  0x9a21e367, 0x9a1f179b, 0x9a1c4bcf, 0x9a198020,
  0x1a63e1ed, 0x1a60169f, 0x1a5c4b51, 0x1a588020,
  0x9aa56076, 0x9aa095a5, 0x9a9bcad4, 0x9a970020,
  0x1ab06046, 0x1aaa9585, 0x1aa4cac4, 0x1a9f0020,
  0x9ab4e03d, 0x9aae157f, 0x9aa74ac1, 0x9aa08020,
  0x1ab8e037, 0x1ab1157b, 0x1aa94abf, 0x1aa18020,
  0x8042fe80, 0x8041ff01, 0x8040ff82, 0x80400020,
  0x00857d03, 0x00837e03, 0x00817f03, 0x007f8020,
  0x80c77b89, 0x80c47d07, 0x80c17e85, 0x80be8020,
  0x0108fa12, 0x0104fc0d, 0x0100fe08, 0x00fd0020,
  0x8113f9e2, 0x810efbed, 0x8109fdf8, 0x81050020,
  0x011879d9, 0x01127be7, 0x010c7df5, 0x01068020,
  0x811c79d3, 0x81157be3, 0x810e7df3, 0x81078020,
  0x011ff9d0, 0x0117fbe1, 0x010ffdf2, 0x01080020,
  0x80417f02, 0x80407f82, 0x803f8002, 0x803e809f,
  0x00827e06, 0x00807f04, 0x007e8002, 0x007c811d,
  0x80c2fd0c, 0x80bffe87, 0x80bd0002, 0x80ba019a,
  0x00ccfcec, 0x00c8fe77, 0x00c50002, 0x00c101aa,
  0x80d07ce6, 0x80cb7e74, 0x80c68002, 0x80c181ad,
  0x00d37ce2, 0x00cd7e72, 0x00c78002, 0x00c181af,
  0x80d5fce0, 0x80cefe71, 0x80c80002, 0x80c101b0,
  0x80d5fce0, 0x80cefe71, 0x80c80002, 0x80c101b0,
  0x8040ff04, 0x803fff83, 0x803f0002, 0x803e009e,
  0x00817e0a, 0x007f7f06, 0x007d8002, 0x007b811b,
  0x808b7dea, 0x80887ef6, 0x80858002, 0x8082812b,
  0x008efde4, 0x008afef3, 0x00870002, 0x0083012e,
  0x8091fde0, 0x808cfef1, 0x80880002, 0x80830130,
  0x00947dde, 0x008e7ef0, 0x00888002, 0x00828131,
  0x00947dde, 0x008e7ef0, 0x00888002, 0x00828131,
  0x0093fde0, 0x008dfef1, 0x00880002, 0x00820130,
  0x80407f06, 0x803f7f84, 0x803e8002, 0x803d809d,
  0x004a7ee6, 0x00487f74, 0x00468002, 0x004480ad,
  0x804dfee0, 0x804aff71, 0x80480002, 0x804500b0,
  0x0050fedc, 0x004cff6f, 0x00490002, 0x004500b2,
  0x80537eda, 0x804e7f6e, 0x80498002, 0x804480b3,
  0x80537eda, 0x804e7f6e, 0x80498002, 0x804480b3,
  0x8052fedc, 0x804dff6f, 0x80490002, 0x804400b2,
  0x8051fee0, 0x804cff71, 0x80480002, 0x804300b0,
  0x8009ffe0, 0x8008fff1, 0x80080002, 0x80070030,
  0x000d7fda, 0x000b7fee, 0x00098002, 0x00078033,
  0x80107fd6, 0x800d7fec, 0x800a8002, 0x80078035,
  0x0012ffd4, 0x000effeb, 0x000b0002, 0x00070036,
  0x0012ffd4, 0x000effeb, 0x000b0002, 0x00070036,
  0x00127fd6, 0x000e7fec, 0x000a8002, 0x00068035,
  0x00117fda, 0x000d7fee, 0x00098002, 0x00058033,
  0x00097ffa, 0x00057ffe, 0x00018002, 0xfffd8023,
  0x80037ffa, 0x80027ffe, 0x80018002, 0x80008023,
  0x00067ff6, 0x00047ffc, 0x00028002, 0x00008025,
  0x8008fff4, 0x8005fffb, 0x80030002, 0x80000026,
  0x8008fff4, 0x8005fffb, 0x80030002, 0x80000026,
  0x80087ff6, 0x80057ffc, 0x80028002, 0x7fff8025,
  0x80077ffa, 0x80047ffe, 0x80018002, 0x7ffe8023,
  0x7fff801a, 0x7ffc800e, 0x7ff98002, 0x7ff68013,
  0x7fc10114, 0x7fbe008b, 0x7fbb0002, 0x7fb7ff96,
  0x8002fffc, 0x8001ffff, 0x80010002, 0x80000022,
  0x00057ffa, 0x00037ffe, 0x00018002, 0xffff8023,
  0x00057ffa, 0x00037ffe, 0x00018002, 0xffff8023,
  0x0004fffc, 0x0002ffff, 0x00010002, 0xffff0022,
  0x00040000, 0x00020001, 0x00000002, 0xfffe0020,
  0xfffc0020, 0xfffa0011, 0xfff80002, 0xfff60010,
  0xffbd811a, 0xffbb808e, 0xffb98002, 0xffb77f93,
  0xff7e8216, 0xff7c810c, 0xff7a8002, 0xff787f15,
  0x80027ffe, 0x80018000, 0x80008002, 0x7fff8021,
  0x80027ffe, 0x80018000, 0x80008002, 0x7fff8021,
  0x80020000, 0x80010001, 0x80000002, 0x7fff0020,
  0x80010004, 0x80000003, 0x7fff0002, 0x7ffe001e,
  0x7ff90024, 0x7ff80013, 0x7ff70002, 0x7ff6000e,
  0x7fba811e, 0x7fb98090, 0x7fb88002, 0x7fb77f91,
  0x7f7b821a, 0x7f7a810e, 0x7f798002, 0x7f787f13,
  0x7f3c0318, 0x7f3b018d, 0x7f3a0002, 0x7f38fe94,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff8002, 0xffff8002, 0xffff8002, 0xffff801f,
  0xfffe8006, 0xfffe8004, 0xfffe8002, 0xfffe801d,
  0xfff68026, 0xfff68014, 0xfff68002, 0xfff6800d,
  0xffb80120, 0xffb80091, 0xffb80002, 0xffb7ff90,
  0xff79021c, 0xff79010f, 0xff790002, 0xff78ff12,
  0xff39831a, 0xff39818e, 0xff398002, 0xff397e93,
  0xe5a06980, 0xe5a034c1, 0xe5a00002, 0xe59fcb60,
  0xffff8002, 0xffff8002, 0xffff8002, 0xffff801f,
  0xfffe8006, 0xfffe8004, 0xfffe8002, 0xfffe801d,
  0xfff68026, 0xfff68014, 0xfff68002, 0xfff6800d,
  0xffb80120, 0xffb80091, 0xffb80002, 0xffb7ff90,
  0xff79021c, 0xff79010f, 0xff790002, 0xff78ff12,
  0xff39831a, 0xff39818e, 0xff398002, 0xff397e93,
  0xe5a06980, 0xe5a034c1, 0xe5a00002, 0xe59fcb60,
  0xbaf6942a, 0xbaf60a16, 0xbaf58002, 0xbaf4f60b,
  0xffff0004, 0xffff0003, 0xffff0002, 0xffff001e,
  0xfff70024, 0xfff70013, 0xfff70002, 0xfff7000e,
  0xffb8811e, 0xffb88090, 0xffb88002, 0xffb87f91,
  0xff79821a, 0xff79810e, 0xff798002, 0xff797f13,
  0xff3a0318, 0xff3a018d, 0xff3a0002, 0xff39fe94,
  0xe5a0e97e, 0xe5a0b4c0, 0xe5a08002, 0xe5a04b61,
  0xbaf71428, 0xbaf68a15, 0xbaf60002, 0xbaf5760c,
  0x7af99422, 0x7af88a12, 0x7af78002, 0x7af6760f,
  0xfff80020, 0xfff80011, 0xfff80002, 0xfff80010,
  0xffb9811a, 0xffb9808e, 0xffb98002, 0xffb97f93,
  0xff7a8216, 0xff7a810c, 0xff7a8002, 0xff7a7f15,
  0xff3b0314, 0xff3b018b, 0xff3b0002, 0xff3afe96,
  0xe5a1e97a, 0xe5a1b4be, 0xe5a18002, 0xe5a14b63,
  0xbaf81424, 0xbaf78a13, 0xbaf70002, 0xbaf6760e,
  0x7afa941e, 0x7af98a10, 0x7af88002, 0x7af77611,
  0x3afc941a, 0x3afb0a0e, 0x3af98002, 0x3af7f613,
  0xffc180fa, 0xffc1807e, 0xffc18002, 0xffc17fa3,
  0xff8281f6, 0xff8280fc, 0xff828002, 0xff827f25,
  0xff4302f4, 0xff43017b, 0xff430002, 0xff42fea6,
  0xe5a9e95a, 0xe5a9b4ae, 0xe5a98002, 0xe5a94b73,
  0xbb001404, 0xbaff8a03, 0xbaff0002, 0xbafe761e,
  0x7b0293fe, 0x7b018a00, 0x7b008002, 0x7aff7621,
  0x3b0493fa, 0x3b0309fe, 0x3b018002, 0x3afff623,
  0xfb0613f8, 0xfb0409fd, 0xfb020002, 0xfafff624,
  0xffc100fc, 0xffc1007f, 0xffc10002, 0xffc0ffa2,
  0xff8181fa, 0xff8180fe, 0xff818002, 0xff817f23,
  0xe5e86860, 0xe5e83431, 0xe5e80002, 0xe5e7cbf0,
  0xbb3e930a, 0xbb3e0986, 0xbb3d8002, 0xbb3cf69b,
  0x7b411304, 0x7b400983, 0x7b3f0002, 0x7b3df69e,
  0x3b431300, 0x3b418981, 0x3b400002, 0x3b3e76a0,
  0xfb4492fe, 0xfb428980, 0xfb408002, 0xfb3e76a1,
  0xbb4592fe, 0xbb430980, 0xbb408002, 0xbb3df6a1,
  0xffc080fe, 0xffc08080, 0xffc08002, 0xffc07fa1,
  0xe6276764, 0xe62733b3, 0xe6270002, 0xe626cc6e,
  0xbb7d920e, 0xbb7d0908, 0xbb7c8002, 0xbb7bf719,
  0x7b801208, 0x7b7f0905, 0x7b7e0002, 0x7b7cf71c,
  0x3b821204, 0x3b808903, 0x3b7f0002, 0x3b7d771e,
  0xfb839202, 0xfb818902, 0xfb7f8002, 0xfb7d771f,
  0xbb849202, 0xbb820902, 0xbb7f8002, 0xbb7cf71f,
  0x7b851204, 0x7b820903, 0x7b7f0002, 0x7b7bf71e,
  0xe666e666, 0xe666b334, 0xe6668002, 0xe6664ced,
  0xbbbd1110, 0xbbbc8889, 0xbbbc0002, 0xbbbb7798,
  0x7bbf910a, 0x7bbe8886, 0x7bbd8002, 0x7bbc779b,
  0x3bc19106, 0x3bc00884, 0x3bbe8002, 0x3bbcf79d,
  0xfbc31104, 0xfbc10883, 0xfbbf0002, 0xfbbcf79e,
  0xbbc41104, 0xbbc18883, 0xbbbf0002, 0xbbbc779e,
  0x7bc49106, 0x7bc18884, 0x7bbe8002, 0x7bbb779d,
  0x2670e65a, 0x266d332e, 0x26698002, 0x2665ccf3,
  0xd5562aaa, 0xd555d556, 0xd5558002, 0xd5552acb,
  0x9558aaa4, 0x9557d553, 0x95570002, 0x95562ace,
  0x555aaaa0, 0x55595551, 0x55580002, 0x5556aad0,
  0x155c2a9e, 0x155a5550, 0x15588002, 0x1556aad1,
  0xd55d2a9e, 0xd55ad550, 0xd5588002, 0xd5562ad1,
  0x955daaa0, 0x955ad551, 0x95580002, 0x95552ad0,
  0x4009fff4, 0x40067ffb, 0x40030002, 0x3fff8026,
  0xd9a5998c, 0xd9a14cc7, 0xd99d0002, 0xd998b35a,
  0xc0027ffa, 0xc001fffe, 0xc0018002, 0xc0010023,
  0x80047ff6, 0x80037ffc, 0x80028002, 0x80018025,
  0x4005fff4, 0x40047ffb, 0x40030002, 0x40018026,
  0x0006fff4, 0x0004fffb, 0x00030002, 0x00010026,
  0xc0077ff6, 0xc004fffc, 0xc0028002, 0xc0000025,
  0x6ab3d54a, 0x6ab0aaa6, 0x6aad8002, 0x6aaa557b,
  0x044f6ee2, 0x044b7772, 0x04478002, 0x044388af,
  0x84916de2, 0x848c76f2, 0x84878002, 0x8482892f,
  0xc001fffc, 0xc0017fff, 0xc0010002, 0xc0008022,
  0x80037ffa, 0x80027ffe, 0x80018002, 0x80008023,
  0x40047ffa, 0x4002fffe, 0x40018002, 0x40000023,
  0x0004fffc, 0x0002ffff, 0x00010002, 0xffff0022,
  0xaab15550, 0xaaaeaaa9, 0xaaac0002, 0xaaa95578,
  0x444ceee8, 0x44497775, 0x44460002, 0x444288ac,
  0xc48eede8, 0xc48a76f5, 0xc4860002, 0xc481892c,
  0x44d06cea, 0x44caf676, 0x44c58002, 0x44c009ab,
  0xc0017ffe, 0xc0010000, 0xc0008002, 0xc0000021,
  0x80027ffe, 0x80018000, 0x80008002, 0x7fff8021,
  0x40030000, 0x40018001, 0x40000002, 0x3ffe8020,
  0xeaaf5554, 0xeaad2aab, 0xeaab0002, 0xeaa8d576,
  0x844aeeec, 0x8447f777, 0x84450002, 0x844208aa,
  0x048cedec, 0x0488f6f7, 0x04850002, 0x0481092a,
  0x84ce6cee, 0x84c97678, 0x84c48002, 0x84bf89a9,
  0x050f6bf2, 0x050975fa, 0x05038002, 0x04fd8a27,
  0xc0010000, 0xc0008001, 0xc0000002, 0xbfff8020,
  0x80018002, 0x80008002, 0x7fff8002, 0x7ffe801f,
  0x2aadd556, 0x2aac2aac, 0x2aaa8002, 0x2aa8d575,
  0xc4496eee, 0xc446f778, 0xc4448002, 0xc44208a9,
  0x448b6dee, 0x4487f6f8, 0x44848002, 0x44810929,
  0xc4ccecf0, 0xc4c87679, 0xc4c40002, 0xc4bf89a8,
  0x450debf4, 0x450875fb, 0x45030002, 0x44fd8a26,
  0xc54e6afa, 0xc547f57e, 0xc5418002, 0xc53b0aa3,
  0xc0008002, 0xc0000002, 0xbfff8002, 0xbfff001f,
  0x6aacd556, 0x6aabaaac, 0x6aaa8002, 0x6aa95575,
  0x04486eee, 0x04467778, 0x04448002, 0x044288a9,
  0x848a6dee, 0x848776f8, 0x84848002, 0x84818929,
  0x04cbecf0, 0x04c7f679, 0x04c40002, 0x04c009a8,
  0x850cebf4, 0x8507f5fb, 0x85030002, 0x84fe0a26,
  0x054d6afa, 0x0547757e, 0x05418002, 0x053b8aa3,
  0x85576ada, 0x8550756e, 0x85498002, 0x85428ab3,
  0xaaac5554, 0xaaabaaab, 0xaaab0002, 0xaaaa5576,
  0x4447eeec, 0x44467777, 0x44450002, 0x444388aa,
  0xc489edec, 0xc48776f7, 0xc4850002, 0xc482892a,
  0x44cb6cee, 0x44c7f678, 0x44c48002, 0x44c109a9,
  0xc50c6bf2, 0xc507f5fa, 0xc5038002, 0xc4ff0a27,
  0x454ceaf8, 0x4547757d, 0x45420002, 0x453c8aa4,
  0xc556ead8, 0xc550756d, 0xc54a0002, 0xc5438ab4,
  0x455a6ad2, 0x4552f56a, 0x454b8002, 0x45440ab7,
  0x999b9998, 0x999acccd, 0x999a0002, 0x99993354,
  0x19dd9898, 0x19dbcc4d, 0x19da0002, 0x19d833d4,
  0x9a1f179a, 0x9a1c4bce, 0x9a198002, 0x9a16b453,
  0x1a60169e, 0x1a5c4b50, 0x1a588002, 0x1a54b4d1,
  0x9aa095a4, 0x9a9bcad3, 0x9a970002, 0x9a92354e,
  0x1aaa9584, 0x1aa4cac3, 0x1a9f0002, 0x1a99355e,
  0x9aae157e, 0x9aa74ac0, 0x9aa08002, 0x9a99b561,
  0x1ab1157a, 0x1aa94abe, 0x1aa18002, 0x1a99b563,
  0x8041ff00, 0x8040ff81, 0x80400002, 0x803f00a0,
  0x00837e02, 0x00817f02, 0x007f8002, 0x007d811f,
  0x80c47d06, 0x80c17e84, 0x80be8002, 0x80bb819d,
  0x0104fc0c, 0x0100fe07, 0x00fd0002, 0x00f9021a,
  0x810efbec, 0x8109fdf7, 0x81050002, 0x8100022a,
  0x01127be6, 0x010c7df4, 0x01068002, 0x0100822d,
  0x81157be2, 0x810e7df2, 0x81078002, 0x8100822f,
  0x0117fbe0, 0x010ffdf1, 0x01080002, 0x01000230,
  0x80407f81, 0x803f8001, 0x803e8081, 0x55aaaa76,
  0x00807f03, 0x007e8001, 0x007c80ff, 0xab54aa22,
  0x80bffe86, 0x80bd0001, 0x80ba017c, 0x00fdff24,
  0x00c8fe76, 0x00c50001, 0x00c1018c, 0x565ea9c4,
  0x80cb7e73, 0x80c68001, 0x80c1818f, 0xabb6a9c2,
  0x00cd7e71, 0x00c78001, 0x00c18191, 0x010dff16,
  0x80cefe70, 0x80c80001, 0x80c10192, 0x5664a9c0,
  0x80cefe70, 0x80c80001, 0x80c10192, 0x5664a9c0,
  0x803fff82, 0x803f0001, 0x803e0080, 0x55a9ffcc,
  0x007f7f05, 0x007d8001, 0x007b80fd, 0xab5354ce,
  0x80887ef5, 0x80858001, 0x8082810d, 0x00b3ff6e,
  0x008afef2, 0x00870001, 0x00830110, 0x560bff6c,
  0x808cfef0, 0x80880001, 0x80830112, 0xab6354c0,
  0x008e7eef, 0x00888001, 0x00828113, 0x00b9ff6a,
  0x008e7eef, 0x00888001, 0x00828113, 0x00b9ff6a,
  0x008dfef0, 0x00880001, 0x00820112, 0x00b954c0,
  0x803f7f83, 0x803e8001, 0x803d807f, 0x55a95522,
  0x00487f73, 0x00468001, 0x0044808f, 0xab09ffc2,
  0x804aff70, 0x80480001, 0x80450092, 0x0061ffc0,
  0x004cff6e, 0x00490001, 0x00450094, 0x55b95514,
  0x804e7f6d, 0x80498001, 0x80448095, 0xab0fffbe,
  0x804e7f6d, 0x80498001, 0x80448095, 0xab0fffbe,
  0x804dff6e, 0x80490001, 0x80440094, 0xab0f5514,
  0x804cff70, 0x80480001, 0x80430092, 0xab0dffc0,
  0x8008fff0, 0x80080001, 0x80070012, 0x5560aac0,
  0x000b7fed, 0x00098001, 0x00078015, 0xaab8aabe,
  0x800d7feb, 0x800a8001, 0x80078017, 0x00100012,
  0x000effea, 0x000b0001, 0x00070018, 0x5566aabc,
  0x000effea, 0x000b0001, 0x00070018, 0x5566aabc,
  0x000e7feb, 0x000a8001, 0x00068017, 0x55660012,
  0x000d7fed, 0x00098001, 0x00058015, 0x5564aabe,
  0x00057ffd, 0x00018001, 0xfffd8005, 0x555a001e,
  0x80027ffd, 0x80018001, 0x80008005, 0x5558001e,
  0x00047ffb, 0x00028001, 0x00008007, 0xaaaf5572,
  0x8005fffa, 0x80030001, 0x80000008, 0x0006001c,
  0x8005fffa, 0x80030001, 0x80000008, 0x0006001c,
  0x80057ffb, 0x80028001, 0x7fff8007, 0x00055572,
  0x80047ffd, 0x80018001, 0x7ffe8005, 0x0004001e,
  0x7ffc800d, 0x7ff98001, 0x7ff67ff5, 0xfff9557e,
  0x7fbe008a, 0x7fbb0001, 0x7fb7ff78, 0xffa6007c,
  0x8001fffe, 0x80010001, 0x80000004, 0x55575574,
  0x00037ffd, 0x00018001, 0xffff8005, 0xaaae001e,
  0x00037ffd, 0x00018001, 0xffff8005, 0xaaae001e,
  0x0002fffe, 0x00010001, 0xffff0004, 0xaaad5574,
  0x00020000, 0x00000001, 0xfffe0002, 0xaaac0020,
  0xfffa0010, 0xfff80001, 0xfff5fff2, 0xaaa15580,
  0xffbb808d, 0xffb98001, 0xffb77f75, 0xaa4e007e,
  0xff7c810b, 0xff7a8001, 0xff787ef7, 0xa9fa00d2,
  0x80017fff, 0x80008001, 0x7fff8003, 0x5556aaca,
  0x80017fff, 0x80008001, 0x7fff8003, 0x5556aaca,
  0x80010000, 0x80000001, 0x7fff0002, 0x55560020,
  0x80000002, 0x7fff0001, 0x7ffe0000, 0x5554aacc,
  0x7ff80012, 0x7ff70001, 0x7ff5fff0, 0x554a002c,
  0x7fb9808f, 0x7fb88001, 0x7fb77f73, 0x54f6ab2a,
  0x7f7a810d, 0x7f798001, 0x7f787ef5, 0x54a2ab7e,
  0x7f3b018c, 0x7f3a0001, 0x7f38fe76, 0x544e0128,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff8001, 0xffff8001, 0xffff8001, 0xffff5576,
  0xfffe8003, 0xfffe8001, 0xfffe7fff, 0xfffe0022,
  0xfff68013, 0xfff68001, 0xfff67fef, 0xfff35582,
  0xffb80090, 0xffb80001, 0xffb7ff72, 0xffa00080,
  0xff79010e, 0xff790001, 0xff78fef4, 0xff4c00d4,
  0xff39818d, 0xff398001, 0xff397e75, 0xfef7567e,
  0xe5a034c0, 0xe5a00001, 0xe59fcb42, 0xdcd578a0,
  0xffff8001, 0xffff8001, 0xffff8001, 0xffff5576,
  0xfffe8003, 0xfffe8001, 0xfffe7fff, 0xfffe0022,
  0xfff68013, 0xfff68001, 0xfff67fef, 0xfff35582,
  0xffb80090, 0xffb80001, 0xffb7ff72, 0xffa00080,
  0xff79010e, 0xff790001, 0xff78fef4, 0xff4c00d4,
  0xff39818d, 0xff398001, 0xff397e75, 0xfef7567e,
  0xe5a034c0, 0xe5a00001, 0xe59fcb42, 0xdcd578a0,
  0xbaf60a15, 0xbaf58001, 0xbaf4f5ed, 0xa3f25c2e,
  0xffff0002, 0xffff0001, 0xffff0000, 0xfffeaacc,
  0xfff70012, 0xfff70001, 0xfff6fff0, 0xfff4002c,
  0xffb8808f, 0xffb88001, 0xffb87f73, 0xffa0ab2a,
  0xff79810d, 0xff798001, 0xff797ef5, 0xff4cab7e,
  0xff3a018c, 0xff3a0001, 0xff39fe76, 0xfef80128,
  0xe5a0b4bf, 0xe5a08001, 0xe5a04b43, 0xdcd6234a,
  0xbaf68a14, 0xbaf60001, 0xbaf575ee, 0xa3f306d8,
  0x7af88a11, 0x7af78001, 0x7af675f1, 0x4ea006d6,
  0xfff80010, 0xfff80001, 0xfff7fff2, 0xfff55580,
  0xffb9808d, 0xffb98001, 0xffb97f75, 0xffa2007e,
  0xff7a810b, 0xff7a8001, 0xff7a7ef7, 0xff4e00d2,
  0xff3b018a, 0xff3b0001, 0xff3afe78, 0xfef9567c,
  0xe5a1b4bd, 0xe5a18001, 0xe5a14b45, 0xdcd7789e,
  0xbaf78a12, 0xbaf70001, 0xbaf675f0, 0xa3f45c2c,
  0x7af98a0f, 0x7af88001, 0x7af775f3, 0x4ea15c2a,
  0x3afb0a0d, 0x3af98001, 0x3af7f5f5, 0xf94db17e,
  0xffc1807d, 0xffc18001, 0xffc17f85, 0xffacab1e,
  0xff8280fb, 0xff828001, 0xff827f07, 0xff58ab72,
  0xff43017a, 0xff430001, 0xff42fe88, 0xff04011c,
  0xe5a9b4ad, 0xe5a98001, 0xe5a94b55, 0xdce2233e,
  0xbaff8a02, 0xbaff0001, 0xbafe7600, 0xa3ff06cc,
  0x7b0189ff, 0x7b008001, 0x7aff7603, 0x4eac06ca,
  0x3b0309fd, 0x3b018001, 0x3afff605, 0xf9585c1e,
  0xfb0409fc, 0xfb020001, 0xfafff606, 0xa40406c8,
  0xffc1007e, 0xffc10001, 0xffc0ff84, 0xffac0074,
  0xff8180fd, 0xff818001, 0xff817f05, 0xff57561e,
  0xe5e83430, 0xe5e80001, 0xe5e7cbd2, 0xdd357840,
  0xbb3e0985, 0xbb3d8001, 0xbb3cf67d, 0xa4525bce,
  0x7b400982, 0x7b3f0001, 0x7b3df680, 0x4eff5bcc,
  0x3b418980, 0x3b400001, 0x3b3e7682, 0xf9abb120,
  0xfb42897f, 0xfb408001, 0xfb3e7683, 0xa4575bca,
  0xbb43097f, 0xbb408001, 0xbb3df683, 0x4f025bca,
  0xffc0807f, 0xffc08001, 0xffc07f83, 0xffab55ca,
  0xe62733b2, 0xe6270001, 0xe626cc50, 0xdd8977ec,
  0xbb7d0907, 0xbb7c8001, 0xbb7bf6fb, 0xa4a65b7a,
  0x7b7f0904, 0x7b7e0001, 0x7b7cf6fe, 0x4f535b78,
  0x3b808902, 0x3b7f0001, 0x3b7d7700, 0xf9ffb0cc,
  0xfb818901, 0xfb7f8001, 0xfb7d7701, 0xa4ab5b76,
  0xbb820901, 0xbb7f8001, 0xbb7cf701, 0x4f565b76,
  0x7b820902, 0x7b7f0001, 0x7b7bf700, 0xfa00b0cc,
  0xe666b333, 0xe6668001, 0xe6664ccf, 0xddde2242,
  0xbbbc8888, 0xbbbc0001, 0xbbbb777a, 0xa4fb05d0,
  0x7bbe8885, 0x7bbd8001, 0x7bbc777d, 0x4fa805ce,
  0x3bc00883, 0x3bbe8001, 0x3bbcf77f, 0xfa545b22,
  0xfbc10882, 0xfbbf0001, 0xfbbcf780, 0xa50005cc,
  0xbbc18882, 0xbbbf0001, 0xbbbc7780, 0x4fab05cc,
  0x7bc18883, 0x7bbe8001, 0x7bbb777f, 0xfa555b22,
  0x266d332d, 0x26698001, 0x2665ccd5, 0x888f223e,
  0xd555d555, 0xd5558001, 0xd5552aad, 0xc71ce3ae,
  0x9557d552, 0x95570001, 0x95562ab0, 0x71c9e3ac,
  0x55595550, 0x55580001, 0x5556aab2, 0x1c763900,
  0x155a554f, 0x15588001, 0x1556aab3, 0xc721e3aa,
  0xd55ad54f, 0xd5588001, 0xd5562ab3, 0x71cce3aa,
  0x955ad550, 0x95580001, 0x95552ab2, 0x1c773900,
  0x40067ffa, 0x40030001, 0x3fff8008, 0xaab1001c,
  0xd9a14cc6, 0xd99d0001, 0xd998b33c, 0x222988a4,
  0xc001fffd, 0xc0018001, 0xc0010005, 0xaaad001e,
  0x80037ffb, 0x80028001, 0x80018007, 0x55595572,
  0x40047ffa, 0x40030001, 0x40018008, 0x0005001c,
  0x0004fffa, 0x00030001, 0x00010008, 0xaab0001c,
  0xc004fffb, 0xc0028001, 0xc0000007, 0x555a5572,
  0x6ab0aaa5, 0x6aad8001, 0x6aaa555d, 0xe3941c8e,
  0x044b7771, 0x04478001, 0x04438891, 0x5b0ca516,
  0x848c76f1, 0x84878001, 0x84828911, 0xb0b7fa16,
  0xc0017ffe, 0xc0010001, 0xc0008004, 0xaaac5574,
  0x80027ffd, 0x80018001, 0x80008005, 0x5558001e,
  0x4002fffd, 0x40018001, 0x40000005, 0x0003001e,
  0x0002fffe, 0x00010001, 0xffff0004, 0xaaad5574,
  0xaaaeaaa8, 0xaaac0001, 0xaaa9555a, 0x38e71c90,
  0x44497774, 0x44460001, 0x4442888e, 0xb05fa518,
  0xc48a76f4, 0xc4860001, 0xc481890e, 0x060afa18,
  0x44caf675, 0x44c58001, 0x44c0098d, 0x5bb5a46e,
  0xc000ffff, 0xc0008001, 0xc0000003, 0xaaabaaca,
  0x80017fff, 0x80008001, 0x7fff8003, 0x5556aaca,
  0x40018000, 0x40000001, 0x3ffe8002, 0x00010020,
  0xeaad2aaa, 0xeaab0001, 0xeaa8d558, 0x8e3ac73c,
  0x8447f776, 0x84450001, 0x8442088c, 0x05b34fc4,
  0x0488f6f6, 0x04850001, 0x0481090c, 0x5b5ea4c4,
  0x84c97677, 0x84c48001, 0x84bf898b, 0xb1094f1a,
  0x050975f9, 0x05038001, 0x04fd8a09, 0x06b34ec6,
  0xc0008000, 0xc0000001, 0xbfff8002, 0xaaab0020,
  0x80008001, 0x7fff8001, 0x7ffe8001, 0x55555576,
  0x2aac2aab, 0x2aaa8001, 0x2aa8d557, 0xe38f1c92,
  0xc446f777, 0xc4448001, 0xc442088b, 0x5b07a51a,
  0x4487f6f7, 0x44848001, 0x4481090b, 0xb0b2fa1a,
  0xc4c87678, 0xc4c40001, 0xc4bf898a, 0x065da470,
  0x450875fa, 0x45030001, 0x44fd8a08, 0x5c07a41c,
  0xc547f57d, 0xc5418001, 0xc53b0a85, 0xb1b0f91e,
  0xc0000001, 0xbfff8001, 0xbfff0001, 0xaaaa5576,
  0x6aabaaab, 0x6aaa8001, 0x6aa95557, 0x38e41c92,
  0x04467777, 0x04448001, 0x0442888b, 0xb05ca51a,
  0x848776f7, 0x84848001, 0x8481890b, 0x0607fa1a,
  0x04c7f678, 0x04c40001, 0x04c0098a, 0x5bb2a470,
  0x8507f5fa, 0x85030001, 0x84fe0a08, 0xb15ca41c,
  0x0547757d, 0x05418001, 0x053b8a85, 0x0705f91e,
  0x8550756d, 0x85498001, 0x85428a95, 0x5c66a3be,
  0xaaabaaaa, 0xaaab0001, 0xaaaa5558, 0x8e39c73c,
  0x44467776, 0x44450001, 0x4443888c, 0x05b24fc4,
  0xc48776f6, 0xc4850001, 0xc482890c, 0x5b5da4c4,
  0x44c7f677, 0x44c48001, 0x44c1098b, 0xb1084f1a,
  0xc507f5f9, 0xc5038001, 0xc4ff0a09, 0x06b24ec6,
  0x4547757c, 0x45420001, 0x453c8a86, 0x5c5ba3c8,
  0xc550756c, 0xc54a0001, 0xc5438a96, 0xb1bc4e68,
  0x4552f569, 0x454b8001, 0x45440a99, 0x07144e66,
  0x999acccc, 0x999a0001, 0x99993336, 0x777888a8,
  0x19dbcc4c, 0x19da0001, 0x19d833b6, 0xcd23dda8,
  0x9a1c4bcd, 0x9a198001, 0x9a16b435, 0x22ce87fe,
  0x1a5c4b4f, 0x1a588001, 0x1a54b4b3, 0x787887aa,
  0x9a9bcad2, 0x9a970001, 0x9a923530, 0xce21dcac,
  0x1aa4cac2, 0x1a9f0001, 0x1a993540, 0x2382874c,
  0x9aa74abf, 0x9aa08001, 0x9a99b543, 0x78da874a,
  0x1aa94abd, 0x1aa18001, 0x1a99b545, 0xce31dc9e,
  0x8040ff80, 0x80400001, 0x803f0082, 0x55ab5520,
  0x00817f01, 0x007f8001, 0x007d8101, 0xab55ff76,
  0x80c17e83, 0x80be8001, 0x80bb817f, 0x00ffff22,
  0x0100fe06, 0x00fd0001, 0x00f901fc, 0x56a95424,
  0x8109fdf6, 0x81050001, 0x8100020c, 0xac09fec4,
  0x010c7df3, 0x01068001, 0x0100820f, 0x0161fec2,
  0x810e7df1, 0x81078001, 0x81008211, 0x56b95416,
  0x010ffdf0, 0x01080001, 0x01000212, 0xac0ffec0,
  0x803f8000, 0x803e8080, 0x55aaaa58, 0x33999954,
  0x007e8000, 0x007c80fe, 0xab54aa04, 0x673265bc,
  0x80bd0000, 0x80ba017b, 0x00fdff06, 0x9aca6558,
  0x00c50000, 0x00c1018b, 0x565ea9a6, 0xce0b3218,
  0x80c68000, 0x80c1818e, 0xabb6a9a4, 0x0141987c,
  0x00c78000, 0x00c18190, 0x010dfef8, 0x34773214,
  0x80c80000, 0x80c10191, 0x5664a9a2, 0x67abfee0,
  0x80c80000, 0x80c10191, 0x5664a9a2, 0x67abfee0,
  0x803f0000, 0x803e007f, 0x55a9ffae, 0x3398cc88,
  0x007d8000, 0x007b80fc, 0xab5354b0, 0x6730cc24,
  0x80858000, 0x8082810c, 0x00b3ff50, 0x9a7198e4,
  0x00870000, 0x0083010f, 0x560bff4e, 0xcda7ff48,
  0x80880000, 0x80830111, 0xab6354a2, 0x00dd98e0,
  0x00888000, 0x00828112, 0x00b9ff4c, 0x341265ac,
  0x00888000, 0x00828112, 0x00b9ff4c, 0x341265ac,
  0x00880000, 0x00820111, 0x00b954a2, 0x341198e0,
  0x803e8000, 0x803d807e, 0x55a95504, 0x3397ffbc,
  0x00468000, 0x0044808e, 0xab09ffa4, 0x66d8cc7c,
  0x80480000, 0x80450091, 0x0061ffa2, 0x9a0f32e0,
  0x00490000, 0x00450093, 0x55b954f6, 0xcd44cc78,
  0x80498000, 0x80448094, 0xab0fffa0, 0x00799944,
  0x80498000, 0x80448094, 0xab0fffa0, 0x00799944,
  0x80490000, 0x80440093, 0xab0f54f6, 0x0078cc78,
  0x80480000, 0x80430091, 0xab0dffa2, 0x007732e0,
  0x80080000, 0x80070011, 0x5560aaa2, 0x3340cce0,
  0x00098000, 0x00078014, 0xaab8aaa0, 0x66773344,
  0x800a8000, 0x80078016, 0x000ffff4, 0x99acccdc,
  0x000b0000, 0x00070017, 0x5566aa9e, 0xcce199a8,
  0x000b0000, 0x00070017, 0x5566aa9e, 0xcce199a8,
  0x000a8000, 0x00068016, 0x5565fff4, 0xcce0ccdc,
  0x00098000, 0x00058014, 0x5564aaa0, 0xccdf3344,
  0x00018000, 0xfffd8004, 0x555a0000, 0xccd26684,
  0x80018000, 0x80008004, 0x55580000, 0x33366684,
  0x00028000, 0x00008006, 0xaaaf5554, 0x666c001c,
  0x80030000, 0x80000007, 0x0005fffe, 0x99a0cce8,
  0x80030000, 0x80000007, 0x0005fffe, 0x99a0cce8,
  0x80028000, 0x7fff8006, 0x00055554, 0x99a0001c,
  0x80018000, 0x7ffe8004, 0x00040000, 0x999e6684,
  0x7ff98000, 0x7ff67ff4, 0xfff95560, 0x999199c4,
  0x7fbb0000, 0x7fb7ff77, 0xffa6005e, 0x992d9a28,
  0x80010000, 0x80000003, 0x55575556, 0x333599b8,
  0x00018000, 0xffff8004, 0xaaae0000, 0x666a6684,
  0x00018000, 0xffff8004, 0xaaae0000, 0x666a6684,
  0x00010000, 0xffff0003, 0xaaad5556, 0x666999b8,
  0x00000000, 0xfffe0001, 0xaaac0002, 0x66680020,
  0xfff80000, 0xfff5fff1, 0xaaa15562, 0x665b3360,
  0xffb98000, 0xffb77f74, 0xaa4e0060, 0x65f733c4,
  0xff7a8000, 0xff787ef6, 0xa9fa00b4, 0x6592675c,
  0x80008000, 0x7fff8002, 0x5556aaac, 0x3334ccec,
  0x80008000, 0x7fff8002, 0x5556aaac, 0x3334ccec,
  0x80000000, 0x7fff0001, 0x55560002, 0x33340020,
  0x7fff0000, 0x7ffdffff, 0x5554aaae, 0x33326688,
  0x7ff70000, 0x7ff5ffef, 0x554a000e, 0x332599c8,
  0x7fb88000, 0x7fb77f72, 0x54f6ab0c, 0x32c19a2c,
  0x7f798000, 0x7f787ef4, 0x54a2ab60, 0x325ccdc4,
  0x7f3a0000, 0x7f38fe75, 0x544e010a, 0x31f73490,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff8000, 0xffff8000, 0xffff5558, 0xffff3354,
  0xfffe8000, 0xfffe7ffe, 0xfffe0004, 0xfffd99bc,
  0xfff68000, 0xfff67fee, 0xfff35564, 0xfff0ccfc,
  0xffb80000, 0xffb7ff71, 0xffa00062, 0xff8ccd60,
  0xff790000, 0xff78fef3, 0xff4c00b6, 0xff2800f8,
  0xff398000, 0xff397e74, 0xfef75660, 0xfec267c4,
  0xe5a00000, 0xe59fcb41, 0xdcd57882, 0xd5ccf720,
  0xffff8000, 0xffff8000, 0xffff5558, 0xffff3354,
  0xfffe8000, 0xfffe7ffe, 0xfffe0004, 0xfffd99bc,
  0xfff68000, 0xfff67fee, 0xfff35564, 0xfff0ccfc,
  0xffb80000, 0xffb7ff71, 0xffa00062, 0xff8ccd60,
  0xff790000, 0xff78fef3, 0xff4c00b6, 0xff2800f8,
  0xff398000, 0xff397e74, 0xfef75660, 0xfec267c4,
  0xe5a00000, 0xe59fcb41, 0xdcd57882, 0xd5ccf720,
  0xbaf58000, 0xbaf4f5ec, 0xa3f25c10, 0x91893b64,
  0xffff0000, 0xfffeffff, 0xfffeaaae, 0xfffe6688,
  0xfff70000, 0xfff6ffef, 0xfff4000e, 0xfff199c8,
  0xffb88000, 0xffb87f72, 0xffa0ab0c, 0xff8d9a2c,
  0xff798000, 0xff797ef4, 0xff4cab60, 0xff28cdc4,
  0xff3a0000, 0xff39fe75, 0xfef8010a, 0xfec33490,
  0xe5a08000, 0xe5a04b42, 0xdcd6232c, 0xd5cdc3ec,
  0xbaf60000, 0xbaf575ed, 0xa3f306ba, 0x918a0830,
  0x7af78000, 0x7af675f0, 0x4ea006b8, 0x2b266e94,
  0xfff80000, 0xfff7fff1, 0xfff55562, 0xfff33360,
  0xffb98000, 0xffb97f74, 0xffa20060, 0xff8f33c4,
  0xff7a8000, 0xff7a7ef6, 0xff4e00b4, 0xff2a675c,
  0xff3b0000, 0xff3afe77, 0xfef9565e, 0xfec4ce28,
  0xe5a18000, 0xe5a14b44, 0xdcd77880, 0xd5cf5d84,
  0xbaf70000, 0xbaf675ef, 0xa3f45c0e, 0x918ba1c8,
  0x7af88000, 0x7af775f2, 0x4ea15c0c, 0x2b28082c,
  0x3af98000, 0x3af7f5f4, 0xf94db160, 0xc4c3a1c4,
  0xffc18000, 0xffc17f84, 0xffacab00, 0xff9c0084,
  0xff828000, 0xff827f06, 0xff58ab54, 0xff37341c,
  0xff430000, 0xff42fe87, 0xff0400fe, 0xfed19ae8,
  0xe5a98000, 0xe5a94b54, 0xdce22320, 0xd5dc2a44,
  0xbaff0000, 0xbafe75ff, 0xa3ff06ae, 0x91986e88,
  0x7b008000, 0x7aff7602, 0x4eac06ac, 0x2b34d4ec,
  0x3b018000, 0x3afff604, 0xf9585c00, 0xc4d06e84,
  0xfb020000, 0xfafff605, 0xa40406aa, 0x5e6b3b50,
  0xffc10000, 0xffc0ff83, 0xffac0056, 0xff9b33b8,
  0xff818000, 0xff817f04, 0xff575600, 0xff359a84,
  0xe5e80000, 0xe5e7cbd1, 0xdd357822, 0xd64029e0,
  0xbb3d8000, 0xbb3cf67c, 0xa4525bb0, 0x91fc6e24,
  0x7b3f0000, 0x7b3df67f, 0x4eff5bae, 0x2b98d488,
  0x3b400000, 0x3b3e7681, 0xf9abb102, 0xc5346e20,
  0xfb408000, 0xfb3e7682, 0xa4575bac, 0x5ecf3aec,
  0xbb408000, 0xbb3df682, 0x4f025bac, 0xf8693aec,
  0xffc08000, 0xffc07f82, 0xffab55ac, 0xff9a66ec,
  0xe6270000, 0xe626cc4f, 0xdd8977ce, 0xd6a4f648,
  0xbb7c8000, 0xbb7bf6fa, 0xa4a65b5c, 0x92613a8c,
  0x7b7e0000, 0x7b7cf6fd, 0x4f535b5a, 0x2bfda0f0,
  0x3b7f0000, 0x3b7d76ff, 0xf9ffb0ae, 0xc5993a88,
  0xfb7f8000, 0xfb7d7700, 0xa4ab5b58, 0x5f340754,
  0xbb7f8000, 0xbb7cf700, 0x4f565b58, 0xf8ce0754,
  0x7b7f0000, 0x7b7bf6ff, 0xfa00b0ae, 0x92673a88,
  0xe6668000, 0xe6664cce, 0xddde2224, 0xd70a8f7c,
  0xbbbc0000, 0xbbbb7779, 0xa4fb05b2, 0x92c6d3c0,
  0x7bbd8000, 0x7bbc777c, 0x4fa805b0, 0x2c633a24,
  0x3bbe8000, 0x3bbcf77e, 0xfa545b04, 0xc5fed3bc,
  0xfbbf0000, 0xfbbcf77f, 0xa50005ae, 0x5f99a088,
  0xbbbf0000, 0xbbbc777f, 0x4fab05ae, 0xf933a088,
  0x7bbe8000, 0x7bbb777e, 0xfa555b04, 0x92ccd3bc,
  0x26698000, 0x2665ccd4, 0x888f2220, 0x0a455c44,
  0xd5558000, 0xd5552aac, 0xc71ce390, 0xbbbc4464,
  0x95570000, 0x95562aaf, 0x71c9e38e, 0x5558aac8,
  0x55580000, 0x5556aab1, 0x1c7638e2, 0xeef44460,
  0x15588000, 0x1556aab2, 0xc721e38c, 0x888f112c,
  0xd5588000, 0xd5562ab2, 0x71cce38c, 0x2229112c,
  0x95580000, 0x95552ab1, 0x1c7738e2, 0xbbc24460,
  0x40030000, 0x3fff8007, 0xaab0fffe, 0x333acce8,
  0xd99d0000, 0xd998b33b, 0x22298886, 0x8f650a58,
  0xc0018000, 0xc0010004, 0xaaad0000, 0x999c6684,
  0x80028000, 0x80018006, 0x55595554, 0x3338001c,
  0x40030000, 0x40018007, 0x0004fffe, 0xccd2cce8,
  0x00030000, 0x00010007, 0xaaaffffe, 0x666ccce8,
  0xc0028000, 0xc0000006, 0x555a5554, 0x0006001c,
  0x6aad8000, 0x6aaa555c, 0xe3941c70, 0x777e88a4,
  0x04478000, 0x04438890, 0x5b0ca4f8, 0xd3a8c614,
  0x84878000, 0x84828910, 0xb0b7f9f8, 0x07432c14,
  0xc0010000, 0xc0008003, 0xaaac5556, 0x999b99b8,
  0x80018000, 0x80008004, 0x55580000, 0x33366684,
  0x40018000, 0x40000004, 0x00030000, 0xccd06684,
  0x00010000, 0xffff0003, 0xaaad5556, 0x666999b8,
  0xaaac0000, 0xaaa95559, 0x38e71c72, 0xdde22240,
  0x44460000, 0x4442888d, 0xb05fa4fa, 0x3a0c5fb0,
  0xc4860000, 0xc481890d, 0x060af9fa, 0x6da6c5b0,
  0x44c58000, 0x44c0098c, 0x5bb5a450, 0xa1405ee4,
  0xc0008000, 0xc0000002, 0xaaabaaac, 0x999accec,
  0x80008000, 0x7fff8002, 0x5556aaac, 0x3334ccec,
  0x40000000, 0x3ffe8001, 0x00010002, 0xccce0020,
  0xeaab0000, 0xeaa8d557, 0x8e3ac71e, 0x444688a8,
  0x84450000, 0x8442088b, 0x05b34fa6, 0xa070c618,
  0x04850000, 0x0481090b, 0x5b5ea4a6, 0xd40b2c18,
  0x84c48000, 0x84bf898a, 0xb1094efc, 0x07a4c54c,
  0x05038000, 0x04fd8a08, 0x06b34ea8, 0x3b3d91b4,
  0xc0000000, 0xbfff8001, 0xaaab0002, 0x999a0020,
  0x7fff8000, 0x7ffe8000, 0x55555558, 0x33333354,
  0x2aaa8000, 0x2aa8d556, 0xe38f1c74, 0xaaabbbdc,
  0xc4448000, 0xc442088a, 0x5b07a4fc, 0x06d5f94c,
  0x44848000, 0x4481090a, 0xb0b2f9fc, 0x3a705f4c,
  0xc4c40000, 0xc4bf8989, 0x065da452, 0x6e09f880,
  0x45030000, 0x44fd8a07, 0x5c07a3fe, 0xa1a2c4e8,
  0xc5418000, 0xc53b0a84, 0xb1b0f900, 0xd53ac484,
  0xbfff8000, 0xbfff0000, 0xaaaa5558, 0x99993354,
  0x6aaa8000, 0x6aa95556, 0x38e41c74, 0x1111bbdc,
  0x04448000, 0x0442888a, 0xb05ca4fc, 0x6d3bf94c,
  0x84848000, 0x8481890a, 0x0607f9fc, 0xa0d65f4c,
  0x04c40000, 0x04c00989, 0x5bb2a452, 0xd46ff880,
  0x85030000, 0x84fe0a07, 0xb15ca3fe, 0x0808c4e8,
  0x05418000, 0x053b8a84, 0x0705f900, 0x3ba0c484,
  0x85498000, 0x85428a94, 0x5c66a3a0, 0x6ee19144,
  0xaaab0000, 0xaaaa5557, 0x8e39c71e, 0x777888a8,
  0x44450000, 0x4443888b, 0x05b24fa6, 0xd3a2c618,
  0xc4850000, 0xc482890b, 0x5b5da4a6, 0x073d2c18,
  0x44c48000, 0x44c1098a, 0xb1084efc, 0x3ad6c54c,
  0xc5038000, 0xc4ff0a08, 0x06b24ea8, 0x6e6f91b4,
  0x45420000, 0x453c8a85, 0x5c5ba3aa, 0xa2079150,
  0xc54a0000, 0xc5438a95, 0xb1bc4e4a, 0xd5485e10,
  0x454b8000, 0x45440a98, 0x07144e48, 0x087ec474,
  0x999a0000, 0x99993335, 0x7778888a, 0x5c2a3d90,
  0x19da0000, 0x19d833b5, 0xcd23dd8a, 0x8fc4a390,
  0x9a198000, 0x9a16b434, 0x22ce87e0, 0xc35e3cc4,
  0x1a588000, 0x1a54b4b2, 0x7878878c, 0xf6f7092c,
  0x9a970000, 0x9a92352f, 0xce21dc8e, 0x2a8f08c8,
  0x1a9f0000, 0x1a99353f, 0x2382872e, 0x5dcfd588,
  0x9aa08000, 0x9a99b542, 0x78da872c, 0x91063bec,
  0x1aa18000, 0x1a99b544, 0xce31dc80, 0xc43bd584,
  0x80400000, 0x803f0081, 0x55ab5502, 0x339a6620,
  0x007f8000, 0x007d8100, 0xab55ff58, 0x6733ff54,
  0x80be8000, 0x80bb817e, 0x00ffff04, 0x9acccbbc,
  0x00fd0000, 0x00f901fb, 0x56a95406, 0xce64cb58,
  0x81050000, 0x8100020b, 0xac09fea6, 0x01a59818,
  0x01068000, 0x0100820e, 0x0161fea4, 0x34dbfe7c,
  0x81078000, 0x81008210, 0x56b953f8, 0x68119814,
  0x01080000, 0x01000211, 0xac0ffea2, 0x9b4664e0,
  0x803e807f, 0x55aaaa57, 0x33999936, 0x00fec0a0,
  0x007c80fd, 0xab54aa03, 0x6732659e, 0x01fc81a0,
  0x80ba017a, 0x00fdff05, 0x9aca653a, 0x02f94320,
  0x00c1018a, 0x565ea9a5, 0xce0b31fa, 0x03893b20,
  0x80c1818d, 0xabb6a9a3, 0x0141985e, 0x040c39a0,
  0x00c1818f, 0x010dfef7, 0x347731f6, 0x048e38a0,
  0x80c10190, 0x5664a9a1, 0x67abfec2, 0x050f3820,
  0x80c10190, 0x5664a9a1, 0x67abfec2, 0x050f3820,
  0x803e007e, 0x55a9ffad, 0x3398cc6a, 0x00fdc120,
  0x007b80fb, 0xab5354af, 0x6730cc06, 0x01fa82a0,
  0x8082810b, 0x00b3ff4f, 0x9a7198c6, 0x028a7aa0,
  0x0083010e, 0x560bff4d, 0xcda7ff2a, 0x030d7920,
  0x80830110, 0xab6354a1, 0x00dd98c2, 0x038f7820,
  0x00828111, 0x00b9ff4b, 0x3412658e, 0x041077a0,
  0x00828111, 0x00b9ff4b, 0x3412658e, 0x041077a0,
  0x00820110, 0x00b954a1, 0x341198c2, 0x040f7820,
  0x803d807d, 0x55a95503, 0x3397ff9e, 0x00fcc1a0,
  0x0044808d, 0xab09ffa3, 0x66d8cc5e, 0x018cb9a0,
  0x80450090, 0x0061ffa1, 0x9a0f32c2, 0x020fb820,
  0x00450092, 0x55b954f5, 0xcd44cc5a, 0x0291b720,
  0x80448093, 0xab0fff9f, 0x00799926, 0x0312b6a0,
  0x80448093, 0xab0fff9f, 0x00799926, 0x0312b6a0,
  0x80440092, 0xab0f54f5, 0x0078cc5a, 0x0311b720,
  0x80430090, 0xab0dffa1, 0x007732c2, 0x030fb820,
  0x80070010, 0x5560aaa1, 0x3340ccc2, 0x008ff820,
  0x00078013, 0xaab8aa9f, 0x66773326, 0x0112f6a0,
  0x80078015, 0x000ffff3, 0x99acccbe, 0x0194f5a0,
  0x00070016, 0x5566aa9d, 0xcce1998a, 0x0215f520,
  0x00070016, 0x5566aa9d, 0xcce1998a, 0x0215f520,
  0x00068015, 0x5565fff3, 0xcce0ccbe, 0x0214f5a0,
  0x00058013, 0x5564aa9f, 0xccdf3326, 0x0212f6a0,
  0xfffd8003, 0x5559ffff, 0xccd26666, 0x0202fea0,
  0x80008003, 0x5557ffff, 0x33366666, 0x0082fea0,
  0x00008005, 0xaaaf5553, 0x666bfffe, 0x0104fda0,
  0x80000006, 0x0005fffd, 0x99a0ccca, 0x0185fd20,
  0x80000006, 0x0005fffd, 0x99a0ccca, 0x0185fd20,
  0x7fff8005, 0x00055553, 0x999ffffe, 0x0184fda0,
  0x7ffe8003, 0x0003ffff, 0x999e6666, 0x0182fea0,
  0x7ff67ff3, 0xfff9555f, 0x999199a6, 0x017306a0,
  0x7fb7ff76, 0xffa6005d, 0x992d9a0a, 0x00f64520,
  0x80000002, 0x55575555, 0x3335999a, 0x0081ff20,
  0xffff8003, 0xaaadffff, 0x666a6666, 0x0102fea0,
  0xffff8003, 0xaaadffff, 0x666a6666, 0x0102fea0,
  0xffff0002, 0xaaad5555, 0x6669999a, 0x0101ff20,
  0xfffe0000, 0xaaac0001, 0x66680002, 0x01000020,
  0xfff5fff0, 0xaaa15561, 0x665b3342, 0x00f00820,
  0xffb77f73, 0xaa4e005f, 0x65f733a6, 0x007346a0,
  0xff787ef5, 0xa9fa00b3, 0x6592673e, 0xfff585a0,
  0x7fff8001, 0x5556aaab, 0x3334ccce, 0x0080ffa0,
  0x7fff8001, 0x5556aaab, 0x3334ccce, 0x0080ffa0,
  0x7fff0000, 0x55560001, 0x33340002, 0x00800020,
  0x7ffdfffe, 0x5554aaad, 0x3332666a, 0x007e0120,
  0x7ff5ffee, 0x554a000d, 0x332599aa, 0x006e0920,
  0x7fb77f71, 0x54f6ab0b, 0x32c19a0e, 0xfff147a0,
  0x7f787ef3, 0x54a2ab5f, 0x325ccda6, 0xff7386a0,
  0x7f38fe74, 0x544e0109, 0x31f73472, 0xfef4c620,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff7fff, 0xffff5557, 0xffff3336, 0xffff00a0,
  0xfffe7ffd, 0xfffe0003, 0xfffd999e, 0xfffd01a0,
  0xfff67fed, 0xfff35563, 0xfff0ccde, 0xffed09a0,
  0xffb7ff70, 0xffa00061, 0xff8ccd42, 0xff704820,
  0xff78fef2, 0xff4c00b5, 0xff2800da, 0xfef28720,
  0xff397e73, 0xfef7565f, 0xfec267a6, 0xfe73c6a0,
  0xe59fcb40, 0xdcd57881, 0xd5ccf702, 0xcb5a6020,
  0xffff7fff, 0xffff5557, 0xffff3336, 0xffff00a0,
  0xfffe7ffd, 0xfffe0003, 0xfffd999e, 0xfffd01a0,
  0xfff67fed, 0xfff35563, 0xfff0ccde, 0xffed09a0,
  0xffb7ff70, 0xffa00061, 0xff8ccd42, 0xff704820,
  0xff78fef2, 0xff4c00b5, 0xff2800da, 0xfef28720,
  0xff397e73, 0xfef7565f, 0xfec267a6, 0xfe73c6a0,
  0xe59fcb40, 0xdcd57881, 0xd5ccf702, 0xcb5a6020,
  0xbaf4f5eb, 0xa3f25c0f, 0x91893b46, 0x76300aa0,
  0xfffefffe, 0xfffeaaad, 0xfffe666a, 0xfffe0120,
  0xfff6ffee, 0xfff4000d, 0xfff199aa, 0xffee0920,
  0xffb87f71, 0xffa0ab0b, 0xff8d9a0e, 0xff7147a0,
  0xff797ef3, 0xff4cab5f, 0xff28cda6, 0xfef386a0,
  0xff39fe74, 0xfef80109, 0xfec33472, 0xfe74c620,
  0xe5a04b41, 0xdcd6232b, 0xd5cdc3ce, 0xcb5b5fa0,
  0xbaf575ec, 0xa3f306b9, 0x918a0812, 0x76310a20,
  0x7af675ef, 0x4ea006b7, 0x2b266e76, 0xf67408a0,
  0xfff7fff0, 0xfff55561, 0xfff33342, 0xfff00820,
  0xffb97f73, 0xffa2005f, 0xff8f33a6, 0xff7346a0,
  0xff7a7ef5, 0xff4e00b3, 0xff2a673e, 0xfef585a0,
  0xff3afe76, 0xfef9565d, 0xfec4ce0a, 0xfe76c520,
  0xe5a14b43, 0xdcd7787f, 0xd5cf5d66, 0xcb5d5ea0,
  0xbaf675ee, 0xa3f45c0d, 0x918ba1aa, 0x76330920,
  0x7af775f1, 0x4ea15c0b, 0x2b28080e, 0xf67607a0,
  0x3af7f5f3, 0xf94db15f, 0xc4c3a1a6, 0x76b806a0,
  0xffc17f83, 0xffacaaff, 0xff9c0066, 0xff833ea0,
  0xff827f05, 0xff58ab53, 0xff3733fe, 0xff057da0,
  0xff42fe86, 0xff0400fd, 0xfed19aca, 0xfe86bd20,
  0xe5a94b53, 0xdce2231f, 0xd5dc2a26, 0xcb6d56a0,
  0xbafe75fe, 0xa3ff06ad, 0x91986e6a, 0x76430120,
  0x7aff7601, 0x4eac06ab, 0x2b34d4ce, 0xf685ffa0,
  0x3afff603, 0xf9585bff, 0xc4d06e66, 0x76c7fea0,
  0xfafff604, 0xa40406a9, 0x5e6b3b32, 0xf708fe20,
  0xffc0ff82, 0xffac0055, 0xff9b339a, 0xff823f20,
  0xff817f03, 0xff5755ff, 0xff359a66, 0xff037ea0,
  0xe5e7cbd0, 0xdd357821, 0xd64029c2, 0xcbea1820,
  0xbb3cf67b, 0xa4525baf, 0x91fc6e06, 0x76bfc2a0,
  0x7b3df67e, 0x4eff5bad, 0x2b98d46a, 0xf702c120,
  0x3b3e7680, 0xf9abb101, 0xc5346e02, 0x7744c020,
  0xfb3e7681, 0xa4575bab, 0x5ecf3ace, 0xf785bfa0,
  0xbb3df681, 0x4f025bab, 0xf8693ace, 0x77c5bfa0,
  0xffc07f81, 0xffab55ab, 0xff9a66ce, 0xff813fa0,
  0xe626cc4e, 0xdd8977cd, 0xd6a4f62a, 0xcc67d920,
  0xbb7bf6f9, 0xa4a65b5b, 0x92613a6e, 0x773d83a0,
  0x7b7cf6fc, 0x4f535b59, 0x2bfda0d2, 0xf7808220,
  0x3b7d76fe, 0xf9ffb0ad, 0xc5993a6a, 0x77c28120,
  0xfb7d76ff, 0xa4ab5b57, 0x5f340736, 0xf80380a0,
  0xbb7cf6ff, 0x4f565b57, 0xf8ce0736, 0x784380a0,
  0x7b7bf6fe, 0xfa00b0ad, 0x92673a6a, 0xf8828120,
  0xe6664ccd, 0xddde2223, 0xd70a8f5e, 0xcce699a0,
  0xbbbb7778, 0xa4fb05b1, 0x92c6d3a2, 0x77bc4420,
  0x7bbc777b, 0x4fa805af, 0x2c633a06, 0xf7ff42a0,
  0x3bbcf77d, 0xfa545b03, 0xc5fed39e, 0x784141a0,
  0xfbbcf77e, 0xa50005ad, 0x5f99a06a, 0xf8824120,
  0xbbbc777e, 0x4fab05ad, 0xf933a06a, 0x78c24120,
  0x7bbb777d, 0xfa555b03, 0x92ccd39e, 0xf90141a0,
  0x2665ccd3, 0x888f221f, 0x0a455c26, 0x4eac96a0,
  0xd5552aab, 0xc71ce38f, 0xbbbc4446, 0xaad5aaa0,
  0x95562aae, 0x71c9e38d, 0x5558aaaa, 0x2b18a920,
  0x5556aab0, 0x1c7638e1, 0xeef44442, 0xab5aa820,
  0x1556aab1, 0xc721e38b, 0x888f110e, 0x2b9ba7a0,
  0xd5562ab1, 0x71cce38b, 0x2229110e, 0xabdba7a0,
  0x95552ab0, 0x1c7738e1, 0xbbc24442, 0x2c1aa820,
  0x3fff8006, 0xaab0fffd, 0x333accca, 0x81c5fd20,
  0xd998b33a, 0x22298885, 0x8f650a3a, 0xb5606320,
  0xc0010003, 0xaaacffff, 0x999c6666, 0x8042fea0,
  0x80018005, 0x55595553, 0x3337fffe, 0x0084fda0,
  0x40018006, 0x0004fffd, 0xccd2ccca, 0x80c5fd20,
  0x00010006, 0xaaaffffd, 0x666cccca, 0x0105fd20,
  0xc0000005, 0x555a5553, 0x0005fffe, 0x8144fda0,
  0x6aaa555b, 0xe3941c6f, 0x777e8886, 0xd6f052a0,
  0x0443888f, 0x5b0ca4f7, 0xd3a8c5f6, 0x0a8ab8a0,
  0x8482890f, 0xb0b7f9f7, 0x07432bf6, 0x0b8a78a0,
  0xc0008002, 0xaaac5555, 0x999b999a, 0x8041ff20,
  0x80008003, 0x5557ffff, 0x33366666, 0x0082fea0,
  0x40000003, 0x0002ffff, 0xccd06666, 0x80c2fea0,
  0xffff0002, 0xaaad5555, 0x6669999a, 0x0101ff20,
  0xaaa95558, 0x38e71c71, 0xdde22222, 0x56ad5420,
  0x4442888c, 0xb05fa4f9, 0x3a0c5f92, 0x8a47ba20,
  0xc481890c, 0x060af9f9, 0x6da6c592, 0x8b477a20,
  0x44c0098b, 0x5bb5a44f, 0xa1405ec6, 0x8c463aa0,
  0xc0000001, 0xaaabaaab, 0x999accce, 0x8040ffa0,
  0x7fff8001, 0x5556aaab, 0x3334ccce, 0x0080ffa0,
  0x3ffe8000, 0x00010001, 0xccce0002, 0x80c00020,
  0xeaa8d556, 0x8e3ac71d, 0x4446888a, 0xd66b5520,
  0x8442088a, 0x05b34fa5, 0xa070c5fa, 0x0a05bb20,
  0x0481090a, 0x5b5ea4a5, 0xd40b2bfa, 0x0b057b20,
  0x84bf8989, 0xb1094efb, 0x07a4c52e, 0x0c043ba0,
  0x04fd8a07, 0x06b34ea7, 0x3b3d9196, 0x0d01fca0,
  0xbfff8000, 0xaaab0001, 0x999a0002, 0x80400020,
  0x7ffe7fff, 0x55555557, 0x33333336, 0x007f00a0,
  0x2aa8d555, 0xe38f1c73, 0xaaabbbbe, 0x562a55a0,
  0xc4420889, 0x5b07a4fb, 0x06d5f92e, 0x89c4bba0,
  0x44810909, 0xb0b2f9fb, 0x3a705f2e, 0x8ac47ba0,
  0xc4bf8988, 0x065da451, 0x6e09f862, 0x8bc33c20,
  0x44fd8a06, 0x5c07a3fd, 0xa1a2c4ca, 0x8cc0fd20,
  0xc53b0a83, 0xb1b0f8ff, 0xd53ac466, 0x8dbdbea0,
  0xbffeffff, 0xaaaa5557, 0x99993336, 0x803f00a0,
  0x6aa95555, 0x38e41c73, 0x1111bbbe, 0xd5ea55a0,
  0x04428889, 0xb05ca4fb, 0x6d3bf92e, 0x0984bba0,
  0x84818909, 0x0607f9fb, 0xa0d65f2e, 0x0a847ba0,
  0x04c00988, 0x5bb2a451, 0xd46ff862, 0x0b833c20,
  0x84fe0a06, 0xb15ca3fd, 0x0808c4ca, 0x0c80fd20,
  0x053b8a83, 0x0705f8ff, 0x3ba0c466, 0x0d7dbea0,
  0x85428a93, 0x5c66a39f, 0x6ee19126, 0x0e0db6a0,
  0xaaaa5556, 0x8e39c71d, 0x7778888a, 0x55ab5520,
  0x4443888a, 0x05b24fa5, 0xd3a2c5fa, 0x8945bb20,
  0xc482890a, 0x5b5da4a5, 0x073d2bfa, 0x8a457b20,
  0x44c10989, 0xb1084efb, 0x3ad6c52e, 0x8b443ba0,
  0xc4ff0a07, 0x06b24ea7, 0x6e6f9196, 0x8c41fca0,
  0x453c8a84, 0x5c5ba3a9, 0xa2079132, 0x8d3ebe20,
  0xc5438a94, 0xb1bc4e49, 0xd5485df2, 0x8dceb620,
  0x45440a97, 0x07144e47, 0x087ec456, 0x8e51b4a0,
  0x99993334, 0x77788889, 0x5c2a3d72, 0x339a6620,
  0x19d833b4, 0xcd23dd89, 0x8fc4a372, 0x349a2620,
  0x9a16b433, 0x22ce87df, 0xc35e3ca6, 0x3598e6a0,
  0x1a54b4b1, 0x7878878b, 0xf6f7090e, 0x3696a7a0,
  0x9a92352e, 0xce21dc8d, 0x2a8f08aa, 0x37936920,
  0x1a99353e, 0x2382872d, 0x5dcfd56a, 0x38236120,
  0x9a99b541, 0x78da872b, 0x91063bce, 0x38a65fa0,
  0x1a99b543, 0xce31dc7f, 0xc43bd566, 0x39285ea0,
  0x803f0080, 0x55ab5501, 0x339a6602, 0x00ffc020,
  0x007d80ff, 0xab55ff57, 0x6733ff36, 0x01fe80a0,
  0x80bb817d, 0x00ffff03, 0x9acccb9e, 0x02fc41a0,
  0x00f901fa, 0x56a95405, 0xce64cb3a, 0x03f90320,
  0x8100020a, 0xac09fea5, 0x01a597fa, 0x0488fb20,
  0x0100820d, 0x0161fea3, 0x34dbfe5e, 0x050bf9a0,
  0x8100820f, 0x56b953f7, 0x681197f6, 0x058df8a0,
  0x01000210, 0xac0ffea1, 0x9b4664c2, 0x060ef820,
  0x55aaaa56, 0x33999935, 0x00fec082, 0x00fdc11f,
  0xab54aa02, 0x6732659d, 0x01fc8182, 0x01fa829d,
  0x00fdff04, 0x9aca6539, 0x02f94302, 0x02f6449a,
  0x565ea9a4, 0xce0b31f9, 0x03893b02, 0x03853caa,
  0xabb6a9a2, 0x0141985d, 0x040c3982, 0x04073b2d,
  0x010dfef6, 0x347731f5, 0x048e3882, 0x04883a2f,
  0x5664a9a0, 0x67abfec1, 0x050f3802, 0x050839b0,
  0x5664a9a0, 0x67abfec1, 0x050f3802, 0x050839b0,
  0x55a9ffac, 0x3398cc69, 0x00fdc102, 0x00fcc19e,
  0xab5354ae, 0x6730cc05, 0x01fa8282, 0x01f8839b,
  0x00b3ff4e, 0x9a7198c5, 0x028a7a82, 0x02877bab,
  0x560bff4c, 0xcda7ff29, 0x030d7902, 0x03097a2e,
  0xab6354a0, 0x00dd98c1, 0x038f7802, 0x038a7930,
  0x00b9ff4a, 0x3412658d, 0x04107782, 0x040a78b1,
  0x00b9ff4a, 0x3412658d, 0x04107782, 0x040a78b1,
  0x00b954a0, 0x341198c1, 0x040f7802, 0x04097930,
  0x55a95502, 0x3397ff9d, 0x00fcc182, 0x00fbc21d,
  0xab09ffa2, 0x66d8cc5d, 0x018cb982, 0x018aba2d,
  0x0061ffa0, 0x9a0f32c1, 0x020fb802, 0x020cb8b0,
  0x55b954f4, 0xcd44cc59, 0x0291b702, 0x028db7b2,
  0xab0fff9e, 0x00799925, 0x0312b682, 0x030db733,
  0xab0fff9e, 0x00799925, 0x0312b682, 0x030db733,
  0xab0f54f4, 0x0078cc59, 0x0311b702, 0x030cb7b2,
  0xab0dffa0, 0x007732c1, 0x030fb802, 0x030ab8b0,
  0x5560aaa0, 0x3340ccc1, 0x008ff802, 0x008ef830,
  0xaab8aa9e, 0x66773325, 0x0112f682, 0x0110f6b3,
  0x000ffff2, 0x99acccbd, 0x0194f582, 0x0191f5b5,
  0x5566aa9c, 0xcce19989, 0x0215f502, 0x0211f536,
  0x5566aa9c, 0xcce19989, 0x0215f502, 0x0211f536,
  0x5565fff2, 0xcce0ccbd, 0x0214f582, 0x0210f5b5,
  0x5564aa9e, 0xccdf3325, 0x0212f682, 0x020ef6b3,
  0x5559fffe, 0xccd26665, 0x0202fe82, 0x01fefea3,
  0x5557fffe, 0x33366665, 0x0082fe82, 0x0081fea3,
  0xaaaf5552, 0x666bfffd, 0x0104fd82, 0x0102fda5,
  0x0005fffc, 0x99a0ccc9, 0x0185fd02, 0x0182fd26,
  0x0005fffc, 0x99a0ccc9, 0x0185fd02, 0x0182fd26,
  0x00055552, 0x999ffffd, 0x0184fd82, 0x0181fda5,
  0x0003fffe, 0x999e6665, 0x0182fe82, 0x017ffea3,
  0xfff9555e, 0x999199a5, 0x01730682, 0x01700693,
  0xffa6005c, 0x992d9a09, 0x00f64502, 0x00f34496,
  0x55575554, 0x33359999, 0x0081ff02, 0x0080ff22,
  0xaaadfffe, 0x666a6665, 0x0102fe82, 0x0100fea3,
  0xaaadfffe, 0x666a6665, 0x0102fe82, 0x0100fea3,
  0xaaad5554, 0x66699999, 0x0101ff02, 0x00ffff22,
  0xaaac0000, 0x66680001, 0x01000002, 0x00fe0020,
  0xaaa15560, 0x665b3341, 0x00f00802, 0x00ee0810,
  0xaa4e005e, 0x65f733a5, 0x00734682, 0x00714613,
  0xa9fa00b2, 0x6592673d, 0xfff58582, 0xfff38495,
  0x5556aaaa, 0x3334cccd, 0x0080ff82, 0x007fffa1,
  0x5556aaaa, 0x3334cccd, 0x0080ff82, 0x007fffa1,
  0x55560000, 0x33340001, 0x00800002, 0x007f0020,
  0x5554aaac, 0x33326669, 0x007e0102, 0x007d011e,
  0x554a000c, 0x332599a9, 0x006e0902, 0x006d090e,
  0x54f6ab0a, 0x32c19a0d, 0xfff14782, 0xfff04711,
  0x54a2ab5e, 0x325ccda5, 0xff738682, 0xff728593,
  0x544e0108, 0x31f73471, 0xfef4c602, 0xfef3c494,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff5556, 0xffff3335, 0xffff0082, 0xffff009f,
  0xfffe0002, 0xfffd999d, 0xfffd0182, 0xfffd019d,
  0xfff35562, 0xfff0ccdd, 0xffed0982, 0xffed098d,
  0xffa00060, 0xff8ccd41, 0xff704802, 0xff704790,
  0xff4c00b4, 0xff2800d9, 0xfef28702, 0xfef28612,
  0xfef7565e, 0xfec267a5, 0xfe73c682, 0xfe73c513,
  0xdcd57880, 0xd5ccf701, 0xcb5a6002, 0xcb5a2b60,
  0xffff5556, 0xffff3335, 0xffff0082, 0xffff009f,
  0xfffe0002, 0xfffd999d, 0xfffd0182, 0xfffd019d,
  0xfff35562, 0xfff0ccdd, 0xffed0982, 0xffed098d,
  0xffa00060, 0xff8ccd41, 0xff704802, 0xff704790,
  0xff4c00b4, 0xff2800d9, 0xfef28702, 0xfef28612,
  0xfef7565e, 0xfec267a5, 0xfe73c682, 0xfe73c513,
  0xdcd57880, 0xd5ccf701, 0xcb5a6002, 0xcb5a2b60,
  0xa3f25c0e, 0x91893b45, 0x76300a82, 0x762f808b,
  0xfffeaaac, 0xfffe6669, 0xfffe0102, 0xfffe011e,
  0xfff4000c, 0xfff199a9, 0xffee0902, 0xffee090e,
  0xffa0ab0a, 0xff8d9a0d, 0xff714782, 0xff714711,
  0xff4cab5e, 0xff28cda5, 0xfef38682, 0xfef38593,
  0xfef80108, 0xfec33471, 0xfe74c602, 0xfe74c494,
  0xdcd6232a, 0xd5cdc3cd, 0xcb5b5f82, 0xcb5b2ae1,
  0xa3f306b8, 0x918a0811, 0x76310a02, 0x7630800c,
  0x4ea006b6, 0x2b266e75, 0xf6740882, 0xf672fe8f,
  0xfff55560, 0xfff33341, 0xfff00802, 0xfff00810,
  0xffa2005e, 0xff8f33a5, 0xff734682, 0xff734613,
  0xff4e00b2, 0xff2a673d, 0xfef58582, 0xfef58495,
  0xfef9565c, 0xfec4ce09, 0xfe76c502, 0xfe76c396,
  0xdcd7787e, 0xd5cf5d65, 0xcb5d5e82, 0xcb5d29e3,
  0xa3f45c0c, 0x918ba1a9, 0x76330902, 0x76327f0e,
  0x4ea15c0a, 0x2b28080d, 0xf6760782, 0xf674fd91,
  0xf94db15e, 0xc4c3a1a5, 0x76b80682, 0x76b67c93,
  0xffacaafe, 0xff9c0065, 0xff833e82, 0xff833e23,
  0xff58ab52, 0xff3733fd, 0xff057d82, 0xff057ca5,
  0xff0400fc, 0xfed19ac9, 0xfe86bd02, 0xfe86bba6,
  0xdce2231e, 0xd5dc2a25, 0xcb6d5682, 0xcb6d21f3,
  0xa3ff06ac, 0x91986e69, 0x76430102, 0x7642771e,
  0x4eac06aa, 0x2b34d4cd, 0xf685ff82, 0xf684f5a1,
  0xf9585bfe, 0xc4d06e65, 0x76c7fe82, 0x76c674a3,
  0xa40406a8, 0x5e6b3b31, 0xf708fe02, 0xf706f424,
  0xffac0054, 0xff9b3399, 0xff823f02, 0xff823ea2,
  0xff5755fe, 0xff359a65, 0xff037e82, 0xff037da3,
  0xdd357820, 0xd64029c1, 0xcbea1802, 0xcbe9e3f0,
  0xa4525bae, 0x91fc6e05, 0x76bfc282, 0x76bf391b,
  0x4eff5bac, 0x2b98d469, 0xf702c102, 0xf701b79e,
  0xf9abb100, 0xc5346e01, 0x7744c002, 0x774336a0,
  0xa4575baa, 0x5ecf3acd, 0xf785bf82, 0xf783b621,
  0x4f025baa, 0xf8693acd, 0x77c5bf82, 0x77c33621,
  0xffab55aa, 0xff9a66cd, 0xff813f82, 0xff813f21,
  0xdd8977cc, 0xd6a4f629, 0xcc67d902, 0xcc67a56e,
  0xa4a65b5a, 0x92613a6d, 0x773d8382, 0x773cfa99,
  0x4f535b58, 0x2bfda0d1, 0xf7808202, 0xf77f791c,
  0xf9ffb0ac, 0xc5993a69, 0x77c28102, 0x77c0f81e,
  0xa4ab5b56, 0x5f340735, 0xf8038082, 0xf801779f,
  0x4f565b56, 0xf8ce0735, 0x78438082, 0x7840f79f,
  0xfa00b0ac, 0x92673a69, 0xf8828102, 0xf87f781e,
  0xddde2222, 0xd70a8f5d, 0xcce69982, 0xcce6666d,
  0xa4fb05b0, 0x92c6d3a1, 0x77bc4402, 0x77bbbb98,
  0x4fa805ae, 0x2c633a05, 0xf7ff4282, 0xf7fe3a1b,
  0xfa545b02, 0xc5fed39d, 0x78414182, 0x783fb91d,
  0xa50005ac, 0x5f99a069, 0xf8824102, 0xf880389e,
  0x4fab05ac, 0xf933a069, 0x78c24102, 0x78bfb89e,
  0xfa555b02, 0x92ccd39d, 0xf9014182, 0xf8fe391d,
  0x888f221e, 0x0a455c25, 0x4eac9682, 0x4ea8e373,
  0xc71ce38e, 0xbbbc4445, 0xaad5aa82, 0xaad5554b,
  0x71c9e38c, 0x5558aaa9, 0x2b18a902, 0x2b17d3ce,
  0x1c7638e0, 0xeef44441, 0xab5aa802, 0xab5952d0,
  0xc721e38a, 0x888f110d, 0x2b9ba782, 0x2b99d251,
  0x71cce38a, 0x2229110d, 0xabdba782, 0xabd95251,
  0x1c7738e0, 0xbbc24441, 0x2c1aa802, 0x2c17d2d0,
  0xaab0fffc, 0x333accc9, 0x81c5fd02, 0x81c27d26,
  0x22298884, 0x8f650a39, 0xb5606302, 0xb55c165a,
  0xaaacfffe, 0x999c6665, 0x8042fe82, 0x80427ea3,
  0x55595552, 0x3337fffd, 0x0084fd82, 0x0083fda5,
  0x0004fffc, 0xccd2ccc9, 0x80c5fd02, 0x80c47d26,
  0xaaaffffc, 0x666cccc9, 0x0105fd02, 0x0103fd26,
  0x555a5552, 0x0005fffd, 0x8144fd82, 0x81427da5,
  0xe3941c6e, 0x777e8885, 0xd6f05282, 0xd6ed27fb,
  0x5b0ca4f6, 0xd3a8c5f5, 0x0a8ab882, 0x0a86c12f,
  0xb0b7f9f6, 0x07432bf5, 0x0b8a7882, 0x0b8581af,
  0xaaac5554, 0x999b9999, 0x8041ff02, 0x80417f22,
  0x5557fffe, 0x33366665, 0x0082fe82, 0x0081fea3,
  0x0002fffe, 0xccd06665, 0x80c2fe82, 0x80c17ea3,
  0xaaad5554, 0x66699999, 0x0101ff02, 0x00ffff22,
  0x38e71c70, 0xdde22221, 0x56ad5402, 0x56aaa978,
  0xb05fa4f8, 0x3a0c5f91, 0x8a47ba02, 0x8a4442ac,
  0x060af9f8, 0x6da6c591, 0x8b477a02, 0x8b43032c,
  0x5bb5a44e, 0xa1405ec5, 0x8c463a82, 0x8c40c42b,
  0xaaabaaaa, 0x999acccd, 0x8040ff82, 0x80407fa1,
  0x5556aaaa, 0x3334cccd, 0x0080ff82, 0x007fffa1,
  0x00010000, 0xccce0001, 0x80c00002, 0x80be8020,
  0x8e3ac71c, 0x44468889, 0xd66b5502, 0xd6692a76,
  0x05b34fa4, 0xa070c5f9, 0x0a05bb02, 0x0a02c3aa,
  0x5b5ea4a4, 0xd40b2bf9, 0x0b057b02, 0x0b01842a,
  0xb1094efa, 0x07a4c52d, 0x0c043b82, 0x0bff4529,
  0x06b34ea6, 0x3b3d9195, 0x0d01fc82, 0x0cfc06a7,
  0xaaab0000, 0x999a0001, 0x80400002, 0x803f8020,
  0x55555556, 0x33333335, 0x007f0082, 0x007e009f,
  0xe38f1c72, 0xaaabbbbd, 0x562a5582, 0x5628aaf5,
  0x5b07a4fa, 0x06d5f92d, 0x89c4bb82, 0x89c24429,
  0xb0b2f9fa, 0x3a705f2d, 0x8ac47b82, 0x8ac104a9,
  0x065da450, 0x6e09f861, 0x8bc33c02, 0x8bbec5a8,
  0x5c07a3fc, 0xa1a2c4c9, 0x8cc0fd02, 0x8cbb8726,
  0xb1b0f8fe, 0xd53ac465, 0x8dbdbe82, 0x8db74923,
  0xaaaa5556, 0x99993335, 0x803f0082, 0x803e809f,
  0x38e41c72, 0x1111bbbd, 0xd5ea5582, 0xd5e92af5,
  0xb05ca4fa, 0x6d3bf92d, 0x0984bb82, 0x0982c429,
  0x0607f9fa, 0xa0d65f2d, 0x0a847b82, 0x0a8184a9,
  0x5bb2a450, 0xd46ff861, 0x0b833c02, 0x0b7f45a8,
  0xb15ca3fc, 0x0808c4c9, 0x0c80fd02, 0x0c7c0726,
  0x0705f8fe, 0x3ba0c465, 0x0d7dbe82, 0x0d77c923,
  0x5c66a39e, 0x6ee19125, 0x0e0db682, 0x0e06c133,
  0x8e39c71c, 0x77788889, 0x55ab5502, 0x55aaaa76,
  0x05b24fa4, 0xd3a2c5f9, 0x8945bb02, 0x894443aa,
  0x5b5da4a4, 0x073d2bf9, 0x8a457b02, 0x8a43042a,
  0xb1084efa, 0x3ad6c52d, 0x8b443b82, 0x8b40c529,
  0x06b24ea6, 0x6e6f9195, 0x8c41fc82, 0x8c3d86a7,
  0x5c5ba3a8, 0xa2079131, 0x8d3ebe02, 0x8d3948a4,
  0xb1bc4e48, 0xd5485df1, 0x8dceb602, 0x8dc840b4,
  0x07144e46, 0x087ec455, 0x8e51b482, 0x8e4a3f37,
  0x77788888, 0x5c2a3d71, 0x339a6602, 0x33999954,
  0xcd23dd88, 0x8fc4a371, 0x349a2602, 0x349859d4,
  0x22ce87de, 0xc35e3ca5, 0x3598e682, 0x35961ad3,
  0x7878878a, 0xf6f7090d, 0x3696a782, 0x3692dc51,
  0xce21dc8c, 0x2a8f08a9, 0x37936902, 0x378e9e4e,
  0x2382872c, 0x5dcfd569, 0x38236102, 0x381d965e,
  0x78da872a, 0x91063bcd, 0x38a65f82, 0x389f94e1,
  0xce31dc7e, 0xc43bd565, 0x39285e82, 0x392093e3,
  0x55ab5500, 0x339a6601, 0x00ffc002, 0x00fec0a0,
  0xab55ff56, 0x6733ff35, 0x01fe8082, 0x01fc819f,
  0x00ffff02, 0x9acccb9d, 0x02fc4182, 0x02f9431d,
  0x56a95404, 0xce64cb39, 0x03f90302, 0x03f5051a,
  0xac09fea4, 0x01a597f9, 0x0488fb02, 0x0483fd2a,
  0x0161fea2, 0x34dbfe5d, 0x050bf982, 0x0505fbad,
  0x56b953f6, 0x681197f5, 0x058df882, 0x0586faaf,
  0xac0ffea0, 0x9b4664c1, 0x060ef802, 0x0606fa30,
  0x33999934, 0x00fec081, 0x00fdc101, 0x00fcc19e,
  0x6732659c, 0x01fc8181, 0x01fa827f, 0x01f8839a,
  0x9aca6538, 0x02f94301, 0x02f6447c, 0x02f34614,
  0xce0b31f8, 0x03893b01, 0x03853c8c, 0x03813e34,
  0x0141985c, 0x040c3981, 0x04073b0f, 0x04023cba,
  0x347731f4, 0x048e3881, 0x04883a11, 0x04823bbe,
  0x67abfec0, 0x050f3801, 0x05083992, 0x05013b40,
  0x67abfec0, 0x050f3801, 0x05083992, 0x05013b40,
  0x3398cc68, 0x00fdc101, 0x00fcc180, 0x00fbc21c,
  0x6730cc04, 0x01fa8281, 0x01f8837d, 0x01f68496,
  0x9a7198c4, 0x028a7a81, 0x02877b8d, 0x02847cb6,
  0xcda7ff28, 0x030d7901, 0x03097a10, 0x03057b3c,
  0x00dd98c0, 0x038f7801, 0x038a7912, 0x03857a40,
  0x3412658c, 0x04107781, 0x040a7893, 0x040479c2,
  0x3412658c, 0x04107781, 0x040a7893, 0x040479c2,
  0x341198c0, 0x040f7801, 0x04097912, 0x04037a40,
  0x3397ff9c, 0x00fcc181, 0x00fbc1ff, 0x00fac29a,
  0x66d8cc5c, 0x018cb981, 0x018aba0f, 0x0188baba,
  0x9a0f32c0, 0x020fb801, 0x020cb892, 0x0209b940,
  0xcd44cc58, 0x0291b701, 0x028db794, 0x0289b844,
  0x00799924, 0x0312b681, 0x030db715, 0x0308b7c6,
  0x00799924, 0x0312b681, 0x030db715, 0x0308b7c6,
  0x0078cc58, 0x0311b701, 0x030cb794, 0x0307b844,
  0x007732c0, 0x030fb801, 0x030ab892, 0x0305b940,
  0x3340ccc0, 0x008ff801, 0x008ef812, 0x008df840,
  0x66773324, 0x0112f681, 0x0110f695, 0x010ef6c6,
  0x99acccbc, 0x0194f581, 0x0191f597, 0x018ef5ca,
  0xcce19988, 0x0215f501, 0x0211f518, 0x020df54c,
  0xcce19988, 0x0215f501, 0x0211f518, 0x020df54c,
  0xcce0ccbc, 0x0214f581, 0x0210f597, 0x020cf5ca,
  0xccdf3324, 0x0212f681, 0x020ef695, 0x020af6c6,
  0xccd26664, 0x0202fe81, 0x01fefe85, 0x01fafea6,
  0x33366664, 0x0082fe81, 0x0081fe85, 0x0080fea6,
  0x666bfffc, 0x0104fd81, 0x0102fd87, 0x0100fdaa,
  0x99a0ccc8, 0x0185fd01, 0x0182fd08, 0x017ffd2c,
  0x99a0ccc8, 0x0185fd01, 0x0182fd08, 0x017ffd2c,
  0x999ffffc, 0x0184fd81, 0x0181fd87, 0x017efdaa,
  0x999e6664, 0x0182fe81, 0x017ffe85, 0x017cfea6,
  0x999199a4, 0x01730681, 0x01700675, 0x016d0686,
  0x992d9a08, 0x00f64501, 0x00f34478, 0x00f0440c,
  0x33359998, 0x0081ff01, 0x0080ff04, 0x007fff24,
  0x666a6664, 0x0102fe81, 0x0100fe85, 0x00fefea6,
  0x666a6664, 0x0102fe81, 0x0100fe85, 0x00fefea6,
  0x66699998, 0x0101ff01, 0x00ffff04, 0x00fdff24,
  0x66680000, 0x01000001, 0x00fe0002, 0x00fc0020,
  0x665b3340, 0x00f00801, 0x00ee07f2, 0x00ec0800,
  0x65f733a4, 0x00734681, 0x007145f5, 0x006f4586,
  0x6592673c, 0xfff58581, 0xfff38477, 0xfff1838a,
  0x3334cccc, 0x0080ff81, 0x007fff83, 0x007effa2,
  0x3334cccc, 0x0080ff81, 0x007fff83, 0x007effa2,
  0x33340000, 0x00800001, 0x007f0002, 0x007e0020,
  0x33326668, 0x007e0101, 0x007d0100, 0x007c011c,
  0x332599a8, 0x006e0901, 0x006d08f0, 0x006c08fc,
  0x32c19a0c, 0xfff14781, 0xfff046f3, 0xffef4682,
  0x325ccda4, 0xff738681, 0xff728575, 0xff718486,
  0x31f73470, 0xfef4c601, 0xfef3c476, 0xfef2c308,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff3334, 0xffff0081, 0xffff0081, 0xffff009e,
  0xfffd999c, 0xfffd0181, 0xfffd017f, 0xfffd019a,
  0xfff0ccdc, 0xffed0981, 0xffed096f, 0xffed097a,
  0xff8ccd40, 0xff704801, 0xff704772, 0xff704700,
  0xff2800d8, 0xfef28701, 0xfef285f4, 0xfef28504,
  0xfec267a4, 0xfe73c681, 0xfe73c4f5, 0xfe73c386,
  0xd5ccf700, 0xcb5a6001, 0xcb5a2b42, 0xcb59f6a0,
  0xffff3334, 0xffff0081, 0xffff0081, 0xffff009e,
  0xfffd999c, 0xfffd0181, 0xfffd017f, 0xfffd019a,
  0xfff0ccdc, 0xffed0981, 0xffed096f, 0xffed097a,
  0xff8ccd40, 0xff704801, 0xff704772, 0xff704700,
  0xff2800d8, 0xfef28701, 0xfef285f4, 0xfef28504,
  0xfec267a4, 0xfe73c681, 0xfe73c4f5, 0xfe73c386,
  0xd5ccf700, 0xcb5a6001, 0xcb5a2b42, 0xcb59f6a0,
  0x91893b44, 0x76300a81, 0x762f806d, 0x762ef676,
  0xfffe6668, 0xfffe0101, 0xfffe0100, 0xfffe011c,
  0xfff199a8, 0xffee0901, 0xffee08f0, 0xffee08fc,
  0xff8d9a0c, 0xff714781, 0xff7146f3, 0xff714682,
  0xff28cda4, 0xfef38681, 0xfef38575, 0xfef38486,
  0xfec33470, 0xfe74c601, 0xfe74c476, 0xfe74c308,
  0xd5cdc3cc, 0xcb5b5f81, 0xcb5b2ac3, 0xcb5af622,
  0x918a0810, 0x76310a01, 0x76307fee, 0x762ff5f8,
  0x2b266e74, 0xf6740881, 0xf672fe71, 0xf671f47e,
  0xfff33340, 0xfff00801, 0xfff007f2, 0xfff00800,
  0xff8f33a4, 0xff734681, 0xff7345f5, 0xff734586,
  0xff2a673c, 0xfef58581, 0xfef58477, 0xfef5838a,
  0xfec4ce08, 0xfe76c501, 0xfe76c378, 0xfe76c20c,
  0xd5cf5d64, 0xcb5d5e81, 0xcb5d29c5, 0xcb5cf526,
  0x918ba1a8, 0x76330901, 0x76327ef0, 0x7631f4fc,
  0x2b28080c, 0xf6760781, 0xf674fd73, 0xf673f382,
  0xc4c3a1a4, 0x76b80681, 0x76b67c75, 0x76b4f286,
  0xff9c0064, 0xff833e81, 0xff833e05, 0xff833da6,
  0xff3733fc, 0xff057d81, 0xff057c87, 0xff057baa,
  0xfed19ac8, 0xfe86bd01, 0xfe86bb88, 0xfe86ba2c,
  0xd5dc2a24, 0xcb6d5681, 0xcb6d21d5, 0xcb6ced46,
  0x91986e68, 0x76430101, 0x76427700, 0x7641ed1c,
  0x2b34d4cc, 0xf685ff81, 0xf684f583, 0xf683eba2,
  0xc4d06e64, 0x76c7fe81, 0x76c67485, 0x76c4eaa6,
  0x5e6b3b30, 0xf708fe01, 0xf706f406, 0xf704ea28,
  0xff9b3398, 0xff823f01, 0xff823e84, 0xff823e24,
  0xff359a64, 0xff037e81, 0xff037d85, 0xff037ca6,
  0xd64029c0, 0xcbea1801, 0xcbe9e3d2, 0xcbe9afc0,
  0x91fc6e04, 0x76bfc281, 0x76bf38fd, 0x76beaf96,
  0x2b98d468, 0xf702c101, 0xf701b780, 0xf700ae1c,
  0xc5346e00, 0x7744c001, 0x77433682, 0x7741ad20,
  0x5ecf3acc, 0xf785bf81, 0xf783b603, 0xf781aca2,
  0xf8693acc, 0x77c5bf81, 0x77c33603, 0x77c0aca2,
  0xff9a66cc, 0xff813f81, 0xff813f03, 0xff813ea2,
  0xd6a4f628, 0xcc67d901, 0xcc67a550, 0xcc6771bc,
  0x92613a6c, 0x773d8381, 0x773cfa7b, 0x773c7192,
  0x2bfda0d0, 0xf7808201, 0xf77f78fe, 0xf77e7018,
  0xc5993a68, 0x77c28101, 0x77c0f800, 0x77bf6f1c,
  0x5f340734, 0xf8038081, 0xf8017781, 0xf7ff6e9e,
  0xf8ce0734, 0x78438081, 0x7840f781, 0x783e6e9e,
  0x92673a68, 0xf8828101, 0xf87f7800, 0xf87c6f1c,
  0xd70a8f5c, 0xcce69981, 0xcce6664f, 0xcce6333a,
  0x92c6d3a0, 0x77bc4401, 0x77bbbb7a, 0x77bb3310,
  0x2c633a04, 0xf7ff4281, 0xf7fe39fd, 0xf7fd3196,
  0xc5fed39c, 0x78414181, 0x783fb8ff, 0x783e309a,
  0x5f99a068, 0xf8824101, 0xf8803880, 0xf87e301c,
  0xf933a068, 0x78c24101, 0x78bfb880, 0x78bd301c,
  0x92ccd39c, 0xf9014181, 0xf8fe38ff, 0xf8fb309a,
  0x0a455c24, 0x4eac9681, 0x4ea8e355, 0x4ea53046,
  0xbbbc4444, 0xaad5aa81, 0xaad5552d, 0xaad4fff6,
  0x5558aaa8, 0x2b18a901, 0x2b17d3b0, 0x2b16fe7c,
  0xeef44440, 0xab5aa801, 0xab5952b2, 0xab57fd80,
  0x888f110c, 0x2b9ba781, 0x2b99d233, 0x2b97fd02,
  0x2229110c, 0xabdba781, 0xabd95233, 0xabd6fd02,
  0xbbc24440, 0x2c1aa801, 0x2c17d2b2, 0x2c14fd80,
  0x333accc8, 0x81c5fd01, 0x81c27d08, 0x81befd2c,
  0x8f650a38, 0xb5606301, 0xb55c163c, 0xb557c994,
  0x999c6664, 0x8042fe81, 0x80427e85, 0x8041fea6,
  0x3337fffc, 0x0084fd81, 0x0083fd87, 0x0082fdaa,
  0xccd2ccc8, 0x80c5fd01, 0x80c47d08, 0x80c2fd2c,
  0x666cccc8, 0x0105fd01, 0x0103fd08, 0x0101fd2c,
  0x0005fffc, 0x8144fd81, 0x81427d87, 0x813ffdaa,
  0x777e8884, 0xd6f05281, 0xd6ed27dd, 0xd6e9fd56,
  0xd3a8c5f4, 0x0a8ab881, 0x0a86c111, 0x0a82c9be,
  0x07432bf4, 0x0b8a7881, 0x0b858191, 0x0b808abe,
  0x999b9998, 0x8041ff01, 0x80417f04, 0x8040ff24,
  0x33366664, 0x0082fe81, 0x0081fe85, 0x0080fea6,
  0xccd06664, 0x80c2fe81, 0x80c17e85, 0x80bffea6,
  0x66699998, 0x0101ff01, 0x00ffff04, 0x00fdff24,
  0xdde22220, 0x56ad5401, 0x56aaa95a, 0x56a7fed0,
  0x3a0c5f90, 0x8a47ba01, 0x8a44428e, 0x8a40cb38,
  0x6da6c590, 0x8b477a01, 0x8b43030e, 0x8b3e8c38,
  0xa1405ec4, 0x8c463a81, 0x8c40c40d, 0x8c3b4db6,
  0x999acccc, 0x8040ff81, 0x80407f83, 0x803fffa2,
  0x3334cccc, 0x0080ff81, 0x007fff83, 0x007effa2,
  0xccce0000, 0x80c00001, 0x80be8002, 0x80bd0020,
  0x44468888, 0xd66b5501, 0xd6692a58, 0xd666ffcc,
  0xa070c5f8, 0x0a05bb01, 0x0a02c38c, 0x09ffcc34,
  0xd40b2bf8, 0x0b057b01, 0x0b01840c, 0x0afd8d34,
  0x07a4c52c, 0x0c043b81, 0x0bff450b, 0x0bfa4eb2,
  0x3b3d9194, 0x0d01fc81, 0x0cfc0689, 0x0cf610ae,
  0x999a0000, 0x80400001, 0x803f8002, 0x803f0020,
  0x33333334, 0x007f0081, 0x007e0081, 0x007d009e,
  0xaaabbbbc, 0x562a5581, 0x5628aad7, 0x5627004a,
  0x06d5f92c, 0x89c4bb81, 0x89c2440b, 0x89bfccb2,
  0x3a705f2c, 0x8ac47b81, 0x8ac1048b, 0x8abd8db2,
  0x6e09f860, 0x8bc33c01, 0x8bbec58a, 0x8bba4f30,
  0xa1a2c4c8, 0x8cc0fd01, 0x8cbb8708, 0x8cb6112c,
  0xd53ac464, 0x8dbdbe81, 0x8db74905, 0x8db0d3a6,
  0x99993334, 0x803f0081, 0x803e8081, 0x803e009e,
  0x1111bbbc, 0xd5ea5581, 0xd5e92ad7, 0xd5e8004a,
  0x6d3bf92c, 0x0984bb81, 0x0982c40b, 0x0980ccb2,
  0xa0d65f2c, 0x0a847b81, 0x0a81848b, 0x0a7e8db2,
  0xd46ff860, 0x0b833c01, 0x0b7f458a, 0x0b7b4f30,
  0x0808c4c8, 0x0c80fd01, 0x0c7c0708, 0x0c77112c,
  0x3ba0c464, 0x0d7dbe81, 0x0d77c905, 0x0d71d3a6,
  0x6ee19124, 0x0e0db681, 0x0e06c115, 0x0dffcbc6,
  0x77788888, 0x55ab5501, 0x55aaaa58, 0x55a9ffcc,
  0xd3a2c5f8, 0x8945bb01, 0x8944438c, 0x8942cc34,
  0x073d2bf8, 0x8a457b01, 0x8a43040c, 0x8a408d34,
  0x3ad6c52c, 0x8b443b81, 0x8b40c50b, 0x8b3d4eb2,
  0x6e6f9194, 0x8c41fc81, 0x8c3d8689, 0x8c3910ae,
  0xa2079130, 0x8d3ebe01, 0x8d394886, 0x8d33d328,
  0xd5485df0, 0x8dceb601, 0x8dc84096, 0x8dc1cb48,
  0x087ec454, 0x8e51b481, 0x8e4a3f19, 0x8e42c9ce,
  0x5c2a3d70, 0x339a6601, 0x33999936, 0x3398cc88,
  0x8fc4a370, 0x349a2601, 0x349859b6, 0x34968d88,
  0xc35e3ca4, 0x3598e681, 0x35961ab5, 0x35934f06,
  0xf6f7090c, 0x3696a781, 0x3692dc33, 0x368f1102,
  0x2a8f08a8, 0x37936901, 0x378e9e30, 0x3789d37c,
  0x5dcfd568, 0x38236101, 0x381d9640, 0x3817cb9c,
  0x91063bcc, 0x38a65f81, 0x389f94c3, 0x3898ca22,
  0xc43bd564, 0x39285e81, 0x392093c5, 0x3918c926,
  0x339a6600, 0x00ffc001, 0x00fec082, 0x00fdc120,
  0x6733ff34, 0x01fe8081, 0x01fc8181, 0x01fa829e,
  0x9acccb9c, 0x02fc4181, 0x02f942ff, 0x02f6449a,
  0xce64cb38, 0x03f90301, 0x03f504fc, 0x03f10714,
  0x01a597f8, 0x0488fb01, 0x0483fd0c, 0x047eff34,
  0x34dbfe5c, 0x050bf981, 0x0505fb8f, 0x04fffdba,
  0x681197f4, 0x058df881, 0x0586fa91, 0x057ffcbe,
  0x9b4664c0, 0x060ef801, 0x0606fa12, 0x05fefc40,
  0x00fec080, 0x00fdc100, 0x00fcc180, 0x00fbc21d,
  0x01fc8180, 0x01fa827e, 0x01f8837c, 0x01f68497,
  0x02f94300, 0x02f6447b, 0x02f345f6, 0x02f0478e,
  0x03893b00, 0x03853c8b, 0x03813e16, 0x037d3fbe,
  0x040c3980, 0x04073b0e, 0x04023c9c, 0x03fd3e47,
  0x048e3880, 0x04883a10, 0x04823ba0, 0x047c3d4d,
  0x050f3800, 0x05083991, 0x05013b22, 0x04fa3cd0,
  0x050f3800, 0x05083991, 0x05013b22, 0x04fa3cd0,
  0x00fdc100, 0x00fcc17f, 0x00fbc1fe, 0x00fac29a,
  0x01fa8280, 0x01f8837c, 0x01f68478, 0x01f48591,
  0x028a7a80, 0x02877b8c, 0x02847c98, 0x02817dc1,
  0x030d7900, 0x03097a0f, 0x03057b1e, 0x03017c4a,
  0x038f7800, 0x038a7911, 0x03857a22, 0x03807b50,
  0x04107780, 0x040a7892, 0x040479a4, 0x03fe7ad3,
  0x04107780, 0x040a7892, 0x040479a4, 0x03fe7ad3,
  0x040f7800, 0x04097911, 0x04037a22, 0x03fd7b50,
  0x00fcc180, 0x00fbc1fe, 0x00fac27c, 0x00f9c317,
  0x018cb980, 0x018aba0e, 0x0188ba9c, 0x0186bb47,
  0x020fb800, 0x020cb891, 0x0209b922, 0x0206b9d0,
  0x0291b700, 0x028db793, 0x0289b826, 0x0285b8d6,
  0x0312b680, 0x030db714, 0x0308b7a8, 0x0303b859,
  0x0312b680, 0x030db714, 0x0308b7a8, 0x0303b859,
  0x0311b700, 0x030cb793, 0x0307b826, 0x0302b8d6,
  0x030fb800, 0x030ab891, 0x0305b922, 0x0300b9d0,
  0x008ff800, 0x008ef811, 0x008df822, 0x008cf850,
  0x0112f680, 0x0110f694, 0x010ef6a8, 0x010cf6d9,
  0x0194f580, 0x0191f596, 0x018ef5ac, 0x018bf5df,
  0x0215f500, 0x0211f517, 0x020df52e, 0x0209f562,
  0x0215f500, 0x0211f517, 0x020df52e, 0x0209f562,
  0x0214f580, 0x0210f596, 0x020cf5ac, 0x0208f5df,
  0x0212f680, 0x020ef694, 0x020af6a8, 0x0206f6d9,
  0x0202fe80, 0x01fefe84, 0x01fafe88, 0x01f6fea9,
  0x0082fe80, 0x0081fe84, 0x0080fe88, 0x007ffea9,
  0x0104fd80, 0x0102fd86, 0x0100fd8c, 0x00fefdaf,
  0x0185fd00, 0x0182fd07, 0x017ffd0e, 0x017cfd32,
  0x0185fd00, 0x0182fd07, 0x017ffd0e, 0x017cfd32,
  0x0184fd80, 0x0181fd86, 0x017efd8c, 0x017bfdaf,
  0x0182fe80, 0x017ffe84, 0x017cfe88, 0x0179fea9,
  0x01730680, 0x01700674, 0x016d0668, 0x016a0679,
  0x00f64500, 0x00f34477, 0x00f043ee, 0x00ed4382,
  0x0081ff00, 0x0080ff03, 0x007fff06, 0x007eff26,
  0x0102fe80, 0x0100fe84, 0x00fefe88, 0x00fcfea9,
  0x0102fe80, 0x0100fe84, 0x00fefe88, 0x00fcfea9,
  0x0101ff00, 0x00ffff03, 0x00fdff06, 0x00fbff26,
  0x01000000, 0x00fe0001, 0x00fc0002, 0x00fa0020,
  0x00f00800, 0x00ee07f1, 0x00ec07e2, 0x00ea07f0,
  0x00734680, 0x007145f4, 0x006f4568, 0x006d44f9,
  0xfff58580, 0xfff38476, 0xfff1836c, 0xffef827f,
  0x0080ff80, 0x007fff82, 0x007eff84, 0x007dffa3,
  0x0080ff80, 0x007fff82, 0x007eff84, 0x007dffa3,
  0x00800000, 0x007f0001, 0x007e0002, 0x007d0020,
  0x007e0100, 0x007d00ff, 0x007c00fe, 0x007b011a,
  0x006e0900, 0x006d08ef, 0x006c08de, 0x006b08ea,
  0xfff14780, 0xfff046f2, 0xffef4664, 0xffee45f3,
  0xff738680, 0xff728574, 0xff718468, 0xff708379,
  0xfef4c600, 0xfef3c475, 0xfef2c2ea, 0xfef1c17c,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff0080, 0xffff0080, 0xffff0080, 0xffff009d,
  0xfffd0180, 0xfffd017e, 0xfffd017c, 0xfffd0197,
  0xffed0980, 0xffed096e, 0xffed095c, 0xffed0967,
  0xff704800, 0xff704771, 0xff7046e2, 0xff704670,
  0xfef28700, 0xfef285f3, 0xfef284e6, 0xfef283f6,
  0xfe73c680, 0xfe73c4f4, 0xfe73c368, 0xfe73c1f9,
  0xcb5a6000, 0xcb5a2b41, 0xcb59f682, 0xcb59c1e0,
  0xffff0080, 0xffff0080, 0xffff0080, 0xffff009d,
  0xfffd0180, 0xfffd017e, 0xfffd017c, 0xfffd0197,
  0xffed0980, 0xffed096e, 0xffed095c, 0xffed0967,
  0xff704800, 0xff704771, 0xff7046e2, 0xff704670,
  0xfef28700, 0xfef285f3, 0xfef284e6, 0xfef283f6,
  0xfe73c680, 0xfe73c4f4, 0xfe73c368, 0xfe73c1f9,
  0xcb5a6000, 0xcb5a2b41, 0xcb59f682, 0xcb59c1e0,
  0x76300a80, 0x762f806c, 0x762ef658, 0x762e6c61,
  0xfffe0100, 0xfffe00ff, 0xfffe00fe, 0xfffe011a,
  0xffee0900, 0xffee08ef, 0xffee08de, 0xffee08ea,
  0xff714780, 0xff7146f2, 0xff714664, 0xff7145f3,
  0xfef38680, 0xfef38574, 0xfef38468, 0xfef38379,
  0xfe74c600, 0xfe74c475, 0xfe74c2ea, 0xfe74c17c,
  0xcb5b5f80, 0xcb5b2ac2, 0xcb5af604, 0xcb5ac163,
  0x76310a00, 0x76307fed, 0x762ff5da, 0x762f6be4,
  0xf6740880, 0xf672fe70, 0xf671f460, 0xf670ea6d,
  0xfff00800, 0xfff007f1, 0xfff007e2, 0xfff007f0,
  0xff734680, 0xff7345f4, 0xff734568, 0xff7344f9,
  0xfef58580, 0xfef58476, 0xfef5836c, 0xfef5827f,
  0xfe76c500, 0xfe76c377, 0xfe76c1ee, 0xfe76c082,
  0xcb5d5e80, 0xcb5d29c4, 0xcb5cf508, 0xcb5cc069,
  0x76330900, 0x76327eef, 0x7631f4de, 0x76316aea,
  0xf6760780, 0xf674fd72, 0xf673f364, 0xf672e973,
  0x76b80680, 0x76b67c74, 0x76b4f268, 0x76b36879,
  0xff833e80, 0xff833e04, 0xff833d88, 0xff833d29,
  0xff057d80, 0xff057c86, 0xff057b8c, 0xff057aaf,
  0xfe86bd00, 0xfe86bb87, 0xfe86ba0e, 0xfe86b8b2,
  0xcb6d5680, 0xcb6d21d4, 0xcb6ced28, 0xcb6cb899,
  0x76430100, 0x764276ff, 0x7641ecfe, 0x7641631a,
  0xf685ff80, 0xf684f582, 0xf683eb84, 0xf682e1a3,
  0x76c7fe80, 0x76c67484, 0x76c4ea88, 0x76c360a9,
  0xf708fe00, 0xf706f405, 0xf704ea0a, 0xf702e02c,
  0xff823f00, 0xff823e83, 0xff823e06, 0xff823da6,
  0xff037e80, 0xff037d84, 0xff037c88, 0xff037ba9,
  0xcbea1800, 0xcbe9e3d1, 0xcbe9afa2, 0xcbe97b90,
  0x76bfc280, 0x76bf38fc, 0x76beaf78, 0x76be2611,
  0xf702c100, 0xf701b77f, 0xf700adfe, 0xf6ffa49a,
  0x7744c000, 0x77433681, 0x7741ad02, 0x774023a0,
  0xf785bf80, 0xf783b602, 0xf781ac84, 0xf77fa323,
  0x77c5bf80, 0x77c33602, 0x77c0ac84, 0x77be2323,
  0xff813f80, 0xff813f02, 0xff813e84, 0xff813e23,
  0xcc67d900, 0xcc67a54f, 0xcc67719e, 0xcc673e0a,
  0x773d8380, 0x773cfa7a, 0x773c7174, 0x773be88b,
  0xf7808200, 0xf77f78fd, 0xf77e6ffa, 0xf77d6714,
  0x77c28100, 0x77c0f7ff, 0x77bf6efe, 0x77bde61a,
  0xf8038080, 0xf8017780, 0xf7ff6e80, 0xf7fd659d,
  0x78438080, 0x7840f780, 0x783e6e80, 0x783be59d,
  0xf8828100, 0xf87f77ff, 0xf87c6efe, 0xf879661a,
  0xcce69980, 0xcce6664e, 0xcce6331c, 0xcce60007,
  0x77bc4400, 0x77bbbb79, 0x77bb32f2, 0x77baaa88,
  0xf7ff4280, 0xf7fe39fc, 0xf7fd3178, 0xf7fc2911,
  0x78414180, 0x783fb8fe, 0x783e307c, 0x783ca817,
  0xf8824100, 0xf880387f, 0xf87e2ffe, 0xf87c279a,
  0x78c24100, 0x78bfb87f, 0x78bd2ffe, 0x78baa79a,
  0xf9014180, 0xf8fe38fe, 0xf8fb307c, 0xf8f82817,
  0x4eac9680, 0x4ea8e354, 0x4ea53028, 0x4ea17d19,
  0xaad5aa80, 0xaad5552c, 0xaad4ffd8, 0xaad4aaa1,
  0x2b18a900, 0x2b17d3af, 0x2b16fe5e, 0x2b16292a,
  0xab5aa800, 0xab5952b1, 0xab57fd62, 0xab56a830,
  0x2b9ba780, 0x2b99d232, 0x2b97fce4, 0x2b9627b3,
  0xabdba780, 0xabd95232, 0xabd6fce4, 0xabd4a7b3,
  0x2c1aa800, 0x2c17d2b1, 0x2c14fd62, 0x2c122830,
  0x81c5fd00, 0x81c27d07, 0x81befd0e, 0x81bb7d32,
  0xb5606300, 0xb55c163b, 0xb557c976, 0xb5537cce,
  0x8042fe80, 0x80427e84, 0x8041fe88, 0x80417ea9,
  0x0084fd80, 0x0083fd86, 0x0082fd8c, 0x0081fdaf,
  0x80c5fd00, 0x80c47d07, 0x80c2fd0e, 0x80c17d32,
  0x0105fd00, 0x0103fd07, 0x0101fd0e, 0x00fffd32,
  0x8144fd80, 0x81427d86, 0x813ffd8c, 0x813d7daf,
  0xd6f05280, 0xd6ed27dc, 0xd6e9fd38, 0xd6e6d2b1,
  0x0a8ab880, 0x0a86c110, 0x0a82c9a0, 0x0a7ed24d,
  0x0b8a7880, 0x0b858190, 0x0b808aa0, 0x0b7b93cd,
  0x8041ff00, 0x80417f03, 0x8040ff06, 0x80407f26,
  0x0082fe80, 0x0081fe84, 0x0080fe88, 0x007ffea9,
  0x80c2fe80, 0x80c17e84, 0x80bffe88, 0x80be7ea9,
  0x0101ff00, 0x00ffff03, 0x00fdff06, 0x00fbff26,
  0x56ad5400, 0x56aaa959, 0x56a7feb2, 0x56a55428,
  0x8a47ba00, 0x8a44428d, 0x8a40cb1a, 0x8a3d53c4,
  0x8b477a00, 0x8b43030d, 0x8b3e8c1a, 0x8b3a1544,
  0x8c463a80, 0x8c40c40c, 0x8c3b4d98, 0x8c35d741,
  0x8040ff80, 0x80407f82, 0x803fff84, 0x803f7fa3,
  0x0080ff80, 0x007fff82, 0x007eff84, 0x007dffa3,
  0x80c00000, 0x80be8001, 0x80bd0002, 0x80bb8020,
  0xd66b5500, 0xd6692a57, 0xd666ffae, 0xd664d522,
  0x0a05bb00, 0x0a02c38b, 0x09ffcc16, 0x09fcd4be,
  0x0b057b00, 0x0b01840b, 0x0afd8d16, 0x0af9963e,
  0x0c043b80, 0x0bff450a, 0x0bfa4e94, 0x0bf5583b,
  0x0d01fc80, 0x0cfc0688, 0x0cf61090, 0x0cf01ab5,
  0x80400000, 0x803f8001, 0x803f0002, 0x803e8020,
  0x007f0080, 0x007e0080, 0x007d0080, 0x007c009d,
  0x562a5580, 0x5628aad6, 0x5627002c, 0x5625559f,
  0x89c4bb80, 0x89c2440a, 0x89bfcc94, 0x89bd553b,
  0x8ac47b80, 0x8ac1048a, 0x8abd8d94, 0x8aba16bb,
  0x8bc33c00, 0x8bbec589, 0x8bba4f12, 0x8bb5d8b8,
  0x8cc0fd00, 0x8cbb8707, 0x8cb6110e, 0x8cb09b32,
  0x8dbdbe80, 0x8db74904, 0x8db0d388, 0x8daa5e29,
  0x803f0080, 0x803e8080, 0x803e0080, 0x803d809d,
  0xd5ea5580, 0xd5e92ad6, 0xd5e8002c, 0xd5e6d59f,
  0x0984bb80, 0x0982c40a, 0x0980cc94, 0x097ed53b,
  0x0a847b80, 0x0a81848a, 0x0a7e8d94, 0x0a7b96bb,
  0x0b833c00, 0x0b7f4589, 0x0b7b4f12, 0x0b7758b8,
  0x0c80fd00, 0x0c7c0707, 0x0c77110e, 0x0c721b32,
  0x0d7dbe80, 0x0d77c904, 0x0d71d388, 0x0d6bde29,
  0x0e0db680, 0x0e06c114, 0x0dffcba8, 0x0df8d659,
  0x55ab5500, 0x55aaaa57, 0x55a9ffae, 0x55a95522,
  0x8945bb00, 0x8944438b, 0x8942cc16, 0x894154be,
  0x8a457b00, 0x8a43040b, 0x8a408d16, 0x8a3e163e,
  0x8b443b80, 0x8b40c50a, 0x8b3d4e94, 0x8b39d83b,
  0x8c41fc80, 0x8c3d8688, 0x8c391090, 0x8c349ab5,
  0x8d3ebe00, 0x8d394885, 0x8d33d30a, 0x8d2e5dac,
  0x8dceb600, 0x8dc84095, 0x8dc1cb2a, 0x8dbb55dc,
  0x8e51b480, 0x8e4a3f18, 0x8e42c9b0, 0x8e3b5465,
  0x339a6600, 0x33999935, 0x3398cc6a, 0x3397ffbc,
  0x349a2600, 0x349859b5, 0x34968d6a, 0x3494c13c,
  0x3598e680, 0x35961ab4, 0x35934ee8, 0x35908339,
  0x3696a780, 0x3692dc32, 0x368f10e4, 0x368b45b3,
  0x37936900, 0x378e9e2f, 0x3789d35e, 0x378508aa,
  0x38236100, 0x381d963f, 0x3817cb7e, 0x381200da,
  0x38a65f80, 0x389f94c2, 0x3898ca04, 0x3891ff63,
  0x39285e80, 0x392093c4, 0x3918c908, 0x3910fe69,
  0x00ffc000, 0x00fec081, 0x00fdc102, 0x00fcc1a0,
  0x01fe8080, 0x01fc8180, 0x01fa8280, 0x01f8839d,
  0x02fc4180, 0x02f942fe, 0x02f6447c, 0x02f34617,
  0x03f90300, 0x03f504fb, 0x03f106f6, 0x03ed090e,
  0x0488fb00, 0x0483fd0b, 0x047eff16, 0x047a013e,
  0x050bf980, 0x0505fb8e, 0x04fffd9c, 0x04f9ffc7,
  0x058df880, 0x0586fa90, 0x057ffca0, 0x0578fecd,
  0x060ef800, 0x0606fa11, 0x05fefc22, 0x05f6fe50,
};
const unsigned kExpectedCount_NEON_umlsl_4S_4H_H = 4608;

#endif  // VIXL_SIM_UMLSL_4S_4H_H_TRACE_AARCH64_H_
