// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_USUBW2_8H_TRACE_AARCH64_H_
#define VIXL_SIM_USUBW2_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_usubw2_8H[] = {
  0xfffb, 0xffd5, 0x3267, 0x545d, 0x7f00, 0x7f00, 0x7f00, 0x0000,
  0xffd4, 0xffb3, 0x323b, 0x5458, 0x7eff, 0x7eff, 0x7fff, 0xffff,
  0xffb2, 0xff87, 0x3236, 0x5457, 0x7efe, 0x7ffe, 0x7ffe, 0xfffe,
  0xff86, 0xff82, 0x3235, 0x5456, 0x7ffd, 0x7ffd, 0x7ffd, 0xfff8,
  0xff81, 0xff81, 0x3234, 0x5555, 0x7ffc, 0x7ffc, 0x7ff7, 0xffcd,
  0xff80, 0xff80, 0x3333, 0x5554, 0x7ffb, 0x7ff6, 0x7fcc, 0xffab,
  0xff7f, 0x007f, 0x3332, 0x5553, 0x7ff5, 0x7fcb, 0x7faa, 0xff83,
  0x007e, 0x007e, 0x3331, 0x554d, 0x7fca, 0x7fa9, 0x7f82, 0xff82,
  0x007d, 0x007d, 0x332b, 0x5522, 0x7fa8, 0x7f81, 0x7f81, 0xff81,
  0x007c, 0x0077, 0x3300, 0x5500, 0x7f80, 0x7f80, 0x7f80, 0xff80,
  0x0076, 0x004c, 0x32de, 0x54d8, 0x7f7f, 0x7f7f, 0x7f7f, 0xff7f,
  0x004b, 0x002a, 0x32b6, 0x54d7, 0x7f7e, 0x7f7e, 0x7f7e, 0xff7e,
  0x0029, 0x0002, 0x32b5, 0x54d6, 0x7f7d, 0x7f7d, 0x7f7d, 0xff7d,
  0x0001, 0x0001, 0x32b4, 0x54d5, 0x7f7c, 0x7f7c, 0x7f7c, 0xff56,
  0x0000, 0x0000, 0x32b3, 0x54d4, 0x7f7b, 0x7f7b, 0x7f55, 0xff34,
  0xffff, 0xffff, 0x32b2, 0x54d3, 0x7f7a, 0x7f54, 0x7f33, 0xff08,
  0xfffe, 0xfffe, 0x32b1, 0x54d2, 0x7f53, 0x7f32, 0x7f07, 0xff03,
  0xfffd, 0xfffd, 0x32b0, 0x54ab, 0x7f31, 0x7f06, 0x7f02, 0xff02,
  0xfffc, 0xfffc, 0x3289, 0x5489, 0x7f05, 0x7f01, 0x7f01, 0xff01,
  0xfffc, 0x3289, 0x5489, 0x7f05, 0x7f01, 0x7f01, 0xff01, 0x0001,
  0xffd5, 0x3267, 0x545d, 0x7f00, 0x7f00, 0x7f00, 0x0000, 0x0000,
  0xffb3, 0x323b, 0x5458, 0x7eff, 0x7eff, 0x7fff, 0xffff, 0xffff,
  0xff87, 0x3236, 0x5457, 0x7efe, 0x7ffe, 0x7ffe, 0xfffe, 0xfff9,
  0xff82, 0x3235, 0x5456, 0x7ffd, 0x7ffd, 0x7ffd, 0xfff8, 0xffce,
  0xff81, 0x3234, 0x5555, 0x7ffc, 0x7ffc, 0x7ff7, 0xffcd, 0xffac,
  0xff80, 0x3333, 0x5554, 0x7ffb, 0x7ff6, 0x7fcc, 0xffab, 0xff84,
  0x007f, 0x3332, 0x5553, 0x7ff5, 0x7fcb, 0x7faa, 0xff83, 0xff83,
  0x007e, 0x3331, 0x554d, 0x7fca, 0x7fa9, 0x7f82, 0xff82, 0xff82,
  0x007d, 0x332b, 0x5522, 0x7fa8, 0x7f81, 0x7f81, 0xff81, 0xff81,
  0x0077, 0x3300, 0x5500, 0x7f80, 0x7f80, 0x7f80, 0xff80, 0xff80,
  0x004c, 0x32de, 0x54d8, 0x7f7f, 0x7f7f, 0x7f7f, 0xff7f, 0xff7f,
  0x002a, 0x32b6, 0x54d7, 0x7f7e, 0x7f7e, 0x7f7e, 0xff7e, 0xff7e,
  0x0002, 0x32b5, 0x54d6, 0x7f7d, 0x7f7d, 0x7f7d, 0xff7d, 0xff57,
  0x0001, 0x32b4, 0x54d5, 0x7f7c, 0x7f7c, 0x7f7c, 0xff56, 0xff35,
  0x0000, 0x32b3, 0x54d4, 0x7f7b, 0x7f7b, 0x7f55, 0xff34, 0xff09,
  0xffff, 0x32b2, 0x54d3, 0x7f7a, 0x7f54, 0x7f33, 0xff08, 0xff04,
  0xfffe, 0x32b1, 0x54d2, 0x7f53, 0x7f32, 0x7f07, 0xff03, 0xff03,
  0xfffd, 0x32b0, 0x54ab, 0x7f31, 0x7f06, 0x7f02, 0xff02, 0xff02,
  0x32b0, 0x54ab, 0x7f31, 0x7f06, 0x7f02, 0xff02, 0xff02, 0x0002,
  0x3289, 0x5489, 0x7f05, 0x7f01, 0x7f01, 0xff01, 0x0001, 0x0001,
  0x3267, 0x545d, 0x7f00, 0x7f00, 0x7f00, 0x0000, 0x0000, 0x0000,
  0x323b, 0x5458, 0x7eff, 0x7eff, 0x7fff, 0xffff, 0xffff, 0xfffa,
  0x3236, 0x5457, 0x7efe, 0x7ffe, 0x7ffe, 0xfffe, 0xfff9, 0xffcf,
  0x3235, 0x5456, 0x7ffd, 0x7ffd, 0x7ffd, 0xfff8, 0xffce, 0xffad,
  0x3234, 0x5555, 0x7ffc, 0x7ffc, 0x7ff7, 0xffcd, 0xffac, 0xff85,
  0x3333, 0x5554, 0x7ffb, 0x7ff6, 0x7fcc, 0xffab, 0xff84, 0xff84,
  0x3332, 0x5553, 0x7ff5, 0x7fcb, 0x7faa, 0xff83, 0xff83, 0xff83,
  0x3331, 0x554d, 0x7fca, 0x7fa9, 0x7f82, 0xff82, 0xff82, 0xff82,
  0x332b, 0x5522, 0x7fa8, 0x7f81, 0x7f81, 0xff81, 0xff81, 0xff81,
  0x3300, 0x5500, 0x7f80, 0x7f80, 0x7f80, 0xff80, 0xff80, 0xff80,
  0x32de, 0x54d8, 0x7f7f, 0x7f7f, 0x7f7f, 0xff7f, 0xff7f, 0xff7f,
  0x32b6, 0x54d7, 0x7f7e, 0x7f7e, 0x7f7e, 0xff7e, 0xff7e, 0xff58,
  0x32b5, 0x54d6, 0x7f7d, 0x7f7d, 0x7f7d, 0xff7d, 0xff57, 0xff36,
  0x32b4, 0x54d5, 0x7f7c, 0x7f7c, 0x7f7c, 0xff56, 0xff35, 0xff0a,
  0x32b3, 0x54d4, 0x7f7b, 0x7f7b, 0x7f55, 0xff34, 0xff09, 0xff05,
  0x32b2, 0x54d3, 0x7f7a, 0x7f54, 0x7f33, 0xff08, 0xff04, 0xff04,
  0x32b1, 0x54d2, 0x7f53, 0x7f32, 0x7f07, 0xff03, 0xff03, 0xff03,
  0x54d2, 0x7f53, 0x7f32, 0x7f07, 0xff03, 0xff03, 0xff03, 0x0010,
  0x54ab, 0x7f31, 0x7f06, 0x7f02, 0xff02, 0xff02, 0x0002, 0x000f,
  0x5489, 0x7f05, 0x7f01, 0x7f01, 0xff01, 0x0001, 0x0001, 0x000e,
  0x545d, 0x7f00, 0x7f00, 0x7f00, 0x0000, 0x0000, 0x0000, 0x0008,
  0x5458, 0x7eff, 0x7eff, 0x7fff, 0xffff, 0xffff, 0xfffa, 0xffdd,
  0x5457, 0x7efe, 0x7ffe, 0x7ffe, 0xfffe, 0xfff9, 0xffcf, 0xffbb,
  0x5456, 0x7ffd, 0x7ffd, 0x7ffd, 0xfff8, 0xffce, 0xffad, 0xff93,
  0x5555, 0x7ffc, 0x7ffc, 0x7ff7, 0xffcd, 0xffac, 0xff85, 0xff92,
  0x5554, 0x7ffb, 0x7ff6, 0x7fcc, 0xffab, 0xff84, 0xff84, 0xff91,
  0x5553, 0x7ff5, 0x7fcb, 0x7faa, 0xff83, 0xff83, 0xff83, 0xff90,
  0x554d, 0x7fca, 0x7fa9, 0x7f82, 0xff82, 0xff82, 0xff82, 0xff8f,
  0x5522, 0x7fa8, 0x7f81, 0x7f81, 0xff81, 0xff81, 0xff81, 0xff8e,
  0x5500, 0x7f80, 0x7f80, 0x7f80, 0xff80, 0xff80, 0xff80, 0xff8d,
  0x54d8, 0x7f7f, 0x7f7f, 0x7f7f, 0xff7f, 0xff7f, 0xff7f, 0xff66,
  0x54d7, 0x7f7e, 0x7f7e, 0x7f7e, 0xff7e, 0xff7e, 0xff58, 0xff44,
  0x54d6, 0x7f7d, 0x7f7d, 0x7f7d, 0xff7d, 0xff57, 0xff36, 0xff18,
  0x54d5, 0x7f7c, 0x7f7c, 0x7f7c, 0xff56, 0xff35, 0xff0a, 0xff13,
  0x54d4, 0x7f7b, 0x7f7b, 0x7f55, 0xff34, 0xff09, 0xff05, 0xff12,
  0x54d3, 0x7f7a, 0x7f54, 0x7f33, 0xff08, 0xff04, 0xff04, 0xff11,
  0x7f7a, 0x7f54, 0x7f33, 0xff08, 0xff04, 0xff04, 0xff11, 0x007d,
  0x7f53, 0x7f32, 0x7f07, 0xff03, 0xff03, 0xff03, 0x0010, 0x007c,
  0x7f31, 0x7f06, 0x7f02, 0xff02, 0xff02, 0x0002, 0x000f, 0x007b,
  0x7f05, 0x7f01, 0x7f01, 0xff01, 0x0001, 0x0001, 0x000e, 0x0075,
  0x7f00, 0x7f00, 0x7f00, 0x0000, 0x0000, 0x0000, 0x0008, 0x004a,
  0x7eff, 0x7eff, 0x7fff, 0xffff, 0xffff, 0xfffa, 0xffdd, 0x0028,
  0x7efe, 0x7ffe, 0x7ffe, 0xfffe, 0xfff9, 0xffcf, 0xffbb, 0x0000,
  0x7ffd, 0x7ffd, 0x7ffd, 0xfff8, 0xffce, 0xffad, 0xff93, 0xffff,
  0x7ffc, 0x7ffc, 0x7ff7, 0xffcd, 0xffac, 0xff85, 0xff92, 0xfffe,
  0x7ffb, 0x7ff6, 0x7fcc, 0xffab, 0xff84, 0xff84, 0xff91, 0xfffd,
  0x7ff5, 0x7fcb, 0x7faa, 0xff83, 0xff83, 0xff83, 0xff90, 0xfffc,
  0x7fca, 0x7fa9, 0x7f82, 0xff82, 0xff82, 0xff82, 0xff8f, 0xfffb,
  0x7fa8, 0x7f81, 0x7f81, 0xff81, 0xff81, 0xff81, 0xff8e, 0xfffa,
  0x7f80, 0x7f80, 0x7f80, 0xff80, 0xff80, 0xff80, 0xff8d, 0xffd3,
  0x7f7f, 0x7f7f, 0x7f7f, 0xff7f, 0xff7f, 0xff7f, 0xff66, 0xffb1,
  0x7f7e, 0x7f7e, 0x7f7e, 0xff7e, 0xff7e, 0xff58, 0xff44, 0xff85,
  0x7f7d, 0x7f7d, 0x7f7d, 0xff7d, 0xff57, 0xff36, 0xff18, 0xff80,
  0x7f7c, 0x7f7c, 0x7f7c, 0xff56, 0xff35, 0xff0a, 0xff13, 0xff7f,
  0x7f7b, 0x7f7b, 0x7f55, 0xff34, 0xff09, 0xff05, 0xff12, 0xff7e,
  0x7f7b, 0x7f55, 0xff34, 0xff09, 0xff05, 0xff12, 0xff7e, 0x007e,
  0x7f54, 0x7f33, 0xff08, 0xff04, 0xff04, 0xff11, 0x007d, 0x007d,
  0x7f32, 0x7f07, 0xff03, 0xff03, 0xff03, 0x0010, 0x007c, 0x007c,
  0x7f06, 0x7f02, 0xff02, 0xff02, 0x0002, 0x000f, 0x007b, 0x0076,
  0x7f01, 0x7f01, 0xff01, 0x0001, 0x0001, 0x000e, 0x0075, 0x004b,
  0x7f00, 0x7f00, 0x0000, 0x0000, 0x0000, 0x0008, 0x004a, 0x0029,
  0x7eff, 0x7fff, 0xffff, 0xffff, 0xfffa, 0xffdd, 0x0028, 0x0001,
  0x7ffe, 0x7ffe, 0xfffe, 0xfff9, 0xffcf, 0xffbb, 0x0000, 0x0000,
  0x7ffd, 0x7ffd, 0xfff8, 0xffce, 0xffad, 0xff93, 0xffff, 0xffff,
  0x7ffc, 0x7ff7, 0xffcd, 0xffac, 0xff85, 0xff92, 0xfffe, 0xfffe,
  0x7ff6, 0x7fcc, 0xffab, 0xff84, 0xff84, 0xff91, 0xfffd, 0xfffd,
  0x7fcb, 0x7faa, 0xff83, 0xff83, 0xff83, 0xff90, 0xfffc, 0xfffc,
  0x7fa9, 0x7f82, 0xff82, 0xff82, 0xff82, 0xff8f, 0xfffb, 0xfffb,
  0x7f81, 0x7f81, 0xff81, 0xff81, 0xff81, 0xff8e, 0xfffa, 0xffd4,
  0x7f80, 0x7f80, 0xff80, 0xff80, 0xff80, 0xff8d, 0xffd3, 0xffb2,
  0x7f7f, 0x7f7f, 0xff7f, 0xff7f, 0xff7f, 0xff66, 0xffb1, 0xff86,
  0x7f7e, 0x7f7e, 0xff7e, 0xff7e, 0xff58, 0xff44, 0xff85, 0xff81,
  0x7f7d, 0x7f7d, 0xff7d, 0xff57, 0xff36, 0xff18, 0xff80, 0xff80,
  0x7f7c, 0x7f7c, 0xff56, 0xff35, 0xff0a, 0xff13, 0xff7f, 0xff7f,
  0x7f7c, 0xff56, 0xff35, 0xff0a, 0xff13, 0xff7f, 0xff7f, 0x007f,
  0x7f55, 0xff34, 0xff09, 0xff05, 0xff12, 0xff7e, 0x007e, 0x007e,
  0x7f33, 0xff08, 0xff04, 0xff04, 0xff11, 0x007d, 0x007d, 0x007d,
  0x7f07, 0xff03, 0xff03, 0xff03, 0x0010, 0x007c, 0x007c, 0x0077,
  0x7f02, 0xff02, 0xff02, 0x0002, 0x000f, 0x007b, 0x0076, 0x004c,
  0x7f01, 0xff01, 0x0001, 0x0001, 0x000e, 0x0075, 0x004b, 0x002a,
  0x7f00, 0x0000, 0x0000, 0x0000, 0x0008, 0x004a, 0x0029, 0x0002,
  0x7fff, 0xffff, 0xffff, 0xfffa, 0xffdd, 0x0028, 0x0001, 0x0001,
  0x7ffe, 0xfffe, 0xfff9, 0xffcf, 0xffbb, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0xfff8, 0xffce, 0xffad, 0xff93, 0xffff, 0xffff, 0xffff,
  0x7ff7, 0xffcd, 0xffac, 0xff85, 0xff92, 0xfffe, 0xfffe, 0xfffe,
  0x7fcc, 0xffab, 0xff84, 0xff84, 0xff91, 0xfffd, 0xfffd, 0xfffd,
  0x7faa, 0xff83, 0xff83, 0xff83, 0xff90, 0xfffc, 0xfffc, 0xfffc,
  0x7f82, 0xff82, 0xff82, 0xff82, 0xff8f, 0xfffb, 0xfffb, 0xffd5,
  0x7f81, 0xff81, 0xff81, 0xff81, 0xff8e, 0xfffa, 0xffd4, 0xffb3,
  0x7f80, 0xff80, 0xff80, 0xff80, 0xff8d, 0xffd3, 0xffb2, 0xff87,
  0x7f7f, 0xff7f, 0xff7f, 0xff7f, 0xff66, 0xffb1, 0xff86, 0xff82,
  0x7f7e, 0xff7e, 0xff7e, 0xff58, 0xff44, 0xff85, 0xff81, 0xff81,
  0x7f7d, 0xff7d, 0xff57, 0xff36, 0xff18, 0xff80, 0xff80, 0xff80,
  0xff7d, 0xff57, 0xff36, 0xff18, 0xff80, 0xff80, 0xff80, 0x3333,
  0xff56, 0xff35, 0xff0a, 0xff13, 0xff7f, 0xff7f, 0x007f, 0x3332,
  0xff34, 0xff09, 0xff05, 0xff12, 0xff7e, 0x007e, 0x007e, 0x3331,
  0xff08, 0xff04, 0xff04, 0xff11, 0x007d, 0x007d, 0x007d, 0x332b,
  0xff03, 0xff03, 0xff03, 0x0010, 0x007c, 0x007c, 0x0077, 0x3300,
  0xff02, 0xff02, 0x0002, 0x000f, 0x007b, 0x0076, 0x004c, 0x32de,
  0xff01, 0x0001, 0x0001, 0x000e, 0x0075, 0x004b, 0x002a, 0x32b6,
  0x0000, 0x0000, 0x0000, 0x0008, 0x004a, 0x0029, 0x0002, 0x32b5,
  0xffff, 0xffff, 0xfffa, 0xffdd, 0x0028, 0x0001, 0x0001, 0x32b4,
  0xfffe, 0xfff9, 0xffcf, 0xffbb, 0x0000, 0x0000, 0x0000, 0x32b3,
  0xfff8, 0xffce, 0xffad, 0xff93, 0xffff, 0xffff, 0xffff, 0x32b2,
  0xffcd, 0xffac, 0xff85, 0xff92, 0xfffe, 0xfffe, 0xfffe, 0x32b1,
  0xffab, 0xff84, 0xff84, 0xff91, 0xfffd, 0xfffd, 0xfffd, 0x32b0,
  0xff83, 0xff83, 0xff83, 0xff90, 0xfffc, 0xfffc, 0xfffc, 0x3289,
  0xff82, 0xff82, 0xff82, 0xff8f, 0xfffb, 0xfffb, 0xffd5, 0x3267,
  0xff81, 0xff81, 0xff81, 0xff8e, 0xfffa, 0xffd4, 0xffb3, 0x323b,
  0xff80, 0xff80, 0xff80, 0xff8d, 0xffd3, 0xffb2, 0xff87, 0x3236,
  0xff7f, 0xff7f, 0xff7f, 0xff66, 0xffb1, 0xff86, 0xff82, 0x3235,
  0xff7e, 0xff7e, 0xff58, 0xff44, 0xff85, 0xff81, 0xff81, 0x3234,
  0xff7e, 0xff58, 0xff44, 0xff85, 0xff81, 0xff81, 0x3234, 0x5555,
  0xff57, 0xff36, 0xff18, 0xff80, 0xff80, 0xff80, 0x3333, 0x5554,
  0xff35, 0xff0a, 0xff13, 0xff7f, 0xff7f, 0x007f, 0x3332, 0x5553,
  0xff09, 0xff05, 0xff12, 0xff7e, 0x007e, 0x007e, 0x3331, 0x554d,
  0xff04, 0xff04, 0xff11, 0x007d, 0x007d, 0x007d, 0x332b, 0x5522,
  0xff03, 0xff03, 0x0010, 0x007c, 0x007c, 0x0077, 0x3300, 0x5500,
  0xff02, 0x0002, 0x000f, 0x007b, 0x0076, 0x004c, 0x32de, 0x54d8,
  0x0001, 0x0001, 0x000e, 0x0075, 0x004b, 0x002a, 0x32b6, 0x54d7,
  0x0000, 0x0000, 0x0008, 0x004a, 0x0029, 0x0002, 0x32b5, 0x54d6,
  0xffff, 0xfffa, 0xffdd, 0x0028, 0x0001, 0x0001, 0x32b4, 0x54d5,
  0xfff9, 0xffcf, 0xffbb, 0x0000, 0x0000, 0x0000, 0x32b3, 0x54d4,
  0xffce, 0xffad, 0xff93, 0xffff, 0xffff, 0xffff, 0x32b2, 0x54d3,
  0xffac, 0xff85, 0xff92, 0xfffe, 0xfffe, 0xfffe, 0x32b1, 0x54d2,
  0xff84, 0xff84, 0xff91, 0xfffd, 0xfffd, 0xfffd, 0x32b0, 0x54ab,
  0xff83, 0xff83, 0xff90, 0xfffc, 0xfffc, 0xfffc, 0x3289, 0x5489,
  0xff82, 0xff82, 0xff8f, 0xfffb, 0xfffb, 0xffd5, 0x3267, 0x545d,
  0xff81, 0xff81, 0xff8e, 0xfffa, 0xffd4, 0xffb3, 0x323b, 0x5458,
  0xff80, 0xff80, 0xff8d, 0xffd3, 0xffb2, 0xff87, 0x3236, 0x5457,
  0xff7f, 0xff7f, 0xff66, 0xffb1, 0xff86, 0xff82, 0x3235, 0x5456,
  0xff7f, 0xff66, 0xffb1, 0xff86, 0xff82, 0x3235, 0x5456, 0x7ffd,
  0xff58, 0xff44, 0xff85, 0xff81, 0xff81, 0x3234, 0x5555, 0x7ffc,
  0xff36, 0xff18, 0xff80, 0xff80, 0xff80, 0x3333, 0x5554, 0x7ffb,
  0xff0a, 0xff13, 0xff7f, 0xff7f, 0x007f, 0x3332, 0x5553, 0x7ff5,
  0xff05, 0xff12, 0xff7e, 0x007e, 0x007e, 0x3331, 0x554d, 0x7fca,
  0xff04, 0xff11, 0x007d, 0x007d, 0x007d, 0x332b, 0x5522, 0x7fa8,
  0xff03, 0x0010, 0x007c, 0x007c, 0x0077, 0x3300, 0x5500, 0x7f80,
  0x0002, 0x000f, 0x007b, 0x0076, 0x004c, 0x32de, 0x54d8, 0x7f7f,
  0x0001, 0x000e, 0x0075, 0x004b, 0x002a, 0x32b6, 0x54d7, 0x7f7e,
  0x0000, 0x0008, 0x004a, 0x0029, 0x0002, 0x32b5, 0x54d6, 0x7f7d,
  0xfffa, 0xffdd, 0x0028, 0x0001, 0x0001, 0x32b4, 0x54d5, 0x7f7c,
  0xffcf, 0xffbb, 0x0000, 0x0000, 0x0000, 0x32b3, 0x54d4, 0x7f7b,
  0xffad, 0xff93, 0xffff, 0xffff, 0xffff, 0x32b2, 0x54d3, 0x7f7a,
  0xff85, 0xff92, 0xfffe, 0xfffe, 0xfffe, 0x32b1, 0x54d2, 0x7f53,
  0xff84, 0xff91, 0xfffd, 0xfffd, 0xfffd, 0x32b0, 0x54ab, 0x7f31,
  0xff83, 0xff90, 0xfffc, 0xfffc, 0xfffc, 0x3289, 0x5489, 0x7f05,
  0xff82, 0xff8f, 0xfffb, 0xfffb, 0xffd5, 0x3267, 0x545d, 0x7f00,
  0xff81, 0xff8e, 0xfffa, 0xffd4, 0xffb3, 0x323b, 0x5458, 0x7eff,
  0xff80, 0xff8d, 0xffd3, 0xffb2, 0xff87, 0x3236, 0x5457, 0x7efe,
  0xff8d, 0xffd3, 0xffb2, 0xff87, 0x3236, 0x5457, 0x7efe, 0x7ffe,
  0xff66, 0xffb1, 0xff86, 0xff82, 0x3235, 0x5456, 0x7ffd, 0x7ffd,
  0xff44, 0xff85, 0xff81, 0xff81, 0x3234, 0x5555, 0x7ffc, 0x7ffc,
  0xff18, 0xff80, 0xff80, 0xff80, 0x3333, 0x5554, 0x7ffb, 0x7ff6,
  0xff13, 0xff7f, 0xff7f, 0x007f, 0x3332, 0x5553, 0x7ff5, 0x7fcb,
  0xff12, 0xff7e, 0x007e, 0x007e, 0x3331, 0x554d, 0x7fca, 0x7fa9,
  0xff11, 0x007d, 0x007d, 0x007d, 0x332b, 0x5522, 0x7fa8, 0x7f81,
  0x0010, 0x007c, 0x007c, 0x0077, 0x3300, 0x5500, 0x7f80, 0x7f80,
  0x000f, 0x007b, 0x0076, 0x004c, 0x32de, 0x54d8, 0x7f7f, 0x7f7f,
  0x000e, 0x0075, 0x004b, 0x002a, 0x32b6, 0x54d7, 0x7f7e, 0x7f7e,
  0x0008, 0x004a, 0x0029, 0x0002, 0x32b5, 0x54d6, 0x7f7d, 0x7f7d,
  0xffdd, 0x0028, 0x0001, 0x0001, 0x32b4, 0x54d5, 0x7f7c, 0x7f7c,
  0xffbb, 0x0000, 0x0000, 0x0000, 0x32b3, 0x54d4, 0x7f7b, 0x7f7b,
  0xff93, 0xffff, 0xffff, 0xffff, 0x32b2, 0x54d3, 0x7f7a, 0x7f54,
  0xff92, 0xfffe, 0xfffe, 0xfffe, 0x32b1, 0x54d2, 0x7f53, 0x7f32,
  0xff91, 0xfffd, 0xfffd, 0xfffd, 0x32b0, 0x54ab, 0x7f31, 0x7f06,
  0xff90, 0xfffc, 0xfffc, 0xfffc, 0x3289, 0x5489, 0x7f05, 0x7f01,
  0xff8f, 0xfffb, 0xfffb, 0xffd5, 0x3267, 0x545d, 0x7f00, 0x7f00,
  0xff8e, 0xfffa, 0xffd4, 0xffb3, 0x323b, 0x5458, 0x7eff, 0x7eff,
  0xfffa, 0xffd4, 0xffb3, 0x323b, 0x5458, 0x7eff, 0x7eff, 0x7fff,
  0xffd3, 0xffb2, 0xff87, 0x3236, 0x5457, 0x7efe, 0x7ffe, 0x7ffe,
  0xffb1, 0xff86, 0xff82, 0x3235, 0x5456, 0x7ffd, 0x7ffd, 0x7ffd,
  0xff85, 0xff81, 0xff81, 0x3234, 0x5555, 0x7ffc, 0x7ffc, 0x7ff7,
  0xff80, 0xff80, 0xff80, 0x3333, 0x5554, 0x7ffb, 0x7ff6, 0x7fcc,
  0xff7f, 0xff7f, 0x007f, 0x3332, 0x5553, 0x7ff5, 0x7fcb, 0x7faa,
  0xff7e, 0x007e, 0x007e, 0x3331, 0x554d, 0x7fca, 0x7fa9, 0x7f82,
  0x007d, 0x007d, 0x007d, 0x332b, 0x5522, 0x7fa8, 0x7f81, 0x7f81,
  0x007c, 0x007c, 0x0077, 0x3300, 0x5500, 0x7f80, 0x7f80, 0x7f80,
  0x007b, 0x0076, 0x004c, 0x32de, 0x54d8, 0x7f7f, 0x7f7f, 0x7f7f,
  0x0075, 0x004b, 0x002a, 0x32b6, 0x54d7, 0x7f7e, 0x7f7e, 0x7f7e,
  0x004a, 0x0029, 0x0002, 0x32b5, 0x54d6, 0x7f7d, 0x7f7d, 0x7f7d,
  0x0028, 0x0001, 0x0001, 0x32b4, 0x54d5, 0x7f7c, 0x7f7c, 0x7f7c,
  0x0000, 0x0000, 0x0000, 0x32b3, 0x54d4, 0x7f7b, 0x7f7b, 0x7f55,
  0xffff, 0xffff, 0xffff, 0x32b2, 0x54d3, 0x7f7a, 0x7f54, 0x7f33,
  0xfffe, 0xfffe, 0xfffe, 0x32b1, 0x54d2, 0x7f53, 0x7f32, 0x7f07,
  0xfffd, 0xfffd, 0xfffd, 0x32b0, 0x54ab, 0x7f31, 0x7f06, 0x7f02,
  0xfffc, 0xfffc, 0xfffc, 0x3289, 0x5489, 0x7f05, 0x7f01, 0x7f01,
  0xfffb, 0xfffb, 0xffd5, 0x3267, 0x545d, 0x7f00, 0x7f00, 0x7f00,
  0xfffb, 0xffd5, 0x3267, 0x545d, 0x7f00, 0x7f00, 0x7f00, 0x8000,
  0xffd4, 0xffb3, 0x323b, 0x5458, 0x7eff, 0x7eff, 0x7fff, 0x7fff,
  0xffb2, 0xff87, 0x3236, 0x5457, 0x7efe, 0x7ffe, 0x7ffe, 0x7ffe,
  0xff86, 0xff82, 0x3235, 0x5456, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ff8,
  0xff81, 0xff81, 0x3234, 0x5555, 0x7ffc, 0x7ffc, 0x7ff7, 0x7fcd,
  0xff80, 0xff80, 0x3333, 0x5554, 0x7ffb, 0x7ff6, 0x7fcc, 0x7fab,
  0xff7f, 0x007f, 0x3332, 0x5553, 0x7ff5, 0x7fcb, 0x7faa, 0x7f83,
  0x007e, 0x007e, 0x3331, 0x554d, 0x7fca, 0x7fa9, 0x7f82, 0x7f82,
  0x007d, 0x007d, 0x332b, 0x5522, 0x7fa8, 0x7f81, 0x7f81, 0x7f81,
  0x007c, 0x0077, 0x3300, 0x5500, 0x7f80, 0x7f80, 0x7f80, 0x7f80,
  0x0076, 0x004c, 0x32de, 0x54d8, 0x7f7f, 0x7f7f, 0x7f7f, 0x7f7f,
  0x004b, 0x002a, 0x32b6, 0x54d7, 0x7f7e, 0x7f7e, 0x7f7e, 0x7f7e,
  0x0029, 0x0002, 0x32b5, 0x54d6, 0x7f7d, 0x7f7d, 0x7f7d, 0x7f7d,
  0x0001, 0x0001, 0x32b4, 0x54d5, 0x7f7c, 0x7f7c, 0x7f7c, 0x7f56,
  0x0000, 0x0000, 0x32b3, 0x54d4, 0x7f7b, 0x7f7b, 0x7f55, 0x7f34,
  0xffff, 0xffff, 0x32b2, 0x54d3, 0x7f7a, 0x7f54, 0x7f33, 0x7f08,
  0xfffe, 0xfffe, 0x32b1, 0x54d2, 0x7f53, 0x7f32, 0x7f07, 0x7f03,
  0xfffd, 0xfffd, 0x32b0, 0x54ab, 0x7f31, 0x7f06, 0x7f02, 0x7f02,
  0xfffc, 0xfffc, 0x3289, 0x5489, 0x7f05, 0x7f01, 0x7f01, 0x7f01,
  0xfffc, 0x3289, 0x5489, 0x7f05, 0x7f01, 0x7f01, 0x7f01, 0x8001,
  0xffd5, 0x3267, 0x545d, 0x7f00, 0x7f00, 0x7f00, 0x8000, 0x8000,
  0xffb3, 0x323b, 0x5458, 0x7eff, 0x7eff, 0x7fff, 0x7fff, 0x7fff,
  0xff87, 0x3236, 0x5457, 0x7efe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ff9,
  0xff82, 0x3235, 0x5456, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ff8, 0x7fce,
  0xff81, 0x3234, 0x5555, 0x7ffc, 0x7ffc, 0x7ff7, 0x7fcd, 0x7fac,
  0xff80, 0x3333, 0x5554, 0x7ffb, 0x7ff6, 0x7fcc, 0x7fab, 0x7f84,
  0x007f, 0x3332, 0x5553, 0x7ff5, 0x7fcb, 0x7faa, 0x7f83, 0x7f83,
  0x007e, 0x3331, 0x554d, 0x7fca, 0x7fa9, 0x7f82, 0x7f82, 0x7f82,
  0x007d, 0x332b, 0x5522, 0x7fa8, 0x7f81, 0x7f81, 0x7f81, 0x7f81,
  0x0077, 0x3300, 0x5500, 0x7f80, 0x7f80, 0x7f80, 0x7f80, 0x7f80,
  0x004c, 0x32de, 0x54d8, 0x7f7f, 0x7f7f, 0x7f7f, 0x7f7f, 0x7f7f,
  0x002a, 0x32b6, 0x54d7, 0x7f7e, 0x7f7e, 0x7f7e, 0x7f7e, 0x7f7e,
  0x0002, 0x32b5, 0x54d6, 0x7f7d, 0x7f7d, 0x7f7d, 0x7f7d, 0x7f57,
  0x0001, 0x32b4, 0x54d5, 0x7f7c, 0x7f7c, 0x7f7c, 0x7f56, 0x7f35,
  0x0000, 0x32b3, 0x54d4, 0x7f7b, 0x7f7b, 0x7f55, 0x7f34, 0x7f09,
  0xffff, 0x32b2, 0x54d3, 0x7f7a, 0x7f54, 0x7f33, 0x7f08, 0x7f04,
  0xfffe, 0x32b1, 0x54d2, 0x7f53, 0x7f32, 0x7f07, 0x7f03, 0x7f03,
  0xfffd, 0x32b0, 0x54ab, 0x7f31, 0x7f06, 0x7f02, 0x7f02, 0x7f02,
  0x32b0, 0x54ab, 0x7f31, 0x7f06, 0x7f02, 0x7f02, 0x7f02, 0xaaaa,
  0x3289, 0x5489, 0x7f05, 0x7f01, 0x7f01, 0x7f01, 0x8001, 0xaaa9,
  0x3267, 0x545d, 0x7f00, 0x7f00, 0x7f00, 0x8000, 0x8000, 0xaaa8,
  0x323b, 0x5458, 0x7eff, 0x7eff, 0x7fff, 0x7fff, 0x7fff, 0xaaa2,
  0x3236, 0x5457, 0x7efe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ff9, 0xaa77,
  0x3235, 0x5456, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ff8, 0x7fce, 0xaa55,
  0x3234, 0x5555, 0x7ffc, 0x7ffc, 0x7ff7, 0x7fcd, 0x7fac, 0xaa2d,
  0x3333, 0x5554, 0x7ffb, 0x7ff6, 0x7fcc, 0x7fab, 0x7f84, 0xaa2c,
  0x3332, 0x5553, 0x7ff5, 0x7fcb, 0x7faa, 0x7f83, 0x7f83, 0xaa2b,
  0x3331, 0x554d, 0x7fca, 0x7fa9, 0x7f82, 0x7f82, 0x7f82, 0xaa2a,
  0x332b, 0x5522, 0x7fa8, 0x7f81, 0x7f81, 0x7f81, 0x7f81, 0xaa29,
  0x3300, 0x5500, 0x7f80, 0x7f80, 0x7f80, 0x7f80, 0x7f80, 0xaa28,
  0x32de, 0x54d8, 0x7f7f, 0x7f7f, 0x7f7f, 0x7f7f, 0x7f7f, 0xaa27,
  0x32b6, 0x54d7, 0x7f7e, 0x7f7e, 0x7f7e, 0x7f7e, 0x7f7e, 0xaa00,
  0x32b5, 0x54d6, 0x7f7d, 0x7f7d, 0x7f7d, 0x7f7d, 0x7f57, 0xa9de,
  0x32b4, 0x54d5, 0x7f7c, 0x7f7c, 0x7f7c, 0x7f56, 0x7f35, 0xa9b2,
  0x32b3, 0x54d4, 0x7f7b, 0x7f7b, 0x7f55, 0x7f34, 0x7f09, 0xa9ad,
  0x32b2, 0x54d3, 0x7f7a, 0x7f54, 0x7f33, 0x7f08, 0x7f04, 0xa9ac,
  0x32b1, 0x54d2, 0x7f53, 0x7f32, 0x7f07, 0x7f03, 0x7f03, 0xa9ab,
  0x54d2, 0x7f53, 0x7f32, 0x7f07, 0x7f03, 0x7f03, 0xa9ab, 0xcccc,
  0x54ab, 0x7f31, 0x7f06, 0x7f02, 0x7f02, 0x7f02, 0xaaaa, 0xcccb,
  0x5489, 0x7f05, 0x7f01, 0x7f01, 0x7f01, 0x8001, 0xaaa9, 0xccca,
  0x545d, 0x7f00, 0x7f00, 0x7f00, 0x8000, 0x8000, 0xaaa8, 0xccc4,
  0x5458, 0x7eff, 0x7eff, 0x7fff, 0x7fff, 0x7fff, 0xaaa2, 0xcc99,
  0x5457, 0x7efe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ff9, 0xaa77, 0xcc77,
  0x5456, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ff8, 0x7fce, 0xaa55, 0xcc4f,
  0x5555, 0x7ffc, 0x7ffc, 0x7ff7, 0x7fcd, 0x7fac, 0xaa2d, 0xcc4e,
  0x5554, 0x7ffb, 0x7ff6, 0x7fcc, 0x7fab, 0x7f84, 0xaa2c, 0xcc4d,
  0x5553, 0x7ff5, 0x7fcb, 0x7faa, 0x7f83, 0x7f83, 0xaa2b, 0xcc4c,
  0x554d, 0x7fca, 0x7fa9, 0x7f82, 0x7f82, 0x7f82, 0xaa2a, 0xcc4b,
  0x5522, 0x7fa8, 0x7f81, 0x7f81, 0x7f81, 0x7f81, 0xaa29, 0xcc4a,
  0x5500, 0x7f80, 0x7f80, 0x7f80, 0x7f80, 0x7f80, 0xaa28, 0xcc49,
  0x54d8, 0x7f7f, 0x7f7f, 0x7f7f, 0x7f7f, 0x7f7f, 0xaa27, 0xcc22,
  0x54d7, 0x7f7e, 0x7f7e, 0x7f7e, 0x7f7e, 0x7f7e, 0xaa00, 0xcc00,
  0x54d6, 0x7f7d, 0x7f7d, 0x7f7d, 0x7f7d, 0x7f57, 0xa9de, 0xcbd4,
  0x54d5, 0x7f7c, 0x7f7c, 0x7f7c, 0x7f56, 0x7f35, 0xa9b2, 0xcbcf,
  0x54d4, 0x7f7b, 0x7f7b, 0x7f55, 0x7f34, 0x7f09, 0xa9ad, 0xcbce,
  0x54d3, 0x7f7a, 0x7f54, 0x7f33, 0x7f08, 0x7f04, 0xa9ac, 0xcbcd,
  0x7f7a, 0x7f54, 0x7f33, 0x7f08, 0x7f04, 0xa9ac, 0xcbcd, 0xff80,
  0x7f53, 0x7f32, 0x7f07, 0x7f03, 0x7f03, 0xa9ab, 0xcccc, 0xff7f,
  0x7f31, 0x7f06, 0x7f02, 0x7f02, 0x7f02, 0xaaaa, 0xcccb, 0xff7e,
  0x7f05, 0x7f01, 0x7f01, 0x7f01, 0x8001, 0xaaa9, 0xccca, 0xff78,
  0x7f00, 0x7f00, 0x7f00, 0x8000, 0x8000, 0xaaa8, 0xccc4, 0xff4d,
  0x7eff, 0x7eff, 0x7fff, 0x7fff, 0x7fff, 0xaaa2, 0xcc99, 0xff2b,
  0x7efe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ff9, 0xaa77, 0xcc77, 0xff03,
  0x7ffd, 0x7ffd, 0x7ffd, 0x7ff8, 0x7fce, 0xaa55, 0xcc4f, 0xff02,
  0x7ffc, 0x7ffc, 0x7ff7, 0x7fcd, 0x7fac, 0xaa2d, 0xcc4e, 0xff01,
  0x7ffb, 0x7ff6, 0x7fcc, 0x7fab, 0x7f84, 0xaa2c, 0xcc4d, 0xff00,
  0x7ff5, 0x7fcb, 0x7faa, 0x7f83, 0x7f83, 0xaa2b, 0xcc4c, 0xfeff,
  0x7fca, 0x7fa9, 0x7f82, 0x7f82, 0x7f82, 0xaa2a, 0xcc4b, 0xfefe,
  0x7fa8, 0x7f81, 0x7f81, 0x7f81, 0x7f81, 0xaa29, 0xcc4a, 0xfefd,
  0x7f80, 0x7f80, 0x7f80, 0x7f80, 0x7f80, 0xaa28, 0xcc49, 0xfed6,
  0x7f7f, 0x7f7f, 0x7f7f, 0x7f7f, 0x7f7f, 0xaa27, 0xcc22, 0xfeb4,
  0x7f7e, 0x7f7e, 0x7f7e, 0x7f7e, 0x7f7e, 0xaa00, 0xcc00, 0xfe88,
  0x7f7d, 0x7f7d, 0x7f7d, 0x7f7d, 0x7f57, 0xa9de, 0xcbd4, 0xfe83,
  0x7f7c, 0x7f7c, 0x7f7c, 0x7f56, 0x7f35, 0xa9b2, 0xcbcf, 0xfe82,
  0x7f7b, 0x7f7b, 0x7f55, 0x7f34, 0x7f09, 0xa9ad, 0xcbce, 0xfe81,
  0x7f7b, 0x7f55, 0x7f34, 0x7f09, 0xa9ad, 0xcbce, 0xfe81, 0xff81,
  0x7f54, 0x7f33, 0x7f08, 0x7f04, 0xa9ac, 0xcbcd, 0xff80, 0xff80,
  0x7f32, 0x7f07, 0x7f03, 0x7f03, 0xa9ab, 0xcccc, 0xff7f, 0xff7f,
  0x7f06, 0x7f02, 0x7f02, 0x7f02, 0xaaaa, 0xcccb, 0xff7e, 0xff79,
  0x7f01, 0x7f01, 0x7f01, 0x8001, 0xaaa9, 0xccca, 0xff78, 0xff4e,
  0x7f00, 0x7f00, 0x8000, 0x8000, 0xaaa8, 0xccc4, 0xff4d, 0xff2c,
  0x7eff, 0x7fff, 0x7fff, 0x7fff, 0xaaa2, 0xcc99, 0xff2b, 0xff04,
  0x7ffe, 0x7ffe, 0x7ffe, 0x7ff9, 0xaa77, 0xcc77, 0xff03, 0xff03,
  0x7ffd, 0x7ffd, 0x7ff8, 0x7fce, 0xaa55, 0xcc4f, 0xff02, 0xff02,
  0x7ffc, 0x7ff7, 0x7fcd, 0x7fac, 0xaa2d, 0xcc4e, 0xff01, 0xff01,
  0x7ff6, 0x7fcc, 0x7fab, 0x7f84, 0xaa2c, 0xcc4d, 0xff00, 0xff00,
  0x7fcb, 0x7faa, 0x7f83, 0x7f83, 0xaa2b, 0xcc4c, 0xfeff, 0xfeff,
  0x7fa9, 0x7f82, 0x7f82, 0x7f82, 0xaa2a, 0xcc4b, 0xfefe, 0xfefe,
  0x7f81, 0x7f81, 0x7f81, 0x7f81, 0xaa29, 0xcc4a, 0xfefd, 0xfed7,
  0x7f80, 0x7f80, 0x7f80, 0x7f80, 0xaa28, 0xcc49, 0xfed6, 0xfeb5,
  0x7f7f, 0x7f7f, 0x7f7f, 0x7f7f, 0xaa27, 0xcc22, 0xfeb4, 0xfe89,
  0x7f7e, 0x7f7e, 0x7f7e, 0x7f7e, 0xaa00, 0xcc00, 0xfe88, 0xfe84,
  0x7f7d, 0x7f7d, 0x7f7d, 0x7f57, 0xa9de, 0xcbd4, 0xfe83, 0xfe83,
  0x7f7c, 0x7f7c, 0x7f56, 0x7f35, 0xa9b2, 0xcbcf, 0xfe82, 0xfe82,
  0x7f7c, 0x7f56, 0x7f35, 0xa9b2, 0xcbcf, 0xfe82, 0xfe82, 0xff82,
  0x7f55, 0x7f34, 0x7f09, 0xa9ad, 0xcbce, 0xfe81, 0xff81, 0xff81,
  0x7f33, 0x7f08, 0x7f04, 0xa9ac, 0xcbcd, 0xff80, 0xff80, 0xff80,
  0x7f07, 0x7f03, 0x7f03, 0xa9ab, 0xcccc, 0xff7f, 0xff7f, 0xff7a,
  0x7f02, 0x7f02, 0x7f02, 0xaaaa, 0xcccb, 0xff7e, 0xff79, 0xff4f,
  0x7f01, 0x7f01, 0x8001, 0xaaa9, 0xccca, 0xff78, 0xff4e, 0xff2d,
  0x7f00, 0x8000, 0x8000, 0xaaa8, 0xccc4, 0xff4d, 0xff2c, 0xff05,
  0x7fff, 0x7fff, 0x7fff, 0xaaa2, 0xcc99, 0xff2b, 0xff04, 0xff04,
  0x7ffe, 0x7ffe, 0x7ff9, 0xaa77, 0xcc77, 0xff03, 0xff03, 0xff03,
  0x7ffd, 0x7ff8, 0x7fce, 0xaa55, 0xcc4f, 0xff02, 0xff02, 0xff02,
  0x7ff7, 0x7fcd, 0x7fac, 0xaa2d, 0xcc4e, 0xff01, 0xff01, 0xff01,
  0x7fcc, 0x7fab, 0x7f84, 0xaa2c, 0xcc4d, 0xff00, 0xff00, 0xff00,
  0x7faa, 0x7f83, 0x7f83, 0xaa2b, 0xcc4c, 0xfeff, 0xfeff, 0xfeff,
  0x7f82, 0x7f82, 0x7f82, 0xaa2a, 0xcc4b, 0xfefe, 0xfefe, 0xfed8,
  0x7f81, 0x7f81, 0x7f81, 0xaa29, 0xcc4a, 0xfefd, 0xfed7, 0xfeb6,
  0x7f80, 0x7f80, 0x7f80, 0xaa28, 0xcc49, 0xfed6, 0xfeb5, 0xfe8a,
  0x7f7f, 0x7f7f, 0x7f7f, 0xaa27, 0xcc22, 0xfeb4, 0xfe89, 0xfe85,
  0x7f7e, 0x7f7e, 0x7f7e, 0xaa00, 0xcc00, 0xfe88, 0xfe84, 0xfe84,
  0x7f7d, 0x7f7d, 0x7f57, 0xa9de, 0xcbd4, 0xfe83, 0xfe83, 0xfe83,
  0x7f7d, 0x7f57, 0xa9de, 0xcbd4, 0xfe83, 0xfe83, 0xfe83, 0xff83,
  0x7f56, 0x7f35, 0xa9b2, 0xcbcf, 0xfe82, 0xfe82, 0xff82, 0xff82,
  0x7f34, 0x7f09, 0xa9ad, 0xcbce, 0xfe81, 0xff81, 0xff81, 0xff81,
  0x7f08, 0x7f04, 0xa9ac, 0xcbcd, 0xff80, 0xff80, 0xff80, 0xff7b,
  0x7f03, 0x7f03, 0xa9ab, 0xcccc, 0xff7f, 0xff7f, 0xff7a, 0xff50,
  0x7f02, 0x7f02, 0xaaaa, 0xcccb, 0xff7e, 0xff79, 0xff4f, 0xff2e,
  0x7f01, 0x8001, 0xaaa9, 0xccca, 0xff78, 0xff4e, 0xff2d, 0xff06,
  0x8000, 0x8000, 0xaaa8, 0xccc4, 0xff4d, 0xff2c, 0xff05, 0xff05,
  0x7fff, 0x7fff, 0xaaa2, 0xcc99, 0xff2b, 0xff04, 0xff04, 0xff04,
  0x7ffe, 0x7ff9, 0xaa77, 0xcc77, 0xff03, 0xff03, 0xff03, 0xff03,
  0x7ff8, 0x7fce, 0xaa55, 0xcc4f, 0xff02, 0xff02, 0xff02, 0xff02,
  0x7fcd, 0x7fac, 0xaa2d, 0xcc4e, 0xff01, 0xff01, 0xff01, 0xff01,
  0x7fab, 0x7f84, 0xaa2c, 0xcc4d, 0xff00, 0xff00, 0xff00, 0xff00,
  0x7f83, 0x7f83, 0xaa2b, 0xcc4c, 0xfeff, 0xfeff, 0xfeff, 0xfed9,
  0x7f82, 0x7f82, 0xaa2a, 0xcc4b, 0xfefe, 0xfefe, 0xfed8, 0xfeb7,
  0x7f81, 0x7f81, 0xaa29, 0xcc4a, 0xfefd, 0xfed7, 0xfeb6, 0xfe8b,
  0x7f80, 0x7f80, 0xaa28, 0xcc49, 0xfed6, 0xfeb5, 0xfe8a, 0xfe86,
  0x7f7f, 0x7f7f, 0xaa27, 0xcc22, 0xfeb4, 0xfe89, 0xfe85, 0xfe85,
  0x7f7e, 0x7f7e, 0xaa00, 0xcc00, 0xfe88, 0xfe84, 0xfe84, 0xfe84,
  0x7f7e, 0xaa00, 0xcc00, 0xfe88, 0xfe84, 0xfe84, 0xfe84, 0xfff0,
  0x7f57, 0xa9de, 0xcbd4, 0xfe83, 0xfe83, 0xfe83, 0xff83, 0xffef,
  0x7f35, 0xa9b2, 0xcbcf, 0xfe82, 0xfe82, 0xff82, 0xff82, 0xffee,
  0x7f09, 0xa9ad, 0xcbce, 0xfe81, 0xff81, 0xff81, 0xff81, 0xffe8,
  0x7f04, 0xa9ac, 0xcbcd, 0xff80, 0xff80, 0xff80, 0xff7b, 0xffbd,
  0x7f03, 0xa9ab, 0xcccc, 0xff7f, 0xff7f, 0xff7a, 0xff50, 0xff9b,
  0x7f02, 0xaaaa, 0xcccb, 0xff7e, 0xff79, 0xff4f, 0xff2e, 0xff73,
  0x8001, 0xaaa9, 0xccca, 0xff78, 0xff4e, 0xff2d, 0xff06, 0xff72,
  0x8000, 0xaaa8, 0xccc4, 0xff4d, 0xff2c, 0xff05, 0xff05, 0xff71,
  0x7fff, 0xaaa2, 0xcc99, 0xff2b, 0xff04, 0xff04, 0xff04, 0xff70,
  0x7ff9, 0xaa77, 0xcc77, 0xff03, 0xff03, 0xff03, 0xff03, 0xff6f,
  0x7fce, 0xaa55, 0xcc4f, 0xff02, 0xff02, 0xff02, 0xff02, 0xff6e,
  0x7fac, 0xaa2d, 0xcc4e, 0xff01, 0xff01, 0xff01, 0xff01, 0xff6d,
  0x7f84, 0xaa2c, 0xcc4d, 0xff00, 0xff00, 0xff00, 0xff00, 0xff46,
  0x7f83, 0xaa2b, 0xcc4c, 0xfeff, 0xfeff, 0xfeff, 0xfed9, 0xff24,
  0x7f82, 0xaa2a, 0xcc4b, 0xfefe, 0xfefe, 0xfed8, 0xfeb7, 0xfef8,
  0x7f81, 0xaa29, 0xcc4a, 0xfefd, 0xfed7, 0xfeb6, 0xfe8b, 0xfef3,
  0x7f80, 0xaa28, 0xcc49, 0xfed6, 0xfeb5, 0xfe8a, 0xfe86, 0xfef2,
  0x7f7f, 0xaa27, 0xcc22, 0xfeb4, 0xfe89, 0xfe85, 0xfe85, 0xfef1,
  0xaa27, 0xcc22, 0xfeb4, 0xfe89, 0xfe85, 0xfe85, 0xfef1, 0xfffd,
  0xaa00, 0xcc00, 0xfe88, 0xfe84, 0xfe84, 0xfe84, 0xfff0, 0xfffc,
  0xa9de, 0xcbd4, 0xfe83, 0xfe83, 0xfe83, 0xff83, 0xffef, 0xfffb,
  0xa9b2, 0xcbcf, 0xfe82, 0xfe82, 0xff82, 0xff82, 0xffee, 0xfff5,
  0xa9ad, 0xcbce, 0xfe81, 0xff81, 0xff81, 0xff81, 0xffe8, 0xffca,
  0xa9ac, 0xcbcd, 0xff80, 0xff80, 0xff80, 0xff7b, 0xffbd, 0xffa8,
  0xa9ab, 0xcccc, 0xff7f, 0xff7f, 0xff7a, 0xff50, 0xff9b, 0xff80,
  0xaaaa, 0xcccb, 0xff7e, 0xff79, 0xff4f, 0xff2e, 0xff73, 0xff7f,
  0xaaa9, 0xccca, 0xff78, 0xff4e, 0xff2d, 0xff06, 0xff72, 0xff7e,
  0xaaa8, 0xccc4, 0xff4d, 0xff2c, 0xff05, 0xff05, 0xff71, 0xff7d,
  0xaaa2, 0xcc99, 0xff2b, 0xff04, 0xff04, 0xff04, 0xff70, 0xff7c,
  0xaa77, 0xcc77, 0xff03, 0xff03, 0xff03, 0xff03, 0xff6f, 0xff7b,
  0xaa55, 0xcc4f, 0xff02, 0xff02, 0xff02, 0xff02, 0xff6e, 0xff7a,
  0xaa2d, 0xcc4e, 0xff01, 0xff01, 0xff01, 0xff01, 0xff6d, 0xff53,
  0xaa2c, 0xcc4d, 0xff00, 0xff00, 0xff00, 0xff00, 0xff46, 0xff31,
  0xaa2b, 0xcc4c, 0xfeff, 0xfeff, 0xfeff, 0xfed9, 0xff24, 0xff05,
  0xaa2a, 0xcc4b, 0xfefe, 0xfefe, 0xfed8, 0xfeb7, 0xfef8, 0xff00,
  0xaa29, 0xcc4a, 0xfefd, 0xfed7, 0xfeb6, 0xfe8b, 0xfef3, 0xfeff,
  0xaa28, 0xcc49, 0xfed6, 0xfeb5, 0xfe8a, 0xfe86, 0xfef2, 0xfefe,
  0xcc49, 0xfed6, 0xfeb5, 0xfe8a, 0xfe86, 0xfef2, 0xfefe, 0xfffe,
  0xcc22, 0xfeb4, 0xfe89, 0xfe85, 0xfe85, 0xfef1, 0xfffd, 0xfffd,
  0xcc00, 0xfe88, 0xfe84, 0xfe84, 0xfe84, 0xfff0, 0xfffc, 0xfffc,
  0xcbd4, 0xfe83, 0xfe83, 0xfe83, 0xff83, 0xffef, 0xfffb, 0xfff6,
  0xcbcf, 0xfe82, 0xfe82, 0xff82, 0xff82, 0xffee, 0xfff5, 0xffcb,
  0xcbce, 0xfe81, 0xff81, 0xff81, 0xff81, 0xffe8, 0xffca, 0xffa9,
  0xcbcd, 0xff80, 0xff80, 0xff80, 0xff7b, 0xffbd, 0xffa8, 0xff81,
  0xcccc, 0xff7f, 0xff7f, 0xff7a, 0xff50, 0xff9b, 0xff80, 0xff80,
  0xcccb, 0xff7e, 0xff79, 0xff4f, 0xff2e, 0xff73, 0xff7f, 0xff7f,
  0xccca, 0xff78, 0xff4e, 0xff2d, 0xff06, 0xff72, 0xff7e, 0xff7e,
  0xccc4, 0xff4d, 0xff2c, 0xff05, 0xff05, 0xff71, 0xff7d, 0xff7d,
  0xcc99, 0xff2b, 0xff04, 0xff04, 0xff04, 0xff70, 0xff7c, 0xff7c,
  0xcc77, 0xff03, 0xff03, 0xff03, 0xff03, 0xff6f, 0xff7b, 0xff7b,
  0xcc4f, 0xff02, 0xff02, 0xff02, 0xff02, 0xff6e, 0xff7a, 0xff54,
  0xcc4e, 0xff01, 0xff01, 0xff01, 0xff01, 0xff6d, 0xff53, 0xff32,
  0xcc4d, 0xff00, 0xff00, 0xff00, 0xff00, 0xff46, 0xff31, 0xff06,
  0xcc4c, 0xfeff, 0xfeff, 0xfeff, 0xfed9, 0xff24, 0xff05, 0xff01,
  0xcc4b, 0xfefe, 0xfefe, 0xfed8, 0xfeb7, 0xfef8, 0xff00, 0xff00,
  0xcc4a, 0xfefd, 0xfed7, 0xfeb6, 0xfe8b, 0xfef3, 0xfeff, 0xfeff,
  0xfefd, 0xfed7, 0xfeb6, 0xfe8b, 0xfef3, 0xfeff, 0xfeff, 0xffff,
  0xfed6, 0xfeb5, 0xfe8a, 0xfe86, 0xfef2, 0xfefe, 0xfffe, 0xfffe,
  0xfeb4, 0xfe89, 0xfe85, 0xfe85, 0xfef1, 0xfffd, 0xfffd, 0xfffd,
  0xfe88, 0xfe84, 0xfe84, 0xfe84, 0xfff0, 0xfffc, 0xfffc, 0xfff7,
  0xfe83, 0xfe83, 0xfe83, 0xff83, 0xffef, 0xfffb, 0xfff6, 0xffcc,
  0xfe82, 0xfe82, 0xff82, 0xff82, 0xffee, 0xfff5, 0xffcb, 0xffaa,
  0xfe81, 0xff81, 0xff81, 0xff81, 0xffe8, 0xffca, 0xffa9, 0xff82,
  0xff80, 0xff80, 0xff80, 0xff7b, 0xffbd, 0xffa8, 0xff81, 0xff81,
  0xff7f, 0xff7f, 0xff7a, 0xff50, 0xff9b, 0xff80, 0xff80, 0xff80,
  0xff7e, 0xff79, 0xff4f, 0xff2e, 0xff73, 0xff7f, 0xff7f, 0xff7f,
  0xff78, 0xff4e, 0xff2d, 0xff06, 0xff72, 0xff7e, 0xff7e, 0xff7e,
  0xff4d, 0xff2c, 0xff05, 0xff05, 0xff71, 0xff7d, 0xff7d, 0xff7d,
  0xff2b, 0xff04, 0xff04, 0xff04, 0xff70, 0xff7c, 0xff7c, 0xff7c,
  0xff03, 0xff03, 0xff03, 0xff03, 0xff6f, 0xff7b, 0xff7b, 0xff55,
  0xff02, 0xff02, 0xff02, 0xff02, 0xff6e, 0xff7a, 0xff54, 0xff33,
  0xff01, 0xff01, 0xff01, 0xff01, 0xff6d, 0xff53, 0xff32, 0xff07,
  0xff00, 0xff00, 0xff00, 0xff00, 0xff46, 0xff31, 0xff06, 0xff02,
  0xfeff, 0xfeff, 0xfeff, 0xfed9, 0xff24, 0xff05, 0xff01, 0xff01,
  0xfefe, 0xfefe, 0xfed8, 0xfeb7, 0xfef8, 0xff00, 0xff00, 0xff00,
};
const unsigned kExpectedCount_NEON_usubw2_8H = 456;

#endif  // VIXL_SIM_USUBW2_8H_TRACE_AARCH64_H_
