package cwe

// Cwe has CWE information
type Cwe struct {
	CweID               string `json:"cweID"`
	Name                string `json:"name"`
	Description         string `json:"description"`
	ExtendedDescription string `json:"extendedDescription"`
	Lang                string `json:"-"`
}

// CweDictEn is the Cwe dictionary
var CweDictEn = map[string]Cwe{
	"1004": {
		CweID:               "1004",
		Name:                "Sensitive Cookie Without 'HttpOnly' Flag",
		Description:         "The software uses a cookie to store sensitive information, but the cookie is not marked with the HttpOnly flag.",
		ExtendedDescription: "The HttpOnly flag directs compatible browsers to prevent client-side script from accessing cookies. Including the HttpOnly flag in the Set-Cookie HTTP response header helps mitigate the risk associated with Cross-Site Scripting (XSS) where an attacker's script code might attempt to read the contents of a cookie and exfiltrate information obtained. When set, browsers that support the flag will not reveal the contents of the cookie to a third party via client-side script executed via XSS.",
		Lang:                "en",
	},
	"1007": {
		CweID:               "1007",
		Name:                "Insufficient Visual Distinction of Homoglyphs Presented to User",
		Description:         "The software displays information or identifiers to a user, but the display mechanism does not make it easy for the user to distinguish between visually similar or identical glyphs (homoglyphs), which may cause the user to misinterpret a glyph and perform an unintended, insecure action.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"102": {
		CweID:               "102",
		Name:                "Struts: Duplicate Validation Forms",
		Description:         "The application uses multiple validation forms with the same name, which might cause the Struts Validator to validate a form that the programmer does not expect.",
		ExtendedDescription: "If two validation forms have the same name, the Struts Validator arbitrarily chooses one of the forms to use for input validation and discards the other. This decision might not correspond to the programmer's expectations, possibly leading to resultant weaknesses. Moreover, it indicates that the validation logic is not up-to-date, and can indicate that other, more subtle validation errors are present.",
		Lang:                "en",
	},
	"1021": {
		CweID:               "1021",
		Name:                "Improper Restriction of Rendered UI Layers or Frames",
		Description:         "The web application does not restrict or incorrectly restricts frame objects or UI layers that belong to another application or domain, which can lead to user confusion about which interface the user is interacting with.",
		ExtendedDescription: "A web application is expected to place restrictions on whether it is allowed to be rendered within frames, iframes, objects, embed or applet elements. Without the restrictions, users can be tricked into interacting with the application when they were not intending to.",
		Lang:                "en",
	},
	"1022": {
		CweID:               "1022",
		Name:                "Improper Restriction of Cross-Origin Permission to window.opener.location",
		Description:         "The web application does not restrict or incorrectly restricts modification of its window opener object's location property by an external application from a different origin.",
		ExtendedDescription: "By default, many browsers that open a link to an external application with a target specified as a new window/tab provide cross-origin access to the location property via a window.opener object. This enables the external application to choose a location to redirect the calling web application, e.g. for a phishing attack.",
		Lang:                "en",
	},
	"1023": {
		CweID:               "1023",
		Name:                "Incomplete Comparison with Missing Factors",
		Description:         "The software performs a comparison between entities that must consider multiple factors or characteristics of each entity, but the comparison does not include one or more of these factors. This can lead to resultant weaknesses, e.g. by operating on the wrong object.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"1024": {
		CweID:               "1024",
		Name:                "Comparison of Incompatible Types",
		Description:         "The software performs a comparison between two entities, but the entities are of different, incompatible types that cannot be guaranteed to provide correct results when they are directly compared.",
		ExtendedDescription: "In languages that are strictly typed but support casting/conversion, such as C or C++, the programmer might assume that casting one entity to the same type as another entity will ensure that the comparison will be performed correctly, but this cannot be guaranteed.  In languages that are not strictly typed, such as PHP or JavaScript, there may be implicit casting/conversion to a type that the programmer is unaware of, causing unexpected results; for example, the string '123' might be converted to a number type.  See examples.",
		Lang:                "en",
	},
	"1025": {
		CweID:               "1025",
		Name:                "Comparison Using Wrong Factors",
		Description:         "The software performs a comparison between two entities, but the comparison examines the wrong factors or characteristics of the entities, which can lead to incorrect results and resultant weaknesses.",
		ExtendedDescription: "A common example of this weakness occurs when the code inadvertently extracts the reference to an object, instead of its relevant contents.",
		Lang:                "en",
	},
	"103": {
		CweID:               "103",
		Name:                "Struts: Incomplete validate() Method Definition",
		Description:         "The application has a validator form that either does not define a validate() method, or defines a validate() method but does not call super.validate().",
		ExtendedDescription: "If you do not call super.validate(), the Validation Framework cannot check the contents of the form against a validation form. In other words, the validation framework will be disabled for the given form.",
		Lang:                "en",
	},
	"104": {
		CweID:               "104",
		Name:                "Struts: Form Bean Does Not Extend Validation Class",
		Description:         "If a form bean does not extend an ActionForm subclass of the Validator framework, it can expose the application to other weaknesses related to insufficient input validation.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"105": {
		CweID:               "105",
		Name:                "Struts: Form Field Without Validator",
		Description:         "The application has a form field that is not validated by a corresponding validation form, which can introduce other weaknesses related to insufficient input validation.",
		ExtendedDescription: "Omitting validation for even a single input field may give attackers the leeway they need to compromise the application. Although J2EE applications are not generally susceptible to memory corruption attacks, if a J2EE application interfaces with native code that does not perform array bounds checking, an attacker may be able to use an input validation mistake in the J2EE application to launch a buffer overflow attack.",
		Lang:                "en",
	},
	"106": {
		CweID:               "106",
		Name:                "Struts: Plug-in Framework not in Use",
		Description:         "When an application does not use an input validation framework such as the Struts Validator, there is a greater risk of introducing weaknesses related to insufficient input validation.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"107": {
		CweID:               "107",
		Name:                "Struts: Unused Validation Form",
		Description:         "An unused validation form indicates that validation logic is not up-to-date.",
		ExtendedDescription: "It is easy for developers to forget to update validation logic when they remove or rename action form mappings. One indication that validation logic is not being properly maintained is the presence of an unused validation form.",
		Lang:                "en",
	},
	"108": {
		CweID:               "108",
		Name:                "Struts: Unvalidated Action Form",
		Description:         "Every Action Form must have a corresponding validation form.",
		ExtendedDescription: "If a Struts Action Form Mapping specifies a form, it must have a validation form defined under the Struts Validator.",
		Lang:                "en",
	},
	"109": {
		CweID:               "109",
		Name:                "Struts: Validator Turned Off",
		Description:         "Automatic filtering via a Struts bean has been turned off, which disables the Struts Validator and custom validation logic. This exposes the application to other weaknesses related to insufficient input validation.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"11": {
		CweID:               "11",
		Name:                "ASP.NET Misconfiguration: Creating Debug Binary",
		Description:         "Debugging messages help attackers learn about the system and plan a form of attack.",
		ExtendedDescription: "ASP .NET applications can be configured to produce debug binaries. These binaries give detailed debugging messages and should not be used in production environments. Debug binaries are meant to be used in a development or testing environment and can pose a security risk if they are deployed to production.",
		Lang:                "en",
	},
	"110": {
		CweID:               "110",
		Name:                "Struts: Validator Without Form Field",
		Description:         "Validation fields that do not appear in forms they are associated with indicate that the validation logic is out of date.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"111": {
		CweID:               "111",
		Name:                "Direct Use of Unsafe JNI",
		Description:         "When a Java application uses the Java Native Interface (JNI) to call code written in another programming language, it can expose the application to weaknesses in that code, even if those weaknesses cannot occur in Java.",
		ExtendedDescription: "Many safety features that programmers may take for granted simply do not apply for native code, so you must carefully review all such code for potential problems. The languages used to implement native code may be more susceptible to buffer overflows and other attacks. Native code is unprotected by the security features enforced by the runtime environment, such as strong typing and array bounds checking.",
		Lang:                "en",
	},
	"112": {
		CweID:               "112",
		Name:                "Missing XML Validation",
		Description:         "The software accepts XML from an untrusted source but does not validate the XML against the proper schema.",
		ExtendedDescription: "Most successful attacks begin with a violation of the programmer's assumptions. By accepting an XML document without validating it against a DTD or XML schema, the programmer leaves a door open for attackers to provide unexpected, unreasonable, or malicious input.",
		Lang:                "en",
	},
	"113": {
		CweID:               "113",
		Name:                "Improper Neutralization of CRLF Sequences in HTTP Headers ('HTTP Response Splitting')",
		Description:         "The software receives data from an upstream component, but does not neutralize or incorrectly neutralizes CR and LF characters before the data is included in outgoing HTTP headers.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"114": {
		CweID:               "114",
		Name:                "Process Control",
		Description:         "Executing commands or loading libraries from an untrusted source or in an untrusted environment can cause an application to execute malicious commands (and payloads) on behalf of an attacker.",
		ExtendedDescription: "Process control vulnerabilities take two forms: 1. An attacker can change the command that the program executes: the attacker explicitly controls what the command is. 2. An attacker can change the environment in which the command executes: the attacker implicitly controls what the command means. Process control vulnerabilities of the first type occur when either data enters the application from an untrusted source and the data is used as part of a string representing a command that is executed by the application. By executing the command, the application gives an attacker a privilege or capability that the attacker would not otherwise have.",
		Lang:                "en",
	},
	"115": {
		CweID:               "115",
		Name:                "Misinterpretation of Input",
		Description:         "The software misinterprets an input, whether from an attacker or another product, in a security-relevant fashion.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"116": {
		CweID:               "116",
		Name:                "Improper Encoding or Escaping of Output",
		Description:         "The software prepares a structured message for communication with another component, but encoding or escaping of the data is either missing or done incorrectly. As a result, the intended structure of the message is not preserved.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"117": {
		CweID:               "117",
		Name:                "Improper Output Neutralization for Logs",
		Description:         "The software does not neutralize or incorrectly neutralizes output that is written to logs.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"118": {
		CweID:               "118",
		Name:                "Incorrect Access of Indexable Resource ('Range Error')",
		Description:         "The software does not restrict or incorrectly restricts operations within the boundaries of a resource that is accessed using an index or pointer, such as memory or files.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"119": {
		CweID:               "119",
		Name:                "Improper Restriction of Operations within the Bounds of a Memory Buffer",
		Description:         "The software performs operations on a memory buffer, but it can read from or write to a memory location that is outside of the intended boundary of the buffer.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"12": {
		CweID:               "12",
		Name:                "ASP.NET Misconfiguration: Missing Custom Error Page",
		Description:         "An ASP .NET application must enable custom error pages in order to prevent attackers from mining information from the framework's built-in responses.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"120": {
		CweID:               "120",
		Name:                "Buffer Copy without Checking Size of Input ('Classic Buffer Overflow')",
		Description:         "The program copies an input buffer to an output buffer without verifying that the size of the input buffer is less than the size of the output buffer, leading to a buffer overflow.",
		ExtendedDescription: "A buffer overflow condition exists when a program attempts to put more data in a buffer than it can hold, or when a program attempts to put data in a memory area outside of the boundaries of a buffer. The simplest type of error, and the most common cause of buffer overflows, is the 'classic' case in which the program copies the buffer without restricting how much is copied. Other variants exist, but the existence of a classic overflow strongly suggests that the programmer is not considering even the most basic of security protections.",
		Lang:                "en",
	},
	"121": {
		CweID:               "121",
		Name:                "Stack-based Buffer Overflow",
		Description:         "A stack-based buffer overflow condition is a condition where the buffer being overwritten is allocated on the stack (i.e., is a local variable or, rarely, a parameter to a function).",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"122": {
		CweID:               "122",
		Name:                "Heap-based Buffer Overflow",
		Description:         "A heap overflow condition is a buffer overflow, where the buffer that can be overwritten is allocated in the heap portion of memory, generally meaning that the buffer was allocated using a routine such as malloc().",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"123": {
		CweID:               "123",
		Name:                "Write-what-where Condition",
		Description:         "Any condition where the attacker has the ability to write an arbitrary value to an arbitrary location, often as the result of a buffer overflow.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"124": {
		CweID:               "124",
		Name:                "Buffer Underwrite ('Buffer Underflow')",
		Description:         "The software writes to a buffer using an index or pointer that references a memory location prior to the beginning of the buffer.",
		ExtendedDescription: "This typically occurs when a pointer or its index is decremented to a position before the buffer, when pointer arithmetic results in a position before the beginning of the valid memory location, or when a negative index is used.",
		Lang:                "en",
	},
	"125": {
		CweID:               "125",
		Name:                "Out-of-bounds Read",
		Description:         "The software reads data past the end, or before the beginning, of the intended buffer.",
		ExtendedDescription: "This typically occurs when the pointer or its index is incremented or decremented to a position beyond the bounds of the buffer or when pointer arithmetic results in a position outside of the valid memory location to name a few. This may result in corruption of sensitive information, a crash, or code execution among other things.",
		Lang:                "en",
	},
	"126": {
		CweID:               "126",
		Name:                "Buffer Over-read",
		Description:         "The software reads from a buffer using buffer access mechanisms such as indexes or pointers that reference memory locations after the targeted buffer.",
		ExtendedDescription: "This typically occurs when the pointer or its index is incremented to a position beyond the bounds of the buffer or when pointer arithmetic results in a position outside of the valid memory location to name a few. This may result in exposure of sensitive information or possibly a crash.",
		Lang:                "en",
	},
	"127": {
		CweID:               "127",
		Name:                "Buffer Under-read",
		Description:         "The software reads from a buffer using buffer access mechanisms such as indexes or pointers that reference memory locations prior to the targeted buffer.",
		ExtendedDescription: "This typically occurs when the pointer or its index is decremented to a position before the buffer, when pointer arithmetic results in a position before the beginning of the valid memory location, or when a negative index is used. This may result in exposure of sensitive information or possibly a crash.",
		Lang:                "en",
	},
	"128": {
		CweID:               "128",
		Name:                "Wrap-around Error",
		Description:         "Wrap around errors occur whenever a value is incremented past the maximum value for its type and therefore 'wraps around' to a very small, negative, or undefined value.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"129": {
		CweID:               "129",
		Name:                "Improper Validation of Array Index",
		Description:         "The product uses untrusted input when calculating or using an array index, but the product does not validate or incorrectly validates the index to ensure the index references a valid position within the array.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"13": {
		CweID:               "13",
		Name:                "ASP.NET Misconfiguration: Password in Configuration File",
		Description:         "Storing a plaintext password in a configuration file allows anyone who can read the file access to the password-protected resource making them an easy target for attackers.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"130": {
		CweID:               "130",
		Name:                "Improper Handling of Length Parameter Inconsistency",
		Description:         "The software parses a formatted message or structure, but it does not handle or incorrectly handles a length field that is inconsistent with the actual length of the associated data.",
		ExtendedDescription: "If an attacker can manipulate the length parameter associated with an input such that it is inconsistent with the actual length of the input, this can be leveraged to cause the target application to behave in unexpected, and possibly, malicious ways. One of the possible motives for doing so is to pass in arbitrarily large input to the application. Another possible motivation is the modification of application state by including invalid data for subsequent properties of the application. Such weaknesses commonly lead to attacks such as buffer overflows and execution of arbitrary code.",
		Lang:                "en",
	},
	"131": {
		CweID:               "131",
		Name:                "Incorrect Calculation of Buffer Size",
		Description:         "The software does not correctly calculate the size to be used when allocating a buffer, which could lead to a buffer overflow.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"132": {
		CweID:               "132",
		Name:                "DEPRECATED (Duplicate): Miscalculated Null Termination",
		Description:         "This entry has been deprecated because it was a duplicate of CWE-170. All content has been transferred to CWE-170.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"134": {
		CweID:               "134",
		Name:                "Use of Externally-Controlled Format String",
		Description:         "The software uses a function that accepts a format string as an argument, but the format string originates from an external source.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"135": {
		CweID:               "135",
		Name:                "Incorrect Calculation of Multi-Byte String Length",
		Description:         "The software does not correctly calculate the length of strings that can contain wide or multi-byte characters.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"138": {
		CweID:               "138",
		Name:                "Improper Neutralization of Special Elements",
		Description:         "The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as control elements or syntactic markers when they are sent to a downstream component.",
		ExtendedDescription: "Most languages and protocols have their own special elements such as characters and reserved words. These special elements can carry control implications. If software does not prevent external control or influence over the inclusion of such special elements, the control flow of the program may be altered from what was intended. For example, both Unix and Windows interpret the symbol < ('less than') as meaning 'read input from a file'.",
		Lang:                "en",
	},
	"14": {
		CweID:               "14",
		Name:                "Compiler Removal of Code to Clear Buffers",
		Description:         "Sensitive memory is cleared according to the source code, but compiler optimizations leave the memory untouched when it is not read from again, aka 'dead store removal.'",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"140": {
		CweID:               "140",
		Name:                "Improper Neutralization of Delimiters",
		Description:         "The software does not neutralize or incorrectly neutralizes delimiters.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"141": {
		CweID:               "141",
		Name:                "Improper Neutralization of Parameter/Argument Delimiters",
		Description:         "The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as parameter or argument delimiters when they are sent to a downstream component.",
		ExtendedDescription: "As data is parsed, an injected/absent/malformed delimiter may cause the process to take unexpected actions.",
		Lang:                "en",
	},
	"142": {
		CweID:               "142",
		Name:                "Improper Neutralization of Value Delimiters",
		Description:         "The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as value delimiters when they are sent to a downstream component.",
		ExtendedDescription: "As data is parsed, an injected/absent/malformed delimiter may cause the process to take unexpected actions.",
		Lang:                "en",
	},
	"143": {
		CweID:               "143",
		Name:                "Improper Neutralization of Record Delimiters",
		Description:         "The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as record delimiters when they are sent to a downstream component.",
		ExtendedDescription: "As data is parsed, an injected/absent/malformed delimiter may cause the process to take unexpected actions.",
		Lang:                "en",
	},
	"144": {
		CweID:               "144",
		Name:                "Improper Neutralization of Line Delimiters",
		Description:         "The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as line delimiters when they are sent to a downstream component.",
		ExtendedDescription: "As data is parsed, an injected/absent/malformed delimiter may cause the process to take unexpected actions.",
		Lang:                "en",
	},
	"145": {
		CweID:               "145",
		Name:                "Improper Neutralization of Section Delimiters",
		Description:         "The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as section delimiters when they are sent to a downstream component.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"146": {
		CweID:               "146",
		Name:                "Improper Neutralization of Expression/Command Delimiters",
		Description:         "The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as expression or command delimiters when they are sent to a downstream component.",
		ExtendedDescription: "As data is parsed, an injected/absent/malformed delimiter may cause the process to take unexpected actions.",
		Lang:                "en",
	},
	"147": {
		CweID:               "147",
		Name:                "Improper Neutralization of Input Terminators",
		Description:         "The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as input terminators when they are sent to a downstream component.",
		ExtendedDescription: "For example, a '.' in SMTP signifies the end of mail message data, whereas a null character can be used for the end of a string.",
		Lang:                "en",
	},
	"148": {
		CweID:               "148",
		Name:                "Improper Neutralization of Input Leaders",
		Description:         "The application does not properly handle when a leading character or sequence ('leader') is missing or malformed, or if multiple leaders are used when only one should be allowed.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"149": {
		CweID:               "149",
		Name:                "Improper Neutralization of Quoting Syntax",
		Description:         "Quotes injected into an application can be used to compromise a system. As data are parsed, an injected/absent/duplicate/malformed use of quotes may cause the process to take unexpected actions.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"15": {
		CweID:               "15",
		Name:                "External Control of System or Configuration Setting",
		Description:         "One or more system settings or configuration elements can be externally controlled by a user.",
		ExtendedDescription: "Allowing external control of system settings can disrupt service or cause an application to behave in unexpected, and potentially malicious ways.",
		Lang:                "en",
	},
	"150": {
		CweID:               "150",
		Name:                "Improper Neutralization of Escape, Meta, or Control Sequences",
		Description:         "The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as escape, meta, or control character sequences when they are sent to a downstream component.",
		ExtendedDescription: "As data is parsed, an injected/absent/malformed delimiter may cause the process to take unexpected actions.",
		Lang:                "en",
	},
	"151": {
		CweID:               "151",
		Name:                "Improper Neutralization of Comment Delimiters",
		Description:         "The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as comment delimiters when they are sent to a downstream component.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"152": {
		CweID:               "152",
		Name:                "Improper Neutralization of Macro Symbols",
		Description:         "The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as macro symbols when they are sent to a downstream component.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"153": {
		CweID:               "153",
		Name:                "Improper Neutralization of Substitution Characters",
		Description:         "The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as substitution characters when they are sent to a downstream component.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"154": {
		CweID:               "154",
		Name:                "Improper Neutralization of Variable Name Delimiters",
		Description:         "The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as variable name delimiters when they are sent to a downstream component.",
		ExtendedDescription: "As data is parsed, an injected delimiter may cause the process to take unexpected actions that result in an attack. Example: '$' for an environment variable.",
		Lang:                "en",
	},
	"155": {
		CweID:               "155",
		Name:                "Improper Neutralization of Wildcards or Matching Symbols",
		Description:         "The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as wildcards or matching symbols when they are sent to a downstream component.",
		ExtendedDescription: "As data is parsed, an injected element may cause the process to take unexpected actions.",
		Lang:                "en",
	},
	"156": {
		CweID:               "156",
		Name:                "Improper Neutralization of Whitespace",
		Description:         "The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could be interpreted as whitespace when they are sent to a downstream component.",
		ExtendedDescription: "This can include space, tab, etc.",
		Lang:                "en",
	},
	"157": {
		CweID:               "157",
		Name:                "Failure to Sanitize Paired Delimiters",
		Description:         "The software does not properly handle the characters that are used to mark the beginning and ending of a group of entities, such as parentheses, brackets, and braces.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"158": {
		CweID:               "158",
		Name:                "Improper Neutralization of Null Byte or NUL Character",
		Description:         "The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes NUL characters or null bytes when they are sent to a downstream component.",
		ExtendedDescription: "As data is parsed, an injected NUL character or null byte may cause the software to believe the input is terminated earlier than it actually is, or otherwise cause the input to be misinterpreted. This could then be used to inject potentially dangerous input that occurs after the null byte or otherwise bypass validation routines and other protection mechanisms.",
		Lang:                "en",
	},
	"159": {
		CweID:               "159",
		Name:                "Failure to Sanitize Special Element",
		Description:         "Weaknesses in this attack-focused category do not properly filter and interpret special elements in user-controlled input which could cause adverse effect on the software behavior and integrity.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"160": {
		CweID:               "160",
		Name:                "Improper Neutralization of Leading Special Elements",
		Description:         "The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes leading special elements that could be interpreted in unexpected ways when they are sent to a downstream component.",
		ExtendedDescription: "As data is parsed, improperly handled leading special elements may cause the process to take unexpected actions that result in an attack.",
		Lang:                "en",
	},
	"161": {
		CweID:               "161",
		Name:                "Improper Neutralization of Multiple Leading Special Elements",
		Description:         "The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes multiple leading special elements that could be interpreted in unexpected ways when they are sent to a downstream component.",
		ExtendedDescription: "As data is parsed, improperly handled multiple leading special elements may cause the process to take unexpected actions that result in an attack.",
		Lang:                "en",
	},
	"162": {
		CweID:               "162",
		Name:                "Improper Neutralization of Trailing Special Elements",
		Description:         "The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes trailing special elements that could be interpreted in unexpected ways when they are sent to a downstream component.",
		ExtendedDescription: "As data is parsed, improperly handled trailing special elements may cause the process to take unexpected actions that result in an attack.",
		Lang:                "en",
	},
	"163": {
		CweID:               "163",
		Name:                "Improper Neutralization of Multiple Trailing Special Elements",
		Description:         "The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes multiple trailing special elements that could be interpreted in unexpected ways when they are sent to a downstream component.",
		ExtendedDescription: "As data is parsed, improperly handled multiple trailing special elements may cause the process to take unexpected actions that result in an attack.",
		Lang:                "en",
	},
	"164": {
		CweID:               "164",
		Name:                "Improper Neutralization of Internal Special Elements",
		Description:         "The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes internal special elements that could be interpreted in unexpected ways when they are sent to a downstream component.",
		ExtendedDescription: "As data is parsed, improperly handled internal special elements may cause the process to take unexpected actions that result in an attack.",
		Lang:                "en",
	},
	"165": {
		CweID:               "165",
		Name:                "Improper Neutralization of Multiple Internal Special Elements",
		Description:         "The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes multiple internal special elements that could be interpreted in unexpected ways when they are sent to a downstream component.",
		ExtendedDescription: "As data is parsed, improperly handled multiple internal special elements may cause the process to take unexpected actions that result in an attack.",
		Lang:                "en",
	},
	"166": {
		CweID:               "166",
		Name:                "Improper Handling of Missing Special Element",
		Description:         "The software receives input from an upstream component, but it does not handle or incorrectly handles when an expected special element is missing.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"167": {
		CweID:               "167",
		Name:                "Improper Handling of Additional Special Element",
		Description:         "The software receives input from an upstream component, but it does not handle or incorrectly handles when an additional unexpected special element is missing.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"168": {
		CweID:               "168",
		Name:                "Improper Handling of Inconsistent Special Elements",
		Description:         "The software does not handle when an inconsistency exists between two or more special characters or reserved words.",
		ExtendedDescription: "An example of this problem would be if paired characters appear in the wrong order, or if the special characters are not properly nested.",
		Lang:                "en",
	},
	"170": {
		CweID:               "170",
		Name:                "Improper Null Termination",
		Description:         "The software does not terminate or incorrectly terminates a string or array with a null character or equivalent terminator.",
		ExtendedDescription: "Null termination errors frequently occur in two different ways. An off-by-one error could cause a null to be written out of bounds, leading to an overflow. Or, a program could use a strncpy() function call incorrectly, which prevents a null terminator from being added at all. Other scenarios are possible.",
		Lang:                "en",
	},
	"172": {
		CweID:               "172",
		Name:                "Encoding Error",
		Description:         "The software does not properly encode or decode the data, resulting in unexpected values.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"173": {
		CweID:               "173",
		Name:                "Improper Handling of Alternate Encoding",
		Description:         "The software does not properly handle when an input uses an alternate encoding that is valid for the control sphere to which the input is being sent.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"174": {
		CweID:               "174",
		Name:                "Double Decoding of the Same Data",
		Description:         "The software decodes the same input twice, which can limit the effectiveness of any protection mechanism that occurs in between the decoding operations.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"175": {
		CweID:               "175",
		Name:                "Improper Handling of Mixed Encoding",
		Description:         "The software does not properly handle when the same input uses several different (mixed) encodings.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"176": {
		CweID:               "176",
		Name:                "Improper Handling of Unicode Encoding",
		Description:         "The software does not properly handle when an input contains Unicode encoding.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"177": {
		CweID:               "177",
		Name:                "Improper Handling of URL Encoding (Hex Encoding)",
		Description:         "The software does not properly handle when all or part of an input has been URL encoded.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"178": {
		CweID:               "178",
		Name:                "Improper Handling of Case Sensitivity",
		Description:         "The software does not properly account for differences in case sensitivity when accessing or determining the properties of a resource, leading to inconsistent results.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"179": {
		CweID:               "179",
		Name:                "Incorrect Behavior Order: Early Validation",
		Description:         "The software validates input before applying protection mechanisms that modify the input, which could allow an attacker to bypass the validation via dangerous inputs that only arise after the modification.",
		ExtendedDescription: "Software needs to validate data at the proper time, after data has been canonicalized and cleansed. Early validation is susceptible to various manipulations that result in dangerous inputs that are produced by canonicalization and cleansing.",
		Lang:                "en",
	},
	"180": {
		CweID:               "180",
		Name:                "Incorrect Behavior Order: Validate Before Canonicalize",
		Description:         "The software validates input before it is canonicalized, which prevents the software from detecting data that becomes invalid after the canonicalization step.",
		ExtendedDescription: "This can be used by an attacker to bypass the validation and launch attacks that expose weaknesses that would otherwise be prevented, such as injection.",
		Lang:                "en",
	},
	"181": {
		CweID:               "181",
		Name:                "Incorrect Behavior Order: Validate Before Filter",
		Description:         "The software validates data before it has been filtered, which prevents the software from detecting data that becomes invalid after the filtering step.",
		ExtendedDescription: "This can be used by an attacker to bypass the validation and launch attacks that expose weaknesses that would otherwise be prevented, such as injection.",
		Lang:                "en",
	},
	"182": {
		CweID:               "182",
		Name:                "Collapse of Data into Unsafe Value",
		Description:         "The software filters data in a way that causes it to be reduced or 'collapsed' into an unsafe value that violates an expected security property.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"183": {
		CweID:               "183",
		Name:                "Permissive Whitelist",
		Description:         "An application uses a 'whitelist' of acceptable values, but the whitelist includes at least one unsafe value, leading to resultant weaknesses.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"184": {
		CweID:               "184",
		Name:                "Incomplete Blacklist",
		Description:         "An application uses a 'blacklist' of prohibited values, but the blacklist is incomplete.",
		ExtendedDescription: "If an incomplete blacklist is used as a security mechanism, then the software may allow unintended values to pass into the application logic.",
		Lang:                "en",
	},
	"185": {
		CweID:               "185",
		Name:                "Incorrect Regular Expression",
		Description:         "The software specifies a regular expression in a way that causes data to be improperly matched or compared.",
		ExtendedDescription: "When the regular expression is used in protection mechanisms such as filtering or validation, this may allow an attacker to bypass the intended restrictions on the incoming data.",
		Lang:                "en",
	},
	"186": {
		CweID:               "186",
		Name:                "Overly Restrictive Regular Expression",
		Description:         "A regular expression is overly restrictive, which prevents dangerous values from being detected.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"187": {
		CweID:               "187",
		Name:                "Partial Comparison",
		Description:         "The software performs a comparison that only examines a portion of a factor before determining whether there is a match, such as a substring, leading to resultant weaknesses.",
		ExtendedDescription: "For example, an attacker might succeed in authentication by providing a small password that matches the associated portion of the larger, correct password.",
		Lang:                "en",
	},
	"188": {
		CweID:               "188",
		Name:                "Reliance on Data/Memory Layout",
		Description:         "The software makes invalid assumptions about how protocol data or memory is organized at a lower level, resulting in unintended program behavior.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"190": {
		CweID:               "190",
		Name:                "Integer Overflow or Wraparound",
		Description:         "The software performs a calculation that can produce an integer overflow or wraparound, when the logic assumes that the resulting value will always be larger than the original value. This can introduce other weaknesses when the calculation is used for resource management or execution control.",
		ExtendedDescription: "An integer overflow or wraparound occurs when an integer value is incremented to a value that is too large to store in the associated representation. When this occurs, the value may wrap to become a very small or negative number. While this may be intended behavior in circumstances that rely on wrapping, it can have security consequences if the wrap is unexpected. This is especially the case if the integer overflow can be triggered using user-supplied inputs. This becomes security-critical when the result is used to control looping, make a security decision, or determine the offset or size in behaviors such as memory allocation, copying, concatenation, etc.",
		Lang:                "en",
	},
	"191": {
		CweID:               "191",
		Name:                "Integer Underflow (Wrap or Wraparound)",
		Description:         "The product subtracts one value from another, such that the result is less than the minimum allowable integer value, which produces a value that is not equal to the correct result.",
		ExtendedDescription: "This can happen in signed and unsigned cases.",
		Lang:                "en",
	},
	"192": {
		CweID:               "192",
		Name:                "Integer Coercion Error",
		Description:         "Integer coercion refers to a set of flaws pertaining to the type casting, extension, or truncation of primitive data types.",
		ExtendedDescription: "Several flaws fall under the category of integer coercion errors. For the most part, these errors in and of themselves result only in availability and data integrity issues. However, in some circumstances, they may result in other, more complicated security related flaws, such as buffer overflow conditions.",
		Lang:                "en",
	},
	"193": {
		CweID:               "193",
		Name:                "Off-by-one Error",
		Description:         "A product calculates or uses an incorrect maximum or minimum value that is 1 more, or 1 less, than the correct value.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"194": {
		CweID:               "194",
		Name:                "Unexpected Sign Extension",
		Description:         "The software performs an operation on a number that causes it to be sign extended when it is transformed into a larger data type. When the original number is negative, this can produce unexpected values that lead to resultant weaknesses.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"195": {
		CweID:               "195",
		Name:                "Signed to Unsigned Conversion Error",
		Description:         "The software uses a signed primitive and performs a cast to an unsigned primitive, which can produce an unexpected value if the value of the signed primitive can not be represented using an unsigned primitive.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"196": {
		CweID:               "196",
		Name:                "Unsigned to Signed Conversion Error",
		Description:         "The software uses an unsigned primitive and performs a cast to a signed primitive, which can produce an unexpected value if the value of the unsigned primitive can not be represented using a signed primitive.",
		ExtendedDescription: "Although less frequent an issue than signed-to-unsigned conversion, unsigned-to-signed conversion can be the perfect precursor to dangerous buffer underwrite conditions that allow attackers to move down the stack where they otherwise might not have access in a normal buffer overflow condition. Buffer underwrites occur frequently when large unsigned values are cast to signed values, and then used as indexes into a buffer or for pointer arithmetic.",
		Lang:                "en",
	},
	"197": {
		CweID:               "197",
		Name:                "Numeric Truncation Error",
		Description:         "Truncation errors occur when a primitive is cast to a primitive of a smaller size and data is lost in the conversion.",
		ExtendedDescription: "When a primitive is cast to a smaller primitive, the high order bits of the large value are lost in the conversion, potentially resulting in an unexpected value that is not equal to the original value. This value may be required as an index into a buffer, a loop iterator, or simply necessary state data. In any case, the value cannot be trusted and the system will be in an undefined state. While this method may be employed viably to isolate the low bits of a value, this usage is rare, and truncation usually implies that an implementation error has occurred.",
		Lang:                "en",
	},
	"198": {
		CweID:               "198",
		Name:                "Use of Incorrect Byte Ordering",
		Description:         "The software receives input from an upstream component, but it does not account for byte ordering (e.g. big-endian and little-endian) when processing the input, causing an incorrect number or value to be used.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"20": {
		CweID:               "20",
		Name:                "Improper Input Validation",
		Description:         "The product does not validate or incorrectly validates input that can affect the control flow or data flow of a program.",
		ExtendedDescription: "When software does not validate input properly, an attacker is able to craft the input in a form that is not expected by the rest of the application. This will lead to parts of the system receiving unintended input, which may result in altered control flow, arbitrary control of a resource, or arbitrary code execution.",
		Lang:                "en",
	},
	"200": {
		CweID:               "200",
		Name:                "Information Exposure",
		Description:         "An information exposure is the intentional or unintentional disclosure of information to an actor that is not explicitly authorized to have access to that information.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"201": {
		CweID:               "201",
		Name:                "Information Exposure Through Sent Data",
		Description:         "The accidental exposure of sensitive information through sent data refers to the transmission of data which are either sensitive in and of itself or useful in the further exploitation of the system through standard data channels.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"202": {
		CweID:               "202",
		Name:                "Exposure of Sensitive Data Through Data Queries",
		Description:         "When trying to keep information confidential, an attacker can often infer some of the information by using statistics.",
		ExtendedDescription: "In situations where data should not be tied to individual users, but a large number of users should be able to make queries that 'scrub' the identity of users, it may be possible to get information about a user -- e.g., by specifying search terms that are known to be unique to that user.",
		Lang:                "en",
	},
	"203": {
		CweID:               "203",
		Name:                "Information Exposure Through Discrepancy",
		Description:         "The product behaves differently or sends different responses in a way that exposes security-relevant information about the state of the product, such as whether a particular operation was successful or not.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"204": {
		CweID:               "204",
		Name:                "Response Discrepancy Information Exposure",
		Description:         "The software provides different responses to incoming requests in a way that allows an actor to determine system state information that is outside of that actor's control sphere.",
		ExtendedDescription: "This issue frequently occurs during authentication, where a difference in failed-login messages could allow an attacker to determine if the username is valid or not. These exposures can be inadvertent (bug) or intentional (design).",
		Lang:                "en",
	},
	"205": {
		CweID:               "205",
		Name:                "Information Exposure Through Behavioral Discrepancy",
		Description:         "The product's actions indicate important differences based on (1) the internal state of the product or (2) differences from other products in the same class.",
		ExtendedDescription: "For example, attacks such as OS fingerprinting rely heavily on both behavioral and response discrepancies.",
		Lang:                "en",
	},
	"206": {
		CweID:               "206",
		Name:                "Information Exposure of Internal State Through Behavioral Inconsistency",
		Description:         "Two separate operations in a product cause the product to behave differently in a way that is observable to an attacker and reveals security-relevant information about the internal state of the product, such as whether a particular operation was successful or not.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"207": {
		CweID:               "207",
		Name:                "Information Exposure Through an External Behavioral Inconsistency",
		Description:         "The product behaves differently than other products like it, in a way that is observable to an attacker and exposes security-relevant information about which product is being used.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"208": {
		CweID:               "208",
		Name:                "Information Exposure Through Timing Discrepancy",
		Description:         "Two separate operations in a product require different amounts of time to complete, in a way that is observable to an actor and reveals security-relevant information about the state of the product, such as whether a particular operation was successful or not.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"209": {
		CweID:               "209",
		Name:                "Information Exposure Through an Error Message",
		Description:         "The software generates an error message that includes sensitive information about its environment, users, or associated data.",
		ExtendedDescription: "The sensitive information may be valuable information on its own (such as a password), or it may be useful for launching other, more deadly attacks. If an attack fails, an attacker may use error information provided by the server to launch another more focused attack. For example, an attempt to exploit a path traversal weakness (CWE-22) might yield the full pathname of the installed application. In turn, this could be used to select the proper number of '..' sequences to navigate to the targeted file. An attack using SQL injection (CWE-89) might not initially succeed, but an error message could reveal the malformed query, which would expose query logic and possibly even passwords or other sensitive information used within the query.",
		Lang:                "en",
	},
	"210": {
		CweID:               "210",
		Name:                "Information Exposure Through Self-generated Error Message",
		Description:         "The software identifies an error condition and creates its own diagnostic or error messages that contain sensitive information.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"211": {
		CweID:               "211",
		Name:                "Information Exposure Through Externally-Generated Error Message",
		Description:         "The software performs an operation that triggers an external diagnostic or error message that is not directly generated by the software, such as an error generated by the programming language interpreter that the software uses. The error can contain sensitive system information.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"212": {
		CweID:               "212",
		Name:                "Improper Cross-boundary Removal of Sensitive Data",
		Description:         "The software uses a resource that contains sensitive data, but it does not properly remove that data before it stores, transfers, or shares the resource with actors in another control sphere.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"213": {
		CweID:               "213",
		Name:                "Intentional Information Exposure",
		Description:         "A product's design or configuration explicitly requires the publication of information that could be regarded as sensitive by an administrator.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"214": {
		CweID:               "214",
		Name:                "Information Exposure Through Process Environment",
		Description:         "A process is invoked with sensitive arguments, environment variables, or other elements that can be seen by other processes on the operating system.",
		ExtendedDescription: "Many operating systems allow a user to list information about processes that are owned by other users. This information could include command line arguments or environment variable settings. When this data contains sensitive information such as credentials, it might allow other users to launch an attack against the software or related resources.",
		Lang:                "en",
	},
	"215": {
		CweID:               "215",
		Name:                "Information Exposure Through Debug Information",
		Description:         "The application contains debugging code that can expose sensitive information to untrusted parties.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"216": {
		CweID:               "216",
		Name:                "Containment Errors (Container Errors)",
		Description:         "This tries to cover various problems in which improper data are included within a 'container.'",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"217": {
		CweID:               "217",
		Name:                "DEPRECATED: Failure to Protect Stored Data from Modification",
		Description:         "This weakness has been deprecated because it incorporated and confused multiple weaknesses. The issues formerly covered in this weakness can be found at CWE-766 and CWE-767.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"218": {
		CweID:               "218",
		Name:                "DEPRECATED (Duplicate): Failure to provide confidentiality for stored data",
		Description:         "This weakness has been deprecated because it was a duplicate of CWE-493. All content has been transferred to CWE-493.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"219": {
		CweID:               "219",
		Name:                "Sensitive Data Under Web Root",
		Description:         "The application stores sensitive data under the web document root with insufficient access control, which might make it accessible to untrusted parties.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"22": {
		CweID:               "22",
		Name:                "Improper Limitation of a Pathname to a Restricted Directory ('Path Traversal')",
		Description:         "The software uses external input to construct a pathname that is intended to identify a file or directory that is located underneath a restricted parent directory, but the software does not properly neutralize special elements within the pathname that can cause the pathname to resolve to a location that is outside of the restricted directory.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"220": {
		CweID:               "220",
		Name:                "Sensitive Data Under FTP Root",
		Description:         "The application stores sensitive data under the FTP document root with insufficient access control, which might make it accessible to untrusted parties.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"221": {
		CweID:               "221",
		Name:                "Information Loss or Omission",
		Description:         "The software does not record, or improperly records, security-relevant information that leads to an incorrect decision or hampers later analysis.",
		ExtendedDescription: "This can be resultant, e.g. a buffer overflow might trigger a crash before the product can log the event.",
		Lang:                "en",
	},
	"222": {
		CweID:               "222",
		Name:                "Truncation of Security-relevant Information",
		Description:         "The application truncates the display, recording, or processing of security-relevant information in a way that can obscure the source or nature of an attack.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"223": {
		CweID:               "223",
		Name:                "Omission of Security-relevant Information",
		Description:         "The application does not record or display information that would be important for identifying the source or nature of an attack, or determining if an action is safe.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"224": {
		CweID:               "224",
		Name:                "Obscured Security-relevant Information by Alternate Name",
		Description:         "The software records security-relevant information according to an alternate name of the affected entity, instead of the canonical name.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"225": {
		CweID:               "225",
		Name:                "DEPRECATED (Duplicate): General Information Management Problems",
		Description:         "This weakness can be found at CWE-199.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"226": {
		CweID:               "226",
		Name:                "Sensitive Information Uncleared Before Release",
		Description:         "The software does not fully clear previously used information in a data structure, file, or other resource, before making that resource available to a party in another control sphere.",
		ExtendedDescription: "This typically results from new data that is not as long as the old data, which leaves portions of the old data still available. Equivalent errors can occur in other situations where the length of data is variable but the associated data structure is not. If memory is not cleared after use, it may allow unintended actors to read the data when the memory is reallocated.",
		Lang:                "en",
	},
	"228": {
		CweID:               "228",
		Name:                "Improper Handling of Syntactically Invalid Structure",
		Description:         "The product does not handle or incorrectly handles input that is not syntactically well-formed with respect to the associated specification.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"229": {
		CweID:               "229",
		Name:                "Improper Handling of Values",
		Description:         "The software does not properly handle when the expected number of values for parameters, fields, or arguments is not provided in input, or if those values are undefined.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"23": {
		CweID:               "23",
		Name:                "Relative Path Traversal",
		Description:         "The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize sequences such as '..' that can resolve to a location that is outside of that directory.",
		ExtendedDescription: "This allows attackers to traverse the file system to access files or directories that are outside of the restricted directory.",
		Lang:                "en",
	},
	"230": {
		CweID:               "230",
		Name:                "Improper Handling of Missing Values",
		Description:         "The software does not handle or incorrectly handles when a parameter, field, or argument name is specified, but the associated value is missing, i.e. it is empty, blank, or null.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"231": {
		CweID:               "231",
		Name:                "Improper Handling of Extra Values",
		Description:         "The software does not handle or incorrectly handles when more values are provided than expected.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"232": {
		CweID:               "232",
		Name:                "Improper Handling of Undefined Values",
		Description:         "The software does not handle or incorrectly handles when a value is not defined or supported for the associated parameter, field, or argument name.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"233": {
		CweID:               "233",
		Name:                "Improper Handling of Parameters",
		Description:         "The software does not properly handle when the expected number of parameters, fields, or arguments is not provided in input, or if those parameters are undefined.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"234": {
		CweID:               "234",
		Name:                "Failure to Handle Missing Parameter",
		Description:         "If too few arguments are sent to a function, the function will still pop the expected number of arguments from the stack. Potentially, a variable number of arguments could be exhausted in a function as well.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"235": {
		CweID:               "235",
		Name:                "Improper Handling of Extra Parameters",
		Description:         "The software does not handle or incorrectly handles when the number of parameters, fields, or arguments with the same name exceeds the expected amount.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"236": {
		CweID:               "236",
		Name:                "Improper Handling of Undefined Parameters",
		Description:         "The software does not handle or incorrectly handles when a particular parameter, field, or argument name is not defined or supported by the product.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"237": {
		CweID:               "237",
		Name:                "Improper Handling of Structural Elements",
		Description:         "The software does not handle or incorrectly handles inputs that are related to complex structures.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"238": {
		CweID:               "238",
		Name:                "Improper Handling of Incomplete Structural Elements",
		Description:         "The software does not handle or incorrectly handles when a particular structural element is not completely specified.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"239": {
		CweID:               "239",
		Name:                "Failure to Handle Incomplete Element",
		Description:         "The software does not properly handle when a particular element is not completely specified.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"24": {
		CweID:               "24",
		Name:                "Path Traversal: '../filedir'",
		Description:         "The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize '../' sequences that can resolve to a location that is outside of that directory.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"240": {
		CweID:               "240",
		Name:                "Improper Handling of Inconsistent Structural Elements",
		Description:         "The software does not handle or incorrectly handles when two or more structural elements should be consistent, but are not.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"241": {
		CweID:               "241",
		Name:                "Improper Handling of Unexpected Data Type",
		Description:         "The software does not handle or incorrectly handles when a particular element is not the expected type, e.g. it expects a digit (0-9) but is provided with a letter (A-Z).",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"242": {
		CweID:               "242",
		Name:                "Use of Inherently Dangerous Function",
		Description:         "The program calls a function that can never be guaranteed to work safely.",
		ExtendedDescription: "Certain functions behave in dangerous ways regardless of how they are used. Functions in this category were often implemented without taking security concerns into account. The gets() function is unsafe because it does not perform bounds checking on the size of its input. An attacker can easily send arbitrarily-sized input to gets() and overflow the destination buffer. Similarly, the >> operator is unsafe to use when reading into a statically-allocated character array because it does not perform bounds checking on the size of its input. An attacker can easily send arbitrarily-sized input to the >> operator and overflow the destination buffer.",
		Lang:                "en",
	},
	"243": {
		CweID:               "243",
		Name:                "Creation of chroot Jail Without Changing Working Directory",
		Description:         "The program uses the chroot() system call to create a jail, but does not change the working directory afterward. This does not prevent access to files outside of the jail.",
		ExtendedDescription: "Improper use of chroot() may allow attackers to escape from the chroot jail. The chroot() function call does not change the process's current working directory, so relative paths may still refer to file system resources outside of the chroot jail after chroot() has been called.",
		Lang:                "en",
	},
	"244": {
		CweID:               "244",
		Name:                "Improper Clearing of Heap Memory Before Release ('Heap Inspection')",
		Description:         "Using realloc() to resize buffers that store sensitive information can leave the sensitive information exposed to attack, because it is not removed from memory.",
		ExtendedDescription: "When sensitive data such as a password or an encryption key is not removed from memory, it could be exposed to an attacker using a 'heap inspection' attack that reads the sensitive data using memory dumps or other methods. The realloc() function is commonly used to increase the size of a block of allocated memory. This operation often requires copying the contents of the old memory block into a new and larger block. This operation leaves the contents of the original block intact but inaccessible to the program, preventing the program from being able to scrub sensitive data from memory. If an attacker can later examine the contents of a memory dump, the sensitive data could be exposed.",
		Lang:                "en",
	},
	"245": {
		CweID:               "245",
		Name:                "J2EE Bad Practices: Direct Management of Connections",
		Description:         "The J2EE application directly manages connections, instead of using the container's connection management facilities.",
		ExtendedDescription: "The J2EE standard forbids the direct management of connections. It requires that applications use the container's resource management facilities to obtain connections to resources. Every major web application container provides pooled database connection management as part of its resource management framework. Duplicating this functionality in an application is difficult and error prone, which is part of the reason it is forbidden under the J2EE standard.",
		Lang:                "en",
	},
	"246": {
		CweID:               "246",
		Name:                "J2EE Bad Practices: Direct Use of Sockets",
		Description:         "The J2EE application directly uses sockets instead of using framework method calls.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"247": {
		CweID:               "247",
		Name:                "DEPRECATED (Duplicate): Reliance on DNS Lookups in a Security Decision",
		Description:         "This entry has been deprecated because it was a duplicate of CWE-350. All content has been transferred to CWE-350.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"248": {
		CweID:               "248",
		Name:                "Uncaught Exception",
		Description:         "An exception is thrown from a function, but it is not caught.",
		ExtendedDescription: "When an exception is not caught, it may cause the program to crash or expose sensitive information.",
		Lang:                "en",
	},
	"249": {
		CweID:               "249",
		Name:                "DEPRECATED: Often Misused: Path Manipulation",
		Description:         "This entry has been deprecated because of name confusion and an accidental combination of multiple weaknesses. Most of its content has been transferred to CWE-785.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"25": {
		CweID:               "25",
		Name:                "Path Traversal: '/../filedir'",
		Description:         "The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize '/../' sequences that can resolve to a location that is outside of that directory.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"250": {
		CweID:               "250",
		Name:                "Execution with Unnecessary Privileges",
		Description:         "The software performs an operation at a privilege level that is higher than the minimum level required, which creates new weaknesses or amplifies the consequences of other weaknesses.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"252": {
		CweID:               "252",
		Name:                "Unchecked Return Value",
		Description:         "The software does not check the return value from a method or function, which can prevent it from detecting unexpected states and conditions.",
		ExtendedDescription: "Two common programmer assumptions are 'this function call can never fail' and 'it doesn't matter if this function call fails'. If an attacker can force the function to fail or otherwise return a value that is not expected, then the subsequent program logic could lead to a vulnerability, because the software is not in a state that the programmer assumes. For example, if the program calls a function to drop privileges but does not check the return code to ensure that privileges were successfully dropped, then the program will continue to operate with the higher privileges.",
		Lang:                "en",
	},
	"253": {
		CweID:               "253",
		Name:                "Incorrect Check of Function Return Value",
		Description:         "The software incorrectly checks a return value from a function, which prevents the software from detecting errors or exceptional conditions.",
		ExtendedDescription: "Important and common functions will return some value about the success of its actions. This will alert the program whether or not to handle any errors caused by that function.",
		Lang:                "en",
	},
	"256": {
		CweID:               "256",
		Name:                "Plaintext Storage of a Password",
		Description:         "Storing a password in plaintext may result in a system compromise.",
		ExtendedDescription: "Password management issues occur when a password is stored in plaintext in an application's properties or configuration file. Storing a plaintext password in a configuration file allows anyone who can read the file access to the password-protected resource.",
		Lang:                "en",
	},
	"257": {
		CweID:               "257",
		Name:                "Storing Passwords in a Recoverable Format",
		Description:         "The storage of passwords in a recoverable format makes them subject to password reuse attacks by malicious users. In fact, it should be noted that recoverable encrypted passwords provide no significant benefit over plaintext passwords since they are subject not only to reuse by malicious attackers but also by malicious insiders. If a system administrator can recover a password directly, or use a brute force search on the available information, the administrator can use the password on other accounts.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"258": {
		CweID:               "258",
		Name:                "Empty Password in Configuration File",
		Description:         "Using an empty string as a password is insecure.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"259": {
		CweID:               "259",
		Name:                "Use of Hard-coded Password",
		Description:         "The software contains a hard-coded password, which it uses for its own inbound authentication or for outbound communication to external components.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"26": {
		CweID:               "26",
		Name:                "Path Traversal: '/dir/../filename'",
		Description:         "The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize '/dir/../filename' sequences that can resolve to a location that is outside of that directory.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"260": {
		CweID:               "260",
		Name:                "Password in Configuration File",
		Description:         "The software stores a password in a configuration file that might be accessible to actors who do not know the password.",
		ExtendedDescription: "This can result in compromise of the system for which the password is used. An attacker could gain access to this file and learn the stored password or worse yet, change the password to one of their choosing.",
		Lang:                "en",
	},
	"261": {
		CweID:               "261",
		Name:                "Weak Cryptography for Passwords",
		Description:         "Obscuring a password with a trivial encoding does not protect the password.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"262": {
		CweID:               "262",
		Name:                "Not Using Password Aging",
		Description:         "If no mechanism is in place for managing password aging, users will have no incentive to update passwords in a timely manner.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"263": {
		CweID:               "263",
		Name:                "Password Aging with Long Expiration",
		Description:         "Allowing password aging to occur unchecked can result in the possibility of diminished password integrity.",
		ExtendedDescription: "Just as neglecting to include functionality for the management of password aging is dangerous, so is allowing password aging to continue unchecked. Passwords must be given a maximum life span, after which a user is required to update with a new and different password.",
		Lang:                "en",
	},
	"266": {
		CweID:               "266",
		Name:                "Incorrect Privilege Assignment",
		Description:         "A product incorrectly assigns a privilege to a particular actor, creating an unintended sphere of control for that actor.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"267": {
		CweID:               "267",
		Name:                "Privilege Defined With Unsafe Actions",
		Description:         "A particular privilege, role, capability, or right can be used to perform unsafe actions that were not intended, even when it is assigned to the correct entity.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"268": {
		CweID:               "268",
		Name:                "Privilege Chaining",
		Description:         "Two distinct privileges, roles, capabilities, or rights can be combined in a way that allows an entity to perform unsafe actions that would not be allowed without that combination.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"269": {
		CweID:               "269",
		Name:                "Improper Privilege Management",
		Description:         "The software does not properly assign, modify, track, or check privileges for an actor, creating an unintended sphere of control for that actor.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"27": {
		CweID:               "27",
		Name:                "Path Traversal: 'dir/../../filename'",
		Description:         "The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize multiple internal '../' sequences that can resolve to a location that is outside of that directory.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"270": {
		CweID:               "270",
		Name:                "Privilege Context Switching Error",
		Description:         "The software does not properly manage privileges while it is switching between different contexts that have different privileges or spheres of control.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"271": {
		CweID:               "271",
		Name:                "Privilege Dropping / Lowering Errors",
		Description:         "The software does not drop privileges before passing control of a resource to an actor that does not have those privileges.",
		ExtendedDescription: "In some contexts, a system executing with elevated permissions will hand off a process/file/etc. to another process or user. If the privileges of an entity are not reduced, then elevated privileges are spread throughout a system and possibly to an attacker.",
		Lang:                "en",
	},
	"272": {
		CweID:               "272",
		Name:                "Least Privilege Violation",
		Description:         "The elevated privilege level required to perform operations such as chroot() should be dropped immediately after the operation is performed.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"273": {
		CweID:               "273",
		Name:                "Improper Check for Dropped Privileges",
		Description:         "The software attempts to drop privileges but does not check or incorrectly checks to see if the drop succeeded.",
		ExtendedDescription: "If the drop fails, the software will continue to run with the raised privileges, which might provide additional access to unprivileged users.",
		Lang:                "en",
	},
	"274": {
		CweID:               "274",
		Name:                "Improper Handling of Insufficient Privileges",
		Description:         "The software does not handle or incorrectly handles when it has insufficient privileges to perform an operation, leading to resultant weaknesses.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"276": {
		CweID:               "276",
		Name:                "Incorrect Default Permissions",
		Description:         "The software, upon installation, sets incorrect permissions for an object that exposes it to an unintended actor.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"277": {
		CweID:               "277",
		Name:                "Insecure Inherited Permissions",
		Description:         "A product defines a set of insecure permissions that are inherited by objects that are created by the program.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"278": {
		CweID:               "278",
		Name:                "Insecure Preserved Inherited Permissions",
		Description:         "A product inherits a set of insecure permissions for an object, e.g. when copying from an archive file, without user awareness or involvement.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"279": {
		CweID:               "279",
		Name:                "Incorrect Execution-Assigned Permissions",
		Description:         "While it is executing, the software sets the permissions of an object in a way that violates the intended permissions that have been specified by the user.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"28": {
		CweID:               "28",
		Name:                "Path Traversal: '..\\filedir'",
		Description:         "The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize '..\\' sequences that can resolve to a location that is outside of that directory.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"280": {
		CweID:               "280",
		Name:                "Improper Handling of Insufficient Permissions or Privileges",
		Description:         "The application does not handle or incorrectly handles when it has insufficient privileges to access resources or functionality as specified by their permissions. This may cause it to follow unexpected code paths that may leave the application in an invalid state.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"281": {
		CweID:               "281",
		Name:                "Improper Preservation of Permissions",
		Description:         "The software does not preserve permissions or incorrectly preserves permissions when copying, restoring, or sharing objects, which can cause them to have less restrictive permissions than intended.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"282": {
		CweID:               "282",
		Name:                "Improper Ownership Management",
		Description:         "The software assigns the wrong ownership, or does not properly verify the ownership, of an object or resource.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"283": {
		CweID:               "283",
		Name:                "Unverified Ownership",
		Description:         "The software does not properly verify that a critical resource is owned by the proper entity.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"284": {
		CweID:               "284",
		Name:                "Improper Access Control",
		Description:         "The software does not restrict or incorrectly restricts access to a resource from an unauthorized actor.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"285": {
		CweID:               "285",
		Name:                "Improper Authorization",
		Description:         "The software does not perform or incorrectly performs an authorization check when an actor attempts to access a resource or perform an action.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"286": {
		CweID:               "286",
		Name:                "Incorrect User Management",
		Description:         "The software does not properly manage a user within its environment.",
		ExtendedDescription: "Users can be assigned to the wrong group (class) of permissions resulting in unintended access rights to sensitive objects.",
		Lang:                "en",
	},
	"287": {
		CweID:               "287",
		Name:                "Improper Authentication",
		Description:         "When an actor claims to have a given identity, the software does not prove or insufficiently proves that the claim is correct.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"288": {
		CweID:               "288",
		Name:                "Authentication Bypass Using an Alternate Path or Channel",
		Description:         "A product requires authentication, but the product has an alternate path or channel that does not require authentication.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"289": {
		CweID:               "289",
		Name:                "Authentication Bypass by Alternate Name",
		Description:         "The software performs authentication based on the name of a resource being accessed, or the name of the actor performing the access, but it does not properly check all possible names for that resource or actor.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"29": {
		CweID:               "29",
		Name:                "Path Traversal: '\\..\\filename'",
		Description:         "The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize '\\..\\filename' (leading backslash dot dot) sequences that can resolve to a location that is outside of that directory.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"290": {
		CweID:               "290",
		Name:                "Authentication Bypass by Spoofing",
		Description:         "This attack-focused weakness is caused by improperly implemented authentication schemes that are subject to spoofing attacks.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"291": {
		CweID:               "291",
		Name:                "Reliance on IP Address for Authentication",
		Description:         "The software uses an IP address for authentication.",
		ExtendedDescription: "IP addresses can be easily spoofed. Attackers can forge the source IP address of the packets they send, but response packets will return to the forged IP address. To see the response packets, the attacker has to sniff the traffic between the victim machine and the forged IP address. In order to accomplish the required sniffing, attackers typically attempt to locate themselves on the same subnet as the victim machine. Attackers may be able to circumvent this requirement by using source routing, but source routing is disabled across much of the Internet today. In summary, IP address verification can be a useful part of an authentication scheme, but it should not be the single factor required for authentication.",
		Lang:                "en",
	},
	"292": {
		CweID:               "292",
		Name:                "DEPRECATED (Duplicate): Trusting Self-reported DNS Name",
		Description:         "This entry has been deprecated because it was a duplicate of CWE-350. All content has been transferred to CWE-350.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"293": {
		CweID:               "293",
		Name:                "Using Referer Field for Authentication",
		Description:         "The referer field in HTTP requests can be easily modified and, as such, is not a valid means of message integrity checking.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"294": {
		CweID:               "294",
		Name:                "Authentication Bypass by Capture-replay",
		Description:         "A capture-replay flaw exists when the design of the software makes it possible for a malicious user to sniff network traffic and bypass authentication by replaying it to the server in question to the same effect as the original message (or with minor changes).",
		ExtendedDescription: "Capture-replay attacks are common and can be difficult to defeat without cryptography. They are a subset of network injection attacks that rely on observing previously-sent valid commands, then changing them slightly if necessary and resending the same commands to the server.",
		Lang:                "en",
	},
	"295": {
		CweID:               "295",
		Name:                "Improper Certificate Validation",
		Description:         "The software does not validate, or incorrectly validates, a certificate.",
		ExtendedDescription: "When a certificate is invalid or malicious, it might allow an attacker to spoof a trusted entity by using a man-in-the-middle (MITM) attack. The software might connect to a malicious host while believing it is a trusted host, or the software might be deceived into accepting spoofed data that appears to originate from a trusted host.",
		Lang:                "en",
	},
	"296": {
		CweID:               "296",
		Name:                "Improper Following of a Certificate's Chain of Trust",
		Description:         "The software does not follow, or incorrectly follows, the chain of trust for a certificate back to a trusted root certificate, resulting in incorrect trust of any resource that is associated with that certificate.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"297": {
		CweID:               "297",
		Name:                "Improper Validation of Certificate with Host Mismatch",
		Description:         "The software communicates with a host that provides a certificate, but the software does not properly ensure that the certificate is actually associated with that host.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"298": {
		CweID:               "298",
		Name:                "Improper Validation of Certificate Expiration",
		Description:         "A certificate expiration is not validated or is incorrectly validated, so trust may be assigned to certificates that have been abandoned due to age.",
		ExtendedDescription: "When the expiration of a certificate is not taken into account, no trust has necessarily been conveyed through it. Therefore, the validity of the certificate cannot be verified and all benefit of the certificate is lost.",
		Lang:                "en",
	},
	"299": {
		CweID:               "299",
		Name:                "Improper Check for Certificate Revocation",
		Description:         "The software does not check or incorrectly checks the revocation status of a certificate, which may cause it to use a certificate that has been compromised.",
		ExtendedDescription: "An improper check for certificate revocation is a far more serious flaw than related certificate failures. This is because the use of any revoked certificate is almost certainly malicious. The most common reason for certificate revocation is compromise of the system in question, with the result that no legitimate servers will be using a revoked certificate, unless they are sorely out of sync.",
		Lang:                "en",
	},
	"30": {
		CweID:               "30",
		Name:                "Path Traversal: '\\dir\\..\\filename'",
		Description:         "The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize '\\dir\\..\\filename' (leading backslash dot dot) sequences that can resolve to a location that is outside of that directory.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"300": {
		CweID:               "300",
		Name:                "Channel Accessible by Non-Endpoint ('Man-in-the-Middle')",
		Description:         "The product does not adequately verify the identity of actors at both ends of a communication channel, or does not adequately ensure the integrity of the channel, in a way that allows the channel to be accessed or influenced by an actor that is not an endpoint.",
		ExtendedDescription: "In order to establish secure communication between two parties, it is often important to adequately verify the identity of entities at each end of the communication channel. Inadequate or inconsistent verification may result in insufficient or incorrect identification of either communicating entity. This can have negative consequences such as misplaced trust in the entity at the other end of the channel. An attacker can leverage this by interposing between the communicating entities and masquerading as the original entity. In the absence of sufficient verification of identity, such an attacker can eavesdrop and potentially modify the communication between the original entities.",
		Lang:                "en",
	},
	"301": {
		CweID:               "301",
		Name:                "Reflection Attack in an Authentication Protocol",
		Description:         "Simple authentication protocols are subject to reflection attacks if a malicious user can use the target machine to impersonate a trusted user.",
		ExtendedDescription: "A mutual authentication protocol requires each party to respond to a random challenge by the other party by encrypting it with a pre-shared key. Often, however, such protocols employ the same pre-shared key for communication with a number of different entities. A malicious user or an attacker can easily compromise this protocol without possessing the correct key by employing a reflection attack on the protocol.",
		Lang:                "en",
	},
	"302": {
		CweID:               "302",
		Name:                "Authentication Bypass by Assumed-Immutable Data",
		Description:         "The authentication scheme or implementation uses key data elements that are assumed to be immutable, but can be controlled or modified by the attacker.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"303": {
		CweID:               "303",
		Name:                "Incorrect Implementation of Authentication Algorithm",
		Description:         "The requirements for the software dictate the use of an established authentication algorithm, but the implementation of the algorithm is incorrect.",
		ExtendedDescription: "This incorrect implementation may allow authentication to be bypassed.",
		Lang:                "en",
	},
	"304": {
		CweID:               "304",
		Name:                "Missing Critical Step in Authentication",
		Description:         "The software implements an authentication technique, but it skips a step that weakens the technique.",
		ExtendedDescription: "Authentication techniques should follow the algorithms that define them exactly, otherwise authentication can be bypassed or more easily subjected to brute force attacks.",
		Lang:                "en",
	},
	"305": {
		CweID:               "305",
		Name:                "Authentication Bypass by Primary Weakness",
		Description:         "The authentication algorithm is sound, but the implemented mechanism can be bypassed as the result of a separate weakness that is primary to the authentication error.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"306": {
		CweID:               "306",
		Name:                "Missing Authentication for Critical Function",
		Description:         "The software does not perform any authentication for functionality that requires a provable user identity or consumes a significant amount of resources.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"307": {
		CweID:               "307",
		Name:                "Improper Restriction of Excessive Authentication Attempts",
		Description:         "The software does not implement sufficient measures to prevent multiple failed authentication attempts within in a short time frame, making it more susceptible to brute force attacks.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"308": {
		CweID:               "308",
		Name:                "Use of Single-factor Authentication",
		Description:         "The use of single-factor authentication can lead to unnecessary risk of compromise when compared with the benefits of a dual-factor authentication scheme.",
		ExtendedDescription: "While the use of multiple authentication schemes is simply piling on more complexity on top of authentication, it is inestimably valuable to have such measures of redundancy. The use of weak, reused, and common passwords is rampant on the internet. Without the added protection of multiple authentication schemes, a single mistake can result in the compromise of an account. For this reason, if multiple schemes are possible and also easy to use, they should be implemented and required.",
		Lang:                "en",
	},
	"309": {
		CweID:               "309",
		Name:                "Use of Password System for Primary Authentication",
		Description:         "The use of password systems as the primary means of authentication may be subject to several flaws or shortcomings, each reducing the effectiveness of the mechanism.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"31": {
		CweID:               "31",
		Name:                "Path Traversal: 'dir\\..\\..\\filename'",
		Description:         "The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize 'dir\\..\\..\\filename' (multiple internal backslash dot dot) sequences that can resolve to a location that is outside of that directory.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"311": {
		CweID:               "311",
		Name:                "Missing Encryption of Sensitive Data",
		Description:         "The software does not encrypt sensitive or critical information before storage or transmission.",
		ExtendedDescription: "The lack of proper data encryption passes up the guarantees of confidentiality, integrity, and accountability that properly implemented encryption conveys.",
		Lang:                "en",
	},
	"312": {
		CweID:               "312",
		Name:                "Cleartext Storage of Sensitive Information",
		Description:         "The application stores sensitive information in cleartext within a resource that might be accessible to another control sphere.",
		ExtendedDescription: "Because the information is stored in cleartext, attackers could potentially read it. Even if the information is encoded in a way that is not human-readable, certain techniques could determine which encoding is being used, then decode the information.",
		Lang:                "en",
	},
	"313": {
		CweID:               "313",
		Name:                "Cleartext Storage in a File or on Disk",
		Description:         "The application stores sensitive information in cleartext in a file, or on disk.",
		ExtendedDescription: "The sensitive information could be read by attackers with access to the file, or with physical or administrator access to the raw disk. Even if the information is encoded in a way that is not human-readable, certain techniques could determine which encoding is being used, then decode the information.",
		Lang:                "en",
	},
	"314": {
		CweID:               "314",
		Name:                "Cleartext Storage in the Registry",
		Description:         "The application stores sensitive information in cleartext in the registry.",
		ExtendedDescription: "Attackers can read the information by accessing the registry key. Even if the information is encoded in a way that is not human-readable, certain techniques could determine which encoding is being used, then decode the information.",
		Lang:                "en",
	},
	"315": {
		CweID:               "315",
		Name:                "Cleartext Storage of Sensitive Information in a Cookie",
		Description:         "The application stores sensitive information in cleartext in a cookie.",
		ExtendedDescription: "Attackers can use widely-available tools to view the cookie and read the sensitive information. Even if the information is encoded in a way that is not human-readable, certain techniques could determine which encoding is being used, then decode the information.",
		Lang:                "en",
	},
	"316": {
		CweID:               "316",
		Name:                "Cleartext Storage of Sensitive Information in Memory",
		Description:         "The application stores sensitive information in cleartext in memory.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"317": {
		CweID:               "317",
		Name:                "Cleartext Storage of Sensitive Information in GUI",
		Description:         "The application stores sensitive information in cleartext within the GUI.",
		ExtendedDescription: "An attacker can often obtain data from a GUI, even if hidden, by using an API to directly access GUI objects such as windows and menus. Even if the information is encoded in a way that is not human-readable, certain techniques could determine which encoding is being used, then decode the information.",
		Lang:                "en",
	},
	"318": {
		CweID:               "318",
		Name:                "Cleartext Storage of Sensitive Information in Executable",
		Description:         "The application stores sensitive information in cleartext in an executable.",
		ExtendedDescription: "Attackers can reverse engineer binary code to obtain secret data. This is especially easy when the cleartext is plain ASCII. Even if the information is encoded in a way that is not human-readable, certain techniques could determine which encoding is being used, then decode the information.",
		Lang:                "en",
	},
	"319": {
		CweID:               "319",
		Name:                "Cleartext Transmission of Sensitive Information",
		Description:         "The software transmits sensitive or security-critical data in cleartext in a communication channel that can be sniffed by unauthorized actors.",
		ExtendedDescription: "Many communication channels can be 'sniffed' by attackers during data transmission. For example, network traffic can often be sniffed by any attacker who has access to a network interface. This significantly lowers the difficulty of exploitation by attackers.",
		Lang:                "en",
	},
	"32": {
		CweID:               "32",
		Name:                "Path Traversal: '...' (Triple Dot)",
		Description:         "The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize '...' (triple dot) sequences that can resolve to a location that is outside of that directory.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"321": {
		CweID:               "321",
		Name:                "Use of Hard-coded Cryptographic Key",
		Description:         "The use of a hard-coded cryptographic key significantly increases the possibility that encrypted data may be recovered.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"322": {
		CweID:               "322",
		Name:                "Key Exchange without Entity Authentication",
		Description:         "The software performs a key exchange with an actor without verifying the identity of that actor.",
		ExtendedDescription: "Performing a key exchange will preserve the integrity of the information sent between two entities, but this will not guarantee that the entities are who they claim they are. This may enable a set of 'man-in-the-middle' attacks. Typically, this involves a victim client that contacts a malicious server that is impersonating a trusted server. If the client skips authentication or ignores an authentication failure, the malicious server may request authentication information from the user. The malicious server can then use this authentication information to log in to the trusted server using the victim's credentials, sniff traffic between the victim and trusted server, etc.",
		Lang:                "en",
	},
	"323": {
		CweID:               "323",
		Name:                "Reusing a Nonce, Key Pair in Encryption",
		Description:         "Nonces should be used for the present occasion and only once.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"324": {
		CweID:               "324",
		Name:                "Use of a Key Past its Expiration Date",
		Description:         "The product uses a cryptographic key or password past its expiration date, which diminishes its safety significantly by increasing the timing window for cracking attacks against that key.",
		ExtendedDescription: "While the expiration of keys does not necessarily ensure that they are compromised, it is a significant concern that keys which remain in use for prolonged periods of time have a decreasing probability of integrity. For this reason, it is important to replace keys within a period of time proportional to their strength.",
		Lang:                "en",
	},
	"325": {
		CweID:               "325",
		Name:                "Missing Required Cryptographic Step",
		Description:         "The software does not implement a required step in a cryptographic algorithm, resulting in weaker encryption than advertised by that algorithm.",
		ExtendedDescription: "Cryptographic implementations should follow the algorithms that define them exactly, otherwise encryption can be weaker than expected.",
		Lang:                "en",
	},
	"326": {
		CweID:               "326",
		Name:                "Inadequate Encryption Strength",
		Description:         "The software stores or transmits sensitive data using an encryption scheme that is theoretically sound, but is not strong enough for the level of protection required.",
		ExtendedDescription: "A weak encryption scheme can be subjected to brute force attacks that have a reasonable chance of succeeding using current attack methods and resources.",
		Lang:                "en",
	},
	"327": {
		CweID:               "327",
		Name:                "Use of a Broken or Risky Cryptographic Algorithm",
		Description:         "The use of a broken or risky cryptographic algorithm is an unnecessary risk that may result in the exposure of sensitive information.",
		ExtendedDescription: "The use of a non-standard algorithm is dangerous because a determined attacker may be able to break the algorithm and compromise whatever data has been protected. Well-known techniques may exist to break the algorithm.",
		Lang:                "en",
	},
	"328": {
		CweID:               "328",
		Name:                "Reversible One-Way Hash",
		Description:         "The product uses a hashing algorithm that produces a hash value that can be used to determine the original input, or to find an input that can produce the same hash, more efficiently than brute force techniques.",
		ExtendedDescription: "This weakness is especially dangerous when the hash is used in security algorithms that require the one-way property to hold. For example, if an authentication system takes an incoming password and generates a hash, then compares the hash to another hash that it has stored in its authentication database, then the ability to create a collision could allow an attacker to provide an alternate password that produces the same target hash, bypassing authentication.",
		Lang:                "en",
	},
	"329": {
		CweID:               "329",
		Name:                "Not Using a Random IV with CBC Mode",
		Description:         "Not using a random initialization Vector (IV) with Cipher Block Chaining (CBC) Mode causes algorithms to be susceptible to dictionary attacks.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"33": {
		CweID:               "33",
		Name:                "Path Traversal: '....' (Multiple Dot)",
		Description:         "The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize '....' (multiple dot) sequences that can resolve to a location that is outside of that directory.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"330": {
		CweID:               "330",
		Name:                "Use of Insufficiently Random Values",
		Description:         "The software may use insufficiently random numbers or values in a security context that depends on unpredictable numbers.",
		ExtendedDescription: "When software generates predictable values in a context requiring unpredictability, it may be possible for an attacker to guess the next value that will be generated, and use this guess to impersonate another user or access sensitive information.",
		Lang:                "en",
	},
	"331": {
		CweID:               "331",
		Name:                "Insufficient Entropy",
		Description:         "The software uses an algorithm or scheme that produces insufficient entropy, leaving patterns or clusters of values that are more likely to occur than others.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"332": {
		CweID:               "332",
		Name:                "Insufficient Entropy in PRNG",
		Description:         "The lack of entropy available for, or used by, a Pseudo-Random Number Generator (PRNG) can be a stability and security threat.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"333": {
		CweID:               "333",
		Name:                "Improper Handling of Insufficient Entropy in TRNG",
		Description:         "True random number generators (TRNG) generally have a limited source of entropy and therefore can fail or block.",
		ExtendedDescription: "The rate at which true random numbers can be generated is limited. It is important that one uses them only when they are needed for security.",
		Lang:                "en",
	},
	"334": {
		CweID:               "334",
		Name:                "Small Space of Random Values",
		Description:         "The number of possible random values is smaller than needed by the product, making it more susceptible to brute force attacks.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"335": {
		CweID:               "335",
		Name:                "Incorrect Usage of Seeds in Pseudo-Random Number Generator (PRNG)",
		Description:         "The software uses a Pseudo-Random Number Generator (PRNG) that does not correctly manage seeds.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"336": {
		CweID:               "336",
		Name:                "Same Seed in Pseudo-Random Number Generator (PRNG)",
		Description:         "A Pseudo-Random Number Generator (PRNG) uses the same seed each time the product is initialized.",
		ExtendedDescription: "If an attacker can guess (or knows) the seed, then the attacker may be able to determine the random numbers that will be produced from the PRNG.",
		Lang:                "en",
	},
	"337": {
		CweID:               "337",
		Name:                "Predictable Seed in Pseudo-Random Number Generator (PRNG)",
		Description:         "A Pseudo-Random Number Generator (PRNG) is initialized from a predictable seed, such as the process ID or system time.",
		ExtendedDescription: "The use of predictable seeds significantly reduces the number of possible seeds that an attacker would need to test in order to predict which random numnbers will be generated by the PRNG.",
		Lang:                "en",
	},
	"338": {
		CweID:               "338",
		Name:                "Use of Cryptographically Weak Pseudo-Random Number Generator (PRNG)",
		Description:         "The product uses a Pseudo-Random Number Generator (PRNG) in a security context, but the PRNG's algorithm is not cryptographically strong.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"339": {
		CweID:               "339",
		Name:                "Small Seed Space in PRNG",
		Description:         "A PRNG uses a relatively small space of seeds.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"34": {
		CweID:               "34",
		Name:                "Path Traversal: '....//'",
		Description:         "The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize '....//' (doubled dot dot slash) sequences that can resolve to a location that is outside of that directory.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"340": {
		CweID:               "340",
		Name:                "Predictability Problems",
		Description:         "Weaknesses in this category are related to schemes that generate numbers or identifiers that are more predictable than required by the application.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"341": {
		CweID:               "341",
		Name:                "Predictable from Observable State",
		Description:         "A number or object is predictable based on observations that the attacker can make about the state of the system or network, such as time, process ID, etc.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"342": {
		CweID:               "342",
		Name:                "Predictable Exact Value from Previous Values",
		Description:         "An exact value or random number can be precisely predicted by observing previous values.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"343": {
		CweID:               "343",
		Name:                "Predictable Value Range from Previous Values",
		Description:         "The software's random number generator produces a series of values which, when observed, can be used to infer a relatively small range of possibilities for the next value that could be generated.",
		ExtendedDescription: "The output of a random number generator should not be predictable based on observations of previous values. In some cases, an attacker cannot predict the exact value that will be produced next, but can narrow down the possibilities significantly. This reduces the amount of effort to perform a brute force attack. For example, suppose the product generates random numbers between 1 and 100, but it always produces a larger value until it reaches 100. If the generator produces an 80, then the attacker knows that the next value will be somewhere between 81 and 100. Instead of 100 possibilities, the attacker only needs to consider 20.",
		Lang:                "en",
	},
	"344": {
		CweID:               "344",
		Name:                "Use of Invariant Value in Dynamically Changing Context",
		Description:         "The product uses a constant value, name, or reference, but this value can (or should) vary across different environments.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"345": {
		CweID:               "345",
		Name:                "Insufficient Verification of Data Authenticity",
		Description:         "The software does not sufficiently verify the origin or authenticity of data, in a way that causes it to accept invalid data.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"346": {
		CweID:               "346",
		Name:                "Origin Validation Error",
		Description:         "The software does not properly verify that the source of data or communication is valid.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"347": {
		CweID:               "347",
		Name:                "Improper Verification of Cryptographic Signature",
		Description:         "The software does not verify, or incorrectly verifies, the cryptographic signature for data.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"348": {
		CweID:               "348",
		Name:                "Use of Less Trusted Source",
		Description:         "The software has two different sources of the same data or information, but it uses the source that has less support for verification, is less trusted, or is less resistant to attack.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"349": {
		CweID:               "349",
		Name:                "Acceptance of Extraneous Untrusted Data With Trusted Data",
		Description:         "The software, when processing trusted data, accepts any untrusted data that is also included with the trusted data, treating the untrusted data as if it were trusted.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"35": {
		CweID:               "35",
		Name:                "Path Traversal: '.../...//'",
		Description:         "The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize '.../...//' (doubled triple dot slash) sequences that can resolve to a location that is outside of that directory.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"350": {
		CweID:               "350",
		Name:                "Reliance on Reverse DNS Resolution for a Security-Critical Action",
		Description:         "The software performs reverse DNS resolution on an IP address to obtain the hostname and make a security decision, but it does not properly ensure that the IP address is truly associated with the hostname.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"351": {
		CweID:               "351",
		Name:                "Insufficient Type Distinction",
		Description:         "The software does not properly distinguish between different types of elements in a way that leads to insecure behavior.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"352": {
		CweID:               "352",
		Name:                "Cross-Site Request Forgery (CSRF)",
		Description:         "The web application does not, or can not, sufficiently verify whether a well-formed, valid, consistent request was intentionally provided by the user who submitted the request.",
		ExtendedDescription: "When a web server is designed to receive a request from a client without any mechanism for verifying that it was intentionally sent, then it might be possible for an attacker to trick a client into making an unintentional request to the web server which will be treated as an authentic request. This can be done via a URL, image load, XMLHttpRequest, etc. and can result in exposure of data or unintended code execution.",
		Lang:                "en",
	},
	"353": {
		CweID:               "353",
		Name:                "Missing Support for Integrity Check",
		Description:         "The software uses a transmission protocol that does not include a mechanism for verifying the integrity of the data during transmission, such as a checksum.",
		ExtendedDescription: "If integrity check values or 'checksums' are omitted from a protocol, there is no way of determining if data has been corrupted in transmission. The lack of checksum functionality in a protocol removes the first application-level check of data that can be used. The end-to-end philosophy of checks states that integrity checks should be performed at the lowest level that they can be completely implemented. Excluding further sanity checks and input validation performed by applications, the protocol's checksum is the most important level of checksum, since it can be performed more completely than at any previous level and takes into account entire messages, as opposed to single packets.",
		Lang:                "en",
	},
	"354": {
		CweID:               "354",
		Name:                "Improper Validation of Integrity Check Value",
		Description:         "The software does not validate or incorrectly validates the integrity check values or 'checksums' of a message. This may prevent it from detecting if the data has been modified or corrupted in transmission.",
		ExtendedDescription: "Improper validation of checksums before use results in an unnecessary risk that can easily be mitigated. The protocol specification describes the algorithm used for calculating the checksum. It is then a simple matter of implementing the calculation and verifying that the calculated checksum and the received checksum match. Improper verification of the calculated checksum and the received checksum can lead to far greater consequences.",
		Lang:                "en",
	},
	"356": {
		CweID:               "356",
		Name:                "Product UI does not Warn User of Unsafe Actions",
		Description:         "The software's user interface does not warn the user before undertaking an unsafe action on behalf of that user. This makes it easier for attackers to trick users into inflicting damage to their system.",
		ExtendedDescription: "Software systems should warn users that a potentially dangerous action may occur if the user proceeds. For example, if the user downloads a file from an unknown source and attempts to execute the file on their machine, then the application's GUI can indicate that the file is unsafe.",
		Lang:                "en",
	},
	"357": {
		CweID:               "357",
		Name:                "Insufficient UI Warning of Dangerous Operations",
		Description:         "The user interface provides a warning to a user regarding dangerous or sensitive operations, but the warning is not noticeable enough to warrant attention.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"358": {
		CweID:               "358",
		Name:                "Improperly Implemented Security Check for Standard",
		Description:         "The software does not implement or incorrectly implements one or more security-relevant checks as specified by the design of a standardized algorithm, protocol, or technique.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"359": {
		CweID:               "359",
		Name:                "Exposure of Private Information ('Privacy Violation')",
		Description:         "The software does not properly prevent private data (such as credit card numbers) from being accessed by actors who either (1) are not explicitly authorized to access the data or (2) do not have the implicit consent of the people to which the data is related.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"36": {
		CweID:               "36",
		Name:                "Absolute Path Traversal",
		Description:         "The software uses external input to construct a pathname that should be within a restricted directory, but it does not properly neutralize absolute path sequences such as '/abs/path' that can resolve to a location that is outside of that directory.",
		ExtendedDescription: "This allows attackers to traverse the file system to access files or directories that are outside of the restricted directory.",
		Lang:                "en",
	},
	"360": {
		CweID:               "360",
		Name:                "Trust of System Event Data",
		Description:         "Security based on event locations are insecure and can be spoofed.",
		ExtendedDescription: "Events are a messaging system which may provide control data to programs listening for events. Events often do not have any type of authentication framework to allow them to be verified from a trusted source. Any application, in Windows, on a given desktop can send a message to any window on the same desktop. There is no authentication framework for these messages. Therefore, any message can be used to manipulate any process on the desktop if the process does not check the validity and safeness of those messages.",
		Lang:                "en",
	},
	"362": {
		CweID:               "362",
		Name:                "Concurrent Execution using Shared Resource with Improper Synchronization ('Race Condition')",
		Description:         "The program contains a code sequence that can run concurrently with other code, and the code sequence requires temporary, exclusive access to a shared resource, but a timing window exists in which the shared resource can be modified by another code sequence that is operating concurrently.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"363": {
		CweID:               "363",
		Name:                "Race Condition Enabling Link Following",
		Description:         "The software checks the status of a file or directory before accessing it, which produces a race condition in which the file can be replaced with a link before the access is performed, causing the software to access the wrong file.",
		ExtendedDescription: "While developers might expect that there is a very narrow time window between the time of check and time of use, there is still a race condition. An attacker could cause the software to slow down (e.g. with memory consumption), causing the time window to become larger. Alternately, in some situations, the attacker could win the race by performing a large number of attacks.",
		Lang:                "en",
	},
	"364": {
		CweID:               "364",
		Name:                "Signal Handler Race Condition",
		Description:         "The software uses a signal handler that introduces a race condition.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"365": {
		CweID:               "365",
		Name:                "Race Condition in Switch",
		Description:         "The code contains a switch statement in which the switched variable can be modified while the switch is still executing, resulting in unexpected behavior.",
		ExtendedDescription: "This issue is particularly important in the case of switch statements that involve fall-through style case statements - ie., those which do not end with break. If the variable being tested by the switch changes in the course of execution, this could change the intended logic of the switch so much that it places the process in a contradictory state and in some cases could even result in memory corruption.",
		Lang:                "en",
	},
	"366": {
		CweID:               "366",
		Name:                "Race Condition within a Thread",
		Description:         "If two threads of execution use a resource simultaneously, there exists the possibility that resources may be used while invalid, in turn making the state of execution undefined.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"367": {
		CweID:               "367",
		Name:                "Time-of-check Time-of-use (TOCTOU) Race Condition",
		Description:         "The software checks the state of a resource before using that resource, but the resource's state can change between the check and the use in a way that invalidates the results of the check. This can cause the software to perform invalid actions when the resource is in an unexpected state.",
		ExtendedDescription: "This weakness can be security-relevant when an attacker can influence the state of the resource between check and use. This can happen with shared resources such as files, memory, or even variables in multithreaded programs.",
		Lang:                "en",
	},
	"368": {
		CweID:               "368",
		Name:                "Context Switching Race Condition",
		Description:         "A product performs a series of non-atomic actions to switch between contexts that cross privilege or other security boundaries, but a race condition allows an attacker to modify or misrepresent the product's behavior during the switch.",
		ExtendedDescription: "This is commonly seen in web browser vulnerabilities in which the attacker can perform certain actions while the browser is transitioning from a trusted to an untrusted domain, or vice versa, and the browser performs the actions on one domain using the trust level and resources of the other domain.",
		Lang:                "en",
	},
	"369": {
		CweID:               "369",
		Name:                "Divide By Zero",
		Description:         "The product divides a value by zero.",
		ExtendedDescription: "This weakness typically occurs when an unexpected value is provided to the product, or if an error occurs that is not properly detected. It frequently occurs in calculations involving physical dimensions such as size, length, width, and height.",
		Lang:                "en",
	},
	"37": {
		CweID:               "37",
		Name:                "Path Traversal: '/absolute/pathname/here'",
		Description:         "A software system that accepts input in the form of a slash absolute path ('/absolute/pathname/here') without appropriate validation can allow an attacker to traverse the file system to unintended locations or access arbitrary files.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"370": {
		CweID:               "370",
		Name:                "Missing Check for Certificate Revocation after Initial Check",
		Description:         "The software does not check the revocation status of a certificate after its initial revocation check, which can cause the software to perform privileged actions even after the certificate is revoked at a later time.",
		ExtendedDescription: "If the revocation status of a certificate is not checked before each action that requires privileges, the system may be subject to a race condition. If a certificate is revoked after the initial check, all subsequent actions taken with the owner of the revoked certificate will lose all benefits guaranteed by the certificate. In fact, it is almost certain that the use of a revoked certificate indicates malicious activity.",
		Lang:                "en",
	},
	"372": {
		CweID:               "372",
		Name:                "Incomplete Internal State Distinction",
		Description:         "The software does not properly determine which state it is in, causing it to assume it is in state X when in fact it is in state Y, causing it to perform incorrect operations in a security-relevant manner.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"373": {
		CweID:               "373",
		Name:                "DEPRECATED: State Synchronization Error",
		Description:         "This entry was deprecated because it overlapped the same concepts as race condition (CWE-362) and Improper Synchronization (CWE-662).",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"374": {
		CweID:               "374",
		Name:                "Passing Mutable Objects to an Untrusted Method",
		Description:         "The program sends non-cloned mutable data as an argument to a method or function.",
		ExtendedDescription: "The function or method that has been called can alter or delete the mutable data. This could violate assumptions that the calling function has made about its state. In situations where unknown code is called with references to mutable data, this external code could make changes to the data sent. If this data was not previously cloned, the modified data might not be valid in the context of execution.",
		Lang:                "en",
	},
	"375": {
		CweID:               "375",
		Name:                "Returning a Mutable Object to an Untrusted Caller",
		Description:         "Sending non-cloned mutable data as a return value may result in that data being altered or deleted by the calling function.",
		ExtendedDescription: "In situations where functions return references to mutable data, it is possible that the external code which called the function may make changes to the data sent. If this data was not previously cloned, the class will then be using modified data which may violate assumptions about its internal state.",
		Lang:                "en",
	},
	"377": {
		CweID:               "377",
		Name:                "Insecure Temporary File",
		Description:         "Creating and using insecure temporary files can leave application and system data vulnerable to attack.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"378": {
		CweID:               "378",
		Name:                "Creation of Temporary File With Insecure Permissions",
		Description:         "Opening temporary files without appropriate measures or controls can leave the file, its contents and any function that it impacts vulnerable to attack.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"379": {
		CweID:               "379",
		Name:                "Creation of Temporary File in Directory with Incorrect Permissions",
		Description:         "The software creates a temporary file in a directory whose permissions allow unintended actors to determine the file's existence or otherwise access that file.",
		ExtendedDescription: "On some operating systems, the fact that the temporary file exists may be apparent to any user with sufficient privileges to access that directory. Since the file is visible, the application that is using the temporary file could be known. If one has access to list the processes on the system, the attacker has gained information about what the user is doing at that time. By correlating this with the applications the user is running, an attacker could potentially discover what a user's actions are. From this, higher levels of security could be breached.",
		Lang:                "en",
	},
	"38": {
		CweID:               "38",
		Name:                "Path Traversal: '\\absolute\\pathname\\here'",
		Description:         "A software system that accepts input in the form of a backslash absolute path ('\\absolute\\pathname\\here') without appropriate validation can allow an attacker to traverse the file system to unintended locations or access arbitrary files.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"382": {
		CweID:               "382",
		Name:                "J2EE Bad Practices: Use of System.exit()",
		Description:         "A J2EE application uses System.exit(), which also shuts down its container.",
		ExtendedDescription: "It is never a good idea for a web application to attempt to shut down the application container. Access to a function that can shut down the application is an avenue for Denial of Service (DoS) attacks.",
		Lang:                "en",
	},
	"383": {
		CweID:               "383",
		Name:                "J2EE Bad Practices: Direct Use of Threads",
		Description:         "Thread management in a Web application is forbidden in some circumstances and is always highly error prone.",
		ExtendedDescription: "Thread management in a web application is forbidden by the J2EE standard in some circumstances and is always highly error prone. Managing threads is difficult and is likely to interfere in unpredictable ways with the behavior of the application container. Even without interfering with the container, thread management usually leads to bugs that are hard to detect and diagnose like deadlock, race conditions, and other synchronization errors.",
		Lang:                "en",
	},
	"384": {
		CweID:               "384",
		Name:                "Session Fixation",
		Description:         "Authenticating a user, or otherwise establishing a new user session, without invalidating any existing session identifier gives an attacker the opportunity to steal authenticated sessions.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"385": {
		CweID:               "385",
		Name:                "Covert Timing Channel",
		Description:         "Covert timing channels convey information by modulating some aspect of system behavior over time, so that the program receiving the information can observe system behavior and infer protected information.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"386": {
		CweID:               "386",
		Name:                "Symbolic Name not Mapping to Correct Object",
		Description:         "A constant symbolic reference to an object is used, even though the reference can resolve to a different object over time.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"39": {
		CweID:               "39",
		Name:                "Path Traversal: 'C:dirname'",
		Description:         "An attacker can inject a drive letter or Windows volume letter ('C:dirname') into a software system to potentially redirect access to an unintended location or arbitrary file.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"390": {
		CweID:               "390",
		Name:                "Detection of Error Condition Without Action",
		Description:         "The software detects a specific error, but takes no actions to handle the error.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"391": {
		CweID:               "391",
		Name:                "Unchecked Error Condition",
		Description:         "Ignoring exceptions and other error conditions may allow an attacker to induce unexpected behavior unnoticed.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"392": {
		CweID:               "392",
		Name:                "Missing Report of Error Condition",
		Description:         "The software encounters an error but does not provide a status code or return value to indicate that an error has occurred.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"393": {
		CweID:               "393",
		Name:                "Return of Wrong Status Code",
		Description:         "A function or operation returns an incorrect return value or status code that does not indicate an error, but causes the product to modify its behavior based on the incorrect result.",
		ExtendedDescription: "This can lead to unpredictable behavior. If the function is used to make security-critical decisions or provide security-critical information, then the wrong status code can cause the software to assume that an action is safe, even when it is not.",
		Lang:                "en",
	},
	"394": {
		CweID:               "394",
		Name:                "Unexpected Status Code or Return Value",
		Description:         "The software does not properly check when a function or operation returns a value that is legitimate for the function, but is not expected by the software.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"395": {
		CweID:               "395",
		Name:                "Use of NullPointerException Catch to Detect NULL Pointer Dereference",
		Description:         "Catching NullPointerException should not be used as an alternative to programmatic checks to prevent dereferencing a null pointer.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"396": {
		CweID:               "396",
		Name:                "Declaration of Catch for Generic Exception",
		Description:         "Catching overly broad exceptions promotes complex error handling code that is more likely to contain security vulnerabilities.",
		ExtendedDescription: "Multiple catch blocks can get ugly and repetitive, but 'condensing' catch blocks by catching a high-level class like Exception can obscure exceptions that deserve special treatment or that should not be caught at this point in the program. Catching an overly broad exception essentially defeats the purpose of Java's typed exceptions, and can become particularly dangerous if the program grows and begins to throw new types of exceptions. The new exception types will not receive any attention.",
		Lang:                "en",
	},
	"397": {
		CweID:               "397",
		Name:                "Declaration of Throws for Generic Exception",
		Description:         "Throwing overly broad exceptions promotes complex error handling code that is more likely to contain security vulnerabilities.",
		ExtendedDescription: "Declaring a method to throw Exception or Throwable makes it difficult for callers to perform proper error handling and error recovery. Java's exception mechanism, for example, is set up to make it easy for callers to anticipate what can go wrong and write code to handle each specific exceptional circumstance. Declaring that a method throws a generic form of exception defeats this system.",
		Lang:                "en",
	},
	"40": {
		CweID:               "40",
		Name:                "Path Traversal: '\\\\UNC\\share\\name\\' (Windows UNC Share)",
		Description:         "An attacker can inject a Windows UNC share ('\\\\UNC\\share\\name') into a software system to potentially redirect access to an unintended location or arbitrary file.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"400": {
		CweID:               "400",
		Name:                "Uncontrolled Resource Consumption ('Resource Exhaustion')",
		Description:         "The software does not properly restrict the size or amount of resources that are requested or influenced by an actor, which can be used to consume more resources than intended.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"401": {
		CweID:               "401",
		Name:                "Improper Release of Memory Before Removing Last Reference ('Memory Leak')",
		Description:         "The software does not sufficiently track and release allocated memory after it has been used, which slowly consumes remaining memory.",
		ExtendedDescription: "This is often triggered by improper handling of malformed data or unexpectedly interrupted sessions.",
		Lang:                "en",
	},
	"402": {
		CweID:               "402",
		Name:                "Transmission of Private Resources into a New Sphere ('Resource Leak')",
		Description:         "The software makes resources available to untrusted parties when those resources are only intended to be accessed by the software.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"403": {
		CweID:               "403",
		Name:                "Exposure of File Descriptor to Unintended Control Sphere ('File Descriptor Leak')",
		Description:         "A process does not close sensitive file descriptors before invoking a child process, which allows the child to perform unauthorized I/O operations using those descriptors.",
		ExtendedDescription: "When a new process is forked or executed, the child process inherits any open file descriptors. When the child process has fewer privileges than the parent process, this might introduce a vulnerability if the child process can access the file descriptor but does not have the privileges to access the associated file.",
		Lang:                "en",
	},
	"404": {
		CweID:               "404",
		Name:                "Improper Resource Shutdown or Release",
		Description:         "The program does not release or incorrectly releases a resource before it is made available for re-use.",
		ExtendedDescription: "When a resource is created or allocated, the developer is responsible for properly releasing the resource as well as accounting for all potential paths of expiration or invalidation, such as a set period of time or revocation.",
		Lang:                "en",
	},
	"405": {
		CweID:               "405",
		Name:                "Asymmetric Resource Consumption (Amplification)",
		Description:         "Software that does not appropriately monitor or control resource consumption can lead to adverse system performance.",
		ExtendedDescription: "This situation is amplified if the software allows malicious users or attackers to consume more resources than their access level permits. Exploiting such a weakness can lead to asymmetric resource consumption, aiding in amplification attacks against the system or the network.",
		Lang:                "en",
	},
	"406": {
		CweID:               "406",
		Name:                "Insufficient Control of Network Message Volume (Network Amplification)",
		Description:         "The software does not sufficiently monitor or control transmitted network traffic volume, so that an actor can cause the software to transmit more traffic than should be allowed for that actor.",
		ExtendedDescription: "In the absence of a policy to restrict asymmetric resource consumption, the application or system cannot distinguish between legitimate transmissions and traffic intended to serve as an amplifying attack on target systems. Systems can often be configured to restrict the amount of traffic sent out on behalf of a client, based on the client's origin or access level. This is usually defined in a resource allocation policy. In the absence of a mechanism to keep track of transmissions, the system or application can be easily abused to transmit asymmetrically greater traffic than the request or client should be permitted to.",
		Lang:                "en",
	},
	"407": {
		CweID:               "407",
		Name:                "Algorithmic Complexity",
		Description:         "An algorithm in a product has an inefficient worst-case computational complexity that may be detrimental to system performance and can be triggered by an attacker, typically using crafted manipulations that ensure that the worst case is being reached.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"408": {
		CweID:               "408",
		Name:                "Incorrect Behavior Order: Early Amplification",
		Description:         "The software allows an entity to perform a legitimate but expensive operation before authentication or authorization has taken place.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"409": {
		CweID:               "409",
		Name:                "Improper Handling of Highly Compressed Data (Data Amplification)",
		Description:         "The software does not handle or incorrectly handles a compressed input with a very high compression ratio that produces a large output.",
		ExtendedDescription: "An example of data amplification is a 'decompression bomb,' a small ZIP file that can produce a large amount of data when it is decompressed.",
		Lang:                "en",
	},
	"41": {
		CweID:               "41",
		Name:                "Improper Resolution of Path Equivalence",
		Description:         "The system or application is vulnerable to file system contents disclosure through path equivalence. Path equivalence involves the use of special characters in file and directory names. The associated manipulations are intended to generate multiple names for the same object.",
		ExtendedDescription: "Path equivalence is usually employed in order to circumvent access controls expressed using an incomplete set of file name or file path representations. This is different from path traversal, wherein the manipulations are performed to generate a name for a different object.",
		Lang:                "en",
	},
	"410": {
		CweID:               "410",
		Name:                "Insufficient Resource Pool",
		Description:         "The software's resource pool is not large enough to handle peak demand, which allows an attacker to prevent others from accessing the resource by using a (relatively) large number of requests for resources.",
		ExtendedDescription: "Frequently the consequence is a 'flood' of connection or sessions.",
		Lang:                "en",
	},
	"412": {
		CweID:               "412",
		Name:                "Unrestricted Externally Accessible Lock",
		Description:         "The software properly checks for the existence of a lock, but the lock can be externally controlled or influenced by an actor that is outside of the intended sphere of control.",
		ExtendedDescription: "This prevents the software from acting on associated resources or performing other behaviors that are controlled by the presence of the lock. Relevant locks might include an exclusive lock or mutex, or modifying a shared resource that is treated as a lock. If the lock can be held for an indefinite period of time, then the denial of service could be permanent.",
		Lang:                "en",
	},
	"413": {
		CweID:               "413",
		Name:                "Improper Resource Locking",
		Description:         "The software does not lock or does not correctly lock a resource when the software must have exclusive access to the resource.",
		ExtendedDescription: "When a resource is not properly locked, an attacker could modify the resource while it is being operated on by the software. This might violate the software's assumption that the resource will not change, potentially leading to unexpected behaviors.",
		Lang:                "en",
	},
	"414": {
		CweID:               "414",
		Name:                "Missing Lock Check",
		Description:         "A product does not check to see if a lock is present before performing sensitive operations on a resource.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"415": {
		CweID:               "415",
		Name:                "Double Free",
		Description:         "The product calls free() twice on the same memory address, potentially leading to modification of unexpected memory locations.",
		ExtendedDescription: "When a program calls free() twice with the same argument, the program's memory management data structures become corrupted. This corruption can cause the program to crash or, in some circumstances, cause two later calls to malloc() to return the same pointer. If malloc() returns the same value twice and the program later gives the attacker control over the data that is written into this doubly-allocated memory, the program becomes vulnerable to a buffer overflow attack.",
		Lang:                "en",
	},
	"416": {
		CweID:               "416",
		Name:                "Use After Free",
		Description:         "Referencing memory after it has been freed can cause a program to crash, use unexpected values, or execute code.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"419": {
		CweID:               "419",
		Name:                "Unprotected Primary Channel",
		Description:         "The software uses a primary channel for administration or restricted functionality, but it does not properly protect the channel.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"42": {
		CweID:               "42",
		Name:                "Path Equivalence: 'filename.' (Trailing Dot)",
		Description:         "A software system that accepts path input in the form of trailing dot ('filedir.') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"420": {
		CweID:               "420",
		Name:                "Unprotected Alternate Channel",
		Description:         "The software protects a primary channel, but it does not use the same level of protection for an alternate channel.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"421": {
		CweID:               "421",
		Name:                "Race Condition During Access to Alternate Channel",
		Description:         "The product opens an alternate channel to communicate with an authorized user, but the channel is accessible to other actors.",
		ExtendedDescription: "This creates a race condition that allows an attacker to access the channel before the authorized user does.",
		Lang:                "en",
	},
	"422": {
		CweID:               "422",
		Name:                "Unprotected Windows Messaging Channel ('Shatter')",
		Description:         "The software does not properly verify the source of a message in the Windows Messaging System while running at elevated privileges, creating an alternate channel through which an attacker can directly send a message to the product.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"423": {
		CweID:               "423",
		Name:                "DEPRECATED (Duplicate): Proxied Trusted Channel",
		Description:         "This entry has been deprecated because it was a duplicate of CWE-441. All content has been transferred to CWE-441.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"424": {
		CweID:               "424",
		Name:                "Improper Protection of Alternate Path",
		Description:         "The product does not sufficiently protect all possible paths that a user can take to access restricted functionality or resources.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"425": {
		CweID:               "425",
		Name:                "Direct Request ('Forced Browsing')",
		Description:         "The web application does not adequately enforce appropriate authorization on all restricted URLs, scripts, or files.",
		ExtendedDescription: "Web applications susceptible to direct request attacks often make the false assumption that such resources can only be reached through a given navigation path and so only apply authorization at certain points in the path.",
		Lang:                "en",
	},
	"426": {
		CweID:               "426",
		Name:                "Untrusted Search Path",
		Description:         "The application searches for critical resources using an externally-supplied search path that can point to resources that are not under the application's direct control.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"427": {
		CweID:               "427",
		Name:                "Uncontrolled Search Path Element",
		Description:         "The product uses a fixed or controlled search path to find resources, but one or more locations in that path can be under the control of unintended actors.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"428": {
		CweID:               "428",
		Name:                "Unquoted Search Path or Element",
		Description:         "The product uses a search path that contains an unquoted element, in which the element contains whitespace or other separators. This can cause the product to access resources in a parent path.",
		ExtendedDescription: "If a malicious individual has access to the file system, it is possible to elevate privileges by inserting such a file as 'C:\\Program.exe' to be run by a privileged program making use of WinExec.",
		Lang:                "en",
	},
	"43": {
		CweID:               "43",
		Name:                "Path Equivalence: 'filename....' (Multiple Trailing Dot)",
		Description:         "A software system that accepts path input in the form of multiple trailing dot ('filedir....') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"430": {
		CweID:               "430",
		Name:                "Deployment of Wrong Handler",
		Description:         "The wrong 'handler' is assigned to process an object.",
		ExtendedDescription: "An example of deploying the wrong handler would be calling a servlet to reveal source code of a .JSP file, or automatically 'determining' type of the object even if it is contradictory to an explicitly specified type.",
		Lang:                "en",
	},
	"431": {
		CweID:               "431",
		Name:                "Missing Handler",
		Description:         "A handler is not available or implemented.",
		ExtendedDescription: "When an exception is thrown and not caught, the process has given up an opportunity to decide if a given failure or event is worth a change in execution.",
		Lang:                "en",
	},
	"432": {
		CweID:               "432",
		Name:                "Dangerous Signal Handler not Disabled During Sensitive Operations",
		Description:         "The application uses a signal handler that shares state with other signal handlers, but it does not properly mask or prevent those signal handlers from being invoked while the original signal handler is still running.",
		ExtendedDescription: "During the execution of a signal handler, it can be interrupted by another handler when a different signal is sent. If the two handlers share state - such as global variables - then an attacker can corrupt the state by sending another signal before the first handler has completed execution.",
		Lang:                "en",
	},
	"433": {
		CweID:               "433",
		Name:                "Unparsed Raw Web Content Delivery",
		Description:         "The software stores raw content or supporting code under the web document root with an extension that is not specifically handled by the server.",
		ExtendedDescription: "If code is stored in a file with an extension such as '.inc' or '.pl', and the web server does not have a handler for that extension, then the server will likely send the contents of the file directly to the requester without the pre-processing that was expected. When that file contains sensitive information such as database credentials, this may allow the attacker to compromise the application or associated components.",
		Lang:                "en",
	},
	"434": {
		CweID:               "434",
		Name:                "Unrestricted Upload of File with Dangerous Type",
		Description:         "The software allows the attacker to upload or transfer files of dangerous types that can be automatically processed within the product's environment.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"435": {
		CweID:               "435",
		Name:                "Improper Interaction Between Multiple Entities",
		Description:         "An interaction error occurs when two entities work correctly when running independently, but they interact in unexpected ways when they are run together.",
		ExtendedDescription: "This could apply to products, systems, components, etc.",
		Lang:                "en",
	},
	"436": {
		CweID:               "436",
		Name:                "Interpretation Conflict",
		Description:         "Product A handles inputs or steps differently than Product B, which causes A to perform incorrect actions based on its perception of B's state.",
		ExtendedDescription: "This is generally found in proxies, firewalls, anti-virus software, and other intermediary devices that monitor, allow, deny, or modify traffic based on how the client or server is expected to behave.",
		Lang:                "en",
	},
	"437": {
		CweID:               "437",
		Name:                "Incomplete Model of Endpoint Features",
		Description:         "A product acts as an intermediary or monitor between two or more endpoints, but it does not have a complete model of an endpoint's features, behaviors, or state, potentially causing the product to perform incorrect actions based on this incomplete model.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"439": {
		CweID:               "439",
		Name:                "Behavioral Change in New Version or Environment",
		Description:         "A's behavior or functionality changes with a new version of A, or a new environment, which is not known (or manageable) by B.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"44": {
		CweID:               "44",
		Name:                "Path Equivalence: 'file.name' (Internal Dot)",
		Description:         "A software system that accepts path input in the form of internal dot ('file.ordir') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"440": {
		CweID:               "440",
		Name:                "Expected Behavior Violation",
		Description:         "A feature, API, or function being used by a product behaves differently than the product expects.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"441": {
		CweID:               "441",
		Name:                "Unintended Proxy or Intermediary ('Confused Deputy')",
		Description:         "The software receives a request, message, or directive from an upstream component, but the software does not sufficiently preserve the original source of the request before forwarding the request to an external actor that is outside of the software's control sphere. This causes the software to appear to be the source of the request, leading it to act as a proxy or other intermediary between the upstream component and the external actor.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"443": {
		CweID:               "443",
		Name:                "DEPRECATED (Duplicate): HTTP response splitting",
		Description:         "This weakness can be found at CWE-113.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"444": {
		CweID:               "444",
		Name:                "Inconsistent Interpretation of HTTP Requests ('HTTP Request Smuggling')",
		Description:         "When malformed or abnormal HTTP requests are interpreted by one or more entities in the data flow between the user and the web server, such as a proxy or firewall, they can be interpreted inconsistently, allowing the attacker to 'smuggle' a request to one device without the other device being aware of it.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"446": {
		CweID:               "446",
		Name:                "UI Discrepancy for Security Feature",
		Description:         "The user interface does not correctly enable or configure a security feature, but the interface provides feedback that causes the user to believe that the feature is in a secure state.",
		ExtendedDescription: "When the user interface does not properly reflect what the user asks of it, then it can lead the user into a false sense of security. For example, the user might check a box to enable a security option to enable encrypted communications, but the software does not actually enable the encryption. Alternately, the user might provide a 'restrict ALL'' access control rule, but the software only implements 'restrict SOME'.",
		Lang:                "en",
	},
	"447": {
		CweID:               "447",
		Name:                "Unimplemented or Unsupported Feature in UI",
		Description:         "A UI function for a security feature appears to be supported and gives feedback to the user that suggests that it is supported, but the underlying functionality is not implemented.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"448": {
		CweID:               "448",
		Name:                "Obsolete Feature in UI",
		Description:         "A UI function is obsolete and the product does not warn the user.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"449": {
		CweID:               "449",
		Name:                "The UI Performs the Wrong Action",
		Description:         "The UI performs the wrong action with respect to the user's request.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"45": {
		CweID:               "45",
		Name:                "Path Equivalence: 'file...name' (Multiple Internal Dot)",
		Description:         "A software system that accepts path input in the form of multiple internal dot ('file...dir') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"450": {
		CweID:               "450",
		Name:                "Multiple Interpretations of UI Input",
		Description:         "The UI has multiple interpretations of user input but does not prompt the user when it selects the less secure interpretation.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"451": {
		CweID:               "451",
		Name:                "User Interface (UI) Misrepresentation of Critical Information",
		Description:         "The user interface (UI) does not properly represent critical information to the user, allowing the information - or its source - to be obscured or spoofed. This is often a component in phishing attacks.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"453": {
		CweID:               "453",
		Name:                "Insecure Default Variable Initialization",
		Description:         "The software, by default, initializes an internal variable with an insecure or less secure value than is possible.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"454": {
		CweID:               "454",
		Name:                "External Initialization of Trusted Variables or Data Stores",
		Description:         "The software initializes critical internal variables or data stores using inputs that can be modified by untrusted actors.",
		ExtendedDescription: "A software system should be reluctant to trust variables that have been initialized outside of its trust boundary, especially if they are initialized by users. The variables may have been initialized incorrectly. If an attacker can initialize the variable, then they can influence what the vulnerable system will do.",
		Lang:                "en",
	},
	"455": {
		CweID:               "455",
		Name:                "Non-exit on Failed Initialization",
		Description:         "The software does not exit or otherwise modify its operation when security-relevant errors occur during initialization, such as when a configuration file has a format error, which can cause the software to execute in a less secure fashion than intended by the administrator.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"456": {
		CweID:               "456",
		Name:                "Missing Initialization of a Variable",
		Description:         "The software does not initialize critical variables, which causes the execution environment to use unexpected values.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"457": {
		CweID:               "457",
		Name:                "Use of Uninitialized Variable",
		Description:         "The code uses a variable that has not been initialized, leading to unpredictable or unintended results.",
		ExtendedDescription: "In some languages such as C and C++, stack variables are not initialized by default. They generally contain junk data with the contents of stack memory before the function was invoked. An attacker can sometimes control or read these contents. In other languages or conditions, a variable that is not explicitly initialized can be given a default value that has security implications, depending on the logic of the program. The presence of an uninitialized variable can sometimes indicate a typographic error in the code.",
		Lang:                "en",
	},
	"458": {
		CweID:               "458",
		Name:                "DEPRECATED: Incorrect Initialization",
		Description:         "This weakness has been deprecated because its name and description did not match. The description duplicated CWE-454, while the name suggested a more abstract initialization problem. Please refer to CWE-665 for the more abstract problem.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"459": {
		CweID:               "459",
		Name:                "Incomplete Cleanup",
		Description:         "The software does not properly 'clean up' and remove temporary or supporting resources after they have been used.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"46": {
		CweID:               "46",
		Name:                "Path Equivalence: 'filename ' (Trailing Space)",
		Description:         "A software system that accepts path input in the form of trailing space ('filedir ') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"460": {
		CweID:               "460",
		Name:                "Improper Cleanup on Thrown Exception",
		Description:         "The product does not clean up its state or incorrectly cleans up its state when an exception is thrown, leading to unexpected state or control flow.",
		ExtendedDescription: "Often, when functions or loops become complicated, some level of resource cleanup is needed throughout execution. Exceptions can disturb the flow of the code and prevent the necessary cleanup from happening.",
		Lang:                "en",
	},
	"462": {
		CweID:               "462",
		Name:                "Duplicate Key in Associative List (Alist)",
		Description:         "Duplicate keys in associative lists can lead to non-unique keys being mistaken for an error.",
		ExtendedDescription: "A duplicate key entry -- if the alist is designed properly -- could be used as a constant time replace function. However, duplicate key entries could be inserted by mistake. Because of this ambiguity, duplicate key entries in an association list are not recommended and should not be allowed.",
		Lang:                "en",
	},
	"463": {
		CweID:               "463",
		Name:                "Deletion of Data Structure Sentinel",
		Description:         "The accidental deletion of a data-structure sentinel can cause serious programming logic problems.",
		ExtendedDescription: "Often times data-structure sentinels are used to mark structure of the data structure. A common example of this is the null character at the end of strings. Another common example is linked lists which may contain a sentinel to mark the end of the list. It is dangerous to allow this type of control data to be easily accessible. Therefore, it is important to protect from the deletion or modification outside of some wrapper interface which provides safety.",
		Lang:                "en",
	},
	"464": {
		CweID:               "464",
		Name:                "Addition of Data Structure Sentinel",
		Description:         "The accidental addition of a data-structure sentinel can cause serious programming logic problems.",
		ExtendedDescription: "Data-structure sentinels are often used to mark the structure of data. A common example of this is the null character at the end of strings or a special sentinel to mark the end of a linked list. It is dangerous to allow this type of control data to be easily accessible. Therefore, it is important to protect from the addition or modification of sentinels.",
		Lang:                "en",
	},
	"466": {
		CweID:               "466",
		Name:                "Return of Pointer Value Outside of Expected Range",
		Description:         "A function can return a pointer to memory that is outside of the buffer that the pointer is expected to reference.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"467": {
		CweID:               "467",
		Name:                "Use of sizeof() on a Pointer Type",
		Description:         "The code calls sizeof() on a malloced pointer type, which always returns the wordsize/8. This can produce an unexpected result if the programmer intended to determine how much memory has been allocated.",
		ExtendedDescription: "The use of sizeof() on a pointer can sometimes generate useful information. An obvious case is to find out the wordsize on a platform. More often than not, the appearance of sizeof(pointer) indicates a bug.",
		Lang:                "en",
	},
	"468": {
		CweID:               "468",
		Name:                "Incorrect Pointer Scaling",
		Description:         "In C and C++, one may often accidentally refer to the wrong memory due to the semantics of when math operations are implicitly scaled.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"469": {
		CweID:               "469",
		Name:                "Use of Pointer Subtraction to Determine Size",
		Description:         "The application subtracts one pointer from another in order to determine size, but this calculation can be incorrect if the pointers do not exist in the same memory chunk.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"47": {
		CweID:               "47",
		Name:                "Path Equivalence: ' filename' (Leading Space)",
		Description:         "A software system that accepts path input in the form of leading space (' filedir') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"470": {
		CweID:               "470",
		Name:                "Use of Externally-Controlled Input to Select Classes or Code ('Unsafe Reflection')",
		Description:         "The application uses external input with reflection to select which classes or code to use, but it does not sufficiently prevent the input from selecting improper classes or code.",
		ExtendedDescription: "If the application uses external inputs to determine which class to instantiate or which method to invoke, then an attacker could supply values to select unexpected classes or methods. If this occurs, then the attacker could create control flow paths that were not intended by the developer. These paths could bypass authentication or access control checks, or otherwise cause the application to behave in an unexpected manner. This situation becomes a doomsday scenario if the attacker can upload files into a location that appears on the application's classpath (CWE-427) or add new entries to the application's classpath (CWE-426). Under either of these conditions, the attacker can use reflection to introduce new, malicious behavior into the application.",
		Lang:                "en",
	},
	"471": {
		CweID:               "471",
		Name:                "Modification of Assumed-Immutable Data (MAID)",
		Description:         "The software does not properly protect an assumed-immutable element from being modified by an attacker.",
		ExtendedDescription: "This occurs when a particular input is critical enough to the functioning of the application that it should not be modifiable at all, but it is. Certain resources are often assumed to be immutable when they are not, such as hidden form fields in web applications, cookies, and reverse DNS lookups.",
		Lang:                "en",
	},
	"472": {
		CweID:               "472",
		Name:                "External Control of Assumed-Immutable Web Parameter",
		Description:         "The web application does not sufficiently verify inputs that are assumed to be immutable but are actually externally controllable, such as hidden form fields.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"473": {
		CweID:               "473",
		Name:                "PHP External Variable Modification",
		Description:         "A PHP application does not properly protect against the modification of variables from external sources, such as query parameters or cookies. This can expose the application to numerous weaknesses that would not exist otherwise.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"474": {
		CweID:               "474",
		Name:                "Use of Function with Inconsistent Implementations",
		Description:         "The code uses a function that has inconsistent implementations across operating systems and versions.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"475": {
		CweID:               "475",
		Name:                "Undefined Behavior for Input to API",
		Description:         "The behavior of this function is undefined unless its control parameter is set to a specific value.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"476": {
		CweID:               "476",
		Name:                "NULL Pointer Dereference",
		Description:         "A NULL pointer dereference occurs when the application dereferences a pointer that it expects to be valid, but is NULL, typically causing a crash or exit.",
		ExtendedDescription: "NULL pointer dereference issues can occur through a number of flaws, including race conditions, and simple programming omissions.",
		Lang:                "en",
	},
	"477": {
		CweID:               "477",
		Name:                "Use of Obsolete Function",
		Description:         "The code uses deprecated or obsolete functions, which suggests that the code has not been actively reviewed or maintained.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"478": {
		CweID:               "478",
		Name:                "Missing Default Case in Switch Statement",
		Description:         "The code does not have a default case in a switch statement, which might lead to complex logical errors and resultant weaknesses.",
		ExtendedDescription: "This flaw represents a common problem in software development, in which not all possible values for a variable are considered or handled by a given process. Because of this, further decisions are made based on poor information, and cascading failure results. This cascading failure may result in any number of security issues, and constitutes a significant failure in the system.",
		Lang:                "en",
	},
	"479": {
		CweID:               "479",
		Name:                "Signal Handler Use of a Non-reentrant Function",
		Description:         "The program defines a signal handler that calls a non-reentrant function.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"48": {
		CweID:               "48",
		Name:                "Path Equivalence: 'file name' (Internal Whitespace)",
		Description:         "A software system that accepts path input in the form of internal space ('file(SPACE)name') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"480": {
		CweID:               "480",
		Name:                "Use of Incorrect Operator",
		Description:         "The programmer accidentally uses the wrong operator, which changes the application logic in security-relevant ways.",
		ExtendedDescription: "These types of errors are generally the result of a typo.",
		Lang:                "en",
	},
	"481": {
		CweID:               "481",
		Name:                "Assigning instead of Comparing",
		Description:         "The code uses an operator for assignment when the intention was to perform a comparison.",
		ExtendedDescription: "In many languages the compare statement is very close in appearance to the assignment statement and are often confused. This bug is generally the result of a typo and usually causes obvious problems with program execution. If the comparison is in an if statement, the if statement will usually evaluate the value of the right-hand side of the predicate.",
		Lang:                "en",
	},
	"482": {
		CweID:               "482",
		Name:                "Comparing instead of Assigning",
		Description:         "The code uses an operator for comparison when the intention was to perform an assignment.",
		ExtendedDescription: "In many languages, the compare statement is very close in appearance to the assignment statement; they are often confused.",
		Lang:                "en",
	},
	"483": {
		CweID:               "483",
		Name:                "Incorrect Block Delimitation",
		Description:         "The code does not explicitly delimit a block that is intended to contain 2 or more statements, creating a logic error.",
		ExtendedDescription: "In some languages, braces (or other delimiters) are optional for blocks. When the delimiter is omitted, it is possible to insert a logic error in which a statement is thought to be in a block but is not. In some cases, the logic error can have security implications.",
		Lang:                "en",
	},
	"484": {
		CweID:               "484",
		Name:                "Omitted Break Statement in Switch",
		Description:         "The program omits a break statement within a switch or similar construct, causing code associated with multiple conditions to execute. This can cause problems when the programmer only intended to execute code associated with one condition.",
		ExtendedDescription: "This can lead to critical code executing in situations where it should not.",
		Lang:                "en",
	},
	"486": {
		CweID:               "486",
		Name:                "Comparison of Classes by Name",
		Description:         "The program compares classes by name, which can cause it to use the wrong class when multiple classes can have the same name.",
		ExtendedDescription: "If the decision to trust the methods and data of an object is based on the name of a class, it is possible for malicious users to send objects of the same name as trusted classes and thereby gain the trust afforded to known classes and types.",
		Lang:                "en",
	},
	"487": {
		CweID:               "487",
		Name:                "Reliance on Package-level Scope",
		Description:         "Java packages are not inherently closed; therefore, relying on them for code security is not a good practice.",
		ExtendedDescription: "The purpose of package scope is to prevent accidental access by other parts of a program. This is an ease-of-software-development feature but not a security feature.",
		Lang:                "en",
	},
	"488": {
		CweID:               "488",
		Name:                "Exposure of Data Element to Wrong Session",
		Description:         "The product does not sufficiently enforce boundaries between the states of different sessions, causing data to be provided to, or used by, the wrong session.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"489": {
		CweID:               "489",
		Name:                "Leftover Debug Code",
		Description:         "The application can be deployed with active debugging code that can create unintended entry points.",
		ExtendedDescription: "A common development practice is to add 'back door' code specifically designed for debugging or testing purposes that is not intended to be shipped or deployed with the application. These back door entry points create security risks because they are not considered during design or testing and fall outside of the expected operating conditions of the application.",
		Lang:                "en",
	},
	"49": {
		CweID:               "49",
		Name:                "Path Equivalence: 'filename/' (Trailing Slash)",
		Description:         "A software system that accepts path input in the form of trailing slash ('filedir/') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"491": {
		CweID:               "491",
		Name:                "Public cloneable() Method Without Final ('Object Hijack')",
		Description:         "A class has a cloneable() method that is not declared final, which allows an object to be created without calling the constructor. This can cause the object to be in an unexpected state.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"492": {
		CweID:               "492",
		Name:                "Use of Inner Class Containing Sensitive Data",
		Description:         "Inner classes are translated into classes that are accessible at package scope and may expose code that the programmer intended to keep private to attackers.",
		ExtendedDescription: "Inner classes quietly introduce several security concerns because of the way they are translated into Java bytecode. In Java source code, it appears that an inner class can be declared to be accessible only by the enclosing class, but Java bytecode has no concept of an inner class, so the compiler must transform an inner class declaration into a peer class with package level access to the original outer class. More insidiously, since an inner class can access private fields in their enclosing class, once an inner class becomes a peer class in bytecode, the compiler converts private fields accessed by the inner class into protected fields.",
		Lang:                "en",
	},
	"493": {
		CweID:               "493",
		Name:                "Critical Public Variable Without Final Modifier",
		Description:         "The product has a critical public variable that is not final, which allows the variable to be modified to contain unexpected values.",
		ExtendedDescription: "If a field is non-final and public, it can be changed once the value is set by any function that has access to the class which contains the field. This could lead to a vulnerability if other parts of the program make assumptions about the contents of that field.",
		Lang:                "en",
	},
	"494": {
		CweID:               "494",
		Name:                "Download of Code Without Integrity Check",
		Description:         "The product downloads source code or an executable from a remote location and executes the code without sufficiently verifying the origin and integrity of the code.",
		ExtendedDescription: "An attacker can execute malicious code by compromising the host server, performing DNS spoofing, or modifying the code in transit.",
		Lang:                "en",
	},
	"495": {
		CweID:               "495",
		Name:                "Private Array-Typed Field Returned From A Public Method",
		Description:         "The product has a method that is declared public, but returns a reference to a private array, which could then be modified in unexpected ways.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"496": {
		CweID:               "496",
		Name:                "Public Data Assigned to Private Array-Typed Field",
		Description:         "Assigning public data to a private array is equivalent to giving public access to the array.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"497": {
		CweID:               "497",
		Name:                "Exposure of System Data to an Unauthorized Control Sphere",
		Description:         "Exposing system data or debugging information helps an adversary learn about the system and form an attack plan.",
		ExtendedDescription: "An information exposure occurs when system data or debugging information leaves the program through an output stream or logging function that makes it accessible to unauthorized parties. An attacker can also cause errors to occur by submitting unusual requests to the web application. The response to these errors can reveal detailed system information, deny service, cause security mechanisms to fail, and crash the server. An attacker can use error messages that reveal technologies, operating systems, and product versions to tune the attack against known vulnerabilities in these technologies. An application may use diagnostic methods that provide significant implementation details such as stack traces as part of its error handling mechanism.",
		Lang:                "en",
	},
	"498": {
		CweID:               "498",
		Name:                "Cloneable Class Containing Sensitive Information",
		Description:         "The code contains a class with sensitive data, but the class is cloneable. The data can then be accessed by cloning the class.",
		ExtendedDescription: "Cloneable classes are effectively open classes, since data cannot be hidden in them. Classes that do not explicitly deny cloning can be cloned by any other class without running the constructor.",
		Lang:                "en",
	},
	"499": {
		CweID:               "499",
		Name:                "Serializable Class Containing Sensitive Data",
		Description:         "The code contains a class with sensitive data, but the class does not explicitly deny serialization. The data can be accessed by serializing the class through another class.",
		ExtendedDescription: "Serializable classes are effectively open classes since data cannot be hidden in them. Classes that do not explicitly deny serialization can be serialized by any other class, which can then in turn use the data stored inside it.",
		Lang:                "en",
	},
	"5": {
		CweID:               "5",
		Name:                "J2EE Misconfiguration: Data Transmission Without Encryption",
		Description:         "Information sent over a network can be compromised while in transit. An attacker may be able to read or modify the contents if the data are sent in plaintext or are weakly encrypted.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"50": {
		CweID:               "50",
		Name:                "Path Equivalence: '//multiple/leading/slash'",
		Description:         "A software system that accepts path input in the form of multiple leading slash ('//multiple/leading/slash') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"500": {
		CweID:               "500",
		Name:                "Public Static Field Not Marked Final",
		Description:         "An object contains a public static field that is not marked final, which might allow it to be modified in unexpected ways.",
		ExtendedDescription: "Public static variables can be read without an accessor and changed without a mutator by any classes in the application.",
		Lang:                "en",
	},
	"501": {
		CweID:               "501",
		Name:                "Trust Boundary Violation",
		Description:         "The product mixes trusted and untrusted data in the same data structure or structured message.",
		ExtendedDescription: "A trust boundary can be thought of as line drawn through a program. On one side of the line, data is untrusted. On the other side of the line, data is assumed to be trustworthy. The purpose of validation logic is to allow data to safely cross the trust boundary - to move from untrusted to trusted. A trust boundary violation occurs when a program blurs the line between what is trusted and what is untrusted. By combining trusted and untrusted data in the same data structure, it becomes easier for programmers to mistakenly trust unvalidated data.",
		Lang:                "en",
	},
	"502": {
		CweID:               "502",
		Name:                "Deserialization of Untrusted Data",
		Description:         "The application deserializes untrusted data without sufficiently verifying that the resulting data will be valid.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"506": {
		CweID:               "506",
		Name:                "Embedded Malicious Code",
		Description:         "The application contains code that appears to be malicious in nature.",
		ExtendedDescription: "Malicious flaws have acquired colorful names, including Trojan horse, trapdoor, timebomb, and logic-bomb. A developer might insert malicious code with the intent to subvert the security of an application or its host system at some time in the future. It generally refers to a program that performs a useful service but exploits rights of the program's user in a way the user does not intend.",
		Lang:                "en",
	},
	"507": {
		CweID:               "507",
		Name:                "Trojan Horse",
		Description:         "The software appears to contain benign or useful functionality, but it also contains code that is hidden from normal operation that violates the intended security policy of the user or the system administrator.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"508": {
		CweID:               "508",
		Name:                "Non-Replicating Malicious Code",
		Description:         "Non-replicating malicious code only resides on the target system or software that is attacked; it does not attempt to spread to other systems.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"509": {
		CweID:               "509",
		Name:                "Replicating Malicious Code (Virus or Worm)",
		Description:         "Replicating malicious code, including viruses and worms, will attempt to attack other systems once it has successfully compromised the target system or software.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"51": {
		CweID:               "51",
		Name:                "Path Equivalence: '/multiple//internal/slash'",
		Description:         "A software system that accepts path input in the form of multiple internal slash ('/multiple//internal/slash/') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"510": {
		CweID:               "510",
		Name:                "Trapdoor",
		Description:         "A trapdoor is a hidden piece of code that responds to a special input, allowing its user access to resources without passing through the normal security enforcement mechanism.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"511": {
		CweID:               "511",
		Name:                "Logic/Time Bomb",
		Description:         "The software contains code that is designed to disrupt the legitimate operation of the software (or its environment) when a certain time passes, or when a certain logical condition is met.",
		ExtendedDescription: "When the time bomb or logic bomb is detonated, it may perform a denial of service such as crashing the system, deleting critical data, or degrading system response time. This bomb might be placed within either a replicating or non-replicating Trojan horse.",
		Lang:                "en",
	},
	"512": {
		CweID:               "512",
		Name:                "Spyware",
		Description:         "The software collects personally identifiable information about a human user or the user's activities, but the software accesses this information using other resources besides itself, and it does not require that user's explicit approval or direct input into the software.",
		ExtendedDescription: "'Spyware' is a commonly used term with many definitions and interpretations. In general, it is meant to software that collects information or installs functionality that human users might not allow if they were fully aware of the actions being taken by the software. For example, a user might expect that tax software would collect a social security number and include it when filing a tax return, but that same user would not expect gaming software to obtain the social security number from that tax software's data.",
		Lang:                "en",
	},
	"514": {
		CweID:               "514",
		Name:                "Covert Channel",
		Description:         "A covert channel is a path that can be used to transfer information in a way not intended by the system's designers.",
		ExtendedDescription: "Typically the system has not given authorization for the transmission and has no knowledge of its occurrence.",
		Lang:                "en",
	},
	"515": {
		CweID:               "515",
		Name:                "Covert Storage Channel",
		Description:         "A covert storage channel transfers information through the setting of bits by one program and the reading of those bits by another. What distinguishes this case from that of ordinary operation is that the bits are used to convey encoded information.",
		ExtendedDescription: "Covert storage channels occur when out-of-band data is stored in messages for the purpose of memory reuse. Covert channels are frequently classified as either storage or timing channels. Examples would include using a file intended to hold only audit information to convey user passwords--using the name of a file or perhaps status bits associated with it that can be read by all users to signal the contents of the file. Steganography, concealing information in such a manner that no one but the intended recipient knows of the existence of the message, is a good example of a covert storage channel.",
		Lang:                "en",
	},
	"516": {
		CweID:               "516",
		Name:                "DEPRECATED (Duplicate): Covert Timing Channel",
		Description:         "This weakness can be found at CWE-385.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"52": {
		CweID:               "52",
		Name:                "Path Equivalence: '/multiple/trailing/slash//'",
		Description:         "A software system that accepts path input in the form of multiple trailing slash ('/multiple/trailing/slash//') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"520": {
		CweID:               "520",
		Name:                ".NET Misconfiguration: Use of Impersonation",
		Description:         "Allowing a .NET application to run at potentially escalated levels of access to the underlying operating and file systems can be dangerous and result in various forms of attacks.",
		ExtendedDescription: ".NET server applications can optionally execute using the identity of the user authenticated to the client. The intention of this functionality is to bypass authentication and access control checks within the .NET application code. Authentication is done by the underlying web server (Microsoft Internet Information Service IIS), which passes the authenticated token, or unauthenticated anonymous token, to the .NET application. Using the token to impersonate the client, the application then relies on the settings within the NTFS directories and files to control access. Impersonation enables the application, on the server running the .NET application, to both execute code and access resources in the context of the authenticated and authorized user.",
		Lang:                "en",
	},
	"521": {
		CweID:               "521",
		Name:                "Weak Password Requirements",
		Description:         "The product does not require that users should have strong passwords, which makes it easier for attackers to compromise user accounts.",
		ExtendedDescription: "An authentication mechanism is only as strong as its credentials. For this reason, it is important to require users to have strong passwords. Lack of password complexity significantly reduces the search space when trying to guess user's passwords, making brute-force attacks easier.",
		Lang:                "en",
	},
	"522": {
		CweID:               "522",
		Name:                "Insufficiently Protected Credentials",
		Description:         "This weakness occurs when the application transmits or stores authentication credentials and uses an insecure method that is susceptible to unauthorized interception and/or retrieval.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"523": {
		CweID:               "523",
		Name:                "Unprotected Transport of Credentials",
		Description:         "Login pages not using adequate measures to protect the user name and password while they are in transit from the client to the server.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"524": {
		CweID:               "524",
		Name:                "Information Exposure Through Caching",
		Description:         "The application uses a cache to maintain a pool of objects, threads, connections, pages, or passwords to minimize the time it takes to access them or the resources to which they connect. If implemented improperly, these caches can allow access to unauthorized information or cause a denial of service vulnerability.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"525": {
		CweID:               "525",
		Name:                "Information Exposure Through Browser Caching",
		Description:         "For each web page, the application should have an appropriate caching policy specifying the extent to which the page and its form fields should be cached.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"526": {
		CweID:               "526",
		Name:                "Information Exposure Through Environmental Variables",
		Description:         "Environmental variables may contain sensitive information about a remote server.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"527": {
		CweID:               "527",
		Name:                "Exposure of CVS Repository to an Unauthorized Control Sphere",
		Description:         "The product stores a CVS repository in a directory or other container that is accessible to actors outside of the intended control sphere.",
		ExtendedDescription: "Information contained within a CVS subdirectory on a web server or other server could be recovered by an attacker and used for malicious purposes. This information may include usernames, filenames, path root, and IP addresses.",
		Lang:                "en",
	},
	"528": {
		CweID:               "528",
		Name:                "Exposure of Core Dump File to an Unauthorized Control Sphere",
		Description:         "The product generates a core dump file in a directory that is accessible to actors outside of the intended control sphere.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"529": {
		CweID:               "529",
		Name:                "Exposure of Access Control List Files to an Unauthorized Control Sphere",
		Description:         "The product stores access control list files in a directory or other container that is accessible to actors outside of the intended control sphere.",
		ExtendedDescription: "Exposure of these access control list files may give the attacker information about the configuration of the site or system. This information may then be used to bypass the intended security policy or identify trusted systems from which an attack can be launched.",
		Lang:                "en",
	},
	"53": {
		CweID:               "53",
		Name:                "Path Equivalence: '\\multiple\\\\internal\\backslash'",
		Description:         "A software system that accepts path input in the form of multiple internal backslash ('\\multiple\\trailing\\\\slash') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"530": {
		CweID:               "530",
		Name:                "Exposure of Backup File to an Unauthorized Control Sphere",
		Description:         "A backup file is stored in a directory that is accessible to actors outside of the intended control sphere.",
		ExtendedDescription: "Often, old files are renamed with an extension such as .~bk to distinguish them from production files. The source code for old files that have been renamed in this manner and left in the webroot can often be retrieved. This renaming may have been performed automatically by the web server, or manually by the administrator.",
		Lang:                "en",
	},
	"531": {
		CweID:               "531",
		Name:                "Information Exposure Through Test Code",
		Description:         "Accessible test applications can pose a variety of security risks. Since developers or administrators rarely consider that someone besides themselves would even know about the existence of these applications, it is common for them to contain sensitive information or functions.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"532": {
		CweID:               "532",
		Name:                "Information Exposure Through Log Files",
		Description:         "Information written to log files can be of a sensitive nature and give valuable guidance to an attacker or expose sensitive user information.",
		ExtendedDescription: "While logging all information may be helpful during development stages, it is important that logging levels be set appropriately before a product ships so that sensitive user data and system information are not accidentally exposed to potential attackers.",
		Lang:                "en",
	},
	"533": {
		CweID:               "533",
		Name:                "Information Exposure Through Server Log Files",
		Description:         "A server.log file was found. This can give information on whatever application left the file. Usually this can give full path names and system information, and sometimes usernames and passwords.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"534": {
		CweID:               "534",
		Name:                "Information Exposure Through Debug Log Files",
		Description:         "The application does not sufficiently restrict access to a log file that is used for debugging.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"535": {
		CweID:               "535",
		Name:                "Information Exposure Through Shell Error Message",
		Description:         "A command shell error message indicates that there exists an unhandled exception in the web application code. In many cases, an attacker can leverage the conditions that cause these errors in order to gain unauthorized access to the system.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"536": {
		CweID:               "536",
		Name:                "Information Exposure Through Servlet Runtime Error Message",
		Description:         "A servlet error message indicates that there exists an unhandled exception in your web application code and may provide useful information to an attacker.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"537": {
		CweID:               "537",
		Name:                "Information Exposure Through Java Runtime Error Message",
		Description:         "In many cases, an attacker can leverage the conditions that cause unhandled exception errors in order to gain unauthorized access to the system.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"538": {
		CweID:               "538",
		Name:                "File and Directory Information Exposure",
		Description:         "The product stores sensitive information in files or directories that are accessible to actors outside of the intended control sphere.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"539": {
		CweID:               "539",
		Name:                "Information Exposure Through Persistent Cookies",
		Description:         "Persistent cookies are cookies that are stored on the browser's hard drive. This can cause security and privacy issues depending on the information stored in the cookie and how it is accessed.",
		ExtendedDescription: "Cookies are small bits of data that are sent by the web application but stored locally in the browser. This lets the application use the cookie to pass information between pages and store variable information. The web application controls what information is stored in a cookie and how it is used. Typical types of information stored in cookies are session Identifiers, personalization and customization information, and in rare cases even usernames to enable automated logins. There are two different types of cookies: session cookies and persistent cookies. Session cookies just live in the browser's memory, and are not stored anywhere, but persistent cookies are stored on the browser's hard drive.",
		Lang:                "en",
	},
	"54": {
		CweID:               "54",
		Name:                "Path Equivalence: 'filedir\\' (Trailing Backslash)",
		Description:         "A software system that accepts path input in the form of trailing backslash ('filedir\\') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"540": {
		CweID:               "540",
		Name:                "Information Exposure Through Source Code",
		Description:         "Source code on a web server often contains sensitive information and should generally not be accessible to users.",
		ExtendedDescription: "There are situations where it is critical to remove source code from an area or server. For example, obtaining Perl source code on a system allows an attacker to understand the logic of the script and extract extremely useful information such as code bugs or logins and passwords.",
		Lang:                "en",
	},
	"541": {
		CweID:               "541",
		Name:                "Information Exposure Through Include Source Code",
		Description:         "If an include file source is accessible, the file can contain usernames and passwords, as well as sensitive information pertaining to the application and system.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"542": {
		CweID:               "542",
		Name:                "Information Exposure Through Cleanup Log Files",
		Description:         "The application does not properly protect or delete a log file related to cleanup.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"543": {
		CweID:               "543",
		Name:                "Use of Singleton Pattern Without Synchronization in a Multithreaded Context",
		Description:         "The software uses the singleton pattern when creating a resource within a multithreaded environment.",
		ExtendedDescription: "The use of a singleton pattern may not be thread-safe.",
		Lang:                "en",
	},
	"544": {
		CweID:               "544",
		Name:                "Missing Standardized Error Handling Mechanism",
		Description:         "The software does not use a standardized method for handling errors throughout the code, which might introduce inconsistent error handling and resultant weaknesses.",
		ExtendedDescription: "If the application handles error messages individually, on a one-by-one basis, this is likely to result in inconsistent error handling. The causes of errors may be lost. Also, detailed information about the causes of an error may be unintentionally returned to the user.",
		Lang:                "en",
	},
	"545": {
		CweID:               "545",
		Name:                "DEPRECATED: Use of Dynamic Class Loading",
		Description:         "This weakness has been deprecated because it partially overlaps CWE-470, it describes legitimate programmer behavior, and other portions will need to be integrated into other entries.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"546": {
		CweID:               "546",
		Name:                "Suspicious Comment",
		Description:         "The code contains comments that suggest the presence of bugs, incomplete functionality, or weaknesses.",
		ExtendedDescription: "Many suspicious comments, such as BUG, HACK, FIXME, LATER, LATER2, TODO, in the code indicate missing security functionality and checking. Others indicate code problems that programmers should fix, such as hard-coded variables, error handling, not using stored procedures, and performance issues.",
		Lang:                "en",
	},
	"547": {
		CweID:               "547",
		Name:                "Use of Hard-coded, Security-relevant Constants",
		Description:         "The program uses hard-coded constants instead of symbolic names for security-critical values, which increases the likelihood of mistakes during code maintenance or security policy change.",
		ExtendedDescription: "If the developer does not find all occurrences of the hard-coded constants, an incorrect policy decision may be made if one of the constants is not changed. Making changes to these values will require code changes that may be difficult or impossible once the system is released to the field. In addition, these hard-coded values may become available to attackers if the code is ever disclosed.",
		Lang:                "en",
	},
	"548": {
		CweID:               "548",
		Name:                "Information Exposure Through Directory Listing",
		Description:         "A directory listing is inappropriately exposed, yielding potentially sensitive information to attackers.",
		ExtendedDescription: "A directory listing provides an attacker with the complete index of all the resources located inside of the directory. The specific risks and consequences vary depending on which files are listed and accessible.",
		Lang:                "en",
	},
	"549": {
		CweID:               "549",
		Name:                "Missing Password Field Masking",
		Description:         "The software does not mask passwords during entry, increasing the potential for attackers to observe and capture passwords.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"55": {
		CweID:               "55",
		Name:                "Path Equivalence: '/./' (Single Dot Directory)",
		Description:         "A software system that accepts path input in the form of single dot directory exploit ('/./') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"550": {
		CweID:               "550",
		Name:                "Information Exposure Through Server Error Message",
		Description:         "Certain conditions, such as network failure, will cause a server error message to be displayed.",
		ExtendedDescription: "While error messages in and of themselves are not dangerous, per se, it is what an attacker can glean from them that might cause eventual problems.",
		Lang:                "en",
	},
	"551": {
		CweID:               "551",
		Name:                "Incorrect Behavior Order: Authorization Before Parsing and Canonicalization",
		Description:         "If a web server does not fully parse requested URLs before it examines them for authorization, it may be possible for an attacker to bypass authorization protection.",
		ExtendedDescription: "For instance, the character strings /./ and / both mean current directory. If /SomeDirectory is a protected directory and an attacker requests /./SomeDirectory, the attacker may be able to gain access to the resource if /./ is not converted to / before the authorization check is performed.",
		Lang:                "en",
	},
	"552": {
		CweID:               "552",
		Name:                "Files or Directories Accessible to External Parties",
		Description:         "Files or directories are accessible in the environment that should not be.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"553": {
		CweID:               "553",
		Name:                "Command Shell in Externally Accessible Directory",
		Description:         "A possible shell file exists in /cgi-bin/ or other accessible directories. This is extremely dangerous and can be used by an attacker to execute commands on the web server.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"554": {
		CweID:               "554",
		Name:                "ASP.NET Misconfiguration: Not Using Input Validation Framework",
		Description:         "The ASP.NET application does not use an input validation framework.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"555": {
		CweID:               "555",
		Name:                "J2EE Misconfiguration: Plaintext Password in Configuration File",
		Description:         "The J2EE application stores a plaintext password in a configuration file.",
		ExtendedDescription: "Storing a plaintext password in a configuration file allows anyone who can read the file to access the password-protected resource, making it an easy target for attackers.",
		Lang:                "en",
	},
	"556": {
		CweID:               "556",
		Name:                "ASP.NET Misconfiguration: Use of Identity Impersonation",
		Description:         "Configuring an ASP.NET application to run with impersonated credentials may give the application unnecessary privileges.",
		ExtendedDescription: "The use of impersonated credentials allows an ASP.NET application to run with either the privileges of the client on whose behalf it is executing or with arbitrary privileges granted in its configuration.",
		Lang:                "en",
	},
	"558": {
		CweID:               "558",
		Name:                "Use of getlogin() in Multithreaded Application",
		Description:         "The application uses the getlogin() function in a multithreaded context, potentially causing it to return incorrect values.",
		ExtendedDescription: "The getlogin() function returns a pointer to a string that contains the name of the user associated with the calling process. The function is not reentrant, meaning that if it is called from another process, the contents are not locked out and the value of the string can be changed by another process. This makes it very risky to use because the username can be changed by other processes, so the results of the function cannot be trusted.",
		Lang:                "en",
	},
	"56": {
		CweID:               "56",
		Name:                "Path Equivalence: 'filedir*' (Wildcard)",
		Description:         "A software system that accepts path input in the form of asterisk wildcard ('filedir*') without appropriate validation can lead to ambiguous path resolution and allow an attacker to traverse the file system to unintended locations or access arbitrary files.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"560": {
		CweID:               "560",
		Name:                "Use of umask() with chmod-style Argument",
		Description:         "The product calls umask() with an incorrect argument that is specified as if it is an argument to chmod().",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"561": {
		CweID:               "561",
		Name:                "Dead Code",
		Description:         "The software contains dead code, which can never be executed.",
		ExtendedDescription: "Dead code is source code that can never be executed in a running program. The surrounding code makes it impossible for a section of code to ever be executed.",
		Lang:                "en",
	},
	"562": {
		CweID:               "562",
		Name:                "Return of Stack Variable Address",
		Description:         "A function returns the address of a stack variable, which will cause unintended program behavior, typically in the form of a crash.",
		ExtendedDescription: "Because local variables are allocated on the stack, when a program returns a pointer to a local variable, it is returning a stack address. A subsequent function call is likely to re-use this same stack address, thereby overwriting the value of the pointer, which no longer corresponds to the same variable since a function's stack frame is invalidated when it returns. At best this will cause the value of the pointer to change unexpectedly. In many cases it causes the program to crash the next time the pointer is dereferenced.",
		Lang:                "en",
	},
	"563": {
		CweID:               "563",
		Name:                "Assignment to Variable without Use",
		Description:         "The variable's value is assigned but never used, making it a dead store.",
		ExtendedDescription: "After the assignment, the variable is either assigned another value or goes out of scope. It is likely that the variable is simply vestigial, but it is also possible that the unused variable points out a bug.",
		Lang:                "en",
	},
	"564": {
		CweID:               "564",
		Name:                "SQL Injection: Hibernate",
		Description:         "Using Hibernate to execute a dynamic SQL statement built with user-controlled input can allow an attacker to modify the statement's meaning or to execute arbitrary SQL commands.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"565": {
		CweID:               "565",
		Name:                "Reliance on Cookies without Validation and Integrity Checking",
		Description:         "The application relies on the existence or values of cookies when performing security-critical operations, but it does not properly ensure that the setting is valid for the associated user.",
		ExtendedDescription: "Attackers can easily modify cookies, within the browser or by implementing the client-side code outside of the browser. Reliance on cookies without detailed validation and integrity checking can allow attackers to bypass authentication, conduct injection attacks such as SQL injection and cross-site scripting, or otherwise modify inputs in unexpected ways.",
		Lang:                "en",
	},
	"566": {
		CweID:               "566",
		Name:                "Authorization Bypass Through User-Controlled SQL Primary Key",
		Description:         "The software uses a database table that includes records that should not be accessible to an actor, but it executes a SQL statement with a primary key that can be controlled by that actor.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"567": {
		CweID:               "567",
		Name:                "Unsynchronized Access to Shared Data in a Multithreaded Context",
		Description:         "The product does not properly synchronize shared data, such as static variables across threads, which can lead to undefined behavior and unpredictable data changes.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"568": {
		CweID:               "568",
		Name:                "finalize() Method Without super.finalize()",
		Description:         "The software contains a finalize() method that does not call super.finalize().",
		ExtendedDescription: "The Java Language Specification states that it is a good practice for a finalize() method to call super.finalize().",
		Lang:                "en",
	},
	"57": {
		CweID:               "57",
		Name:                "Path Equivalence: 'fakedir/../realdir/filename'",
		Description:         "The software contains protection mechanisms to restrict access to 'realdir/filename', but it constructs pathnames using external input in the form of 'fakedir/../realdir/filename' that are not handled by those mechanisms. This allows attackers to perform unauthorized actions against the targeted file.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"570": {
		CweID:               "570",
		Name:                "Expression is Always False",
		Description:         "The software contains an expression that will always evaluate to false.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"571": {
		CweID:               "571",
		Name:                "Expression is Always True",
		Description:         "The software contains an expression that will always evaluate to true.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"572": {
		CweID:               "572",
		Name:                "Call to Thread run() instead of start()",
		Description:         "The program calls a thread's run() method instead of calling start(), which causes the code to run in the thread of the caller instead of the callee.",
		ExtendedDescription: "In most cases a direct call to a Thread object's run() method is a bug. The programmer intended to begin a new thread of control, but accidentally called run() instead of start(), so the run() method will execute in the caller's thread of control.",
		Lang:                "en",
	},
	"573": {
		CweID:               "573",
		Name:                "Improper Following of Specification by Caller",
		Description:         "The software does not follow or incorrectly follows the specifications as required by the implementation language, environment, framework, protocol, or platform.",
		ExtendedDescription: "When leveraging external functionality, such as an API, it is important that the caller does so in accordance with the requirements of the external functionality or else unintended behaviors may result, possibly leaving the system vulnerable to any number of exploits.",
		Lang:                "en",
	},
	"574": {
		CweID:               "574",
		Name:                "EJB Bad Practices: Use of Synchronization Primitives",
		Description:         "The program violates the Enterprise JavaBeans (EJB) specification by using thread synchronization primitives.",
		ExtendedDescription: "The Enterprise JavaBeans specification requires that every bean provider follow a set of programming guidelines designed to ensure that the bean will be portable and behave consistently in any EJB container. In this case, the program violates the following EJB guideline: 'An enterprise bean must not use thread synchronization primitives to synchronize execution of multiple instances.' The specification justifies this requirement in the following way: 'This rule is required to ensure consistent runtime semantics because while some EJB containers may use a single JVM to execute all enterprise bean's instances, others may distribute the instances across multiple JVMs.'",
		Lang:                "en",
	},
	"575": {
		CweID:               "575",
		Name:                "EJB Bad Practices: Use of AWT Swing",
		Description:         "The program violates the Enterprise JavaBeans (EJB) specification by using AWT/Swing.",
		ExtendedDescription: "The Enterprise JavaBeans specification requires that every bean provider follow a set of programming guidelines designed to ensure that the bean will be portable and behave consistently in any EJB container. In this case, the program violates the following EJB guideline: 'An enterprise bean must not use the AWT functionality to attempt to output information to a display, or to input information from a keyboard.' The specification justifies this requirement in the following way: 'Most servers do not allow direct interaction between an application program and a keyboard/display attached to the server system.'",
		Lang:                "en",
	},
	"576": {
		CweID:               "576",
		Name:                "EJB Bad Practices: Use of Java I/O",
		Description:         "The program violates the Enterprise JavaBeans (EJB) specification by using the java.io package.",
		ExtendedDescription: "The Enterprise JavaBeans specification requires that every bean provider follow a set of programming guidelines designed to ensure that the bean will be portable and behave consistently in any EJB container. In this case, the program violates the following EJB guideline: 'An enterprise bean must not use the java.io package to attempt to access files and directories in the file system.' The specification justifies this requirement in the following way: 'The file system APIs are not well-suited for business components to access data. Business components should use a resource manager API, such as JDBC, to store data.'",
		Lang:                "en",
	},
	"577": {
		CweID:               "577",
		Name:                "EJB Bad Practices: Use of Sockets",
		Description:         "The program violates the Enterprise JavaBeans (EJB) specification by using sockets.",
		ExtendedDescription: "The Enterprise JavaBeans specification requires that every bean provider follow a set of programming guidelines designed to ensure that the bean will be portable and behave consistently in any EJB container. In this case, the program violates the following EJB guideline: 'An enterprise bean must not attempt to listen on a socket, accept connections on a socket, or use a socket for multicast.' The specification justifies this requirement in the following way: 'The EJB architecture allows an enterprise bean instance to be a network socket client, but it does not allow it to be a network server. Allowing the instance to become a network server would conflict with the basic function of the enterprise bean-- to serve the EJB clients.'",
		Lang:                "en",
	},
	"578": {
		CweID:               "578",
		Name:                "EJB Bad Practices: Use of Class Loader",
		Description:         "The program violates the Enterprise JavaBeans (EJB) specification by using the class loader.",
		ExtendedDescription: "The Enterprise JavaBeans specification requires that every bean provider follow a set of programming guidelines designed to ensure that the bean will be portable and behave consistently in any EJB container. In this case, the program violates the following EJB guideline: 'The enterprise bean must not attempt to create a class loader; obtain the current class loader; set the context class loader; set security manager; create a new security manager; stop the JVM; or change the input, output, and error streams.' The specification justifies this requirement in the following way: 'These functions are reserved for the EJB container. Allowing the enterprise bean to use these functions could compromise security and decrease the container's ability to properly manage the runtime environment.'",
		Lang:                "en",
	},
	"579": {
		CweID:               "579",
		Name:                "J2EE Bad Practices: Non-serializable Object Stored in Session",
		Description:         "The application stores a non-serializable object as an HttpSession attribute, which can hurt reliability.",
		ExtendedDescription: "A J2EE application can make use of multiple JVMs in order to improve application reliability and performance. In order to make the multiple JVMs appear as a single application to the end user, the J2EE container can replicate an HttpSession object across multiple JVMs so that if one JVM becomes unavailable another can step in and take its place without disrupting the flow of the application. This is only possible if all session data is serializable, allowing the session to be duplicated between the JVMs.",
		Lang:                "en",
	},
	"58": {
		CweID:               "58",
		Name:                "Path Equivalence: Windows 8.3 Filename",
		Description:         "The software contains a protection mechanism that restricts access to a long filename on a Windows operating system, but the software does not properly restrict access to the equivalent short '8.3' filename.",
		ExtendedDescription: "On later Windows operating systems, a file can have a 'long name' and a short name that is compatible with older Windows file systems, with up to 8 characters in the filename and 3 characters for the extension. These '8.3' filenames, therefore, act as an alternate name for files with long names, so they are useful pathname equivalence manipulations.",
		Lang:                "en",
	},
	"580": {
		CweID:               "580",
		Name:                "clone() Method Without super.clone()",
		Description:         "The software contains a clone() method that does not call super.clone() to obtain the new object.",
		ExtendedDescription: "All implementations of clone() should obtain the new object by calling super.clone(). If a class does not follow this convention, a subclass's clone() method will return an object of the wrong type.",
		Lang:                "en",
	},
	"581": {
		CweID:               "581",
		Name:                "Object Model Violation: Just One of Equals and Hashcode Defined",
		Description:         "The software does not maintain equal hashcodes for equal objects.",
		ExtendedDescription: "Java objects are expected to obey a number of invariants related to equality. One of these invariants is that equal objects must have equal hashcodes. In other words, if a.equals(b) == true then a.hashCode() == b.hashCode().",
		Lang:                "en",
	},
	"582": {
		CweID:               "582",
		Name:                "Array Declared Public, Final, and Static",
		Description:         "The program declares an array public, final, and static, which is not sufficient to prevent the array's contents from being modified.",
		ExtendedDescription: "Because arrays are mutable objects, the final constraint requires that the array object itself be assigned only once, but makes no guarantees about the values of the array elements. Since the array is public, a malicious program can change the values stored in the array. As such, in most cases an array declared public, final and static is a bug.",
		Lang:                "en",
	},
	"583": {
		CweID:               "583",
		Name:                "finalize() Method Declared Public",
		Description:         "The program violates secure coding principles for mobile code by declaring a finalize() method public.",
		ExtendedDescription: "A program should never call finalize explicitly, except to call super.finalize() inside an implementation of finalize(). In mobile code situations, the otherwise error prone practice of manual garbage collection can become a security threat if an attacker can maliciously invoke one of your finalize() methods because it is declared with public access.",
		Lang:                "en",
	},
	"584": {
		CweID:               "584",
		Name:                "Return Inside Finally Block",
		Description:         "The code has a return statement inside a finally block, which will cause any thrown exception in the try block to be discarded.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"585": {
		CweID:               "585",
		Name:                "Empty Synchronized Block",
		Description:         "The software contains an empty synchronized block.",
		ExtendedDescription: "An empty synchronized block does not actually accomplish any synchronization and may indicate a troubled section of code. An empty synchronized block can occur because code no longer needed within the synchronized block is commented out without removing the synchronized block.",
		Lang:                "en",
	},
	"586": {
		CweID:               "586",
		Name:                "Explicit Call to Finalize()",
		Description:         "The software makes an explicit call to the finalize() method from outside the finalizer.",
		ExtendedDescription: "While the Java Language Specification allows an object's finalize() method to be called from outside the finalizer, doing so is usually a bad idea. For example, calling finalize() explicitly means that finalize() will be called more than once: the first time will be the explicit call and the last time will be the call that is made after the object is garbage collected.",
		Lang:                "en",
	},
	"587": {
		CweID:               "587",
		Name:                "Assignment of a Fixed Address to a Pointer",
		Description:         "The software sets a pointer to a specific address other than NULL or 0.",
		ExtendedDescription: "Using a fixed address is not portable because that address will probably not be valid in all environments or platforms.",
		Lang:                "en",
	},
	"588": {
		CweID:               "588",
		Name:                "Attempt to Access Child of a Non-structure Pointer",
		Description:         "Casting a non-structure type to a structure type and accessing a field can lead to memory access errors or data corruption.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"589": {
		CweID:               "589",
		Name:                "Call to Non-ubiquitous API",
		Description:         "The software uses an API function that does not exist on all versions of the target platform. This could cause portability problems or inconsistencies that allow denial of service or other consequences.",
		ExtendedDescription: "Some functions that offer security features supported by the OS are not available on all versions of the OS in common use. Likewise, functions are often deprecated or made obsolete for security reasons and should not be used.",
		Lang:                "en",
	},
	"59": {
		CweID:               "59",
		Name:                "Improper Link Resolution Before File Access ('Link Following')",
		Description:         "The software attempts to access a file based on the filename, but it does not properly prevent that filename from identifying a link or shortcut that resolves to an unintended resource.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"590": {
		CweID:               "590",
		Name:                "Free of Memory not on the Heap",
		Description:         "The application calls free() on a pointer to memory that was not allocated using associated heap allocation functions such as malloc(), calloc(), or realloc().",
		ExtendedDescription: "When free() is called on an invalid pointer, the program's memory management data structures may become corrupted. This corruption can cause the program to crash or, in some circumstances, an attacker may be able to cause free() to operate on controllable memory locations to modify critical program variables or execute code.",
		Lang:                "en",
	},
	"591": {
		CweID:               "591",
		Name:                "Sensitive Data Storage in Improperly Locked Memory",
		Description:         "The application stores sensitive data in memory that is not locked, or that has been incorrectly locked, which might cause the memory to be written to swap files on disk by the virtual memory manager. This can make the data more accessible to external actors.",
		ExtendedDescription: "On Windows systems the VirtualLock function can lock a page of memory to ensure that it will remain present in memory and not be swapped to disk. However, on older versions of Windows, such as 95, 98, or Me, the VirtualLock() function is only a stub and provides no protection. On POSIX systems the mlock() call ensures that a page will stay resident in memory but does not guarantee that the page will not appear in the swap. Therefore, it is unsuitable for use as a protection mechanism for sensitive data. Some platforms, in particular Linux, do make the guarantee that the page will not be swapped, but this is non-standard and is not portable. Calls to mlock() also require supervisor privilege. Return values for both of these calls must be checked to ensure that the lock operation was actually successful.",
		Lang:                "en",
	},
	"592": {
		CweID:               "592",
		Name:                "DEPRECATED: Authentication Bypass Issues",
		Description:         "This weakness has been deprecated because it covered redundant concepts already described in CWE-287.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"593": {
		CweID:               "593",
		Name:                "Authentication Bypass: OpenSSL CTX Object Modified after SSL Objects are Created",
		Description:         "The software modifies the SSL context after connection creation has begun.",
		ExtendedDescription: "If the program modifies the SSL_CTX object after creating SSL objects from it, there is the possibility that older SSL objects created from the original context could all be affected by that change.",
		Lang:                "en",
	},
	"594": {
		CweID:               "594",
		Name:                "J2EE Framework: Saving Unserializable Objects to Disk",
		Description:         "When the J2EE container attempts to write unserializable objects to disk there is no guarantee that the process will complete successfully.",
		ExtendedDescription: "In heavy load conditions, most J2EE application frameworks flush objects to disk to manage memory requirements of incoming requests. For example, session scoped objects, and even application scoped objects, are written to disk when required. While these application frameworks do the real work of writing objects to disk, they do not enforce that those objects be serializable, thus leaving the web application vulnerable to crashes induced by serialization failure. An attacker may be able to mount a denial of service attack by sending enough requests to the server to force the web application to save objects to disk.",
		Lang:                "en",
	},
	"595": {
		CweID:               "595",
		Name:                "Comparison of Object References Instead of Object Contents",
		Description:         "The program compares object references instead of the contents of the objects themselves, preventing it from detecting equivalent objects.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"596": {
		CweID:               "596",
		Name:                "Incorrect Semantic Object Comparison",
		Description:         "The software does not correctly compare two objects based on their conceptual content.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"597": {
		CweID:               "597",
		Name:                "Use of Wrong Operator in String Comparison",
		Description:         "The product uses the wrong operator when comparing a string, such as using '==' when the equals() method should be used instead.",
		ExtendedDescription: "In Java, using == or != to compare two strings for equality actually compares two objects for equality, not their values. Chances are good that the two references will never be equal. While this weakness often only affects program correctness, if the equality is used for a security decision, it could be leveraged to affect program security.",
		Lang:                "en",
	},
	"598": {
		CweID:               "598",
		Name:                "Information Exposure Through Query Strings in GET Request",
		Description:         "The web application uses the GET method to process requests that contain sensitive information, which can expose that information through the browser's history, Referers, web logs, and other sources.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"599": {
		CweID:               "599",
		Name:                "Missing Validation of OpenSSL Certificate",
		Description:         "The software uses OpenSSL and trusts or uses a certificate without using the SSL_get_verify_result() function to ensure that the certificate satisfies all necessary security requirements.",
		ExtendedDescription: "This could allow an attacker to use an invalid certificate to claim to be a trusted host, use expired certificates, or conduct other attacks that could be detected if the certificate is properly validated.",
		Lang:                "en",
	},
	"6": {
		CweID:               "6",
		Name:                "J2EE Misconfiguration: Insufficient Session-ID Length",
		Description:         "The J2EE application is configured to use an insufficient session ID length.",
		ExtendedDescription: "If an attacker can guess or steal a session ID, then they may be able to take over the user's session (called session hijacking). The number of possible session IDs increases with increased session ID length, making it more difficult to guess or steal a session ID.",
		Lang:                "en",
	},
	"600": {
		CweID:               "600",
		Name:                "Uncaught Exception in Servlet",
		Description:         "The Servlet does not catch all exceptions, which may reveal sensitive debugging information.",
		ExtendedDescription: "When a Servlet throws an exception, the default error response the Servlet container sends back to the user typically includes debugging information. This information is of great value to an attacker. For example, a stack trace might show the attacker a malformed SQL query string, the type of database being used, and the version of the application container. This information enables the attacker to target known vulnerabilities in these components.",
		Lang:                "en",
	},
	"601": {
		CweID:               "601",
		Name:                "URL Redirection to Untrusted Site ('Open Redirect')",
		Description:         "A web application accepts a user-controlled input that specifies a link to an external site, and uses that link in a Redirect. This simplifies phishing attacks.",
		ExtendedDescription: "An http parameter may contain a URL value and could cause the web application to redirect the request to the specified URL. By modifying the URL value to a malicious site, an attacker may successfully launch a phishing scam and steal user credentials. Because the server name in the modified link is identical to the original site, phishing attempts have a more trustworthy appearance.",
		Lang:                "en",
	},
	"602": {
		CweID:               "602",
		Name:                "Client-Side Enforcement of Server-Side Security",
		Description:         "The software is composed of a server that relies on the client to implement a mechanism that is intended to protect the server.",
		ExtendedDescription: "When the server relies on protection mechanisms placed on the client side, an attacker can modify the client-side behavior to bypass the protection mechanisms resulting in potentially unexpected interactions between the client and server. The consequences will vary, depending on what the mechanisms are trying to protect.",
		Lang:                "en",
	},
	"603": {
		CweID:               "603",
		Name:                "Use of Client-Side Authentication",
		Description:         "A client/server product performs authentication within client code but not in server code, allowing server-side authentication to be bypassed via a modified client that omits the authentication check.",
		ExtendedDescription: "Client-side authentication is extremely weak and may be breached easily. Any attacker may read the source code and reverse-engineer the authentication mechanism to access parts of the application which would otherwise be protected.",
		Lang:                "en",
	},
	"605": {
		CweID:               "605",
		Name:                "Multiple Binds to the Same Port",
		Description:         "When multiple sockets are allowed to bind to the same port, other services on that port may be stolen or spoofed.",
		ExtendedDescription: "On most systems, a combination of setting the SO_REUSEADDR socket option, and a call to bind() allows any process to bind to a port to which a previous process has bound with INADDR_ANY. This allows a user to bind to the specific address of a server bound to INADDR_ANY on an unprivileged port, and steal its UDP packets/TCP connection.",
		Lang:                "en",
	},
	"606": {
		CweID:               "606",
		Name:                "Unchecked Input for Loop Condition",
		Description:         "The product does not properly check inputs that are used for loop conditions, potentially leading to a denial of service because of excessive looping.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"607": {
		CweID:               "607",
		Name:                "Public Static Final Field References Mutable Object",
		Description:         "A public or protected static final field references a mutable object, which allows the object to be changed by malicious code, or accidentally from another package.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"608": {
		CweID:               "608",
		Name:                "Struts: Non-private Field in ActionForm Class",
		Description:         "An ActionForm class contains a field that has not been declared private, which can be accessed without using a setter or getter.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"609": {
		CweID:               "609",
		Name:                "Double-Checked Locking",
		Description:         "The program uses double-checked locking to access a resource without the overhead of explicit synchronization, but the locking is insufficient.",
		ExtendedDescription: "Double-checked locking refers to the situation where a programmer checks to see if a resource has been initialized, grabs a lock, checks again to see if the resource has been initialized, and then performs the initialization if it has not occurred yet. This should not be done, as is not guaranteed to work in all languages and on all architectures. In summary, other threads may not be operating inside the synchronous block and are not guaranteed to see the operations execute in the same order as they would appear inside the synchronous block.",
		Lang:                "en",
	},
	"61": {
		CweID:               "61",
		Name:                "UNIX Symbolic Link (Symlink) Following",
		Description:         "The software, when opening a file or directory, does not sufficiently account for when the file is a symbolic link that resolves to a target outside of the intended control sphere. This could allow an attacker to cause the software to operate on unauthorized files.",
		ExtendedDescription: "A software system that allows UNIX symbolic links (symlink) as part of paths whether in internal code or through user input can allow an attacker to spoof the symbolic link and traverse the file system to unintended locations or access arbitrary files. The symbolic link can permit an attacker to read/write/corrupt a file that they originally did not have permissions to access.",
		Lang:                "en",
	},
	"610": {
		CweID:               "610",
		Name:                "Externally Controlled Reference to a Resource in Another Sphere",
		Description:         "The product uses an externally controlled name or reference that resolves to a resource that is outside of the intended control sphere.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"611": {
		CweID:               "611",
		Name:                "Improper Restriction of XML External Entity Reference ('XXE')",
		Description:         "The software processes an XML document that can contain XML entities with URIs that resolve to documents outside of the intended sphere of control, causing the product to embed incorrect documents into its output.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"612": {
		CweID:               "612",
		Name:                "Information Exposure Through Indexing of Private Data",
		Description:         "The product performs an indexing routine against private documents, but does not sufficiently verify that the actors who can access the index also have the privileges to access the private documents.",
		ExtendedDescription: "When an indexing routine is applied against a group of private documents, and that index's results are available to outsiders who do not have access to those documents, then outsiders might be able to obtain sensitive information by conducting targeted searches. The risk is especially dangerous if search results include surrounding text that was not part of the search query. This issue can appear in search engines that are not configured (or implemented) to ignore critical files that should remain hidden; even without permissions to download these files directly, the remote user could read them.",
		Lang:                "en",
	},
	"613": {
		CweID:               "613",
		Name:                "Insufficient Session Expiration",
		Description:         "According to WASC, 'Insufficient Session Expiration is when a web site permits an attacker to reuse old session credentials or session IDs for authorization.'",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"614": {
		CweID:               "614",
		Name:                "Sensitive Cookie in HTTPS Session Without 'Secure' Attribute",
		Description:         "The Secure attribute for sensitive cookies in HTTPS sessions is not set, which could cause the user agent to send those cookies in plaintext over an HTTP session.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"615": {
		CweID:               "615",
		Name:                "Information Exposure Through Comments",
		Description:         "While adding general comments is very useful, some programmers tend to leave important data, such as: filenames related to the web application, old links or links which were not meant to be browsed by users, old code fragments, etc.",
		ExtendedDescription: "An attacker who finds these comments can map the application's structure and files, expose hidden parts of the site, and study the fragments of code to reverse engineer the application, which may help develop further attacks against the site.",
		Lang:                "en",
	},
	"616": {
		CweID:               "616",
		Name:                "Incomplete Identification of Uploaded File Variables (PHP)",
		Description:         "The PHP application uses an old method for processing uploaded files by referencing the four global variables that are set for each file (e.g. $varname, $varname_size, $varname_name, $varname_type). These variables could be overwritten by attackers, causing the application to process unauthorized files.",
		ExtendedDescription: "These global variables could be overwritten by POST requests, cookies, or other methods of populating or overwriting these variables. This could be used to read or process arbitrary files by providing values such as '/etc/passwd'.",
		Lang:                "en",
	},
	"617": {
		CweID:               "617",
		Name:                "Reachable Assertion",
		Description:         "The product contains an assert() or similar statement that can be triggered by an attacker, which leads to an application exit or other behavior that is more severe than necessary.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"618": {
		CweID:               "618",
		Name:                "Exposed Unsafe ActiveX Method",
		Description:         "An ActiveX control is intended for use in a web browser, but it exposes dangerous methods that perform actions that are outside of the browser's security model (e.g. the zone or domain).",
		ExtendedDescription: "ActiveX controls can exercise far greater control over the operating system than typical Java or javascript. Exposed methods can be subject to various vulnerabilities, depending on the implemented behaviors of those methods, and whether input validation is performed on the provided arguments. If there is no integrity checking or origin validation, this method could be invoked by attackers.",
		Lang:                "en",
	},
	"619": {
		CweID:               "619",
		Name:                "Dangling Database Cursor ('Cursor Injection')",
		Description:         "If a database cursor is not closed properly, then it could become accessible to other users while retaining the same privileges that were originally assigned, leaving the cursor 'dangling.'",
		ExtendedDescription: "For example, an improper dangling cursor could arise from unhandled exceptions. The impact of the issue depends on the cursor's role, but SQL injection attacks are commonly possible.",
		Lang:                "en",
	},
	"62": {
		CweID:               "62",
		Name:                "UNIX Hard Link",
		Description:         "The software, when opening a file or directory, does not sufficiently account for when the name is associated with a hard link to a target that is outside of the intended control sphere. This could allow an attacker to cause the software to operate on unauthorized files.",
		ExtendedDescription: "Failure for a system to check for hard links can result in vulnerability to different types of attacks. For example, an attacker can escalate their privileges if a file used by a privileged program is replaced with a hard link to a sensitive file (e.g. /etc/passwd). When the process opens the file, the attacker can assume the privileges of that process.",
		Lang:                "en",
	},
	"620": {
		CweID:               "620",
		Name:                "Unverified Password Change",
		Description:         "When setting a new password for a user, the product does not require knowledge of the original password, or using another form of authentication.",
		ExtendedDescription: "This could be used by an attacker to change passwords for another user, thus gaining the privileges associated with that user.",
		Lang:                "en",
	},
	"621": {
		CweID:               "621",
		Name:                "Variable Extraction Error",
		Description:         "The product uses external input to determine the names of variables into which information is extracted, without verifying that the names of the specified variables are valid. This could cause the program to overwrite unintended variables.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"622": {
		CweID:               "622",
		Name:                "Improper Validation of Function Hook Arguments",
		Description:         "A product adds hooks to user-accessible API functions, but does not properly validate the arguments. This could lead to resultant vulnerabilities.",
		ExtendedDescription: "Such hooks can be used in defensive software that runs with privileges, such as anti-virus or firewall, which hooks kernel calls. When the arguments are not validated, they could be used to bypass the protection scheme or attack the product itself.",
		Lang:                "en",
	},
	"623": {
		CweID:               "623",
		Name:                "Unsafe ActiveX Control Marked Safe For Scripting",
		Description:         "An ActiveX control is intended for restricted use, but it has been marked as safe-for-scripting.",
		ExtendedDescription: "This might allow attackers to use dangerous functionality via a web page that accesses the control, which can lead to different resultant vulnerabilities, depending on the control's behavior.",
		Lang:                "en",
	},
	"624": {
		CweID:               "624",
		Name:                "Executable Regular Expression Error",
		Description:         "The product uses a regular expression that either (1) contains an executable component with user-controlled inputs, or (2) allows a user to enable execution by inserting pattern modifiers.",
		ExtendedDescription: "Case (2) is possible in the PHP preg_replace() function, and possibly in other languages when a user-controlled input is inserted into a string that is later parsed as a regular expression.",
		Lang:                "en",
	},
	"625": {
		CweID:               "625",
		Name:                "Permissive Regular Expression",
		Description:         "The product uses a regular expression that does not sufficiently restrict the set of allowed values.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"626": {
		CweID:               "626",
		Name:                "Null Byte Interaction Error (Poison Null Byte)",
		Description:         "The product does not properly handle null bytes or NUL characters when passing data between different representations or components.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"627": {
		CweID:               "627",
		Name:                "Dynamic Variable Evaluation",
		Description:         "In a language where the user can influence the name of a variable at runtime, if the variable names are not controlled, an attacker can read or write to arbitrary variables, or access arbitrary functions.",
		ExtendedDescription: "The resultant vulnerabilities depend on the behavior of the application, both at the crossover point and in any control/data flow that is reachable by the related variables or functions.",
		Lang:                "en",
	},
	"628": {
		CweID:               "628",
		Name:                "Function Call with Incorrectly Specified Arguments",
		Description:         "The product calls a function, procedure, or routine with arguments that are not correctly specified, leading to always-incorrect behavior and resultant weaknesses.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"636": {
		CweID:               "636",
		Name:                "Not Failing Securely ('Failing Open')",
		Description:         "When the product encounters an error condition or failure, its design requires it to fall back to a state that is less secure than other options that are available, such as selecting the weakest encryption algorithm or using the most permissive access control restrictions.",
		ExtendedDescription: "By entering a less secure state, the product inherits the weaknesses associated with that state, making it easier to compromise. At the least, it causes administrators to have a false sense of security. This weakness typically occurs as a result of wanting to 'fail functional' to minimize administration and support costs, instead of 'failing safe.'",
		Lang:                "en",
	},
	"637": {
		CweID:               "637",
		Name:                "Unnecessary Complexity in Protection Mechanism (Not Using 'Economy of Mechanism')",
		Description:         "The software uses a more complex mechanism than necessary, which could lead to resultant weaknesses when the mechanism is not correctly understood, modeled, configured, implemented, or used.",
		ExtendedDescription: "Security mechanisms should be as simple as possible. Complex security mechanisms may engender partial implementations and compatibility problems, with resulting mismatches in assumptions and implemented security. A corollary of this principle is that data specifications should be as simple as possible, because complex data specifications result in complex validation code. Complex tasks and systems may also need to be guarded by complex security checks, so simple systems should be preferred.",
		Lang:                "en",
	},
	"638": {
		CweID:               "638",
		Name:                "Not Using Complete Mediation",
		Description:         "The software does not perform access checks on a resource every time the resource is accessed by an entity, which can create resultant weaknesses if that entity's rights or privileges change over time.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"639": {
		CweID:               "639",
		Name:                "Authorization Bypass Through User-Controlled Key",
		Description:         "The system's authorization functionality does not prevent one user from gaining access to another user's data or record by modifying the key value identifying the data.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"64": {
		CweID:               "64",
		Name:                "Windows Shortcut Following (.LNK)",
		Description:         "The software, when opening a file or directory, does not sufficiently handle when the file is a Windows shortcut (.LNK) whose target is outside of the intended control sphere. This could allow an attacker to cause the software to operate on unauthorized files.",
		ExtendedDescription: "The shortcut (file with the .lnk extension) can permit an attacker to read/write a file that they originally did not have permissions to access.",
		Lang:                "en",
	},
	"640": {
		CweID:               "640",
		Name:                "Weak Password Recovery Mechanism for Forgotten Password",
		Description:         "The software contains a mechanism for users to recover or change their passwords without knowing the original password, but the mechanism is weak.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"641": {
		CweID:               "641",
		Name:                "Improper Restriction of Names for Files and Other Resources",
		Description:         "The application constructs the name of a file or other resource using input from an upstream component, but it does not restrict or incorrectly restricts the resulting name.",
		ExtendedDescription: "This may produce resultant weaknesses. For instance, if the names of these resources contain scripting characters, it is possible that a script may get executed in the client's browser if the application ever displays the name of the resource on a dynamically generated web page. Alternately, if the resources are consumed by some application parser, a specially crafted name can exploit some vulnerability internal to the parser, potentially resulting in execution of arbitrary code on the server machine. The problems will vary based on the context of usage of such malformed resource names and whether vulnerabilities are present in or assumptions are made by the targeted technology that would make code execution possible.",
		Lang:                "en",
	},
	"642": {
		CweID:               "642",
		Name:                "External Control of Critical State Data",
		Description:         "The software stores security-critical state information about its users, or the software itself, in a location that is accessible to unauthorized actors.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"643": {
		CweID:               "643",
		Name:                "Improper Neutralization of Data within XPath Expressions ('XPath Injection')",
		Description:         "The software uses external input to dynamically construct an XPath expression used to retrieve data from an XML database, but it does not neutralize or incorrectly neutralizes that input. This allows an attacker to control the structure of the query.",
		ExtendedDescription: "The net effect is that the attacker will have control over the information selected from the XML database and may use that ability to control application flow, modify logic, retrieve unauthorized data, or bypass important checks (e.g. authentication).",
		Lang:                "en",
	},
	"644": {
		CweID:               "644",
		Name:                "Improper Neutralization of HTTP Headers for Scripting Syntax",
		Description:         "The application does not neutralize or incorrectly neutralizes web scripting syntax in HTTP headers that can be used by web browser components that can process raw headers, such as Flash.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"645": {
		CweID:               "645",
		Name:                "Overly Restrictive Account Lockout Mechanism",
		Description:         "The software contains an account lockout protection mechanism, but the mechanism is too restrictive and can be triggered too easily, which allows attackers to deny service to legitimate users by causing their accounts to be locked out.",
		ExtendedDescription: "Account lockout is a security feature often present in applications as a countermeasure to the brute force attack on the password based authentication mechanism of the system. After a certain number of failed login attempts, the users' account may be disabled for a certain period of time or until it is unlocked by an administrator. Other security events may also possibly trigger account lockout. However, an attacker may use this very security feature to deny service to legitimate system users. It is therefore important to ensure that the account lockout security mechanism is not overly restrictive.",
		Lang:                "en",
	},
	"646": {
		CweID:               "646",
		Name:                "Reliance on File Name or Extension of Externally-Supplied File",
		Description:         "The software allows a file to be uploaded, but it relies on the file name or extension of the file to determine the appropriate behaviors. This could be used by attackers to cause the file to be misclassified and processed in a dangerous fashion.",
		ExtendedDescription: "An application might use the file name or extension of of a user-supplied file to determine the proper course of action, such as selecting the correct process to which control should be passed, deciding what data should be made available, or what resources should be allocated. If the attacker can cause the code to misclassify the supplied file, then the wrong action could occur. For example, an attacker could supply a file that ends in a '.php.gif' extension that appears to be a GIF image, but would be processed as PHP code. In extreme cases, code execution is possible, but the attacker could also cause exhaustion of resources, denial of service, exposure of debug or system data (including application source code), or being bound to a particular server side process. This weakness may be due to a vulnerability in any of the technologies used by the web and application servers, due to misconfiguration, or resultant from another flaw in the application itself.",
		Lang:                "en",
	},
	"647": {
		CweID:               "647",
		Name:                "Use of Non-Canonical URL Paths for Authorization Decisions",
		Description:         "The software defines policy namespaces and makes authorization decisions based on the assumption that a URL is canonical. This can allow a non-canonical URL to bypass the authorization.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"648": {
		CweID:               "648",
		Name:                "Incorrect Use of Privileged APIs",
		Description:         "The application does not conform to the API requirements for a function call that requires extra privileges. This could allow attackers to gain privileges by causing the function to be called incorrectly.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"649": {
		CweID:               "649",
		Name:                "Reliance on Obfuscation or Encryption of Security-Relevant Inputs without Integrity Checking",
		Description:         "The software uses obfuscation or encryption of inputs that should not be mutable by an external actor, but the software does not use integrity checks to detect if those inputs have been modified.",
		ExtendedDescription: "When an application relies on obfuscation or incorrectly applied / weak encryption to protect client-controllable tokens or parameters, that may have an effect on the user state, system state, or some decision made on the server. Without protecting the tokens/parameters for integrity, the application is vulnerable to an attack where an adversary blindly traverses the space of possible values of the said token/parameter in order to attempt to gain an advantage. The goal of the attacker is to find another admissible value that will somehow elevate their privileges in the system, disclose information or change the behavior of the system in some way beneficial to the attacker. If the application does not protect these critical tokens/parameters for integrity, it will not be able to determine that these values have been tampered with. Measures that are used to protect data for confidentiality should not be relied upon to provide the integrity service.",
		Lang:                "en",
	},
	"65": {
		CweID:               "65",
		Name:                "Windows Hard Link",
		Description:         "The software, when opening a file or directory, does not sufficiently handle when the name is associated with a hard link to a target that is outside of the intended control sphere. This could allow an attacker to cause the software to operate on unauthorized files.",
		ExtendedDescription: "Failure for a system to check for hard links can result in vulnerability to different types of attacks. For example, an attacker can escalate their privileges if a file used by a privileged program is replaced with a hard link to a sensitive file (e.g. AUTOEXEC.BAT). When the process opens the file, the attacker can assume the privileges of that process, or prevent the program from accurately processing data.",
		Lang:                "en",
	},
	"650": {
		CweID:               "650",
		Name:                "Trusting HTTP Permission Methods on the Server Side",
		Description:         "The server contains a protection mechanism that assumes that any URI that is accessed using HTTP GET will not cause a state change to the associated resource. This might allow attackers to bypass intended access restrictions and conduct resource modification and deletion attacks, since some applications allow GET to modify state.",
		ExtendedDescription: "The HTTP GET method and some other methods are designed to retrieve resources and not to alter the state of the application or resources on the server side. Furthermore, the HTTP specification requires that GET requests (and other requests) should not have side effects. Believing that it will be enough to prevent unintended resource alterations, an application may disallow the HTTP requests to perform DELETE, PUT and POST operations on the resource representation. However, there is nothing in the HTTP protocol itself that actually prevents the HTTP GET method from performing more than just query of the data. Developers can easily code programs that accept a HTTP GET request that do in fact create, update or delete data on the server. For instance, it is a common practice with REST based Web Services to have HTTP GET requests modifying resources on the server side. However, whenever that happens, the access control needs to be properly enforced in the application. No assumptions should be made that only HTTP DELETE, PUT, POST, and other methods have the power to alter the representation of the resource being accessed in the request.",
		Lang:                "en",
	},
	"651": {
		CweID:               "651",
		Name:                "Information Exposure Through WSDL File",
		Description:         "The Web services architecture may require exposing a Web Service Definition Language (WSDL) file that contains information on the publicly accessible services and how callers of these services should interact with them (e.g. what parameters they expect and what types they return).",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"652": {
		CweID:               "652",
		Name:                "Improper Neutralization of Data within XQuery Expressions ('XQuery Injection')",
		Description:         "The software uses external input to dynamically construct an XQuery expression used to retrieve data from an XML database, but it does not neutralize or incorrectly neutralizes that input. This allows an attacker to control the structure of the query.",
		ExtendedDescription: "The net effect is that the attacker will have control over the information selected from the XML database and may use that ability to control application flow, modify logic, retrieve unauthorized data, or bypass important checks (e.g. authentication).",
		Lang:                "en",
	},
	"653": {
		CweID:               "653",
		Name:                "Insufficient Compartmentalization",
		Description:         "The product does not sufficiently compartmentalize functionality or processes that require different privilege levels, rights, or permissions.",
		ExtendedDescription: "When a weakness occurs in functionality that is accessible by lower-privileged users, then without strong boundaries, an attack might extend the scope of the damage to higher-privileged users.",
		Lang:                "en",
	},
	"654": {
		CweID:               "654",
		Name:                "Reliance on a Single Factor in a Security Decision",
		Description:         "A protection mechanism relies exclusively, or to a large extent, on the evaluation of a single condition or the integrity of a single object or entity in order to make a decision about granting access to restricted resources or functionality.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"655": {
		CweID:               "655",
		Name:                "Insufficient Psychological Acceptability",
		Description:         "The software has a protection mechanism that is too difficult or inconvenient to use, encouraging non-malicious users to disable or bypass the mechanism, whether by accident or on purpose.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"656": {
		CweID:               "656",
		Name:                "Reliance on Security Through Obscurity",
		Description:         "The software uses a protection mechanism whose strength depends heavily on its obscurity, such that knowledge of its algorithms or key data is sufficient to defeat the mechanism.",
		ExtendedDescription: "This reliance on 'security through obscurity' can produce resultant weaknesses if an attacker is able to reverse engineer the inner workings of the mechanism. Note that obscurity can be one small part of defense in depth, since it can create more work for an attacker; however, it is a significant risk if used as the primary means of protection.",
		Lang:                "en",
	},
	"657": {
		CweID:               "657",
		Name:                "Violation of Secure Design Principles",
		Description:         "The product violates well-established principles for secure design.",
		ExtendedDescription: "This can introduce resultant weaknesses or make it easier for developers to introduce related weaknesses during implementation. Because code is centered around design, it can be resource-intensive to fix design problems.",
		Lang:                "en",
	},
	"66": {
		CweID:               "66",
		Name:                "Improper Handling of File Names that Identify Virtual Resources",
		Description:         "The product does not handle or incorrectly handles a file name that identifies a 'virtual' resource that is not directly specified within the directory that is associated with the file name, causing the product to perform file-based operations on a resource that is not a file.",
		ExtendedDescription: "Virtual file names are represented like normal file names, but they are effectively aliases for other resources that do not behave like normal files. Depending on their functionality, they could be alternate entities. They are not necessarily listed in directories.",
		Lang:                "en",
	},
	"662": {
		CweID:               "662",
		Name:                "Improper Synchronization",
		Description:         "The software attempts to use a shared resource in an exclusive manner, but does not prevent or incorrectly prevents use of the resource by another thread or process.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"663": {
		CweID:               "663",
		Name:                "Use of a Non-reentrant Function in a Concurrent Context",
		Description:         "The software calls a non-reentrant function in a concurrent context in which a competing code sequence (e.g. thread or signal handler) may have an opportunity to call the same function or otherwise influence its state.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"664": {
		CweID:               "664",
		Name:                "Improper Control of a Resource Through its Lifetime",
		Description:         "The software does not maintain or incorrectly maintains control over a resource throughout its lifetime of creation, use, and release.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"665": {
		CweID:               "665",
		Name:                "Improper Initialization",
		Description:         "The software does not initialize or incorrectly initializes a resource, which might leave the resource in an unexpected state when it is accessed or used.",
		ExtendedDescription: "This can have security implications when the associated resource is expected to have certain properties or values, such as a variable that determines whether a user has been authenticated or not.",
		Lang:                "en",
	},
	"666": {
		CweID:               "666",
		Name:                "Operation on Resource in Wrong Phase of Lifetime",
		Description:         "The software performs an operation on a resource at the wrong phase of the resource's lifecycle, which can lead to unexpected behaviors.",
		ExtendedDescription: "When a developer wants to initialize, use or release a resource, it is important to follow the specifications outlined for how to operate on that resource and to ensure that the resource is in the expected state. In this case, the software wants to perform a normally valid operation, initialization, use or release, on a resource when it is in the incorrect phase of its lifetime.",
		Lang:                "en",
	},
	"667": {
		CweID:               "667",
		Name:                "Improper Locking",
		Description:         "The software does not properly acquire a lock on a resource, or it does not properly release a lock on a resource, leading to unexpected resource state changes and behaviors.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"668": {
		CweID:               "668",
		Name:                "Exposure of Resource to Wrong Sphere",
		Description:         "The product exposes a resource to the wrong control sphere, providing unintended actors with inappropriate access to the resource.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"669": {
		CweID:               "669",
		Name:                "Incorrect Resource Transfer Between Spheres",
		Description:         "The product does not properly transfer a resource/behavior to another sphere, or improperly imports a resource/behavior from another sphere, in a manner that provides unintended control over that resource.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"67": {
		CweID:               "67",
		Name:                "Improper Handling of Windows Device Names",
		Description:         "The software constructs pathnames from user input, but it does not handle or incorrectly handles a pathname containing a Windows device name such as AUX or CON. This typically leads to denial of service or an information exposure when the application attempts to process the pathname as a regular file.",
		ExtendedDescription: "Not properly handling virtual filenames (e.g. AUX, CON, PRN, COM1, LPT1) can result in different types of vulnerabilities. In some cases an attacker can request a device via injection of a virtual filename in a URL, which may cause an error that leads to a denial of service or an error page that reveals sensitive information. A software system that allows device names to bypass filtering runs the risk of an attacker injecting malicious code in a file with the name of a device.",
		Lang:                "en",
	},
	"670": {
		CweID:               "670",
		Name:                "Always-Incorrect Control Flow Implementation",
		Description:         "The code contains a control flow path that does not reflect the algorithm that the path is intended to implement, leading to incorrect behavior any time this path is navigated.",
		ExtendedDescription: "This weakness captures cases in which a particular code segment is always incorrect with respect to the algorithm that it is implementing. For example, if a C programmer intends to include multiple statements in a single block but does not include the enclosing braces (CWE-483), then the logic is always incorrect. This issue is in contrast to most weaknesses in which the code usually behaves correctly, except when it is externally manipulated in malicious ways.",
		Lang:                "en",
	},
	"671": {
		CweID:               "671",
		Name:                "Lack of Administrator Control over Security",
		Description:         "The product uses security features in a way that prevents the product's administrator from tailoring security settings to reflect the environment in which the product is being used. This introduces resultant weaknesses or prevents it from operating at a level of security that is desired by the administrator.",
		ExtendedDescription: "If the product's administrator does not have the ability to manage security-related decisions at all times, then protecting the product from outside threats - including the product's developer - can become impossible. For example, a hard-coded account name and password cannot be changed by the administrator, thus exposing that product to attacks that the administrator can not prevent.",
		Lang:                "en",
	},
	"672": {
		CweID:               "672",
		Name:                "Operation on a Resource after Expiration or Release",
		Description:         "The software uses, accesses, or otherwise operates on a resource after that resource has been expired, released, or revoked.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"673": {
		CweID:               "673",
		Name:                "External Influence of Sphere Definition",
		Description:         "The product does not prevent the definition of control spheres from external actors.",
		ExtendedDescription: "Typically, a product defines its control sphere within the code itself, or through configuration by the product's administrator. In some cases, an external party can change the definition of the control sphere. This is typically a resultant weakness.",
		Lang:                "en",
	},
	"674": {
		CweID:               "674",
		Name:                "Uncontrolled Recursion",
		Description:         "The product does not properly control the amount of recursion that takes place, which consumes excessive resources, such as allocated memory or the program stack.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"675": {
		CweID:               "675",
		Name:                "Duplicate Operations on Resource",
		Description:         "The product performs the same operation on a resource two or more times, when the operation should only be applied once.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"676": {
		CweID:               "676",
		Name:                "Use of Potentially Dangerous Function",
		Description:         "The program invokes a potentially dangerous function that could introduce a vulnerability if it is used incorrectly, but the function can also be used safely.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"680": {
		CweID:               "680",
		Name:                "Integer Overflow to Buffer Overflow",
		Description:         "The product performs a calculation to determine how much memory to allocate, but an integer overflow can occur that causes less memory to be allocated than expected, leading to a buffer overflow.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"681": {
		CweID:               "681",
		Name:                "Incorrect Conversion between Numeric Types",
		Description:         "When converting from one data type to another, such as long to integer, data can be omitted or translated in a way that produces unexpected values. If the resulting values are used in a sensitive context, then dangerous behaviors may occur.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"682": {
		CweID:               "682",
		Name:                "Incorrect Calculation",
		Description:         "The software performs a calculation that generates incorrect or unintended results that are later used in security-critical decisions or resource management.",
		ExtendedDescription: "When software performs a security-critical calculation incorrectly, it might lead to incorrect resource allocations, incorrect privilege assignments, or failed comparisons among other things. Many of the direct results of an incorrect calculation can lead to even larger problems such as failed protection mechanisms or even arbitrary code execution.",
		Lang:                "en",
	},
	"683": {
		CweID:               "683",
		Name:                "Function Call With Incorrect Order of Arguments",
		Description:         "The software calls a function, procedure, or routine, but the caller specifies the arguments in an incorrect order, leading to resultant weaknesses.",
		ExtendedDescription: "While this weakness might be caught by the compiler in some languages, it can occur more frequently in cases in which the called function accepts variable numbers or types of arguments, such as format strings in C. It also can occur in languages or environments that do not enforce strong typing.",
		Lang:                "en",
	},
	"684": {
		CweID:               "684",
		Name:                "Incorrect Provision of Specified Functionality",
		Description:         "The code does not function according to its published specifications, potentially leading to incorrect usage.",
		ExtendedDescription: "When providing functionality to an external party, it is important that the software behaves in accordance with the details specified. When requirements of nuances are not documented, the functionality may produce unintended behaviors for the caller, possibly leading to an exploitable state.",
		Lang:                "en",
	},
	"685": {
		CweID:               "685",
		Name:                "Function Call With Incorrect Number of Arguments",
		Description:         "The software calls a function, procedure, or routine, but the caller specifies too many arguments, or too few arguments, which may lead to undefined behavior and resultant weaknesses.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"686": {
		CweID:               "686",
		Name:                "Function Call With Incorrect Argument Type",
		Description:         "The software calls a function, procedure, or routine, but the caller specifies an argument that is the wrong data type, which may lead to resultant weaknesses.",
		ExtendedDescription: "This weakness is most likely to occur in loosely typed languages, or in strongly typed languages in which the types of variable arguments cannot be enforced at compilation time, or where there is implicit casting.",
		Lang:                "en",
	},
	"687": {
		CweID:               "687",
		Name:                "Function Call With Incorrectly Specified Argument Value",
		Description:         "The software calls a function, procedure, or routine, but the caller specifies an argument that contains the wrong value, which may lead to resultant weaknesses.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"688": {
		CweID:               "688",
		Name:                "Function Call With Incorrect Variable or Reference as Argument",
		Description:         "The software calls a function, procedure, or routine, but the caller specifies the wrong variable or reference as one of the arguments, which may lead to undefined behavior and resultant weaknesses.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"689": {
		CweID:               "689",
		Name:                "Permission Race Condition During Resource Copy",
		Description:         "The product, while copying or cloning a resource, does not set the resource's permissions or access control until the copy is complete, leaving the resource exposed to other spheres while the copy is taking place.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"69": {
		CweID:               "69",
		Name:                "Improper Handling of Windows ::DATA Alternate Data Stream",
		Description:         "The software does not properly prevent access to, or detect usage of, alternate data streams (ADS).",
		ExtendedDescription: "An attacker can use an ADS to hide information about a file (e.g. size, the name of the process) from a system or file browser tools such as Windows Explorer and 'dir' at the command line utility. Alternately, the attacker might be able to bypass intended access restrictions for the associated data fork.",
		Lang:                "en",
	},
	"690": {
		CweID:               "690",
		Name:                "Unchecked Return Value to NULL Pointer Dereference",
		Description:         "The product does not check for an error after calling a function that can return with a NULL pointer if the function fails, which leads to a resultant NULL pointer dereference.",
		ExtendedDescription: "While unchecked return value weaknesses are not limited to returns of NULL pointers (see the examples in CWE-252), functions often return NULL to indicate an error status. When this error condition is not checked, a NULL pointer dereference can occur.",
		Lang:                "en",
	},
	"691": {
		CweID:               "691",
		Name:                "Insufficient Control Flow Management",
		Description:         "The code does not sufficiently manage its control flow during execution, creating conditions in which the control flow can be modified in unexpected ways.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"692": {
		CweID:               "692",
		Name:                "Incomplete Blacklist to Cross-Site Scripting",
		Description:         "The product uses a blacklist-based protection mechanism to defend against XSS attacks, but the blacklist is incomplete, allowing XSS variants to succeed.",
		ExtendedDescription: "While XSS might seem simple to prevent, web browsers vary so widely in how they parse web pages, that a blacklist cannot keep track of all the variations. The 'XSS Cheat Sheet' [REF-564] contains a large number of attacks that are intended to bypass incomplete blacklists.",
		Lang:                "en",
	},
	"693": {
		CweID:               "693",
		Name:                "Protection Mechanism Failure",
		Description:         "The product does not use or incorrectly uses a protection mechanism that provides sufficient defense against directed attacks against the product.",
		ExtendedDescription: "This weakness covers three distinct situations. A 'missing' protection mechanism occurs when the application does not define any mechanism against a certain class of attack. An 'insufficient' protection mechanism might provide some defenses - for example, against the most common attacks - but it does not protect against everything that is intended. Finally, an 'ignored' mechanism occurs when a mechanism is available and in active use within the product, but the developer has not applied it in some code path.",
		Lang:                "en",
	},
	"694": {
		CweID:               "694",
		Name:                "Use of Multiple Resources with Duplicate Identifier",
		Description:         "The software uses multiple resources that can have the same identifier, in a context in which unique identifiers are required.",
		ExtendedDescription: "If the software assumes that each resource has a unique identifier, the software could operate on the wrong resource if attackers can cause multiple resources to be associated with the same identifier.",
		Lang:                "en",
	},
	"695": {
		CweID:               "695",
		Name:                "Use of Low-Level Functionality",
		Description:         "The software uses low-level functionality that is explicitly prohibited by the framework or specification under which the software is supposed to operate.",
		ExtendedDescription: "The use of low-level functionality can violate the specification in unexpected ways that effectively disable built-in protection mechanisms, introduce exploitable inconsistencies, or otherwise expose the functionality to attack.",
		Lang:                "en",
	},
	"696": {
		CweID:               "696",
		Name:                "Incorrect Behavior Order",
		Description:         "The software performs multiple related behaviors, but the behaviors are performed in the wrong order in ways which may produce resultant weaknesses.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"697": {
		CweID:               "697",
		Name:                "Insufficient Comparison",
		Description:         "The software compares two entities in a security-relevant context, but the comparison is insufficient, which may lead to resultant weaknesses.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"698": {
		CweID:               "698",
		Name:                "Execution After Redirect (EAR)",
		Description:         "The web application sends a redirect to another location, but instead of exiting, it executes additional code.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"7": {
		CweID:               "7",
		Name:                "J2EE Misconfiguration: Missing Custom Error Page",
		Description:         "The default error page of a web application should not display sensitive information about the software system.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"703": {
		CweID:               "703",
		Name:                "Improper Check or Handling of Exceptional Conditions",
		Description:         "The software does not properly anticipate or handle exceptional conditions that rarely occur during normal operation of the software.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"704": {
		CweID:               "704",
		Name:                "Incorrect Type Conversion or Cast",
		Description:         "The software does not correctly convert an object, resource or structure from one type to a different type.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"705": {
		CweID:               "705",
		Name:                "Incorrect Control Flow Scoping",
		Description:         "The software does not properly return control flow to the proper location after it has completed a task or detected an unusual condition.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"706": {
		CweID:               "706",
		Name:                "Use of Incorrectly-Resolved Name or Reference",
		Description:         "The software uses a name or reference to access a resource, but the name/reference resolves to a resource that is outside of the intended control sphere.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"707": {
		CweID:               "707",
		Name:                "Improper Enforcement of Message or Data Structure",
		Description:         "The software does not enforce or incorrectly enforces that structured messages or data are well-formed before being read from an upstream component or sent to a downstream component.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"708": {
		CweID:               "708",
		Name:                "Incorrect Ownership Assignment",
		Description:         "The software assigns an owner to a resource, but the owner is outside of the intended control sphere.",
		ExtendedDescription: "This may allow the resource to be manipulated by actors outside of the intended control sphere.",
		Lang:                "en",
	},
	"71": {
		CweID:               "71",
		Name:                "DEPRECATED: Apple '.DS_Store'",
		Description:         "This entry has been deprecated as it represents a specific observed example of a UNIX Hard Link weakness type rather than its own individual weakness type. Please refer to CWE-62.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"710": {
		CweID:               "710",
		Name:                "Improper Adherence to Coding Standards",
		Description:         "The software does not follow certain coding rules for development, which can lead to resultant weaknesses or increase the severity of the associated vulnerabilities.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"72": {
		CweID:               "72",
		Name:                "Improper Handling of Apple HFS+ Alternate Data Stream Path",
		Description:         "The software does not properly handle special paths that may identify the data or resource fork of a file on the HFS+ file system.",
		ExtendedDescription: "If the software chooses actions to take based on the file name, then if an attacker provides the data or resource fork, the software may take unexpected actions. Further, if the software intends to restrict access to a file, then an attacker might still be able to bypass intended access restrictions by requesting the data or resource fork for that file.",
		Lang:                "en",
	},
	"73": {
		CweID:               "73",
		Name:                "External Control of File Name or Path",
		Description:         "The software allows user input to control or influence paths or file names that are used in filesystem operations.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"732": {
		CweID:               "732",
		Name:                "Incorrect Permission Assignment for Critical Resource",
		Description:         "The software specifies permissions for a security-critical resource in a way that allows that resource to be read or modified by unintended actors.",
		ExtendedDescription: "When a resource is given a permissions setting that provides access to a wider range of actors than required, it could lead to the exposure of sensitive information, or the modification of that resource by unintended parties. This is especially dangerous when the resource is related to program configuration, execution or sensitive user data.",
		Lang:                "en",
	},
	"733": {
		CweID:               "733",
		Name:                "Compiler Optimization Removal or Modification of Security-critical Code",
		Description:         "The developer builds a security-critical protection mechanism into the software but the compiler optimizes the program such that the mechanism is removed or modified.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"74": {
		CweID:               "74",
		Name:                "Improper Neutralization of Special Elements in Output Used by a Downstream Component ('Injection')",
		Description:         "The software constructs all or part of a command, data structure, or record using externally-influenced input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could modify how it is parsed or interpreted when it is sent to a downstream component.",
		ExtendedDescription: "Software has certain assumptions about what constitutes data and control respectively. It is the lack of verification of these assumptions for user-controlled input that leads to injection problems. Injection problems encompass a wide variety of issues -- all mitigated in very different ways and usually attempted in order to alter the control flow of the process. For this reason, the most effective way to discuss these weaknesses is to note the distinct features which classify them as injection weaknesses. The most important issue to note is that all injection problems share one thing in common -- i.e., they allow for the injection of control plane data into the user-controlled data plane. This means that the execution of the process may be altered by sending code in through legitimate data channels, using no other mechanism. While buffer overflows, and many other flaws, involve the use of some further issue to gain execution, injection problems need only for the data to be parsed. The most classic instantiations of this category of weakness are SQL injection and format string vulnerabilities.",
		Lang:                "en",
	},
	"749": {
		CweID:               "749",
		Name:                "Exposed Dangerous Method or Function",
		Description:         "The software provides an Applications Programming Interface (API) or similar interface for interaction with external actors, but the interface includes a dangerous method or function that is not properly restricted.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"75": {
		CweID:               "75",
		Name:                "Failure to Sanitize Special Elements into a Different Plane (Special Element Injection)",
		Description:         "The software does not adequately filter user-controlled input for special elements with control implications.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"754": {
		CweID:               "754",
		Name:                "Improper Check for Unusual or Exceptional Conditions",
		Description:         "The software does not check or improperly checks for unusual or exceptional conditions that are not expected to occur frequently during day to day operation of the software.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"755": {
		CweID:               "755",
		Name:                "Improper Handling of Exceptional Conditions",
		Description:         "The software does not handle or incorrectly handles an exceptional condition.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"756": {
		CweID:               "756",
		Name:                "Missing Custom Error Page",
		Description:         "The software does not return custom error pages to the user, possibly exposing sensitive information.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"757": {
		CweID:               "757",
		Name:                "Selection of Less-Secure Algorithm During Negotiation ('Algorithm Downgrade')",
		Description:         "A protocol or its implementation supports interaction between multiple actors and allows those actors to negotiate which algorithm should be used as a protection mechanism such as encryption or authentication, but it does not select the strongest algorithm that is available to both parties.",
		ExtendedDescription: "When a security mechanism can be forced to downgrade to use a less secure algorithm, this can make it easier for attackers to compromise the software by exploiting weaker algorithm. The victim might not be aware that the less secure algorithm is being used. For example, if an attacker can force a communications channel to use cleartext instead of strongly-encrypted data, then the attacker could read the channel by sniffing, instead of going through extra effort of trying to decrypt the data using brute force techniques.",
		Lang:                "en",
	},
	"758": {
		CweID:               "758",
		Name:                "Reliance on Undefined, Unspecified, or Implementation-Defined Behavior",
		Description:         "The software uses an API function, data structure, or other entity in a way that relies on properties that are not always guaranteed to hold for that entity.",
		ExtendedDescription: "This can lead to resultant weaknesses when the required properties change, such as when the software is ported to a different platform or if an interaction error (CWE-435) occurs.",
		Lang:                "en",
	},
	"759": {
		CweID:               "759",
		Name:                "Use of a One-Way Hash without a Salt",
		Description:         "The software uses a one-way cryptographic hash against an input that should not be reversible, such as a password, but the software does not also use a salt as part of the input.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"76": {
		CweID:               "76",
		Name:                "Improper Neutralization of Equivalent Special Elements",
		Description:         "The software properly neutralizes certain special elements, but it improperly neutralizes equivalent special elements.",
		ExtendedDescription: "The software may have a fixed list of special characters it believes is complete. However, there may be alternate encodings, or representations that also have the same meaning. For example, the software may filter out a leading slash (/) to prevent absolute path names, but does not account for a tilde (~) followed by a user name, which on some *nix systems could be expanded to an absolute pathname. Alternately, the software might filter a dangerous '-e' command-line switch when calling an external program, but it might not account for '--exec' or other switches that have the same semantics.",
		Lang:                "en",
	},
	"760": {
		CweID:               "760",
		Name:                "Use of a One-Way Hash with a Predictable Salt",
		Description:         "The software uses a one-way cryptographic hash against an input that should not be reversible, such as a password, but the software uses a predictable salt as part of the input.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"761": {
		CweID:               "761",
		Name:                "Free of Pointer not at Start of Buffer",
		Description:         "The application calls free() on a pointer to a memory resource that was allocated on the heap, but the pointer is not at the start of the buffer.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"762": {
		CweID:               "762",
		Name:                "Mismatched Memory Management Routines",
		Description:         "The application attempts to return a memory resource to the system, but it calls a release function that is not compatible with the function that was originally used to allocate that resource.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"763": {
		CweID:               "763",
		Name:                "Release of Invalid Pointer or Reference",
		Description:         "The application attempts to return a memory resource to the system, but calls the wrong release function or calls the appropriate release function incorrectly.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"764": {
		CweID:               "764",
		Name:                "Multiple Locks of a Critical Resource",
		Description:         "The software locks a critical resource more times than intended, leading to an unexpected state in the system.",
		ExtendedDescription: "When software is operating in a concurrent environment and repeatedly locks a critical resource, the consequences will vary based on the type of lock, the lock's implementation, and the resource being protected. In some situations such as with semaphores, the resources are pooled and extra locking calls will reduce the size of the total available pool, possibly leading to degraded performance or a denial of service. If this can be triggered by an attacker, it will be similar to an unrestricted lock (CWE-412). In the context of a binary lock, it is likely that any duplicate locking attempts will never succeed since the lock is already held and progress may not be possible.",
		Lang:                "en",
	},
	"765": {
		CweID:               "765",
		Name:                "Multiple Unlocks of a Critical Resource",
		Description:         "The software unlocks a critical resource more times than intended, leading to an unexpected state in the system.",
		ExtendedDescription: "When software is operating in a concurrent environment and repeatedly unlocks a critical resource, the consequences will vary based on the type of lock, the lock's implementation, and the resource being protected. In some situations such as with semaphores, the resources are pooled and extra calls to unlock will increase the count for the number of available resources, likely resulting in a crash or unpredictable behavior when the system nears capacity.",
		Lang:                "en",
	},
	"766": {
		CweID:               "766",
		Name:                "Critical Variable Declared Public",
		Description:         "The software declares a critical variable or field to be public when intended security policy requires it to be private.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"767": {
		CweID:               "767",
		Name:                "Access to Critical Private Variable via Public Method",
		Description:         "The software defines a public method that reads or modifies a private variable.",
		ExtendedDescription: "If an attacker modifies the variable to contain unexpected values, this could violate assumptions from other parts of the code. Additionally, if an attacker can read the private variable, it may expose sensitive information or make it easier to launch further attacks.",
		Lang:                "en",
	},
	"768": {
		CweID:               "768",
		Name:                "Incorrect Short Circuit Evaluation",
		Description:         "The software contains a conditional statement with multiple logical expressions in which one of the non-leading expressions may produce side effects. This may lead to an unexpected state in the program after the execution of the conditional, because short-circuiting logic may prevent the side effects from occurring.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"769": {
		CweID:               "769",
		Name:                "Uncontrolled File Descriptor Consumption",
		Description:         "The software does not properly limit the number of open file descriptors that it uses.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"77": {
		CweID:               "77",
		Name:                "Improper Neutralization of Special Elements used in a Command ('Command Injection')",
		Description:         "The software constructs all or part of a command using externally-influenced input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could modify the intended command when it is sent to a downstream component.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"770": {
		CweID:               "770",
		Name:                "Allocation of Resources Without Limits or Throttling",
		Description:         "The software allocates a reusable resource or group of resources on behalf of an actor without imposing any restrictions on how many resources can be allocated, in violation of the intended security policy for that actor.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"771": {
		CweID:               "771",
		Name:                "Missing Reference to Active Allocated Resource",
		Description:         "The software does not properly maintain a reference to a resource that has been allocated, which prevents the resource from being reclaimed.",
		ExtendedDescription: "This does not necessarily apply in languages or frameworks that automatically perform garbage collection, since the removal of all references may act as a signal that the resource is ready to be reclaimed.",
		Lang:                "en",
	},
	"772": {
		CweID:               "772",
		Name:                "Missing Release of Resource after Effective Lifetime",
		Description:         "The software does not release a resource after its effective lifetime has ended, i.e., after the resource is no longer needed.",
		ExtendedDescription: "When a resource is not released after use, it can allow attackers to cause a denial of service.",
		Lang:                "en",
	},
	"773": {
		CweID:               "773",
		Name:                "Missing Reference to Active File Descriptor or Handle",
		Description:         "The software does not properly maintain references to a file descriptor or handle, which prevents that file descriptor/handle from being reclaimed.",
		ExtendedDescription: "This can cause the software to consume all available file descriptors or handles, which can prevent other processes from performing critical file processing operations.",
		Lang:                "en",
	},
	"774": {
		CweID:               "774",
		Name:                "Allocation of File Descriptors or Handles Without Limits or Throttling",
		Description:         "The software allocates file descriptors or handles on behalf of an actor without imposing any restrictions on how many descriptors can be allocated, in violation of the intended security policy for that actor.",
		ExtendedDescription: "This can cause the software to consume all available file descriptors or handles, which can prevent other processes from performing critical file processing operations.",
		Lang:                "en",
	},
	"775": {
		CweID:               "775",
		Name:                "Missing Release of File Descriptor or Handle after Effective Lifetime",
		Description:         "The software does not release a file descriptor or handle after its effective lifetime has ended, i.e., after the file descriptor/handle is no longer needed.",
		ExtendedDescription: "When a file descriptor or handle is not released after use (typically by explicitly closing it), attackers can cause a denial of service by consuming all available file descriptors/handles, or otherwise preventing other system processes from obtaining their own file descriptors/handles.",
		Lang:                "en",
	},
	"776": {
		CweID:               "776",
		Name:                "Improper Restriction of Recursive Entity References in DTDs ('XML Entity Expansion')",
		Description:         "The software uses XML documents and allows their structure to be defined with a Document Type Definition (DTD), but it does not properly control the number of recursive definitions of entities.",
		ExtendedDescription: "If the DTD contains a large number of nested or recursive entities, this can lead to explosive growth of data when parsed, causing a denial of service.",
		Lang:                "en",
	},
	"777": {
		CweID:               "777",
		Name:                "Regular Expression without Anchors",
		Description:         "The software uses a regular expression to perform neutralization, but the regular expression is not anchored and may allow malicious or malformed data to slip through.",
		ExtendedDescription: "When performing tasks such as whitelist validation, data is examined and possibly modified to ensure that it is well-formed and adheres to a list of safe values. If the regular expression is not anchored, malicious or malformed data may be included before or after any string matching the regular expression. The type of malicious data that is allowed will depend on the context of the application and which anchors are omitted from the regular expression.",
		Lang:                "en",
	},
	"778": {
		CweID:               "778",
		Name:                "Insufficient Logging",
		Description:         "When a security-critical event occurs, the software either does not record the event or omits important details about the event when logging it.",
		ExtendedDescription: "When security-critical events are not logged properly, such as a failed login attempt, this can make malicious behavior more difficult to detect and may hinder forensic analysis after an attack succeeds.",
		Lang:                "en",
	},
	"779": {
		CweID:               "779",
		Name:                "Logging of Excessive Data",
		Description:         "The software logs too much information, making log files hard to process and possibly hindering recovery efforts or forensic analysis after an attack.",
		ExtendedDescription: "While logging is a good practice in general, and very high levels of logging are appropriate for debugging stages of development, too much logging in a production environment might hinder a system administrator's ability to detect anomalous conditions. This can provide cover for an attacker while attempting to penetrate a system, clutter the audit trail for forensic analysis, or make it more difficult to debug problems in a production environment.",
		Lang:                "en",
	},
	"78": {
		CweID:               "78",
		Name:                "Improper Neutralization of Special Elements used in an OS Command ('OS Command Injection')",
		Description:         "The software constructs all or part of an OS command using externally-influenced input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could modify the intended OS command when it is sent to a downstream component.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"780": {
		CweID:               "780",
		Name:                "Use of RSA Algorithm without OAEP",
		Description:         "The software uses the RSA algorithm but does not incorporate Optimal Asymmetric Encryption Padding (OAEP), which might weaken the encryption.",
		ExtendedDescription: "Padding schemes are often used with cryptographic algorithms to make the plaintext less predictable and complicate attack efforts. The OAEP scheme is often used with RSA to nullify the impact of predictable common text.",
		Lang:                "en",
	},
	"781": {
		CweID:               "781",
		Name:                "Improper Address Validation in IOCTL with METHOD_NEITHER I/O Control Code",
		Description:         "The software defines an IOCTL that uses METHOD_NEITHER for I/O, but it does not validate or incorrectly validates the addresses that are provided.",
		ExtendedDescription: "When an IOCTL uses the METHOD_NEITHER option for I/O control, it is the responsibility of the IOCTL to validate the addresses that have been supplied to it. If validation is missing or incorrect, attackers can supply arbitrary memory addresses, leading to code execution or a denial of service.",
		Lang:                "en",
	},
	"782": {
		CweID:               "782",
		Name:                "Exposed IOCTL with Insufficient Access Control",
		Description:         "The software implements an IOCTL with functionality that should be restricted, but it does not properly enforce access control for the IOCTL.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"783": {
		CweID:               "783",
		Name:                "Operator Precedence Logic Error",
		Description:         "The program uses an expression in which operator precedence causes incorrect logic to be used.",
		ExtendedDescription: "While often just a bug, operator precedence logic errors can have serious consequences if they are used in security-critical code, such as making an authentication decision.",
		Lang:                "en",
	},
	"784": {
		CweID:               "784",
		Name:                "Reliance on Cookies without Validation and Integrity Checking in a Security Decision",
		Description:         "The application uses a protection mechanism that relies on the existence or values of a cookie, but it does not properly ensure that the cookie is valid for the associated user.",
		ExtendedDescription: "Attackers can easily modify cookies, within the browser or by implementing the client-side code outside of the browser. Attackers can bypass protection mechanisms such as authorization and authentication by modifying the cookie to contain an expected value.",
		Lang:                "en",
	},
	"785": {
		CweID:               "785",
		Name:                "Use of Path Manipulation Function without Maximum-sized Buffer",
		Description:         "The software invokes a function for normalizing paths or file names, but it provides an output buffer that is smaller than the maximum possible size, such as PATH_MAX.",
		ExtendedDescription: "Passing an inadequately-sized output buffer to a path manipulation function can result in a buffer overflow. Such functions include realpath(), readlink(), PathAppend(), and others.",
		Lang:                "en",
	},
	"786": {
		CweID:               "786",
		Name:                "Access of Memory Location Before Start of Buffer",
		Description:         "The software reads or writes to a buffer using an index or pointer that references a memory location prior to the beginning of the buffer.",
		ExtendedDescription: "This typically occurs when a pointer or its index is decremented to a position before the buffer, when pointer arithmetic results in a position before the beginning of the valid memory location, or when a negative index is used.",
		Lang:                "en",
	},
	"787": {
		CweID:               "787",
		Name:                "Out-of-bounds Write",
		Description:         "The software writes data past the end, or before the beginning, of the intended buffer.",
		ExtendedDescription: "This typically occurs when the pointer or its index is incremented or decremented to a position beyond the bounds of the buffer or when pointer arithmetic results in a position outside of the valid memory location to name a few. This may result in corruption of sensitive information, a crash, or code execution among other things.",
		Lang:                "en",
	},
	"788": {
		CweID:               "788",
		Name:                "Access of Memory Location After End of Buffer",
		Description:         "The software reads or writes to a buffer using an index or pointer that references a memory location after the end of the buffer.",
		ExtendedDescription: "This typically occurs when a pointer or its index is decremented to a position before the buffer; when pointer arithmetic results in a position before the buffer; or when a negative index is used, which generates a position before the buffer.",
		Lang:                "en",
	},
	"789": {
		CweID:               "789",
		Name:                "Uncontrolled Memory Allocation",
		Description:         "The product allocates memory based on an untrusted size value, but it does not validate or incorrectly validates the size, allowing arbitrary amounts of memory to be allocated.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"79": {
		CweID:               "79",
		Name:                "Improper Neutralization of Input During Web Page Generation ('Cross-site Scripting')",
		Description:         "The software does not neutralize or incorrectly neutralizes user-controllable input before it is placed in output that is used as a web page that is served to other users.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"790": {
		CweID:               "790",
		Name:                "Improper Filtering of Special Elements",
		Description:         "The software receives data from an upstream component, but does not filter or incorrectly filters special elements before sending it to a downstream component.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"791": {
		CweID:               "791",
		Name:                "Incomplete Filtering of Special Elements",
		Description:         "The software receives data from an upstream component, but does not completely filter special elements before sending it to a downstream component.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"792": {
		CweID:               "792",
		Name:                "Incomplete Filtering of One or More Instances of Special Elements",
		Description:         "The software receives data from an upstream component, but does not completely filter one or more instances of special elements before sending it to a downstream component.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"793": {
		CweID:               "793",
		Name:                "Only Filtering One Instance of a Special Element",
		Description:         "The software receives data from an upstream component, but only filters a single instance of a special element before sending it to a downstream component.",
		ExtendedDescription: "Incomplete filtering of this nature may be location-dependent, as in only the first or last element is filtered.",
		Lang:                "en",
	},
	"794": {
		CweID:               "794",
		Name:                "Incomplete Filtering of Multiple Instances of Special Elements",
		Description:         "The software receives data from an upstream component, but does not filter all instances of a special element before sending it to a downstream component.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"795": {
		CweID:               "795",
		Name:                "Only Filtering Special Elements at a Specified Location",
		Description:         "The software receives data from an upstream component, but only accounts for special elements at a specified location, thereby missing remaining special elements that may exist before sending it to a downstream component.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"796": {
		CweID:               "796",
		Name:                "Only Filtering Special Elements Relative to a Marker",
		Description:         "The software receives data from an upstream component, but only accounts for special elements positioned relative to a marker (e.g. 'at the beginning/end of a string; the second argument'), thereby missing remaining special elements that may exist before sending it to a downstream component.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"797": {
		CweID:               "797",
		Name:                "Only Filtering Special Elements at an Absolute Position",
		Description:         "The software receives data from an upstream component, but only accounts for special elements at an absolute position (e.g. 'byte number 10'), thereby missing remaining special elements that may exist before sending it to a downstream component.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"798": {
		CweID:               "798",
		Name:                "Use of Hard-coded Credentials",
		Description:         "The software contains hard-coded credentials, such as a password or cryptographic key, which it uses for its own inbound authentication, outbound communication to external components, or encryption of internal data.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"799": {
		CweID:               "799",
		Name:                "Improper Control of Interaction Frequency",
		Description:         "The software does not properly limit the number or frequency of interactions that it has with an actor, such as the number of incoming requests.",
		ExtendedDescription: "This can allow the actor to perform actions more frequently than expected. The actor could be a human or an automated process such as a virus or bot. This could be used to cause a denial of service, compromise program logic (such as limiting humans to a single vote), or other consequences. For example, an authentication routine might not limit the number of times an attacker can guess a password. Or, a web site might conduct a poll but only expect humans to vote a maximum of once a day.",
		Lang:                "en",
	},
	"8": {
		CweID:               "8",
		Name:                "J2EE Misconfiguration: Entity Bean Declared Remote",
		Description:         "When an application exposes a remote interface for an entity bean, it might also expose methods that get or set the bean's data. These methods could be leveraged to read sensitive information, or to change data in ways that violate the application's expectations, potentially leading to other vulnerabilities.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"80": {
		CweID:               "80",
		Name:                "Improper Neutralization of Script-Related HTML Tags in a Web Page (Basic XSS)",
		Description:         "The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special characters such as '<', '>', and '&' that could be interpreted as web-scripting elements when they are sent to a downstream component that processes web pages.",
		ExtendedDescription: "This may allow such characters to be treated as control characters, which are executed client-side in the context of the user's session. Although this can be classified as an injection problem, the more pertinent issue is the improper conversion of such special characters to respective context-appropriate entities before displaying them to the user.",
		Lang:                "en",
	},
	"804": {
		CweID:               "804",
		Name:                "Guessable CAPTCHA",
		Description:         "The software uses a CAPTCHA challenge, but the challenge can be guessed or automatically recognized by a non-human actor.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"805": {
		CweID:               "805",
		Name:                "Buffer Access with Incorrect Length Value",
		Description:         "The software uses a sequential operation to read or write a buffer, but it uses an incorrect length value that causes it to access memory that is outside of the bounds of the buffer.",
		ExtendedDescription: "When the length value exceeds the size of the destination, a buffer overflow could occur.",
		Lang:                "en",
	},
	"806": {
		CweID:               "806",
		Name:                "Buffer Access Using Size of Source Buffer",
		Description:         "The software uses the size of a source buffer when reading from or writing to a destination buffer, which may cause it to access memory that is outside of the bounds of the buffer.",
		ExtendedDescription: "When the size of the destination is smaller than the size of the source, a buffer overflow could occur.",
		Lang:                "en",
	},
	"807": {
		CweID:               "807",
		Name:                "Reliance on Untrusted Inputs in a Security Decision",
		Description:         "The application uses a protection mechanism that relies on the existence or values of an input, but the input can be modified by an untrusted actor in a way that bypasses the protection mechanism.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"81": {
		CweID:               "81",
		Name:                "Improper Neutralization of Script in an Error Message Web Page",
		Description:         "The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes special characters that could be interpreted as web-scripting elements when they are sent to an error page.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"82": {
		CweID:               "82",
		Name:                "Improper Neutralization of Script in Attributes of IMG Tags in a Web Page",
		Description:         "The web application does not neutralize or incorrectly neutralizes scripting elements within attributes of HTML IMG tags, such as the src attribute.",
		ExtendedDescription: "Attackers can embed XSS exploits into the values for IMG attributes (e.g. SRC) that is streamed and then executed in a victim's browser. Note that when the page is loaded into a user's browsers, the exploit will automatically execute.",
		Lang:                "en",
	},
	"820": {
		CweID:               "820",
		Name:                "Missing Synchronization",
		Description:         "The software utilizes a shared resource in a concurrent manner but does not attempt to synchronize access to the resource.",
		ExtendedDescription: "If access to a shared resource is not synchronized, then the resource may not be in a state that is expected by the software. This might lead to unexpected or insecure behaviors, especially if an attacker can influence the shared resource.",
		Lang:                "en",
	},
	"821": {
		CweID:               "821",
		Name:                "Incorrect Synchronization",
		Description:         "The software utilizes a shared resource in a concurrent manner but it does not correctly synchronize access to the resource.",
		ExtendedDescription: "If access to a shared resource is not correctly synchronized, then the resource may not be in a state that is expected by the software. This might lead to unexpected or insecure behaviors, especially if an attacker can influence the shared resource.",
		Lang:                "en",
	},
	"822": {
		CweID:               "822",
		Name:                "Untrusted Pointer Dereference",
		Description:         "The program obtains a value from an untrusted source, converts this value to a pointer, and dereferences the resulting pointer.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"823": {
		CweID:               "823",
		Name:                "Use of Out-of-range Pointer Offset",
		Description:         "The program performs pointer arithmetic on a valid pointer, but it uses an offset that can point outside of the intended range of valid memory locations for the resulting pointer.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"824": {
		CweID:               "824",
		Name:                "Access of Uninitialized Pointer",
		Description:         "The program accesses or uses a pointer that has not been initialized.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"825": {
		CweID:               "825",
		Name:                "Expired Pointer Dereference",
		Description:         "The program dereferences a pointer that contains a location for memory that was previously valid, but is no longer valid.",
		ExtendedDescription: "When a program releases memory, but it maintains a pointer to that memory, then the memory might be re-allocated at a later time. If the original pointer is accessed to read or write data, then this could cause the program to read or modify data that is in use by a different function or process. Depending on how the newly-allocated memory is used, this could lead to a denial of service, information exposure, or code execution.",
		Lang:                "en",
	},
	"826": {
		CweID:               "826",
		Name:                "Premature Release of Resource During Expected Lifetime",
		Description:         "The program releases a resource that is still intended to be used by the program itself or another actor.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"827": {
		CweID:               "827",
		Name:                "Improper Control of Document Type Definition",
		Description:         "The software does not restrict a reference to a Document Type Definition (DTD) to the intended control sphere. This might allow attackers to reference arbitrary DTDs, possibly causing the software to expose files, consume excessive system resources, or execute arbitrary http requests on behalf of the attacker.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"828": {
		CweID:               "828",
		Name:                "Signal Handler with Functionality that is not Asynchronous-Safe",
		Description:         "The software defines a signal handler that contains code sequences that are not asynchronous-safe, i.e., the functionality is not reentrant, or it can be interrupted.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"829": {
		CweID:               "829",
		Name:                "Inclusion of Functionality from Untrusted Control Sphere",
		Description:         "The software imports, requires, or includes executable functionality (such as a library) from a source that is outside of the intended control sphere.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"83": {
		CweID:               "83",
		Name:                "Improper Neutralization of Script in Attributes in a Web Page",
		Description:         "The software does not neutralize or incorrectly neutralizes 'javascript:' or other URIs from dangerous attributes within tags, such as onmouseover, onload, onerror, or style.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"830": {
		CweID:               "830",
		Name:                "Inclusion of Web Functionality from an Untrusted Source",
		Description:         "The software includes web functionality (such as a web widget) from another domain, which causes it to operate within the domain of the software, potentially granting total access and control of the software to the untrusted source.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"831": {
		CweID:               "831",
		Name:                "Signal Handler Function Associated with Multiple Signals",
		Description:         "The software defines a function that is used as a handler for more than one signal.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"832": {
		CweID:               "832",
		Name:                "Unlock of a Resource that is not Locked",
		Description:         "The software attempts to unlock a resource that is not locked.",
		ExtendedDescription: "Depending on the locking functionality, an unlock of a non-locked resource might cause memory corruption or other modification to the resource (or its associated metadata that is used for tracking locks).",
		Lang:                "en",
	},
	"833": {
		CweID:               "833",
		Name:                "Deadlock",
		Description:         "The software contains multiple threads or executable segments that are waiting for each other to release a necessary lock, resulting in deadlock.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"834": {
		CweID:               "834",
		Name:                "Excessive Iteration",
		Description:         "The software performs an iteration or loop without sufficiently limiting the number of times that the loop is executed.",
		ExtendedDescription: "If the iteration can be influenced by an attacker, this weakness could allow attackers to consume excessive resources such as CPU or memory. In many cases, a loop does not need to be infinite in order to cause enough resource consumption to adversely affect the software or its host system; it depends on the amount of resources consumed per iteration.",
		Lang:                "en",
	},
	"835": {
		CweID:               "835",
		Name:                "Loop with Unreachable Exit Condition ('Infinite Loop')",
		Description:         "The program contains an iteration or loop with an exit condition that cannot be reached, i.e., an infinite loop.",
		ExtendedDescription: "If the loop can be influenced by an attacker, this weakness could allow attackers to consume excessive resources such as CPU or memory.",
		Lang:                "en",
	},
	"836": {
		CweID:               "836",
		Name:                "Use of Password Hash Instead of Password for Authentication",
		Description:         "The software records password hashes in a data store, receives a hash of a password from a client, and compares the supplied hash to the hash obtained from the data store.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"837": {
		CweID:               "837",
		Name:                "Improper Enforcement of a Single, Unique Action",
		Description:         "The software requires that an actor should only be able to perform an action once, or to have only one unique action, but the software does not enforce or improperly enforces this restriction.",
		ExtendedDescription: "In various applications, a user is only expected to perform a certain action once, such as voting, requesting a refund, or making a purchase. When this restriction is not enforced, sometimes this can have security implications. For example, in a voting application, an attacker could attempt to 'stuff the ballot box' by voting multiple times. If these votes are counted separately, then the attacker could directly affect who wins the vote. This could have significant business impact depending on the purpose of the software.",
		Lang:                "en",
	},
	"838": {
		CweID:               "838",
		Name:                "Inappropriate Encoding for Output Context",
		Description:         "The software uses or specifies an encoding when generating output to a downstream component, but the specified encoding is not the same as the encoding that is expected by the downstream component.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"839": {
		CweID:               "839",
		Name:                "Numeric Range Comparison Without Minimum Check",
		Description:         "The program checks a value to ensure that it does not exceed a maximum, but it does not verify that the value exceeds the minimum.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"84": {
		CweID:               "84",
		Name:                "Improper Neutralization of Encoded URI Schemes in a Web Page",
		Description:         "The web application improperly neutralizes user-controlled input for executable script disguised with URI encodings.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"841": {
		CweID:               "841",
		Name:                "Improper Enforcement of Behavioral Workflow",
		Description:         "The software supports a session in which more than one behavior must be performed by an actor, but it does not properly ensure that the actor performs the behaviors in the required sequence.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"842": {
		CweID:               "842",
		Name:                "Placement of User into Incorrect Group",
		Description:         "The software or the administrator places a user into an incorrect group.",
		ExtendedDescription: "If the incorrect group has more access or privileges than the intended group, the user might be able to bypass intended security policy to access unexpected resources or perform unexpected actions. The access-control system might not be able to detect malicious usage of this group membership.",
		Lang:                "en",
	},
	"843": {
		CweID:               "843",
		Name:                "Access of Resource Using Incompatible Type ('Type Confusion')",
		Description:         "The program allocates or initializes a resource such as a pointer, object, or variable using one type, but it later accesses that resource using a type that is incompatible with the original type.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"85": {
		CweID:               "85",
		Name:                "Doubled Character XSS Manipulations",
		Description:         "The web application does not filter user-controlled input for executable script disguised using doubling of the involved characters.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"86": {
		CweID:               "86",
		Name:                "Improper Neutralization of Invalid Characters in Identifiers in Web Pages",
		Description:         "The software does not neutralize or incorrectly neutralizes invalid characters or byte sequences in the middle of tag names, URI schemes, and other identifiers.",
		ExtendedDescription: "Some web browsers may remove these sequences, resulting in output that may have unintended control implications. For example, the software may attempt to remove a 'javascript:' URI scheme, but a 'java%00script:' URI may bypass this check and still be rendered as active javascript by some browsers, allowing XSS or other attacks.",
		Lang:                "en",
	},
	"862": {
		CweID:               "862",
		Name:                "Missing Authorization",
		Description:         "The software does not perform an authorization check when an actor attempts to access a resource or perform an action.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"863": {
		CweID:               "863",
		Name:                "Incorrect Authorization",
		Description:         "The software performs an authorization check when an actor attempts to access a resource or perform an action, but it does not correctly perform the check. This allows attackers to bypass intended access restrictions.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"87": {
		CweID:               "87",
		Name:                "Improper Neutralization of Alternate XSS Syntax",
		Description:         "The software does not neutralize or incorrectly neutralizes user-controlled input for alternate script syntax.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"88": {
		CweID:               "88",
		Name:                "Argument Injection or Modification",
		Description:         "The software does not sufficiently delimit the arguments being passed to a component in another control sphere, allowing alternate arguments to be provided, leading to potentially security-relevant changes.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"89": {
		CweID:               "89",
		Name:                "Improper Neutralization of Special Elements used in an SQL Command ('SQL Injection')",
		Description:         "The software constructs all or part of an SQL command using externally-influenced input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could modify the intended SQL command when it is sent to a downstream component.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"9": {
		CweID:               "9",
		Name:                "J2EE Misconfiguration: Weak Access Permissions for EJB Methods",
		Description:         "If elevated access rights are assigned to EJB methods, then an attacker can take advantage of the permissions to exploit the software system.",
		ExtendedDescription: "If the EJB deployment descriptor contains one or more method permissions that grant access to the special ANYONE role, it indicates that access control for the application has not been fully thought through or that the application is structured in such a way that reasonable access control restrictions are impossible.",
		Lang:                "en",
	},
	"90": {
		CweID:               "90",
		Name:                "Improper Neutralization of Special Elements used in an LDAP Query ('LDAP Injection')",
		Description:         "The software constructs all or part of an LDAP query using externally-influenced input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could modify the intended LDAP query when it is sent to a downstream component.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"908": {
		CweID:               "908",
		Name:                "Use of Uninitialized Resource",
		Description:         "The software uses a resource that has not been properly initialized.",
		ExtendedDescription: "This can have security implications when the associated resource is expected to have certain properties or values.",
		Lang:                "en",
	},
	"909": {
		CweID:               "909",
		Name:                "Missing Initialization of Resource",
		Description:         "The software does not initialize a critical resource.",
		ExtendedDescription: "Many resources require initialization before they can be properly used. If a resource is not initialized, it could contain unpredictable or expired data, or it could be initialized to defaults that are invalid. This can have security implications when the resource is expected to have certain properties or values.",
		Lang:                "en",
	},
	"91": {
		CweID:               "91",
		Name:                "XML Injection (aka Blind XPath Injection)",
		Description:         "The software does not properly neutralize special elements that are used in XML, allowing attackers to modify the syntax, content, or commands of the XML before it is processed by an end system.",
		ExtendedDescription: "Within XML, special elements could include reserved words or characters such as '<', '>', ''', and '&', which could then be used to add new data or modify XML syntax.",
		Lang:                "en",
	},
	"910": {
		CweID:               "910",
		Name:                "Use of Expired File Descriptor",
		Description:         "The software uses or accesses a file descriptor after it has been closed.",
		ExtendedDescription: "After a file descriptor for a particular file or device has been released, it can be reused. The code might not write to the original file, since the reused file descriptor might reference a different file or device.",
		Lang:                "en",
	},
	"911": {
		CweID:               "911",
		Name:                "Improper Update of Reference Count",
		Description:         "The software uses a reference count to manage a resource, but it does not update or incorrectly updates the reference count.",
		ExtendedDescription: "Reference counts can be used when tracking how many objects contain a reference to a particular resource, such as in memory management or garbage collection. When the reference count reaches zero, the resource can be de-allocated or reused because there are no more objects that use it. If the reference count accidentally reaches zero, then the resource might be released too soon, even though it is still in use. If all objects no longer use the resource, but the reference count is not zero, then the resource might not ever be released.",
		Lang:                "en",
	},
	"912": {
		CweID:               "912",
		Name:                "Hidden Functionality",
		Description:         "The software contains functionality that is not documented, not part of the specification, and not accessible through an interface or command sequence that is obvious to the software's users or administrators.",
		ExtendedDescription: "Hidden functionality can take many forms, such as intentionally malicious code, 'Easter Eggs' that contain extraneous functionality such as games, developer-friendly shortcuts that reduce maintenance or support costs such as hard-coded accounts, etc. From a security perspective, even when the functionality is not intentionally malicious or damaging, it can increase the software's attack surface and expose additional weaknesses beyond what is already exposed by the intended functionality. Even if it is not easily accessible, the hidden functionality could be useful for attacks that modify the control flow of the application.",
		Lang:                "en",
	},
	"913": {
		CweID:               "913",
		Name:                "Improper Control of Dynamically-Managed Code Resources",
		Description:         "The software does not properly restrict reading from or writing to dynamically-managed code resources such as variables, objects, classes, attributes, functions, or executable instructions or statements.",
		ExtendedDescription: "Many languages offer powerful features that allow the programmer to dynamically create or modify existing code, or resources used by code such as variables and objects. While these features can offer significant flexibility and reduce development time, they can be extremely dangerous if attackers can directly influence these code resources in unexpected ways.",
		Lang:                "en",
	},
	"914": {
		CweID:               "914",
		Name:                "Improper Control of Dynamically-Identified Variables",
		Description:         "The software does not properly restrict reading from or writing to dynamically-identified variables.",
		ExtendedDescription: "Many languages offer powerful features that allow the programmer to access arbitrary variables that are specified by an input string. While these features can offer significant flexibility and reduce development time, they can be extremely dangerous if attackers can modify unintended variables that have security implications.",
		Lang:                "en",
	},
	"915": {
		CweID:               "915",
		Name:                "Improperly Controlled Modification of Dynamically-Determined Object Attributes",
		Description:         "The software receives input from an upstream component that specifies multiple attributes, properties, or fields that are to be initialized or updated in an object, but it does not properly control which attributes can be modified.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"916": {
		CweID:               "916",
		Name:                "Use of Password Hash With Insufficient Computational Effort",
		Description:         "The software generates a hash for a password, but it uses a scheme that does not provide a sufficient level of computational effort that would make password cracking attacks infeasible or expensive.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"917": {
		CweID:               "917",
		Name:                "Improper Neutralization of Special Elements used in an Expression Language Statement ('Expression Language Injection')",
		Description:         "The software constructs all or part of an expression language (EL) statement in a Java Server Page (JSP) using externally-influenced input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could modify the intended EL statement before it is executed.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"918": {
		CweID:               "918",
		Name:                "Server-Side Request Forgery (SSRF)",
		Description:         "The web server receives a URL or similar request from an upstream component and retrieves the contents of this URL, but it does not sufficiently ensure that the request is being sent to the expected destination.",
		ExtendedDescription: "By providing URLs to unexpected hosts or ports, attackers can make it appear that the server is sending the request, possibly bypassing access controls such as firewalls that prevent the attackers from accessing the URLs directly. The server can be used as a proxy to conduct port scanning of hosts in internal networks, use other URLs such as that can access documents on the system (using file://), or use other protocols such as gopher:// or tftp://, which may provide greater control over the contents of requests.",
		Lang:                "en",
	},
	"92": {
		CweID:               "92",
		Name:                "DEPRECATED: Improper Sanitization of Custom Special Characters",
		Description:         "This entry has been deprecated. It originally came from PLOVER, which sometimes defined 'other' and 'miscellaneous' categories in order to satisfy exhaustiveness requirements for taxonomies. Within the context of CWE, the use of a more abstract entry is preferred in mapping situations. CWE-75 is a more appropriate mapping.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"920": {
		CweID:               "920",
		Name:                "Improper Restriction of Power Consumption",
		Description:         "The software operates in an environment in which power is a limited resource that cannot be automatically replenished, but the software does not properly restrict the amount of power that its operation consumes.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"921": {
		CweID:               "921",
		Name:                "Storage of Sensitive Data in a Mechanism without Access Control",
		Description:         "The software stores sensitive information in a file system or device that does not have built-in access control.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"922": {
		CweID:               "922",
		Name:                "Insecure Storage of Sensitive Information",
		Description:         "The software stores sensitive information without properly limiting read or write access by unauthorized actors.",
		ExtendedDescription: "If read access is not properly restricted, then attackers can steal the sensitive information. If write access is not properly restricted, then attackers can modify and possibly delete the data, causing incorrect results and possibly a denial of service.",
		Lang:                "en",
	},
	"923": {
		CweID:               "923",
		Name:                "Improper Restriction of Communication Channel to Intended Endpoints",
		Description:         "The software establishes a communication channel to (or from) an endpoint for privileged or protected operations, but it does not properly ensure that it is communicating with the correct endpoint.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"924": {
		CweID:               "924",
		Name:                "Improper Enforcement of Message Integrity During Transmission in a Communication Channel",
		Description:         "The software establishes a communication channel with an endpoint and receives a message from that endpoint, but it does not sufficiently ensure that the message was not modified during transmission.",
		ExtendedDescription: "A man-in-the-middle (MITM) attacker might be able to modify the message and spoof the endpoint.",
		Lang:                "en",
	},
	"925": {
		CweID:               "925",
		Name:                "Improper Verification of Intent by Broadcast Receiver",
		Description:         "The Android application uses a Broadcast Receiver that receives an Intent but does not properly verify that the Intent came from an authorized source.",
		ExtendedDescription: "Certain types of Intents, identified by action string, can only be broadcast by the operating system itself, not by third-party applications. However, when an application registers to receive these implicit system intents, it is also registered to receive any explicit intents. While a malicious application cannot send an implicit system intent, it can send an explicit intent to the target application, which may assume that any received intent is a valid implicit system intent and not an explicit intent from another application. This may lead to unintended behavior.",
		Lang:                "en",
	},
	"926": {
		CweID:               "926",
		Name:                "Improper Export of Android Application Components",
		Description:         "The Android application exports a component for use by other applications, but does not properly restrict which applications can launch the component or access the data it contains.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"927": {
		CweID:               "927",
		Name:                "Use of Implicit Intent for Sensitive Communication",
		Description:         "The Android application uses an implicit intent for transmitting sensitive data to other applications.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"93": {
		CweID:               "93",
		Name:                "Improper Neutralization of CRLF Sequences ('CRLF Injection')",
		Description:         "The software uses CRLF (carriage return line feeds) as a special element, e.g. to separate lines or records, but it does not neutralize or incorrectly neutralizes CRLF sequences from inputs.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"939": {
		CweID:               "939",
		Name:                "Improper Authorization in Handler for Custom URL Scheme",
		Description:         "The software uses a handler for a custom URL scheme, but it does not properly restrict which actors can invoke the handler using the scheme.",
		ExtendedDescription: "Mobile platforms and other architectures allow the use of custom URL schemes to facilitate communication between applications. In the case of iOS, this is the only method to do inter-application communication. The implementation is at the developer's discretion which may open security flaws in the application. An example could be potentially dangerous functionality such as modifying files through a custom URL scheme.",
		Lang:                "en",
	},
	"94": {
		CweID:               "94",
		Name:                "Improper Control of Generation of Code ('Code Injection')",
		Description:         "The software constructs all or part of a code segment using externally-influenced input from an upstream component, but it does not neutralize or incorrectly neutralizes special elements that could modify the syntax or behavior of the intended code segment.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"940": {
		CweID:               "940",
		Name:                "Improper Verification of Source of a Communication Channel",
		Description:         "The software establishes a communication channel to handle an incoming request that has been initiated by an actor, but it does not properly verify that the request is coming from the expected origin.",
		ExtendedDescription: "When an attacker can successfully establish a communication channel from an untrusted origin, the attacker may be able to gain privileges and access unexpected functionality.",
		Lang:                "en",
	},
	"941": {
		CweID:               "941",
		Name:                "Incorrectly Specified Destination in a Communication Channel",
		Description:         "The software creates a communication channel to initiate an outgoing request to an actor, but it does not correctly specify the intended destination for that actor.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"942": {
		CweID:               "942",
		Name:                "Overly Permissive Cross-domain Whitelist",
		Description:         "The software uses a cross-domain policy file that includes domains that should not be trusted.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"943": {
		CweID:               "943",
		Name:                "Improper Neutralization of Special Elements in Data Query Logic",
		Description:         "The application generates a query intended to access or manipulate data in a data store such as a database, but it does not neutralize or incorrectly neutralizes special elements that can modify the intended logic of the query.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"95": {
		CweID:               "95",
		Name:                "Improper Neutralization of Directives in Dynamically Evaluated Code ('Eval Injection')",
		Description:         "The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes code syntax before using the input in a dynamic evaluation call (e.g. 'eval').",
		ExtendedDescription: "This may allow an attacker to execute arbitrary code, or at least modify what code can be executed.",
		Lang:                "en",
	},
	"96": {
		CweID:               "96",
		Name:                "Improper Neutralization of Directives in Statically Saved Code ('Static Code Injection')",
		Description:         "The software receives input from an upstream component, but it does not neutralize or incorrectly neutralizes code syntax before inserting the input into an executable resource, such as a library, configuration file, or template.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"97": {
		CweID:               "97",
		Name:                "Improper Neutralization of Server-Side Includes (SSI) Within a Web Page",
		Description:         "The software generates a web page, but does not neutralize or incorrectly neutralizes user-controllable input that could be interpreted as a server-side include (SSI) directive.",
		ExtendedDescription: "",
		Lang:                "en",
	},
	"98": {
		CweID:               "98",
		Name:                "Improper Control of Filename for Include/Require Statement in PHP Program ('PHP Remote File Inclusion')",
		Description:         "The PHP application receives input from an upstream component, but it does not restrict or incorrectly restricts the input before its usage in 'require,' 'include,' or similar functions.",
		ExtendedDescription: "In certain versions and configurations of PHP, this can allow an attacker to specify a URL to a remote location from which the software will obtain the code to execute. In other cases in association with path traversal, the attacker can specify a local file that may contain executable statements that can be parsed by PHP.",
		Lang:                "en",
	},
	"99": {
		CweID:               "99",
		Name:                "Improper Control of Resource Identifiers ('Resource Injection')",
		Description:         "The software receives input from an upstream component, but it does not restrict or incorrectly restricts the input before it is used as an identifier for a resource that may be outside the intended sphere of control.",
		ExtendedDescription: "",
		Lang:                "en",
	},
}
