}q (X   __module_docstringqX  The :class:`RichTextCtrl` is a generic, ground-up implementation of a rich
text control capable of showing multiple text styles and images.  This module
contains the control and many supporting classes needed for using the features
of the :class:`RichTextCtrl`.

.. note:: Due to some internal dynamic initialization in wxWidgets, this
          module should be imported **before** the :class:`wx.App` object is
          created.
qX   TextAttrDimensionqXI   A class representing a rich text dimension, including units and position.qX   TextAttrDimensionsqX3   A class for left, right, top and bottom dimensions.qX   TextAttrSizeqX*   A class for representing width and height.qX   TextAttrDimensionConverterq	X0   A class to make it easier to convert dimensions.q
X   TextAttrBorderqX/   A class representing a rich text object border.qX   TextAttrBordersq
X2   A class representing a rich text object's borders.qX   TextBoxAttrqX>   A class representing the box attributes of a rich text object.qX   RichTextAttrqX?   A class representing enhanced attributes for rich text objects.qX   RichTextPropertiesqX'   A simple property class using Variants.qX   RichTextFontTableqX@   Manages quick access to a pool of fonts for rendering rich text.qX
   RichTextRangeqX<   This stores beginning and end positions for a range of data.qX   RichTextSelectionqX   Stores selection information.qX   RichTextDrawingContextqXC   A class for passing information to drawing and measuring functions.qX   RichTextObjectqX0   This is the base for drawable rich text objects.qX   RichTextCompositeObjectqX0   Objects of this class can contain other objects.q X   RichTextParagraphLayoutBoxq!X+   This class knows how to lay out paragraphs.q"X   RichTextBoxq#XK   This class implements a floating or inline text box, containing paragraphs.q$X
   RichTextFieldq%X   This class implements the general concept of a field, an object that represents additional functionality such as a footnote, a bookmark, a page number, a table of contents, and so on.q&X   RichTextFieldTypeq'X&   The base class for custom field types.q(X   RichTextFieldTypeStandardq)X   A field type that can handle fields with text or bitmap labels, with a small range of styles for implementing rectangular fields and fields that can be used for start and end tags.q*X   RichTextLineq+X   This object represents a line in a paragraph, and stores offsets from the start of the paragraph representing the start and end positions of the line.q,X   RichTextParagraphq-X   This object represents a single paragraph containing various objects such as text content, images, and further paragraph layout objects.q.X   RichTextPlainTextq/X.   This object represents a single piece of text.q0X   RichTextImageBlockq1XG   This class stores information about an image, in binary in-memory form.q2X
   RichTextImageq3X'   This class implements a graphic object.q4X   RichTextBufferq5XK   This is a kind of paragraph layout box, used to represent the whole buffer.q6X   RichTextCellq7XT   :ref:`wx.richtext.RichTextCell`  is the cell in a table, in which the user can type.q8X
   RichTextTableq9XU   :ref:`wx.richtext.RichTextTable`  represents a table with arbitrary columns and rows.q:X   RichTextObjectAddressq;X   A class for specifying an object anywhere in an object hierarchy, without using a pointer, necessary since ``RTC`` commands may delete and recreate sub-objects so physical object addresses change.q<X   RichTextCommandq=X,   Implements a command on the undo/redo stack.q>X   RichTextActionq?X   Implements a part of a command.q@X   RichTextFileHandlerqAX!   The base class for file handlers.qBX   RichTextPlainTextHandlerqCX)   Implements saving a buffer to plain text.qDX   RichTextDrawingHandlerqEX+   The base class for custom drawing handlers.qFX   RichTextBufferDataObjectqGX:   Implements a rich text data object for clipboard transfer.qHX   RichTextRendererqIX6   This class isolates some common drawing functionality.qJX   RichTextStdRendererqKX*   The standard renderer for drawing bullets.qLX!   RichTextContextMenuPropertiesInfoqMX   :ref:`wx.richtext.RichTextContextMenuPropertiesInfo`  keeps track of objects that appear in the context menu, whose properties are available to be edited.qNX   RichTextCtrlqOX   :ref:`wx.richtext.RichTextCtrl`  provides a generic, ground-up implementation of a text control capable of showing multiple styles and images.qPX
   RichTextEventqQXK   This is the event class for :ref:`wx.richtext.RichTextCtrl`  notifications.qRX   RichTextHTMLHandlerqSXH   Handles HTML output (only) for :ref:`wx.richtext.RichTextCtrl`  content.qTX   RichTextXMLHandlerqUXl   A handler for loading and saving content in an ``XML`` format specific to :ref:`wx.richtext.RichTextBuffer`.qVX   RichTextHeaderFooterDataqWX   This class represents header and footer data to be passed to the :ref:`wx.richtext.RichTextPrinting`  and :ref:`wx.richtext.RichTextPrintout`  classes.qXX   RichTextPrintoutqYXI   This class implements print layout for :ref:`wx.richtext.RichTextBuffer`.qZX   RichTextPrintingq[Xq   This class provides a simple interface for performing :ref:`wx.richtext.RichTextBuffer`  printing and previewing.q\X   RichTextStyleListCtrlq]X   This class incorporates a :ref:`wx.richtext.RichTextStyleListBox`  and a choice control that allows the user to select the category of style to view.q^X   RichTextStyleListBoxq_X   This is a listbox that can display the styles in a :ref:`wx.richtext.RichTextStyleSheet`, and apply the selection to an associated :ref:`wx.richtext.RichTextCtrl`.q`X   RichTextStyleComboCtrlqaX   This is a combo control that can display the styles in a :ref:`wx.richtext.RichTextStyleSheet`, and apply the selection to an associated :ref:`wx.richtext.RichTextCtrl`.qbX   RichTextStyleDefinitionqcX8   This is a base class for paragraph and character styles.qdX    RichTextParagraphStyleDefinitionqeXm   This class represents a paragraph style definition, usually added to a :ref:`wx.richtext.RichTextStyleSheet`.qfX    RichTextCharacterStyleDefinitionqgXm   This class represents a character style definition, usually added to a :ref:`wx.richtext.RichTextStyleSheet`.qhX   RichTextListStyleDefinitionqiXh   This class represents a list style definition, usually added to a :ref:`wx.richtext.RichTextStyleSheet`.qjX   RichTextStyleSheetqkX   A style sheet contains named paragraph and character styles that make it easy for a user to apply combinations of attributes to a :ref:`wx.richtext.RichTextCtrl`.qlX   RichTextStyleOrganiserDialogqmXR   This class shows a style sheet and allows the user to edit, add and remove styles.qnX   SymbolPickerDialogqoXs   :ref:`wx.richtext.SymbolPickerDialog`  presents the user with a choice of fonts and a grid of available characters.qpX   RichTextFormattingDialogFactoryqqXx   This class provides pages for :ref:`wx.richtext.RichTextFormattingDialog`, and allows other customization of the dialog.qrX   RichTextFormattingDialogqsXG   This dialog allows the user to edit a character and/or paragraph style.qtu.