#include "alternatives.ih"

// static
void Alternatives::globFilter(char const *entry, GlobContext &context)
{
    imsg << "Inspecting `" << entry << "': ";
                            // if a trailing / was removed reinstall it.
    string dirEntry(entry);
    if (dirEntry.back() != '/')
        dirEntry += '/';

    if (
        dotPattern(dirEntry, context)
        or
        trailingDotPatterns(entry)
    )
        return;

    Stat stat{ entry };

        // check if the entry name (globbed) is equal to the true path name
        // if not, the globbed name is a link to the true path
    if (not context.alternatives.d_allDirs && stat.path() != entry)
    {
        imsg << "symlink" << endl;
        return;
    }

    if
    (
        context.stored.insert(
            pair<size_t, size_t>(stat.inode(), stat.device())
        ).second == false           // entry already there
    )
    {
        imsg << "already available" << endl;
        return;
    }

    imsg << "ACCEPTED" << endl;

    context.alternatives.add(entry);
}
