
/* fli.h: ICCE Add-ons for XForms */

#ifndef _FLI_H_
#define _FLI_H_

#include <X11/forms.h> 

#ifdef __cplusplus
extern "C"
{
#endif

    /* Help browser definitions - KK sept 95. */
    /* ====================================== */

    /* load helpfile into browser, return 0 on success; 1 = file not found,
       2 = other fault (memory) */
    extern int fli_load_help_browser (FL_FORM *form, FL_OBJECT *textbrowser,
				      FL_OBJECT *contentsbrowser, FL_OBJECT
				      *indexbrowser, char const *fname);

    /* terminate help browser */
    extern void fli_terminate_help_browser (FL_OBJECT *obj);

    /* Data types, functions and variables for internal usage */
    typedef struct
    {
	FL_OBJECT *textbrowser, *contentsbrowser, *indexbrowser;
	FILE *f;
	FL_FORM *form;
    } FLI_HELP_BROWSER;

    extern FLI_HELP_BROWSER
	*fli_help_browser;
    extern int
	nfli_help_browser;

    /* callback that makes the browser clickable.. internal function */ 
    extern void fli_help_browser_cb (FL_OBJECT *obj, long data);

    /* callback that makes the browser clickable.. internal function */ 
    extern void fli_parse_helpfile (int index);

    /* Color lookup definitions - KK sept. 95 */
    /* ====================================== */

    /* where is the color database? */ 
#   define FLI_RGB_DATABASE	    "/usr/lib/X11/rgb.txt"

    /* look up a color, return 0 on success, 1 on database not found,
       2 on color not found */ 
    extern int fli_lookup_color (char const *col, int *r, int *g, int *b);

    /* Geometry parsing and applying - KK sept. 95 */
    /* =========================================== */

    /* parse a geometry string.. returns a bitmask of: */
#   define FLI_WH_PARSED	    1	    /* width/height parsed */
#   define FLI_XY_PARSED	    2	    /* x/y parsed */
#   define FLI_WHXY_PARSED	    3	    /* both */
    /* zero return value: error */
    
    extern int fli_parse_geometry (char const *geom, int *x, int *y,
				   int *w, int *h);

    /* parse a geometry string and apply it to a form,
       return types same as above */ 
    extern int fli_apply_geometry (FL_FORM *form, char const *geom);

#ifdef __cplusplus
}
#endif

#endif						/* _FLI_H_ */ 
