/* yForth? - A Forth interpreter written in ANSI C
 * Copyright (C) 2012 Luca Padovani
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * ------------------------------------------------------------------------
 * Module name: memall.c
 * Abstract:    Memory allocation word set
 */

#include <string.h>
#include <malloc.h>
#include "yforth.h"
#include "core.h"
#include "coree.h"

/**************************************************************************/
/* WORDS ******************************************************************/
/**************************************************************************/

void _allocate() {
    register void *addr = malloc(*sp);
    if (addr == NULL) *sp = 0;
    else *sp = (Cell) addr;
    *--sp = FFLAG(addr == NULL);
}

void _free() {
    free((void *) *sp);
    *sp = FFLAG(0);
}

void _resize() {
    register void *addr = realloc((void *) sp[1], sp[0]);
    if (addr == NULL) sp[1] = 0;
    else sp[1] = (Cell) addr;
    *sp = FFLAG(addr == NULL);
}


