
# AWS RDS instance by HTTP

## Overview

For Zabbix version: 6.0 and higher  
The template to monitor AWS RDS instance by HTTP via Zabbix that works without any external scripts.  
Most of the metrics are collected in one go, thanks to Zabbix bulk data collection.
*NOTE*
This template uses the GetMetricData CloudWatch API calls to list and retrieve metrics.
For more information, please refer to the (CloudWatch pricing)[https://aws.amazon.com/cloudwatch/pricing/] page.

Additional information about metrics and used API methods:

* Full metrics list related to RDS: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-metrics.html
* Full metrics list related to Amazon Aurora: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.AuroraMySQL.Monitoring.Metrics.html#Aurora.AuroraMySQL.Monitoring.Metrics.instances
* DescribeAlarms API method: https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html


## Setup

> See [Zabbix template operation](https://www.zabbix.com/documentation/6.0/manual/config/templates_out_of_the_box/http) for basic instructions.

The template get AWS RDS instance metrics and uses the script item to make HTTP requests to the CloudWatch API.

Before using the template, you need to create an IAM policy with the necessary permissions for the Zabbix role in your AWS account.  

Add the following required permissions to your Zabbix IAM policy in order to collect Amazon RDS metrics.  
```json
{
    "Version":"2012-10-17",
    "Statement":[
        {
          "Action":[
              "cloudwatch:Describe*",
              "cloudwatch:Get*",
              "cloudwatch:List*",
              "rds:Describe*"
          ],
          "Effect":"Allow",
          "Resource":"*"
        }
    ]
  }
  ```

Set macros "{$AWS.ACCESS.KEY.ID}", "{$AWS.SECRET.ACCESS.KEY}", "{$AWS.REGION}", "{$AWS.RDS.INSTANCE.ID}"

For more information about manage access keys, see [official documentation](https://docs.aws.amazon.com/general/latest/gr/aws-sec-cred-types.html#access-keys-and-secret-access-keys)

Also, see the Macros section for a list of macros used for LLD filters.

Additional information about metrics and used API methods:
* Full metrics list related to RDS: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-metrics.html
* Full metrics list related to Amazon Aurora: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.AuroraMySQL.Monitoring.Metrics.html#Aurora.AuroraMySQL.Monitoring.Metrics.instances
* DescribeAlarms API method: https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html


## Zabbix configuration

No specific Zabbix configuration is required.

### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$AWS.ACCESS.KEY.ID} |<p>Access key ID.</p> |`` |
|{$AWS.EBS.BYTE.CREDIT.BALANCE.MIN.WARN} |<p>Minimum percentage of Byte credits remaining for trigger expression.</p> |`20` |
|{$AWS.EBS.IO.CREDIT.BALANCE.MIN.WARN} |<p>Minimum percentage of I/O credits remaining for trigger expression.</p> |`20` |
|{$AWS.RDS.BURST.CREDIT.BALANCE.MIN.WARN} |<p>Minimum percentage of Byte credits remaining for trigger expression.</p> |`20` |
|{$AWS.RDS.CPU.CREDIT.BALANCE.MIN.WARN} |<p>Minimum number of free earned CPU credits for trigger expression.</p> |`50` |
|{$AWS.RDS.CPU.UTIL.WARN.MAX} |<p>The warning threshold of the CPU utilization in %.</p> |`85` |
|{$AWS.RDS.INSTANCE.ID} |<p>RDS DB Instance identifier.</p> |`` |
|{$AWS.RDS.LLD.FILTER.ALARM_NAME.MATCHES} |<p>Filter of discoverable alarms by namespace.</p> |`.*` |
|{$AWS.RDS.LLD.FILTER.ALARM_NAME.NOT_MATCHES} |<p>Filter to exclude discovered alarms by namespace.</p> |`CHANGE_IF_NEEDED` |
|{$AWS.RDS.LLD.FILTER.ALARM_SERVICE_NAMESPACE.MATCHES} |<p>Filter of discoverable alarms by namespace.</p> |`.*` |
|{$AWS.RDS.LLD.FILTER.ALARM_SERVICE_NAMESPACE.NOT_MATCHES} |<p>Filter to exclude discovered alarms by namespace.</p> |`CHANGE_IF_NEEDED` |
|{$AWS.RDS.LLD.FILTER.EVENT_CATEGORY.MATCHES} |<p>Filter of discoverable events by category.</p> |`.*` |
|{$AWS.RDS.LLD.FILTER.EVENT_CATEGORY.NOT_MATCHES} |<p>Filter to exclude discovered events by category.</p> |`CHANGE_IF_NEEDED` |
|{$AWS.RDS.LLD.FILTER.EVENT_SOURCE_TYPE.MATCHES} |<p>Filter of discoverable events by source type.</p> |`.*` |
|{$AWS.RDS.LLD.FILTER.EVENT_SOURCE_TYPE.NOT_MATCHES} |<p>Filter to exclude discovered events by source type.</p> |`CHANGE_IF_NEEDED` |
|{$AWS.REGION} |<p>Amazon RDS Region code.</p> |`us-west-1` |
|{$AWS.SECRET.ACCESS.KEY} |<p>Secret access key.</p> |`` |
|{$AWS.PROXY} |<p>Sets HTTP proxy value. If this macro is empty then no proxy is used.</p> |`` |

## Template links

There are no template links in this template.

## Discovery rules

|Name|Description|Type|Key and additional info|
|----|-----------|----|----|
|Aurora metrics discovery |<p>Discovery Amazon Aurora metrics.</p><p>https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.AuroraMySQL.Monitoring.Metrics.html#Aurora.AuroraMySQL.Monitoring.Metrics.instances</p> |DEPENDENT |aws.rds.aurora.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `return JSON.stringify(value.includes('aurora') ? [{'{#SINGLETON}': ''}] : []); `</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Aurora MySQL metrics discovery |<p>Discovery Aurora MySQL metrics.</p><p>Storage types:</p><p> aurora (for MySQL 5.6-compatible Aurora)</p><p> aurora-mysql (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)</p> |DEPENDENT |aws.rds.postgresql.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Instance Alarms discovery |<p>Discovery instance alarms.</p> |DEPENDENT |aws.rds.alarms.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p><p>**Filter**:</p>AND <p>- {#ALARM_SERVICE_NAMESPACE} MATCHES_REGEX `{$AWS.RDS.LLD.FILTER.ALARM_SERVICE_NAMESPACE.MATCHES}`</p><p>- {#ALARM_SERVICE_NAMESPACE} NOT_MATCHES_REGEX `{$AWS.RDS.LLD.FILTER.ALARM_SERVICE_NAMESPACE.NOT_MATCHES}`</p><p>- {#ALARM_NAME} MATCHES_REGEX `{$AWS.RDS.LLD.FILTER.ALARM_NAME.MATCHES}`</p><p>- {#ALARM_NAME} NOT_MATCHES_REGEX `{$AWS.RDS.LLD.FILTER.ALARM_NAME.NOT_MATCHES}`</p> |
|Instance Events discovery |<p>Discovery instance events.</p> |DEPENDENT |aws.rds.events.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p><p>**Filter**:</p>AND <p>- {#EVENT_CATEGORY} MATCHES_REGEX `{$AWS.RDS.LLD.FILTER.EVENT_CATEGORY.MATCHES}`</p><p>- {#EVENT_CATEGORY} NOT_MATCHES_REGEX `{$AWS.RDS.LLD.FILTER.EVENT_CATEGORY.NOT_MATCHES}`</p><p>- {#EVENT_SOURCE_TYPE} MATCHES_REGEX `{$AWS.RDS.LLD.FILTER.EVENT_SOURCE_TYPE.MATCHES}`</p><p>- {#EVENT_SOURCE_TYPE} NOT_MATCHES_REGEX `{$AWS.RDS.LLD.FILTER.EVENT_SOURCE_TYPE.NOT_MATCHES}`</p> |
|PostgreSQL metrics discovery |<p>Discovery PostgreSQL metrics.</p><p>Storage types:</p><p> aurora-postgresql</p><p> postgres</p> |DEPENDENT |aws.rds.postgresql.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `return JSON.stringify(value.includes('postgresql') ? [{'{#SINGLETON}': ''}] : []); `</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |

## Items collected

|Group|Name|Description|Type|Key and additional info|
|-----|----|-----------|----|---------------------|
|AWS RDS |AWS RDS: Get metrics check |<p>Data collection check.</p> |DEPENDENT |aws.rds.metrics.check<p>**Preprocessing**:</p><p>- JSONPATH: `$.error`</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> `</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|AWS RDS |AWS RDS: Get instance info check |<p>Data collection check.</p> |DEPENDENT |aws.rds.instance_info.check<p>**Preprocessing**:</p><p>- JSONPATH: `$.error`</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> `</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|AWS RDS |AWS RDS: Get alarms check |<p>Data collection check.</p> |DEPENDENT |aws.rds.alarms.check<p>**Preprocessing**:</p><p>- JSONPATH: `$.error`</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> `</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|AWS RDS |AWS RDS: Get events check |<p>Data collection check.</p> |DEPENDENT |aws.rds.events.check<p>**Preprocessing**:</p><p>- JSONPATH: `$.error`</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> `</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|AWS RDS |AWS RDS: Class |<p>Contains the name of the compute and memory capacity class of the DB instance.</p> |DEPENDENT |aws.rds.class<p>**Preprocessing**:</p><p>- JSONPATH: `$[*].DBInstanceClass.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|AWS RDS |AWS RDS: Engine |<p>Database engine.</p> |DEPENDENT |aws.rds.engine<p>**Preprocessing**:</p><p>- JSONPATH: `$..Engine.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|AWS RDS |AWS RDS: Engine version |<p>Indicates the database engine version.</p> |DEPENDENT |aws.rds.engine.version<p>**Preprocessing**:</p><p>- JSONPATH: `$[*].EngineVersion.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|AWS RDS |AWS RDS: Status |<p>Specifies the current state of this database.</p><p>All possible status values and their description: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/accessing-monitoring.html#Overview.DBInstance.Status</p> |DEPENDENT |aws.rds.status<p>**Preprocessing**:</p><p>- JSONPATH: `$..DBInstanceStatus.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|AWS RDS |AWS RDS: Storage type |<p>Specifies the storage type associated with DB instance.</p> |DEPENDENT |aws.rds.storage_type<p>**Preprocessing**:</p><p>- JSONPATH: `$[*].StorageType.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|AWS RDS |AWS RDS: Create time |<p>Provides the date and time the DB instance was created.</p> |DEPENDENT |aws.rds.create_time<p>**Preprocessing**:</p><p>- JSONPATH: `$..InstanceCreateTime.first()`</p> |
|AWS RDS |AWS RDS: Storage: Allocated |<p>Specifies the allocated storage size specified in gibibytes (GiB).</p> |DEPENDENT |aws.rds.storage.allocated<p>**Preprocessing**:</p><p>- JSONPATH: `$[*].AllocatedStorage.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|AWS RDS |AWS RDS: Storage: Max allocated |<p>The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.</p><p>If limit is not specified returns -1.</p> |DEPENDENT |aws.rds.storage.max_allocated<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|AWS RDS |AWS RDS: Read replica: State |<p>The status of a read replica. If the instance isn't a read replica, this is blank.</p><p>Boolean value that is true if the instance is operating normally, or false if the instance is in an error state.</p> |DEPENDENT |aws.rds.read_replica_state<p>**Preprocessing**:</p><p>- JSONPATH: `$..StatusInfos..Normal.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>- BOOL_TO_DECIMAL</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|AWS RDS |AWS RDS: Read replica: Status |<p>The status of a read replica. If the instance isn't a read replica, this is blank.</p><p>Status of the DB instance. For a StatusType of read replica, the values can be replicating, replication stop point set, replication stop point reached, error, stopped, or terminated.</p> |DEPENDENT |aws.rds.read_replica_status<p>**Preprocessing**:</p><p>- JSONPATH: `$..StatusInfos..Status.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|AWS RDS |AWS RDS: Swap usage |<p>The amount of swap space used. </p><p>This metric is available for the Aurora PostgreSQL DB instance classes db.t3.medium, db.t3.large, db.r4.large, db.r4.xlarge, db.r5.large, db.r5.xlarge, db.r6g.large, and db.r6g.xlarge. </p><p>For Aurora MySQL, this metric applies only to db.t* DB instance classes.</p><p>This metric is not available for SQL Server.</p> |DEPENDENT |aws.rds.swap_usage<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "SwapUsage")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Disk: Write IOPS |<p>The number of write records generated per second. This is more or less the number of log records generated by the database. These do not correspond to 8K page writes, and do not correspond to network packets sent.</p> |DEPENDENT |aws.rds.write_iops.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "WriteIOPS")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Disk: Write latency |<p>The average amount of time taken per disk I/O operation.</p> |DEPENDENT |aws.rds.write_latency<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "WriteLatency")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Disk: Write throughput |<p>The average number of bytes written to persistent storage every second.</p> |DEPENDENT |aws.rds.write_throughput.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "WriteThroughput")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Network: Receive throughput |<p>The incoming (Receive) network traffic on the DB instance, including both customer database traffic and Amazon RDS traffic used for monitoring and replication.</p> |DEPENDENT |aws.rds.network_receive_throughput.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "NetworkReceiveThroughput")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Burst balance |<p>The percent of General Purpose SSD (gp2) burst-bucket I/O credits available.</p> |DEPENDENT |aws.rds.burst_balance<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "BurstBalance")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: CPU: Utilization |<p>The percentage of CPU utilization.</p> |DEPENDENT |aws.rds.cpu.utilization<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "CPUUtilization")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Credit CPU: Balance |<p>The number of CPU credits that an instance has accumulated, reported at 5-minute intervals.</p><p>You can use this metric to determine how long a DB instance can burst beyond its baseline performance level at a given rate.</p><p>When an instance is running, credits in the CPUCreditBalance don't expire. When the instance stops, the CPUCreditBalance does not persist, and all accrued credits are lost.</p><p>This metric applies only to db.t2.small and db.t2.medium instances for Aurora MySQL, and to db.t3 instances for Aurora PostgreSQL.</p> |DEPENDENT |aws.rds.cpu.credit_balance<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "CPUCreditBalance")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Credit CPU: Usage |<p>The number of CPU credits consumed during the specified period, reported at 5-minute intervals.</p><p>This metric measures the amount of time during which physical CPUs have been used for processing instructions by virtual CPUs allocated to the DB instance.</p><p>This metric applies only to db.t2.small and db.t2.medium instances for Aurora MySQL, and to db.t3 instances for Aurora PostgreSQL</p> |DEPENDENT |aws.rds.cpu.credit_usage<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "CPUCreditUsage")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Connections |<p>The number of client network connections to the database instance.</p><p>The number of database sessions can be higher than the metric value because the metric value doesn't include the following:</p><p>- Sessions that no longer have a network connection but which the database hasn't cleaned up</p><p>- Sessions created by the database engine for its own purposes</p><p>- Sessions created by the database engine's parallel execution capabilities</p><p>- Sessions created by the database engine job scheduler</p><p>- Amazon Aurora/RDS connections</p> |DEPENDENT |aws.rds.database_connections<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "DatabaseConnections")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Disk: Queue depth |<p>The number of outstanding read/write requests waiting to access the disk.</p> |DEPENDENT |aws.rds.disk_queue_depth<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "DiskQueueDepth")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: EBS: Byte balance |<p>The percentage of throughput credits remaining in the burst bucket of your RDS database. This metric is available for basic monitoring only.</p><p>To find the instance sizes that support this metric, see the instance sizes with an asterisk (*) in the EBS optimized by default table (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html#current) in Amazon RDS User Guide for Linux Instances.</p> |DEPENDENT |aws.rds.ebs_byte_balance<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "EBSByteBalance%")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: EBS: IO balance |<p>The percentage of I/O credits remaining in the burst bucket of your RDS database. This metric is available for basic monitoring only.</p><p>To find the instance sizes that support this metric, see the instance sizes with an asterisk (*) in the EBS optimized by default table (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html#current) in Amazon RDS User Guide for Linux Instances.</p> |DEPENDENT |aws.rds.ebs_io_balance<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "EBSIOBalance%")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Memory, freeable |<p>The amount of available random access memory.</p><p>For MariaDB, MySQL, Oracle, and PostgreSQL DB instances, this metric reports the value of the MemAvailable field of /proc/meminfo.</p> |DEPENDENT |aws.rds.freeable_memory<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "FreeableMemory")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Storage: Local free |<p>The amount of local storage available, in bytes.</p><p>Unlike for other DB engines, for Aurora DB instances this metric reports the amount of storage available to each DB instance. </p><p>This value depends on the DB instance class. You can increase the amount of free storage space for an instance by choosing a larger DB instance class for your instance.</p><p>(This doesn't apply to Aurora Serverless v2.)</p> |DEPENDENT |aws.rds.free_local_storage<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "FreeLocalStorage")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Network: Receive throughput |<p>The incoming (receive) network traffic on the DB instance, including both customer database traffic and Amazon RDS traffic used for monitoring and replication.</p><p>For Amazon Aurora: The amount of network throughput received from the Aurora storage subsystem by each instance in the DB cluster.</p> |DEPENDENT |aws.rds.storage_network_receive_throughput<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "StorageNetworkReceiveThroughput")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Network: Transmit throughput |<p>The outgoing (transmit) network traffic on the DB instance, including both customer database traffic and Amazon RDS traffic used for monitoring and replication.</p><p>For Amazon Aurora: The amount of network throughput sent to the Aurora storage subsystem by each instance in the Aurora MySQL DB cluster.</p> |DEPENDENT |aws.rds.storage_network_transmit_throughput<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "StorageNetworkTransmitThroughput")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Disk: Read IOPS |<p>The average number of disk I/O operations per second. Aurora PostgreSQL-Compatible Edition reports read and write IOPS separately, in 1-minute intervals.</p> |DEPENDENT |aws.rds.read_iops.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "ReadIOPS")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Disk: Read latency |<p>The average amount of time taken per disk I/O operation.</p> |DEPENDENT |aws.rds.read_latency<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "ReadLatency")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Disk: Read throughput |<p>The average number of bytes read from disk per second.</p> |DEPENDENT |aws.rds.read_throughput.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "ReadThroughput")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Network: Transmit throughput |<p>The outgoing (Transmit) network traffic on the DB instance, including both customer database traffic and Amazon RDS traffic used for monitoring and replication.</p> |DEPENDENT |aws.rds.network_transmit_throughput.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "NetworkTransmitThroughput")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Network: Throughput |<p>The amount of network throughput both received from and transmitted to clients by each instance in the Aurora MySQL DB cluster, in bytes per second. This throughput doesn't include network traffic between instances in the DB cluster and the cluster volume.</p> |DEPENDENT |aws.rds.network_throughput.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "NetworkThroughput")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Storage: Space free |<p>The amount of available storage space.</p> |DEPENDENT |aws.rds.free_storage_space<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "FreeStorageSpace")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Disk: Read IOPS, local storage |<p>The average number of disk read I/O operations to local storage per second. Only applies to Multi-AZ DB clusters.</p> |DEPENDENT |aws.rds.read_iops_local_storage.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "ReadIOPSLocalStorage")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Disk: Read latency, local storage |<p>The average amount of time taken per disk I/O operation for local storage. Only applies to Multi-AZ DB clusters.</p> |DEPENDENT |aws.rds.read_latency_local_storage<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "ReadLatencyLocalStorage")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Disk: Read throughput, local storage |<p>The average number of bytes read from disk per second for local storage. Only applies to Multi-AZ DB clusters.</p> |DEPENDENT |aws.rds.read_throughput_local_storage.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "ReadThroughputLocalStorage")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Replication: Lag |<p>The amount of time a read replica DB instance lags behind the source DB instance. Applies to MySQL, MariaDB, Oracle, PostgreSQL, and SQL Server read replicas.</p> |DEPENDENT |aws.rds.replica_lag<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "ReplicaLag")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Disk: Write IOPS, local storage |<p>The average number of disk write I/O operations per second on local storage in a Multi-AZ DB cluster.</p> |DEPENDENT |aws.rds.write_iops_local_storage.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "WriteIOPSLocalStorage")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Disk: Write latency, local storage |<p>The average amount of time taken per disk I/O operation on local storage in a Multi-AZ DB cluster.</p> |DEPENDENT |aws.rds.write_latency_local_storage<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "WriteLatencyLocalStorage")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Disk: Write throughput, local storage |<p>The average number of bytes written to disk per second for local storage.</p> |DEPENDENT |aws.rds.write_throughput_local_storage.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "WriteThroughputLocalStorage")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: SQLServer: Failed agent jobs |<p>The number of failed Microsoft SQL Server Agent jobs during the last minute.</p> |DEPENDENT |aws.rds.failed_sql_server_agent_jobs_count<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "FailedSQLServerAgentJobsCount")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Disk: Binlog Usage |<p>The amount of disk space occupied by binary logs on the master. Applies to MySQL read replicas.</p> |DEPENDENT |aws.rds.bin_log_disk_usage<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "BinLogDiskUsage")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS Alarms: ["{#ALARM_NAME}"]: State reason |<p>An explanation for the alarm state, in text format.</p><p>Alarm description:</p><p>{#ALARM_DESCRIPTION}</p> |DEPENDENT |aws.rds.alarm.state_reason["{#ALARM_NAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.AlarmName == "{#ALARM_NAME}")].StateReason.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|AWS RDS |AWS RDS Alarms: ["{#ALARM_NAME}"]: State |<p>The state value for the alarm. Possible values: 0 (OK), 1 (INSUFFICIENT_DATA), 2 (ALARM).</p><p>Alarm description:</p><p>{#ALARM_DESCRIPTION}</p> |DEPENDENT |aws.rds.alarm.state["{#ALARM_NAME}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.AlarmName == "{#ALARM_NAME}")].StateValue.first()`</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 3`</p><p>- JAVASCRIPT: `var state = ['OK', 'INSUFFICIENT_DATA', 'ALARM']; return state.indexOf(value.trim()) === -1 ? 255 : state.indexOf(value.trim()); `</p> |
|AWS RDS |AWS RDS: Replication: Lag, max |<p>The maximum amount of lag between the primary instance and each Aurora DB instance in the DB cluster.</p> |DEPENDENT |aws.rds.aurora_replica_lag.max[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "AuroraReplicaLagMaximum")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Replication: Lag, min |<p>The minimum amount of lag between the primary instance and each Aurora DB instance in the DB cluster.</p> |DEPENDENT |aws.rds.aurora_replica_lag.min[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "AuroraReplicaLagMinimum")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Replication: Lag |<p>For an Aurora replica, the amount of lag when replicating updates from the primary instance.</p> |DEPENDENT |aws.rds.aurora_replica_lag[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "AuroraReplicaLag")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Buffer Cache hit ratio |<p>The percentage of requests that are served by the buffer cache.</p> |DEPENDENT |aws.rds.buffer_cache_hit_ratio[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "BufferCacheHitRatio")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Operations: Commit latency |<p>The amount of latency for commit operations.</p> |DEPENDENT |aws.rds.commit_latency[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "CommitLatency")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Operations: Commit throughput |<p>The average number of commit operations per second.</p> |DEPENDENT |aws.rds.commit_throughput.rate[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "CommitThroughput")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Deadlocks, rate |<p>The average number of deadlocks in the database per second.</p> |DEPENDENT |aws.rds.deadlocks.rate[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "Deadlocks")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Engine uptime |<p>The amount of time that the instance has been running.</p> |DEPENDENT |aws.rds.engine_uptime[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "EngineUptime")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Rollback segment history list length |<p>The undo logs that record committed transactions with delete-marked records. These records are scheduled to be processed by the InnoDB purge operation.</p> |DEPENDENT |aws.rds.rollback_segment_history_list_length[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "RollbackSegmentHistoryListLength")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Network: Throughput |<p>The amount of network throughput received from and sent to the Aurora storage subsystem by each instance in the Aurora MySQL DB cluster.</p> |DEPENDENT |aws.rds.storage_network_throughput[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "StorageNetworkThroughput")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: RDS to Aurora PostgreSQL replicaLag |<p>The lag when replicating updates from the primary RDS PostgreSQL instance to other nodes in the cluster.</p> |DEPENDENT |aws.rds.rds_to_aurora_postgresql_replica_lag[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "RDSToAuroraPostgreSQLReplicaLag")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Maximum Used transaction ID |<p>The age of the oldest unvacuumed transaction ID, in transactions. If this value reaches 2,146,483,648 (2^31 - 1,000,000), the database is forced into read-only mode, to avoid transaction ID wraparound. </p> |DEPENDENT |aws.rds.maximum_used_transaction_ids[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "MaximumUsedTransactionIDs")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Disk: Replication slot usage |<p>The amount of disk space consumed by replication slot files.</p> |DEPENDENT |aws.rds.replication_slot_disk_usage[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "ReplicationSlotDiskUsage")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Checkpoint lag |<p>The amount of time since the most recent checkpoint. Applies to only RDS for PostgreSQL.</p> |DEPENDENT |aws.rds.checkpoint_lag[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "CheckpointLag")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Replication: Oldest slot lag |<p>The lagging size of the replica lagging the most in terms of write-ahead log (WAL) data received. Applies to PostgreSQL.</p> |DEPENDENT |aws.rds.oldest_replication_slot_lag[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "OldestReplicationSlotLag")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Transaction log: Disk usage |<p>The disk space used by transaction logs. Applies to PostgreSQL, primary for Aurora PostgreSQL.</p><p>By default, Aurora PostgreSQL uses log records, not transaction logs. When transaction logs aren't in use, the value for this metric is -1.</p> |DEPENDENT |aws.rds.transaction_logs_disk_usage[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "TransactionLogsDiskUsage")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Transaction log: Generation |<p>The size of transaction logs generated per second. Applies to PostgreSQL.</p> |DEPENDENT |aws.rds.transaction_logs_generation[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "TransactionLogsGeneration")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Operations: Delete latency |<p>The amount of latency for delete queries.</p> |DEPENDENT |aws.rds.delete_latency[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "DeleteLatency")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Operations: Delete throughput |<p>The average number of delete queries per second.</p> |DEPENDENT |aws.rds.delete_throughput.rate[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "DeleteThroughput")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: DML: Latency |<p>The amount of latency for inserts, updates, and deletes.</p> |DEPENDENT |aws.rds.dml_latency[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "DMLLatency")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: DML: Throughput |<p>The average number of inserts, updates, and deletes per second.</p> |DEPENDENT |aws.rds.dml_throughput.rate[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "DMLThroughput")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: DDL: Latency |<p>The amount of latency for data definition language (DDL) requests - for example, create, alter, and drop requests.</p> |DEPENDENT |aws.rds.ddl_latency[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "DDLLatency")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: DDL: Throughput |<p>The average number of DDL requests per second.</p> |DEPENDENT |aws.rds.ddl_throughput.rate[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "DDLThroughput")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Backtrack: Window, actual |<p>The difference between the target backtrack window and the actual backtrack window.</p> |DEPENDENT |aws.rds.backtrack_window_actual[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "BacktrackWindowActual")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Backtrack: Window, alert |<p>The number of times that the actual backtrack window is smaller than the target backtrack window for a given period of time.</p> |DEPENDENT |aws.rds.backtrack_window_alert[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "BacktrackWindowAlert")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Transactions: Blocked, rate |<p>The average number of transactions in the database that are blocked per second.</p> |DEPENDENT |aws.rds.blocked_transactions.rate[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "BlockedTransactions")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Row lock time |<p>The total time spent acquiring row locks for InnoDB tables.</p> |DEPENDENT |aws.rds.row_locktime[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "RowLockTime")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Operations: Select latency |<p>The amount of latency for select queries.</p> |DEPENDENT |aws.rds.select_latency[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "SelectLatency")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Operations: Select throughput |<p>The average number of select queries per second.</p> |DEPENDENT |aws.rds.select_throughput.rate[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "SelectThroughput")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Replication: Binlog lag |<p>The amount of time that a binary log replica DB cluster running on Aurora MySQL-Compatible Edition lags behind the binary log replication source. </p><p>A lag means that the source is generating records faster than the replica can apply them.</p><p>The metric value indicates the following:</p><p>A high value: The replica is lagging the replication source.</p><p>0 or a value close to 0: The replica process is active and current.</p><p>-1: Aurora can't determine the lag, which can happen during replica setup or when the replica is in an error state</p> |DEPENDENT |aws.rds.aurora_replication_binlog_lag[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "AuroraBinlogReplicaLag")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Transactions: Active, rate |<p>The average number of current transactions executing on an Aurora database instance per second.</p><p>By default, Aurora doesn't enable this metric. To begin measuring this value, set innodb_monitor_enable='all' in the DB parameter group for a specific DB instance.</p> |DEPENDENT |aws.rds.aurora_transactions_active.rate[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "ActiveTransactions")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Connections: Aborted |<p>The number of client connections that have not been closed properly.</p> |DEPENDENT |aws.rds.aurora_clients_aborted[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "AbortedClients")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Operations: Insert latency |<p>The amount of latency for insert queries, in milliseconds.</p> |DEPENDENT |aws.rds.insert_latency[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "InsertLatency")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Operations: Insert throughput |<p>The average number of insert queries per second.</p> |DEPENDENT |aws.rds.insert_throughput.rate[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "InsertThroughput")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Login failures, rate |<p>The average number of failed login attempts per second.</p> |DEPENDENT |aws.rds.login_failures.rate[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "LoginFailures")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Queries, rate |<p>The average number of queries executed per second.</p> |DEPENDENT |aws.rds.queries.rate[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "Queries")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Resultset cache hit ratio |<p>The percentage of requests that are served by the Resultset cache.</p> |DEPENDENT |aws.rds.result_set_cache_hit_ratio[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "ResultSetCacheHitRatio")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Binary log files, number |<p>The number of binlog files generated.</p> |DEPENDENT |aws.rds.num_binary_log_files[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "NumBinaryLogFiles")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Binary log files, size |<p>The total size of the binlog files.</p> |DEPENDENT |aws.rds.sum_binary_log_files[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "SumBinaryLogSize")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Operations: Update latency |<p>The amount of latency for update queries.</p> |DEPENDENT |aws.rds.update_latency[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "UpdateLatency")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS: Operations: Update throughput |<p>The average number of update queries per second.</p> |DEPENDENT |aws.rds.update_throughput.rate[{#SINGLETON}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.Label == "UpdateThroughput")].Values.first().first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|AWS RDS |AWS RDS Events: [{#EVENT_CATEGORY}]: {#EVENT_SOURCE_TYPE}/{#EVENT_SOURCE_ID}: Message |<p>Provides the text of this event.</p> |DEPENDENT |aws.rds.event_message["{#EVENT_CATEGORY}/{#EVENT_SOURCE_TYPE}/{#EVENT_SOURCE_ID}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.SourceIdentifier == "{#EVENT_SOURCE_ID}" && @.SourceType == "{#EVENT_SOURCE_TYPE}" && @.EventCategories == "{#EVENT_CATEGORY}")].Message`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>- JSONPATH: `$[-1]`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|AWS RDS |AWS RDS Events: [{#EVENT_CATEGORY}]: {#EVENT_SOURCE_TYPE}/{#EVENT_SOURCE_ID} : Date |<p>Provides the text of this event.</p> |DEPENDENT |aws.rds.event_date["{#EVENT_CATEGORY}/{#EVENT_SOURCE_TYPE}/{#EVENT_SOURCE_ID}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$.[?(@.SourceIdentifier == "{#EVENT_SOURCE_ID}" && @.SourceType == "{#EVENT_SOURCE_TYPE}" && @.EventCategories == "{#EVENT_CATEGORY}")].Date`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>- JSONPATH: `$[-1]`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|Zabbix raw items |AWS RDS: Get metrics data |<p>Get instance metrics.</p><p>Full metrics list related to RDS: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-metrics.html</p><p>Full metrics list related to Amazon Aurora: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.AuroraMySQL.Monitoring.Metrics.html#Aurora.AuroraMySQL.Monitoring.Metrics.instances</p> |SCRIPT |aws.rds.get_metrics<p>**Preprocessing**:</p><p>- CHECK_NOT_SUPPORTED</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>**Expression**:</p>`The text is too long. Please see the template.` |
|Zabbix raw items |AWS RDS: Get instance info |<p>Get instance info.</p><p>DescribeDBInstances API method: https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html</p> |SCRIPT |aws.rds.get_instance_info<p>**Preprocessing**:</p><p>- CHECK_NOT_SUPPORTED</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>**Expression**:</p>`The text is too long. Please see the template.` |
|Zabbix raw items |AWS CloudWatch: Get instance alarms data |<p>DescribeAlarms API method: https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html</p> |SCRIPT |aws.rds.get_alarms<p>**Preprocessing**:</p><p>- CHECK_NOT_SUPPORTED</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>**Expression**:</p>`The text is too long. Please see the template.` |
|Zabbix raw items |AWS RDS: Get instance events data |<p>DescribeEvents API method: https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeEvents.html</p> |SCRIPT |aws.rds.get_events<p>**Preprocessing**:</p><p>- CHECK_NOT_SUPPORTED</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>**Expression**:</p>`The text is too long. Please see the template.` |

## Triggers

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----|----|----|
|AWS RDS: Failed to get metrics data |<p>-</p> |`length(last(/AWS RDS instance by HTTP/aws.rds.metrics.check))>0` |WARNING | |
|AWS RDS: Failed to get instance data |<p>-</p> |`length(last(/AWS RDS instance by HTTP/aws.rds.instance_info.check))>0` |WARNING | |
|AWS RDS: Failed to get alarms data |<p>-</p> |`length(last(/AWS RDS instance by HTTP/aws.rds.alarms.check))>0` |WARNING | |
|AWS RDS: Failed to get events data |<p>-</p> |`length(last(/AWS RDS instance by HTTP/aws.rds.events.check))>0` |WARNING | |
|AWS RDS: Read replica in error state  |<p>The status of a read replica.</p><p>False if the instance is in an error state.</p> |`last(/AWS RDS instance by HTTP/aws.rds.read_replica_state)=0` |AVERAGE | |
|AWS RDS: Burst balance is too low |<p>-</p> |`max(/AWS RDS instance by HTTP/aws.rds.burst_balance,5m)<{$AWS.RDS.BURST.CREDIT.BALANCE.MIN.WARN}` |WARNING | |
|AWS RDS: High CPU utilization |<p>CPU utilization is too high. The system might be slow to respond.</p> |`min(/AWS RDS instance by HTTP/aws.rds.cpu.utilization,15m)>{$AWS.RDS.CPU.UTIL.WARN.MAX}` |WARNING | |
|AWS RDS: Instance CPU Credit balance is too low |<p>The number of earned CPU credits has been less than {$AWS.RDS.CPU.CREDIT.BALANCE.MIN.WARN} in the last 5 minutes.</p> |`max(/AWS RDS instance by HTTP/aws.rds.cpu.credit_balance,5m)<{$AWS.RDS.CPU.CREDIT.BALANCE.MIN.WARN}` |WARNING | |
|AWS RDS: Byte Credit balance is too low |<p>-</p> |`max(/AWS RDS instance by HTTP/aws.rds.ebs_byte_balance,5m)<{$AWS.EBS.BYTE.CREDIT.BALANCE.MIN.WARN}` |WARNING | |
|AWS RDS: I/O Credit balance is too low |<p>-</p> |`max(/AWS RDS instance by HTTP/aws.rds.ebs_io_balance,5m)<{$AWS.EBS.IO.CREDIT.BALANCE.MIN.WARN}` |WARNING | |
|AWS RDS Alarms: "{#ALARM_NAME}" has 'Alarm' state |<p>Alarm "{#ALARM_NAME}" has 'Alarm' state. </p><p>Reason: {ITEM.LASTVALUE2}</p> |`last(/AWS RDS instance by HTTP/aws.rds.alarm.state["{#ALARM_NAME}"])=2 and length(last(/AWS RDS instance by HTTP/aws.rds.alarm.state_reason["{#ALARM_NAME}"]))>0` |AVERAGE | |
|AWS RDS Alarms: "{#ALARM_NAME}" has 'Insufficient data' state |<p>-</p> |`last(/AWS RDS instance by HTTP/aws.rds.alarm.state["{#ALARM_NAME}"])=1` |INFO | |

## Feedback

Please report any issues with the template at https://support.zabbix.com

You can also provide feedback, discuss the template or ask for help with it at [ZABBIX forums](https://www.zabbix.com/forum/zabbix-suggestions-and-feedback).

