/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto;

import net.lingala.zip4j.crypto.Decrypter;
import net.lingala.zip4j.crypto.engine.ZipCryptoEngine;
import net.lingala.zip4j.exception.ZipException;

public class StandardDecrypter
implements Decrypter {
    private char[] password;
    private byte[] crcBytes;
    private byte[] crc = new byte[4];
    private ZipCryptoEngine zipCryptoEngine;

    public StandardDecrypter(char[] password, byte[] crcBytes, byte[] headerBytes) throws ZipException {
        this.password = password;
        this.crcBytes = crcBytes;
        this.zipCryptoEngine = new ZipCryptoEngine();
        this.init(headerBytes);
    }

    @Override
    public int decryptData(byte[] buff, int start, int len) throws ZipException {
        if (start < 0 || len < 0) {
            throw new ZipException("one of the input parameters were null in standard decrypt data");
        }
        for (int i = start; i < start + len; ++i) {
            int val = buff[i] & 0xFF;
            val = (val ^ this.zipCryptoEngine.decryptByte()) & 0xFF;
            this.zipCryptoEngine.updateKeys((byte)val);
            buff[i] = (byte)val;
        }
        return len;
    }

    private void init(byte[] headerBytes) throws ZipException {
        this.crc[3] = (byte)(this.crcBytes[3] & 0xFF);
        this.crc[2] = (byte)(this.crcBytes[3] >> 8 & 0xFF);
        this.crc[1] = (byte)(this.crcBytes[3] >> 16 & 0xFF);
        this.crc[0] = (byte)(this.crcBytes[3] >> 24 & 0xFF);
        if (this.crc[2] > 0 || this.crc[1] > 0 || this.crc[0] > 0) {
            throw new IllegalStateException("Invalid CRC in File Header");
        }
        if (this.password == null || this.password.length <= 0) {
            throw new ZipException("Wrong password!", ZipException.Type.WRONG_PASSWORD);
        }
        this.zipCryptoEngine.initKeys(this.password);
        byte result = headerBytes[0];
        for (int i = 0; i < 12; ++i) {
            this.zipCryptoEngine.updateKeys((byte)(result ^ this.zipCryptoEngine.decryptByte()));
            if (i + 1 == 12) continue;
            result = headerBytes[i + 1];
        }
    }
}

