
package ONVIF::Media::Elements::SetAudioSourceConfiguration;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://www.onvif.org/ver10/media/wsdl' }

__PACKAGE__->__set_name('SetAudioSourceConfiguration');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Configuration_of :ATTR(:get<Configuration>);
my %ForcePersistence_of :ATTR(:get<ForcePersistence>);

__PACKAGE__->_factory(
    [ qw(        Configuration
        ForcePersistence

    ) ],
    {
        'Configuration' => \%Configuration_of,
        'ForcePersistence' => \%ForcePersistence_of,
    },
    {
        'Configuration' => 'ONVIF::Media::Types::AudioSourceConfiguration',
        'ForcePersistence' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
    },
    {

        'Configuration' => 'Configuration',
        'ForcePersistence' => 'ForcePersistence',
    }
);

} # end BLOCK







} # end of BLOCK



1;


=pod

=head1 NAME

ONVIF::Media::Elements::SetAudioSourceConfiguration

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
SetAudioSourceConfiguration from the namespace http://www.onvif.org/ver10/media/wsdl.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Configuration

 $element->set_Configuration($data);
 $element->get_Configuration();




=item * ForcePersistence

 $element->set_ForcePersistence($data);
 $element->get_ForcePersistence();





=back


=head1 METHODS

=head2 new

 my $element = ONVIF::Media::Elements::SetAudioSourceConfiguration->new($data);

Constructor. The following data structure may be passed to new():

 {
   Configuration =>  { # ONVIF::Media::Types::AudioSourceConfiguration
     SourceToken => $some_value, # ReferenceToken
   },
   ForcePersistence =>  $some_value, # boolean
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

