#pragma once

/*
 * Do not edit this file unless you know *exactly* what you are doing.
 *
 * Some of the values in this file were chosen to preserve game balance,
 * while others are hard-coded based on the format of old save-files, the
 * definition of arrays in various places, mathematical properties, fast
 * computation, storage limits, or the format of external text files.
 *
 * Changing some of these values will induce crashes or memory errors or
 * savefile mis-reads.  Most of the comments in this file are meant as
 * reminders, not complete descriptions, and even a complete knowledge
 * of the source may not be sufficient to fully understand the effects
 * of changing certain definitions.
 *
 * Lastly, note that the code does not always use the symbolic constants
 * below, and sometimes uses various hard-coded values that may not even
 * be defined in this file, but which may be related to definitions here.
 * This is of course bad programming practice, but nobody is perfect...
 *
 * For example, there are MANY things that depend on the screen being
 * 80x24, with the top line used for messages, the bottom line being
 * used for status, and exactly 22 lines used to show the dungeon.
 * Just because your screen can hold 46 lines does not mean that the
 * game will work if you try to use 44 lines to show the dungeon.
 *
 * You have been warned.
 */


/*
 * Release state, CVS or not, remember to switch it when making releases
 */

#ifndef IS_CVS
/* #define IS_CVS          " (ah)" */
#define IS_CVS          " (ah, git)"
#endif

#define USER_PATH_VERSION "/2.4"

#define SAVEFILE_VERSION 105

/*
 * Maximum amount of Angband windows.
 */
#define ANGBAND_TERM_MAX 8

/*
 * Number of grids in each block (vertically)
 * Probably hard-coded to 11, see "generate.c"
 */
#define BLOCK_HGT	11

/*
 * Number of grids in each block (horizontally)
 * Probably hard-coded to 11, see "generate.c"
 */
#define BLOCK_WID	11


/*
 * Number of grids in each panel (vertically)
 * Must be a multiple of BLOCK_HGT
 */
#define PANEL_HGT	11

/*
 * Number of grids in each panel (horizontally)
 * Must be a multiple of BLOCK_WID
 */
#define PANEL_WID	33


/*
 * Number of grids used to display the dungeon (vertically).
 * Must be a multiple of 11, probably hard-coded to 22.
 */
#define SCREEN_HGT      22

/*
 * Number of grids used to display the dungeon (horizontally).
 * Must be a multiple of 33, probably hard-coded to 66.
 */
#define SCREEN_WID      66


/*
 * Maximum dungeon height in grids, must be a multiple of SCREEN_HGT,
 * probably hard-coded to SCREEN_HGT * 3.
 */
#define MAX_HGT         66

/*
 * Maximum dungeon width in grids, must be a multiple of SCREEN_WID,
 * probably hard-coded to SCREEN_WID * 3.
 */
#define MAX_WID         198

/* Used only in object3.c / trap effects */
#if ((MAX_HGT / SCREEN_HGT) < (MAX_WID / SCREEN_WID))
 #define RATIO (MAX_WID / SCREEN_WID)
#else
 #define RATIO (MAX_HGT / SCREEN_HGT)
#endif

/*
 * Default radius of detection spells
 * Its area must be at least as large as SCREEN_WID * SCREEN_HGT
 */
#define DEFAULT_RADIUS	25

#define MAX_SPELLS          100
#define MAX_RUNES           100

/*
 * Total number of monster powers
 */
#define MONSTER_POWERS_MAX 96

/*
 * Total number of stores (see "store.c", etc)
 */
#define STORE_GENERAL   0
#define STORE_HOME      7

/* Number of Random Artifacts */
#define MAX_RANDARTS 84
#define MAX_T_ACT    51


/* bear barehanded attacks      ... */
#define MAX_BEAR        8

/* Monk martial arts... */
#define MAX_MA          17

#define MA_KNEE         0x0001
#define MA_SLOW         0x0002
#define MA_WOUND        0x0004
#define MA_STUN         0x0008
#define MA_FULL_SLOW    0x0010

/* Mindcraft */
#define MAX_MINDCRAFT_POWERS  11

/* Necromancy */
#define MAX_NECRO_POWERS  6

/* Mimicry */
#define MAX_MIMIC_POWERS  5
#define MIMIC_FORMS_MAX 14

/* Symbiosis */
#define MAX_SYMBIOTIC_POWERS  9


/* A hack for cave.c */
#define BMP_FIRST_PC_CLASS 164
#define BMP_FIRST_PC_RACE 128


/*
 * Maximum dungeon level.  The player can never reach this level
 * in the dungeon, and this value is used for various calculations
 * involving object and monster creation.  It must be at least 100.
 * Setting it below 128 may prevent the creation of some objects.
 */
#define MAX_DEPTH               128
#define MAX_DEPTH_MONSTER       200


/*
 * Maximum size of the "lite" array (see "cave.c")
 * Note that the "lite radius" will NEVER exceed 5, and even if the "lite"
 * was rectangular, we would never require more than 128 entries in the array.
 */
#define LITE_MAX 1536

/*
 * Maximum size of the "view" array (see "cave.c")
 * Note that the "view radius" will NEVER exceed 20, and even if the "view"
 * was octagonal, we would never require more than 1520 entries in the array.
 */
#define VIEW_MAX 1536

/*
 * Maximum size of the "temp" array (see "cave.c")
 * We must be as large as "VIEW_MAX" and "LITE_MAX" for proper functioning
 * of "update_view()" and "update_lite()".  We must also be as large as the
 * largest illuminatable room, but no room is larger than 800 grids.  We
 * must also be large enough to allow "good enough" use as a circular queue,
 * to calculate monster flow, but note that the flow code is "paranoid".
 */
#define TEMP_MAX 16384


/*
 * Number of keymap modes
 */
#define KEYMAP_MODES	2

/*
 * Mode for original keyset commands
 */
#define KEYMAP_MODE_ORIG	0

/*
 * Mode for roguelike keyset commands
 */
#define KEYMAP_MODE_ROGUE	1


/*
 * OPTION: Maximum number of macros (see "io.c")
 * Default: assume at most 256 macros are used
 */
#define MACRO_MAX       256

/*
 * Maximum value storable in a "byte" (hard-coded)
 */
#define MAX_UCHAR       255

/*
 * Maximum value storable in a "s16b" (hard-coded)
 */
#define MAX_SHORT       32767


/*
 * Store constants
 */
#define STORE_INVEN_MAX 255             /* Max number of discrete objs in inven */
#define STORE_OBJ_LEVEL 5               /* Magic Level for normal stores */
#define STORE_TURNOVER  9               /* Normal shop turnover, per day */
#define STORE_MIN_KEEP  6               /* Min slots to "always" keep full */
#define STORE_MAX_KEEP  18              /* Max slots to "always" keep full */
#define STORE_SHUFFLE   21              /* 1/Chance (per day) of an owner changing */
#define STORE_TURNS             1000    /* Number of turns between turnovers */

/*
 * Misc constants
 */
#define DAY                     11520                   /* Number of turns per day */
#define YEAR                    (DAY * 365)             /* Number of turns per year */
#define HOUR                    (DAY / 24)              /* Number of turns per hour */
#define MINUTE                  (HOUR / 60)             /* Number of turns per minute */
#define DAY_START               (HOUR * 6)              /* Sunrise */

#define BREAK_GLYPH             550             /* Rune of protection resistance */
#define BREAK_MINOR_GLYPH       99             /* For explosive runes */
#define BTH_PLUS_ADJ    3       /* Adjust BTH per plus-to-hit */
#define MON_MULT_ADJ    10              /* High value slows multiplication */
#define MON_SUMMON_ADJ  2               /* Adjust level of summoned creatures */
#define MON_DRAIN_LIFE  2               /* Percent of player exp drained per hit */
#define USE_DEVICE      3               /* x> Harder devices x< Easier devices     */

#define BIAS_ELEC 1                     /* "Biases" for random artifact gen */
#define BIAS_POIS 2
#define BIAS_FIRE 3
#define BIAS_COLD 4
#define BIAS_ACID 5
#define BIAS_STR 6
#define BIAS_INT 7
#define BIAS_WIS 8
#define BIAS_DEX 9
#define BIAS_CON 10
#define BIAS_CHR 11
#define BIAS_CHAOS 12
#define BIAS_PRIESTLY 13
#define BIAS_NECROMANTIC 14
#define BIAS_LAW 15
#define BIAS_ROGUE 16
#define BIAS_MAGE 17
#define BIAS_WARRIOR 18
#define BIAS_RANGER 19

/*
 * Location of objects when they were found
 */
#define OBJ_FOUND_MONSTER       1
#define OBJ_FOUND_FLOOR         2
#define OBJ_FOUND_VAULT         3
#define OBJ_FOUND_SPECIAL       4
#define OBJ_FOUND_RUBBLE        5
#define OBJ_FOUND_REWARD        6
#define OBJ_FOUND_STORE         7
#define OBJ_FOUND_STOLEN        8
#define OBJ_FOUND_SELFMADE      9
/*
 * There is a 1/20 (5%) chance of inflating the requested object_level
 * during the creation of an object (see "get_obj_num()" in "object.c").
 * Lower values yield better objects more often.
 */
#define GREAT_OBJ       20

#define GREAT_EGO       20

/*
 * There is a 1/50 (2%) chance of inflating the requested monster_level
 * during the creation of a monsters (see "get_mon_num()" in "monster.c").
 * Lower values yield harder monsters more often.
 */
#define NASTY_MON       50              /* 1/chance of inflated monster level */


/*
 * Refueling constants
 */
#define FUEL_TORCH      5000    /* Maximum amount of fuel in a torch */
#define FUEL_LAMP       15000   /* Maximum amount of fuel in a lantern */


/*
 * More maximum values
 */
#define MAX_SIGHT       20      /* Maximum view distance */
#define MAX_RANGE       18      /* Maximum range (spells, etc) */



/*
 * The town starts out with 4 residents during the day
 */
#define MIN_M_ALLOC_TD          4

/*
 * The town starts out with 8 residents during the night
 */
#define MIN_M_ALLOC_TN          8


/*
 * A monster can only "multiply" (reproduce) if there are fewer than 100
 * monsters on the level capable of such spontaneous reproduction.  This
 * is a hack which prevents the "m_list[]" array from exploding due to
 * reproducing monsters.  Messy, but necessary.
 */
#define MAX_REPRO       100


/*
 * Player constants
 */
#define SUBRACE_SAVE    9               /* Ugly hack, should be in foo-info, the subrace saved to the savefile */
#define PY_MAX_EXP      99999999L       /* Maximum exp */
#define PY_MAX_GOLD     999999999L      /* Maximum gold */

/*
 * Player "food" crucial values
 */
#define PY_FOOD_MAX             15000   /* Food value (Bloated) */
#define PY_FOOD_FULL    10000   /* Food value (Normal) */
#define PY_FOOD_ALERT   2000    /* Food value (Hungry) */
#define PY_FOOD_WEAK    1000    /* Food value (Weak) */
#define PY_FOOD_FAINT   500             /* Food value (Fainting) */
#define PY_FOOD_STARVE  100             /* Food value (Starving) */

/*
 * Player regeneration constants
 */
#define PY_REGEN_NORMAL         197             /* Regen factor*2^16 when full */
#define PY_REGEN_WEAK           98              /* Regen factor*2^16 when weak */
#define PY_REGEN_FAINT          33              /* Regen factor*2^16 when fainting */
#define PY_REGEN_HPBASE         1442    /* Min amount hp regen*2^16 */
#define PY_REGEN_MNBASE         524             /* Min amount mana regen*2^16 */

/*
 * A "stack" of items is limited to less than 100 items (hard-coded).
 */
#define MAX_STACK_SIZE                  100


#define MKEY_MINDCRAFT          2
#define MKEY_ANTIMAGIC          3
#define MKEY_MIMIC              6
#define MKEY_NECRO              7
#define MKEY_POWER_MAGE         8
#define MKEY_FORGING            10
#define MKEY_INCARNATION        11
#define MKEY_SUMMON             13
#define MKEY_STEAL              15
#define MKEY_DODGE              16
#define MKEY_SCHOOL             17
#define MKEY_LEARN              18
#define MKEY_COPY               19
#define MKEY_SYMBIOTIC          20
#define MKEY_BOULDER            21
#define MKEY_COMPANION          22
#define MKEY_PIERCING           23
#define MKEY_DEATH_TOUCH        100
#define MKEY_GEOMANCY           101
#define MKEY_REACH_ATTACK       102


/*** Screen Locations ***/

/*
 * Some screen locations for various display routines
 * Currently, row 8 and 15 are the only "blank" rows.
 * That leaves a "border" around the "stat" values.
 */

#define ROW_MAP                 1
#define COL_MAP                 13		/* Dungeon map */

#define ROW_RACE                1
#define COL_RACE                0       /* <race name> */

#define ROW_CLASS               2
#define COL_CLASS               0       /* <class name> */

#define ROW_TITLE               3
#define COL_TITLE               0       /* <title> or <mode> */

#define ROW_LEVEL               4
#define COL_LEVEL               0       /* "LEVEL xxxxxx" */

#define ROW_EXP                 5
#define COL_EXP                 0       /* "EXP xxxxxxxx" */

#define ROW_GOLD                6
#define COL_GOLD                0       /* "AU xxxxxxxxx" */

#define ROW_STAT                8
#define COL_STAT                0       /* "xxx   xxxxxx" */

#define ROW_AC                  14
#define COL_AC                  0       /* "Cur AC xxxxx" */

#define ROW_HP                  15
#define COL_HP                  0       /* "HP xxxxx/xxxxx" */

#define ROW_SANITY              16      /* "Sanity  100%" */
#define COL_SANITY              0

#define ROW_SP                  17
#define COL_SP                  0       /* "SP xxxxx/xxxxx" */

#define ROW_PIETY               18
#define COL_PIETY               0       /* "Pt xxxxx/xxxxx" */

#define ROW_MH                  19
#define COL_MH                  0       /* "MH xxxxx/xxxxx" */



/*** Terrain Feature Indexes (see "lib/edit/f_info.txt") ***/

/* Nothing */
#define FEAT_NONE               0x00

/* Basic features */
#define FEAT_FLOOR              0x01
#define FEAT_FOUNTAIN           0x02
#define FEAT_GLYPH              0x03
#define FEAT_OPEN               0x04
#define FEAT_BROKEN             0x05
#define FEAT_LESS               0x06
#define FEAT_MORE               0x07

/* Quest features -KMW- */
#define FEAT_QUEST_ENTER        0x08
#define FEAT_QUEST_EXIT         0x09
#define FEAT_QUEST_DOWN         0x0A
#define FEAT_QUEST_UP           0x0B

/* Shafts -GSN- */
#define FEAT_SHAFT_DOWN         0x0D
#define FEAT_SHAFT_UP           0x0E

/* Basic feature */
#define FEAT_EMPTY_FOUNTAIN     0x0F

/* Feature 0x10 -- web */

/* Features 0x12 - 0x1F -- unused */

/* Doors */
#define FEAT_DOOR_HEAD          0x20
#define FEAT_DOOR_TAIL          0x2F

/* Extra */
#define FEAT_SECRET             0x30
#define FEAT_RUBBLE             0x31

/* Seams */
#define FEAT_MAGMA              0x32
#define FEAT_QUARTZ             0x33
#define FEAT_MAGMA_H            0x34
#define FEAT_QUARTZ_H           0x35
#define FEAT_MAGMA_K            0x36
#define FEAT_QUARTZ_K           0x37

/* Walls */
#define FEAT_WALL_EXTRA         0x38
#define FEAT_WALL_INNER         0x39
#define FEAT_WALL_OUTER         0x3A
#define FEAT_WALL_SOLID         0x3B
#define FEAT_PERM_EXTRA         0x3C
#define FEAT_PERM_INNER         0x3D
#define FEAT_PERM_OUTER         0x3E
#define FEAT_PERM_SOLID         0x3F

/* Explosive rune */
#define FEAT_MINOR_GLYPH        0x40

/* Shops */
#define FEAT_SHOP               0x4A

/* Permanent walls for quests */
#define FEAT_QUEST1             0x4B

/* Features 0x4F - 0x53 -- unused */

/* Additional terrains */
#define FEAT_SHAL_WATER         0x54
#define FEAT_DEEP_LAVA          0x55
#define FEAT_SHAL_LAVA          0x56
#define FEAT_DARK_PIT           0x57
#define FEAT_DIRT               0x58
#define FEAT_GRASS              0x59
#define FEAT_ICE                0x5A
#define FEAT_SAND               0x5B
#define FEAT_DEAD_TREE          0x5C
#define FEAT_DEAD_SMALL_TREE    212
#define FEAT_ASH                0x5D
#define FEAT_MUD                0x5E
#define FEAT_ICE_WALL           0x5F
#define FEAT_TREES              0x60
#define FEAT_MOUNTAIN           0x61
#define FEAT_SANDWALL           0x62
#define FEAT_SANDWALL_H         0x63
#define FEAT_SANDWALL_K         0x64
/* Feature 0x65 -- high mountain chain */
/* Feature 0x66 -- nether mist */

/* Features 0x67 - 0x9F -- unused */

#define FEAT_BETWEEN            0xA0 /* 160 */

/* Altars */
#define FEAT_ALTAR_HEAD         0xA1 /* 161 */
#define FEAT_ALTAR_TAIL         0xAB /* 171 */

#define FEAT_MARKER             0xAC /* 172 */
/* Feature 0xAD -- Underground Tunnel */
#define FEAT_TAINTED_WATER      0xAE /* 174 */
#define FEAT_BETWEEN2           0xB0 /* 176 */
#define FEAT_LAVA_WALL          0xB1 /* 177 */
#define FEAT_GREAT_FIRE         0xB2 /* 178 */
#define FEAT_WAY_MORE           0xB3 /* 179 */
#define FEAT_WAY_LESS           0xB4 /* 180 */
/* Feature 0xB5 -- field */
#define FEAT_EKKAIA             0xB6 /* 182 */

/* Features 0xB7 - 0xBA -- unused */

#define FEAT_DEEP_WATER         0xBB /* 187 */
#define FEAT_GLASS_WALL         0xBC /* 188 */
#define FEAT_ILLUS_WALL         0xBD /* 189 */
/* Feature 0xBE -- grass roof */
/* Feature 0xBF -- grass roof top */
/* Feature 0xC0 -- grass roof chimney */
/* Feature 0xC1 -- brick roof */
/* Feature 0xC2 -- brick roof top */
/* Feature 0xC3 -- brick roof chimney */
/* Feature 0xC4 -- window */
/* Feature 0xC5 -- small window */
/* Feature 0xC6 -- rain barrel */
#define FEAT_FLOWER             0xC7 /* 199 */
/* Feature 0xC8 -- cobblestone road */
/* Feature 0xC9 -- cobblestone with outlet */
#define FEAT_SMALL_TREES        0xCA /* 202 */
#define FEAT_TOWN               0xCB /* 203 */
/* Feature 0xCC -- Underground Tunnel */
#define FEAT_FIRE               0xCD /* 205 */
/* Feature 0xCE -- pile of rubble (permanent) */

/* Features 0xCF - 0xFF -- unused */


#define MAX_BETWEEN_EXITS       3

/*
 * Maximum number of school spells
 */
#define SCHOOL_SPELLS_MAX 200

/*
 * Maximum number of spell schools
 */
#define SCHOOLS_MAX 50

/*
 * Number of effects
 */
#define MAX_EFFECTS             128
#define EFF_WAVE                0x00000001      /* A circle whose radius increase */
#define EFF_LAST                0x00000002      /* The wave lasts */
#define EFF_STORM               0x00000004      /* The area follows the player */
#define EFF_DIR1                0x00000008      /* Directed effect */
#define EFF_DIR2                0x00000010      /* Directed effect */
#define EFF_DIR3                0x00000020      /* Directed effect */
#define EFF_DIR4                0x00000040      /* Directed effect */
#define EFF_DIR6                0x00000080      /* Directed effect */
#define EFF_DIR7                0x00000100      /* Directed effect */
#define EFF_DIR8                0x00000200      /* Directed effect */
#define EFF_DIR9                0x00000400      /* Directed effect */

/*** Artifact indexes (see "lib/edit/a_info.txt") ***/

#define ART_ANCHOR                      14
#define ART_POWER                       13
#define ART_MORGOTH                     34
#define ART_NARSIL              164
#define ART_GLAMDRING           73
#define ART_ANDURIL                     83
#define ART_GROND                       111

/* Spell for various object */
#define SPELL_ID_PLAIN          1
#define SPELL_BO_FIRE           2
#define SPELL_BO_COLD           3
#define SPELL_BO_ELEC           4
#define SPELL_BO_POIS           5
#define SPELL_BO_ACID           6
#define SPELL_MAPPING           7
#define SPELL_CURE              8
#define SPELL_ID_FULL           9
#define SPELL_WRAITH            10
#define SPELL_INVIS             11


/*** Ego-Item indexes (see "lib/edit/e_info.txt") ***/

#define EGO_MANA                1
#define EGO_POWER               2
#define EGO_MANA_POWER          3
#define EGO_BRAND_POIS          77
#define EGO_BRAND_ELEC          74
#define EGO_BRAND_FIRE          75
#define EGO_BRAND_COLD          76
#define EGO_BRAND_ACID          73
#define EGO_EARTHQUAKES         80
#define EGO_BLESS_BLADE         67
#define EGO_VAMPIRIC            97
#define EGO_CHAOTIC             78
#define EGO_BLASTED             127
#define EGO_SHATTERED           126
#define EGO_FLAME               122
#define EGO_FROST               123
#define EGO_LIGHTNING_BOLT      121
#define EGO_FREE_ACTION         49
#define EGO_DF                  66
#define EGO_MOTION              59
#define EGO_SPECTRAL            102
#define EGO_NOLDOR              23
#define EGO_JUMP                15
#define EGO_SPINING             72
#define EGO_DRAGON              99
#define EGO_INST_DRAGONKIND     130
#define EGO_ENDURE_ELEC         17
#define EGO_ENDURE_ACID         16
#define EGO_ENDURE_FIRE         18
#define EGO_ENDURE_COLD         19
#define EGO_QUIET               58
#define EGO_WISDOM              25
#define EGO_RESIST_ELEC         6
#define EGO_RESIST_ACID         5
#define EGO_RESIST_FIRE         7
#define EGO_RESIST_COLD         8
#define EGO_LIFE                68
#define EGO_STEALTH             42
#define EGO_PROTECTION          41
#define EGO_MAGI                27
#define EGO_SPEED               60
#define EGO_RESISTANCE          9
#define EGO_LITE                32
#define EGO_AURA_FIRE           44
#define EGO_SLAYING_WEAPON      71
#define EGO_SLAYING             50
#define EGO_TELEPORTATION       35
#define EGO_ELVENKIND           10
#define EGO_LITE_MAGI           163
#define EGO_HA                  65


/* Activation effects for random artifacts */
#define ACT_SUNLIGHT            1
#define ACT_BO_MISS_1           2
#define ACT_BA_POIS_1           3
#define ACT_BO_ELEC_1           4
#define ACT_BO_ACID_1           5
#define ACT_BO_COLD_1           6
#define ACT_BO_FIRE_1           7
#define ACT_BA_COLD_1           8
#define ACT_BA_FIRE_1           9
#define ACT_DRAIN_1             10
#define ACT_BA_COLD_2           11
#define ACT_BA_ELEC_2           12
#define ACT_DRAIN_2             13
#define ACT_VAMPIRE_1           14
#define ACT_BO_MISS_2           15
#define ACT_BA_FIRE_2           16
#define ACT_BA_COLD_3           17
#define ACT_BA_ELEC_3           18
#define ACT_WHIRLWIND           19
#define ACT_VAMPIRE_2           20
#define ACT_CALL_CHAOS          21
#define ACT_ROCKET              22
#define ACT_DISP_EVIL           23
#define ACT_BA_MISS_3           24
#define ACT_DISP_GOOD           25
#define ACT_GILGALAD            26
#define ACT_CELEBRIMBOR         27
#define ACT_SKULLCLEAVER        28
#define ACT_HARADRIM            29
#define ACT_FUNDIN              30
#define ACT_EOL                 31
#define ACT_UMBAR               32
#define ACT_UNDEATH             35
#define ACT_THRAIN              36
#define ACT_BARAHIR             37
#define ACT_TULKAS              38
#define ACT_NARYA               39
#define ACT_NENYA               40
#define ACT_VILYA               41
#define ACT_POWER               42
#define ACT_RAZORBACK           44
#define ACT_BLADETURNER         45
#define ACT_MEDIATOR            46
#define ACT_BELEGENNON          47
#define ACT_GORLIM              48
#define ACT_COLLUIN             49
#define ACT_BELANGIL            50
#define ACT_CONFUSE             51
#define ACT_SLEEP               52
#define ACT_QUAKE               53
#define ACT_TERROR              54
#define ACT_TELE_AWAY           55
#define ACT_BANISH_EVIL         56
#define ACT_GENOCIDE            57
#define ACT_MASS_GENO           58
#define ACT_ANGUIREL            59
#define ACT_ERU                 60
#define ACT_DAWN                61
#define ACT_FIRESTAR            62
#define ACT_TURMIL              63
#define ACT_CUBRAGOL            64
#define ACT_CHARM_ANIMAL        65
#define ACT_CHARM_UNDEAD        66
#define ACT_CHARM_OTHER         67
#define ACT_CHARM_ANIMALS       68
#define ACT_CHARM_OTHERS        69
#define ACT_SUMMON_ANIMAL       70
#define ACT_SUMMON_PHANTOM      71
#define ACT_SUMMON_ELEMENTAL    72
#define ACT_SUMMON_DEMON        73
#define ACT_SUMMON_UNDEAD       74
#define ACT_ELESSAR             75
#define ACT_GANDALF             76
#define ACT_MARDA               77
#define ACT_PALANTIR            78
#define ACT_CURE_LW             81
#define ACT_CURE_MW             82
#define ACT_CURE_POISON         83
#define ACT_REST_LIFE           84
#define ACT_REST_ALL            85
#define ACT_CURE_700            86
#define ACT_CURE_1000           87
#define ACT_EREBOR              89
#define ACT_DRUEDAIN            90
#define ACT_ESP                 91
#define ACT_BERSERK             92
#define ACT_PROT_EVIL           93
#define ACT_RESIST_ALL          94
#define ACT_SPEED               95
#define ACT_XTRA_SPEED          96
#define ACT_WRAITH              97
#define ACT_INVULN              98
#define ACT_ROHAN               99
#define ACT_HELM                100
#define ACT_BOROMIR             101
#define ACT_HURIN               102
#define ACT_AXE_GOTHMOG         103
#define ACT_MELKOR              104
#define ACT_GROND               105
#define ACT_NATUREBANE          106
#define ACT_NIGHT               107
#define ACT_ORCHAST             108
#define ACT_LIGHT               111
#define ACT_MAP_LIGHT           112
#define ACT_DETECT_ALL          113
#define ACT_DETECT_XTRA         114
#define ACT_RUNE_EXPLO          117
#define ACT_RUNE_PROT           118
#define ACT_SATIATE             119
#define ACT_DEST_DOOR          120
#define ACT_STONE_MUD           121
#define ACT_RECHARGE            122
#define ACT_ALCHEMY             123
#define ACT_DIM_DOOR            124
#define ACT_TELEPORT            125
#define ACT_RECALL              126

#define ACT_DEATH               127
#define ACT_RUINATION           128
#define ACT_DESTRUC             129
#define ACT_UNINT               130
#define ACT_UNSTR               131
#define ACT_UNCON               132
#define ACT_UNCHR               133
#define ACT_UNDEX               134
#define ACT_UNWIS               135
#define ACT_STATLOSS            136
#define ACT_HISTATLOSS          137
#define ACT_EXPLOSS             138
#define ACT_HIEXPLOSS           139
#define ACT_SUMMON_MONST        140
#define ACT_PARALYZE            141
#define ACT_HALLU               142
#define ACT_POISON              143
#define ACT_HUNGER              144
#define ACT_STUN                145
#define ACT_CUTS                146
#define ACT_PARANO              147
#define ACT_CONFUSION           148
#define ACT_BLIND               149
#define ACT_PET_SUMMON          150
#define ACT_CURE_PARA           151
#define ACT_CURE_HALLU          152
#define ACT_CURE_POIS           153
#define ACT_CURE_HUNGER         154
#define ACT_CURE_STUN           155
#define ACT_CURE_CUTS           156
#define ACT_CURE_FEAR           157
#define ACT_CURE_CONF           158
#define ACT_CURE_BLIND          159
#define ACT_CURING              160
#define ACT_DARKNESS            161
#define ACT_LEV_TELE            162
#define ACT_ACQUIREMENT         163
#define ACT_WEIRD               164
#define ACT_AGGRAVATE           165
#define ACT_MUT                 166
#define ACT_CURE_INSANITY       167
#define ACT_CURE_MUT            168
#define ACT_LIGHT_ABSORBTION    169
/* of dragonkind?*/
#define ACT_BA_FIRE_H           170
#define ACT_BA_COLD_H           171
#define ACT_BA_ELEC_H           172
#define ACT_BA_ACID_H           173
#define ACT_SPIN                174
#define ACT_NOLDOR              175
#define ACT_SPECTRAL            176
#define ACT_JUMP                177
#define ACT_DEST_TELE           178
/*amulet of serpents dam 100, rad 2 timout 40+d60 */
#define ACT_BA_POIS_4           179
/*rings of X 50,50+d50 dur 20+d20 */
#define ACT_BA_COLD_4           180
#define ACT_BA_FIRE_4           181
#define ACT_BA_ACID_4           182
#define ACT_BA_ELEC_4           183
#define ACT_BR_ELEC             184
#define ACT_BR_COLD             185
#define ACT_BR_FIRE             186
#define ACT_BR_ACID             187
#define ACT_BR_POIS             188
#define ACT_BR_MANY             189
#define ACT_BR_CONF             190
#define ACT_BR_SOUND            191
#define ACT_BR_CHAOS            192
#define ACT_BR_SHARD            193
#define ACT_BR_BALANCE          194
#define ACT_BR_LIGHT            195
#define ACT_BR_POWER            196
#define ACT_GROW_MOLD		197
#define ACT_MUSIC		200
#define ACT_ETERNAL_FLAME       201
#define ACT_MAGGOT              202
#define ACT_LEBOHAUM            203
#define ACT_DURANDIL            204
#define ACT_RADAGAST            205 /* Theme */
#define ACT_VALAROMA            206 /* Theme */

/*** Object "tval" and "sval" codes ***/


/*
 * The values for the "tval" field of various objects.
 *
 * This value is the primary means by which items are sorted in the
 * player inventory, followed by "sval" and "cost".
 *
 * Note that a "BOW" with tval = 19 and sval S = 10*N+P takes a missile
 * weapon with tval = 16+N, and does (xP) damage when so combined.  This
 * fact is not actually used in the source, but it kind of interesting.
 *
 * Note that as of 2.7.8, the "item flags" apply to all items, though
 * only armor and weapons and a few other items use any of these flags.
 */

#define TV_SKELETON      1      /* Skeletons ('s') */
#define TV_BOTTLE        2      /* Empty bottles ('!') */
#define TV_SPIKE         5      /* Spikes ('~') */
#define TV_MSTAFF        6      /* Mage Staffs */
#define TV_PARCHMENT     8      /* Parchments from Kamband */
#define TV_CORPSE        9      /* Monster corpses */
#define TV_EGG          10      /* Monster Eggs */
#define TV_JUNK         11      /* Sticks, Pottery, etc ('~') */
#define TV_TOOL         12      /* Tools */
#define TV_INSTRUMENT   14      /* Musical instruments */
#define TV_BOOMERANG    15      /* Boomerangs */
#define TV_SHOT         16      /* Ammo for slings */
#define TV_ARROW        17      /* Ammo for bows */
#define TV_BOLT         18      /* Ammo for x-bows */
#define TV_BOW          19      /* Slings/Bows/Xbows */
#define TV_DIGGING      20      /* Shovels/Picks */
#define TV_HAFTED       21      /* Priest Weapons */
#define TV_POLEARM      22      /* Pikes/Glaives/Spears/etc. */
#define TV_SWORD        23      /* Edged Weapons */
#define TV_AXE          24      /* Axes/Cleavers */
#define TV_BOOTS        30      /* Boots */
#define TV_GLOVES       31      /* Gloves */
#define TV_HELM         32      /* Helms */
#define TV_CROWN        33      /* Crowns */
#define TV_SHIELD       34      /* Shields */
#define TV_CLOAK        35      /* Cloaks */
#define TV_SOFT_ARMOR   36      /* Soft Armor */
#define TV_HARD_ARMOR   37      /* Hard Armor */
#define TV_DRAG_ARMOR   38      /* Dragon Scale Mail */
#define TV_LITE         39      /* Lites (including Specials) */
#define TV_AMULET       40      /* Amulets (including Specials) */
#define TV_RING         45      /* Rings (including Specials) */
#define TV_TOTEM        54      /* Summoner totems */
#define TV_STAFF        55
#define TV_WAND         65
#define TV_ROD          66
#define TV_ROD_MAIN     67
#define TV_SCROLL       70
#define TV_POTION       71
#define TV_POTION2      72      /* Second set of potion */
#define TV_FLASK        77
#define TV_FOOD         80
#define TV_HYPNOS       99      /* To wield monsters !:) */
#define TV_GOLD         100     /* Gold can only be picked up by players */
#define TV_RANDART      102     /* Random Artifacts */

#define TV_BOOK         111
#define TV_SYMBIOTIC_BOOK 112
#define TV_MUSIC_BOOK   113
#define TV_DRUID_BOOK   114
#define TV_DAEMON_BOOK  115


/* The "sval" codes for TV_JUNK */
#define SV_BOULDER      1


/* The "sval" codes for TV_TOOL */
#define SV_TOOL_CLIMB 0

/* The "sval" codes for TV_MSTAFF */
#define SV_MSTAFF 1

/* The "sval" codes for TV_SHOT/TV_ARROW/TV_BOLT */
#define SV_AMMO_LIGHT                    0	/* pebbles */
#define SV_AMMO_NORMAL                   1	/* shots, arrows, bolts */
#define SV_AMMO_HEAVY                    2	/* seeker arrows and bolts, mithril shots */

/* The "sval" codes for TV_INSTRUMENT */
#define SV_DRUM                          58
#define SV_HARP                          59
#define SV_HORN                          60

/* The "sval" codes for TV_BOOMERANG */
#define SV_BOOM_S_WOOD                   1      /* 1d4  */
#define SV_BOOM_WOOD                     2      /* 1d8  */
#define SV_BOOM_S_METAL                  3      /* 3d4  */
#define SV_BOOM_METAL                    4      /* 4d5  */

/* The "sval" codes for TV_BOW (note information in "sval") */
#define SV_SLING                         2	/* (x2) */
#define SV_SHORT_BOW                    12	/* (x2) */
#define SV_LONG_BOW                     13	/* (x3) */
#define SV_LIGHT_XBOW                   23	/* (x3) */
#define SV_HEAVY_XBOW                   24	/* (x4) */

/* The "sval" codes for TV_DIGGING */
#define SV_SHOVEL                        1
#define SV_GNOMISH_SHOVEL                2
#define SV_DWARVEN_SHOVEL                3
#define SV_PICK                          4
#define SV_ORCISH_PICK                   5
#define SV_DWARVEN_PICK                  6
#define SV_MATTOCK                       7

/* The "sval" values for TV_HAFTED */
#define SV_CLUB                          1	/* 1d4  */
#define SV_WHIP                          2	/* 1d6  */
#define SV_QUARTERSTAFF                  3	/* 1d9  */
#define SV_NUNCHAKU                      4	/* 2d3  */
#define SV_MACE                          5	/* 2d4  */
#define SV_BALL_AND_CHAIN                6	/* 2d4  */
#define SV_WAR_HAMMER                    8	/* 3d3  */
#define SV_LUCERN_HAMMER                10	/* 2d5  */
#define SV_THREE_PIECE_ROD              11	/* 3d3  */
#define SV_MORNING_STAR                 12	/* 2d6  */
#define SV_FLAIL                        13	/* 2d6  */
#define SV_LEAD_FILLED_MACE             15	/* 3d4  */
#define SV_TWO_HANDED_FLAIL             18	/* 3d6  */
#define SV_GREAT_HAMMER                 19	/* 4d6  */
#define SV_MACE_OF_DISRUPTION           20	/* 5d8  */
#define SV_GROND                        50	/* 3d4  */

/* The "sval" values for TV_AXE */
#define SV_HATCHET                       1	/* 1d5 */
#define SV_CLEAVER                       2      /* 2d4 */
#define SV_LIGHT_WAR_AXE                 8      /* 2d5 */
#define SV_BEAKED_AXE                   10	/* 2d6 */
#define SV_BROAD_AXE                    11	/* 2d6 */
#define SV_BATTLE_AXE                   22	/* 2d8 */
#define SV_GREAT_AXE                    25	/* 4d4 */
#define SV_LOCHABER_AXE                 28	/* 3d8 */
#define SV_SLAUGHTER_AXE                30      /* 5d7 */

/* The "sval" values for TV_POLEARM */
#define SV_SPEAR                         2	/* 1d6 */
#define SV_SICKLE                        3	/* 2d3 */
#define SV_AWL_PIKE                      4	/* 1d8 */
#define SV_TRIDENT                       5	/* 1d9 */
#define SV_FAUCHARD                      6  /* 1d10 */
#define SV_BROAD_SPEAR                   7	/* 1d9 */
#define SV_PIKE                          8	/* 2d5 */
#define SV_GLAIVE                       13	/* 2d6 */
#define SV_HALBERD                      15	/* 3d4 */
#define SV_GUISARME                     16  /* 2d5 */
#define SV_SCYTHE                       17	/* 5d3 */
#define SV_LANCE                        20	/* 2d8 */
#define SV_TRIFURCATE_SPEAR             26	/* 2d9 */
#define SV_HEAVY_LANCE                  29  /* 4d8 */
#define SV_SCYTHE_OF_SLICING            30	/* 8d4 */

/* The "sval" codes for TV_SWORD */
#define SV_BROKEN_DAGGER                 1  /* 1d1 */
#define SV_BROKEN_SWORD                  2  /* 1d2 */
#define SV_DAGGER                        4  /* 1d4 */
#define SV_MAIN_GAUCHE                   5  /* 1d5 */
#define SV_RAPIER                        7  /* 1d6 */
#define SV_SMALL_SWORD                   8  /* 1d6 */
#define SV_BASILLARD                     9  /* 1d8 */
#define SV_SHORT_SWORD                  10  /* 1d7 */
#define SV_SABRE                        11  /* 1d7 */
#define SV_CUTLASS                      12  /* 1d7 */
#define SV_KHOPESH                      14  /* 2d4 */
#define SV_TULWAR                       15  /* 2d4 */
#define SV_BROAD_SWORD                  16  /* 2d5 */
#define SV_LONG_SWORD                   17  /* 2d5 */
#define SV_SCIMITAR                     18  /* 2d5 */
#define SV_KATANA                       20  /* 3d4 */
#define SV_BASTARD_SWORD                21  /* 3d4 */
#define SV_GREAT_SCIMITAR               22  /* 4d5 */
#define SV_CLAYMORE                     23  /* 2d8 */
#define SV_ESPADON                      24  /* 2d9 */
#define SV_TWO_HANDED_SWORD             25  /* 3d6 */
#define SV_FLAMBERGE                    26  /* 3d7 */
#define SV_EXECUTIONERS_SWORD           28  /* 4d5 */
#define SV_ZWEIHANDER                   29  /* 4d6 */
#define SV_BLADE_OF_CHAOS               30  /* 6d5 */
#define SV_BLUESTEEL_BLADE              31  /* 3d9 */
#define SV_SHADOW_BLADE                 32  /* 4d4 */
#define SV_DARK_SWORD                   33  /* 3d7 */

/* The "sval" codes for TV_SHIELD */
#define SV_SMALL_LEATHER_SHIELD          2
#define SV_SMALL_METAL_SHIELD            3
#define SV_LARGE_LEATHER_SHIELD          4
#define SV_LARGE_METAL_SHIELD            5
#define SV_DRAGON_SHIELD                 6
#define SV_SHIELD_OF_DEFLECTION         10

/* The "sval" codes for TV_HELM */
#define SV_HARD_LEATHER_CAP              2
#define SV_METAL_CAP                     3
#define SV_IRON_HELM                     5
#define SV_STEEL_HELM                    6
#define SV_DRAGON_HELM                   7
#define SV_IRON_CROWN                   10
#define SV_GOLDEN_CROWN                 11
#define SV_JEWELED_CROWN                12
#define SV_MORGOTH                      50

/* The "sval" codes for TV_BOOTS */
#define SV_PAIR_OF_SOFT_LEATHER_BOOTS    2
#define SV_PAIR_OF_HARD_LEATHER_BOOTS    3
#define SV_PAIR_OF_METAL_SHOD_BOOTS      6

/* The "sval" codes for TV_CLOAK */
#define SV_CLOAK                         1
#define SV_ELVEN_CLOAK                   2
#define SV_FUR_CLOAK                     3
#define SV_SHADOW_CLOAK                  6
#define SV_MIMIC_CLOAK                   100

/* The "sval" codes for TV_GLOVES */
#define SV_SET_OF_LEATHER_GLOVES         1
#define SV_SET_OF_GAUNTLETS              2
#define SV_SET_OF_CESTI                  5

/* The "sval" codes for TV_SOFT_ARMOR */
#define SV_FILTHY_RAG                    1
#define SV_ROBE                          2
#define SV_PAPER_ARMOR                   3  /* 4 */
#define SV_SOFT_LEATHER_ARMOR            4
#define SV_SOFT_STUDDED_LEATHER          5
#define SV_HARD_LEATHER_ARMOR            6
#define SV_HARD_STUDDED_LEATHER          7
#define SV_RHINO_HIDE_ARMOR              8
#define SV_CORD_ARMOR                    9  /*  6 */
#define SV_PADDED_ARMOR                 10  /*  4 */
#define SV_LEATHER_SCALE_MAIL           11
#define SV_LEATHER_JACK                 12
#define SV_STONE_AND_HIDE_ARMOR         15  /* 15 */
#define SV_THUNDERLORD_SUIT             16

/* The "sval" codes for TV_HARD_ARMOR */
#define SV_RUSTY_CHAIN_MAIL              1  /* 14- */
#define SV_RING_MAIL                     2  /* 12  */
#define SV_METAL_SCALE_MAIL              3  /* 13  */
#define SV_CHAIN_MAIL                    4  /* 14  */
#define SV_DOUBLE_RING_MAIL              5  /* 15  */
#define SV_AUGMENTED_CHAIN_MAIL          6  /* 16  */
#define SV_DOUBLE_CHAIN_MAIL             7  /* 16  */
#define SV_BAR_CHAIN_MAIL                8  /* 18  */
#define SV_METAL_BRIGANDINE_ARMOUR       9  /* 19  */
#define SV_SPLINT_MAIL                  10  /* 19  */
#define SV_PARTIAL_PLATE_ARMOUR         12  /* 22  */
#define SV_METAL_LAMELLAR_ARMOUR        13  /* 23  */
#define SV_FULL_PLATE_ARMOUR            15  /* 25  */
#define SV_RIBBED_PLATE_ARMOUR          18  /* 28  */
#define SV_MITHRIL_CHAIN_MAIL           20  /* 28+ */
#define SV_MITHRIL_PLATE_MAIL           25  /* 35+ */
#define SV_ADAMANTITE_PLATE_MAIL        30  /* 40+ */

/* The "sval" codes for TV_DRAG_ARMOR */
#define SV_DRAGON_BLACK                  1
#define SV_DRAGON_BLUE                   2
#define SV_DRAGON_WHITE                  3
#define SV_DRAGON_RED                    4
#define SV_DRAGON_GREEN                  5
#define SV_DRAGON_MULTIHUED              6
#define SV_DRAGON_SHINING               10
#define SV_DRAGON_LAW                   12
#define SV_DRAGON_BRONZE                14
#define SV_DRAGON_GOLD                  16
#define SV_DRAGON_CHAOS                 18
#define SV_DRAGON_BALANCE               20
#define SV_DRAGON_POWER                 30

/* The sval codes for TV_LITE */
#define SV_LITE_TORCH                    0
#define SV_LITE_LANTERN                  1
#define SV_LITE_TORCH_EVER               2
#define SV_LITE_DWARVEN                  3
#define SV_LITE_FEANORIAN                4


/* The "sval" codes for TV_AMULET */
#define SV_AMULET_DOOM                   0
#define SV_AMULET_BRILLANCE              6
#define SV_AMULET_CHARISMA               7
#define SV_AMULET_THE_MAGI               8
#define SV_AMULET_REFLECTION             9
#define SV_AMULET_NO_MAGIC              13
#define SV_AMULET_NO_TELE               14
#define SV_AMULET_RESISTANCE            15
#define SV_AMULET_SERPENT               17
#define SV_AMULET_TELEPATHY             22
#define SV_AMULET_TRICKERY              23
#define SV_AMULET_WEAPONMASTERY         24
#define SV_AMULET_DEVOTION              25
#define SV_AMULET_INFRA                 26
#define SV_AMULET_SPELL                 27
#define SV_AMULET_WISDOM                28

/* The sval codes for TV_RING */
#define SV_RING_WOE                      0
#define SV_RING_WEAKNESS                 2
#define SV_RING_STUPIDITY                3
#define SV_RING_SPECIAL                  5
#define SV_RING_PROTECTION              16
#define SV_RING_ACID                    17
#define SV_RING_FLAMES                  18
#define SV_RING_ICE                     19
#define SV_RING_STR                     24
#define SV_RING_INT                     25
#define SV_RING_DEX                     26
#define SV_RING_CON                     27
#define SV_RING_ACCURACY                28
#define SV_RING_DAMAGE                  29
#define SV_RING_SLAYING                 30
#define SV_RING_SPEED                   31
#define SV_RING_POWER                   37
#define SV_RING_LORDLY                  48
#define SV_RING_ATTACKS                 49
#define SV_RING_INVIS                   53
#define SV_RING_CRIT                    59

/* The "sval" codes for TV_ROD(Rod Tips) */
#define SV_ROD_NOTHING                   0
#define SV_ROD_DETECT_DOOR               1
#define SV_ROD_RECALL                    3
#define SV_ROD_ILLUMINATION              4
#define SV_ROD_MAPPING                   5
#define SV_ROD_DETECTION                 6
#define SV_ROD_CURING                    8
#define SV_ROD_HEALING                   9
#define SV_ROD_RESTORATION              10
#define SV_ROD_SPEED                    11
#define SV_ROD_TELEPORT_AWAY            13
#define SV_ROD_LITE                     15
#define SV_ROD_SLEEP_MONSTER            16
#define SV_ROD_SLOW_MONSTER             17
#define SV_ROD_DRAIN_LIFE               18
#define SV_ROD_POLYMORPH                19
#define SV_ROD_ACID_BOLT                20
#define SV_ROD_ELEC_BOLT                21
#define SV_ROD_FIRE_BOLT                22
#define SV_ROD_COLD_BOLT                23
#define SV_ROD_ACID_BALL                24
#define SV_ROD_ELEC_BALL                25
#define SV_ROD_FIRE_BALL                26
#define SV_ROD_COLD_BALL                27
#define SV_ROD_HAVOC                    28
#define SV_ROD_HOME                     30


/* The "sval" codes for TV_ROD_MAIN(Rods) */
/* Note that the sval is the max mana capacity of the rod */

#define SV_ROD_SILVER                   100


/* The "sval" codes for TV_SCROLL */

#define SV_SCROLL_DARKNESS               0
#define SV_SCROLL_AGGRAVATE_MONSTER      1
#define SV_SCROLL_CURSE_ARMOR            2
#define SV_SCROLL_CURSE_WEAPON           3
#define SV_SCROLL_SUMMON_MONSTER         4
#define SV_SCROLL_SUMMON_UNDEAD          5
#define SV_SCROLL_SUMMON_MINE            6
#define SV_SCROLL_PHASE_DOOR             8
#define SV_SCROLL_TELEPORT               9
#define SV_SCROLL_TELEPORT_LEVEL        10
#define SV_SCROLL_WORD_OF_RECALL        11
#define SV_SCROLL_REMOVE_CURSE          14
#define SV_SCROLL_STAR_REMOVE_CURSE     15
#define SV_SCROLL_ENCHANT_ARMOR         16
#define SV_SCROLL_ENCHANT_WEAPON_TO_HIT 17
#define SV_SCROLL_ENCHANT_WEAPON_TO_DAM 18
#define SV_SCROLL_ENCHANT_WEAPON_PVAL   19
#define SV_SCROLL_STAR_ENCHANT_ARMOR    20
#define SV_SCROLL_STAR_ENCHANT_WEAPON   21
#define SV_SCROLL_RECHARGING            22
#define SV_SCROLL_RESET_RECALL          23
#define SV_SCROLL_LIGHT                 24
#define SV_SCROLL_MAPPING               25
#define SV_SCROLL_DETECT_GOLD           26
#define SV_SCROLL_DETECT_ITEM           27
#define SV_SCROLL_DETECT_DOOR           29
#define SV_SCROLL_DETECT_INVIS          30
#define SV_SCROLL_DIVINATION            31
#define SV_SCROLL_SATISFY_HUNGER        32
#define SV_SCROLL_BLESSING              33
#define SV_SCROLL_HOLY_CHANT            34
#define SV_SCROLL_HOLY_PRAYER           35
#define SV_SCROLL_MONSTER_CONFUSION     36
#define SV_SCROLL_PROTECTION_FROM_EVIL  37
#define SV_SCROLL_RUNE_OF_PROTECTION    38
#define SV_SCROLL_DEINCARNATION         40
#define SV_SCROLL_STAR_DESTRUCTION      41
#define SV_SCROLL_DISPEL_UNDEAD         42
#define SV_SCROLL_MASS_RESURECTION      43
#define SV_SCROLL_GENOCIDE              44
#define SV_SCROLL_MASS_GENOCIDE         45
#define SV_SCROLL_ACQUIREMENT           46
#define SV_SCROLL_STAR_ACQUIREMENT      47
#define SV_SCROLL_FIRE                  48
#define SV_SCROLL_ICE                   49
#define SV_SCROLL_CHAOS                 50
#define SV_SCROLL_RUMOR                 51
#define SV_SCROLL_ARTIFACT              52
#define SV_SCROLL_NOTHING               53
#define SV_SCROLL_STERILIZATION         54

/* The "sval" codes for TV_POTION */
#define SV_POTION_WATER                  0
#define SV_POTION_APPLE_JUICE            1
#define SV_POTION_SLIME_MOLD             2
#define SV_POTION_BLOOD                  3
#define SV_POTION_SLOWNESS               4
#define SV_POTION_SALT_WATER             5
#define SV_POTION_POISON                 6
#define SV_POTION_BLINDNESS              7
#define SV_POTION_INVIS                  8
#define SV_POTION_CONFUSION              9
#define SV_POTION_MUTATION              10
#define SV_POTION_SLEEP                 11
#define SV_POTION_LEARNING              12
#define SV_POTION_LOSE_MEMORIES         13
#define SV_POTION_RUINATION             15
#define SV_POTION_DEC_STR               16
#define SV_POTION_DEC_INT               17
#define SV_POTION_DEC_WIS               18
#define SV_POTION_DEC_DEX               19
#define SV_POTION_DEC_CON               20
#define SV_POTION_DEC_CHR               21
#define SV_POTION_DETONATIONS           22
#define SV_POTION_DEATH                 23
#define SV_POTION_INFRAVISION           24
#define SV_POTION_DETECT_INVIS          25
#define SV_POTION_SLOW_POISON           26
#define SV_POTION_CURE_POISON           27
#define SV_POTION_BOLDNESS              28
#define SV_POTION_SPEED                 29
#define SV_POTION_RESIST_HEAT           30
#define SV_POTION_RESIST_COLD           31
#define SV_POTION_HEROISM               32
#define SV_POTION_BESERK_STRENGTH       33
#define SV_POTION_CURE_LIGHT            34
#define SV_POTION_CURE_SERIOUS          35
#define SV_POTION_CURE_CRITICAL         36
#define SV_POTION_HEALING               37
#define SV_POTION_STAR_HEALING          38
#define SV_POTION_LIFE                  39
#define SV_POTION_RESTORE_MANA          40
#define SV_POTION_RESTORE_EXP           41
#define SV_POTION_RES_STR               42
#define SV_POTION_RES_INT               43
#define SV_POTION_RES_WIS               44
#define SV_POTION_RES_DEX               45
#define SV_POTION_RES_CON               46
#define SV_POTION_RES_CHR               47
#define SV_POTION_INC_STR               48
#define SV_POTION_INC_INT               49
#define SV_POTION_INC_WIS               50
#define SV_POTION_INC_DEX               51
#define SV_POTION_INC_CON               52
#define SV_POTION_INC_CHR               53
#define SV_POTION_AUGMENTATION          55
#define SV_POTION_ENLIGHTENMENT         56
#define SV_POTION_STAR_ENLIGHTENMENT    57
#define SV_POTION_EXPERIENCE            59
#define SV_POTION_RESISTANCE            60
#define SV_POTION_CURING                61
#define SV_POTION_INVULNERABILITY       62
#define SV_POTION_NEW_LIFE              63

#define SV_POTION_LAST                  63

/* The "sval" codes for TV_POTION2 */
#define SV_POTION2_MIMIC                 1
#define SV_POTION2_CURE_LIGHT_SANITY     14
#define SV_POTION2_CURE_SERIOUS_SANITY   15
#define SV_POTION2_CURE_CRITICAL_SANITY  16
#define SV_POTION2_CURE_SANITY           17
#define SV_POTION2_CURE_WATER            18

#define SV_POTION2_LAST                  18

/* The "sval" codes for TV_FOOD */
#define SV_FOOD_POISON                   0
#define SV_FOOD_BLINDNESS                1
#define SV_FOOD_PARANOIA                 2
#define SV_FOOD_CONFUSION                3
#define SV_FOOD_HALLUCINATION            4
#define SV_FOOD_PARALYSIS                5
#define SV_FOOD_WEAKNESS                 6
#define SV_FOOD_SICKNESS                 7
#define SV_FOOD_STUPIDITY                8
#define SV_FOOD_NAIVETY                  9
#define SV_FOOD_UNHEALTH                10
#define SV_FOOD_DISEASE                 11
#define SV_FOOD_CURE_POISON             12
#define SV_FOOD_CURE_BLINDNESS          13
#define SV_FOOD_CURE_PARANOIA           14
#define SV_FOOD_CURE_CONFUSION          15
#define SV_FOOD_CURE_SERIOUS            16
#define SV_FOOD_RESTORE_STR             17
#define SV_FOOD_RESTORE_CON             18
#define SV_FOOD_RESTORING               19
/* many missing mushrooms */
#define SV_FOOD_BISCUIT                 32
#define SV_FOOD_JERKY                   33
#define SV_FOOD_RATION                  35
#define SV_FOOD_SLIME_MOLD              36
#define SV_FOOD_WAYBREAD                37
#define SV_FOOD_PINT_OF_ALE             38
#define SV_FOOD_PINT_OF_WINE            39
#define SV_FOOD_ATHELAS                 40
#define SV_FOOD_GREAT_HEALTH            41
#define SV_FOOD_FORTUNE_COOKIE          42

/* The "sval" codes for TV_CORPSE */
#define SV_CORPSE_CORPSE     1
#define SV_CORPSE_SKELETON   2
#define SV_CORPSE_HEAD       3
#define SV_CORPSE_SKULL      4
#define SV_CORPSE_MEAT       5

/* The "sval" codes for TV_DAEMON_BOOK */
#define SV_DEMONBLADE  55
#define SV_DEMONSHIELD 56
#define SV_DEMONHORN   57

/*
 * Special "sval" limit -- first "normal" food
 */
#define SV_FOOD_MIN_FOOD                32

/*
 * Special "sval" limit -- first "aimed" rod
 */
#define SV_ROD_MIN_DIRECTION    12

/*
 * Special "sval" limit -- last "good" magic/prayer book
 */
#define SV_BOOK_MAX_GOOD    49

/*** General flag values ***/


/*
 * Special cave grid flags
 */
#define CAVE_MARK       0x0001    /* memorized feature */
#define CAVE_GLOW       0x0002    /* self-illuminating */
#define CAVE_ICKY       0x0004    /* part of a vault */
#define CAVE_ROOM       0x0008    /* part of a room */
#define CAVE_SEEN       0x0010    /* seen flag  */
#define CAVE_VIEW       0x0020    /* view flag */
#define CAVE_TEMP       0x0040    /* temp flag */
#define CAVE_WALL       0x0080    /* wall flag */
#define CAVE_SPEC       0x0400    /* special mark(quests) */
#define CAVE_FREE       0x0800    /* no random generation on it */
#define CAVE_PLIT       0x2000    /* Player lit grid */
#define CAVE_MLIT       0x4000    /* Monster lit grid */

/*
 * Bit flags for the "project()" function
 *
 *   JUMP: Jump directly to the target location (this is a hack)
 *   BEAM: Work as a beam weapon (affect every grid passed through)
 *   THRU: Continue "through" the target (used for "bolts"/"beams")
 *   WALL: Continue "through" the walls
 *   STOP: Stop as soon as we hit a monster (used for "bolts")
 *   GRID: Affect each grid in the "blast area" in some way
 *   ITEM: Affect each object in the "blast area" in some way
 *   KILL: Affect each monster in the "blast area" in some way
 *   HIDE: Hack -- disable "visual" feedback from projection
 */
#define PROJECT_JUMP       0x00000001
#define PROJECT_BEAM       0x00000002
#define PROJECT_THRU       0x00000004
#define PROJECT_STOP       0x00000008
#define PROJECT_GRID       0x00000010
#define PROJECT_ITEM       0x00000020
#define PROJECT_KILL       0x00000040
#define PROJECT_HIDE       0x00000080
#define PROJECT_VIEWABLE   0x00000100   /* Affect monsters in LOS */
#define PROJECT_METEOR_SHOWER 0x00000200        /* Affect random grids */
#define PROJECT_BLAST      0x00000400   /* Like Mega_blast, but will only affect viewable grids */
#define PROJECT_PANEL      0x00000800   /* Affect everything in the panel. */
#define PROJECT_ALL        0x00001000   /* Affect every single grid. */
#define PROJECT_WALL       0x00002000
#define PROJECT_MANA_PATH  0x00004000   /* Follow a mana path. */
#define PROJECT_ABSORB_MANA 0x00008000   /* The spell increase in power as it absord grid's mana. */
#define PROJECT_STAY       0x00010000

/*
 * Bit flags for the "enchant()" function
 */
#define ENCH_TOHIT   0x01
#define ENCH_TODAM   0x02
#define ENCH_TOAC    0x04
#define ENCH_PVAL    0x08

/*
 * Bit flags for the "target_set" function XXX XXX XXX
 *
 *      KILL: Target monsters
 *      LOOK: Describe grid fully
 *      XTRA: Currently unused flag
 *      GRID: Select from all grids
 */
#define TARGET_KILL             0x01
#define TARGET_LOOK             0x02
#define TARGET_XTRA             0x04
#define TARGET_GRID             0x08


/*
 * Some bit-flags for the "smart" field
 */
#define SM_RES_ACID             0x00000001
#define SM_RES_ELEC             0x00000002
#define SM_RES_FIRE             0x00000004
#define SM_RES_COLD             0x00000008
#define SM_RES_POIS             0x00000010
#define SM_RES_NETH             0x00000020
#define SM_RES_LITE             0x00000040
#define SM_RES_DARK             0x00000080
#define SM_RES_FEAR             0x00000100
#define SM_RES_CONF             0x00000200
#define SM_RES_CHAOS            0x00000400
#define SM_RES_DISEN            0x00000800
#define SM_RES_BLIND            0x00001000
#define SM_RES_NEXUS            0x00002000
#define SM_RES_SOUND            0x00004000
#define SM_RES_SHARD            0x00008000
#define SM_OPP_ACID             0x00010000
#define SM_OPP_ELEC             0x00020000
#define SM_OPP_FIRE             0x00040000
#define SM_OPP_COLD             0x00080000
#define SM_OPP_POIS             0x00100000
#define SM_OPP_XXX1             0x00200000
#define SM_CLONED               0x00400000
#define SM_IMM_ACID             0x01000000
#define SM_IMM_ELEC             0x02000000
#define SM_IMM_FIRE             0x04000000
#define SM_IMM_COLD             0x08000000
#define SM_IMM_XXX5             0x10000000
#define SM_IMM_REFLECT          0x20000000
#define SM_IMM_FREE             0x40000000
#define SM_IMM_MANA             0x80000000

/*
 * Monster status(Player POV)
 */
#define MSTATUS_ENEMY           -2
#define MSTATUS_NEUTRAL_M       -1
#define MSTATUS_NEUTRAL         0
#define MSTATUS_NEUTRAL_P       1
#define MSTATUS_FRIEND          2
#define MSTATUS_PET             3
#define MSTATUS_COMPANION       4

/*
 * Bit flags for the "get_item" function
 */
#define USE_EQUIP    0x01	/* Allow equip items */
#define USE_INVEN    0x02	/* Allow inven items */
#define USE_FLOOR    0x04	/* Allow floor items */
#define USE_AUTO     0x10	/* Allow creation of automatizer rule */
/*
 * Bit flags for the "p_ptr->notice" variable
 */
#define PN_COMBINE      0x00000001L     /* Combine the pack */
#define PN_REORDER      0x00000002L     /* Reorder the pack */
/* xxx (many) */


/*
 * Bit flags for the "p_ptr->update" variable
 */
#define PU_BONUS        0x00000001L     /* Calculate bonuses */
#define PU_TORCH        0x00000002L     /* Calculate torch radius */
#define PU_BODY         0x00000004L     /* Calculate body parts */
#define PU_SANITY       0x00000008L     /* Calculate csan and msan */
#define PU_HP           0x00000010L     /* Calculate chp and mhp */
#define PU_MANA         0x00000020L     /* Calculate csp and msp */
#define PU_SPELLS       0x00000040L     /* Calculate spells */
#define PU_POWERS       0x00000080L     /* Calculate powers */
#define PU_UN_VIEW      0x00010000L     /* Forget view */
#define PU_VIEW         0x00100000L     /* Update view */
#define PU_MON_LITE     0x00200000L     /* Update monster light */
#define PU_MONSTERS     0x01000000L     /* Update monsters */
#define PU_DISTANCE     0x02000000L     /* Update distances */
#define PU_FLOW         0x10000000L     /* Update flow */


/*
 * Bit flags for the "p_ptr->redraw" variable
 */
#define PR_FRAME        0x02000000L     /* Display Basic Info */
#define PR_MAP          0x04000000L     /* Display Map */
#define PR_WIPE         0x08000000L     /* Hack -- Total Redraw */

/*
 * Bit flags for the "p_ptr->window" variable (etc)
 */
#define PW_INVEN        0x00000001L     /* Display inven/equip */
#define PW_EQUIP        0x00000002L     /* Display equip/inven */
#define PW_PLAYER       0x00000008L     /* Display character */
#define PW_M_LIST       0x00000010L /* Show monster list */
#define PW_MESSAGE      0x00000040L     /* Display messages */
#define PW_OVERHEAD     0x00000080L     /* Display overhead view */
#define PW_MONSTER      0x00000100L     /* Display monster recall */
#define PW_OBJECT       0x00000200L     /* Display object recall */


/* jk */
#define STAT_DEC_TEMPORARY 1
#define STAT_DEC_NORMAL 2
#define STAT_DEC_PERMANENT 3

/*** General index values ***/


/*
 * Legal restrictions for "summon_specific()"
 */
#define SUMMON_ANT                  11
#define SUMMON_SPIDER               12
#define SUMMON_HOUND                13
#define SUMMON_HYDRA                14
#define SUMMON_ANGEL                15
#define SUMMON_DEMON                16
#define SUMMON_UNDEAD               17
#define SUMMON_DRAGON               18
#define SUMMON_HI_UNDEAD            21
#define SUMMON_HI_DRAGON            22
#define SUMMON_WRAITH               31
#define SUMMON_UNIQUE               32
#define SUMMON_BIZARRE1             33
#define SUMMON_BIZARRE2             34
#define SUMMON_BIZARRE3             35
#define SUMMON_BIZARRE4             36
#define SUMMON_BIZARRE5             37
#define SUMMON_BIZARRE6             38
#define SUMMON_HI_DEMON             39
#define SUMMON_KIN                  40
#define SUMMON_DAWN                 41
#define SUMMON_ANIMAL               42
#define SUMMON_ANIMAL_RANGER        43
#define SUMMON_HI_UNDEAD_NO_UNIQUES 44
#define SUMMON_HI_DRAGON_NO_UNIQUES 45
#define SUMMON_NO_UNIQUES           46
#define SUMMON_PHANTOM              47
#define SUMMON_ELEMENTAL            48
#define SUMMON_THUNDERLORD          49
#define SUMMON_BLUE_HORROR          50
#define SUMMON_BUG                  51
#define SUMMON_RNG                  52
#define SUMMON_MINE                 53
#define SUMMON_HUMAN                54
#define SUMMON_SHADOWS              55
#define SUMMON_GHOST                56
#define SUMMON_QUYLTHULG            57


/*
 * Spell types used by project(), and related functions.
 */
#define GF_ELEC         1
#define GF_POIS         2
#define GF_ACID         3
#define GF_COLD         4
#define GF_FIRE         5
#define GF_UNBREATH     6
#define GF_CORPSE_EXPL  7
#define GF_MISSILE      10
#define GF_ARROW        11
#define GF_PLASMA       12
#define GF_WAVE         13
#define GF_WATER        14
#define GF_LITE         15
#define GF_DARK         16
#define GF_LITE_WEAK    17
#define GF_DARK_WEAK    18
#define GF_SHARDS       20
#define GF_SOUND        21
#define GF_CONFUSION    22
#define GF_FORCE        23
#define GF_INERTIA      24
#define GF_MANA         26
#define GF_METEOR       27
#define GF_ICE          28
#define GF_CHAOS        30
#define GF_NETHER       31
#define GF_DISENCHANT   32
#define GF_NEXUS        33
#define GF_TIME         34
#define GF_GRAVITY      35
#define GF_KILL_WALL    40
#define GF_KILL_DOOR    41
#define GF_MAKE_WALL    45
#define GF_MAKE_DOOR    46
#define GF_OLD_CLONE    51
#define GF_OLD_POLY             52
#define GF_OLD_HEAL             53
#define GF_OLD_SPEED    54
#define GF_OLD_SLOW             55
#define GF_OLD_CONF             56
#define GF_OLD_SLEEP    57
#define GF_OLD_DRAIN    58
#define GF_AWAY_UNDEAD  61
#define GF_AWAY_EVIL    62
#define GF_AWAY_ALL     63
#define GF_TURN_UNDEAD  64
#define GF_TURN_EVIL    65
#define GF_TURN_ALL     66
#define GF_DISP_UNDEAD  67
#define GF_DISP_EVIL    68
#define GF_DISP_ALL 69
#define GF_DISP_DEMON   70      /* New types for Zangband begin here... */
#define GF_DISP_LIVING  71
#define GF_ROCKET       72
#define GF_NUKE         73
#define GF_MAKE_GLYPH   74
#define GF_STASIS       75
#define GF_STONE_WALL   76
#define GF_DEATH_RAY    77
#define GF_STUN         78
#define GF_HOLY_FIRE    79
#define GF_HELL_FIRE    80
#define GF_DISINTEGRATE 81
#define GF_CHARM        82
#define GF_CONTROL_UNDEAD   83
#define GF_CONTROL_ANIMAL   84
#define GF_PSI         85
#define GF_PSI_DRAIN   86
#define GF_TELEKINESIS  87
#define GF_JAM_DOOR     88
#define GF_DOMINATION   89
#define GF_DISP_GOOD    90
#define GF_RAISE        92
#define GF_DESTRUCTION  94
#define GF_STUN_CONF    95
#define GF_STUN_DAM     96
#define GF_CONF_DAM     98
#define GF_STAR_CHARM   99
#define GF_IMPLOSION    100
#define GF_LAVA_FLOW    101
#define GF_FEAR         102
#define GF_BETWEEN_GATE 103
#define GF_WINDS_MANA   104
#define GF_DEATH        105
#define GF_CONTROL_DEMON 106
#define GF_RAISE_DEMON 107
#define GF_TRAP_DEMONSOUL 108
#define GF_ATTACK       109
#define GF_CHARM_UNMOVING 110
#define GF_INSTA_DEATH 111
#define GF_ELEMENTAL_WALL 112
#define GF_ELEMENTAL_GROWTH 113
#define MAX_GF          114

/*
 * Some things which induce learning
 */
#define DRS_NONE         0
#define DRS_ACID         1
#define DRS_ELEC         2
#define DRS_FIRE         3
#define DRS_COLD         4
#define DRS_POIS         5
#define DRS_NETH         6
#define DRS_LITE         7
#define DRS_DARK         8
#define DRS_FEAR         9
#define DRS_CONF        10
#define DRS_CHAOS       11
#define DRS_DISEN       12
#define DRS_BLIND       13
#define DRS_NEXUS       14
#define DRS_SOUND       15
#define DRS_SHARD       16
#define DRS_FREE        30
#define DRS_MANA        31
#define DRS_REFLECT     32



/*
 * Hack -- first "normal" artifact in the artifact list.  All of
 * the artifacts with indexes from 1 to 15 are "special" (lights,
 * rings, amulets), and the ones from 16 to 127 are "normal".
 */
#define ART_MIN_NORMAL          16
#define ART_MIN_SPECIAL         200


/*
 * Hack -- special "xtra" object powers
 */

/* Sustain one stat */
#define EGO_XTRA_SUSTAIN        1

/* High resist */
#define EGO_XTRA_POWER          2


/*
 * Special Monster Flags
 */
#define MFLAG_VIEW      0x00000001    /* Monster is in line of sight */
#define MFLAG_QUEST     0x00000002    /* Monster is subject to a quest */
#define MFLAG_PARTIAL   0x00000004    /* Monster is a partial summon */
#define MFLAG_CONTROL   0x00000008    /* Monster is controlled */
#define MFLAG_BORN      0x00000010    /* Monster is still being born */
#define MFLAG_NICE      0x00000020    /* Monster is still being nice */
#define MFLAG_SHOW      0x00000040    /* Monster is recently memorized */
#define MFLAG_MARK      0x00000080    /* Monster is currently memorized */
#define MFLAG_NO_DROP   0x00000100    /* Monster wont drop obj/corpse */
#define MFLAG_QUEST2    0x00000200    /* Monster is subject to a quest */
#define PERM_MFLAG_MASK ( \
        MFLAG_QUEST | MFLAG_QUEST2 | \
        MFLAG_PARTIAL | MFLAG_CONTROL | MFLAG_NO_DROP \
        )

#define NEW_GROUP_CHANCE        40      /* Chance to get a new group */

/*** Town flags ***/
#define TOWN_REAL	0x01	/* Town is really present */
#define TOWN_KNOWN	0x02	/* Town is found by the player */



/*
 * New monster blow methods
 */
#define RBM_ANY          0
#define RBM_HIT          1
#define RBM_TOUCH        2
#define RBM_PUNCH        3
#define RBM_KICK         4
#define RBM_CLAW         5
#define RBM_BITE         6
#define RBM_STING        7
#define RBM_XXX1         8
#define RBM_BUTT         9
#define RBM_CRUSH       10
#define RBM_ENGULF      11
#define RBM_CHARGE      12
#define RBM_CRAWL       13
#define RBM_DROOL       14
#define RBM_SPIT        15
#define RBM_EXPLODE     16
#define RBM_GAZE        17
#define RBM_WAIL        18
#define RBM_SPORE       19
#define RBM_XXX4        20
#define RBM_BEG         21
#define RBM_INSULT      22
#define RBM_MOAN        23
#define RBM_SHOW        24


/*
 * New monster blow effects
 */
#define RBE_ANY          0
#define RBE_HURT         1
#define RBE_POISON       2
#define RBE_UN_BONUS     3
#define RBE_UN_POWER     4
#define RBE_EAT_GOLD     5
#define RBE_EAT_ITEM     6
#define RBE_EAT_FOOD     7
#define RBE_EAT_LITE     8
#define RBE_ACID         9
#define RBE_ELEC        10
#define RBE_FIRE        11
#define RBE_COLD        12
#define RBE_BLIND       13
#define RBE_CONFUSE     14
#define RBE_TERRIFY     15
#define RBE_PARALYZE    16
#define RBE_LOSE_STR    17
#define RBE_LOSE_INT    18
#define RBE_LOSE_WIS    19
#define RBE_LOSE_DEX    20
#define RBE_LOSE_CON    21
#define RBE_LOSE_CHR    22
#define RBE_LOSE_ALL    23
#define RBE_SHATTER     24
#define RBE_EXP_10      25
#define RBE_EXP_20      26
#define RBE_EXP_40      27
#define RBE_EXP_80      28
#define RBE_DISEASE     29
#define RBE_TIME        30
#define RBE_SANITY      31
#define RBE_HALLU       32
#define RBE_PARASITE    33
#define RBE_ABOMINATION 34


/*** Monster flag values (hard-coded) ***/

#define MONSTER_LEVEL_MAX       150


/*** Macro Definitions ***/


/*
 * Road flags
 */
#define ROAD_NORTH	1
#define ROAD_SOUTH	2
#define ROAD_EAST	4
#define ROAD_WEST	8


/*
 * Buildings actions
 */
#define BACT_TOWN_HISTORY            2
#define BACT_RACE_LEGENDS            3
#define BACT_KING_LEGENDS            5
#define BACT_QUEST1                  6
#define BACT_IN_BETWEEN             12
#define BACT_GAMBLE_RULES           13
#define BACT_CRAPS                  14
#define BACT_DICE_SLOTS             16
#define BACT_REST                   17
#define BACT_FOOD                   18
#define BACT_RUMORS                 19
#define BACT_COMPARE_WEAPONS        21
#define BACT_ENCHANT_WEAPON         23
#define BACT_ENCHANT_ARMOR          24
#define BACT_RECHARGE               25
#define BACT_HEALING                28
#define BACT_RESTORE                29
#define BACT_ENCHANT_ARROWS         30
#define BACT_ENCHANT_BOW            31
#define BACT_RECALL                 33
#define BACT_TELEPORT_LEVEL         34
#define BACT_MIMIC_NORMAL           37
#define BACT_DIVINATION             42
#define BACT_SELL                   43
#define BACT_BUY                    44
#define BACT_EXAMINE                45
#define BACT_STEAL                  46
#define BACT_STAR_HEAL              50
#define BACT_DROP_ITEM              54
#define BACT_GET_ITEM               55
#define BACT_FIREPROOF_QUEST        56
#define BACT_LIBRARY_QUEST          61
#define BACT_EREBOR_KEY             66
/* If one adds new BACT_ do NOT forget to increase max_bact in variables.c */


/*
 * Quest status
 */
#define QUEST_STATUS_IGNORED         -1
#define QUEST_STATUS_UNTAKEN         0
#define QUEST_STATUS_TAKEN           1
#define QUEST_STATUS_COMPLETED       2
#define QUEST_STATUS_REWARDED        3
#define QUEST_STATUS_FAILED          4
#define QUEST_STATUS_FINISHED        5
#define QUEST_STATUS_FAILED_DONE     6

/*
 * Quest flags
 */
#define QUEST_FLAG_SILENT  0x01 /* no messages for completion */
#define QUEST_FLAG_PRESET  0x02 /* quest is outside the main dungeon */
#define QUEST_FLAG_ONCE    0x04 /* quest is marked finished after leaving */

/*
 * Initialization flags
 */
#define INIT_SHOW_TEXT        0x01
#define INIT_ASSIGN           0x02
#define INIT_CREATE_DUNGEON   0x04
#define INIT_GET_SIZE         0x08
#define INIT_POSITION         0x10

/*
 * Fate
 */
#define MAX_FATES               200

#define FATE_NONE               0
#define FATE_FIND_O             1
#define FATE_NO_DIE_MORTAL      2
#define FATE_FIND_A             3
#define FATE_FIND_R             4
#define FATE_FIND_V             5
#define FATE_DIE                6

/*
 * Defines of the different dungeon types
 */
#define DUNGEON_WILDERNESS      0
#define DUNGEON_MIRKWOOD        1
#define DUNGEON_MORDOR          2
#define DUNGEON_ANGBAND         3
#define DUNGEON_BARROW_DOWNS    4
#define DUNGEON_MOUNT_DOOM      5
#define DUNGEON_NETHER_REALM    6
#define DUNGEON_NUMENOR         7
#define DUNGEON_MANDOS          8
#define DUNGEON_VOID            11
#define DUNGEON_MAZE            18
#define DUNGEON_DOL_GULDUR      23

/* Max depth of each dungeon(max_depth - min_depth) */
#define MAX_DUNGEON_DEPTH       128

#define DUNGEON_MODE_NONE       0
#define DUNGEON_MODE_AND        1
#define DUNGEON_MODE_NAND       2
#define DUNGEON_MODE_OR         3
#define DUNGEON_MODE_NOR        4


/*
 * Returns the dungeon level or the feat,
 * if the player is not in a dungeon
 */
#define level_or_feat(DTYPE, DLEVEL) \
	((DTYPE) == DUNGEON_WILDERNESS ? \
	        (game->wilderness)(p_ptr->wilderness_x, p_ptr->wilderness_y).feat : \
		(DLEVEL) )


/*
 * Defines for the inscriptions
 */
#define INSCRIP_EXEC_ENGRAVE    0x01
#define INSCRIP_EXEC_WALK       0x02
#define INSCRIP_EXEC_MONST_WALK 0x04

#define INSCRIP_NONE            0
#define INSCRIP_LIGHT           1
#define INSCRIP_DARK            2
#define INSCRIP_STORM           3
#define INSCRIP_PROTECTION      4
#define INSCRIP_DWARF_SUMMON    5
#define INSCRIP_CHASM           6
#define INSCRIP_BLACK_FIRE      7
#define MAX_INSCRIPTIONS        8

/*
 * Various class dependant defines
 */
#define CLASS_NONE              0

#define CLASS_UNDEAD                    0x0008
#define CLASS_ANTIMAGIC                 0x0010
#define CLASS_LEGS                      0x0020
#define CLASS_ARMS                      0x0040
#define CLASS_WALL                      0x0080

/*
 * Types of birth presents
 */
#define BIRTH_NONE      0
#define BIRTH_RING      1
#define BIRTH_AMULET    2

/*
 * Automatic note taking types
 */
#define NOTE_BIRTH		1
#define NOTE_WINNER		2
#define NOTE_SAVE_GAME		3
#define NOTE_ENTER_DUNGEON	4

/* Stores/buildings defines */
#define STORE_HATED     0
#define STORE_LIKED     1
#define STORE_NORMAL    2

/* Wilderness map related */
#define WILDERNESS_SEE_RADIUS   3       /* The amount of wilderness seen around the player */

/* Ego monsters defines */
#define MEGO_CHAR_ANY           127
#define MEGO_ADD                0
#define MEGO_SUB                1
#define MEGO_FIX                2
#define MEGO_PRC                3

#define MEGO_CHANCE             18      /* % chances of getting ego monsters */

/*
 * Used (or should be) by various functions and tables needing access to
 * single bits
 */
#define BIT(x) (1L << (x))

/* Town defines */
#define TOWN_RANDOM     20              /* First random town */
#define TOWN_CHANCE     50              /* Chance of 1 town */


/*
 * Shield effect options
 */
#define SHIELD_NONE             0x0000
#define SHIELD_COUNTER          0x0001
#define SHIELD_FIRE             0x0002
#define SHIELD_GREAT_FIRE       0x0004
#define SHIELD_FEAR             0x0008

/*
 * Quest constants
 */
#define MAX_MON_QUEST       10
#define MAX_ITEM_QUEST       5

#define MAX_RANDOM_QUEST    99

#define QUEST_NULL              0
#define QUEST_NECRO             1
#define QUEST_SAURON            2
#define QUEST_MORGOTH           3
#define QUEST_THIEVES           4
#define QUEST_RANDOM            5
#define QUEST_HOBBIT            6
#define QUEST_NAZGUL            7
#define QUEST_TROLL             8
#define QUEST_WIGHT             9
#define QUEST_SPIDER            10
#define QUEST_POISON            11
#define QUEST_NARSIL            12
#define QUEST_EOL               13
#define QUEST_NIRNAETH          14
#define QUEST_INVASION          15
#define QUEST_BETWEEN           16
#define QUEST_ONE               17
#define QUEST_SHROOM            18
#define QUEST_THRAIN            19
#define QUEST_ULTRA_GOOD        20
#define QUEST_ULTRA_EVIL        21
#define QUEST_WOLVES            22
#define QUEST_DRAGONS           23
#define QUEST_HAUNTED           24
#define QUEST_EVIL              25
#define QUEST_BOUNTY            26
#define QUEST_FIREPROOF         27
#define QUEST_LIBRARY           28
#define QUEST_GOD               29
#define MAX_Q_IDX               30

#define PLOT_MAIN               0
#define PLOT_BREE               1
#define PLOT_LORIEN             2
#define PLOT_OTHER              3
#define PLOT_GONDOLIN           4
#define PLOT_MINAS              5
#define PLOT_KHAZAD             6
#define MAX_PLOTS               7

/*
 * Modules
 */
#define MODULE_TOME             0
#define MODULE_THEME            1
#define MAX_MODULES             2

/*
 * Races
 */
#define RACE_HUMAN 0
#define RACE_HALF_ELF 1
#define RACE_ELF 2
#define RACE_HOBBIT 3
#define RACE_GNOME 4
#define RACE_DWARF 5
#define RACE_ORC 6
#define RACE_TROLL 7
#define RACE_DUNADAN 8
#define RACE_HIGH_ELF 9
#define RACE_HALF_OGRE 10
#define RACE_BEORNING 11
#define RACE_KOBOLD 12        /* ToME */
#define RACE_DRUADAN 12       /* Theme */
#define RACE_PETTY_DWARF 13
#define RACE_DARK_ELF 14
#define RACE_ENT 15
#define RACE_ROHANKNIGHT 16
#define RACE_THUNDERLORD 17 /* ToME */
#define RACE_EAGLE 17       /* Theme */
#define RACE_DEATHMOLD 18   /* ToME */
#define RACE_DRAGON 18      /* Theme */
#define RACE_YEEK 19
#define RACE_WOOD_ELF 20
#define RACE_MAIA 21
#define RACE_EASTERLING 22 /* Theme */
#define RACE_DEMON 23 /* Theme */

/*
 * Hooks
 */
#define HOOK_MONSTER_DEATH      0
#define HOOK_GEN_QUEST          2
#define HOOK_END_TURN           3
#define HOOK_FEELING            4
#define HOOK_NEW_MONSTER        5
#define HOOK_GEN_LEVEL          6
#define HOOK_BUILD_ROOM1        7
#define HOOK_NEW_LEVEL          8
#define HOOK_QUEST_FINISH       9
#define HOOK_QUEST_FAIL         10
#define HOOK_GIVE               11
#define HOOK_CHAR_DUMP          12
#define HOOK_INIT_QUEST         13
#define HOOK_WILD_GEN           14
#define HOOK_DROP               15
#define HOOK_IDENTIFY           16
#define HOOK_MOVE               17
#define HOOK_STAIR              18
#define HOOK_MONSTER_AI         19
#define HOOK_PLAYER_LEVEL       20
#define HOOK_WIELD              21
#define HOOK_NEW_MONSTER_END    22
#define HOOK_AIM                24
#define HOOK_USE                25
#define HOOK_CHAT               32
#define HOOK_MON_SPEAK          33
#define HOOK_BIRTH_OBJECTS      35
#define HOOK_SAVE_GAME          40
#define HOOK_LOAD_GAME          41
#define HOOK_LEVEL_REGEN        42
#define HOOK_LEVEL_END_GEN      43
#define HOOK_GEN_LEVEL_BEGIN    49
#define HOOK_GET                50
#define HOOK_RECALC_SKILLS      52
#define HOOK_ENTER_DUNGEON      53
#define HOOK_EAT                55
#define HOOK_DIE                56
#define HOOK_CALC_HP            57
#define HOOK_CALC_MANA          60
#define HOOK_RECALL             62
#define HOOK_BODY_PARTS         65
#define HOOK_MON_ASK_HELP       69
#define HOOK_GAME_START         72
#define HOOK_FORBID_TRAVEL      75

/*
 * Special weapon effects
 */
#define SPEC_POIS               0x00000001L
#define SPEC_CUT                0x00000002L

/*
 * Ambushes in the wild
 */
#define AMBUSH_RACE             1
#define AMBUSH_MIX              2

/*
 * Macro trigger
 */
#define MAX_MACRO_MOD 12
#define MAX_MACRO_TRIG 200


/*
 * Skills !
 */
#define SKILL_MAX               50000           /* Maximun skill value */
#define SKILL_STEP              1000            /* 1 skill point */

#define SKILL_EXCLUSIVE         9999            /* Flag to tell exclusive skills */

/* Number of skill choices for Lost Sword quests. */
#define LOST_SWORD_NSKILLS	4

#define MAX_MELEE               3


/*
 * Spellbinder triggers
 */
#define SPELLBINDER_HP75        1
#define SPELLBINDER_HP50        2
#define SPELLBINDER_HP25        3

/*
 * God's defines
 */
#define GOD_ALL                 -1
#define GOD_NONE                0
#define GOD_ERU                 1
#define GOD_MANWE               2
#define GOD_TULKAS              3
#define GOD_MELKOR              4
#define GOD_YAVANNA             5
#define GOD_AULE                6
#define GOD_VARDA               7
#define GOD_ULMO                8
#define GOD_MANDOS              9
#define MAX_GODS               10

/*
 * Command numbers for do_cmd_cli().
 *
 * As the user is not intended to have a way to enter these codes directly
 * (doing so isn't harmful, but these codes are not intended as mnemonics),
 * only codes in the range 0xE000 - 0xF8FF (the private area of Unicode 3.0)
 * should be used.
 *
 * In addition, values at the lower end of this range are preferred as the upper
 * end may have a system-specific encoding
 */
#define CMD_CLI_HELP	-8192
#define CMD_SHOW_TIME	-8188
#define CMD_SHOW_SKILL	-8187
#define CMD_DUMP_HTML	-8186
#define CMD_MACRO    	-8185
#define CMD_QUEST    	-8184
#define CMD_SHOW_ABILITY -8182

#define CLI_MAX	128


/*
 * The various winner state
 */
#define WINNER_NORMAL           1
#define WINNER_ULTRA            2

/*
 * The abilities
 */
#define AB_SPREAD_BLOWS         0
#define AB_TREE_WALK            1
#define AB_PERFECT_CASTING      2
#define AB_MAX_BLOW1            3
#define AB_MAX_BLOW2            4
#define AB_AMMO_CREATION        5
#define AB_DEATH_TOUCH          6
#define AB_FAR_REACHING         8
#define AB_UNDEAD_FORM          10

/**
 * Spell school books/tomes
 */
#define TOME_MANA 0
#define TOME_FIRE 1
#define TOME_WINDS 2
#define TOME_EARTH 3
#define TOME_WATER 4
#define TOME_TRANSLOCATION 5
#define TOME_NATURE 6
#define TOME_KNOWLEDGE 7
#define TOME_TIME 8
#define TOME_META 9
#define TOME_MIND 10
#define TOME_HELLFLAME 11
#define TOME_ERU 20
#define TOME_MANWE 21
#define TOME_TULKAS 22
#define TOME_MELKOR 23
#define TOME_YAVANNA 24
#define BOOK_CANTRIPS 50
#define BOOK_TELEPORTATION 51
#define BOOK_SUMMONING 52
#define BOOK_DEMON_SWORD 55
#define BOOK_DEMON_SHIELD 56
#define BOOK_DEMON_HELM 57
#define BOOK_DRUMS 58
#define BOOK_HARPS 59
#define BOOK_HORNS 60
#define BOOK_PLAYER 61
#define BOOK_GEOMANCY 62
#define BOOK_AULE 63
#define BOOK_VARDA 64
#define BOOK_ULMO 65
#define BOOK_MANDOS 66
#define BOOK_RANDOM 255

#define SCHOOL_BOOKS_SIZE 256

/**
 * Macro to generate a memoizing named monster lookup function.
 *
 * This is meant as a stopgap measure until a better method
 * can be implemented.
 */
#define GENERATE_MONSTER_LOOKUP_FN(fn, name) \
	static int fn()\
	{\
		static int r_idx = -1;\
		if (r_idx < 0)\
		{\
			r_idx = test_monster_name(name);\
			assert(r_idx);\
		}\
		return r_idx;\
	}
