// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/Microsoft/hcsshim/cmd/containerd-shim-runhcs-v1/stats/stats.proto

package stats

import (
	fmt "fmt"
	v1 "github.com/containerd/cgroups/stats/v1"
	proto "github.com/gogo/protobuf/proto"
	_ "github.com/gogo/protobuf/types"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	io "io"
	math "math"
	reflect "reflect"
	strings "strings"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type Statistics struct {
	// Types that are valid to be assigned to Container:
	//	*Statistics_Windows
	//	*Statistics_Linux
	Container            isStatistics_Container    `protobuf_oneof:"container"`
	VM                   *VirtualMachineStatistics `protobuf:"bytes,3,opt,name=vm,proto3" json:"vm,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *Statistics) Reset()      { *m = Statistics{} }
func (*Statistics) ProtoMessage() {}
func (*Statistics) Descriptor() ([]byte, []int) {
	return fileDescriptor_23217f96da3a05cc, []int{0}
}
func (m *Statistics) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Statistics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Statistics.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Statistics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Statistics.Merge(m, src)
}
func (m *Statistics) XXX_Size() int {
	return m.Size()
}
func (m *Statistics) XXX_DiscardUnknown() {
	xxx_messageInfo_Statistics.DiscardUnknown(m)
}

var xxx_messageInfo_Statistics proto.InternalMessageInfo

type isStatistics_Container interface {
	isStatistics_Container()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Statistics_Windows struct {
	Windows *WindowsContainerStatistics `protobuf:"bytes,1,opt,name=windows,proto3,oneof"`
}
type Statistics_Linux struct {
	Linux *v1.Metrics `protobuf:"bytes,2,opt,name=linux,proto3,oneof"`
}

func (*Statistics_Windows) isStatistics_Container() {}
func (*Statistics_Linux) isStatistics_Container()   {}

func (m *Statistics) GetContainer() isStatistics_Container {
	if m != nil {
		return m.Container
	}
	return nil
}

func (m *Statistics) GetWindows() *WindowsContainerStatistics {
	if x, ok := m.GetContainer().(*Statistics_Windows); ok {
		return x.Windows
	}
	return nil
}

func (m *Statistics) GetLinux() *v1.Metrics {
	if x, ok := m.GetContainer().(*Statistics_Linux); ok {
		return x.Linux
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Statistics) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Statistics_OneofMarshaler, _Statistics_OneofUnmarshaler, _Statistics_OneofSizer, []interface{}{
		(*Statistics_Windows)(nil),
		(*Statistics_Linux)(nil),
	}
}

func _Statistics_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Statistics)
	// container
	switch x := m.Container.(type) {
	case *Statistics_Windows:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Windows); err != nil {
			return err
		}
	case *Statistics_Linux:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Linux); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Statistics.Container has unexpected type %T", x)
	}
	return nil
}

func _Statistics_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Statistics)
	switch tag {
	case 1: // container.windows
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(WindowsContainerStatistics)
		err := b.DecodeMessage(msg)
		m.Container = &Statistics_Windows{msg}
		return true, err
	case 2: // container.linux
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(v1.Metrics)
		err := b.DecodeMessage(msg)
		m.Container = &Statistics_Linux{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Statistics_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Statistics)
	// container
	switch x := m.Container.(type) {
	case *Statistics_Windows:
		s := proto.Size(x.Windows)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Statistics_Linux:
		s := proto.Size(x.Linux)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type WindowsContainerStatistics struct {
	Timestamp            time.Time                            `protobuf:"bytes,1,opt,name=timestamp,proto3,stdtime" json:"timestamp"`
	ContainerStartTime   time.Time                            `protobuf:"bytes,2,opt,name=container_start_time,json=containerStartTime,proto3,stdtime" json:"container_start_time"`
	UptimeNS             uint64                               `protobuf:"varint,3,opt,name=uptime_ns,json=uptimeNs,proto3" json:"uptime_ns,omitempty"`
	Processor            *WindowsContainerProcessorStatistics `protobuf:"bytes,4,opt,name=processor,proto3" json:"processor,omitempty"`
	Memory               *WindowsContainerMemoryStatistics    `protobuf:"bytes,5,opt,name=memory,proto3" json:"memory,omitempty"`
	Storage              *WindowsContainerStorageStatistics   `protobuf:"bytes,6,opt,name=storage,proto3" json:"storage,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *WindowsContainerStatistics) Reset()      { *m = WindowsContainerStatistics{} }
func (*WindowsContainerStatistics) ProtoMessage() {}
func (*WindowsContainerStatistics) Descriptor() ([]byte, []int) {
	return fileDescriptor_23217f96da3a05cc, []int{1}
}
func (m *WindowsContainerStatistics) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WindowsContainerStatistics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WindowsContainerStatistics.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WindowsContainerStatistics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowsContainerStatistics.Merge(m, src)
}
func (m *WindowsContainerStatistics) XXX_Size() int {
	return m.Size()
}
func (m *WindowsContainerStatistics) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowsContainerStatistics.DiscardUnknown(m)
}

var xxx_messageInfo_WindowsContainerStatistics proto.InternalMessageInfo

type WindowsContainerProcessorStatistics struct {
	TotalRuntimeNS       uint64   `protobuf:"varint,1,opt,name=total_runtime_ns,json=totalRuntimeNs,proto3" json:"total_runtime_ns,omitempty"`
	RuntimeUserNS        uint64   `protobuf:"varint,2,opt,name=runtime_user_ns,json=runtimeUserNs,proto3" json:"runtime_user_ns,omitempty"`
	RuntimeKernelNS      uint64   `protobuf:"varint,3,opt,name=runtime_kernel_ns,json=runtimeKernelNs,proto3" json:"runtime_kernel_ns,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WindowsContainerProcessorStatistics) Reset()      { *m = WindowsContainerProcessorStatistics{} }
func (*WindowsContainerProcessorStatistics) ProtoMessage() {}
func (*WindowsContainerProcessorStatistics) Descriptor() ([]byte, []int) {
	return fileDescriptor_23217f96da3a05cc, []int{2}
}
func (m *WindowsContainerProcessorStatistics) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WindowsContainerProcessorStatistics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WindowsContainerProcessorStatistics.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WindowsContainerProcessorStatistics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowsContainerProcessorStatistics.Merge(m, src)
}
func (m *WindowsContainerProcessorStatistics) XXX_Size() int {
	return m.Size()
}
func (m *WindowsContainerProcessorStatistics) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowsContainerProcessorStatistics.DiscardUnknown(m)
}

var xxx_messageInfo_WindowsContainerProcessorStatistics proto.InternalMessageInfo

type WindowsContainerMemoryStatistics struct {
	MemoryUsageCommitBytes            uint64   `protobuf:"varint,1,opt,name=memory_usage_commit_bytes,json=memoryUsageCommitBytes,proto3" json:"memory_usage_commit_bytes,omitempty"`
	MemoryUsageCommitPeakBytes        uint64   `protobuf:"varint,2,opt,name=memory_usage_commit_peak_bytes,json=memoryUsageCommitPeakBytes,proto3" json:"memory_usage_commit_peak_bytes,omitempty"`
	MemoryUsagePrivateWorkingSetBytes uint64   `protobuf:"varint,3,opt,name=memory_usage_private_working_set_bytes,json=memoryUsagePrivateWorkingSetBytes,proto3" json:"memory_usage_private_working_set_bytes,omitempty"`
	XXX_NoUnkeyedLiteral              struct{} `json:"-"`
	XXX_unrecognized                  []byte   `json:"-"`
	XXX_sizecache                     int32    `json:"-"`
}

func (m *WindowsContainerMemoryStatistics) Reset()      { *m = WindowsContainerMemoryStatistics{} }
func (*WindowsContainerMemoryStatistics) ProtoMessage() {}
func (*WindowsContainerMemoryStatistics) Descriptor() ([]byte, []int) {
	return fileDescriptor_23217f96da3a05cc, []int{3}
}
func (m *WindowsContainerMemoryStatistics) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WindowsContainerMemoryStatistics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WindowsContainerMemoryStatistics.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WindowsContainerMemoryStatistics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowsContainerMemoryStatistics.Merge(m, src)
}
func (m *WindowsContainerMemoryStatistics) XXX_Size() int {
	return m.Size()
}
func (m *WindowsContainerMemoryStatistics) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowsContainerMemoryStatistics.DiscardUnknown(m)
}

var xxx_messageInfo_WindowsContainerMemoryStatistics proto.InternalMessageInfo

type WindowsContainerStorageStatistics struct {
	ReadCountNormalized  uint64   `protobuf:"varint,1,opt,name=read_count_normalized,json=readCountNormalized,proto3" json:"read_count_normalized,omitempty"`
	ReadSizeBytes        uint64   `protobuf:"varint,2,opt,name=read_size_bytes,json=readSizeBytes,proto3" json:"read_size_bytes,omitempty"`
	WriteCountNormalized uint64   `protobuf:"varint,3,opt,name=write_count_normalized,json=writeCountNormalized,proto3" json:"write_count_normalized,omitempty"`
	WriteSizeBytes       uint64   `protobuf:"varint,4,opt,name=write_size_bytes,json=writeSizeBytes,proto3" json:"write_size_bytes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WindowsContainerStorageStatistics) Reset()      { *m = WindowsContainerStorageStatistics{} }
func (*WindowsContainerStorageStatistics) ProtoMessage() {}
func (*WindowsContainerStorageStatistics) Descriptor() ([]byte, []int) {
	return fileDescriptor_23217f96da3a05cc, []int{4}
}
func (m *WindowsContainerStorageStatistics) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WindowsContainerStorageStatistics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WindowsContainerStorageStatistics.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WindowsContainerStorageStatistics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowsContainerStorageStatistics.Merge(m, src)
}
func (m *WindowsContainerStorageStatistics) XXX_Size() int {
	return m.Size()
}
func (m *WindowsContainerStorageStatistics) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowsContainerStorageStatistics.DiscardUnknown(m)
}

var xxx_messageInfo_WindowsContainerStorageStatistics proto.InternalMessageInfo

type VirtualMachineStatistics struct {
	Processor            *VirtualMachineProcessorStatistics `protobuf:"bytes,1,opt,name=processor,proto3" json:"processor,omitempty"`
	Memory               *VirtualMachineMemoryStatistics    `protobuf:"bytes,2,opt,name=memory,proto3" json:"memory,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *VirtualMachineStatistics) Reset()      { *m = VirtualMachineStatistics{} }
func (*VirtualMachineStatistics) ProtoMessage() {}
func (*VirtualMachineStatistics) Descriptor() ([]byte, []int) {
	return fileDescriptor_23217f96da3a05cc, []int{5}
}
func (m *VirtualMachineStatistics) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VirtualMachineStatistics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VirtualMachineStatistics.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VirtualMachineStatistics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VirtualMachineStatistics.Merge(m, src)
}
func (m *VirtualMachineStatistics) XXX_Size() int {
	return m.Size()
}
func (m *VirtualMachineStatistics) XXX_DiscardUnknown() {
	xxx_messageInfo_VirtualMachineStatistics.DiscardUnknown(m)
}

var xxx_messageInfo_VirtualMachineStatistics proto.InternalMessageInfo

type VirtualMachineProcessorStatistics struct {
	TotalRuntimeNS       uint64   `protobuf:"varint,1,opt,name=total_runtime_ns,json=totalRuntimeNs,proto3" json:"total_runtime_ns,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VirtualMachineProcessorStatistics) Reset()      { *m = VirtualMachineProcessorStatistics{} }
func (*VirtualMachineProcessorStatistics) ProtoMessage() {}
func (*VirtualMachineProcessorStatistics) Descriptor() ([]byte, []int) {
	return fileDescriptor_23217f96da3a05cc, []int{6}
}
func (m *VirtualMachineProcessorStatistics) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VirtualMachineProcessorStatistics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VirtualMachineProcessorStatistics.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VirtualMachineProcessorStatistics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VirtualMachineProcessorStatistics.Merge(m, src)
}
func (m *VirtualMachineProcessorStatistics) XXX_Size() int {
	return m.Size()
}
func (m *VirtualMachineProcessorStatistics) XXX_DiscardUnknown() {
	xxx_messageInfo_VirtualMachineProcessorStatistics.DiscardUnknown(m)
}

var xxx_messageInfo_VirtualMachineProcessorStatistics proto.InternalMessageInfo

type VirtualMachineMemoryStatistics struct {
	WorkingSetBytes      uint64                `protobuf:"varint,1,opt,name=working_set_bytes,json=workingSetBytes,proto3" json:"working_set_bytes,omitempty"`
	VirtualNodeCount     uint32                `protobuf:"varint,2,opt,name=virtual_node_count,json=virtualNodeCount,proto3" json:"virtual_node_count,omitempty"`
	VmMemory             *VirtualMachineMemory `protobuf:"bytes,3,opt,name=vm_memory,json=vmMemory,proto3" json:"vm_memory,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *VirtualMachineMemoryStatistics) Reset()      { *m = VirtualMachineMemoryStatistics{} }
func (*VirtualMachineMemoryStatistics) ProtoMessage() {}
func (*VirtualMachineMemoryStatistics) Descriptor() ([]byte, []int) {
	return fileDescriptor_23217f96da3a05cc, []int{7}
}
func (m *VirtualMachineMemoryStatistics) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VirtualMachineMemoryStatistics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VirtualMachineMemoryStatistics.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VirtualMachineMemoryStatistics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VirtualMachineMemoryStatistics.Merge(m, src)
}
func (m *VirtualMachineMemoryStatistics) XXX_Size() int {
	return m.Size()
}
func (m *VirtualMachineMemoryStatistics) XXX_DiscardUnknown() {
	xxx_messageInfo_VirtualMachineMemoryStatistics.DiscardUnknown(m)
}

var xxx_messageInfo_VirtualMachineMemoryStatistics proto.InternalMessageInfo

type VirtualMachineMemory struct {
	AvailableMemory       int32    `protobuf:"varint,1,opt,name=available_memory,json=availableMemory,proto3" json:"available_memory,omitempty"`
	AvailableMemoryBuffer int32    `protobuf:"varint,2,opt,name=available_memory_buffer,json=availableMemoryBuffer,proto3" json:"available_memory_buffer,omitempty"`
	ReservedMemory        uint64   `protobuf:"varint,3,opt,name=reserved_memory,json=reservedMemory,proto3" json:"reserved_memory,omitempty"`
	AssignedMemory        uint64   `protobuf:"varint,4,opt,name=assigned_memory,json=assignedMemory,proto3" json:"assigned_memory,omitempty"`
	SlpActive             bool     `protobuf:"varint,5,opt,name=slp_active,json=slpActive,proto3" json:"slp_active,omitempty"`
	BalancingEnabled      bool     `protobuf:"varint,6,opt,name=balancing_enabled,json=balancingEnabled,proto3" json:"balancing_enabled,omitempty"`
	DmOperationInProgress bool     `protobuf:"varint,7,opt,name=dm_operation_in_progress,json=dmOperationInProgress,proto3" json:"dm_operation_in_progress,omitempty"`
	XXX_NoUnkeyedLiteral  struct{} `json:"-"`
	XXX_unrecognized      []byte   `json:"-"`
	XXX_sizecache         int32    `json:"-"`
}

func (m *VirtualMachineMemory) Reset()      { *m = VirtualMachineMemory{} }
func (*VirtualMachineMemory) ProtoMessage() {}
func (*VirtualMachineMemory) Descriptor() ([]byte, []int) {
	return fileDescriptor_23217f96da3a05cc, []int{8}
}
func (m *VirtualMachineMemory) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VirtualMachineMemory) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VirtualMachineMemory.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VirtualMachineMemory) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VirtualMachineMemory.Merge(m, src)
}
func (m *VirtualMachineMemory) XXX_Size() int {
	return m.Size()
}
func (m *VirtualMachineMemory) XXX_DiscardUnknown() {
	xxx_messageInfo_VirtualMachineMemory.DiscardUnknown(m)
}

var xxx_messageInfo_VirtualMachineMemory proto.InternalMessageInfo

func init() {
	proto.RegisterType((*Statistics)(nil), "containerd.runhcs.stats.v1.Statistics")
	proto.RegisterType((*WindowsContainerStatistics)(nil), "containerd.runhcs.stats.v1.WindowsContainerStatistics")
	proto.RegisterType((*WindowsContainerProcessorStatistics)(nil), "containerd.runhcs.stats.v1.WindowsContainerProcessorStatistics")
	proto.RegisterType((*WindowsContainerMemoryStatistics)(nil), "containerd.runhcs.stats.v1.WindowsContainerMemoryStatistics")
	proto.RegisterType((*WindowsContainerStorageStatistics)(nil), "containerd.runhcs.stats.v1.WindowsContainerStorageStatistics")
	proto.RegisterType((*VirtualMachineStatistics)(nil), "containerd.runhcs.stats.v1.VirtualMachineStatistics")
	proto.RegisterType((*VirtualMachineProcessorStatistics)(nil), "containerd.runhcs.stats.v1.VirtualMachineProcessorStatistics")
	proto.RegisterType((*VirtualMachineMemoryStatistics)(nil), "containerd.runhcs.stats.v1.VirtualMachineMemoryStatistics")
	proto.RegisterType((*VirtualMachineMemory)(nil), "containerd.runhcs.stats.v1.VirtualMachineMemory")
}

func init() {
	proto.RegisterFile("github.com/Microsoft/hcsshim/cmd/containerd-shim-runhcs-v1/stats/stats.proto", fileDescriptor_23217f96da3a05cc)
}

var fileDescriptor_23217f96da3a05cc = []byte{
	// 1037 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0x6d, 0x6f, 0xdb, 0x44,
	0x1c, 0x8f, 0xb3, 0x3e, 0x24, 0x37, 0xda, 0xb4, 0xb7, 0x76, 0x84, 0x48, 0x24, 0x6b, 0x90, 0xf6,
	0x00, 0x34, 0xa1, 0xa3, 0x1a, 0x1a, 0x0c, 0x4d, 0xa4, 0x02, 0x0d, 0xb1, 0x84, 0x72, 0xe9, 0x03,
	0x02, 0x21, 0x73, 0xb1, 0xaf, 0xee, 0xa9, 0xb6, 0xcf, 0xba, 0x3b, 0xbb, 0xac, 0xaf, 0xf8, 0x08,
	0x7c, 0xac, 0x22, 0xde, 0xec, 0x25, 0xaf, 0x32, 0x96, 0x6f, 0x80, 0x84, 0x78, 0x3d, 0xf9, 0xee,
	0x9c, 0xb8, 0xed, 0xba, 0xb6, 0xda, 0x9b, 0xc8, 0xfe, 0xff, 0x1e, 0xee, 0xff, 0x70, 0xe7, 0x0b,
	0x78, 0xea, 0x51, 0xb9, 0x1f, 0x0f, 0x5a, 0x0e, 0x0b, 0xda, 0x5d, 0xea, 0x70, 0x26, 0xd8, 0x9e,
	0x6c, 0xef, 0x3b, 0x42, 0xec, 0xd3, 0xa0, 0xed, 0x04, 0x6e, 0xdb, 0x61, 0xa1, 0xc4, 0x34, 0x24,
	0xdc, 0x5d, 0x4d, 0x63, 0xab, 0x3c, 0x0e, 0xf7, 0x1d, 0xb1, 0x9a, 0xac, 0xb5, 0x85, 0xc4, 0x52,
	0xe8, 0xdf, 0x56, 0xc4, 0x99, 0x64, 0xb0, 0x36, 0x21, 0xb7, 0x34, 0xaf, 0xa5, 0xe1, 0x64, 0xad,
	0xb6, 0xe4, 0x31, 0x8f, 0x29, 0x5a, 0x3b, 0x7d, 0xd2, 0x8a, 0x5a, 0xc3, 0x63, 0xcc, 0xf3, 0x49,
	0x5b, 0xbd, 0x0d, 0xe2, 0xbd, 0xb6, 0xa4, 0x01, 0x11, 0x12, 0x07, 0x91, 0x21, 0xac, 0xe7, 0x12,
	0x9c, 0xb8, 0xb7, 0x1d, 0x8f, 0xb3, 0x38, 0x32, 0xab, 0xb7, 0x93, 0xb5, 0x76, 0x40, 0x24, 0xa7,
	0x8e, 0x49, 0xa4, 0xf9, 0xbf, 0x05, 0x40, 0x5f, 0x62, 0x49, 0x85, 0xa4, 0x8e, 0x80, 0x08, 0xcc,
	0x1e, 0xd2, 0xd0, 0x65, 0x87, 0xa2, 0x6a, 0xdd, 0xb2, 0xee, 0x5e, 0xbf, 0xff, 0xa0, 0x75, 0x7e,
	0xa6, 0xad, 0x5d, 0x4d, 0xdd, 0xc8, 0x18, 0x13, 0xa3, 0x27, 0x05, 0x94, 0x19, 0xc1, 0x87, 0x60,
	0xda, 0xa7, 0x61, 0xfc, 0x5b, 0xb5, 0xa8, 0x1c, 0x57, 0x5a, 0x94, 0xe5, 0x4d, 0x4d, 0x82, 0xa9,
	0x5f, 0x57, 0xa7, 0xf6, 0xa4, 0x80, 0xb4, 0x02, 0x3e, 0x05, 0xc5, 0x24, 0xa8, 0x5e, 0x53, 0xba,
	0xf5, 0x37, 0x65, 0xb2, 0x43, 0xb9, 0x8c, 0xb1, 0xdf, 0xc5, 0xce, 0x3e, 0x0d, 0xc9, 0x24, 0x8f,
	0xce, 0xcc, 0x68, 0xd8, 0x28, 0xee, 0x74, 0x51, 0x31, 0x09, 0x3a, 0xd7, 0x41, 0x79, 0x6c, 0xd1,
	0xfc, 0xf7, 0x1a, 0xa8, 0x9d, 0x9f, 0x3f, 0xec, 0x80, 0xf2, 0xb8, 0xc1, 0xa6, 0x15, 0xb5, 0x96,
	0x1e, 0x41, 0x2b, 0x1b, 0x41, 0x6b, 0x2b, 0x63, 0x74, 0x4a, 0xc7, 0xc3, 0x46, 0xe1, 0x8f, 0x17,
	0x0d, 0x0b, 0x4d, 0x64, 0x70, 0x07, 0x2c, 0x8d, 0xd7, 0xb3, 0x85, 0xc4, 0x5c, 0xda, 0x29, 0x68,
	0xfa, 0x70, 0x39, 0x3b, 0xe8, 0xe4, 0x92, 0xe3, 0x32, 0xa5, 0xc0, 0x7b, 0xa0, 0x1c, 0x47, 0xa9,
	0x93, 0x1d, 0x0a, 0xd5, 0x9c, 0xa9, 0xce, 0x3b, 0xa3, 0x61, 0xa3, 0xb4, 0xad, 0x82, 0xbd, 0x3e,
	0x2a, 0x69, 0xb8, 0x27, 0xe0, 0x2f, 0xa0, 0x1c, 0x71, 0xe6, 0x10, 0x21, 0x18, 0xaf, 0x4e, 0xa9,
	0x75, 0x1f, 0x5f, 0x65, 0xa2, 0x9b, 0x99, 0x78, 0xd2, 0x1a, 0x34, 0x71, 0x84, 0x5b, 0x60, 0x26,
	0x20, 0x01, 0xe3, 0xcf, 0xaa, 0xd3, 0xca, 0xfb, 0xd1, 0x55, 0xbc, 0xbb, 0x4a, 0x99, 0x33, 0x36,
	0x5e, 0x70, 0x17, 0xcc, 0x0a, 0xc9, 0x38, 0xf6, 0x48, 0x75, 0x46, 0xd9, 0x7e, 0x79, 0xb5, 0x4d,
	0xa8, 0xa4, 0x39, 0xdf, 0xcc, 0xad, 0xf9, 0xc2, 0x02, 0x1f, 0x5c, 0xa2, 0x42, 0xf8, 0x08, 0x2c,
	0x48, 0x26, 0xb1, 0x6f, 0xf3, 0x38, 0xcc, 0xfa, 0x6c, 0xa9, 0x3e, 0xc3, 0xd1, 0xb0, 0x31, 0xbf,
	0x95, 0x62, 0x48, 0x43, 0xbd, 0x3e, 0x9a, 0x97, 0xf9, 0xf7, 0x74, 0xbf, 0x57, 0x32, 0x5d, 0x2c,
	0x08, 0x4f, 0xc5, 0x45, 0x25, 0x5e, 0x1c, 0x0d, 0x1b, 0x73, 0x86, 0xb7, 0x2d, 0x08, 0xef, 0xf5,
	0xd1, 0x1c, 0xcf, 0xbd, 0x0a, 0xf8, 0x18, 0x2c, 0x66, 0xd2, 0x03, 0xc2, 0x43, 0xe2, 0x4f, 0x26,
	0x7c, 0x63, 0x34, 0x6c, 0x54, 0x8c, 0xf8, 0x3b, 0x85, 0xf5, 0xfa, 0x28, 0x5b, 0xc8, 0x04, 0x44,
	0xf3, 0x3f, 0x0b, 0xdc, 0xba, 0xa8, 0xcf, 0xf0, 0x21, 0x78, 0x4f, 0x77, 0xda, 0x8e, 0x05, 0xf6,
	0x88, 0xed, 0xb0, 0x20, 0xa0, 0xd2, 0x1e, 0x3c, 0x93, 0xc4, 0xd4, 0x89, 0x6e, 0x6a, 0xc2, 0x76,
	0x8a, 0x6f, 0x28, 0xb8, 0x93, 0xa2, 0xb0, 0x03, 0xea, 0xaf, 0x93, 0x46, 0x04, 0x1f, 0x18, 0xbd,
	0x2a, 0x15, 0xd5, 0xce, 0xe8, 0x37, 0x09, 0x3e, 0xd0, 0x1e, 0x3f, 0x80, 0xdb, 0x27, 0x3c, 0x22,
	0x4e, 0x13, 0x2c, 0x89, 0x7d, 0xc8, 0xf8, 0x01, 0x0d, 0x3d, 0x5b, 0x90, 0x2c, 0x17, 0x55, 0x39,
	0x5a, 0xc9, 0x79, 0x6d, 0x6a, 0xee, 0xae, 0xa6, 0xf6, 0x89, 0x4e, 0x2b, 0x1d, 0xec, 0xca, 0x85,
	0xfb, 0x00, 0xde, 0x07, 0xcb, 0x9c, 0x60, 0xd7, 0x76, 0x58, 0x1c, 0x4a, 0x3b, 0x64, 0x3c, 0xc0,
	0x3e, 0x3d, 0x22, 0xae, 0xa9, 0xf9, 0x46, 0x0a, 0x6e, 0xa4, 0x58, 0x6f, 0x0c, 0xc1, 0xdb, 0xa0,
	0xa2, 0x34, 0x82, 0x1e, 0x91, 0x13, 0x15, 0xce, 0xa5, 0xe1, 0x3e, 0x3d, 0x22, 0xba, 0xa8, 0x75,
	0x70, 0xf3, 0x90, 0x53, 0x49, 0xce, 0x9a, 0xeb, 0x22, 0x96, 0x14, 0x7a, 0xda, 0xfd, 0x2e, 0x58,
	0xd0, 0xaa, 0x9c, 0xfd, 0x94, 0xe2, 0xcf, 0xab, 0xf8, 0xd8, 0xbf, 0xf9, 0x97, 0x05, 0xaa, 0xe7,
	0x7d, 0xe4, 0xe0, 0xcf, 0xf9, 0x53, 0x6e, 0x5d, 0x7c, 0x64, 0x4e, 0x1a, 0x5d, 0x70, 0xc6, 0xd1,
	0xf8, 0x8c, 0xeb, 0xef, 0xd6, 0xe7, 0x97, 0x77, 0x3e, 0xef, 0x84, 0x37, 0x31, 0x58, 0xb9, 0x30,
	0x87, 0xb7, 0x3b, 0x85, 0xcd, 0x3f, 0x2d, 0x50, 0x7f, 0x73, 0x36, 0xf0, 0x43, 0xb0, 0x78, 0x76,
	0xcf, 0xe9, 0xbd, 0x50, 0x39, 0x3c, 0xb9, 0xc3, 0xe0, 0xc7, 0x00, 0x26, 0xda, 0xcd, 0x0e, 0x99,
	0x6b, 0xc6, 0xac, 0x3a, 0x32, 0x87, 0x16, 0x0c, 0xd2, 0x63, 0xae, 0x9e, 0x30, 0xec, 0x82, 0x72,
	0x12, 0xd8, 0xa6, 0x6d, 0xfa, 0xfa, 0xfa, 0xe4, 0xaa, 0x6d, 0x43, 0xa5, 0x24, 0xd0, 0x4f, 0xcd,
	0xe7, 0x45, 0xb0, 0xf4, 0x3a, 0x0a, 0xbc, 0x07, 0x16, 0x70, 0x82, 0xa9, 0x8f, 0x07, 0x3e, 0xc9,
	0x96, 0x4b, 0x0b, 0x98, 0x46, 0x95, 0x71, 0xdc, 0x50, 0x1f, 0x80, 0x77, 0x4f, 0x53, 0xed, 0x41,
	0xbc, 0xb7, 0x47, 0xb8, 0xaa, 0x62, 0x1a, 0x2d, 0x9f, 0x52, 0x74, 0x14, 0x08, 0xef, 0xa4, 0x07,
	0x40, 0x10, 0x9e, 0x10, 0x37, 0x5f, 0xd0, 0x14, 0x9a, 0xcf, 0xc2, 0x66, 0x81, 0x3b, 0xa0, 0x82,
	0x85, 0xa0, 0x5e, 0x38, 0x21, 0x9a, 0xad, 0x9c, 0x85, 0x0d, 0xf1, 0x7d, 0x00, 0x84, 0x1f, 0xd9,
	0xd8, 0x91, 0x34, 0x21, 0xea, 0xe2, 0x28, 0xa1, 0xb2, 0xf0, 0xa3, 0xaf, 0x54, 0x00, 0x7e, 0x04,
	0x16, 0x07, 0xd8, 0xc7, 0xa1, 0x93, 0xce, 0x85, 0x84, 0x69, 0x42, 0xae, 0xba, 0x07, 0x4a, 0x68,
	0x61, 0x0c, 0x7c, 0xad, 0xe3, 0xf0, 0x33, 0x50, 0x75, 0x03, 0x9b, 0x45, 0x84, 0x63, 0x49, 0x59,
	0x68, 0xd3, 0xd0, 0x8e, 0x38, 0xf3, 0x38, 0x11, 0xa2, 0x3a, 0xab, 0x34, 0xcb, 0x6e, 0xf0, 0x7d,
	0x06, 0x7f, 0x1b, 0x6e, 0x1a, 0xb0, 0xf3, 0xeb, 0xf1, 0xcb, 0x7a, 0xe1, 0xef, 0x97, 0xf5, 0xc2,
	0xef, 0xa3, 0xba, 0x75, 0x3c, 0xaa, 0x5b, 0xcf, 0x47, 0x75, 0xeb, 0x9f, 0x51, 0xdd, 0xfa, 0xe9,
	0x9b, 0xb7, 0xfd, 0xa3, 0xf7, 0x85, 0xfa, 0xfd, 0xb1, 0x30, 0x98, 0x51, 0x37, 0xfb, 0xa7, 0xaf,
	0x02, 0x00, 0x00, 0xff, 0xff, 0xb6, 0xe8, 0x0f, 0x6d, 0x3b, 0x0a, 0x00, 0x00,
}

func (m *Statistics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Statistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Container != nil {
		nn1, err := m.Container.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn1
	}
	if m.VM != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.VM.Size()))
		n2, err := m.VM.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Statistics_Windows) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Windows != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.Windows.Size()))
		n3, err := m.Windows.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}
func (m *Statistics_Linux) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Linux != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.Linux.Size()))
		n4, err := m.Linux.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}
func (m *WindowsContainerStatistics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WindowsContainerStatistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintStats(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdTime(m.Timestamp)))
	n5, err := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.Timestamp, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	dAtA[i] = 0x12
	i++
	i = encodeVarintStats(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdTime(m.ContainerStartTime)))
	n6, err := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.ContainerStartTime, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	if m.UptimeNS != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.UptimeNS))
	}
	if m.Processor != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.Processor.Size()))
		n7, err := m.Processor.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.Memory != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.Memory.Size()))
		n8, err := m.Memory.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.Storage != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.Storage.Size()))
		n9, err := m.Storage.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *WindowsContainerProcessorStatistics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WindowsContainerProcessorStatistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TotalRuntimeNS != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.TotalRuntimeNS))
	}
	if m.RuntimeUserNS != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.RuntimeUserNS))
	}
	if m.RuntimeKernelNS != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.RuntimeKernelNS))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *WindowsContainerMemoryStatistics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WindowsContainerMemoryStatistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.MemoryUsageCommitBytes != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.MemoryUsageCommitBytes))
	}
	if m.MemoryUsageCommitPeakBytes != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.MemoryUsageCommitPeakBytes))
	}
	if m.MemoryUsagePrivateWorkingSetBytes != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.MemoryUsagePrivateWorkingSetBytes))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *WindowsContainerStorageStatistics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WindowsContainerStorageStatistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ReadCountNormalized != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.ReadCountNormalized))
	}
	if m.ReadSizeBytes != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.ReadSizeBytes))
	}
	if m.WriteCountNormalized != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.WriteCountNormalized))
	}
	if m.WriteSizeBytes != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.WriteSizeBytes))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *VirtualMachineStatistics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VirtualMachineStatistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Processor != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.Processor.Size()))
		n10, err := m.Processor.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.Memory != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.Memory.Size()))
		n11, err := m.Memory.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *VirtualMachineProcessorStatistics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VirtualMachineProcessorStatistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TotalRuntimeNS != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.TotalRuntimeNS))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *VirtualMachineMemoryStatistics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VirtualMachineMemoryStatistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.WorkingSetBytes != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.WorkingSetBytes))
	}
	if m.VirtualNodeCount != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.VirtualNodeCount))
	}
	if m.VmMemory != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.VmMemory.Size()))
		n12, err := m.VmMemory.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *VirtualMachineMemory) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VirtualMachineMemory) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.AvailableMemory != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.AvailableMemory))
	}
	if m.AvailableMemoryBuffer != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.AvailableMemoryBuffer))
	}
	if m.ReservedMemory != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.ReservedMemory))
	}
	if m.AssignedMemory != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.AssignedMemory))
	}
	if m.SlpActive {
		dAtA[i] = 0x28
		i++
		if m.SlpActive {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.BalancingEnabled {
		dAtA[i] = 0x30
		i++
		if m.BalancingEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.DmOperationInProgress {
		dAtA[i] = 0x38
		i++
		if m.DmOperationInProgress {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintStats(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Statistics) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Container != nil {
		n += m.Container.Size()
	}
	if m.VM != nil {
		l = m.VM.Size()
		n += 1 + l + sovStats(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Statistics_Windows) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Windows != nil {
		l = m.Windows.Size()
		n += 1 + l + sovStats(uint64(l))
	}
	return n
}
func (m *Statistics_Linux) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Linux != nil {
		l = m.Linux.Size()
		n += 1 + l + sovStats(uint64(l))
	}
	return n
}
func (m *WindowsContainerStatistics) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.Timestamp)
	n += 1 + l + sovStats(uint64(l))
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.ContainerStartTime)
	n += 1 + l + sovStats(uint64(l))
	if m.UptimeNS != 0 {
		n += 1 + sovStats(uint64(m.UptimeNS))
	}
	if m.Processor != nil {
		l = m.Processor.Size()
		n += 1 + l + sovStats(uint64(l))
	}
	if m.Memory != nil {
		l = m.Memory.Size()
		n += 1 + l + sovStats(uint64(l))
	}
	if m.Storage != nil {
		l = m.Storage.Size()
		n += 1 + l + sovStats(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *WindowsContainerProcessorStatistics) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TotalRuntimeNS != 0 {
		n += 1 + sovStats(uint64(m.TotalRuntimeNS))
	}
	if m.RuntimeUserNS != 0 {
		n += 1 + sovStats(uint64(m.RuntimeUserNS))
	}
	if m.RuntimeKernelNS != 0 {
		n += 1 + sovStats(uint64(m.RuntimeKernelNS))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *WindowsContainerMemoryStatistics) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MemoryUsageCommitBytes != 0 {
		n += 1 + sovStats(uint64(m.MemoryUsageCommitBytes))
	}
	if m.MemoryUsageCommitPeakBytes != 0 {
		n += 1 + sovStats(uint64(m.MemoryUsageCommitPeakBytes))
	}
	if m.MemoryUsagePrivateWorkingSetBytes != 0 {
		n += 1 + sovStats(uint64(m.MemoryUsagePrivateWorkingSetBytes))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *WindowsContainerStorageStatistics) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ReadCountNormalized != 0 {
		n += 1 + sovStats(uint64(m.ReadCountNormalized))
	}
	if m.ReadSizeBytes != 0 {
		n += 1 + sovStats(uint64(m.ReadSizeBytes))
	}
	if m.WriteCountNormalized != 0 {
		n += 1 + sovStats(uint64(m.WriteCountNormalized))
	}
	if m.WriteSizeBytes != 0 {
		n += 1 + sovStats(uint64(m.WriteSizeBytes))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *VirtualMachineStatistics) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Processor != nil {
		l = m.Processor.Size()
		n += 1 + l + sovStats(uint64(l))
	}
	if m.Memory != nil {
		l = m.Memory.Size()
		n += 1 + l + sovStats(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *VirtualMachineProcessorStatistics) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TotalRuntimeNS != 0 {
		n += 1 + sovStats(uint64(m.TotalRuntimeNS))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *VirtualMachineMemoryStatistics) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.WorkingSetBytes != 0 {
		n += 1 + sovStats(uint64(m.WorkingSetBytes))
	}
	if m.VirtualNodeCount != 0 {
		n += 1 + sovStats(uint64(m.VirtualNodeCount))
	}
	if m.VmMemory != nil {
		l = m.VmMemory.Size()
		n += 1 + l + sovStats(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *VirtualMachineMemory) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AvailableMemory != 0 {
		n += 1 + sovStats(uint64(m.AvailableMemory))
	}
	if m.AvailableMemoryBuffer != 0 {
		n += 1 + sovStats(uint64(m.AvailableMemoryBuffer))
	}
	if m.ReservedMemory != 0 {
		n += 1 + sovStats(uint64(m.ReservedMemory))
	}
	if m.AssignedMemory != 0 {
		n += 1 + sovStats(uint64(m.AssignedMemory))
	}
	if m.SlpActive {
		n += 2
	}
	if m.BalancingEnabled {
		n += 2
	}
	if m.DmOperationInProgress {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovStats(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozStats(x uint64) (n int) {
	return sovStats(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Statistics) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Statistics{`,
		`Container:` + fmt.Sprintf("%v", this.Container) + `,`,
		`VM:` + strings.Replace(fmt.Sprintf("%v", this.VM), "VirtualMachineStatistics", "VirtualMachineStatistics", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Statistics_Windows) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Statistics_Windows{`,
		`Windows:` + strings.Replace(fmt.Sprintf("%v", this.Windows), "WindowsContainerStatistics", "WindowsContainerStatistics", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Statistics_Linux) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Statistics_Linux{`,
		`Linux:` + strings.Replace(fmt.Sprintf("%v", this.Linux), "Metrics", "v1.Metrics", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WindowsContainerStatistics) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WindowsContainerStatistics{`,
		`Timestamp:` + strings.Replace(strings.Replace(this.Timestamp.String(), "Timestamp", "types.Timestamp", 1), `&`, ``, 1) + `,`,
		`ContainerStartTime:` + strings.Replace(strings.Replace(this.ContainerStartTime.String(), "Timestamp", "types.Timestamp", 1), `&`, ``, 1) + `,`,
		`UptimeNS:` + fmt.Sprintf("%v", this.UptimeNS) + `,`,
		`Processor:` + strings.Replace(fmt.Sprintf("%v", this.Processor), "WindowsContainerProcessorStatistics", "WindowsContainerProcessorStatistics", 1) + `,`,
		`Memory:` + strings.Replace(fmt.Sprintf("%v", this.Memory), "WindowsContainerMemoryStatistics", "WindowsContainerMemoryStatistics", 1) + `,`,
		`Storage:` + strings.Replace(fmt.Sprintf("%v", this.Storage), "WindowsContainerStorageStatistics", "WindowsContainerStorageStatistics", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WindowsContainerProcessorStatistics) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WindowsContainerProcessorStatistics{`,
		`TotalRuntimeNS:` + fmt.Sprintf("%v", this.TotalRuntimeNS) + `,`,
		`RuntimeUserNS:` + fmt.Sprintf("%v", this.RuntimeUserNS) + `,`,
		`RuntimeKernelNS:` + fmt.Sprintf("%v", this.RuntimeKernelNS) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WindowsContainerMemoryStatistics) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WindowsContainerMemoryStatistics{`,
		`MemoryUsageCommitBytes:` + fmt.Sprintf("%v", this.MemoryUsageCommitBytes) + `,`,
		`MemoryUsageCommitPeakBytes:` + fmt.Sprintf("%v", this.MemoryUsageCommitPeakBytes) + `,`,
		`MemoryUsagePrivateWorkingSetBytes:` + fmt.Sprintf("%v", this.MemoryUsagePrivateWorkingSetBytes) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WindowsContainerStorageStatistics) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WindowsContainerStorageStatistics{`,
		`ReadCountNormalized:` + fmt.Sprintf("%v", this.ReadCountNormalized) + `,`,
		`ReadSizeBytes:` + fmt.Sprintf("%v", this.ReadSizeBytes) + `,`,
		`WriteCountNormalized:` + fmt.Sprintf("%v", this.WriteCountNormalized) + `,`,
		`WriteSizeBytes:` + fmt.Sprintf("%v", this.WriteSizeBytes) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *VirtualMachineStatistics) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&VirtualMachineStatistics{`,
		`Processor:` + strings.Replace(fmt.Sprintf("%v", this.Processor), "VirtualMachineProcessorStatistics", "VirtualMachineProcessorStatistics", 1) + `,`,
		`Memory:` + strings.Replace(fmt.Sprintf("%v", this.Memory), "VirtualMachineMemoryStatistics", "VirtualMachineMemoryStatistics", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *VirtualMachineProcessorStatistics) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&VirtualMachineProcessorStatistics{`,
		`TotalRuntimeNS:` + fmt.Sprintf("%v", this.TotalRuntimeNS) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *VirtualMachineMemoryStatistics) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&VirtualMachineMemoryStatistics{`,
		`WorkingSetBytes:` + fmt.Sprintf("%v", this.WorkingSetBytes) + `,`,
		`VirtualNodeCount:` + fmt.Sprintf("%v", this.VirtualNodeCount) + `,`,
		`VmMemory:` + strings.Replace(fmt.Sprintf("%v", this.VmMemory), "VirtualMachineMemory", "VirtualMachineMemory", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *VirtualMachineMemory) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&VirtualMachineMemory{`,
		`AvailableMemory:` + fmt.Sprintf("%v", this.AvailableMemory) + `,`,
		`AvailableMemoryBuffer:` + fmt.Sprintf("%v", this.AvailableMemoryBuffer) + `,`,
		`ReservedMemory:` + fmt.Sprintf("%v", this.ReservedMemory) + `,`,
		`AssignedMemory:` + fmt.Sprintf("%v", this.AssignedMemory) + `,`,
		`SlpActive:` + fmt.Sprintf("%v", this.SlpActive) + `,`,
		`BalancingEnabled:` + fmt.Sprintf("%v", this.BalancingEnabled) + `,`,
		`DmOperationInProgress:` + fmt.Sprintf("%v", this.DmOperationInProgress) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringStats(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Statistics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Statistics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Statistics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Windows", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &WindowsContainerStatistics{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Container = &Statistics_Windows{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Linux", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &v1.Metrics{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Container = &Statistics_Linux{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VM", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VM == nil {
				m.VM = &VirtualMachineStatistics{}
			}
			if err := m.VM.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WindowsContainerStatistics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WindowsContainerStatistics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WindowsContainerStatistics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.Timestamp, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerStartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.ContainerStartTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UptimeNS", wireType)
			}
			m.UptimeNS = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.UptimeNS |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Processor", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Processor == nil {
				m.Processor = &WindowsContainerProcessorStatistics{}
			}
			if err := m.Processor.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Memory", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Memory == nil {
				m.Memory = &WindowsContainerMemoryStatistics{}
			}
			if err := m.Memory.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Storage", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Storage == nil {
				m.Storage = &WindowsContainerStorageStatistics{}
			}
			if err := m.Storage.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WindowsContainerProcessorStatistics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WindowsContainerProcessorStatistics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WindowsContainerProcessorStatistics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalRuntimeNS", wireType)
			}
			m.TotalRuntimeNS = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalRuntimeNS |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeUserNS", wireType)
			}
			m.RuntimeUserNS = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RuntimeUserNS |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeKernelNS", wireType)
			}
			m.RuntimeKernelNS = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RuntimeKernelNS |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WindowsContainerMemoryStatistics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WindowsContainerMemoryStatistics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WindowsContainerMemoryStatistics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemoryUsageCommitBytes", wireType)
			}
			m.MemoryUsageCommitBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MemoryUsageCommitBytes |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemoryUsageCommitPeakBytes", wireType)
			}
			m.MemoryUsageCommitPeakBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MemoryUsageCommitPeakBytes |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemoryUsagePrivateWorkingSetBytes", wireType)
			}
			m.MemoryUsagePrivateWorkingSetBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MemoryUsagePrivateWorkingSetBytes |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WindowsContainerStorageStatistics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WindowsContainerStorageStatistics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WindowsContainerStorageStatistics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadCountNormalized", wireType)
			}
			m.ReadCountNormalized = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReadCountNormalized |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadSizeBytes", wireType)
			}
			m.ReadSizeBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReadSizeBytes |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteCountNormalized", wireType)
			}
			m.WriteCountNormalized = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WriteCountNormalized |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteSizeBytes", wireType)
			}
			m.WriteSizeBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WriteSizeBytes |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VirtualMachineStatistics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VirtualMachineStatistics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VirtualMachineStatistics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Processor", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Processor == nil {
				m.Processor = &VirtualMachineProcessorStatistics{}
			}
			if err := m.Processor.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Memory", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Memory == nil {
				m.Memory = &VirtualMachineMemoryStatistics{}
			}
			if err := m.Memory.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VirtualMachineProcessorStatistics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VirtualMachineProcessorStatistics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VirtualMachineProcessorStatistics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalRuntimeNS", wireType)
			}
			m.TotalRuntimeNS = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalRuntimeNS |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VirtualMachineMemoryStatistics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VirtualMachineMemoryStatistics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VirtualMachineMemoryStatistics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkingSetBytes", wireType)
			}
			m.WorkingSetBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WorkingSetBytes |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field VirtualNodeCount", wireType)
			}
			m.VirtualNodeCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.VirtualNodeCount |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VmMemory", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VmMemory == nil {
				m.VmMemory = &VirtualMachineMemory{}
			}
			if err := m.VmMemory.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VirtualMachineMemory) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VirtualMachineMemory: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VirtualMachineMemory: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AvailableMemory", wireType)
			}
			m.AvailableMemory = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AvailableMemory |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AvailableMemoryBuffer", wireType)
			}
			m.AvailableMemoryBuffer = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AvailableMemoryBuffer |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReservedMemory", wireType)
			}
			m.ReservedMemory = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReservedMemory |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AssignedMemory", wireType)
			}
			m.AssignedMemory = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AssignedMemory |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SlpActive", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SlpActive = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BalancingEnabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.BalancingEnabled = bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DmOperationInProgress", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DmOperationInProgress = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipStats(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowStats
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowStats
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowStats
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthStats
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthStats
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowStats
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipStats(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthStats
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthStats = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowStats   = fmt.Errorf("proto: integer overflow")
)
