// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Diagnostics;
#if USE_MDT_EVENTSOURCE
using Microsoft.Diagnostics.Tracing;
#else
using System.Diagnostics.Tracing;
#endif
using System.Text;
using Address = System.UInt64;

#pragma warning disable 1591        // disable warnings on XML comments not being present

// This code was automatically generated by the TraceParserGen tool, which converts
// an ETW event manifest into strongly typed C# classes.
//namespace Microsoft.Diagnostics.Tracing.Parsers
//{
//    using Microsoft.Diagnostics.Tracing.Parsers.EventSourceTest;

//    [System.CodeDom.Compiler.GeneratedCode("traceparsergen", "2.0")]
//    public sealed class EventSourceTestTraceEventParser : TraceEventParser
//    {
//        public static string ProviderName = "EventSourceTest";
//        public static Guid ProviderGuid = new Guid(unchecked((int)0x69e2aa3e), unchecked((short)0x083b), unchecked((short)0x5014), 0xca, 0xd4, 0x3e, 0x51, 0x1a, 0x0b, 0x94, 0xcf);
//        public enum Keywords : long
//        {
//            Hasnoargs = 0x1,
//            Hasintargs = 0x2,
//            Haslongargs = 0x4,
//            Hasstringargs = 0x8,
//            Hasdatetimeargs = 0x10,
//            Hasenumargs = 0x20,
//            Transfer = 0x40,
//            Session3 = 0x100000000000,
//            Session2 = 0x200000000000,
//            Session1 = 0x400000000000,
//            Session0 = 0x800000000000,
//        };

//        public EventSourceTestTraceEventParser(TraceEventSource source) : base(source) { }

//        public event Action<EmptyTraceData> Event0
//        {
//            add
//            {
//                source.RegisterEventTemplate(Event0Template(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 1, ProviderGuid);
//            }
//        }
//        public event Action<EventEnumArgs> EventEnum
//        {
//            add
//            {
//                source.RegisterEventTemplate(EventEnumTemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 19, ProviderGuid);
//            }
//        }
//        public event Action<EventEnum1Args> EventEnum1
//        {
//            add
//            {
//                source.RegisterEventTemplate(EventEnum1Template(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 20, ProviderGuid);
//            }
//        }
//        public event Action<EventFlagsArgs> EventFlags
//        {
//            add
//            {
//                source.RegisterEventTemplate(EventFlagsTemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 21, ProviderGuid);
//            }
//        }
//        public event Action<EventFlags1Args> EventFlags1
//        {
//            add
//            {
//                source.RegisterEventTemplate(EventFlags1Template(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 22, ProviderGuid);
//            }
//        }
//        public event Action<EventIArgs> EventI
//        {
//            add
//            {
//                source.RegisterEventTemplate(EventITemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 2, ProviderGuid);
//            }
//        }
//        public event Action<EventIIArgs> EventII
//        {
//            add
//            {
//                source.RegisterEventTemplate(EventIITemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 3, ProviderGuid);
//            }
//        }
//        public event Action<EventIIIArgs> EventIII
//        {
//            add
//            {
//                source.RegisterEventTemplate(EventIIITemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 4, ProviderGuid);
//            }
//        }
//        public event Action<EventLArgs> EventL
//        {
//            add
//            {
//                source.RegisterEventTemplate(EventLTemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 5, ProviderGuid);
//            }
//        }
//        public event Action<EventLLArgs> EventLL
//        {
//            add
//            {
//                source.RegisterEventTemplate(EventLLTemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 6, ProviderGuid);
//            }
//        }
//        public event Action<EventLLLArgs> EventLLL
//        {
//            add
//            {
//                source.RegisterEventTemplate(EventLLLTemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 7, ProviderGuid);
//            }
//        }
//        public event Action<EventNoAttributesArgs> EventNoAttributes
//        {
//            add
//            {
//                source.RegisterEventTemplate(EventNoAttributesTemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 16, ProviderGuid);
//            }
//        }
//        public event Action<EventSArgs> EventS
//        {
//            add
//            {
//                source.RegisterEventTemplate(EventSTemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 8, ProviderGuid);
//            }
//        }
//        public event Action<EventSIArgs> EventSI
//        {
//            add
//            {
//                source.RegisterEventTemplate(EventSITemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 11, ProviderGuid);
//            }
//        }
//        public event Action<EventSIIArgs> EventSII
//        {
//            add
//            {
//                source.RegisterEventTemplate(EventSIITemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 13, ProviderGuid);
//            }
//        }
//        public event Action<EventSLArgs> EventSL
//        {
//            add
//            {
//                source.RegisterEventTemplate(EventSLTemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 12, ProviderGuid);
//            }
//        }
//        public event Action<EventSSArgs> EventSS
//        {
//            add
//            {
//                source.RegisterEventTemplate(EventSSTemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 9, ProviderGuid);
//            }
//        }
//        public event Action<EventSSSArgs> EventSSS
//        {
//            add
//            {
//                source.RegisterEventTemplate(EventSSSTemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 10, ProviderGuid);
//            }
//        }
//        public event Action<EventWith7StringsArgs> EventWith7Strings
//        {
//            add
//            {
//                source.RegisterEventTemplate(EventWith7StringsTemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 26, ProviderGuid);
//            }
//        }
//        public event Action<EventWith9StringsArgs> EventWith9Strings
//        {
//            add
//            {
//                source.RegisterEventTemplate(EventWith9StringsTemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 27, ProviderGuid);
//            }
//        }
//        public event Action<EventWithByteArrArgArgs> EventWithByteArrArg
//        {
//            add
//            {
//                source.RegisterEventTemplate(EventWithByteArrArgTemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 34, ProviderGuid);
//            }
//        }
//        public event Action<EventWithBytePtrArgArgs> EventWithBytePtrArg
//        {
//            add
//            {
//                source.RegisterEventTemplate(EventWithBytePtrArgTemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 35, ProviderGuid);
//            }
//        }
//        public event Action<EventWithEscapingMessageArgs> EventWithEscapingMessage
//        {
//            add
//            {
//                source.RegisterEventTemplate(EventWithEscapingMessageTemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 32, ProviderGuid);
//            }
//        }
//        public event Action<EventWithManyTypeArgsArgs> EventWithManyTypeArgs
//        {
//            add
//            {
//                source.RegisterEventTemplate(EventWithManyTypeArgsTemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 25, ProviderGuid);
//            }
//        }
//        public event Action<EventWithMoreEscapingMessageArgs> EventWithMoreEscapingMessage
//        {
//            add
//            {
//                source.RegisterEventTemplate(EventWithMoreEscapingMessageTemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 33, ProviderGuid);
//            }
//        }
//        public event Action<EventWithWeirdArgsArgs> EventWithWeirdArgs
//        {
//            add
//            {
//                source.RegisterEventTemplate(EventWithWeirdArgsTemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 30, ProviderGuid);
//            }
//        }
//        public event Action<MessageArgs> Message
//        {
//            add
//            {
//                source.RegisterEventTemplate(MessageTemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 14, ProviderGuid);
//            }
//        }
//        public event Action<SlowerHelperArgs> SlowerHelper
//        {
//            add
//            {
//                source.RegisterEventTemplate(SlowerHelperTemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 18, ProviderGuid);
//            }
//        }
//        public event Action<EventDateTimeArgs> WorkDateTimeOpcode1
//        {
//            add
//            {
//                source.RegisterEventTemplate(WorkDateTimeOpcode1Template(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 24, ProviderGuid);
//            }
//        }
//        public event Action<EmptyTraceData> WorkItem
//        {
//            add
//            {
//                source.RegisterEventTemplate(WorkItemTemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 15, ProviderGuid);
//            }
//        }
//        public event Action<LogTaskScheduledBadArgs> WorkItemBadSend
//        {
//            add
//            {
//                source.RegisterEventTemplate(WorkItemBadSendTemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 23, ProviderGuid);
//            }
//        }
//        public event Action<LogTaskScheduledArgs> WorkItemSend
//        {
//            add
//            {
//                source.RegisterEventTemplate(WorkItemSendTemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 17, ProviderGuid);
//            }
//        }
//        public event Action<EventWithXferManyTypeArgsArgs> WorkManyArgsSend
//        {
//            add
//            {
//                source.RegisterEventTemplate(WorkManyArgsSendTemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 29, ProviderGuid);
//            }
//        }
//        public event Action<EventWithXferWeirdArgsArgs> WorkWeirdArgsSend
//        {
//            add
//            {
//                source.RegisterEventTemplate(WorkWeirdArgsSendTemplate(value));
//            }
//            remove
//            {
//                source.UnregisterEventTemplate(value, 31, ProviderGuid);
//            }
//        }

//        #region private
//        protected override string GetProviderName() { return ProviderName; }

//        private static EmptyTraceData Event0Template(Action<EmptyTraceData> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EmptyTraceData(action, 1, 65533, "Event0", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static EventEnumArgs EventEnumTemplate(Action<EventEnumArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventEnumArgs(action, 19, 65515, "EventEnum", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static EventEnum1Args EventEnum1Template(Action<EventEnum1Args> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventEnum1Args(action, 20, 65514, "EventEnum1", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static EventFlagsArgs EventFlagsTemplate(Action<EventFlagsArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventFlagsArgs(action, 21, 65513, "EventFlags", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static EventFlags1Args EventFlags1Template(Action<EventFlags1Args> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventFlags1Args(action, 22, 65512, "EventFlags1", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static EventIArgs EventITemplate(Action<EventIArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventIArgs(action, 2, 65532, "EventI", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static EventIIArgs EventIITemplate(Action<EventIIArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventIIArgs(action, 3, 65531, "EventII", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static EventIIIArgs EventIIITemplate(Action<EventIIIArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventIIIArgs(action, 4, 65530, "EventIII", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static EventLArgs EventLTemplate(Action<EventLArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventLArgs(action, 5, 65529, "EventL", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static EventLLArgs EventLLTemplate(Action<EventLLArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventLLArgs(action, 6, 65528, "EventLL", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static EventLLLArgs EventLLLTemplate(Action<EventLLLArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventLLLArgs(action, 7, 65527, "EventLLL", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static EventNoAttributesArgs EventNoAttributesTemplate(Action<EventNoAttributesArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventNoAttributesArgs(action, 16, 65518, "EventNoAttributes", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static EventSArgs EventSTemplate(Action<EventSArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventSArgs(action, 8, 65526, "EventS", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static EventSIArgs EventSITemplate(Action<EventSIArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventSIArgs(action, 11, 65523, "EventSI", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static EventSIIArgs EventSIITemplate(Action<EventSIIArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventSIIArgs(action, 13, 65521, "EventSII", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static EventSLArgs EventSLTemplate(Action<EventSLArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventSLArgs(action, 12, 65522, "EventSL", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static EventSSArgs EventSSTemplate(Action<EventSSArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventSSArgs(action, 9, 65525, "EventSS", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static EventSSSArgs EventSSSTemplate(Action<EventSSSArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventSSSArgs(action, 10, 65524, "EventSSS", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static EventWith7StringsArgs EventWith7StringsTemplate(Action<EventWith7StringsArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventWith7StringsArgs(action, 26, 65508, "EventWith7Strings", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static EventWith9StringsArgs EventWith9StringsTemplate(Action<EventWith9StringsArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventWith9StringsArgs(action, 27, 65507, "EventWith9Strings", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static EventWithByteArrArgArgs EventWithByteArrArgTemplate(Action<EventWithByteArrArgArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventWithByteArrArgArgs(action, 34, 65500, "EventWithByteArrArg", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static EventWithBytePtrArgArgs EventWithBytePtrArgTemplate(Action<EventWithBytePtrArgArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventWithBytePtrArgArgs(action, 35, 65499, "EventWithBytePtrArg", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static EventWithEscapingMessageArgs EventWithEscapingMessageTemplate(Action<EventWithEscapingMessageArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventWithEscapingMessageArgs(action, 32, 65502, "EventWithEscapingMessage", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static EventWithManyTypeArgsArgs EventWithManyTypeArgsTemplate(Action<EventWithManyTypeArgsArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventWithManyTypeArgsArgs(action, 25, 65509, "EventWithManyTypeArgs", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static EventWithMoreEscapingMessageArgs EventWithMoreEscapingMessageTemplate(Action<EventWithMoreEscapingMessageArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventWithMoreEscapingMessageArgs(action, 33, 65501, "EventWithMoreEscapingMessage", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static EventWithWeirdArgsArgs EventWithWeirdArgsTemplate(Action<EventWithWeirdArgsArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventWithWeirdArgsArgs(action, 30, 65504, "EventWithWeirdArgs", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static MessageArgs MessageTemplate(Action<MessageArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new MessageArgs(action, 14, 65520, "Message", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static SlowerHelperArgs SlowerHelperTemplate(Action<SlowerHelperArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new SlowerHelperArgs(action, 18, 65516, "SlowerHelper", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static EventDateTimeArgs WorkDateTimeOpcode1Template(Action<EventDateTimeArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventDateTimeArgs(action, 24, 5, "WorkDateTime", Guid.Empty, 11, "Opcode1", ProviderGuid, ProviderName);
//        }
//        private static EmptyTraceData WorkItemTemplate(Action<EmptyTraceData> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EmptyTraceData(action, 15, 1, "WorkItem", Guid.Empty, 0, "", ProviderGuid, ProviderName);
//        }
//        private static LogTaskScheduledBadArgs WorkItemBadSendTemplate(Action<LogTaskScheduledBadArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new LogTaskScheduledBadArgs(action, 23, 2, "WorkItemBad", Guid.Empty, 9, "Send", ProviderGuid, ProviderName);
//        }
//        private static LogTaskScheduledArgs WorkItemSendTemplate(Action<LogTaskScheduledArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new LogTaskScheduledArgs(action, 17, 1, "WorkItem", Guid.Empty, 9, "Send", ProviderGuid, ProviderName);
//        }
//        private static EventWithXferManyTypeArgsArgs WorkManyArgsSendTemplate(Action<EventWithXferManyTypeArgsArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventWithXferManyTypeArgsArgs(action, 29, 3, "WorkManyArgs", Guid.Empty, 9, "Send", ProviderGuid, ProviderName);
//        }
//        private static EventWithXferWeirdArgsArgs WorkWeirdArgsSendTemplate(Action<EventWithXferWeirdArgsArgs> action)
//        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
//            return new EventWithXferWeirdArgsArgs(action, 31, 4, "WorkWeirdArgs", Guid.Empty, 9, "Send", ProviderGuid, ProviderName);
//        }

//        private static volatile TraceEvent[] s_templates;
//        protected override void EnumerateTemplates(Func<string, string, EventFilterResponse> eventsToObserve, Action<TraceEvent> callback)
//        {
//            if (s_templates == null)
//            {
//                var templates = new TraceEvent[34];
//                templates[0] = Event0Template(null);
//                templates[1] = EventITemplate(null);
//                templates[2] = EventIITemplate(null);
//                templates[3] = EventIIITemplate(null);
//                templates[4] = EventLTemplate(null);
//                templates[5] = EventLLTemplate(null);
//                templates[6] = EventLLLTemplate(null);
//                templates[7] = EventSTemplate(null);
//                templates[8] = EventSSTemplate(null);
//                templates[9] = EventSSSTemplate(null);
//                templates[10] = EventSITemplate(null);
//                templates[11] = EventSLTemplate(null);
//                templates[12] = EventSIITemplate(null);
//                templates[13] = MessageTemplate(null);
//                templates[14] = WorkItemTemplate(null);
//                templates[15] = EventNoAttributesTemplate(null);
//                templates[16] = WorkItemSendTemplate(null);
//                templates[17] = SlowerHelperTemplate(null);
//                templates[18] = EventEnumTemplate(null);
//                templates[19] = EventEnum1Template(null);
//                templates[20] = EventFlagsTemplate(null);
//                templates[21] = EventFlags1Template(null);
//                templates[22] = WorkItemBadSendTemplate(null);
//                templates[23] = WorkDateTimeOpcode1Template(null);
//                templates[24] = EventWithManyTypeArgsTemplate(null);
//                templates[25] = EventWith7StringsTemplate(null);
//                templates[26] = EventWith9StringsTemplate(null);
//                templates[27] = WorkManyArgsSendTemplate(null);
//                templates[28] = EventWithWeirdArgsTemplate(null);
//                templates[29] = WorkWeirdArgsSendTemplate(null);
//                templates[30] = EventWithEscapingMessageTemplate(null);
//                templates[31] = EventWithMoreEscapingMessageTemplate(null);
//                templates[32] = EventWithByteArrArgTemplate(null);
//                templates[33] = EventWithBytePtrArgTemplate(null);
//                s_templates = templates;
//            }
//            foreach (var template in s_templates)
//                if (eventsToObserve == null || eventsToObserve(template.ProviderName, template.EventName) == EventFilterResponse.AcceptEvent)
//                    callback(template);
//        }

//        #endregion
//    }
//}

//namespace Microsoft.Diagnostics.Tracing.Parsers.EventSourceTest
//{
//    public sealed class EventEnumArgs : TraceEvent
//    {
//        public MyColor x { get { return (MyColor)GetInt32At(0); } }

//        #region Private
//        internal EventEnumArgs(Action<EventEnumArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != 4));
//            Debug.Assert(!(Version > 0 && EventDataLength < 4));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventEnumArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "x", x);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "x" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return x;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventEnumArgs> m_target;
//        #endregion
//    }
//    public sealed class EventEnum1Args : TraceEvent
//    {
//        public MyColor x { get { return (MyColor)GetInt32At(0); } }

//        #region Private
//        internal EventEnum1Args(Action<EventEnum1Args> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != 4));
//            Debug.Assert(!(Version > 0 && EventDataLength < 4));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventEnum1Args>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "x", x);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "x" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return x;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventEnum1Args> m_target;
//        #endregion
//    }
//    public sealed class EventFlagsArgs : TraceEvent
//    {
//        public MyFlags x { get { return (MyFlags)GetInt32At(0); } }

//        #region Private
//        internal EventFlagsArgs(Action<EventFlagsArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != 4));
//            Debug.Assert(!(Version > 0 && EventDataLength < 4));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventFlagsArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "x", x);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "x" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return x;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventFlagsArgs> m_target;
//        #endregion
//    }
//    public sealed class EventFlags1Args : TraceEvent
//    {
//        public MyFlags x { get { return (MyFlags)GetInt32At(0); } }

//        #region Private
//        internal EventFlags1Args(Action<EventFlags1Args> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != 4));
//            Debug.Assert(!(Version > 0 && EventDataLength < 4));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventFlags1Args>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "x", x);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "x" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return x;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventFlags1Args> m_target;
//        #endregion
//    }
//    public sealed class EventIArgs : TraceEvent
//    {
//        public int arg1 { get { return GetInt32At(0); } }

//        #region Private
//        internal EventIArgs(Action<EventIArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != 4));
//            Debug.Assert(!(Version > 0 && EventDataLength < 4));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventIArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "arg1", arg1);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "arg1" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return arg1;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventIArgs> m_target;
//        #endregion
//    }
//    public sealed class EventIIArgs : TraceEvent
//    {
//        public int arg1 { get { return GetInt32At(0); } }
//        public int arg2 { get { return GetInt32At(4); } }

//        #region Private
//        internal EventIIArgs(Action<EventIIArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != 8));
//            Debug.Assert(!(Version > 0 && EventDataLength < 8));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventIIArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "arg1", arg1);
//            XmlAttrib(sb, "arg2", arg2);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "arg1", "arg2" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return arg1;
//                case 1:
//                    return arg2;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventIIArgs> m_target;
//        #endregion
//    }
//    public sealed class EventIIIArgs : TraceEvent
//    {
//        public int arg1 { get { return GetInt32At(0); } }
//        public int arg2 { get { return GetInt32At(4); } }
//        public int arg3 { get { return GetInt32At(8); } }

//        #region Private
//        internal EventIIIArgs(Action<EventIIIArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != 12));
//            Debug.Assert(!(Version > 0 && EventDataLength < 12));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventIIIArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "arg1", arg1);
//            XmlAttrib(sb, "arg2", arg2);
//            XmlAttrib(sb, "arg3", arg3);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "arg1", "arg2", "arg3" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return arg1;
//                case 1:
//                    return arg2;
//                case 2:
//                    return arg3;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventIIIArgs> m_target;
//        #endregion
//    }
//    public sealed class EventLArgs : TraceEvent
//    {
//        public long arg1 { get { return GetInt64At(0); } }

//        #region Private
//        internal EventLArgs(Action<EventLArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != 8));
//            Debug.Assert(!(Version > 0 && EventDataLength < 8));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventLArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "arg1", arg1);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "arg1" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return arg1;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventLArgs> m_target;
//        #endregion
//    }
//    public sealed class EventLLArgs : TraceEvent
//    {
//        public long arg1 { get { return GetInt64At(0); } }
//        public long arg2 { get { return GetInt64At(8); } }

//        #region Private
//        internal EventLLArgs(Action<EventLLArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != 16));
//            Debug.Assert(!(Version > 0 && EventDataLength < 16));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventLLArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "arg1", arg1);
//            XmlAttrib(sb, "arg2", arg2);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "arg1", "arg2" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return arg1;
//                case 1:
//                    return arg2;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventLLArgs> m_target;
//        #endregion
//    }
//    public sealed class EventLLLArgs : TraceEvent
//    {
//        public long arg1 { get { return GetInt64At(0); } }
//        public long arg2 { get { return GetInt64At(8); } }
//        public long arg3 { get { return GetInt64At(16); } }

//        #region Private
//        internal EventLLLArgs(Action<EventLLLArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != 24));
//            Debug.Assert(!(Version > 0 && EventDataLength < 24));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventLLLArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "arg1", arg1);
//            XmlAttrib(sb, "arg2", arg2);
//            XmlAttrib(sb, "arg3", arg3);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "arg1", "arg2", "arg3" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return arg1;
//                case 1:
//                    return arg2;
//                case 2:
//                    return arg3;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventLLLArgs> m_target;
//        #endregion
//    }
//    public sealed class EventNoAttributesArgs : TraceEvent
//    {
//        public string s { get { return GetUnicodeStringAt(0); } }

//        #region Private
//        internal EventNoAttributesArgs(Action<EventNoAttributesArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
//            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventNoAttributesArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "s", s);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "s" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return s;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventNoAttributesArgs> m_target;
//        #endregion
//    }
//    public sealed class EventSArgs : TraceEvent
//    {
//        public string arg1 { get { return GetUnicodeStringAt(0); } }

//        #region Private
//        internal EventSArgs(Action<EventSArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
//            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventSArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "arg1", arg1);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "arg1" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return arg1;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventSArgs> m_target;
//        #endregion
//    }
//    public sealed class EventSIArgs : TraceEvent
//    {
//        public string arg1 { get { return GetUnicodeStringAt(0); } }
//        public int arg2 { get { return GetInt32At(SkipUnicodeString(0)); } }

//        #region Private
//        internal EventSIArgs(Action<EventSIArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0) + 4));
//            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0) + 4));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventSIArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "arg1", arg1);
//            XmlAttrib(sb, "arg2", arg2);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "arg1", "arg2" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return arg1;
//                case 1:
//                    return arg2;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventSIArgs> m_target;
//        #endregion
//    }
//    public sealed class EventSIIArgs : TraceEvent
//    {
//        public string arg1 { get { return GetUnicodeStringAt(0); } }
//        public int arg2 { get { return GetInt32At(SkipUnicodeString(0)); } }
//        public int arg3 { get { return GetInt32At(SkipUnicodeString(0) + 4); } }

//        #region Private
//        internal EventSIIArgs(Action<EventSIIArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0) + 8));
//            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0) + 8));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventSIIArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "arg1", arg1);
//            XmlAttrib(sb, "arg2", arg2);
//            XmlAttrib(sb, "arg3", arg3);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "arg1", "arg2", "arg3" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return arg1;
//                case 1:
//                    return arg2;
//                case 2:
//                    return arg3;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventSIIArgs> m_target;
//        #endregion
//    }
//    public sealed class EventSLArgs : TraceEvent
//    {
//        public string arg1 { get { return GetUnicodeStringAt(0); } }
//        public long arg2 { get { return GetInt64At(SkipUnicodeString(0)); } }

//        #region Private
//        internal EventSLArgs(Action<EventSLArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0) + 8));
//            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0) + 8));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventSLArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "arg1", arg1);
//            XmlAttrib(sb, "arg2", arg2);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "arg1", "arg2" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return arg1;
//                case 1:
//                    return arg2;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventSLArgs> m_target;
//        #endregion
//    }
//    public sealed class EventSSArgs : TraceEvent
//    {
//        public string arg1 { get { return GetUnicodeStringAt(0); } }
//        public string arg2 { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }

//        #region Private
//        internal EventSSArgs(Action<EventSSArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(0))));
//            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(0))));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventSSArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "arg1", arg1);
//            XmlAttrib(sb, "arg2", arg2);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "arg1", "arg2" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return arg1;
//                case 1:
//                    return arg2;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventSSArgs> m_target;
//        #endregion
//    }
//    public sealed class EventSSSArgs : TraceEvent
//    {
//        public string arg1 { get { return GetUnicodeStringAt(0); } }
//        public string arg2 { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
//        public string arg3 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }

//        #region Private
//        internal EventSSSArgs(Action<EventSSSArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
//            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventSSSArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "arg1", arg1);
//            XmlAttrib(sb, "arg2", arg2);
//            XmlAttrib(sb, "arg3", arg3);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "arg1", "arg2", "arg3" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return arg1;
//                case 1:
//                    return arg2;
//                case 2:
//                    return arg3;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventSSSArgs> m_target;
//        #endregion
//    }
//    public sealed class EventWith7StringsArgs : TraceEvent
//    {
//        public string s0 { get { return GetUnicodeStringAt(0); } }
//        public string s1 { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
//        public string s2 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
//        public string s3 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }
//        public string s4 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))); } }
//        public string s5 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))))); } }
//        public string s6 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))))); } }

//        #region Private
//        internal EventWith7StringsArgs(Action<EventWith7StringsArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))))))));
//            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))))))));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventWith7StringsArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "s0", s0);
//            XmlAttrib(sb, "s1", s1);
//            XmlAttrib(sb, "s2", s2);
//            XmlAttrib(sb, "s3", s3);
//            XmlAttrib(sb, "s4", s4);
//            XmlAttrib(sb, "s5", s5);
//            XmlAttrib(sb, "s6", s6);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "s0", "s1", "s2", "s3", "s4", "s5", "s6" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return s0;
//                case 1:
//                    return s1;
//                case 2:
//                    return s2;
//                case 3:
//                    return s3;
//                case 4:
//                    return s4;
//                case 5:
//                    return s5;
//                case 6:
//                    return s6;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventWith7StringsArgs> m_target;
//        #endregion
//    }
//    public sealed class EventWith9StringsArgs : TraceEvent
//    {
//        public string s0 { get { return GetUnicodeStringAt(0); } }
//        public string s1 { get { return GetUnicodeStringAt(SkipUnicodeString(0)); } }
//        public string s2 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(0))); } }
//        public string s3 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))); } }
//        public string s4 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))); } }
//        public string s5 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))))); } }
//        public string s6 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))))); } }
//        public string s7 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))))))); } }
//        public string s8 { get { return GetUnicodeStringAt(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0))))))))); } }

//        #region Private
//        internal EventWith9StringsArgs(Action<EventWith9StringsArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))))))))));
//            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(SkipUnicodeString(0)))))))))));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventWith9StringsArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "s0", s0);
//            XmlAttrib(sb, "s1", s1);
//            XmlAttrib(sb, "s2", s2);
//            XmlAttrib(sb, "s3", s3);
//            XmlAttrib(sb, "s4", s4);
//            XmlAttrib(sb, "s5", s5);
//            XmlAttrib(sb, "s6", s6);
//            XmlAttrib(sb, "s7", s7);
//            XmlAttrib(sb, "s8", s8);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "s0", "s1", "s2", "s3", "s4", "s5", "s6", "s7", "s8" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return s0;
//                case 1:
//                    return s1;
//                case 2:
//                    return s2;
//                case 3:
//                    return s3;
//                case 4:
//                    return s4;
//                case 5:
//                    return s5;
//                case 6:
//                    return s6;
//                case 7:
//                    return s7;
//                case 8:
//                    return s8;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventWith9StringsArgs> m_target;
//        #endregion
//    }
//    public sealed class EventWithByteArrArgArgs : TraceEvent
//    {
//        public int blobSize { get { return GetInt32At(0); } }
//        public byte[] blob { get { return GetByteArrayAt(4, blobSize); } }
//        public int blobAt(int arrayIndex) { return GetByteAt(4 + (arrayIndex * HostOffset(1, 0))); }
//        public int n { get { return GetInt32At(0 + (blobSize) + 4); } }

//        #region Private
//        internal EventWithByteArrArgArgs(Action<EventWithByteArrArgArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != 0 + (blobSize * 1) + 8));
//            Debug.Assert(!(Version > 0 && EventDataLength < 0 + (blobSize * 1) + 8));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventWithByteArrArgArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "blobSize", blobSize);
//            XmlAttrib(sb, "n", n);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "blobSize", "blob", "n" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return blobSize;
//                case 1:
//                    return n;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventWithByteArrArgArgs> m_target;
//        #endregion
//    }
//    public sealed class EventWithBytePtrArgArgs : TraceEvent
//    {
//        public int blobSize { get { return GetInt32At(0); } }
//        public byte[] blob { get { return GetByteArrayAt(4, blobSize); } }
//        public int blobAt(int arrayIndex) { return GetByteAt(4 + (arrayIndex * HostOffset(1, 0))); }
//        public int n { get { return GetInt32At(0 + (blobSize) + 4); } }

//        #region Private
//        internal EventWithBytePtrArgArgs(Action<EventWithBytePtrArgArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != 0 + (blobSize * 1) + 8));
//            Debug.Assert(!(Version > 0 && EventDataLength < 0 + (blobSize * 1) + 8));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventWithBytePtrArgArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "blobSize", blobSize);
//            XmlAttrib(sb, "n", n);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "blobSize", "blob", "n" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return blobSize;
//                case 1:
//                    return n;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventWithBytePtrArgArgs> m_target;
//        #endregion
//    }
//    public sealed class EventWithEscapingMessageArgs : TraceEvent
//    {
//        public string msg { get { return GetUnicodeStringAt(0); } }
//        public int n { get { return GetInt32At(SkipUnicodeString(0)); } }

//        #region Private
//        internal EventWithEscapingMessageArgs(Action<EventWithEscapingMessageArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0) + 4));
//            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0) + 4));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventWithEscapingMessageArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "msg", msg);
//            XmlAttrib(sb, "n", n);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "msg", "n" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return msg;
//                case 1:
//                    return n;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventWithEscapingMessageArgs> m_target;
//        #endregion
//    }
//    public sealed class EventWithManyTypeArgsArgs : TraceEvent
//    {
//        public string msg { get { return GetUnicodeStringAt(0); } }
//        public long l { get { return GetInt64At(SkipUnicodeString(0)); } }
//        public int ui { get { return GetInt32At(SkipUnicodeString(0) + 8); } }
//        public long ui64 { get { return GetInt64At(SkipUnicodeString(0) + 12); } }
//        public int ch { get { return GetInt16At(SkipUnicodeString(0) + 20); } }
//        public int b { get { return GetByteAt(SkipUnicodeString(0) + 22); } }
//        public int sb { get { return GetByteAt(SkipUnicodeString(0) + 23); } }
//        public int sh { get { return GetInt16At(SkipUnicodeString(0) + 24); } }
//        public int ush { get { return GetInt16At(SkipUnicodeString(0) + 26); } }
//        public float f { get { return GetSingleAt(SkipUnicodeString(0) + 28); } }
//        public double d { get { return GetDoubleAt(SkipUnicodeString(0) + 32); } }
//        public Guid guid { get { return GetGuidAt(SkipUnicodeString(0) + 40); } }

//        #region Private
//        internal EventWithManyTypeArgsArgs(Action<EventWithManyTypeArgsArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0) + 56));
//            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0) + 56));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventWithManyTypeArgsArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "msg", msg);
//            XmlAttrib(sb, "l", l);
//            XmlAttrib(sb, "ui", ui);
//            XmlAttrib(sb, "ui64", ui64);
//            XmlAttrib(sb, "ch", ch);
//            XmlAttrib(sb, "b", b);
//            XmlAttrib(sb, "sb", sb);
//            XmlAttrib(sb, "sh", sh);
//            XmlAttrib(sb, "ush", ush);
//            XmlAttrib(sb, "f", f);
//            XmlAttrib(sb, "d", d);
//            XmlAttrib(sb, "guid", guid);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "msg", "l", "ui", "ui64", "ch", "b", "sb", "sh", "ush", "f", "d", "guid" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return msg;
//                case 1:
//                    return l;
//                case 2:
//                    return ui;
//                case 3:
//                    return ui64;
//                case 4:
//                    return ch;
//                case 5:
//                    return b;
//                case 6:
//                    return sb;
//                case 7:
//                    return sh;
//                case 8:
//                    return ush;
//                case 9:
//                    return f;
//                case 10:
//                    return d;
//                case 11:
//                    return guid;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventWithManyTypeArgsArgs> m_target;
//        #endregion
//    }
//    public sealed class EventWithMoreEscapingMessageArgs : TraceEvent
//    {
//        public string msg { get { return GetUnicodeStringAt(0); } }
//        public int percentage { get { return GetInt32At(SkipUnicodeString(0)); } }

//        #region Private
//        internal EventWithMoreEscapingMessageArgs(Action<EventWithMoreEscapingMessageArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0) + 4));
//            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0) + 4));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventWithMoreEscapingMessageArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "msg", msg);
//            XmlAttrib(sb, "percentage", percentage);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "msg", "percentage" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return msg;
//                case 1:
//                    return percentage;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventWithMoreEscapingMessageArgs> m_target;
//        #endregion
//    }
//    public sealed class EventWithWeirdArgsArgs : TraceEvent
//    {
//        public Address iptr { get { return GetAddressAt(0); } }
//        public bool b { get { return GetInt32At(HostOffset(4, 1)) != 0; } }
//        public long le { get { return GetInt64At(HostOffset(8, 1)); } }

//        #region Private
//        internal EventWithWeirdArgsArgs(Action<EventWithWeirdArgsArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(16, 1)));
//            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(16, 1)));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventWithWeirdArgsArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttribHex(sb, "iptr", iptr);
//            XmlAttrib(sb, "b", b);
//            XmlAttrib(sb, "le", le);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "iptr", "b", "le" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return iptr;
//                case 1:
//                    return b;
//                case 2:
//                    return le;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventWithWeirdArgsArgs> m_target;
//        #endregion
//    }
//    public sealed class MessageArgs : TraceEvent
//    {
//        public string arg1 { get { return GetUnicodeStringAt(0); } }

//        #region Private
//        internal MessageArgs(Action<MessageArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
//            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<MessageArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "arg1", arg1);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "arg1" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return arg1;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<MessageArgs> m_target;
//        #endregion
//    }
//    public sealed class SlowerHelperArgs : TraceEvent
//    {
//        public int arg1 { get { return GetInt32At(0); } }
//        public string arg2 { get { return GetUnicodeStringAt(4); } }

//        #region Private
//        internal SlowerHelperArgs(Action<SlowerHelperArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(4)));
//            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(4)));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<SlowerHelperArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "arg1", arg1);
//            XmlAttrib(sb, "arg2", arg2);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "arg1", "arg2" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return arg1;
//                case 1:
//                    return arg2;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<SlowerHelperArgs> m_target;
//        #endregion
//    }
//    public sealed class EventDateTimeArgs : TraceEvent
//    {
//        public DateTime dt { get { return DateTime.FromFileTime(GetInt64At(0)); } }

//        #region Private
//        internal EventDateTimeArgs(Action<EventDateTimeArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != 8));
//            Debug.Assert(!(Version > 0 && EventDataLength < 8));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventDateTimeArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "dt", dt);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "dt" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return dt;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventDateTimeArgs> m_target;
//        #endregion
//    }
//    public sealed class LogTaskScheduledBadArgs : TraceEvent
//    {
//        public string message { get { return GetUnicodeStringAt(0); } }

//        #region Private
//        internal LogTaskScheduledBadArgs(Action<LogTaskScheduledBadArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
//            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<LogTaskScheduledBadArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "message", message);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "message" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return message;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<LogTaskScheduledBadArgs> m_target;
//        #endregion
//    }
//    public sealed class LogTaskScheduledArgs : TraceEvent
//    {
//        public string message { get { return GetUnicodeStringAt(0); } }

//        #region Private
//        internal LogTaskScheduledArgs(Action<LogTaskScheduledArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
//            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<LogTaskScheduledArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "message", message);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "message" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return message;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<LogTaskScheduledArgs> m_target;
//        #endregion
//    }
//    public sealed class EventWithXferManyTypeArgsArgs : TraceEvent
//    {
//        public long l { get { return GetInt64At(0); } }
//        public int ui { get { return GetInt32At(8); } }
//        public long ui64 { get { return GetInt64At(12); } }
//        public int ch { get { return GetInt16At(20); } }
//        public int b { get { return GetByteAt(22); } }
//        public int sb { get { return GetByteAt(23); } }
//        public int sh { get { return GetInt16At(24); } }
//        public int ush { get { return GetInt16At(26); } }
//        public float f { get { return GetSingleAt(28); } }
//        public double d { get { return GetDoubleAt(32); } }
//        public Guid guid { get { return GetGuidAt(40); } }

//        #region Private
//        internal EventWithXferManyTypeArgsArgs(Action<EventWithXferManyTypeArgsArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != 56));
//            Debug.Assert(!(Version > 0 && EventDataLength < 56));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventWithXferManyTypeArgsArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttrib(sb, "l", l);
//            XmlAttrib(sb, "ui", ui);
//            XmlAttrib(sb, "ui64", ui64);
//            XmlAttrib(sb, "ch", ch);
//            XmlAttrib(sb, "b", b);
//            XmlAttrib(sb, "sb", sb);
//            XmlAttrib(sb, "sh", sh);
//            XmlAttrib(sb, "ush", ush);
//            XmlAttrib(sb, "f", f);
//            XmlAttrib(sb, "d", d);
//            XmlAttrib(sb, "guid", guid);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "l", "ui", "ui64", "ch", "b", "sb", "sh", "ush", "f", "d", "guid" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return l;
//                case 1:
//                    return ui;
//                case 2:
//                    return ui64;
//                case 3:
//                    return ch;
//                case 4:
//                    return b;
//                case 5:
//                    return sb;
//                case 6:
//                    return sh;
//                case 7:
//                    return ush;
//                case 8:
//                    return f;
//                case 9:
//                    return d;
//                case 10:
//                    return guid;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventWithXferManyTypeArgsArgs> m_target;
//        #endregion
//    }
//    public sealed class EventWithXferWeirdArgsArgs : TraceEvent
//    {
//        public Address iptr { get { return GetAddressAt(0); } }
//        public bool b { get { return GetInt32At(HostOffset(4, 1)) != 0; } }
//        public long le { get { return GetInt64At(HostOffset(8, 1)); } }

//        #region Private
//        internal EventWithXferWeirdArgsArgs(Action<EventWithXferWeirdArgsArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
//            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
//        {
//            this.m_target = target;
//        }
//        protected override void Dispatch()
//        {
//            m_target(this);
//        }
//        protected override void Validate()
//        {
//            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(16, 1)));
//            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(16, 1)));
//        }
//        protected override Delegate Target
//        {
//            get { return m_target; }
//            set { m_target = (Action<EventWithXferWeirdArgsArgs>)value; }
//        }
//        public override StringBuilder ToXml(StringBuilder sb)
//        {
//            Prefix(sb);
//            XmlAttribHex(sb, "iptr", iptr);
//            XmlAttrib(sb, "b", b);
//            XmlAttrib(sb, "le", le);
//            sb.Append("/>");
//            return sb;
//        }

//        public override string[] PayloadNames
//        {
//            get
//            {
//                if (payloadNames == null)
//                    payloadNames = new string[] { "iptr", "b", "le" };
//                return payloadNames;
//            }
//        }

//        public override object PayloadValue(int index)
//        {
//            switch (index)
//            {
//                case 0:
//                    return iptr;
//                case 1:
//                    return b;
//                case 2:
//                    return le;
//                default:
//                    Debug.Assert(false, "Bad field index");
//                    return null;
//            }
//        }

//        private event Action<EventWithXferWeirdArgsArgs> m_target;
//        #endregion
//    }
//    public enum MyColor
//    {
//        Red = 0x0,
//        Blue = 0x1,
//        Green = 0x2,
//    }
//    [Flags]
//    public enum MyFlags
//    {
//        Flag1 = 0x1,
//        Flag2 = 0x2,
//        Flag3 = 0x4,
//    }
//}
