/* Contributed by Nicola Pero <nicola.pero@meta-innovation.com>, November 2010.  */
/* { dg-do compile } */
/* { dg-options "-Wall" } */

/* Test warnings with the dot-syntax.  */

#include <stdlib.h>
#include <objc/objc.h>
#include <objc/runtime.h>

@interface MyRootClass
{
  Class isa;
  id a;
  id b;
  int p1;
  int p2;
}
+ (id) initialize;
+ (id) alloc;
- (id) init;

@property int p1;
@property int p2;
@end

@implementation MyRootClass
+ (id) initialize { return self; }
+ (id) alloc { return class_createInstance (self, 0); }
- (id) init { return self; }
@synthesize p1;
@synthesize p2;
@end

int main (void)
{
  MyRootClass *object = [[MyRootClass alloc] init];

  /* First, test that the artificial code generated by dot-syntax does
     not generate unexpected warnings.  */

  /* All of the following should generate no warnings.  */
  object.p1 = 0;
  object.p2 = 0;
  object.p1 = object.p2 = 0;
  if (object.p1 > 0)
    object.p2 = 0;
  
  object.p1++;
  ++object.p1;
  object.p1--;
  --object.p1;
  
  while (object.p1)
    object.p1--;

  /* Now test some warnings.  */
  object.p1; /* This warning does not seem to be produced in C++.  dg-warning "value computed is not used" */

  /* TODO: It would be good to get the following to warn.  */
  if (object.p1 = 0) /* dg-warning "suggest parentheses around assignment used as truth value" */
    abort ();

  return 0;
}


