/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.picl;

import com.thaiopensource.validate.picl.AttributePathPattern;
import com.thaiopensource.validate.picl.ChoicePattern;
import com.thaiopensource.validate.picl.ElementPathPattern;
import com.thaiopensource.validate.picl.NotAllowedPattern;
import com.thaiopensource.validate.picl.PathPattern;
import com.thaiopensource.validate.picl.Pattern;
import java.util.Vector;

class PatternBuilder {
    static final byte CHILD = 0;
    static final byte ATTRIBUTE = 1;
    private boolean hadDescendantOrSelf = false;
    private final Vector choices = new Vector();
    private final Vector names = new Vector();
    private final Vector descendantsOrSelf = new Vector();
    private static final int NO_ATTRIBUTE = 0;
    private static final int LAST_WAS_ATTRIBUTE = 1;
    private static final int NON_LEAF_ATTRIBUTE = 2;
    private int attributeType = 0;

    PatternBuilder() {
    }

    void addName(byte by, String string, String string2) {
        this.descendantsOrSelf.addElement(this.hadDescendantOrSelf);
        this.hadDescendantOrSelf = false;
        this.names.addElement(string);
        this.names.addElement(string2);
        switch (this.attributeType) {
            case 1: {
                this.attributeType = 2;
                break;
            }
            case 0: {
                if (by != 1) break;
                this.attributeType = 1;
            }
        }
    }

    void addAnyName(byte by) {
        this.addName(by, "#any", "#any");
    }

    void addNsName(byte by, String string) {
        this.addName(by, string, "#any");
    }

    void addDescendantsOrSelf() {
        if (this.attributeType == 0) {
            this.hadDescendantOrSelf = true;
        }
    }

    private PathPattern wrapUpAlternative() {
        PathPattern pathPattern;
        if (this.attributeType == 2) {
            pathPattern = null;
        } else {
            String[] stringArray = new String[this.names.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)this.names.elementAt(i);
            }
            boolean[] blArray = new boolean[this.descendantsOrSelf.size() + 1];
            for (int i = 0; i < blArray.length - 1; ++i) {
                blArray[i] = (Boolean)this.descendantsOrSelf.elementAt(i);
            }
            blArray[blArray.length - 1] = this.hadDescendantOrSelf;
            pathPattern = this.attributeType == 0 ? new ElementPathPattern(stringArray, blArray) : new AttributePathPattern(stringArray, blArray);
        }
        this.cleanupAlternative();
        return pathPattern;
    }

    private void cleanupAlternative() {
        this.attributeType = 0;
        this.hadDescendantOrSelf = false;
        this.names.setSize(0);
        this.descendantsOrSelf.setSize(0);
    }

    void cleanup() {
        this.cleanupAlternative();
        this.choices.setSize(0);
    }

    void alternative() {
        PathPattern pathPattern = this.wrapUpAlternative();
        if (pathPattern != null) {
            this.choices.addElement(pathPattern);
        }
    }

    Pattern createPattern() {
        PathPattern pathPattern = this.wrapUpAlternative();
        if (this.choices.size() == 0) {
            if (pathPattern == null) {
                return new NotAllowedPattern();
            }
            return pathPattern;
        }
        if (pathPattern != null) {
            this.choices.addElement(pathPattern);
        }
        Pattern[] patternArray = new Pattern[this.choices.size()];
        for (int i = 0; i < patternArray.length; ++i) {
            patternArray[i] = (Pattern)this.choices.elementAt(i);
        }
        return new ChoicePattern(patternArray);
    }
}

