//
// Copyright 2016 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// DXTSRGBCompressedTextureTestData.inl
//   Data for sRGB DXT texture tests (DXTSRGBCompressedTextureTest.cpp)
//

static constexpr size_t kMaxCompressedSize = 64;
static constexpr size_t kMaxDecompressedSize = 256;

struct TestCase
{
    GLsizei width;
    GLsizei height;
    GLsizei dataSize;
    uint8_t data[kMaxCompressedSize];
    uint8_t expected[kMaxDecompressedSize];
};

static const std::map<GLenum, TestCase> kTests = {
    {
        GL_COMPRESSED_SRGB_S3TC_DXT1_EXT,
        {
            8, 8, 32,
            {
                0x08, 0xba, 0xe8, 0x45, 0x44, 0x45, 0x40, 0x55, 0xe8, 0xbd, 0x17, 0x42, 0x44, 0x45, 0x40, 0x55,
                0x17, 0xba, 0xe8, 0x45, 0x11, 0x10, 0x15, 0x00, 0xf7, 0x45, 0x17, 0x42, 0x11, 0x10, 0x15, 0x00,
            },
            {
                0x82, 0x0d, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff, 0x82, 0x0d, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff,
                0x82, 0x83, 0x0d, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x82, 0x83, 0x0d, 0xff, 0x0d, 0x0d, 0x82, 0xff,
                0x0d, 0x83, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff, 0x82, 0x0d, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff,
                0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x82, 0x83, 0x0d, 0xff, 0x0d, 0x0d, 0x82, 0xff,
                0x82, 0x0d, 0x0d, 0xff, 0x82, 0x0d, 0x0d, 0xff, 0x82, 0x0d, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff,
                0x82, 0x83, 0x0d, 0xff, 0x82, 0x83, 0x0d, 0xff, 0x82, 0x83, 0x0d, 0xff, 0x0d, 0x0d, 0x82, 0xff,
                0x0d, 0x83, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff,
                0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff,
                0x0d, 0x83, 0x0d, 0xff, 0x82, 0x0d, 0x82, 0xff, 0x0d, 0x83, 0x0d, 0xff, 0x82, 0x0d, 0x82, 0xff,
                0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff,
                0x82, 0x0d, 0x82, 0xff, 0x82, 0x0d, 0x82, 0xff, 0x0d, 0x83, 0x0d, 0xff, 0x82, 0x0d, 0x82, 0xff,
                0x0d, 0x83, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff,
                0x0d, 0x83, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff, 0x82, 0x0d, 0x82, 0xff,
                0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff,
                0x82, 0x0d, 0x82, 0xff, 0x82, 0x0d, 0x82, 0xff, 0x82, 0x0d, 0x82, 0xff, 0x82, 0x0d, 0x82, 0xff,
                0x0d, 0x83, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff, 
            }
        }
    },
    {
        GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT,
        {
            8, 8, 32,
            {
                0xa8, 0x4d, 0x48, 0xb2, 0x13, 0x10, 0x15, 0x00, 0xe8, 0xbd, 0x17, 0x42, 0x44, 0x45, 0x40, 0x55,
                0x17, 0xba, 0xe8, 0x45, 0x11, 0x10, 0x15, 0x00, 0xf7, 0x45, 0x17, 0x42, 0x11, 0x10, 0x15, 0x00,
            },
            {
                0x00, 0x00, 0x00, 0x00, 0x11, 0x77, 0x0d, 0xff, 0x74, 0x11, 0x0d, 0xff, 0x11, 0x77, 0x0d, 0xff,
                0x82, 0x83, 0x0d, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x82, 0x83, 0x0d, 0xff, 0x0d, 0x0d, 0x82, 0xff,
                0x11, 0x77, 0x0d, 0xff, 0x11, 0x77, 0x0d, 0xff, 0x74, 0x11, 0x0d, 0xff, 0x11, 0x77, 0x0d, 0xff,
                0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x82, 0x83, 0x0d, 0xff, 0x0d, 0x0d, 0x82, 0xff,
                0x74, 0x11, 0x0d, 0xff, 0x74, 0x11, 0x0d, 0xff, 0x74, 0x11, 0x0d, 0xff, 0x11, 0x77, 0x0d, 0xff,
                0x82, 0x83, 0x0d, 0xff, 0x82, 0x83, 0x0d, 0xff, 0x82, 0x83, 0x0d, 0xff, 0x0d, 0x0d, 0x82, 0xff,
                0x11, 0x77, 0x0d, 0xff, 0x11, 0x77, 0x0d, 0xff, 0x11, 0x77, 0x0d, 0xff, 0x11, 0x77, 0x0d, 0xff,
                0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff,
                0x0d, 0x83, 0x0d, 0xff, 0x82, 0x0d, 0x82, 0xff, 0x0d, 0x83, 0x0d, 0xff, 0x82, 0x0d, 0x82, 0xff,
                0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff,
                0x82, 0x0d, 0x82, 0xff, 0x82, 0x0d, 0x82, 0xff, 0x0d, 0x83, 0x0d, 0xff, 0x82, 0x0d, 0x82, 0xff,
                0x0d, 0x83, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff,
                0x0d, 0x83, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff, 0x82, 0x0d, 0x82, 0xff,
                0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff,
                0x82, 0x0d, 0x82, 0xff, 0x82, 0x0d, 0x82, 0xff, 0x82, 0x0d, 0x82, 0xff, 0x82, 0x0d, 0x82, 0xff,
                0x0d, 0x83, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff,
            }
        }
    },
    {
        GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT,
        {
            8, 8, 64,
            {
                0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x08, 0xba, 0xe8, 0x45, 0x44, 0x45, 0x40, 0x55,
                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0xbd, 0x17, 0x42, 0x44, 0x45, 0x40, 0x55,
                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x17, 0xba, 0xe8, 0x45, 0x11, 0x10, 0x15, 0x00,
                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x45, 0x17, 0x42, 0x11, 0x10, 0x15, 0x00,
            },
            {
                0x82, 0x0d, 0x0d, 0x77, 0x0d, 0x83, 0x0d, 0xff, 0x82, 0x0d, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff,
                0x82, 0x83, 0x0d, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x82, 0x83, 0x0d, 0xff, 0x0d, 0x0d, 0x82, 0xff,
                0x0d, 0x83, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff, 0x82, 0x0d, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff,
                0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x82, 0x83, 0x0d, 0xff, 0x0d, 0x0d, 0x82, 0xff,
                0x82, 0x0d, 0x0d, 0xff, 0x82, 0x0d, 0x0d, 0xff, 0x82, 0x0d, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff,
                0x82, 0x83, 0x0d, 0xff, 0x82, 0x83, 0x0d, 0xff, 0x82, 0x83, 0x0d, 0xff, 0x0d, 0x0d, 0x82, 0xff,
                0x0d, 0x83, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff,
                0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff,
                0x0d, 0x83, 0x0d, 0xff, 0x82, 0x0d, 0x82, 0xff, 0x0d, 0x83, 0x0d, 0xff, 0x82, 0x0d, 0x82, 0xff,
                0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff,
                0x82, 0x0d, 0x82, 0xff, 0x82, 0x0d, 0x82, 0xff, 0x0d, 0x83, 0x0d, 0xff, 0x82, 0x0d, 0x82, 0xff,
                0x0d, 0x83, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff,
                0x0d, 0x83, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff, 0x82, 0x0d, 0x82, 0xff,
                0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff,
                0x82, 0x0d, 0x82, 0xff, 0x82, 0x0d, 0x82, 0xff, 0x82, 0x0d, 0x82, 0xff, 0x82, 0x0d, 0x82, 0xff,
                0x0d, 0x83, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff, 
            }
        }
    },
    {
        GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT,
        {
            8, 8, 64,
            {
                0xff, 0x7f, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xba, 0xe8, 0x45, 0x44, 0x45, 0x40, 0x55,
                0xff, 0xff, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0xe8, 0xbd, 0x17, 0x42, 0x44, 0x45, 0x40, 0x55,
                0xff, 0xff, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x17, 0xba, 0xe8, 0x45, 0x11, 0x10, 0x15, 0x00,
                0xff, 0xff, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0xf7, 0x45, 0x17, 0x42, 0x11, 0x10, 0x15, 0x00,
            },
            {
                0x82, 0x0d, 0x0d, 0x7f, 0x0d, 0x83, 0x0d, 0xff, 0x82, 0x0d, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff,
                0x82, 0x83, 0x0d, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x82, 0x83, 0x0d, 0xff, 0x0d, 0x0d, 0x82, 0xff,
                0x0d, 0x83, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff, 0x82, 0x0d, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff,
                0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x82, 0x83, 0x0d, 0xff, 0x0d, 0x0d, 0x82, 0xff,
                0x82, 0x0d, 0x0d, 0xff, 0x82, 0x0d, 0x0d, 0xff, 0x82, 0x0d, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff,
                0x82, 0x83, 0x0d, 0xff, 0x82, 0x83, 0x0d, 0xff, 0x82, 0x83, 0x0d, 0xff, 0x0d, 0x0d, 0x82, 0xff,
                0x0d, 0x83, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff,
                0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff,
                0x0d, 0x83, 0x0d, 0xff, 0x82, 0x0d, 0x82, 0xff, 0x0d, 0x83, 0x0d, 0xff, 0x82, 0x0d, 0x82, 0xff,
                0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff,
                0x82, 0x0d, 0x82, 0xff, 0x82, 0x0d, 0x82, 0xff, 0x0d, 0x83, 0x0d, 0xff, 0x82, 0x0d, 0x82, 0xff,
                0x0d, 0x83, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff,
                0x0d, 0x83, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff, 0x0d, 0x83, 0x0d, 0xff, 0x82, 0x0d, 0x82, 0xff,
                0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x0d, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff,
                0x82, 0x0d, 0x82, 0xff, 0x82, 0x0d, 0x82, 0xff, 0x82, 0x0d, 0x82, 0xff, 0x82, 0x0d, 0x82, 0xff,
                0x0d, 0x83, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff, 0x0d, 0x83, 0x82, 0xff,
            }
        }
    },
};
