/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_ADDI.C $
   $Locker: ska $	$Name:  $	$State: Exp $

ob(ject): cfgAddOpt
su(bsystem): cmdline
ty(pe): H
sy(nopsis): 
sh(ort description): Add an option
he(ader files): 
lo(ng description): Adds an option behind the last entry of the
	output stack. If the current output stack does not contain a 
	write function, the option is ignored (== lost).\par
	In fact, all this function does is to create a string prepending
	a slash to the passed in string and add the result with the
	write function, as if it would be a normal argument.
pr(erequistes): 
va(lue): none
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_addi.c
in(itialized by): 
wa(rning): 
bu(gs): 

ob(ject): cfgInsOpt
su(bsystem): cmdline
ty(pe): H
sy(nopsis): 
sh(ort description): Insert an option
he(ader files): 
lo(ng description): Inserts an option before the last entry of the
	output stack. If the current output stack does not contain a 
	write function, the option is ignored (== lost).
	In fact, all this function does is to create a string prepending
	a slash to the passed in string and add the result with the
	write function, as if it would be a normal argument.
pr(erequistes): 
va(lue): none
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_addi.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <string.h>
#endif
#include <portable.h>
#include "dynstr.h"
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_ADDI.C 1.5 1999/12/13 02:21:56 ska Exp ska $";
#endif

static void adder(int mode, struct Cfg_Getopt * const optstru
 , const char * const s)
{	char *buf;

	assert(optstru);
	assert(s);

	chkHeap;

	if(C(_oHead) && curOStk->C_wrArg) {
		buf = Emalloc(strlen(s) + 2); chkHeap;
		buf[0] = optSign;
		strcpy(&buf[1], s); chkHeap;
		(curOStk->C_wrArg)(mode, optstru, curOStk, buf, strlen(buf) + 1);
		free(buf); chkHeap;
	}
}

void cfgAddOpt(struct Cfg_Getopt * const optstru, const char * const s)
{	DBG_ENTER("cfgAddOpt", Suppl_cmdline)
	adder(0, optstru, s);
	DBG_EXIT
}

void cfgInsOpt(struct Cfg_Getopt * const optstru, const char * const s)
{	DBG_ENTER("cfgAddOpt", Suppl_cmdline)
	adder(1, optstru, s);
	DBG_EXIT
}
