/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: FFSEEK.C $
   $Locker: ska $	$Name:  $	$State: Exp $

ob(ject): Fseek
su(bsystem): supplio
ty(pe): 
sh(ort description): Seek to a \tok{(dword)} position of a stream
pr(erequistes): fp != NULL
va(lue): 0: on success\item else: on failure
re(lated to): 
se(condary subsystems): 
in(itialized by): 
wa(rning): 
bu(gs): 
co(mpilers): Micro-C only

*/

#include "initsupl.loc"

#ifdef _MICROC_
#include <stdio.h>
#include <portable.h>
#include "supplio.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: FFSEEK.C 1.4 1999/12/13 02:23:10 ska Exp ska $";
#endif

int Fseek(FILE *fp, dword *pos, int whence)
{	DBG_ENTER("Fseek", Suppl_supplio)
	assert(fp);
	assert(pos);
	DBG_RETURN_BI( fseek(fp, pos->hi, pos->lo, whence))
}

#endif
