/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.castor;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.TypeCreator;
import org.codehaus.xfire.aegis.type.TypeMapping;
import org.codehaus.xfire.castor.CastorType;
import org.codehaus.xfire.util.ClassLoaderUtils;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.util.XMLClassDescriptorImpl;

public class CastorTypeCreator
implements TypeCreator {
    private static final Log log = LogFactory.getLog((Class)CastorTypeCreator.class);
    private TypeCreator nextCreator;
    private Mapping mapping = null;
    private TypeMapping typeMapping;

    public CastorTypeCreator(TypeCreator typeCreator, String mappingFile) {
        this.nextCreator = typeCreator;
        try {
            if (mappingFile != null && mappingFile.length() > 0) {
                this.mapping = new Mapping();
                this.mapping.loadMapping(ClassLoaderUtils.getResource(mappingFile, CastorTypeCreator.class));
            }
        }
        catch (IOException e) {
            String error = "Error accessing mapping file '" + mappingFile + "'.";
            log.error((Object)error, (Throwable)e);
            throw new XFireRuntimeException(error, e);
        }
        catch (MappingException e) {
            String error = "Error processing mapping file '" + mappingFile + "'.";
            log.error((Object)error, (Throwable)e);
            throw new XFireRuntimeException(error, e);
        }
    }

    public QName getElementName(Method m, int index) {
        return this.nextCreator.getElementName(m, index);
    }

    public Type createType(Method method, int index) {
        Class<?> clazz = null;
        clazz = index > -1 ? method.getParameterTypes()[index] : method.getReturnType();
        if (this.isCastorType(clazz)) {
            return this.createCastorType(clazz);
        }
        return this.nextCreator.createType(clazz);
    }

    public Type createType(PropertyDescriptor propDesc) {
        if (this.isCastorType(propDesc.getPropertyType())) {
            return this.createCastorType(propDesc.getPropertyType());
        }
        return this.nextCreator.createType(propDesc.getPropertyType());
    }

    public Type createType(Field field) {
        if (this.isCastorType(field.getType())) {
            return this.createCastorType(field.getType());
        }
        return this.nextCreator.createType(field.getType());
    }

    public Type createType(Class clazz) {
        if (this.isCastorType(clazz)) {
            return this.createCastorType(clazz);
        }
        return this.nextCreator.createType(clazz);
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.typeMapping = typeMapping;
        this.nextCreator.setTypeMapping(typeMapping);
    }

    private boolean isCastorType(Class clazz) {
        Class xdClass = null;
        boolean isCastor = false;
        if (this.mapping != null) {
            try {
                XMLClassDescriptorImpl xd = (XMLClassDescriptorImpl)this.mapping.getResolver(Mapping.XML).getDescriptor(clazz);
                if (xd != null) {
                    isCastor = true;
                }
            }
            catch (MappingException e) {
                String error = "Error getting resolver from mapping";
                log.error((Object)error, (Throwable)e);
                throw new XFireRuntimeException(error, e);
            }
        }
        try {
            xdClass = ClassLoaderUtils.loadClass(clazz.getName() + "Descriptor", this.getClass());
            if (xdClass != null && XMLClassDescriptorImpl.class.isAssignableFrom(xdClass)) {
                isCastor = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return isCastor;
    }

    private CastorType createCastorType(Class clazz) {
        CastorType type = new CastorType(clazz, this.mapping);
        return type;
    }

    public TypeCreator getParent() {
        return null;
    }

    public void setParent(TypeCreator creator) {
    }
}

