#!/bin/sh
# Easy to use Athlon addition as described in the original readme_g.txt.
# Now Athlon users should only run this script to get a ready to run
# 3D-NOW/MMX/Athlon-enhanced gogo.
#
# Send comments to: Thomas Juerges <thomas.a.juerges@ruhr-uni-bochum.de>
#
echo -e "\nBuilding 3D-Now!/MMX/Athlon extensions compiler...\n\n"
if [ ! -x mmx/mmx_builder ]; then
	cd mmx
	gcc -DONLY_E3DN -DNO_KANJI -o mmx_builder *.c
	cd ..
fi
echo -e "Build of compiler complete.\n\nBuilding .asm-files...\n\n"
for i in *.nas; do
		mmx/mmx_builder $i
		tmp=`echo $i | sed -e 's/\.nas/\.asm/'`
		if [ ! -f $i.bak ]; then
			mv -f $i $i.bak
		fi
		mv -f $tmp $i
		done
echo -e "\n\nO.K.\nExtensions are now built.\nYou can find the old style assembler files moved to *.nas.bak"
echo -e "i\nNow we go on with a simple make:\n"
make
echo -e "\n\nO.K. Everything seems to be ready for take off now.\n"
echo -e "Please check the output of each process we ran through.\n"
echo -e "If everything seems to be fine, well, have fun!\n\n"
exit
