/*
 *	v񂠂肪Ƃ(99/10/26)
 */

#include "mydef.h"
#include "parser.h"
#include "errmes.h"

/* ]ɎgX^bN */
#define STACK_DEPTH (40)
int32 stack[STACK_DEPTH];
int   sp=0;

/* ]
 * input
 *   src ]鐔ւ̃|C^
 * output
 *   num ]ʂϐւ̃|C^
 * return  
 *   ]̎̕ւ̃|C^ 
 *   G[ NULL ԂAnum ̒g͕s
 */
static char* expression(int32 *num,char* src);

/* ]
 * 3*4 ݂ '*' ܂ '/' ŌqꂽA̐܂͎] 
 * ]ʂ stack ɐς
 * input
 *   src ]鍀ւ̃|C^
 * return  
 *   ]̎̕ւ̃|C^ 
 *   G[ NULL Ԃ
 */
static char* term(char* src);

/* vf(?włȂĂ܂H^^;;)]
 * \vf](ꂵ{ꂶ^^;;)
 * ]ʂ stack ɐς
 * input
 *   src ]vfւ̃|C^
 * return  
 *   ]vf̎̕ւ̃|C^ 
 *   G[ NULL Ԃ
 */
static char* factor(char* src);

/* X^bNɐςł鐔vZ
 * stack 琔oČvZ
 * ]ʂ stack ɐς
 * input
 *   ope vZ@w肷鉉Zq '+','-','*','/' ̂ꂩ
 * return  
 *   ɌvZł NOERR
 *   G[ ERR Ԃ
 */
static int calc(char ope);

/* X^bNɐς
 * input
 *   num ςސ
 * return  
 *   ɐς߂ NOERR
 *   G[ ERR Ԃ
 */
static int push(int32 num);

/* X^bN牵
 * input
 *   num ϐւ̃|C^
 * return  
 *   ɉ NOERR
 *   G[ ERR Ԃ
 */
static int pull(int32 *num);

int push(int32 num){
  if(sp >= STACK_DEPTH)return ERR;
  stack[sp++]=num;
  return NOERR;
}

int pull(int32 *num){
  if(sp <= 0)return ERR;
  *num=stack[--sp];
  return NOERR;
}


char* expression(int32 *num,char* src) {
  char ope;
  src=term(src);
  if(!src)return NULL;
  while(*src){
    if (*src=='+' || *src=='-'){
        ope=*src;
        src++;
        src=term(src);
        if(!src)return NULL;
        if(calc(ope)!=NOERR)return NULL;
    }
    else break;
  }
  if(pull(num)!=NOERR)return NULL;
  return src;
}

char* term(char* src){
  char ope;
  src=factor(src);
  if(!src)return NULL;
  while(*src){
    if (*src=='*' || *src=='/'){
        ope=*src;
        src++;
        src=factor(src);
        if(!src)return NULL;
        if(calc(ope)!=NOERR)return NULL;
    }
    else break;
  }
  return src;
}

char* factor(char* src){
  int32 a=0;
  int sign=1;
  switch(*src){
  case '+':
    src++;
    break;
  case '-':
    sign=-1;
    src++;
    break;
  }
  switch(*src){
  case '(':
    src++;
    src=expression(&a,src);
    if(!src)return NULL;
    if(*src!=')')return NULL;
    src++;
    break;
  default:
    if(*src<'0' || *src>'9')return NULL;
    do{
      if(*src<'0' || *src>'9')break;
      a=a*10;
      a+=*src-'0';
      src++;
    }while(*src);
  }
  if(push(a*sign)!=NOERR)return NULL;
  return src;
}

int calc(char ope){
  int32 para1,para2;
  if(pull(&para2)!=NOERR||pull(&para1)!=NOERR)return ERR;
  switch(ope){
  case '+':
    return push(para1+para2);
  case '-':
    return push(para1-para2);
  case '*':
    return push(para1*para2);
  case '/':
    return push(para1/para2);
  default:
    return ERR;
  }
}

/* Xy[X܂̓^u폜 src󂳂Ȃ */
static char *deleteSpace(char *src){
	static char buf[strLenMax];
	char *dist = buf;
	if( !src )return NULL;
	do{
		while( *src ==' ' || *src == '\t' )src++;
	}while( ( *dist++ = *src++ ) );
	return buf;
}

/*
 *  lԂ(͂Ȃatoi())
 *  ŏIIɂ͓dxɂ܂ł
 */
int getNumber(int32 *num,char *src){
  TOKEN tok;
#if 1 	/* Xy[XĂƉ͂Ɏŝ by shigeo 99/12/21 */
	src = deleteSpace( src );
#endif
  src=expression(num,src);
  if(!src)return ERR; 
  src=nextToken(&tok,src);
  if(tok.type!=TOKEN_NONE)return ERR; /* ]s\ȕ񂪎cĂ */
  if(sp)return ERR; /* X^bNĂȂ */
  return NOERR;
#if 0
  char *p;
  int32 a=0;
  int sign=0;
  src=nextToken(&tok,src);
  if(tok.type==TOKEN_NONE)return ERR;
  if(tok.type==TOKEN_ADD){
    src=nextToken(&tok,src);
    sign=0;
  }else if(tok.type==TOKEN_SUB){
    src=nextToken(&tok,src);
    sign=1;
  }
  if(tok.type!=TOKEN_STR)return ERR;
  p=tok.str;
  do{
    a=a*10;
    if(*p<'0' || *p>'9')return ERR;
    a+=*p-'0';
    p++;
  }while(*p);
  if(sign){
    *num=-a;
  }else{
    *num=a;
  }
  src=nextToken(&tok,src);
  if(tok.type!=TOKEN_NONE)return ERR;/* ݌vZs */
  return NOERR;
#endif
}
