/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina;

import java.util.List;
import net.sf.picard.filter.SamRecordFilter;
import net.sf.picard.filter.SolexaNoiseFilter;
import net.sf.picard.illumina.IlluminaBasecallsConverter;
import net.sf.picard.illumina.IlluminaBasecallsToSam;
import net.sf.picard.illumina.parser.ClusterData;
import net.sf.picard.illumina.parser.ReadData;
import net.sf.picard.illumina.parser.ReadStructure;
import net.sf.picard.util.AdapterPair;
import net.sf.picard.util.ClippingUtility;
import net.sf.picard.util.IlluminaUtil;
import net.sf.samtools.SAMRecord;

public class ClusterDataToSamConverter
implements IlluminaBasecallsConverter.ClusterDataConverter<IlluminaBasecallsToSam.SAMRecordsForCluster> {
    private final String runBarcode;
    private final String readGroupId;
    private final SamRecordFilter filters = new SolexaNoiseFilter();
    private final boolean isPairedEnd;
    private final boolean isBarcoded;
    private final int[] templateIndices;
    private final int[] barcodeIndices;
    private final AdapterPair[] adaptersToCheck;
    private final int outputRecordsPerCluster;

    public ClusterDataToSamConverter(String runBarcode, String readGroupId, ReadStructure readStructure, List<IlluminaUtil.IlluminaAdapterPair> adapters) {
        this.runBarcode = runBarcode;
        this.readGroupId = readGroupId;
        this.isPairedEnd = readStructure.templates.length() == 2;
        this.isBarcoded = !readStructure.barcodes.isEmpty();
        this.adaptersToCheck = new AdapterPair[adapters.size()];
        for (int i = 0; i < adapters.size(); ++i) {
            this.adaptersToCheck[i] = adapters.get(i);
        }
        this.templateIndices = readStructure.templates.getIndices();
        this.barcodeIndices = readStructure.barcodes.getIndices();
        this.outputRecordsPerCluster = readStructure.templates.length();
    }

    private SAMRecord createSamRecord(ReadData readData, String readName, boolean isPf, boolean firstOfPair, String unmatchedBarcode) {
        SAMRecord sam = new SAMRecord(null);
        sam.setReadName(readName);
        sam.setReadBases(readData.getBases());
        sam.setBaseQualities(readData.getQualities());
        sam.setReadPairedFlag(this.isPairedEnd);
        sam.setReadUnmappedFlag(true);
        sam.setReadFailsVendorQualityCheckFlag(!isPf);
        if (this.isPairedEnd) {
            sam.setMateUnmappedFlag(true);
            sam.setFirstOfPairFlag(firstOfPair);
            sam.setSecondOfPairFlag(!firstOfPair);
        }
        if (this.filters.filterOut(sam)) {
            sam.setAttribute("XN", (Object)1);
        }
        if (this.readGroupId != null) {
            sam.setAttribute("RG", (Object)this.readGroupId);
        }
        if (unmatchedBarcode != null) {
            sam.setAttribute("BC", (Object)unmatchedBarcode);
        }
        return sam;
    }

    @Override
    public IlluminaBasecallsToSam.SAMRecordsForCluster convertClusterToOutputRecord(ClusterData cluster) {
        SAMRecord firstOfPair;
        IlluminaBasecallsToSam.SAMRecordsForCluster ret = new IlluminaBasecallsToSam.SAMRecordsForCluster(this.outputRecordsPerCluster);
        String readName = IlluminaUtil.makeReadName(this.runBarcode, cluster.getLane(), cluster.getTile(), cluster.getX(), cluster.getY());
        String unmatchedBarcode = null;
        if (this.isBarcoded && cluster.getMatchedBarcode() == null) {
            byte[][] barcode = new byte[this.barcodeIndices.length][];
            for (int i = 0; i < this.barcodeIndices.length; ++i) {
                barcode[i] = cluster.getRead(this.barcodeIndices[i]).getBases();
            }
            unmatchedBarcode = IlluminaUtil.barcodeSeqsToString(barcode).replace('.', 'N');
        }
        ret.records[0] = firstOfPair = this.createSamRecord(cluster.getRead(this.templateIndices[0]), readName, cluster.isPf(), true, unmatchedBarcode);
        SAMRecord secondOfPair = null;
        if (this.isPairedEnd) {
            ret.records[1] = secondOfPair = this.createSamRecord(cluster.getRead(this.templateIndices[1]), readName, cluster.isPf(), false, unmatchedBarcode);
        }
        if (this.adaptersToCheck.length > 0) {
            if (this.isPairedEnd) {
                ClippingUtility.adapterTrimIlluminaPairedReads(firstOfPair, secondOfPair, this.adaptersToCheck);
            } else {
                ClippingUtility.adapterTrimIlluminaSingleRead(firstOfPair, this.adaptersToCheck);
            }
        }
        return ret;
    }
}

