/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble;

import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.seekablestream.SeekableStreamFactory;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.Tribble;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.index.Block;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.IndexFactory;
import htsjdk.tribble.readers.PositionalBufferedStream;
import htsjdk.tribble.util.ParsingUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;

public class TribbleIndexedFeatureReader<T extends Feature, SOURCE>
extends AbstractFeatureReader<T, SOURCE> {
    private Index index;
    private final boolean pathIsRegularFile;
    private SeekableStream seekableStream = null;
    private boolean needCheckForIndex = true;

    public TribbleIndexedFeatureReader(String featurePath, FeatureCodec<T, SOURCE> codec, boolean requireIndex) throws IOException {
        super(featurePath, codec);
        if (requireIndex) {
            this.loadIndex();
            if (!this.hasIndex()) {
                throw new TribbleException("An index is required, but none found.");
            }
        }
        this.pathIsRegularFile = SeekableStreamFactory.isFilePath(this.path);
        this.readHeader();
    }

    public TribbleIndexedFeatureReader(String featureFile, String indexFile, FeatureCodec<T, SOURCE> codec, boolean requireIndex) throws IOException {
        this(featureFile, codec, false);
        if (indexFile != null && ParsingUtils.resourceExists(indexFile)) {
            this.index = IndexFactory.loadIndex(indexFile);
            this.needCheckForIndex = false;
        } else if (requireIndex) {
            if (!this.hasIndex()) {
                throw new TribbleException("An index is required, but none found.");
            }
        }
    }

    public TribbleIndexedFeatureReader(String featureFile, FeatureCodec<T, SOURCE> codec, Index index) throws IOException {
        this(featureFile, codec, false);
        this.index = index;
        this.needCheckForIndex = false;
    }

    private void loadIndex() throws IOException {
        String indexFile = Tribble.indexFile(this.path);
        if (ParsingUtils.resourceExists(indexFile)) {
            this.index = IndexFactory.loadIndex(indexFile);
        } else if (ParsingUtils.resourceExists(indexFile = ParsingUtils.appendToPath(indexFile, ".gz"))) {
            this.index = IndexFactory.loadIndex(indexFile);
        }
        this.needCheckForIndex = false;
    }

    private SeekableStream getSeekableStream() throws IOException {
        SeekableStream result;
        if (this.reuseStreamInQuery()) {
            if (this.seekableStream == null) {
                this.seekableStream = SeekableStreamFactory.getInstance().getStreamFor(this.path);
            }
            result = this.seekableStream;
        } else {
            result = SeekableStreamFactory.getInstance().getStreamFor(this.path);
        }
        return result;
    }

    private boolean reuseStreamInQuery() {
        return this.pathIsRegularFile;
    }

    @Override
    public void close() throws IOException {
        if (this.seekableStream != null) {
            this.seekableStream.close();
        }
    }

    @Override
    public List<String> getSequenceNames() {
        return !this.hasIndex() ? new ArrayList<String>() : new ArrayList<String>(this.index.getSequenceNames());
    }

    @Override
    public boolean hasIndex() {
        if (this.index == null && this.needCheckForIndex) {
            try {
                this.loadIndex();
            }
            catch (IOException e) {
                throw new TribbleException("Error loading index file: " + e.getMessage(), e);
            }
        }
        return this.index != null;
    }

    private void readHeader() throws IOException {
        InputStream is = null;
        PositionalBufferedStream pbs = null;
        try {
            is = ParsingUtils.openInputStream(this.path);
            if (ParsingUtils.pathHasExtension(this.path, ".gz")) {
                is = new GZIPInputStream(new BufferedInputStream(is));
            }
            pbs = new PositionalBufferedStream(is);
            Object source = this.codec.makeSourceFromStream(pbs);
            this.header = this.codec.readHeader(source);
        }
        catch (Exception e) {
            throw new TribbleException.MalformedFeatureFile("Unable to parse header with error: " + e.getMessage(), this.path, e);
        }
        finally {
            if (pbs != null) {
                pbs.close();
            } else if (is != null) {
                is.close();
            }
        }
    }

    @Override
    public CloseableTribbleIterator<T> query(String chr, int start, int end) throws IOException {
        if (!this.hasIndex()) {
            throw new TribbleException("Index not found for: " + this.path);
        }
        if (this.index.containsChromosome(chr)) {
            List<Block> blocks = this.index.getBlocks(chr, start - 1, end);
            return new QueryIterator(chr, start, end, blocks);
        }
        return new AbstractFeatureReader.EmptyIterator();
    }

    @Override
    public CloseableTribbleIterator<T> iterator() throws IOException {
        return new WFIterator();
    }

    static class BlockStreamWrapper
    extends InputStream {
        SeekableStream seekableStream;
        long maxPosition;

        BlockStreamWrapper(SeekableStream seekableStream, Block block) throws IOException {
            this.seekableStream = seekableStream;
            seekableStream.seek(block.getStartPosition());
            this.maxPosition = block.getEndPosition();
        }

        @Override
        public int read() throws IOException {
            return this.seekableStream.position() > this.maxPosition ? -1 : this.seekableStream.read();
        }

        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            long maxBytes = this.maxPosition - this.seekableStream.position();
            if (maxBytes <= 0L) {
                return -1;
            }
            int bytesToRead = (int)Math.min((long)len, Math.min(maxBytes, Integer.MAX_VALUE));
            return this.seekableStream.read(bytes, off, bytesToRead);
        }
    }

    class QueryIterator
    implements CloseableTribbleIterator<T> {
        private String chrAlias;
        int start;
        int end;
        private T currentRecord;
        private SOURCE source;
        private SeekableStream mySeekableStream;
        private Iterator<Block> blockIterator;

        public QueryIterator(String chr, int start, int end, List<Block> blocks) throws IOException {
            this.start = start;
            this.end = end;
            this.mySeekableStream = TribbleIndexedFeatureReader.this.getSeekableStream();
            this.blockIterator = blocks.iterator();
            this.advanceBlock();
            this.readNextRecord();
            this.chrAlias = this.currentRecord == null ? chr : this.currentRecord.getContig();
        }

        @Override
        public boolean hasNext() {
            return this.currentRecord != null;
        }

        @Override
        public T next() {
            Object ret = this.currentRecord;
            try {
                this.readNextRecord();
            }
            catch (IOException e) {
                throw new RuntimeIOException("Unable to read the next record, the last record was at " + ret.getContig() + ":" + ret.getStart() + "-" + ret.getEnd(), e);
            }
            return ret;
        }

        private void advanceBlock() throws IOException {
            while (this.blockIterator != null && this.blockIterator.hasNext()) {
                Block block = this.blockIterator.next();
                if (block.getSize() <= 0L) continue;
                int bufferSize = Math.min(2000000, block.getSize() > 100000000L ? 10000000 : (int)block.getSize());
                this.source = TribbleIndexedFeatureReader.this.codec.makeSourceFromStream(new PositionalBufferedStream(new BlockStreamWrapper(this.mySeekableStream, block), bufferSize));
                return;
            }
            if (this.source != null) {
                TribbleIndexedFeatureReader.this.codec.close(this.source);
                this.source = null;
            }
        }

        private void readNextRecord() throws IOException {
            if (this.source == null) {
                return;
            }
            this.currentRecord = null;
            while (true) {
                if (!TribbleIndexedFeatureReader.this.codec.isDone(this.source)) {
                    try {
                        Object f = TribbleIndexedFeatureReader.this.codec.decode(this.source);
                        if (f == null) continue;
                        if (this.chrAlias != null && !f.getContig().equals(this.chrAlias) || f.getStart() > this.end) {
                            if (this.blockIterator.hasNext()) {
                                this.advanceBlock();
                                continue;
                            }
                            return;
                        }
                        if (f.getEnd() < this.start) continue;
                        this.currentRecord = f;
                        return;
                    }
                    catch (TribbleException e) {
                        e.setSource(TribbleIndexedFeatureReader.this.path);
                        throw e;
                    }
                    catch (NumberFormatException e) {
                        String error = "Error parsing line: " + this.source;
                        throw new TribbleException.MalformedFeatureFile(error, TribbleIndexedFeatureReader.this.path, e);
                    }
                }
                if (this.blockIterator == null || !this.blockIterator.hasNext()) break;
                this.advanceBlock();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported.");
        }

        @Override
        public void close() {
            TribbleIndexedFeatureReader.this.codec.close(this.source);
            if (!TribbleIndexedFeatureReader.this.reuseStreamInQuery()) {
                try {
                    this.mySeekableStream.close();
                }
                catch (IOException e) {
                    throw new TribbleException("Couldn't close seekable stream", e);
                }
            }
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }

    class WFIterator
    implements CloseableTribbleIterator<T> {
        private T currentRecord;
        private SOURCE source;

        public WFIterator() throws IOException {
            PositionalBufferedStream pbs;
            InputStream inputStream = ParsingUtils.openInputStream(TribbleIndexedFeatureReader.this.path);
            if (ParsingUtils.pathHasExtension(TribbleIndexedFeatureReader.this.path, ".gz")) {
                GZIPInputStream is = new GZIPInputStream(new BufferedInputStream(inputStream, 512000));
                pbs = new PositionalBufferedStream(is, 1000);
            } else {
                pbs = new PositionalBufferedStream(inputStream, 512000);
            }
            pbs.skip(TribbleIndexedFeatureReader.this.header.getHeaderEnd());
            this.source = TribbleIndexedFeatureReader.this.codec.makeSourceFromStream(pbs);
            this.readNextRecord();
        }

        @Override
        public boolean hasNext() {
            return this.currentRecord != null;
        }

        @Override
        public T next() {
            Object ret = this.currentRecord;
            try {
                this.readNextRecord();
            }
            catch (IOException e) {
                throw new RuntimeIOException("Unable to read the next record, the last record was at " + ret.getContig() + ":" + ret.getStart() + "-" + ret.getEnd(), e);
            }
            return ret;
        }

        private void readNextRecord() throws IOException {
            this.currentRecord = null;
            while (!TribbleIndexedFeatureReader.this.codec.isDone(this.source)) {
                try {
                    Object f = TribbleIndexedFeatureReader.this.codec.decode(this.source);
                    if (f == null) continue;
                    this.currentRecord = f;
                    return;
                }
                catch (TribbleException e) {
                    e.setSource(TribbleIndexedFeatureReader.this.path);
                    throw e;
                }
                catch (NumberFormatException e) {
                    String error = "Error parsing line at byte position: " + this.source;
                    throw new TribbleException.MalformedFeatureFile(error, TribbleIndexedFeatureReader.this.path, e);
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported in Iterators");
        }

        @Override
        public void close() {
            TribbleIndexedFeatureReader.this.codec.close(this.source);
        }

        public WFIterator iterator() {
            return this;
        }
    }
}

